/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.ui.graphwizard.GraphWizard;
import com.sas.graphics.silk.util.SILKChartFlavor;
import com.sas.graphics.tools.wizard.ChartCategory;
import com.sas.graphics.tools.wizard.WizardEntry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ComponentPalette
extends JList
implements DragGestureListener {
    private static final long serialVersionUID = 5969781351038258747L;
    GraphWizard wizard = null;
    Object dataSource = null;
    DragSource dragSource = DragSource.getDefaultDragSource();

    @Override
    public void addNotify() {
        super.addNotify();
        Frame parent = UIUtilities.getParentFrame((Component)this);
        JFrame f = null;
        if (parent instanceof JFrame) {
            f = (JFrame)parent;
        }
        this.wizard = new GraphWizard(f, this.getCurrentData());
        this.setModel(new PalatteListModel());
        this.setCellRenderer(new NameAndPictureListCellRenderer());
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    public Object getCurrentData() {
        return this.dataSource;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        if (this.getSelectedIndex() == -1) {
            return;
        }
        Object obj = this.getSelectedValue();
        if (obj == null) {
            return;
        }
        WizardEntry e = (WizardEntry)this.getSelectedValue();
        e.reset();
        e.init(null, this.getCurrentData(), null);
        SILKChartFlavor scf = new SILKChartFlavor(e);
        dge.startDrag(DragSource.DefaultCopyDrop, (Transferable)scf);
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(Object dataSource) {
        this.dataSource = dataSource;
    }

    class NameAndPictureListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -4362252253181915905L;

        public NameAndPictureListCellRenderer() {
            this.setOpaque(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.setHorizontalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            WizardEntry entry = (WizardEntry)value;
            this.setText(entry.getName());
            if (entry.getImage() != null) {
                ImageIcon i = new ImageIcon(entry.getImage());
                this.setIcon(i);
            }
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            int x = 150;
            int y = 30;
            Dimension d = new Dimension(Math.max(x, this.getPreferredSize().width), Math.max(y, this.getPreferredSize().height));
            this.setPreferredSize(d);
            return this;
        }
    }

    class PalatteListModel
    extends DefaultListModel {
        private static final long serialVersionUID = -4023946370974251905L;

        public PalatteListModel() {
            ChartCategory[] cats = ComponentPalette.this.wizard.getChartList();
            for (int i = 0; i < cats.length; ++i) {
                WizardEntry[] entries = cats[i].getEntries();
                for (int j = 0; j < entries.length; ++j) {
                    this.addElement(entries[j]);
                }
            }
        }
    }
}

