/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ConstComponent;
import com.sas.graphics.silk.TreeviewComponent;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BaseLinksPanel
extends JPanel
implements TabPanelInterface,
ActionListener,
ItemListener,
ChangeListener {
    private static final long serialVersionUID = -3165192154578484478L;
    protected JComponent parent;
    protected PropertyInterface propertyInterface;
    protected ResourceBundle resourceBundle;
    JCheckBox LinkColorMappedButton = new JCheckBox();
    JPanel LinkWidthPanel = new JPanel();
    JRadioButton LinkWidthFixedButton = new JRadioButton();
    JRadioButton LinkWidthMappedButton = new JRadioButton();
    JComboBox LinkWidthCombo = new JComboBox();
    protected EtchedBorder etchedBorder = new EtchedBorder();
    private TitledBorder LinkWidthBorder = new TitledBorder(this.etchedBorder);
    private String[] widths;
    private int numLinkWidths = 5;
    private ButtonGroup widthButtonGroup = null;
    private boolean firstLinkWidthValQuery = true;

    public BaseLinksPanel(PropertyInterface propInterface, JComponent component) {
        this.propertyInterface = propInterface;
        this.parent = component;
        this.resourceBundle = ResourceBundle.getBundle("com.sas.graphics.silk.constchart.LinksPanel");
        this.setLayout(null);
        this.setSize(265, 410);
        this.LinkColorMappedButton.setText("Map Color from Data Values");
        this.LinkColorMappedButton.setActionCommand("ColorMapped");
        this.add(this.LinkColorMappedButton);
        this.LinkColorMappedButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.LinkColorMappedButton.setBounds(12, 132, 240, 24);
        this.LinkWidthPanel.setLayout(null);
        this.add(this.LinkWidthPanel);
        this.LinkWidthPanel.setBounds(12, 12, 240, 96);
        this.LinkWidthFixedButton.setText("Fixed:");
        this.LinkWidthFixedButton.setActionCommand("SizeFixed");
        this.LinkWidthPanel.add(this.LinkWidthFixedButton);
        this.LinkWidthFixedButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.LinkWidthFixedButton.setBounds(4, 24, 84, 24);
        this.LinkWidthMappedButton.setText("Mapped from Data Values");
        this.LinkWidthMappedButton.setActionCommand("SizeMapped");
        this.LinkWidthPanel.add(this.LinkWidthMappedButton);
        this.LinkWidthMappedButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.LinkWidthMappedButton.setBounds(4, 60, 232, 24);
        this.LinkWidthPanel.add(this.LinkWidthCombo);
        this.LinkWidthCombo.setBackground(Color.white);
        this.LinkWidthCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.LinkWidthCombo.setBounds(92, 24, 140, 24);
        this.LinkWidthPanel.setBorder(this.LinkWidthBorder);
        this.LinkWidthBorder.setTitleColor(Color.black);
        this.LinkWidthBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        String fixed = this.GRS(this.resourceBundle, "LinksPanel.Fixed.txt", "Fixed:");
        String mapped = this.GRS(this.resourceBundle, "LinksPanel.Mapped.txt", "Mapped from Data Values");
        String mappedColor = this.GRS(this.resourceBundle, "LinksPanel.ColorMapped.txt", "Map Color from Data Values");
        String widthTitle = this.GRS(this.resourceBundle, "LinksPanel.Width.txt", "Width");
        this.widths = new String[this.numLinkWidths];
        this.widths[0] = this.GRS(this.resourceBundle, "LinksPanel.LinkWidthCombo.OnePt.txt", "1 pt.");
        this.widths[1] = this.GRS(this.resourceBundle, "LinksPanel.LinkWidthCombo.TwoPt.txt", "2 pt.");
        this.widths[2] = this.GRS(this.resourceBundle, "LinksPanel.LinkWidthCombo.ThreePt.txt", "3 pt.");
        this.widths[3] = this.GRS(this.resourceBundle, "LinksPanel.LinkWidthCombo.FourPt.txt", "4 pt.");
        this.widths[4] = this.GRS(this.resourceBundle, "LinksPanel.LinkWidthCombo.FivePt.txt", "5 pt.");
        this.widthButtonGroup = new ButtonGroup();
        this.widthButtonGroup.add(this.LinkWidthFixedButton);
        this.widthButtonGroup.add(this.LinkWidthMappedButton);
        this.LinkColorMappedButton.setText(mappedColor);
        this.LinkWidthFixedButton.setText(fixed);
        this.LinkWidthMappedButton.setText(mapped);
        this.LinkWidthBorder.setTitle(widthTitle);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JRadioButton) {
            JRadioButton radio = (JRadioButton)source;
            if (radio == this.LinkWidthFixedButton) {
                this.LinkWidthCombo.setEnabled(true);
                this.propertyInterface.setPropertyValue(853, (Object)new Boolean(false));
                int index = this.LinkWidthCombo.getSelectedIndex();
                if (index >= 0) {
                    this.propertyInterface.setPropertyValue(851, (Object)new Integer(index + 1));
                } else {
                    this.LinkWidthCombo.setSelectedIndex(0);
                }
                if (this.parent instanceof ConstComponent) {
                    ((ConstComponent)this.parent).setWidthMappingLinks(false);
                } else if (this.parent instanceof TreeviewComponent) {
                    ((TreeviewComponent)this.parent).setWidthMappingLinks(false);
                }
            } else if (radio == this.LinkWidthMappedButton) {
                this.LinkWidthCombo.setEnabled(false);
                this.propertyInterface.setPropertyValue(853, (Object)new Boolean(true));
                if (this.parent instanceof ConstComponent) {
                    ((ConstComponent)this.parent).setWidthMappingLinks(true);
                } else if (this.parent instanceof TreeviewComponent) {
                    ((TreeviewComponent)this.parent).setWidthMappingLinks(true);
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox cb;
        Object source = e.getSource();
        if (null == source) {
            return;
        }
        if (source instanceof JComboBox) {
            JComboBox box = (JComboBox)source;
            int index = box.getSelectedIndex();
            this.propertyInterface.setPropertyValue(851, (Object)new Integer(index + 1));
        } else if (source instanceof JCheckBox && (cb = (JCheckBox)source) == this.LinkColorMappedButton) {
            this.propertyInterface.setPropertyValue(863, (Object)new Boolean(!cb.isSelected()));
            if (this.parent instanceof ConstComponent) {
                ((ConstComponent)this.parent).setColorMappingLinks(cb.isSelected());
            } else if (this.parent instanceof TreeviewComponent) {
                ((TreeviewComponent)this.parent).setColorMappingLinks(cb.isSelected());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ColorSchemeInterface colorScheme;
        Color c;
        Object source = e.getSource();
        if (source instanceof ColorSchemeInterface && (c = (colorScheme = (ColorSchemeInterface)source).getColorSchemeItemColor(0)) != null) {
            this.propertyInterface.setPropertyValue(850, (Object)c);
        }
    }

    public int getLinkWidth() {
        int linkWidth = 1;
        int selectedIndex = this.LinkWidthCombo.getSelectedIndex();
        if (selectedIndex > 0) {
            linkWidth = selectedIndex + 1;
        }
        return linkWidth;
    }

    public boolean cancelChanges() {
        this.refreshComponents();
        return true;
    }

    public boolean applyChanges() {
        this.propertyInterface.applyPropertyChanges();
        this.refreshComponents();
        return true;
    }

    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }

    protected String GRS(ResourceBundle rb, String name, String defStrg) {
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (rb != null) {
                s = rb.getString(name);
            }
        }
        catch (MissingResourceException e) {
            s = null;
        }
        if (s == null) {
            s = defStrg;
        }
        return s;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.refreshComponents();
        }
        super.setVisible(b);
    }

    public void refreshComponents() {
        boolean widthMappingAllowed;
        this.LinkColorMappedButton.removeItemListener(this);
        this.LinkWidthFixedButton.removeActionListener(this);
        this.LinkWidthMappedButton.removeActionListener(this);
        this.LinkWidthCombo.removeActionListener(this);
        Object value = this.propertyInterface.getPropertyValue(852);
        boolean linkColorMapped = value == null ? false : (Boolean)value;
        value = this.propertyInterface.getPropertyValue(859);
        boolean isValueMappingAllowed = value == null ? false : (Boolean)value;
        value = this.propertyInterface.getPropertyValue(863);
        boolean linkColorFix = false;
        if (value != null && value instanceof Boolean) {
            linkColorFix = (Boolean)value;
        }
        if (isValueMappingAllowed || linkColorMapped) {
            this.LinkColorMappedButton.setEnabled(true);
            if (linkColorFix) {
                this.LinkColorMappedButton.setSelected(false);
            } else {
                this.LinkColorMappedButton.setSelected(true);
            }
        } else {
            this.LinkColorMappedButton.setEnabled(false);
            this.LinkColorMappedButton.setSelected(false);
        }
        value = this.propertyInterface.getPropertyValue(853);
        boolean widthMapping = value == null ? false : (Boolean)value;
        value = this.propertyInterface.getPropertyValue(860);
        boolean bl = widthMappingAllowed = value == null ? false : (Boolean)value;
        if (widthMappingAllowed) {
            this.LinkWidthMappedButton.setEnabled(true);
            if (widthMapping) {
                this.LinkWidthMappedButton.setSelected(true);
                this.LinkWidthCombo.setEnabled(false);
            } else {
                this.LinkWidthFixedButton.setEnabled(true);
                this.LinkWidthFixedButton.setSelected(true);
                this.LinkWidthCombo.setEnabled(true);
            }
        } else {
            this.LinkWidthMappedButton.setEnabled(false);
            this.LinkWidthFixedButton.setEnabled(true);
            this.LinkWidthFixedButton.setSelected(true);
            this.LinkWidthCombo.setEnabled(true);
        }
        if (this.firstLinkWidthValQuery) {
            this.firstLinkWidthValQuery = false;
            this.LinkWidthCombo.removeAllItems();
            for (int i = 0; i < this.widths.length; ++i) {
                this.LinkWidthCombo.addItem(this.widths[i]);
            }
        }
        this.LinkColorMappedButton.addItemListener(this);
        this.LinkWidthFixedButton.addActionListener(this);
        this.LinkWidthMappedButton.addActionListener(this);
        this.LinkWidthCombo.addItemListener(this);
    }
}

