/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.util.nld.NLDViewer;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class AnimationStopIcon {
    private Component comp = null;
    private static Image icon = null;
    private int marginX = -1;
    private int marginY = -1;
    private int rightClrnc = 0;
    private String stopText = null;
    private String stopIconTipText = null;

    public AnimationStopIcon(Component component, String text, String iconTipText) {
        this.comp = component;
        if (icon == null) {
            icon = this.getImage("icons/MessageError_16.gif");
        }
        this.stopText = text;
        this.stopIconTipText = iconTipText;
        this.marginX = 5;
        this.marginY = 20;
        this.rightClrnc = 0;
    }

    private Image getImage(String name) {
        String s = name;
        InputStream is = null;
        Image img = null;
        if (this.comp == null || name == null) {
            return null;
        }
        if (!(s.startsWith("/") || s.startsWith("http:") || s.startsWith("file:"))) {
            s = "/" + s;
        }
        s.replace('\\', '/');
        try {
            URL url = new URL(s);
            is = url.openStream();
        }
        catch (Exception url) {
            // empty catch block
        }
        if (is == null && (is = this.comp.getClass().getResourceAsStream(s)) == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (baos == null) {
            return null;
        }
        try {
            int c;
            while ((c = is.read()) >= 0) {
                baos.write(c);
            }
            Toolkit tk = this.comp.getToolkit();
            if (tk == null) {
                return null;
            }
            img = tk.createImage(baos.toByteArray());
            MediaTracker mt = new MediaTracker(this.comp);
            mt.addImage(img, 0);
            mt.waitForID(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return img;
    }

    public boolean isAnimating() {
        if (this.comp == null) {
            return false;
        }
        if (this.comp instanceof NLDViewer) {
            return ((NLDViewer)this.comp).isAnimating();
        }
        return false;
    }

    public boolean isMouseOverIcon(int x, int y) {
        if (this.comp == null || !this.isAnimating() || icon == null) {
            return false;
        }
        return x > this.comp.getWidth() - icon.getWidth(null) - this.marginX - this.rightClrnc && x < this.comp.getWidth() - this.marginX && y > this.comp.getHeight() - icon.getHeight(null) - this.marginY && y < this.comp.getHeight() - this.marginY;
    }

    public String getTooltipText() {
        return this.stopIconTipText;
    }

    public void draw(Graphics g) {
        if (this.isAnimating()) {
            if (this.comp == null || icon == null) {
                return;
            }
            String iconText = this.stopText;
            int iWidth = icon.getWidth(null);
            int iHeight = icon.getHeight(null);
            int iLeft = this.comp.getWidth() - icon.getWidth(null) - this.marginX;
            int iTop = this.comp.getHeight() - icon.getHeight(null) - this.marginY;
            int iCenterX = iLeft + (int)((double)iWidth / 2.0);
            int iCenterY = iTop + (int)((double)iHeight / 2.0);
            FontMetrics fm = this.comp.getFontMetrics(this.comp.getFont());
            Rectangle2D bound = fm.getStringBounds(iconText, g);
            double strWidth = bound.getWidth();
            double strHeight = bound.getWidth();
            this.rightClrnc = strWidth > (double)iWidth ? (int)(strWidth / 2.0 - (double)iWidth / 2.0) : 0;
            int txtCenterX = iCenterX;
            int txtCenterY = iCenterY + (int)((double)iHeight / 2.0) + (int)(strHeight / 2.0) + 10;
            int textLeft = txtCenterX - (int)(strWidth / 2.0);
            int textTop = txtCenterY - (int)(strHeight / 2.0);
            g.drawImage(icon, iLeft - this.rightClrnc, iTop, null);
            g.drawString(iconText, textLeft - this.rightClrnc, textTop);
        }
    }

    public Point getTipPos() {
        if (this.comp == null || icon == null) {
            return null;
        }
        return new Point(this.comp.getWidth() - icon.getWidth(null) - this.rightClrnc, this.comp.getHeight() - icon.getHeight(null) - this.rightClrnc);
    }
}

