/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.spectrumplot;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.util.StringCompare;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class DendrogramModel
implements RoleInterface,
DataFilterListenerInterface {
    public static final int ROLE_CLUSTER = 0;
    public static final int ROLE_PARENT = 1;
    public static final int ROLE_HEIGHT = 2;
    public static final int ROLE_TIP = 3;
    public static final int NUM_ROLES = 4;
    protected DataFilterReadInterface dataIn;
    protected Object[] variables = new Object[4];
    protected boolean[] obsSelected;
    protected int[] obsMapping;
    protected boolean rebuildTree;
    protected boolean validTree;
    protected Node root;
    protected HashMap leaves;
    protected ArrayList selectedValues;
    protected int treeLevel;
    public static final Roles ROLES = Roles.getInstance(null);
    public static final String CLUSTER_ROLE_NAME = "Cluster";
    public static final String PARENT_ROLE_NAME = "Parent";
    public static final String HEIGHT_ROLE_NAME = "Height";
    public static final String TIP_ROLE_NAME = ROLES.getRoleNLSName("ROLE_TIP");

    public DendrogramModel(DataFilterReadInterface data) {
        this.setDataSource(data);
    }

    public DendrogramModel() {
        this(null);
    }

    public Object getVariableDescription(Object variable) {
        if (variable == null) {
            return null;
        }
        Object desc = this.dataIn.getVariableDescription(variable);
        if (desc == null || ((String)desc).equals("")) {
            return variable;
        }
        return desc;
    }

    protected boolean buildUpTree() {
        if (!this.rebuildTree) {
            return true;
        }
        this.validTree = false;
        int cid = this.dataIn.getVariableIndex(this.variables[0]);
        int pid = this.dataIn.getVariableIndex(this.variables[1]);
        int hid = this.dataIn.getVariableIndex(this.variables[2]);
        if (pid < 0 || cid < 0) {
            return false;
        }
        for (int i = 0; i < this.dataIn.getNumberObservations(-1); ++i) {
            Object p = this.dataIn.getValue(pid, (long)i);
            if (!this.dataIn.isMissing(pid, p)) continue;
            this.root = new Node();
            this.root.name = this.dataIn.getValue(cid, (long)i);
            this.root.height = hid < 0 ? 0.0 : ((Number)this.dataIn.getValue(hid, (long)i)).doubleValue();
            this.root.parent = null;
            this.root.level = 0;
            this.validTree = true;
            break;
        }
        if (!this.validTree) {
            return false;
        }
        this.leaves = new LinkedHashMap();
        this.treeLevel = this.root.level;
        this.buildUpChildren(this.root);
        if (this.treeLevel <= 0) {
            return false;
        }
        if (hid < 0) {
            Iterator iter = this.leaves.keySet().iterator();
            int size = this.leaves.size();
            for (int i = 0; i < size; ++i) {
                Node leaf = (Node)iter.next();
                leaf.height = this.treeLevel;
            }
        }
        this.rebuildTree = false;
        return true;
    }

    private void buildUpChildren(Node parent) {
        int cid = this.dataIn.getVariableIndex(this.variables[0]);
        int pid = this.dataIn.getVariableIndex(this.variables[1]);
        int hid = this.dataIn.getVariableIndex(this.variables[2]);
        ArrayList<Node> children = null;
        for (int i = 0; i < this.dataIn.getNumberObservations(-1); ++i) {
            Object p = this.dataIn.getValue(pid, (long)i);
            if (!p.equals(parent.name)) continue;
            Node kid = new Node();
            kid.name = this.dataIn.getValue(cid, (long)i);
            kid.height = hid < 0 ? parent.height + 1.0 : ((Number)this.dataIn.getValue(hid, (long)i)).doubleValue();
            kid.parent = parent;
            kid.level = parent.level + 1;
            if (children == null) {
                children = new ArrayList<Node>();
                kid.firstChild = true;
            }
            children.add(kid);
        }
        if (children == null || children.size() == 0) {
            this.leaves.put(parent, "leaf");
            return;
        }
        parent.children = children;
        this.treeLevel = Math.max(this.treeLevel, parent.level + 1);
        for (int k = 0; k < children.size(); ++k) {
            this.buildUpChildren((Node)children.get(k));
        }
    }

    protected HashMap getLeaves() {
        return this.leaves;
    }

    protected int getTreeLevel() {
        return this.treeLevel;
    }

    protected ArrayList getSelectedValues() {
        return this.selectedValues;
    }

    protected void setSelectAll(boolean sel) {
        this.setSelection(this.root, sel);
    }

    protected void setSelection(Node parent, boolean sel) {
        if (parent == null) {
            return;
        }
        if (this.selectedValues == null) {
            this.selectedValues = new ArrayList();
        }
        parent.selected = sel;
        this.setSelectionToChildren(parent, sel);
    }

    private void setSelectionToChildren(Node parent, boolean sel) {
        ArrayList children = parent.children;
        if (children == null || children.size() == 0) {
            if (sel) {
                this.selectedValues.add(parent.name);
            } else {
                this.selectedValues.remove(parent.name);
            }
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            Node kid = (Node)children.get(i);
            kid.selected = sel;
            this.setSelectionToChildren(kid, sel);
        }
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        return this.dataIn;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public boolean setDataSource(Object source, Object id) {
        if (!(source instanceof DataFilterReadInterface)) {
            return false;
        }
        this.dataIn = (DataFilterReadInterface)source;
        for (int i = 0; i < this.variables.length; ++i) {
            this.variables[i] = null;
        }
        int n = this.dataIn.getNumberObservations(-1);
        this.obsSelected = new boolean[n];
        this.obsMapping = new int[n];
        for (int i = 0; i < n; ++i) {
            this.obsSelected[i] = false;
            this.obsMapping[i] = -1;
        }
        this.rebuildTree = true;
        return true;
    }

    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    public Object getVariable(Object role) {
        int id;
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return null;
        }
        if (NLSRole.equals(CLUSTER_ROLE_NAME)) {
            id = 0;
        } else if (NLSRole.equals(PARENT_ROLE_NAME)) {
            id = 1;
        } else if (NLSRole.equals(HEIGHT_ROLE_NAME)) {
            id = 2;
        } else if (NLSRole.equals(TIP_ROLE_NAME)) {
            id = 3;
        } else {
            return null;
        }
        return this.variables[id];
    }

    public Object getRole(Object variableId) {
        String obj;
        int id = -1;
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] instanceof String && variableId instanceof String && StringCompare.equals((String)((String)this.variables[i]), (String)((String)variableId))) {
                id = i;
                break;
            }
            if (this.variables[i] == null || !this.variables[i].equals(variableId)) continue;
            id = i;
            break;
        }
        switch (id) {
            default: {
                obj = null;
                break;
            }
            case 0: {
                obj = CLUSTER_ROLE_NAME;
                break;
            }
            case 1: {
                obj = PARENT_ROLE_NAME;
                break;
            }
            case 2: {
                obj = HEIGHT_ROLE_NAME;
                break;
            }
            case 3: {
                obj = TIP_ROLE_NAME;
            }
        }
        return obj;
    }

    public boolean setRole(Object variableId, Object role) {
        int id;
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return false;
        }
        if (NLSRole.equals(CLUSTER_ROLE_NAME)) {
            id = 0;
        } else if (NLSRole.equals(PARENT_ROLE_NAME)) {
            id = 1;
        } else if (NLSRole.equals(HEIGHT_ROLE_NAME)) {
            id = 2;
        } else if (NLSRole.equals(TIP_ROLE_NAME)) {
            id = 3;
        } else {
            return false;
        }
        if (variableId == null) {
            return false;
        }
        if (variableId != null && !this.dataIn.verifyVariable(variableId)) {
            return false;
        }
        if (id == 2 && !this.dataIn.isNumericVariable(variableId)) {
            return false;
        }
        this.variables[id] = variableId;
        this.rebuildTree = true;
        return true;
    }

    public boolean addRole(Object variableId, Object role) {
        return this.setRole(variableId, role);
    }

    public boolean removeRole(Object variableId, Object role) {
        int id;
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        Object NLSRole = this.getNLSRole(role);
        if (NLSRole == null) {
            return false;
        }
        if (NLSRole.equals(CLUSTER_ROLE_NAME)) {
            id = 0;
        } else if (NLSRole.equals(PARENT_ROLE_NAME)) {
            id = 1;
        } else if (NLSRole.equals(HEIGHT_ROLE_NAME)) {
            id = 2;
        } else if (NLSRole.equals(TIP_ROLE_NAME)) {
            id = 3;
        } else {
            return false;
        }
        if (this.variables[id] instanceof String && variableId instanceof String && StringCompare.equals((String)((String)this.variables[id]), (String)((String)variableId))) {
            this.variables[id] = null;
        } else if (this.variables[id] != null && this.variables[id].equals(variableId)) {
            this.variables[id] = null;
        } else {
            return false;
        }
        this.rebuildTree = true;
        return true;
    }

    public boolean isDiscrete(Object role) {
        return false;
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        return true;
    }

    public Object getSortOrder(Object role) {
        return null;
    }

    public boolean setSortOrder(Object role, Object order) {
        return true;
    }

    public Object getRoleValue(Object role, int which) {
        Object id = this.getVariable(role);
        if (id == null) {
            return null;
        }
        if (which == 0) {
            return new Double(this.getMinimumValue(id));
        }
        if (which == 1) {
            return new Double(this.getMaximumValue(id));
        }
        return null;
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    public int getMaxAllowed(Object role) {
        return -1;
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
    }

    private Object getNLSRole(Object role) {
        return role;
    }

    private double getMinimumValue(Object variableId) {
        if (variableId == null) {
            return Double.NaN;
        }
        if (this.getRole(variableId).equals(HEIGHT_ROLE_NAME)) {
            int vid = this.dataIn.getVariableIndex(variableId);
            long rows = this.dataIn.getNumberObservations(vid);
            double min = Double.MAX_VALUE;
            for (long i = 0L; i < rows; ++i) {
                double v = this.dataIn.getNumericValue(vid, i);
                if (Double.isNaN(v) || !(v < min)) continue;
                min = v;
            }
            return min;
        }
        return 0.0;
    }

    private double getMaximumValue(Object variableId) {
        if (variableId == null) {
            return Double.NaN;
        }
        if (this.getRole(variableId).equals(HEIGHT_ROLE_NAME)) {
            int vid = this.dataIn.getVariableIndex(variableId);
            long rows = this.dataIn.getNumberObservations(vid);
            double max = -1.7976931348623157E308;
            for (long i = 0L; i < rows; ++i) {
                double v = this.dataIn.getNumericValue(vid, i);
                if (Double.isNaN(v) || !(v > max)) continue;
                max = v;
            }
            return max;
        }
        return 1.0;
    }

    class Node {
        Object name;
        double height;
        Node parent;
        ArrayList children;
        boolean firstChild;
        int level;
        boolean selected;

        Node() {
        }
    }
}

