/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.parallelaxis;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.silk.base.DistributionElement;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.Brush;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.ExtendedJLabel;
import com.sas.text.SASFormat;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JLabel;

public class AxisObject
implements UpdateInterface,
RenderInterface,
TransformInterface,
ViewportListenerInterface {
    private Rectangle screenArea;
    private double min = 0.0;
    private double max = 1.0;
    private ArrayList values = null;
    private double axisMin = 0.0;
    private double axisMax = 1.0;
    private double viewportMin = 0.0;
    private double viewportMax = 1.0;
    private AxisZoomPanHandler zoomPanHandler = null;
    private ArrayList viewportListeners = null;
    private boolean panTickValues = false;
    private Axes axis = null;
    private Object variable;
    private boolean discrete = false;
    private String description;
    private SASFormat format;
    private JLabel label;
    private boolean rebuildRequired = true;
    private boolean reverseAxis = false;
    private int orientation = 1;
    private DistributionElement distribution;
    private Brush brush;

    public AxisObject(Object var) {
        this.variable = var;
    }

    public AxisObject(Object var, boolean discrete) {
        this(var);
        this.discrete = discrete;
    }

    public Object getVariable() {
        return this.variable;
    }

    public boolean isDiscrete() {
        return this.discrete;
    }

    public double getMin() {
        return this.min;
    }

    public boolean setMin(double minIn) {
        if (Double.isInfinite(minIn) || Double.isNaN(minIn)) {
            return false;
        }
        this.min = minIn;
        return true;
    }

    public double getMax() {
        return this.max;
    }

    public boolean setMax(double maxIn) {
        if (Double.isInfinite(maxIn) || Double.isNaN(maxIn)) {
            return false;
        }
        this.max = maxIn;
        return true;
    }

    public ArrayList getValues() {
        return this.values;
    }

    public void setValues(ArrayList v) {
        this.values = v;
        this.rebuildRequired = true;
    }

    public double getAxisMin() {
        return this.axisMin;
    }

    public boolean setAxisMin(double minIn) {
        if (Double.isInfinite(minIn) || Double.isNaN(minIn)) {
            return false;
        }
        this.axisMin = minIn;
        this.rebuildRequired = true;
        return true;
    }

    public double getAxisMax() {
        return this.axisMax;
    }

    public boolean setAxisMax(double maxIn) {
        if (Double.isInfinite(maxIn) || Double.isNaN(maxIn)) {
            return false;
        }
        this.axisMax = maxIn;
        this.rebuildRequired = true;
        return true;
    }

    public DistributionElement getDistribution() {
        return this.distribution;
    }

    public void setDistribution(DistributionElement de) {
        this.distribution = de;
    }

    public Brush getBrush() {
        return this.brush;
    }

    public void setBrush(Brush b) {
        this.brush = b;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean setOrientation(int i) {
        if (i != 0 && i != 1) {
            return false;
        }
        if (i == 0) {
            this.axis.setDimension(2);
        } else {
            this.axis.setDimension(1);
        }
        this.orientation = i;
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public SASFormat getFormat() {
        return this.format;
    }

    public void setFormat(SASFormat fmt) {
        this.format = fmt;
    }

    public void setStyle(Style style) {
        if (this.axis == null) {
            return;
        }
        this.axis.applyStyle(style);
        this.label.setFont(this.getAxisLabelFont(this.axis));
        this.label.setForeground(this.axis.getLabel().getColor());
        this.zoomPanHandler.setStyle(style);
    }

    protected Font getAxisLabelFont(Axes axis) {
        TextStyleInterface tsi = axis.getLabel();
        Font fnt = null;
        if (tsi != null) {
            fnt = tsi.getFont();
        }
        if (tsi instanceof TextAttrib && ((TextAttrib)tsi).hasUserSetValue(9002)) {
            return fnt;
        }
        Font f = SILKUtilities.adjustFontSize((Font)fnt);
        return f;
    }

    public Rectangle getScreenArea() {
        return this.screenArea;
    }

    public void setScreenArea(Rectangle r) {
        if (r == null) {
            return;
        }
        this.screenArea = r;
        this.axis.setScreenArea(r.x, r.y, r.width, r.height);
    }

    public void setViewport(double min, double max) {
        this.viewportMin = min;
        this.viewportMax = max;
        if (!this.discrete) {
            double[] minMax = this.getViewportMinMax();
            if (this.panTickValues) {
                Object[] tickValues = AxisZoomPanHandler.panTickValues((double)minMax[0], (double)minMax[1], (Object[])this.axis.getTickMarkValues(false));
                this.axis.setAxis((Object)new Double(minMax[0]), (Object)new Double(minMax[1]), -1, -1, tickValues, null, Boolean.FALSE);
            } else {
                this.axis.setAxis((Object)new Double(minMax[0]), (Object)new Double(minMax[1]), -1, -1, null, Boolean.TRUE, null);
            }
            if (this.distribution != null) {
                ContinuousRange dr = new ContinuousRange(minMax[0], minMax[1]);
                byte dim = this.orientation == 0 ? (byte)2 : 1;
                this.distribution.setRange(dim, 0, (DataRange)dr);
            }
        }
    }

    public void setPanTickValues(boolean b) {
        this.panTickValues = b;
    }

    public void setDimension(Dimension d) {
        this.axis.setChartAreaDimension(d, true);
    }

    public boolean build(Object buildData) {
        if (!this.rebuildRequired) {
            return true;
        }
        this.axis.setGridLines((Object)new Boolean(false));
        this.axis.setDirection(this.orientation == 1);
        this.axis.setValues((Object)this.format);
        if (this.discrete) {
            this.axisMin = 0.0;
            this.axisMax = this.values.size() - 1;
            if (this.axisMin == this.axisMax) {
                this.axisMin -= 1.0;
                this.axisMax += 1.0;
            }
            this.axis.setAxis((Object)new Double(this.axisMin), (Object)new Double(this.axisMax), -1, -1, this.values.toArray(), null, null);
            this.zoomPanHandler.setMinimumViewportRange(2.0 / (this.axisMax - this.axisMin));
        } else {
            if (this.axisMin == this.axisMax) {
                this.axisMin -= 1.0;
                this.axisMax += 1.0;
            }
            this.axis.setAxis((Object)new Double(this.axisMin), (Object)new Double(this.axisMax), -1, -1, null, new Boolean(true), null);
            double[] end = this.axis.getMinMaxTickMarkValues();
            this.axisMin = end[0];
            this.axisMax = end[1];
            this.zoomPanHandler.setMinimumViewportRange(0.001);
        }
        this.rebuildRequired = false;
        return true;
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean rc = this.build(buildData);
        this.draw(drawContext, false);
        return rc;
    }

    public boolean create(Object createData) {
        this.axis = new Axes();
        this.axis.setTransformObject((Object)this);
        this.axis.setGridLines((Object)new Boolean(false));
        if (this.description == null) {
            this.description = (String)this.variable;
        }
        this.description = this.description.trim();
        this.axis.setLabel((Object)this.description);
        this.label = new ExtendedJLabel(this.description);
        this.label.setHorizontalAlignment(4);
        this.label.setVerticalAlignment(0);
        this.label.setFont(this.getAxisLabelFont(this.axis));
        this.label.setForeground(this.axis.getLabel().getColor());
        this.zoomPanHandler = new AxisZoomPanHandler(this.axis);
        this.zoomPanHandler.setDataRange(0.0, 1.0);
        this.zoomPanHandler.setPrimaryZoomPanArea(true);
        this.zoomPanHandler.addViewportListener((Object)this);
        this.rebuildRequired = true;
        return true;
    }

    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    public void draw(Object p, boolean callHighlightDraw) {
        if (!(p instanceof Graphics)) {
            return;
        }
        Graphics g = (Graphics)p;
        this.axis.draw((Object)g, false);
    }

    public void drawHighlight(Object p) {
    }

    public long getMasks() {
        return 0L;
    }

    public Object getOpacityValue() {
        return null;
    }

    public boolean isVisible() {
        return this.axis.isVisible();
    }

    public long setMasks(long mask, long bits) {
        return 0L;
    }

    public boolean setOpacityValue(Object newOpacity) {
        return false;
    }

    public void setVisible(boolean viz) {
        this.axis.setVisible(viz);
    }

    public double[] project(double x, double y, double z, double[] out) {
        double[] ret = out;
        if (ret == null && (ret = new double[3]) == null) {
            return null;
        }
        double[] minMax = this.getViewportMinMax();
        if (this.reverseAxis) {
            ret[0] = minMax[0] == minMax[1] ? (double)this.screenArea.x : (double)this.screenArea.width * (x - minMax[1]) / (minMax[0] - minMax[1]) + (double)this.screenArea.x;
        } else {
            double d = ret[0] = minMax[1] == minMax[0] ? (double)this.screenArea.x : (double)this.screenArea.width * (x - minMax[0]) / (minMax[1] - minMax[0]) + (double)this.screenArea.x;
        }
        ret[1] = this.reverseAxis ? (minMax[0] == minMax[1] ? (double)this.screenArea.y : (double)this.screenArea.height - (double)this.screenArea.height * (y - minMax[1]) / (minMax[0] - minMax[1]) + (double)this.screenArea.y) : (minMax[1] == minMax[0] ? (double)this.screenArea.y : (double)this.screenArea.height - (double)this.screenArea.height * (y - minMax[0]) / (minMax[1] - minMax[0]) + (double)this.screenArea.y);
        ret[2] = 0.0;
        return ret;
    }

    public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
        double[] ret = out;
        if (ret == null && (ret = new double[3]) == null) {
            return null;
        }
        double[] minMax = this.getViewportMinMax();
        if (this.reverseAxis) {
            ret[0] = this.screenArea.width == 0 ? minMax[1] : (minMax[0] - minMax[1]) * (pixelX - (double)this.screenArea.x) / (double)this.screenArea.width + minMax[1];
        } else {
            double d = ret[0] = this.screenArea.width == 0 ? minMax[0] : (minMax[1] - minMax[0]) * (pixelX - (double)this.screenArea.x) / (double)this.screenArea.width + minMax[0];
        }
        ret[1] = this.reverseAxis ? (this.screenArea.height == 0 ? minMax[1] : (minMax[0] - minMax[1]) * ((double)(this.screenArea.height + this.screenArea.y) - pixelY) / (double)this.screenArea.height + minMax[1]) : (this.screenArea.height == 0 ? minMax[0] : (minMax[1] - minMax[0]) * ((double)(this.screenArea.height + this.screenArea.y) - pixelY) / (double)this.screenArea.height + minMax[0]);
        ret[2] = 0.0;
        return ret;
    }

    public void setReverse(int axis, boolean flag) {
        this.reverseAxis = flag;
    }

    public boolean isReverse(int axis) {
        return this.reverseAxis;
    }

    private double[] getViewportMinMax() {
        double[] minMax = new double[]{this.axisMin + this.viewportMin * (this.axisMax - this.axisMin), this.axisMin + this.viewportMax * (this.axisMax - this.axisMin)};
        return minMax;
    }

    public Point project(Object value) {
        if (this.discrete) {
            return this.project(this.values.indexOf(value));
        }
        return this.project(((Number)value).doubleValue());
    }

    public Point project(double value) {
        double[] d = null;
        if (this.orientation == 0) {
            d = this.project(0.0, value, 0.0, null);
            return new Point(this.screenArea.x, (int)d[1]);
        }
        d = this.project(value, 0.0, 0.0, null);
        return new Point((int)d[0], this.screenArea.y + this.screenArea.height);
    }

    public Object unProject(int x, int y) {
        double[] d = this.unProject(x, y, 0.0, null);
        double v = this.orientation == 0 ? d[1] : d[0];
        if (this.discrete) {
            double err = 0.1;
            for (int i = 0; i < this.values.size(); ++i) {
                if (!(v >= (double)i - err) || !(v <= (double)i + err)) continue;
                return this.values.get(i);
            }
            return null;
        }
        if (v >= this.axisMin && v <= this.axisMax) {
            return new Double(v);
        }
        return null;
    }

    public int getPixelLoc() {
        if (this.orientation == 0) {
            return this.screenArea.x;
        }
        return this.screenArea.y + this.screenArea.height;
    }

    public Insets getMargin(Graphics2D g) {
        int bottom;
        int top;
        int left;
        int right;
        this.build(null);
        this.label.setVisible(this.axis.isVisible() && this.axis.getLabel().isVisible() && !this.axis.isLabelFontTooSmall());
        this.label.setFont(this.getAxisLabelFont(this.axis));
        this.label.setForeground(this.axis.getLabel().getColor());
        int o = this.orientation == 0 ? 1 : 0;
        ((ExtendedJLabel)this.label).setOrientation(o);
        int axisTextMargin = 2;
        int labelWidth = this.getLabelWidth();
        int labelHeight = this.getLabelHeight();
        if (this.orientation == 0) {
            right = (int)(0.5 * (double)labelWidth);
            boolean labelVisible = this.axis.getLabel().isVisible();
            this.axis.setLabel((Object)Boolean.FALSE);
            int left_value = this.axis.isPrimary() ? this.axis.getLeftWidth(g) : this.axis.getRightWidth(g);
            this.axis.setLabel((Object)new Boolean(labelVisible));
            left = (int)Math.max((double)left_value, 0.5 * (double)labelWidth);
            if (left_value == 0) {
                top = 0;
                bottom = 0;
            } else {
                top = (int)(0.5 * (double)this.axis.getValueHeight(g, -1));
                bottom = (int)(0.5 * (double)this.axis.getValueHeight(g, 0));
            }
        } else {
            top = (int)(0.5 * (double)labelHeight);
            int bottom_value = this.axis.getTickMarkValueHeight(g);
            bottom = (int)Math.max((double)bottom_value, 0.5 * (double)labelHeight);
            if (bottom_value == 0) {
                left = 0;
                right = 0;
            } else {
                left = this.axis.getLeftWidth(g) + axisTextMargin;
                right = this.axis.getRightWidth(g) + axisTextMargin;
            }
        }
        return new Insets(top, left, bottom, right);
    }

    public int getTickValueOffset(Graphics2D g) {
        return this.orientation == 0 ? this.axis.getLeftWidth(g) : this.axis.getTickMarkValueHeight(g);
    }

    public int getLabelWidth() {
        return this.label.isVisible() ? this.label.getPreferredSize().width : 0;
    }

    public int getLabelHeight() {
        return this.label.isVisible() ? this.label.getPreferredSize().height : 0;
    }

    public Axes getAxis() {
        return this.axis;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public AxisZoomPanHandler getZoomPanHandler() {
        return this.zoomPanHandler;
    }

    public void addViewportListener(Object listener) {
        if (listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (this.viewportListeners == null) {
            this.viewportListeners = new ArrayList();
        }
        if (!this.viewportListeners.contains(listener)) {
            this.viewportListeners.add(listener);
        }
    }

    public void removeViewportListener(Object listener) {
        if (this.viewportListeners == null || listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (this.viewportListeners.contains(listener)) {
            this.viewportListeners.remove(listener);
        }
    }

    protected void fireViewportChangeEvent(ViewportEvent evt) {
        evt.source = this;
        for (int i = 0; i < this.viewportListeners.size(); ++i) {
            ((ViewportListenerInterface)this.viewportListeners.get(i)).viewportChanged(evt);
        }
    }

    public void viewportChanged(ViewportEvent evt) {
        this.panTickValues = this.zoomPanHandler.getCurrentZoomPanStatus() == 0;
        if (this.orientation == 1) {
            this.setViewport(evt.xMin, evt.xMax);
        } else {
            this.setViewport(evt.yMin, evt.yMax);
        }
        this.fireViewportChangeEvent(evt);
    }
}

