/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.orgchart;

import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DrilldownEvent;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.MarkerStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TreeFindInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.orgchart.CustomZoomDialog;
import com.sas.graphics.silk.orgchart.FindPanel;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.NodeRenderer;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.RoleManager;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.graphics.util.nld.NLDScrollPaneInterface;
import com.sas.text.SASFormat;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class OrgViewer
extends JComponent
implements RoleListenerInterface,
RenderInterface,
UpdateInterface,
RoleInterface,
PropertyInterface,
NLDScrollPaneInterface,
TreeFindInterface,
DataFilterListenerInterface,
ActionListener {
    private static final long serialVersionUID = 1571482651024976737L;
    public static final String NODE_DATA_ID = "Nodes";
    public static final String LINK_DATA_ID = "Links";
    protected static final int LINK_NODE_ENUM = 0;
    protected static final int LINK_DATA_ENUM = 1;
    public static final int FIT_TO_PAGE_NONE = -1;
    public static final int FIT_TO_PAGE = 0;
    public static final int FIT_TO_PAGE_WIDTH = 1;
    public static final int FIT_TO_PAGE_HEIGHT = 2;
    protected String styleElement = "GraphDataStyleDefault";
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private static final int MAX_WIDTH = 169;
    public static final int EXPL = 0;
    public static final int VERT = 1;
    public static final int HORZ = 2;
    public static final int VERTHORZ = 3;
    public static final int STACKED_LEAVES = 3;
    public static final int LENS_FULL_TREE = 4;
    public static final int LENS_SUB_TREE = 5;
    public static final int LIST_VIEW = 6;
    public static final int NO_SHAPE = -1;
    public static final int EXPAND_SHAPE = 0;
    public static final int COLLAPSE_SHAPE = 1;
    protected static final int VERTICAL_GAP = 8;
    protected static final int HANDLE_GAP = 15;
    protected static final int MARGIN = 5;
    protected static final int FONT_PAD = 10;
    public static final int MAX_ICON_WIDTH = 24;
    public static final int MAX_ICON_HEIGHT = 24;
    public static final int ICON_PAD = 4;
    public static final int MAX_TEXT_LINES = 5;
    public static final int TEXT_PAD = 4;
    protected static final int MOUSE_DOWN = 1;
    protected static final int MOUSE_UP = 2;
    protected static final int MOUSE_DRAGGED = 3;
    protected Object nodeDataModel = null;
    protected DataFilterReadInterface nodeDataFilter = null;
    protected Object linkDataModel = null;
    protected DataFilterReadInterface linkDataFilter = null;
    protected SILKNumber nodeIDRole;
    protected SILKNumber nodeParentIDRole;
    protected SILKNumber nodeLabelRole;
    protected SILKNumber nodeGroupRole;
    protected SILKNumber nodeTipRole;
    protected SILKNumber nodeIconRole;
    protected SILKNumber nodeURLRole;
    protected SILKNumber nodeHasChildrenRole;
    protected SILKNumber nodeColorRole;
    protected SILKNumber linkIDRole;
    protected SILKNumber linkFromRole;
    protected SILKNumber linkToRole;
    protected SILKNumber linkTipRole;
    protected RoleManager roleManager = null;
    protected Roles roles = null;
    protected int treeLayout = 2;
    protected boolean orthogonalLinks = true;
    protected boolean sizeNodesToFitText = false;
    protected boolean drawIcon = true;
    protected boolean rebuildRequired = false;
    protected boolean noData = true;
    protected Object rootNodeId = null;
    protected Hashtable idToIndexMap = null;
    protected Hashtable idToIndexMapInLinkModel = null;
    protected int[] xPosition = null;
    protected int[] yPosition = null;
    protected boolean[] collapsed = null;
    protected boolean[] visible = null;
    protected int treeDepth = 0;
    private int absoluteTreeDepth = 0;
    protected int preferredHeight = 0;
    protected int preferredWidth = 0;
    protected int maxHeight = 0;
    protected int maxWidth = 0;
    protected int[] vspaces = null;
    protected int[] hspaces = null;
    private Image backBuffer = null;
    private boolean backBufferValid = false;
    private int compWidth = 0;
    private int compHeight = 0;
    private Point origin = null;
    protected Style style = null;
    private Image expandIcon = null;
    private Image collapseIcon = null;
    private Image defaultNodeIcon = null;
    protected GlobalDefaults defaults = null;
    protected Object focusNodeId = null;
    protected Font nodeFont = FontManager.getFont((String)"SansSerif", (int)0, (int)12);
    protected int actionMode = 6;
    private ArrayList[] children = null;
    private LinkedHashMap breadthOrdering = null;
    private LinkedHashMap breadthIndexOrdering = null;
    private boolean breadthOrderBuilt = false;
    protected ArrayList[] depthList = null;
    protected Stack rootsStack = null;
    protected Hashtable collapsedNodes = null;
    protected double[] lensValues = null;
    protected double[] lensLocs = null;
    protected double[] lensScreenLocs = null;
    protected double[][] worldLinearArea = null;
    protected double[][] screenLinearArea = null;
    protected int[] linearNodeStart = null;
    protected int[] linearNodeEnd = null;
    protected JDialog findDialog = null;
    protected Frame parentFrame = null;
    protected int mouseContext = -1;
    protected boolean treeDepthChanged = false;
    protected Cursor defaultCursor = null;
    protected Cursor handCursor = null;
    protected Cursor moveOpenCursor = null;
    protected Cursor moveClosedCursor = null;
    protected Cursor zoomCursor = null;
    protected Vector drillDownListeners = new Vector();
    protected static final int NUMBER_ADJACENT_NODES_IN_STACK = 10;
    protected int nodeDrawSampleStep = 10;
    protected LinkedHashMap nodeGroupTable = null;
    protected static final int[] supportedProperties = new int[]{0, 24, 25, 23, 433, 426, 434, 441, 801, 804, 0, 53, 19001};
    protected UserSetPropertyBitMask userSetProperties = null;
    protected PropertyList pendingProperties = null;
    protected String currentLegend = null;
    protected Hashtable iconCache = null;
    protected Hashtable focusNodeStateTable = null;
    protected boolean drawRaisedNodes = true;
    protected int scaledPreferredHeight = 0;
    protected int scaledPreferredWidth = 0;
    protected int scaledMaxHeight = 0;
    protected int scaledMaxWidth = 0;
    protected ResourceBundle resourceBundle;
    protected int oldCompWidth;
    protected int oldCompHeight;
    private boolean zoomValueSelected = true;
    private int zoomFitType = 0;
    private boolean reInitZoomScale = true;
    private JDialog customZoomdlg = null;
    protected boolean doubleClicked = false;
    protected String lastSearchString = null;
    protected int lastSearchType = 0;
    protected boolean lastMatchCase = false;
    protected LinkedHashMap previousFound = new LinkedHashMap();
    protected JPopupMenu popupMenu = null;
    protected Point popUpLoc = null;
    private JPopupMenu popUpMenu = null;
    private double zoomScale = 1.0;
    protected int mouseDownX = 0;
    protected int mouseDownY = 0;
    protected int lastMouseX = 0;
    protected int lastMouseY = 0;
    private int oldLayoutFocusNodeIdx = -1;
    protected double[][] xRanges = null;
    private String viewContextNodeId = null;
    private int viewContextXPos = -1;
    private int viewContextYPos = -1;
    private Hashtable treeState = null;
    private Vector pendingRoots = new Vector();
    protected int viewCenterX = -1;
    protected int viewCenterY = -1;
    private int treeExpansionLevel = -1;
    private boolean treeExpLevelChanged = false;
    private Color minColor;
    private Color neutralColor;
    private Color maxColor;
    private Color missingColor;
    private Color underflowColor;
    private Color overlflowColor;
    private double minValue = 0.0;
    private double neutralValue = 0.5;
    private double maxValue = 1.0;
    private boolean zeroCenter;
    private String colorRamp = "TwoColorAltRamp";
    private boolean reinitColorRamp = true;

    public OrgViewer() {
        this.userSetProperties = new UserSetPropertyBitMask(supportedProperties);
        this.pendingProperties = new PropertyList();
        this.iconCache = new Hashtable();
        this.roleManager = new RoleManager();
        this.roles = Roles.getInstance(null);
        this.nodeIDRole = this.roles.getRoleObject("ROLE_NODE_ID");
        this.roleManager.newRole((Object)this.nodeIDRole, (Object)"Node ID", 1, (Object)NODE_DATA_ID);
        this.nodeParentIDRole = this.roles.getRoleObject("ROLE_NODE_PARENT_ID");
        this.roleManager.newRole((Object)this.nodeParentIDRole, (Object)"Node Parent ID", 1, (Object)NODE_DATA_ID);
        this.nodeLabelRole = this.roles.getRoleObject("ROLE_NODE_LABEL");
        this.roleManager.newRole((Object)this.nodeLabelRole, (Object)"Node Label", 1, (Object)NODE_DATA_ID);
        this.nodeGroupRole = this.roles.getRoleObject("ROLE_NODE_GROUP");
        this.roleManager.newRole((Object)this.nodeGroupRole, (Object)"Node Group", 1, (Object)NODE_DATA_ID);
        this.nodeTipRole = this.roles.getRoleObject("ROLE_NODE_TIP");
        this.roleManager.newRole((Object)this.nodeTipRole, (Object)"Node Tip", 1, (Object)NODE_DATA_ID);
        this.nodeIconRole = this.roles.getRoleObject("ROLE_NODE_ICON");
        this.roleManager.newRole((Object)this.nodeIconRole, (Object)"Node Icon", 1, (Object)NODE_DATA_ID);
        this.nodeURLRole = this.roles.getRoleObject("ROLE_NODE_URL");
        this.roleManager.newRole((Object)this.nodeURLRole, (Object)"Node URL", 1, (Object)NODE_DATA_ID);
        this.nodeHasChildrenRole = this.roles.getRoleObject("ROLE_NODE_HAS_CHILDREN");
        this.roleManager.newRole((Object)this.nodeHasChildrenRole, (Object)"Node Has Children", 1, (Object)NODE_DATA_ID);
        this.nodeColorRole = this.roles.getRoleObject("ROLE_NODE_COLOR");
        this.roleManager.newRole((Object)this.nodeColorRole, (Object)"Node Color", 1, (Object)NODE_DATA_ID);
        this.roleManager.setRoleType((Object)this.nodeColorRole, 1);
        this.linkIDRole = this.roles.getRoleObject("ROLE_LINK_ID");
        this.roleManager.newRole((Object)this.linkIDRole, (Object)"Link ID", 1, (Object)LINK_DATA_ID);
        this.linkFromRole = this.roles.getRoleObject("ROLE_LINK_FROM");
        this.roleManager.newRole((Object)this.linkFromRole, (Object)"Link From", 1, (Object)LINK_DATA_ID);
        this.linkToRole = this.roles.getRoleObject("ROLE_LINK_TO");
        this.roleManager.newRole((Object)this.linkToRole, (Object)"Link To", 1, (Object)LINK_DATA_ID);
        this.linkTipRole = this.roles.getRoleObject("ROLE_LINK_TIP");
        this.roleManager.newRole((Object)this.linkTipRole, (Object)"Link Tip", 1, (Object)LINK_DATA_ID);
        this.roleManager.addRoleListener((RoleListenerInterface)this);
        this.origin = new Point();
        this.expandIcon = ResourceLoader.getImage((Component)this, (String)"icons/ExpandCategory_default.gif");
        this.collapseIcon = ResourceLoader.getImage((Component)this, (String)"icons/CollapseCategory_default.gif");
        this.defaultNodeIcon = ResourceLoader.getImage((Component)this, (String)"icons/defaultNode.gif");
        this.defaults = new GlobalDefaults();
        this.registerKeyboardAction(this, "RIGHT-ARROW", KeyStroke.getKeyStroke(39, 0, false), 0);
        this.registerKeyboardAction(this, "LEFT-ARROW", KeyStroke.getKeyStroke(37, 0, false), 0);
        this.registerKeyboardAction(this, "UP-ARROW", KeyStroke.getKeyStroke(38, 0, false), 0);
        this.registerKeyboardAction(this, "DOWN-ARROW", KeyStroke.getKeyStroke(40, 0, false), 0);
        this.registerKeyboardAction(this, "CTRL-E", KeyStroke.getKeyStroke(69, 2, false), 0);
        this.registerKeyboardAction(this, "CTRL-C", KeyStroke.getKeyStroke(67, 2, false), 0);
        this.registerKeyboardAction(this, "CTRL-F", KeyStroke.getKeyStroke(70, 2, false), 0);
        this.registerKeyboardAction(this, "CTRL-S", KeyStroke.getKeyStroke(83, 2, false), 0);
        this.defaultCursor = Cursor.getDefaultCursor();
        this.handCursor = Cursor.getPredefinedCursor(12);
        this.setCursor(this.defaultCursor);
        this.resourceBundle = ResourceBundle.getBundle("com.sas.graphics.silk.orgchart.silk_orgchart_NLS");
    }

    public void setColorRamp(String cr) {
        this.colorRamp = cr;
    }

    public String getColorRamp() {
        return this.colorRamp;
    }

    public void setStyleElement(String stElement) {
        this.styleElement = stElement;
    }

    public String getStyleElement() {
        return this.styleElement;
    }

    public String getStyle() {
        return this.style.getSchemeName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setStyle(Object o) {
        if (o == null) {
            this.style = null;
        } else {
            if (o.equals(this.style)) {
                return true;
            }
            if (o instanceof Style) {
                this.style = (Style)o;
            } else if (o instanceof String) {
                StyleCollection sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48);
                if (sc.getStyle((String)o) == null) return false;
                this.style = sc.getStyle((String)o);
            } else {
                if (!(o instanceof ColorScheme)) return false;
                this.style = ((ColorScheme)o).getStyle();
            }
        }
        if (!this.style.getSchemeName().equalsIgnoreCase("SILKDefault")) {
            this.userSetProperties.set(0);
        } else {
            this.userSetProperties.clear(0);
        }
        if (this.style == null) {
            return false;
        }
        this.reinitColorRamp = true;
        this.initColorRamp();
        this.backBufferValid = false;
        this.repaint();
        return true;
    }

    public boolean setActionMode(int actionMode) {
        switch (actionMode) {
            case 6: {
                this.actionMode = actionMode;
                this.setCursor(this.defaultCursor);
                return true;
            }
            case 4: {
                this.actionMode = actionMode;
                this.setCursor(this.moveOpenCursor);
                return true;
            }
            case 3: {
                this.actionMode = actionMode;
                this.setCursor(this.zoomCursor);
                return true;
            }
        }
        return false;
    }

    public int getActionMode() {
        return this.actionMode;
    }

    protected String getFormattedValue(Object var, int obs) {
        if (this.nodeDataFilter == null) {
            return null;
        }
        int varIdx = this.nodeDataFilter.getVariableIndex(var);
        if (var == null || varIdx < 0 || obs < 0 || obs >= this.nodeDataFilter.getNumberObservations(-1)) {
            return null;
        }
        Object value = this.nodeDataFilter.getValue(varIdx, (long)obs);
        if (value == null) {
            return null;
        }
        return this.getFormattedValue(var, value);
    }

    protected String getFormattedValue(Object var, Object value) {
        int varIdx = this.nodeDataFilter.getVariableIndex(var);
        if (var == null || varIdx < 0) {
            return null;
        }
        if (value == null) {
            return null;
        }
        SASFormat format = (SASFormat)this.nodeDataFilter.getFormat(var, SASFormat.class);
        if (format == null) {
            return this.getDefaultFormattedValue(value);
        }
        if (value instanceof String && format.isCharacterFormat() || value instanceof Number && !format.isCharacterFormat()) {
            return format.format(value);
        }
        return value.toString();
    }

    protected String getDefaultFormattedValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return this.defaults.defaultNumericFormat.format(value);
        }
        return value.toString();
    }

    public String getTipText(int screenX, int screenY) {
        int obs = this.pick(screenX, screenY);
        return this.getTipText(obs);
    }

    protected String getTipText(int obs) {
        int i;
        Object label;
        if (this.nodeDataFilter == null || obs < 0 || obs >= this.nodeDataFilter.getNumberObservations(-1)) {
            return null;
        }
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        Object labelVar = this.roleManager.getVariable((Object)this.nodeLabelRole, 0);
        Object tipVars = this.roleManager.getVariable((Object)this.nodeTipRole);
        if (idVar == null && tipVars == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(idVar);
        sb.append(" \t= \t ");
        sb.append(this.getFormattedValue(idVar, obs));
        if (labelVar != null && (label = this.nodeDataFilter.getValue(labelVar, (long)obs)) != null) {
            if (this.getNumberOfTextLines(label.toString()) > 1) {
                sb.append("\n");
                sb.append(labelVar);
                ArrayList v = OrgViewer.makeMultiLineStrings(label);
                for (i = 0; i < v.size(); ++i) {
                    if (i == 0) {
                        sb.append(" \t=\t ");
                    } else {
                        sb.append("\n \t \t ");
                    }
                    sb.append(v.get(i).toString());
                }
            } else {
                sb.append("\n");
                sb.append(labelVar);
                sb.append(" \t=\t ");
                sb.append(label.toString());
            }
        }
        int type = Extract.getSourceType((Object)tipVars);
        int n = Extract.getNumberItems((Object)tipVars, (int)type);
        for (i = 0; i < n; ++i) {
            Object var = Extract.getObject((Object)tipVars, (int)i, (int)type);
            if (var == null) continue;
            sb.append("\n");
            sb.append(var);
            sb.append(" \t=\t ");
            String tip = this.getFormattedValue(var, obs);
            if (tip == null) continue;
            if (this.getNumberOfTextLines(tip.toString()) > 1) {
                ArrayList v = OrgViewer.makeMultiLineStrings(tip);
                for (int l = 0; l < v.size(); ++l) {
                    sb.append(v.get(l).toString());
                    if (l == v.size() - 1) continue;
                    sb.append("\n \t \t ");
                }
                continue;
            }
            sb.append(tip.toString());
        }
        return sb.toString();
    }

    protected int pick(int screenX, int screenY) {
        switch (this.treeLayout) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                return this.linearPick(screenX, screenY);
            }
            case 4: 
            case 5: {
                return this.lensPick(screenX, screenY);
            }
        }
        return -1;
    }

    protected int linearPick(int screenX, int screenY) {
        if (this.xPosition == null || this.yPosition == null) {
            return -1;
        }
        Rectangle r = new Rectangle(0, 0, this.scaledMaxWidth, this.scaledMaxHeight);
        int halfNodeWidth = this.maxWidth / 2;
        int halfNodeHeight = this.maxHeight / 2;
        for (int i = 0; i < this.xPosition.length; ++i) {
            if (!this.isNodeVisible(i)) continue;
            Object nId = this.getNodeId(i);
            if (this.isLabelOnStack(nId)) {
                int scaledLabelW;
                String l = this.getNodeLabel(i);
                int lHeight = this.getLabelHeight(l);
                int scaledLabelH = (int)((double)(lHeight + 2) * this.zoomScale);
                int width = this.maxWidth - 12;
                r.width = scaledLabelW = (int)((double)width * this.zoomScale);
                r.height = scaledLabelH;
                r.x = this.getXPosition(i) - halfNodeWidth + 12;
                r.y = this.getYPosition(i) - (int)((double)scaledLabelH / (2.0 * this.zoomScale));
            } else {
                r.width = this.scaledMaxWidth;
                r.height = this.scaledMaxHeight;
                r.x = this.getXPosition(i) - halfNodeWidth;
                r.y = this.getYPosition(i) - halfNodeHeight;
            }
            double[] pt = this.project(r.x, r.y, null);
            r.x = (int)(pt[0] * this.zoomScale);
            r.y = (int)(pt[1] * this.zoomScale);
            if (!r.contains(screenX, screenY)) continue;
            return i;
        }
        return -1;
    }

    protected int lensPick(int screenX, int screenY) {
        int nIndex;
        int j;
        if (this.xPosition == null || this.yPosition == null) {
            return -1;
        }
        if (this.linearNodeStart == null || this.linearNodeEnd == null) {
            return -1;
        }
        int y = this.origin.y + screenY;
        int level = this.getLevelAtPosition(y);
        if (level < 0) {
            return -1;
        }
        Rectangle r = new Rectangle(0, 0, this.scaledMaxWidth, this.scaledMaxHeight);
        int halfNodeWidth = this.maxWidth / 2;
        int halfNodeHeight = this.maxHeight / 2;
        double[] pt1 = new double[2];
        for (j = this.linearNodeStart[level]; j <= this.linearNodeEnd[level] && this.depthList[level] != null && this.depthList[level].size() != 0; ++j) {
            nIndex = this.getNodeIndex(this.depthList[level].get(j));
            pt1 = this.project(this.getXPosition(nIndex), this.getYPosition(nIndex), pt1);
            r.x = (int)(pt1[0] - (double)halfNodeWidth);
            r.y = (int)(pt1[1] - (double)halfNodeHeight);
            r.x = (int)((double)r.x * this.zoomScale);
            r.y = (int)((double)r.y * this.zoomScale);
            if (!r.contains(screenX, screenY)) continue;
            return nIndex;
        }
        for (j = this.linearNodeStart[level] - 1; j >= 0 && this.depthList[level] != null && this.depthList[level].size() != 0; --j) {
            nIndex = this.getNodeIndex(this.depthList[level].get(j));
            pt1 = this.project(this.getXPosition(nIndex), this.getYPosition(nIndex), pt1);
            r.x = (int)(pt1[0] - (double)halfNodeWidth);
            r.y = (int)(pt1[1] - (double)halfNodeHeight);
            r.x = (int)((double)r.x * this.zoomScale);
            r.y = (int)((double)r.y * this.zoomScale);
            if (!r.contains(screenX, screenY)) continue;
            return nIndex;
        }
        for (j = this.linearNodeEnd[level]; j < this.depthList[level].size() && this.depthList[level] != null && this.depthList[level].size() != 0; ++j) {
            nIndex = this.getNodeIndex(this.depthList[level].get(j));
            pt1 = this.project(this.getXPosition(nIndex), this.getYPosition(nIndex), pt1);
            r.x = (int)(pt1[0] - (double)halfNodeWidth);
            r.y = (int)(pt1[1] - (double)halfNodeHeight);
            r.x = (int)((double)r.x * this.zoomScale);
            r.y = (int)((double)r.y * this.zoomScale);
            if (!r.contains(screenX, screenY)) continue;
            return nIndex;
        }
        return -1;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.draw(g, false);
    }

    @Override
    public Graphics getGraphics() {
        if (this.backBuffer == null && this.compWidth > 0 && this.compHeight > 0) {
            this.backBuffer = this.createImage(this.compWidth, this.compHeight);
            if (this.backBuffer == null) {
                this.backBuffer = new BufferedImage(this.compWidth, this.compHeight, 1);
            }
        }
        if (this.backBuffer != null) {
            Graphics g = this.backBuffer.getGraphics();
            g.setFont(this.nodeFont);
            return g;
        }
        return super.getGraphics();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.doResize(width, height);
    }

    public void setBounds(int x, int y, int width, int height, boolean fire) {
        super.setBounds(x, y, width, height);
        if (fire) {
            this.doResize(width, height);
        }
    }

    protected void doResize(int compWidthIn, int compHeightIn) {
        if (compWidthIn == this.compWidth && compHeightIn == this.compHeight) {
            return;
        }
        this.compWidth = compWidthIn;
        this.compHeight = compHeightIn;
        this.invalidateBackBuffer();
        this.reInitZoomScale = true;
        if (this.isRebuildRequired()) {
            this.build(Boolean.TRUE);
        } else if (this.treeLayout == 5 || this.treeLayout == 4) {
            this.buildTree();
        }
        this.setOrigin(this.origin.x, this.origin.y, false);
        if (this.treeLayout == 5 || this.treeLayout == 4) {
            this.setFocusNode(this.focusNodeId);
        }
        this.changeSupport.firePropertyChange("resize", null, new Integer(this.treeLayout));
    }

    protected void initOrigin() {
        if (this.scaledPreferredWidth <= this.compWidth && this.scaledPreferredHeight <= this.compHeight) {
            return;
        }
        if (this.rootNodeId == null) {
            return;
        }
        int rootIndex = this.getNodeIndex(this.rootNodeId);
        int rx = this.getXPosition(rootIndex);
        int ry = this.getYPosition(rootIndex);
        this.setOrigin(rx - this.compWidth / 2, ry - this.compHeight / 2, false);
    }

    protected void updateView(boolean buildTree, boolean initOrigin) {
        if (buildTree) {
            this.buildTree();
        }
        if (initOrigin) {
            this.initOrigin();
        }
        this.initZoomScale();
        this.backBufferValid = false;
        this.changeSupport.firePropertyChange("resize", null, new Integer(this.treeLayout));
        this.repaint();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    protected void invalidateBackBuffer() {
        this.backBuffer = null;
        this.backBufferValid = false;
    }

    protected boolean isLinkOutside(Rectangle r, double[] point1, double[] point2) {
        double[] pt1 = new double[2];
        double[] pt2 = new double[2];
        pt1[0] = point1[0] * this.zoomScale;
        pt1[1] = point1[1] * this.zoomScale;
        pt2[0] = point2[0] * this.zoomScale;
        pt2[1] = point2[1] * this.zoomScale;
        if (r == null || pt1 == null || pt2 == null) {
            return true;
        }
        if ((double)r.x > pt1[0] && (double)r.x > pt2[0]) {
            return true;
        }
        if ((double)(r.x + r.width) < pt1[0] && (double)(r.x + r.width) < pt2[0]) {
            return true;
        }
        if ((double)r.y > pt1[1] && (double)r.y > pt2[1]) {
            return true;
        }
        return (double)(r.y + r.height) < pt1[1] && (double)(r.y + r.height) < pt2[1];
    }

    public void setZoomFitType(int zFitType) {
        if (zFitType == 0 || zFitType == 1 || zFitType == 2) {
            this.setZoomScale(1.0);
            this.zoomFitType = zFitType;
            this.zoomValueSelected = true;
        } else {
            this.zoomFitType = -1;
        }
        this.reInitZoomScale = true;
    }

    public int getZoomFitType() {
        return this.zoomFitType;
    }

    private void initScaledDimensions() {
        this.scaledPreferredHeight = (int)((double)this.preferredHeight * this.zoomScale);
        this.scaledPreferredWidth = (int)((double)this.preferredWidth * this.zoomScale);
        this.scaledMaxHeight = (int)((double)this.maxHeight * this.zoomScale);
        this.scaledMaxWidth = (int)((double)this.maxWidth * this.zoomScale);
        switch (this.treeLayout) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                this.scaledPreferredHeight = (int)((double)(this.preferredHeight - 5) * this.zoomScale) + 5;
                this.scaledPreferredWidth = this.preferredWidth;
            }
        }
    }

    private void initZoomScale() {
        if (!this.reInitZoomScale) {
            return;
        }
        if (this.zoomFitType == 0 && this.zoomValueSelected) {
            double xScale = (double)this.compWidth / (double)this.preferredWidth;
            double yScale = (double)this.compHeight / (double)this.preferredHeight;
            this.zoomScale = Math.min(xScale, yScale);
        } else if (this.zoomFitType == 1 && this.zoomValueSelected) {
            this.zoomScale = (double)this.compWidth / (double)this.preferredWidth;
        } else if (this.zoomFitType == 2 && this.zoomValueSelected) {
            this.zoomScale = (double)this.compHeight / (double)this.preferredHeight;
        }
        this.initScaledDimensions();
    }

    protected void drawChart(Graphics g) {
        Object idVar;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.compWidth, this.compHeight);
        if (this.noData) {
            return;
        }
        Graphics2D g2 = null;
        AffineTransform oldTrans = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            oldTrans = g2.getTransform();
        }
        this.initZoomScale();
        if (g2 != null) {
            AffineTransform transf = new AffineTransform(oldTrans);
            transf.scale(this.zoomScale, this.zoomScale);
            g2.setTransform(transf);
        }
        if ((idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0)) == null || this.nodeDataFilter == null) {
            return;
        }
        if (this.isRebuildRequired()) {
            this.build(Boolean.TRUE);
        }
        Color wallColor = this.style.getFillStyleElement("WallFill").getFillColor();
        Color linkColor = ColorUtilities.darker((Color)wallColor, (double)0.35);
        int idVarIndex = this.nodeDataFilter.getVariableIndex(idVar);
        double[] pt1 = new double[2];
        double[] pt2 = new double[2];
        double[] pt3 = new double[2];
        double[] pt4 = new double[2];
        Rectangle r = new Rectangle(0 - this.scaledMaxWidth / 2, 0 - this.scaledMaxHeight / 2, this.compWidth + this.scaledMaxWidth, this.compHeight + this.scaledMaxHeight);
        g.setColor(linkColor);
        Object renderingHint = null;
        if (!this.orthogonalLinks && g2 != null) {
            renderingHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int nObs = this.nodeDataFilter.getNumberObservations(-1);
        for (int i = 0; i < nObs; ++i) {
            Object nodeId = this.nodeDataFilter.getValue(idVarIndex, (long)i);
            Object parentId = this.getParentNodeId(nodeId);
            int nIndex = this.getNodeIndex(nodeId);
            int pIndex = this.getNodeIndex(parentId);
            this.drawLink(g, r, parentId, pIndex, nodeId, nIndex, pt1, pt2, pt3, pt4);
        }
        int focusNodeIndex = this.getNodeIndex(this.focusNodeId);
        if (this.focusNodeId != null && focusNodeIndex >= 0) {
            Stroke savedStroke = null;
            if (g2 != null) {
                savedStroke = g2.getStroke();
                g2.setStroke(new BasicStroke(2.0f, 2, 2));
            }
            Color selectColor = this.style.getLineStyleElement(this.styleElement).getLineColor();
            g.setColor(selectColor);
            Object nodeId = this.focusNodeId;
            Object parentId = this.getParentNodeId(nodeId);
            while (!this.rootNodeId.equals(nodeId) && parentId != null) {
                int nIndex = this.getNodeIndex(nodeId);
                int pIndex = this.getNodeIndex(parentId);
                this.drawLink(g, r, parentId, pIndex, nodeId, nIndex, pt1, pt2, pt3, pt4);
                nodeId = parentId;
                parentId = this.getParentNodeId(nodeId);
            }
            if (g2 != null) {
                g2.setStroke(savedStroke);
            }
        }
        if (!this.orthogonalLinks && g2 != null && renderingHint != null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        }
        this.drawNodes(g, r, pt1, pt2);
        if (g2 != null) {
            g2.setTransform(oldTrans);
        }
    }

    protected void drawVSpaces(Graphics g) {
        double[] pt = new double[2];
        g.setColor(Color.RED);
        for (int i = 0; i < this.vspaces.length; ++i) {
            int y = this.vspaces[i];
            pt = this.project(0.0, y, pt);
            g.drawLine(0, (int)(pt[1] * this.zoomScale), this.compWidth, (int)(pt[1] * this.zoomScale));
        }
    }

    protected void drawLink(Graphics g, Rectangle r, Object parentId, int pIndex, Object nodeId, int nIndex, double[] pt1, double[] pt2, double[] pt3, double[] pt4) {
        if (!this.isNodeVisible(nIndex) || !this.isNodeVisible(pIndex)) {
            return;
        }
        if (pIndex < 0 || this.isCollapsed(pIndex)) {
            return;
        }
        pt1 = this.project(this.getXPosition(pIndex), this.getYPosition(pIndex), pt1);
        if (this.isLinkOutside(r, pt1, pt2 = this.project(this.getXPosition(nIndex), this.getYPosition(nIndex), pt2))) {
            return;
        }
        if (this.orthogonalLinks) {
            if (this.treeLayout == 2) {
                double[] t = this.getHandlePosition(pIndex, pt3);
                if (t == null) {
                    return;
                }
                pt3 = t;
                pt3 = this.project(pt3[0], pt3[1], pt3);
                int parentDepth = this.getDepth(parentId);
                pt4[0] = pt1[0] = (double)(this.hspaces[parentDepth + 1] - this.origin.x);
                pt4[1] = pt2[1];
                g.drawLine((int)pt3[0], (int)pt3[1], (int)pt1[0], (int)pt1[1]);
                g.drawLine((int)pt1[0], (int)pt1[1], (int)pt4[0], (int)pt4[1]);
                g.drawLine((int)pt4[0], (int)pt4[1], (int)pt2[0], (int)pt2[1]);
            } else if (this.treeLayout == 6) {
                if (this.isLabelOnStack(nodeId)) {
                    if (this.isLinkOutside(r, pt1, pt2)) {
                        return;
                    }
                    g.drawLine((int)(pt1[0] + (double)(4 - this.maxWidth / 2)), (int)pt1[1], (int)(pt2[0] + (double)(4 - this.maxWidth / 2)), (int)pt2[1]);
                    g.drawLine((int)(pt2[0] + (double)(4 - this.maxWidth / 2)), (int)pt2[1], (int)(pt2[0] + (double)(8 - this.maxWidth / 2)), (int)pt2[1]);
                } else {
                    pt2[1] = pt2[1] - (double)(this.maxHeight / 2);
                    pt3 = this.getBranchPosition(pIndex, pt3);
                    pt3 = this.project(pt3[0], pt3[1], pt3);
                    pt4[0] = pt2[0];
                    pt4[1] = pt3[1];
                    g.drawLine((int)pt1[0], (int)pt1[1], (int)pt3[0], (int)pt3[1]);
                    g.drawLine((int)pt3[0], (int)pt3[1], (int)pt4[0], (int)pt4[1]);
                    g.drawLine((int)pt4[0], (int)pt4[1], (int)pt2[0], (int)pt2[1]);
                }
            } else {
                pt2[1] = pt2[1] - (double)(this.maxHeight / 2);
                pt3 = this.getBranchPosition(pIndex, pt3);
                pt3 = this.project(pt3[0], pt3[1], pt3);
                pt4[0] = pt2[0];
                pt4[1] = pt3[1];
                g.drawLine((int)pt1[0], (int)pt1[1], (int)pt3[0], (int)pt3[1]);
                g.drawLine((int)pt3[0], (int)pt3[1], (int)pt4[0], (int)pt4[1]);
                g.drawLine((int)pt4[0], (int)pt4[1], (int)pt2[0], (int)pt2[1]);
            }
        } else {
            double[] t = this.getHandlePosition(pIndex, pt3);
            if (t == null) {
                return;
            }
            pt3 = t;
            pt3 = this.project(pt3[0], pt3[1], pt3);
            pt2[1] = pt2[1] - (double)(this.maxHeight / 2);
            g.drawLine((int)pt1[0], (int)pt1[1], (int)pt3[0], (int)pt3[1]);
            g.drawLine((int)pt3[0], (int)pt3[1], (int)pt2[0], (int)pt2[1]);
        }
    }

    protected void drawNodes(Graphics g, Rectangle r, double[] pt1, double[] pt2) {
        if (this.rootNodeId == null) {
            return;
        }
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        int idVarIndex = this.nodeDataFilter.getVariableIndex(idVar);
        Object labelVar = this.roleManager.getVariable((Object)this.nodeLabelRole, 0);
        int labelVarIndex = idVarIndex;
        if (labelVar != null) {
            labelVarIndex = this.nodeDataFilter.getVariableIndex(labelVar);
        }
        Object iconVar = this.roleManager.getVariable((Object)this.nodeIconRole, 0);
        int iconVarIndex = -1;
        if (iconVar != null) {
            iconVarIndex = this.nodeDataFilter.getVariableIndex(iconVar);
        }
        Color wallColor = this.style.getFillStyleElement("WallFill").getFillColor();
        Color linkColor = ColorUtilities.darker((Color)wallColor, (double)0.35);
        Color nodeOutlineColor = this.style.getLineStyleElement(this.styleElement).getLineColor();
        Color nodeColor = this.style.getFillStyleElement(this.styleElement).getFillColor();
        Color textColor = this.style.getTextStyleElement("TitleText").getTextColor();
        Color focusColor = this.style.getLineStyleElement(this.styleElement).getLineColor();
        boolean isColorRolePresent = this.isNodeRoleSet(this.nodeColorRole);
        boolean isGroupRolePresent = this.isNodeRoleSet(this.nodeGroupRole);
        g.setFont(this.nodeFont);
        if (this.treeLayout == 5 || this.treeLayout == 4) {
            this.drawLensedNodes(g, r, pt1, pt2);
        } else {
            Object nodeGroupVar = this.roleManager.getVariable((Object)this.nodeGroupRole, 0);
            for (int i = 0; i < this.nodeDataFilter.getNumberObservations(-1); ++i) {
                Object nId = this.nodeDataFilter.getValue(idVarIndex, (long)i);
                Object parentId = this.getParentNodeId(nId);
                int pIdx = this.getNodeIndex(parentId);
                if ((parentId == null || pIdx < 0) && !this.rootNodeId.equals(nId) || this.getNodeIndex(nId) != i || !this.isNodeVisible(i) || parentId != null && this.isCollapsed(pIdx) && this.areEqual(parentId, this.rootNodeId)) continue;
                boolean onStack = this.isLabelOnStack(nId);
                boolean isChildrenOnStack = this.isChildrenOnStack(nId);
                Color nc = nodeColor;
                Color noc = nodeOutlineColor;
                if (isGroupRolePresent) {
                    int groupIndex = this.getGroupIndex(i);
                    if (groupIndex >= 0) {
                        DataStyleElement dse = SILKUtilities.getStyleElement((String)this.nodeDataFilter.getFormattedValue(nodeGroupVar, (long)i, null), (int)groupIndex, (int)2, (Style)this.style, (String)this.styleElement, null).getAsDataStyle();
                        noc = dse.getLineColor();
                        nc = dse.getFillColor();
                    }
                } else if (isColorRolePresent) {
                    nc = this.getMappedNodeColor(i);
                } else {
                    int depth = this.getAbsoluteDepth(nId);
                    nc = this.getMappedColor(depth);
                }
                this.drawNode(g, r, i, idVarIndex, labelVarIndex, iconVarIndex, linkColor, noc, nc, textColor, focusColor, false, null, pt1, pt2, onStack, isChildrenOnStack);
            }
        }
    }

    protected Color getMappedNodeColor(int obsIndex) {
        Object nodeColorVar = this.roleManager.getVariable((Object)this.nodeColorRole, 0);
        if (this.nodeDataFilter == null || nodeColorVar == null) {
            return null;
        }
        if (obsIndex < 0 || obsIndex >= this.nodeDataFilter.getNumberObservations(-1)) {
            return null;
        }
        int colorVarIndex = this.nodeDataFilter.getVariableIndex(this.roleManager.getVariable((Object)this.nodeColorRole, 0));
        return this.getMappedColor(obsIndex, colorVarIndex);
    }

    protected void drawLensedNodes(Graphics g, Rectangle r, double[] pt1, double[] pt2) {
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        int idVarIndex = this.nodeDataFilter.getVariableIndex(idVar);
        Object labelVar = this.roleManager.getVariable((Object)this.nodeLabelRole, 0);
        int labelVarIndex = idVarIndex;
        if (labelVar != null) {
            labelVarIndex = this.nodeDataFilter.getVariableIndex(labelVar);
        }
        Object iconVar = this.roleManager.getVariable((Object)this.nodeIconRole, 0);
        int iconVarIndex = -1;
        if (iconVar != null) {
            iconVarIndex = this.nodeDataFilter.getVariableIndex(iconVar);
        }
        Object nodeGroupVar = this.roleManager.getVariable((Object)this.nodeGroupRole, 0);
        Color wallColor = this.style.getFillStyleElement("WallFill").getFillColor();
        Color linkColor = ColorUtilities.darker((Color)wallColor, (double)0.35);
        Color nodeOutlineColor = this.style.getLineStyleElement(this.styleElement).getLineColor();
        Color nodeColor = this.style.getFillStyleElement(this.styleElement).getFillColor();
        Color textColor = this.style.getTextStyleElement("TitleText").getTextColor();
        Color focusColor = this.style.getLineStyleElement(this.styleElement).getLineColor();
        boolean isColorRolePresent = this.isNodeRoleSet(this.nodeColorRole);
        boolean isGroupRolePresent = this.isNodeRoleSet(this.nodeGroupRole);
        for (int i = 0; i < this.depthList.length; ++i) {
            int depth;
            DataStyleElement dse;
            int groupIndex;
            Color noc;
            Color nc;
            int pIdx;
            Object parentId;
            Object nId;
            int nodeIndex;
            int j;
            if (this.depthList[i].size() == 0) continue;
            this.nodeDrawSampleStep = this.depthList[i].size() < 1000 ? 10 : 10 * (this.depthList[i].size() / 1000);
            for (j = 0; j < this.linearNodeStart[i]; ++j) {
                if (this.linearNodeStart[i] > 10 && j < this.linearNodeStart[i] - 10 && j % this.nodeDrawSampleStep != 0) continue;
                nodeIndex = this.getNodeIndex(this.depthList[i].get(j));
                nId = this.nodeDataFilter.getValue(idVarIndex, (long)nodeIndex);
                parentId = this.getParentNodeId(nId);
                pIdx = this.getNodeIndex(parentId);
                if ((parentId == null || pIdx < 0) && !this.rootNodeId.equals(nId) || this.getNodeIndex(nId) != nodeIndex || !this.isNodeVisible(nodeIndex) || parentId != null && this.isCollapsed(pIdx) && this.areEqual(parentId, this.rootNodeId)) continue;
                nc = nodeColor;
                noc = nodeOutlineColor;
                if (isGroupRolePresent) {
                    groupIndex = this.getGroupIndex(nodeIndex);
                    if (groupIndex >= 0) {
                        dse = SILKUtilities.getStyleElement((String)this.nodeDataFilter.getFormattedValue(nodeGroupVar, (long)nodeIndex, null), (int)groupIndex, (int)2, (Style)this.style, (String)this.styleElement, null).getAsDataStyle();
                        nc = dse.getFillColor();
                        noc = dse.getLineColor();
                    }
                } else if (isColorRolePresent) {
                    nc = this.getMappedNodeColor(i);
                } else {
                    depth = this.getAbsoluteDepth(nId);
                    nc = this.getMappedColor(depth);
                }
                this.drawNode(g, r, nodeIndex, idVarIndex, labelVarIndex, iconVarIndex, linkColor, noc, nc, textColor, focusColor, false, null, pt1, pt2, false, false);
            }
            for (j = this.depthList[i].size() - 1; j > this.linearNodeEnd[i]; --j) {
                if (this.depthList[i].size() - this.linearNodeEnd[i] > 10 && j > this.linearNodeEnd[i] + 10 && j % this.nodeDrawSampleStep != 0 && j != this.depthList[i].size() - 1) continue;
                nodeIndex = this.getNodeIndex(this.depthList[i].get(j));
                nId = this.nodeDataFilter.getValue(idVarIndex, (long)nodeIndex);
                parentId = this.getParentNodeId(nId);
                pIdx = this.getNodeIndex(parentId);
                if ((parentId == null || pIdx < 0) && !this.rootNodeId.equals(nId) || this.getNodeIndex(nId) != nodeIndex || !this.isNodeVisible(nodeIndex) || parentId != null && this.isCollapsed(pIdx) && this.areEqual(parentId, this.rootNodeId)) continue;
                nc = nodeColor;
                noc = nodeOutlineColor;
                if (isGroupRolePresent) {
                    groupIndex = this.getGroupIndex(nodeIndex);
                    if (groupIndex >= 0) {
                        dse = SILKUtilities.getStyleElement((String)this.nodeDataFilter.getFormattedValue(nodeGroupVar, (long)nodeIndex, null), (int)groupIndex, (int)2, (Style)this.style, (String)this.styleElement, null).getAsDataStyle();
                        noc = dse.getLineColor();
                        nc = dse.getFillColor();
                    }
                } else if (isColorRolePresent) {
                    nc = this.getMappedNodeColor(nodeIndex);
                } else {
                    depth = this.getAbsoluteDepth(nId);
                    nc = this.getMappedColor(depth);
                }
                this.drawNode(g, r, nodeIndex, idVarIndex, labelVarIndex, iconVarIndex, linkColor, noc, nc, textColor, focusColor, false, null, pt1, pt2, false, false);
            }
            for (j = this.linearNodeStart[i]; j <= this.linearNodeEnd[i]; ++j) {
                nodeIndex = this.getNodeIndex(this.depthList[i].get(j));
                nId = this.nodeDataFilter.getValue(idVarIndex, (long)nodeIndex);
                parentId = this.getParentNodeId(nId);
                pIdx = this.getNodeIndex(parentId);
                if ((parentId == null || pIdx < 0) && !this.rootNodeId.equals(nId) || this.getNodeIndex(nId) != nodeIndex || !this.isNodeVisible(nodeIndex) || parentId != null && this.isCollapsed(pIdx) && this.areEqual(parentId, this.rootNodeId)) continue;
                nc = nodeColor;
                noc = nodeOutlineColor;
                if (isGroupRolePresent) {
                    groupIndex = this.getGroupIndex(nodeIndex);
                    if (groupIndex >= 0) {
                        dse = SILKUtilities.getStyleElement((String)this.nodeDataFilter.getFormattedValue(nodeGroupVar, (long)nodeIndex, null), (int)groupIndex, (int)2, (Style)this.style, (String)this.styleElement, null).getAsDataStyle();
                        noc = dse.getLineColor();
                        nc = dse.getFillColor();
                    }
                } else if (isColorRolePresent) {
                    nc = this.getMappedNodeColor(nodeIndex);
                } else {
                    depth = this.getAbsoluteDepth(nId);
                    nc = this.getMappedColor(depth);
                }
                this.drawNode(g, r, nodeIndex, idVarIndex, labelVarIndex, iconVarIndex, linkColor, noc, nc, textColor, focusColor, false, null, pt1, pt2, false, false);
            }
        }
    }

    private boolean isSubTreeCollapsed(Object nodeId) {
        if (nodeId == null) {
            return false;
        }
        int nIdx = this.getNodeIndex(nodeId);
        if (this.isCollapsed(nIdx)) {
            return true;
        }
        Object parentId = this.getParentNodeId(nodeId);
        return this.isSubTreeCollapsed(parentId);
    }

    protected void drawNode(Graphics g, Rectangle r, int nodeIndex, int idVarIndex, int labelVarIndex, int iconVarIndex, Color linkColor, Color nodeOutlineColor, Color nodeColor, Color textColor, Color focusColor, boolean selected, Color selectColor, double[] pt1, double[] pt2, boolean drawOnlyLabel, boolean isChildrenOnStack) {
        int nIndex = nodeIndex;
        Object label = this.nodeDataFilter.getValue(labelVarIndex, (long)nodeIndex);
        Image nodeIcon = this.defaultNodeIcon;
        if (this.drawIcon && iconVarIndex >= 0) {
            Image image;
            Object iconLoc = this.nodeDataFilter.getValue(iconVarIndex, (long)nodeIndex);
            if (iconLoc != null && iconLoc.toString().length() != 0 && !this.iconCache.containsKey(iconLoc) && (image = ResourceLoader.getImage((Component)this, (String)iconLoc.toString())) != null) {
                this.iconCache.put(iconLoc, image);
            }
            if ((image = (Image)this.iconCache.get(iconLoc)) != null) {
                nodeIcon = image;
            }
        }
        if (!r.contains((int)((pt1 = this.project(this.getXPosition(nIndex), this.getYPosition(nIndex), pt1))[0] * this.zoomScale), (int)(pt1[1] * this.zoomScale))) {
            return;
        }
        Image handleIcon = null;
        int handleShapeType = -1;
        boolean hasChildren = this.hasChildren(nIndex);
        if (this.children != null && nIndex >= 0 && nIndex < this.children.length) {
            ArrayList childNodes = this.children[nIndex];
            if (childNodes != null && childNodes.size() > 0) {
                if (this.isCollapsed(nIndex)) {
                    handleIcon = this.expandIcon;
                    handleShapeType = 0;
                } else {
                    handleIcon = this.collapseIcon;
                    handleShapeType = 1;
                }
            } else if (hasChildren) {
                handleIcon = this.expandIcon;
                handleShapeType = 0;
            }
        }
        double[] t = null;
        if (handleIcon != null) {
            t = this.getHandlePosition(nIndex, pt2);
        }
        if (this.treeLayout == 2) {
            handleShapeType = -1;
        }
        if (t != null) {
            pt2 = t;
        }
        pt2 = this.project(pt2[0], pt2[1], pt2);
        if ((this.isCollapsed(nIndex) || hasChildren) && (this.treeLayout != 2 || nIndex == this.getNodeIndex(this.rootNodeId))) {
            g.setColor(linkColor);
            g.drawLine((int)pt1[0], (int)pt1[1], (int)pt2[0], (int)pt2[1]);
        }
        int textLines = 1;
        if (label != null) {
            textLines = this.getNumberOfTextLines(label.toString());
        }
        boolean drawShadow = this.drawRaisedNodes && (hasChildren || this.getNumberOfChildren(nIndex) > 0);
        int nHeight = this.maxHeight;
        if (drawOnlyLabel) {
            nHeight = this.getLabelHeight(label.toString());
        }
        NodeRenderer.drawOrgChartNode(g, nodeColor, nodeOutlineColor, textColor, (int)pt1[0], (int)pt1[1], this.maxWidth, nHeight, label, textLines, this.focusNodeId.equals(this.getNodeId(nIndex)), focusColor, selected, selectColor, this.drawIcon, nodeIcon, drawShadow, (int)pt2[0], (int)pt2[1], handleIcon, this, handleShapeType, drawOnlyLabel, isChildrenOnStack);
    }

    protected void drawSelections(Graphics g) {
        int idVarIndex;
        if (this.nodeDataFilter == null) {
            return;
        }
        SelectionIterator selections = this.nodeDataFilter.getSelections();
        if (selections == null) {
            return;
        }
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        if (idVar == null || this.nodeDataFilter == null) {
            return;
        }
        Object labelVar = this.roleManager.getVariable((Object)this.nodeLabelRole, 0);
        int labelVarIndex = idVarIndex = this.nodeDataFilter.getVariableIndex(idVar);
        if (labelVar != null) {
            labelVarIndex = this.nodeDataFilter.getVariableIndex(labelVar);
        }
        Object iconVar = this.roleManager.getVariable((Object)this.nodeIconRole, 0);
        int iconVarIndex = -1;
        if (iconVar != null) {
            iconVarIndex = this.nodeDataFilter.getVariableIndex(iconVar);
        }
        Color nodeOutlineColor = this.style.getLineStyleElement(this.styleElement).getLineColor();
        Color nodeColor = this.style.getFillStyleElement(this.styleElement).getFillColor();
        Color textColor = this.style.getTextStyleElement("TitleText").getTextColor();
        Color selectColor = this.style.getLineStyleElement("Selection").getLineColor();
        Color wallColor = this.style.getFillStyleElement("WallFill").getFillColor();
        Color linkColor = ColorUtilities.darker((Color)wallColor, (double)0.35);
        Color focusColor = this.style.getLineStyleElement(this.styleElement).getLineColor();
        g.setFont(this.nodeFont);
        Rectangle r = new Rectangle(0 - this.scaledMaxWidth / 2, 0 - this.scaledMaxHeight / 2, this.compWidth + this.scaledMaxWidth, this.compHeight + this.scaledMaxHeight);
        Graphics2D g2 = null;
        AffineTransform oldTrans = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            oldTrans = g2.getTransform();
            AffineTransform transf = new AffineTransform(oldTrans);
            transf.scale(this.zoomScale, this.zoomScale);
            g2.setTransform(transf);
        }
        double[] pt1 = new double[2];
        double[] pt3 = new double[2];
        boolean isColorRolePresent = this.isNodeRoleSet(this.nodeColorRole);
        boolean isGroupRolePresent = this.isNodeRoleSet(this.nodeGroupRole);
        Object nodeGroupVar = this.roleManager.getVariable((Object)this.nodeGroupRole, 0);
        while (selections.hasMoreSelections()) {
            Object parentId;
            int nIndex = selections.nextSelectedIndex();
            if (!this.isNodeVisible(nIndex) || (parentId = this.getParentNodeId(this.getNodeId(nIndex))) != null && this.isCollapsed(this.getNodeIndex(parentId)) && this.areEqual(parentId, this.rootNodeId)) continue;
            Color nc = nodeColor;
            Color noc = nodeOutlineColor;
            if (isGroupRolePresent) {
                int groupIndex = this.getGroupIndex(nIndex);
                if (groupIndex >= 0) {
                    DataStyleElement dse = SILKUtilities.getStyleElement((String)this.nodeDataFilter.getFormattedValue(nodeGroupVar, (long)nIndex, null), (int)groupIndex, (int)2, (Style)this.style, (String)this.styleElement, null).getAsDataStyle();
                    noc = dse.getLineColor();
                    nc = dse.getFillColor();
                }
            } else if (isColorRolePresent) {
                nc = this.getMappedNodeColor(nIndex);
            } else {
                int depth = this.getAbsoluteDepth(this.getNodeId(nIndex));
                nc = this.getMappedColor(depth);
            }
            boolean onStack = this.isLabelOnStack(this.getNodeId(nIndex));
            boolean isChildrenOnStack = this.isChildrenOnStack(this.getNodeId(nIndex));
            this.drawNode(g, r, nIndex, idVarIndex, labelVarIndex, iconVarIndex, linkColor, noc, nc, textColor, focusColor, true, selectColor, pt1, pt3, onStack, isChildrenOnStack);
        }
        if (g2 != null) {
            g2.setTransform(oldTrans);
        }
    }

    protected void drawFocusNode(Graphics g) {
        int idVarIndex;
        if (this.focusNodeId == null) {
            return;
        }
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        if (idVar == null || this.nodeDataFilter == null) {
            return;
        }
        int nIndex = this.getNodeIndex(this.focusNodeId);
        if (!this.isNodeVisible(nIndex)) {
            return;
        }
        Object parentId = this.getParentNodeId(this.getNodeId(nIndex));
        if (parentId != null && this.isCollapsed(this.getNodeIndex(parentId)) && this.areEqual(parentId, this.rootNodeId)) {
            return;
        }
        Object labelVar = this.roleManager.getVariable((Object)this.nodeLabelRole, 0);
        int labelVarIndex = idVarIndex = this.nodeDataFilter.getVariableIndex(idVar);
        if (labelVar != null) {
            labelVarIndex = this.nodeDataFilter.getVariableIndex(labelVar);
        }
        Object iconVar = this.roleManager.getVariable((Object)this.nodeIconRole, 0);
        int iconVarIndex = -1;
        if (iconVar != null) {
            iconVarIndex = this.nodeDataFilter.getVariableIndex(iconVar);
        }
        Rectangle r = new Rectangle(0 - this.scaledMaxWidth / 2, 0 - this.scaledMaxHeight / 2, this.compWidth + this.scaledMaxWidth, this.compHeight + this.scaledMaxHeight);
        double[] pt1 = new double[2];
        double[] pt3 = new double[2];
        Color nodeOutlineColor = this.style.getLineStyleElement(this.styleElement).getLineColor();
        Color nodeColor = this.style.getFillStyleElement(this.styleElement).getFillColor();
        Color textColor = this.style.getTextStyleElement("TitleText").getTextColor();
        Color selectColor = this.style.getLineStyleElement("Selection").getLineColor();
        Color focusColor = this.style.getLineStyleElement(this.styleElement).getLineColor();
        Color wallColor = this.style.getFillStyleElement("WallFill").getFillColor();
        Color linkColor = ColorUtilities.darker((Color)wallColor, (double)0.35);
        boolean onStack = this.isLabelOnStack(this.getNodeId(nIndex));
        boolean isChildrenOnStack = this.isChildrenOnStack(this.getNodeId(nIndex));
        this.drawNode(g, r, nIndex, idVarIndex, labelVarIndex, iconVarIndex, linkColor, nodeOutlineColor, nodeColor, textColor, focusColor, this.nodeDataFilter.isSelected((long)nIndex), selectColor, pt1, pt3, onStack, isChildrenOnStack);
    }

    protected double[] project(double x, double y, double[] pt) {
        switch (this.treeLayout) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                pt = this.linearProject(x, y, pt);
                break;
            }
            case 4: 
            case 5: {
                pt = this.lensProject(x, y, pt);
            }
        }
        return pt;
    }

    protected double[] unProject(double x, double y, double[] pt) {
        switch (this.treeLayout) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                pt = this.linearUnProject(x, y, pt);
                break;
            }
            case 4: 
            case 5: {
                pt = this.lensUnProject(x, y, pt);
            }
        }
        return pt;
    }

    protected int getLevelAtPosition(double y) {
        int level;
        for (level = 0; level < this.vspaces.length - 1 && y > (double)this.vspaces[level + 1] * this.zoomScale; ++level) {
        }
        return level;
    }

    protected double[] lensUnProject(double x, double y, double[] pt) {
        return pt;
    }

    protected double[] lensProject(double x, double y, double[] pt) {
        int level;
        if (pt == null) {
            pt = new double[2];
        }
        if (this.lensValues[level = this.getLevelAtPosition(y)] == 1.0) {
            pt[0] = x;
        } else if (x >= this.worldLinearArea[level][0] && x <= this.worldLinearArea[level][1]) {
            pt[0] = x - this.worldLinearArea[level][0] + this.screenLinearArea[level][0];
        } else if (x < this.worldLinearArea[level][0]) {
            double logBase = this.worldLinearArea[level][0] - this.xRanges[level][0];
            double log = Math.log(this.worldLinearArea[level][0] - x) / Math.log(logBase);
            log = Math.max(0.0, Math.min(1.0, log));
            pt[0] = (double)(5 + this.maxWidth / 2) + (this.screenLinearArea[level][0] - 5.0 - (double)(this.maxWidth / 2)) * (1.0 - log);
        } else {
            double logBase = this.xRanges[level][1] - this.worldLinearArea[level][1];
            double log = Math.log(x - this.worldLinearArea[level][1]) / Math.log(logBase);
            log = Math.max(0.0, Math.min(1.0, log));
            pt[0] = this.screenLinearArea[level][1] + ((double)(this.compWidth - 5 - this.maxWidth / 2) - this.screenLinearArea[level][1]) * log;
        }
        pt[1] = y - (double)this.origin.y;
        return pt;
    }

    protected double[] linearUnProject(double x, double y, double[] pt) {
        if (pt == null) {
            pt = new double[2];
        }
        int widthOffset = 0;
        if (this.scaledPreferredWidth < this.compWidth) {
            widthOffset = (this.compWidth - this.scaledPreferredWidth) / 2;
            widthOffset = (int)((double)widthOffset * this.zoomScale);
        }
        pt[0] = x + (double)this.origin.x;
        pt[1] = y + (double)this.origin.y;
        if (this.treeLayout == 1 || this.treeLayout == 3 || this.treeLayout == 6) {
            pt[0] = pt[0] - (double)widthOffset;
        }
        return pt;
    }

    protected double[] linearProject(double x, double y, double[] pt) {
        if (pt == null) {
            pt = new double[2];
        }
        int widthOffset = 0;
        if (this.scaledPreferredWidth < this.compWidth) {
            widthOffset = (this.compWidth - this.scaledPreferredWidth) / 2;
            widthOffset = (int)((double)widthOffset / this.zoomScale);
        }
        pt[0] = x - (double)this.origin.x;
        pt[1] = y - (double)this.origin.y;
        if (this.treeLayout == 1 || this.treeLayout == 3 || this.treeLayout == 6) {
            pt[0] = pt[0] + (double)widthOffset;
        }
        return pt;
    }

    public void draw(Object p, boolean callHighlightDraw) {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        if (this.backBuffer == null) {
            this.backBuffer = this.createImage(this.compWidth, this.compHeight);
        }
        if (this.backBuffer != null) {
            if (!this.backBufferValid) {
                Graphics2D g = (Graphics2D)this.backBuffer.getGraphics();
                this.drawChart(g);
                this.backBufferValid = true;
            }
            if (p instanceof Graphics) {
                ((Graphics)p).drawImage(this.backBuffer, this.getBounds().x, this.getBounds().y, this);
            }
        } else if (p instanceof Graphics) {
            this.drawChart((Graphics)p);
        }
        if (p instanceof Graphics) {
            this.drawSelections((Graphics)p);
        }
    }

    public void drawHighlight(Object p) {
    }

    public long getMasks() {
        return 0L;
    }

    public Object getOpacityValue() {
        return null;
    }

    public long setMasks(long mask, long bits) {
        return 0L;
    }

    public boolean setOpacityValue(Object newOpacity) {
        return false;
    }

    protected void buildGroupIndexMap() {
        Object[] groupValues;
        Object nodeGroupVar = this.roleManager.getVariable((Object)this.nodeGroupRole, 0);
        if (this.nodeDataFilter == null || nodeGroupVar == null) {
            if (this.nodeGroupTable != null) {
                this.nodeGroupTable.clear();
            }
            return;
        }
        if (!(this.nodeDataFilter instanceof DataFilterInfoInterface)) {
            return;
        }
        DataFilterInfoInterface info = (DataFilterInfoInterface)this.nodeDataFilter;
        if (this.nodeGroupTable == null) {
            this.nodeGroupTable = new LinkedHashMap();
        }
        if ((groupValues = info.getUniqueValues(nodeGroupVar, true)) != null) {
            for (int i = 0; i < groupValues.length; ++i) {
                Object gv = groupValues[i];
                this.nodeGroupTable.put(gv, new Integer(i));
            }
        } else {
            this.nodeGroupTable.clear();
        }
    }

    protected int getGroupIndex(int obsIndex) {
        Object nodeGroupVar = this.roleManager.getVariable((Object)this.nodeGroupRole, 0);
        if (this.nodeDataFilter == null || nodeGroupVar == null || this.nodeGroupTable == null || this.nodeGroupTable.size() == 0) {
            return -1;
        }
        if (obsIndex < 0 || obsIndex >= this.nodeDataFilter.getNumberObservations(-1)) {
            return -1;
        }
        return this.getGroupIndex(this.nodeDataFilter.getFormattedValue(nodeGroupVar, (long)obsIndex, null));
    }

    protected int getGroupIndex(Object groupValue) {
        if (groupValue == null) {
            return -1;
        }
        if (this.nodeGroupTable == null || this.nodeGroupTable.size() == 0) {
            return -1;
        }
        Object o = null;
        Object v = this.nodeGroupTable.get(groupValue);
        o = v;
        return v == null ? -1 : (Integer)o;
    }

    public boolean build(Object buildData) {
        if (Boolean.TRUE.equals(buildData) || this.isRebuildRequired()) {
            Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
            Object fromVar = this.getFromVar();
            Object toVar = this.getToVar();
            if (this.nodeDataFilter == null || idVar == null || fromVar == null || toVar == null) {
                this.noData = true;
                return false;
            }
            this.noData = false;
            this.treeDepthChanged = true;
            this.buildMetaData();
            this.children = this.buildChildrenInfo();
            this.computeNodeSizes();
            this.buildTree();
            this.rebuildRequired = false;
            boolean treeBuildRequired = false;
            if (this.treeState != null) {
                this.setTreeState(this.treeState);
                treeBuildRequired = true;
            }
            if (this.treeLayout == 5) {
                if (this.oldLayoutFocusNodeIdx != -1) {
                    Object oldFocusNode = this.getNodeId(this.oldLayoutFocusNodeIdx);
                    int focusNodeDepth = this.getDepth(oldFocusNode);
                    int expLevel = focusNodeDepth >= 1 ? 1 : 0;
                    this.expandTree(expLevel);
                } else if (this.treeExpansionLevel <= 0) {
                    this.expandTree(0);
                } else {
                    this.expandTree(1);
                }
                treeBuildRequired = true;
            } else if (this.treeExpLevelChanged) {
                this.setTreeExpansionLevel(this.treeExpansionLevel, false);
                treeBuildRequired = true;
            }
            if (this.pendingRoots != null && this.pendingRoots.size() > 0) {
                for (int i = 0; i < this.pendingRoots.size(); ++i) {
                    this.setRoot(this.pendingRoots.elementAt(i));
                }
                this.pendingRoots.removeAllElements();
                treeBuildRequired = true;
            }
            if (treeBuildRequired) {
                this.buildTree();
            }
            if (this.scaledPreferredWidth > this.compWidth || this.scaledPreferredHeight > this.compHeight) {
                this.initOrigin();
            }
            if (this.viewCenterX >= 0 && this.viewCenterY >= 0) {
                this.setViewCenter(this.viewCenterX, this.viewCenterY);
            }
            if (this.viewContextNodeId != null) {
                this.setViewContext(this.viewContextNodeId, this.viewContextXPos, this.viewContextYPos);
            }
            this.initScaledDimensions();
            this.changeSupport.firePropertyChange("resize", null, new Integer(this.treeLayout));
            return true;
        }
        return false;
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        this.build(buildData);
        this.draw(drawContext, false);
        return true;
    }

    public boolean create(Object createData) {
        return false;
    }

    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    public Object[] getDataIds() {
        return new String[]{NODE_DATA_ID, LINK_DATA_ID};
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        if (LINK_DATA_ID.equals(id)) {
            return this.linkDataModel;
        }
        return this.nodeDataModel;
    }

    public boolean setDataSource(Object source, Object id) {
        DataFilterReadInterface dfri = FilterFactory.getDataSourceFilter((Object)source);
        if (dfri != null) {
            int dm = -1;
            if (id instanceof Number) {
                dm = ((Number)id).intValue();
            }
            this.roleManager.setDataset(id, (Object)dfri);
            if (LINK_DATA_ID.equals(id) || dm == 1) {
                this.linkDataModel = source;
                this.linkDataFilter = dfri;
                this.linkDataFilter.addDataFilterListener((Object)this);
            } else {
                this.nodeDataModel = source;
                this.nodeDataFilter = dfri;
                this.nodeDataFilter.addDataFilterListener((Object)this);
            }
            return true;
        }
        return false;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public boolean addRole(Object variableId, Object role) {
        return this.roleManager.addRole(variableId, role);
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public Object getAllVariables(Object role) {
        return this.roleManager.getAllVariables(role);
    }

    public Object getLimit(Object role) {
        return this.roleManager.getLimit(role);
    }

    public int getMaxAllowed(Object role) {
        return this.roleManager.getMaxAllowed(role);
    }

    public Object getRole(Object variableId) {
        return this.roleManager.getRole(variableId);
    }

    public Object getRoleValue(Object role, int which) {
        return null;
    }

    public Object getSortOrder(Object role) {
        return this.roleManager.getSortOrder(role);
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return this.roleManager.getSupportedRoles(id, discrete);
    }

    public Object[][] getSupportedSortableRoles() {
        return this.roleManager.getSupportedSortableRoles();
    }

    public int[] getSupportedSortDirections(Object role) {
        return this.roleManager.getSupportedSortDirections(role);
    }

    public Object getVariable(Object role) {
        return this.roleManager.getVariable(role, 0);
    }

    public boolean isDiscrete(Object role) {
        return this.roleManager.isDiscrete(role);
    }

    public boolean removeRole(Object variableId, Object role) {
        return this.roleManager.removeRole(variableId, role);
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public boolean requiresMultipleRoleAssignments() {
        return this.roleManager.requiresMultipleRoleAssignments();
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        return this.roleManager.setDiscrete(role, discrete);
    }

    public boolean setLimit(Object role, Object value) {
        return this.roleManager.setLimit(role, value);
    }

    public boolean setRole(Object variableId, Object role) {
        return this.roleManager.setRole(variableId, role);
    }

    public boolean setSortOrder(Object role, Object order) {
        return this.roleManager.setSortOrder(role, order);
    }

    public boolean supportsMultipleAssignments(Object role) {
        return this.roleManager.supportsMultipleAssignments(role);
    }

    private boolean handleSetRole(RoleEvent e) {
        switch (e.role) {
            case 26: 
            case 27: 
            case 45: 
            case 46: {
                this.rebuildRequired = true;
                break;
            }
            case 6: {
                this.buildGroupIndexMap();
                this.currentLegend = e.type == 3 ? null : this.nodeGroupRole.toString();
                if (this.roleManager.getVariable((Object)this.nodeColorRole, 0) == null) break;
                this.roleManager.removeRole(this.roleManager.getVariable((Object)this.nodeColorRole, 0), (Object)this.nodeColorRole);
                break;
            }
            case 64: {
                this.iconCache.clear();
                break;
            }
            case 2: {
                this.reinitColorRamp = true;
                this.initColorRamp();
                if (this.roleManager.getVariable((Object)this.nodeGroupRole, 0) == null) break;
                this.roleManager.removeRole(this.roleManager.getVariable((Object)this.nodeGroupRole, 0), (Object)this.nodeGroupRole);
                break;
            }
        }
        return true;
    }

    private boolean handleRemoveRole(RoleEvent e) {
        switch (e.role) {
            case 26: 
            case 27: 
            case 45: 
            case 46: {
                this.rebuildRequired = true;
                break;
            }
            case 6: {
                this.currentLegend = null;
                break;
            }
            case 64: {
                this.iconCache.clear();
                break;
            }
            case 2: {
                this.clearColorRamp();
                break;
            }
        }
        return true;
    }

    public void roleChanged(RoleEvent e) {
        switch (e.type) {
            case 1: 
            case 2: {
                this.handleSetRole(e);
                break;
            }
            case 3: {
                this.handleRemoveRole(e);
            }
        }
    }

    protected Object getFromVar() {
        Object parentIdVar = this.roleManager.getVariable((Object)this.nodeParentIDRole, 0);
        if (parentIdVar != null) {
            return parentIdVar;
        }
        Object linkFromVar = this.roleManager.getVariable((Object)this.linkFromRole, 0);
        if (linkFromVar != null) {
            return linkFromVar;
        }
        return null;
    }

    protected Object getToVar() {
        Object parentIdVar = this.roleManager.getVariable((Object)this.nodeParentIDRole, 0);
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        if (parentIdVar != null && idVar != null) {
            return idVar;
        }
        Object linkToVar = this.roleManager.getVariable((Object)this.linkToRole, 0);
        if (linkToVar != null) {
            return linkToVar;
        }
        return null;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public int getPreferredHeight() {
        if (this.zoomFitType == 0 || this.zoomFitType == 2) {
            return this.compHeight;
        }
        return this.scaledPreferredHeight;
    }

    public int getPreferredWidth() {
        if (this.zoomFitType == 0 || this.zoomFitType == 1) {
            return this.compWidth;
        }
        return this.scaledPreferredWidth;
    }

    public void setOrigin(Point origin, boolean scaleX, boolean scaleY) {
        int ox = origin.x;
        if (scaleX) {
            ox = (int)((double)ox / this.zoomScale);
        }
        int oy = origin.y;
        if (scaleY) {
            oy = (int)((double)oy / this.zoomScale);
        }
        this.setOrigin(ox, oy, false);
        this.backBufferValid = false;
        this.repaint();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(400, 400);
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement_New(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        int unitIncrement = 10;
        if (orientation == 0) {
            currentPosition = visibleRect.x;
            if (this.maxWidth != 0) {
                unitIncrement = this.maxWidth;
            }
        } else {
            currentPosition = visibleRect.y;
            if (this.maxHeight != 0) {
                unitIncrement = this.maxHeight;
            }
        }
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / unitIncrement * unitIncrement;
            return newPosition == 0 ? unitIncrement : newPosition;
        }
        return (int)((double)((currentPosition / unitIncrement + 1) * unitIncrement - currentPosition) * this.zoomScale);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int unitIncrement = 10;
        if (orientation == 0) {
            if (this.scaledMaxWidth != 0) {
                unitIncrement = this.scaledMaxWidth;
            }
            return (int)((double)(visibleRect.width - unitIncrement) * this.zoomScale);
        }
        if (this.scaledMaxHeight != 0) {
            unitIncrement = this.maxHeight + 8;
        }
        return (int)((double)(visibleRect.height - unitIncrement) * this.zoomScale);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        int unitIncrement = 10;
        if (orientation == 0) {
            currentPosition = visibleRect.x;
            if (this.scaledMaxWidth != 0) {
                unitIncrement = this.scaledMaxWidth;
            }
        } else {
            currentPosition = visibleRect.y;
            if (this.scaledMaxHeight != 0) {
                unitIncrement = this.scaledMaxHeight;
            }
        }
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / unitIncrement * unitIncrement;
            return newPosition == 0 ? unitIncrement : newPosition;
        }
        return (currentPosition / unitIncrement + 1) * unitIncrement - currentPosition;
    }

    protected Object getLegendEntries(String currentLegend) {
        Object[] groupValues;
        if (currentLegend == null) {
            return null;
        }
        if (!this.nodeGroupRole.toString().equalsIgnoreCase(currentLegend)) {
            return null;
        }
        Object groupVar = this.roleManager.getVariable((Object)this.nodeGroupRole, 0);
        if (this.nodeDataFilter == null || groupVar == null) {
            return null;
        }
        if (!(this.nodeDataFilter instanceof DataFilterInfoInterface)) {
            return null;
        }
        if (this.nodeGroupTable == null || this.nodeGroupTable.size() == 0) {
            this.buildGroupIndexMap();
        }
        if ((groupValues = ((DataFilterInfoInterface)this.nodeDataFilter).getUniqueValues(groupVar, true)) == null || groupValues.length == 0) {
            return null;
        }
        Integer markerShape = new Integer(19);
        Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(groupValues.length);
        for (int i = 0; i < groupValues.length; ++i) {
            Object gv = groupValues[i];
            int gi = this.getGroupIndex(gv);
            if (gv == null || gi < 0) continue;
            DataStyleElement dse = SILKUtilities.getStyleElement((String)gv.toString(), (int)gi, (int)2, (Style)this.style, (String)this.styleElement, null).getAsDataStyle();
            Color noc = dse.getLineColor();
            Color nc = dse.getFillColor();
            MarkerAttrib ms = new MarkerAttrib(true, nc);
            ms.setShape((Object)markerShape);
            ms.setFilled(true);
            ms.setOutline((Object)Boolean.TRUE);
            ms.setOutline((Object)noc);
            legendEntries.add(new LegendEntry(gv, (MarkerStyleInterface)ms, null));
        }
        return legendEntries;
    }

    protected Object getLegendTitle(String currentLegend) {
        if (currentLegend == null && this.nodeDataFilter != null) {
            return null;
        }
        if (this.nodeGroupRole.toString().equalsIgnoreCase(currentLegend)) {
            return this.nodeDataFilter.getVariableDescription(this.roleManager.getVariable((Object)this.nodeGroupRole, 0));
        }
        return null;
    }

    protected void applyChange(int key, Object value) {
        switch (key) {
            case 0: {
                this.setStyle(value);
                break;
            }
            case 19001: {
                if (value == null) break;
                this.styleElement = value.toString();
                this.applyStyleElement();
                break;
            }
            case 53: {
                if (value == null) break;
                this.colorRamp = value.toString();
                this.reinitColorRamp = true;
                this.initColorRamp();
                break;
            }
            case 801: {
                this.setZoomFitType((Integer)value);
                break;
            }
            case 804: {
                this.setZoomScale((Double)value);
                break;
            }
        }
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        Vector changes = this.pendingProperties.getChangesBySource(source);
        if (changes.size() == 0) {
            return false;
        }
        for (int i = 0; i < changes.size(); ++i) {
            PropertyEvent event = (PropertyEvent)changes.elementAt(i);
            int key = event.id;
            Object value = event.value;
            this.applyChange(key, value);
        }
        if (changes.size() > 0) {
            this.buildAndDraw(new Boolean(true), null, null);
        }
        this.pendingProperties.removeChangesBySource(source);
        return true;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        this.pendingProperties.removeChangesBySource(source);
    }

    public int getNumberPendingProperties() {
        return this.pendingProperties.getNumberPending(null);
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        return this.pendingProperties.getPending(source);
    }

    public Object getPropertyValue(int id) {
        if (this.pendingProperties != null && this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            default: {
                break;
            }
            case 23: {
                rc = this.currentLegend;
                break;
            }
            case 434: {
                if (this.nodeGroupRole.toString().equalsIgnoreCase(this.currentLegend)) {
                    rc = this.roleManager.getVariable((Object)this.nodeGroupRole, 0);
                    break;
                }
                rc = null;
                break;
            }
            case 24: 
            case 25: {
                if (this.currentLegend != null) {
                    rc = new Object[]{this.currentLegend};
                    break;
                }
                rc = null;
                break;
            }
            case 433: {
                rc = this.getLegendEntries(this.currentLegend);
                break;
            }
            case 426: {
                rc = this.getLegendTitle(this.currentLegend);
                break;
            }
            case 441: {
                rc = Boolean.FALSE;
                break;
            }
            case 804: {
                rc = new Double(this.getZoomScale());
                break;
            }
            case 0: {
                rc = new ColorScheme(this.style);
                break;
            }
            case 53: {
                if (this.isNodeRoleSet(RoleInterface.ROLE_NODE_COLOR)) {
                    rc = this.colorRamp;
                    break;
                }
                rc = null;
                break;
            }
            case 19001: {
                rc = this.styleElement;
            }
        }
        return rc;
    }

    public boolean hasUserSetValue(int id) {
        return this.userSetProperties.get(id);
    }

    public boolean isPropertyPending(int id) {
        return this.pendingProperties.isPending(id);
    }

    public boolean isPropertySupported(int id) {
        for (int i = 0; i < supportedProperties.length; ++i) {
            if (supportedProperties[i] != id) continue;
            return true;
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (id == 23 && value != null) {
            String leg = value.toString();
            if (this.nodeGroupRole.toString().equalsIgnoreCase(leg)) {
                this.currentLegend = this.nodeGroupRole.toString();
                return true;
            }
        }
        if (this.isPropertySupported(id)) {
            return this.pendingProperties.store(id, value);
        }
        return false;
    }

    private void createCustomZoomDialog() {
        if (this.customZoomdlg == null) {
            this.customZoomdlg = new CustomZoomDialog(this);
        }
    }

    public void updateView() {
        this.backBufferValid = false;
        this.zoomValueSelected = true;
        this.updateView(false, true);
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("NLD_RESET_ROOT")) {
            this.reset();
        }
        if (command.equals("ACTION_MODE_PAN")) {
            this.setActionMode(4);
        } else if (command.equals("ACTION_MODE_SELECT")) {
            this.setActionMode(6);
        } else if (command.equals("ACTION_MODE_ZOOM")) {
            this.setActionMode(3);
            this.zoomValueSelected = false;
        } else if (command.equals("CUSTOM_ZOOM")) {
            this.zoomValueSelected = true;
            this.createCustomZoomDialog();
            this.customZoomdlg.setLocation(this.popUpLoc);
            this.customZoomdlg.setVisible(true);
        } else if (command.equals("FIT_TO_PAGE")) {
            this.setZoomFitType(0);
            this.updateView();
        } else if (command.equals("FIT_TO_WIDTH")) {
            this.setZoomFitType(1);
            this.updateView();
        } else if (command.equals("FIT_TO_HEIGHT")) {
            this.setZoomFitType(2);
            this.updateView();
        } else if (command.equals("ZOOM_10PERCENT")) {
            this.setZoomScale(0.1);
            this.updateView();
        } else if (command.equals("ZOOM_25PERCENT")) {
            this.setZoomScale(0.25);
            this.updateView();
        } else if (command.equals("ZOOM_50PERCENT")) {
            this.setZoomScale(0.5);
            this.updateView();
        } else if (command.equals("ZOOM_100PERCENT")) {
            this.setZoomScale(1.0);
            this.updateView();
        } else if (command.equals("ZOOM_125PERCENT")) {
            this.setZoomScale(1.25);
            this.updateView();
        } else if (command.equals("ZOOM_150PERCENT")) {
            this.setZoomScale(1.5);
            this.updateView();
        } else if (command.equals("ZOOM_200PERCENT")) {
            this.setZoomScale(2.0);
            this.updateView();
        } else if (command.equals("ZOOM_400PERCENT")) {
            this.setZoomScale(4.0);
            this.updateView();
        } else if (command.equalsIgnoreCase("NLD_SHOW_ALL_NODES")) {
            this.showAllNodes();
        } else if (command.equalsIgnoreCase("TREE_LAYOUT_VERTICAL")) {
            this.setTreeLayout(1);
        } else if (command.equalsIgnoreCase("TREE_LAYOUT_HORIZONTAL")) {
            this.setTreeLayout(2);
        } else if (command.equalsIgnoreCase("TREE_LAYOUT_STACKED_LEAVES")) {
            this.setTreeLayout(3);
        } else if (command.equalsIgnoreCase("TREE_LAYOUT_LIST_VIEW")) {
            this.setTreeLayout(6);
        } else if (command.equalsIgnoreCase("TREE_LAYOUT_LENS_FULL_TREE")) {
            this.setTreeLayout(4);
        } else if (command.equalsIgnoreCase("TREE_LAYOUT_LENS_SUB_TREE")) {
            this.setTreeLayout(5);
        } else if (command.equalsIgnoreCase("NLD_SET_ROOT")) {
            this.setViewRoot(this.getNodeId(this.mouseContext), true);
        } else if (command.equalsIgnoreCase("NLD_LAST_ROOT")) {
            this.lastRoot(true);
        } else if (command.equalsIgnoreCase("FIND") || command.equals("CTRL-F")) {
            this.find();
        } else if (command.equals("CTRL-E")) {
            int nodeIndex = this.getNodeIndex(this.focusNodeId);
            if (this.focusNodeId != null && this.isCollapsed(nodeIndex) && this.getNumberOfChildren(nodeIndex) > 0) {
                this.setNodeCollapsed(nodeIndex);
            }
        } else if (command.equals("CTRL-C")) {
            int nodeIndex = this.getNodeIndex(this.focusNodeId);
            if (this.focusNodeId != null && !this.isCollapsed(nodeIndex) && this.getNumberOfChildren(nodeIndex) > 0) {
                this.setNodeCollapsed(nodeIndex);
            }
        } else if (command.equals("RIGHT-ARROW")) {
            Object nodeId = null;
            if (this.treeLayout == 1 || this.treeLayout == 4 || this.treeLayout == 5) {
                nodeId = this.getRightRelative(this.focusNodeId, true, false);
            } else if (this.treeLayout == 3) {
                if (!this.isNodeOnStack(this.focusNodeId)) {
                    nodeId = this.getRightRelative(this.focusNodeId, true, false);
                }
            } else if (this.treeLayout == 6) {
                if (!this.isLabelOnStack(this.focusNodeId)) {
                    nodeId = this.getRightRelative(this.focusNodeId, true, false);
                }
            } else if (this.treeLayout == 2) {
                int nodeIndex = this.getNodeIndex(this.focusNodeId);
                if (this.isCollapsed(nodeIndex)) {
                    this.setCollapsed(nodeIndex, false);
                } else {
                    nodeId = this.getFirstChild(this.focusNodeId);
                }
            }
            if (nodeId != null) {
                this.setFocusNode(nodeId);
            }
        } else if (command.equals("LEFT-ARROW")) {
            Object nodeId = null;
            if (this.treeLayout == 1 || this.treeLayout == 4 || this.treeLayout == 5) {
                nodeId = this.getLeftRelative(this.focusNodeId, true, false);
            } else if (this.treeLayout == 3) {
                if (!this.isNodeOnStack(this.focusNodeId)) {
                    nodeId = this.getLeftRelative(this.focusNodeId, true, false);
                }
            } else if (this.treeLayout == 6) {
                if (!this.isLabelOnStack(this.focusNodeId)) {
                    nodeId = this.getLeftRelative(this.focusNodeId, true, false);
                }
            } else if (this.treeLayout == 2) {
                int nodeIndex = this.getNodeIndex(this.focusNodeId);
                ArrayList al = this.getChildren(this.focusNodeId);
                if (al != null && al.size() > 0) {
                    if (!this.isCollapsed(nodeIndex)) {
                        this.setCollapsed(nodeIndex, true);
                    } else if (!this.areEqual(this.focusNodeId, this.rootNodeId)) {
                        nodeId = this.getParentNodeId(this.focusNodeId);
                    }
                } else {
                    nodeId = this.getParentNodeId(this.focusNodeId);
                }
            }
            if (nodeId != null) {
                this.setFocusNode(nodeId);
            }
        } else if (command.equals("UP-ARROW")) {
            Object nodeId = null;
            if (this.focusNodeId == null || this.focusNodeId.equals(this.rootNodeId)) {
                return;
            }
            if (this.treeLayout == 1 || this.treeLayout == 4 || this.treeLayout == 5) {
                nodeId = this.getParentNodeId(this.focusNodeId);
            } else if (this.treeLayout == 3) {
                nodeId = this.focusNodeId == this.getFirstChild(this.getParentNodeId(this.focusNodeId)) || !this.isNodeOnStack(this.focusNodeId) ? this.getParentNodeId(this.focusNodeId) : this.getLeftRelative(this.focusNodeId, true, false);
            } else if (this.treeLayout == 6) {
                nodeId = this.focusNodeId == this.getFirstChild(this.getParentNodeId(this.focusNodeId)) || !this.isLabelOnStack(this.focusNodeId) ? this.getParentNodeId(this.focusNodeId) : this.getLeftRelative(this.focusNodeId, true, false);
            } else if (this.treeLayout == 2) {
                nodeId = this.getUpRelative(this.focusNodeId);
            }
            if (nodeId != null) {
                this.setFocusNode(nodeId);
            }
        } else if (command.equals("DOWN-ARROW")) {
            Object nodeId = null;
            if (this.focusNodeId == null) {
                return;
            }
            ArrayList children = this.getChildren(this.focusNodeId);
            if (!this.isCollapsed(this.getNodeIndex(this.focusNodeId)) && children != null && children.size() > 0) {
                nodeId = this.getFirstChild(this.focusNodeId);
            } else {
                if (this.treeLayout == 3 && this.isNodeOnStack(this.focusNodeId) && this.focusNodeId != this.getLastChild(this.getParentNodeId(this.focusNodeId))) {
                    nodeId = this.getRightRelative(this.focusNodeId, true, false);
                }
                if (this.treeLayout == 6) {
                    if (this.isLabelOnStack(this.focusNodeId) && this.focusNodeId != this.getLastChild(this.getParentNodeId(this.focusNodeId))) {
                        nodeId = this.getRightRelative(this.focusNodeId, true, false);
                    }
                } else if (this.treeLayout == 2) {
                    nodeId = this.getDownRelative(this.focusNodeId);
                }
            }
            if (nodeId != null) {
                this.setFocusNode(nodeId);
            }
        } else if (command.equals("CTRL-S")) {
            int nodeIndex = this.getNodeIndex(this.focusNodeId);
            this.nodeDataFilter.unselectAll();
            if (nodeIndex >= 0 && nodeIndex < this.nodeDataFilter.getNumberObservations(-1)) {
                this.nodeDataFilter.setSelected((long)nodeIndex, true);
                this.repaint();
            }
        }
    }

    public void mousePressed(int mx, int my, boolean popupTrigger, int mClickCount, int modifier) {
        if (popupTrigger) {
            this.mouseContext = this.pick(mx, my);
            this.showPopupMenu(mx, my);
            return;
        }
        this.mouseDownX = mx;
        this.mouseDownY = my;
        if (mClickCount > 1 && (this.treeLayout == 5 || this.treeLayout == 4)) {
            this.mouseContext = this.pick(mx, my);
            Object nId = this.getNodeId(this.mouseContext);
            if (nId != null) {
                this.centerNode(nId, true);
                this.setFocusNode(nId);
            }
            this.doubleClicked = true;
            return;
        }
        this.doubleClicked = false;
        switch (this.actionMode) {
            default: {
                this.select(1, mx, my, modifier);
                break;
            }
            case 4: {
                this.pan(1, mx, my);
                break;
            }
            case 3: {
                this.zoom(1, mx, my);
            }
        }
    }

    public void mouseReleased(int mx, int my, boolean popupTrigger, int mClickCount, int modifier) {
        if (popupTrigger) {
            this.mouseContext = this.pick(mx, my);
            this.showPopupMenu(mx, my);
            return;
        }
        if (this.doubleClicked) {
            return;
        }
        if (Math.abs(this.mouseDownX - mx) < 3 && Math.abs(this.mouseDownY - my) < 3) {
            int handle = this.getHandleAt(mx, my);
            if (this.hasChildren(handle) && this.getChildren(this.getNodeId(handle)) == null) {
                this.fireDrillDownEvent(handle, true);
                return;
            }
            if (this.nodeDataFilter != null && handle >= 0 && handle < this.nodeDataFilter.getNumberObservations(-1)) {
                this.setNodeCollapsed(handle);
                return;
            }
        }
        switch (this.actionMode) {
            default: {
                this.select(2, mx, my, modifier);
                break;
            }
            case 4: {
                this.pan(2, mx, my);
                break;
            }
            case 3: {
                this.zoom(2, mx, my);
            }
        }
    }

    public void mouseDragged(int mx, int my, int modifier) {
        switch (this.actionMode) {
            default: {
                this.select(3, mx, my, modifier);
                break;
            }
            case 4: {
                this.pan(3, mx, my);
                break;
            }
            case 3: {
                this.zoom(3, mx, my);
            }
        }
    }

    public void mouseMoved(int mx, int my, int modifier) {
    }

    protected void find() {
        if (this.findDialog == null) {
            this.findDialog = this.createFindDialog();
        }
        this.findDialog.setVisible(true);
    }

    protected JDialog createFindDialog() {
        if (this.parentFrame == null) {
            Container con;
            for (con = this.getParent(); con != null && !(con instanceof Frame); con = con.getParent()) {
            }
            this.parentFrame = (Frame)con;
        }
        JDialog d = new JDialog(this.parentFrame);
        Container c = d.getContentPane();
        FindPanel fp = new FindPanel(this, d);
        d.setSize(fp.getWidth(), fp.getHeight() + 30);
        c.setLayout(new BorderLayout());
        c.add(fp);
        return d;
    }

    public void find(int searchType, String searchString, boolean matchCase) {
        boolean sameMatchCase;
        boolean sameSearchString = this.lastSearchString != null && this.lastSearchString.equals(searchString);
        boolean sameSearchType = this.lastSearchType == searchType;
        boolean bl = sameMatchCase = this.lastMatchCase == matchCase;
        if (!(sameSearchString && sameSearchType && sameMatchCase)) {
            this.previousFound.clear();
        }
        Object foundNode = null;
        switch (searchType) {
            case 1: {
                foundNode = this.breadthFirstSearch(searchString, matchCase);
                break;
            }
            case 2: {
                foundNode = this.depthFirstSearch(searchString, matchCase);
            }
        }
        if (foundNode != null) {
            this.centerNode(foundNode, false);
            this.previousFound.put(foundNode, foundNode);
            this.lastSearchString = searchString;
            this.lastSearchType = searchType;
            this.lastMatchCase = matchCase;
            this.setFocusNode(foundNode);
        } else if (this.previousFound.size() > 0) {
            this.previousFound.clear();
            this.find(searchType, searchString, matchCase);
        }
        this.updateView(false, false);
    }

    protected Object depthFirstSearch(String searchString, boolean matchCase) {
        if (searchString == null || searchString.length() == 0) {
            return null;
        }
        Stack<Object> nodes = new Stack<Object>();
        nodes.push(this.rootNodeId);
        while (!nodes.isEmpty()) {
            Object n = nodes.pop();
            int nodeIndex = this.getNodeIndex(n);
            if (this.match(this.getNodeLabel(nodeIndex), searchString, matchCase) && !this.previousFound.containsKey(n)) {
                return n;
            }
            ArrayList children = this.getChildren(n);
            if (children == null) continue;
            for (int i = children.size() - 1; i >= 0; --i) {
                Object child = children.get(i);
                nodes.push(child);
            }
        }
        return null;
    }

    protected Object breadthFirstSearch(String searchString, boolean matchCase) {
        if (this.nodeDataFilter == null || searchString == null || searchString.length() == 0) {
            return null;
        }
        Queue nodes = new Queue();
        nodes.enqueue(this.rootNodeId);
        boolean[] processed = new boolean[this.nodeDataFilter.getNumberObservations(-1)];
        while (!nodes.isEmpty()) {
            ArrayList children;
            int i;
            ArrayList siblings;
            Object n = nodes.dequeue();
            int nodeIndex = this.getNodeIndex(n);
            if (this.match(this.getNodeLabel(nodeIndex), searchString, matchCase) && !this.previousFound.containsKey(n)) {
                return n;
            }
            processed[nodeIndex] = true;
            Object parent = this.getParentNodeId(n);
            if (parent != null && (siblings = this.getChildren(parent)) != null) {
                for (i = 0; i < siblings.size(); ++i) {
                    Object sibling = siblings.get(i);
                    int sIndex = this.getNodeIndex(sibling);
                    if (n != sibling && this.match(this.getNodeLabel(sIndex), searchString, matchCase) && !this.previousFound.containsKey(sibling)) {
                        return sibling;
                    }
                    if (n == sibling || processed[sIndex]) continue;
                    nodes.enqueue(sibling);
                }
            }
            if ((children = this.getChildren(n)) == null) continue;
            for (i = 0; i < children.size(); ++i) {
                Object child = children.get(i);
                int cIndex = this.getNodeIndex(child);
                if (this.match(this.getNodeLabel(cIndex), searchString, matchCase) && !this.previousFound.containsKey(child)) {
                    return child;
                }
                if (processed[cIndex]) continue;
                nodes.enqueue(child);
            }
        }
        return null;
    }

    protected boolean match(String val, String searchString, boolean matchCase) {
        String a = val;
        String b = searchString;
        if (!matchCase) {
            a = val.toUpperCase();
            b = searchString.toUpperCase();
        }
        return a != null && a.indexOf(b) >= 0;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = this.buildPopupMenu();
        }
        this.setPopupMenuState(this.popupMenu);
        return this.popupMenu;
    }

    protected void showPopupMenu(int x, int y) {
        if (this.popupMenu == null) {
            this.popupMenu = this.buildPopupMenu();
        }
        this.setPopupMenuState(this.popupMenu);
        this.popupMenu.show(this, x, y);
        if (this.popUpLoc == null) {
            this.popUpLoc = new Point();
        }
        this.popUpLoc.setLocation(x, y);
    }

    protected void setPopupMenuState(JPopupMenu popupMenu) {
        JMenuItem zoomMenuItemInActionMenu;
        JMenu zoomMenuItem;
        JMenuItem showAllNodes;
        JMenuItem setRoot;
        if (popupMenu == null) {
            return;
        }
        this.setZoomRadioStatus();
        switch (this.treeLayout) {
            case 0: {
                MenuUtilities.setMenuItemSelected((JPopupMenu)popupMenu, (String)"TREE_LAYOUT_EXPLORER", (boolean)true);
                break;
            }
            case 1: {
                MenuUtilities.setMenuItemSelected((JPopupMenu)popupMenu, (String)"TREE_LAYOUT_VERTICAL", (boolean)true);
                break;
            }
            case 2: {
                MenuUtilities.setMenuItemSelected((JPopupMenu)popupMenu, (String)"TREE_LAYOUT_HORIZONTAL", (boolean)true);
                break;
            }
            case 3: {
                MenuUtilities.setMenuItemSelected((JPopupMenu)popupMenu, (String)"TREE_LAYOUT_STACKED_LEAVES", (boolean)true);
                break;
            }
            case 6: {
                MenuUtilities.setMenuItemSelected((JPopupMenu)popupMenu, (String)"TREE_LAYOUT_LIST_VIEW", (boolean)true);
                break;
            }
            case 4: {
                MenuUtilities.setMenuItemSelected((JPopupMenu)popupMenu, (String)"TREE_LAYOUT_LENS_FULL_TREE", (boolean)true);
                break;
            }
            case 5: {
                MenuUtilities.setMenuItemSelected((JPopupMenu)popupMenu, (String)"TREE_LAYOUT_LENS_SUB_TREE", (boolean)true);
            }
        }
        JMenuItem resetRoot = MenuUtilities.getMenuItem((JPopupMenu)this.popUpMenu, (String)"NLD_RESET_ROOT");
        if (this.rootsStack == null || this.rootsStack.isEmpty()) {
            resetRoot.setEnabled(false);
        } else {
            resetRoot.setEnabled(true);
        }
        JMenuItem lastRoot = MenuUtilities.getMenuItem((JPopupMenu)popupMenu, (String)"NLD_LAST_ROOT");
        if (lastRoot != null) {
            if (this.rootsStack == null || this.rootsStack.isEmpty()) {
                lastRoot.setEnabled(false);
            } else {
                lastRoot.setEnabled(true);
            }
        }
        if ((setRoot = MenuUtilities.getMenuItem((JPopupMenu)popupMenu, (String)"NLD_SET_ROOT")) != null) {
            if (this.mouseContext >= 0 && this.mouseContext < this.nodeDataFilter.getNumberObservations(-1)) {
                Object n = this.getNodeId(this.mouseContext);
                ArrayList children = this.getChildren(n);
                if (!this.rootNodeId.equals(n) && children != null && children.size() > 0) {
                    setRoot.setEnabled(true);
                } else {
                    setRoot.setEnabled(false);
                }
            } else {
                setRoot.setEnabled(false);
            }
        }
        if ((showAllNodes = MenuUtilities.getMenuItem((JPopupMenu)popupMenu, (String)"NLD_SHOW_ALL_NODES")) != null) {
            if (this.treeLayout == 5) {
                showAllNodes.setEnabled(false);
            } else {
                showAllNodes.setEnabled(true);
            }
        }
        if ((zoomMenuItem = MenuUtilities.getSubMenu((JPopupMenu)popupMenu, (String)"ZOOM_DROPDOWN")) != null) {
            if (this.treeLayout == 5 || this.treeLayout == 4) {
                zoomMenuItem.setEnabled(false);
            } else {
                zoomMenuItem.setEnabled(true);
            }
        }
        if ((zoomMenuItemInActionMenu = MenuUtilities.getMenuItem((JPopupMenu)popupMenu, (String)"ACTION_MODE_ZOOM")) != null) {
            if (this.treeLayout == 5 || this.treeLayout == 4) {
                JMenuItem selectMenuItem = MenuUtilities.getMenuItem((JPopupMenu)popupMenu, (String)"ACTION_MODE_SELECT");
                if (zoomMenuItemInActionMenu != null && zoomMenuItemInActionMenu.isSelected()) {
                    selectMenuItem.setSelected(true);
                    this.setActionMode(6);
                }
                zoomMenuItemInActionMenu.setEnabled(false);
            } else {
                zoomMenuItemInActionMenu.setEnabled(true);
            }
        }
    }

    public void setZoomScale(double zoomScale) {
        if (zoomScale * (double)this.preferredWidth < 1.0 || zoomScale * (double)this.preferredHeight < 1.0) {
            return;
        }
        this.setZoomFitType(-1);
        this.zoomScale = zoomScale;
        this.reInitZoomScale = true;
    }

    public double getZoomScale() {
        return this.zoomScale;
    }

    private void updateZoomDynamicLabel() {
        JMenuItem mi = MenuUtilities.getMenuItem((JPopupMenu)this.popUpMenu, (String)"DYNAMIC_LABEL");
        mi.setText(new String("" + (int)Math.max(1.0, this.zoomScale * 100.0) + "%"));
    }

    private void setZoomRadioStatus() {
        if (this.actionMode == 3 && !this.zoomValueSelected) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"CUSTOM_ZOOM", (boolean)true);
            this.updateZoomDynamicLabel();
            return;
        }
        if (this.zoomFitType == 0) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"FIT_TO_PAGE", (boolean)true);
        } else if (this.zoomFitType == 1) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"FIT_TO_WIDTH", (boolean)true);
        } else if (this.zoomFitType == 2) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"FIT_TO_HEIGHT", (boolean)true);
        } else if (this.zoomScale == 0.1) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"ZOOM_10PERCENT", (boolean)true);
        } else if (this.zoomScale == 0.25) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"ZOOM_25PERCENT", (boolean)true);
        } else if (this.zoomScale == 0.5) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"ZOOM_50PERCENT", (boolean)true);
        } else if (this.zoomScale == 1.0) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"ZOOM_100PERCENT", (boolean)true);
        } else if (this.zoomScale == 1.25) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"ZOOM_125PERCENT", (boolean)true);
        } else if (this.zoomScale == 1.5) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"ZOOM_150PERCENT", (boolean)true);
        } else if (this.zoomScale == 2.0) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"ZOOM_200PERCENT", (boolean)true);
        } else if (this.zoomScale == 4.0) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"ZOOM_400PERCENT", (boolean)true);
        } else {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popUpMenu, (String)"CUSTOM_ZOOM", (boolean)true);
        }
        this.updateZoomDynamicLabel();
    }

    protected JPopupMenu buildPopupMenu() {
        if (this.popUpMenu == null) {
            this.popUpMenu = MenuUtilities.getPopupMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/OrgChartComponentMenu.xml"), (ActionListener)this);
        }
        this.setZoomRadioStatus();
        return this.popUpMenu;
    }

    protected void select(int mouseEventType, int mx, int my, int modifier) {
        switch (mouseEventType) {
            case 2: {
                int obs;
                boolean ctrlPressed;
                boolean bl = ctrlPressed = (modifier & 2) != 0;
                if (!ctrlPressed) {
                    this.nodeDataFilter.unselectAll();
                }
                if ((obs = this.pick(mx, my)) >= 0 && obs < this.nodeDataFilter.getNumberObservations(-1)) {
                    if (ctrlPressed) {
                        this.nodeDataFilter.setSelected((long)obs, !this.nodeDataFilter.isSelected((long)obs));
                    } else {
                        this.nodeDataFilter.setSelected((long)obs, true);
                    }
                    this.fireDrillDownEvent(obs, false);
                }
                this.repaint();
                break;
            }
        }
    }

    protected void pan(int mouseEventType, int mx, int my) {
        switch (mouseEventType) {
            case 1: {
                int level;
                this.lastMouseX = this.mouseDownX = mx;
                this.lastMouseY = this.mouseDownY = my;
                int handle = this.getHandleAt(mx, my);
                int y = this.mouseDownY + this.origin.y;
                if (this.treeLayout != 5 && this.treeLayout != 4 || this.lensValues[level = this.getLevelAtPosition(y)] == 1.0 || this.nodeDataFilter == null || handle >= 0) break;
                this.setCursor(this.moveClosedCursor);
                break;
            }
            case 2: 
            case 3: {
                int dx = mx - this.lastMouseX;
                int dy = my - this.lastMouseY;
                if (this.treeLayout == 5 || this.treeLayout == 4) {
                    int y = this.mouseDownY + this.origin.y;
                    int level = this.getLevelAtPosition(y);
                    if (this.lensValues[level] == 1.0) break;
                    int n = level;
                    this.lensLocs[n] = this.lensLocs[n] - (double)dx;
                    this.adjustOtherLenses(level, dx);
                    this.updateLensMetadata();
                    this.backBufferValid = false;
                    this.repaint();
                } else if (this.scaledPreferredWidth > this.compWidth || this.scaledPreferredHeight > this.compHeight) {
                    this.moveOrigin(-dx, -dy, true);
                }
                this.lastMouseX = mx;
                this.lastMouseY = my;
                if (mouseEventType != 2) break;
                this.setCursor(this.moveOpenCursor);
            }
        }
    }

    protected void zoom(int mouseEventType, int mx, int my) {
        switch (mouseEventType) {
            case 1: {
                this.lastMouseX = this.mouseDownX = mx;
                this.lastMouseY = this.mouseDownY = my;
                break;
            }
            case 2: 
            case 3: {
                int dy = my - this.lastMouseY;
                this.zoomValueSelected = false;
                if (Math.abs(dy) < 5) {
                    return;
                }
                double zs = this.zoomScale * (1.0 - 1.5 * (double)dy / (double)this.compHeight);
                if (zs * (double)this.preferredWidth > 1.0 && zs * (double)this.preferredHeight > 1.0) {
                    this.zoomScale = zs;
                    this.updateView(false, false);
                }
                this.zoomFitType = -1;
                this.lastMouseX = mx;
                this.lastMouseY = my;
                if (mouseEventType != 2) break;
                this.setCursor(this.zoomCursor);
            }
        }
    }

    protected void adjustOtherLenses(int level, int dx) {
        if (this.xRanges[level][0] == this.xRanges[level][1]) {
            return;
        }
        if (this.treeLayout == 4) {
            int i;
            double percentageScrolled = (double)dx * 1.0 / (this.xRanges[level][1] - this.xRanges[level][0]);
            for (i = 1; i <= this.treeDepth; ++i) {
                if (i == level || this.xRanges[i][0] == this.xRanges[i][1]) continue;
                double d = percentageScrolled * (this.xRanges[i][1] - this.xRanges[i][0]);
                int n = i;
                this.lensLocs[n] = this.lensLocs[n] - d;
            }
            for (i = 1; i <= this.treeDepth; ++i) {
                double halfLinearScreenArea = (this.screenLinearArea[i][1] - this.screenLinearArea[i][0]) / 2.0;
                double lmn = this.xRanges[i][0] + halfLinearScreenArea + (this.computeNodeShellSize() - (double)this.maxWidth);
                double lmx = this.xRanges[i][1] - halfLinearScreenArea - (this.computeNodeShellSize() - (double)this.maxWidth);
                this.lensLocs[i] = Math.max(lmn, Math.min(this.lensLocs[i], lmx));
            }
        } else if (this.treeLayout == 5) {
            double halfLinearScreenArea = (this.screenLinearArea[level][1] - this.screenLinearArea[level][0]) / 2.0;
            double lmn = this.xRanges[level][0] + halfLinearScreenArea + (this.computeNodeShellSize() - (double)this.maxWidth);
            double lmx = this.xRanges[level][1] - halfLinearScreenArea - (this.computeNodeShellSize() - (double)this.maxWidth);
            this.lensLocs[level] = Math.max(lmn, Math.min(this.lensLocs[level], lmx));
        }
    }

    protected void buildMetaData() {
        int i;
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        Object parentIdVar = this.roleManager.getVariable((Object)this.nodeParentIDRole, 0);
        Object fromVar = this.getFromVar();
        Object toVar = this.getToVar();
        if (this.nodeDataFilter == null || idVar == null || fromVar == null || toVar == null) {
            return;
        }
        if (this.idToIndexMap == null) {
            this.idToIndexMap = new Hashtable();
        }
        this.idToIndexMap.clear();
        int idVarIndex = this.nodeDataFilter.getVariableIndex(idVar);
        for (i = 0; i < this.nodeDataFilter.getNumberObservations(-1); ++i) {
            Object o = this.nodeDataFilter.getValue(idVarIndex, (long)i);
            if (o == null || this.idToIndexMap.containsKey(o)) continue;
            this.idToIndexMap.put(o, new Integer(i));
        }
        if (parentIdVar == null && this.linkDataFilter != null) {
            if (this.idToIndexMapInLinkModel == null) {
                this.idToIndexMapInLinkModel = new Hashtable();
            }
            this.idToIndexMapInLinkModel.clear();
            int toVarIndex = this.linkDataFilter.getVariableIndex(toVar);
            block1: for (int i2 = 0; i2 < this.nodeDataFilter.getNumberObservations(-1); ++i2) {
                Object o = this.nodeDataFilter.getValue(idVarIndex, (long)i2);
                if (o == null) continue;
                for (int j = 0; j < this.linkDataFilter.getNumberObservations(-1); ++j) {
                    Object to = this.linkDataFilter.getValue(toVarIndex, (long)j);
                    if (!o.equals(to) || this.idToIndexMapInLinkModel.containsKey(o)) continue;
                    this.idToIndexMapInLinkModel.put(o, new Integer(j));
                    continue block1;
                }
            }
        }
        if (this.xPosition == null || this.xPosition.length != this.nodeDataFilter.getNumberObservations(-1)) {
            this.xPosition = new int[this.nodeDataFilter.getNumberObservations(-1)];
        }
        if (this.yPosition == null || this.yPosition.length != this.nodeDataFilter.getNumberObservations(-1)) {
            this.yPosition = new int[this.nodeDataFilter.getNumberObservations(-1)];
        }
        if (this.collapsed == null || this.collapsed.length != this.nodeDataFilter.getNumberObservations(-1)) {
            this.collapsed = new boolean[this.nodeDataFilter.getNumberObservations(-1)];
        }
        if (this.visible == null || this.visible.length != this.nodeDataFilter.getNumberObservations(-1)) {
            this.visible = new boolean[this.nodeDataFilter.getNumberObservations(-1)];
        }
        this.locateRoot();
        for (i = 0; i < this.nodeDataFilter.getNumberObservations(-1); ++i) {
            Object o = this.getNodeId(i);
            this.visible[i] = this.getParentNodeId(this.getNodeId(i)) != null || this.areEqual(o, this.rootNodeId);
        }
    }

    protected void buildLensMetaData() {
        if (this.treeLayout == 4 || this.treeLayout == 5) {
            if (this.treeDepthChanged || this.depthList == null) {
                this.buildDepthList();
            }
            if (this.depthList == null) {
                return;
            }
            this.lensValues = new double[this.treeDepth + 1];
            for (int i = 0; i <= this.treeDepth; ++i) {
                int num = this.depthList[i].size();
                double levelWidth = this.computeLevelWidth(num);
                if (levelWidth > (double)this.compWidth) {
                    double scaledWidth = Math.max(1.0, levelWidth / (double)this.compWidth);
                    this.lensValues[i] = Math.pow(scaledWidth, 2.0);
                    continue;
                }
                this.lensValues[i] = 1.0;
            }
            if (this.lensLocs == null || this.lensLocs.length != this.treeDepth + 1) {
                this.lensLocs = new double[this.treeDepth + 1];
            }
            if (this.lensScreenLocs == null || this.lensScreenLocs.length != this.treeDepth + 1) {
                this.lensScreenLocs = new double[this.treeDepth + 1];
            }
            if (this.worldLinearArea == null || this.worldLinearArea.length != this.treeDepth + 1) {
                this.worldLinearArea = new double[this.treeDepth + 1][2];
                this.screenLinearArea = new double[this.treeDepth + 1][2];
            }
            this.linearNodeStart = new int[this.treeDepth + 1];
            this.linearNodeEnd = new int[this.treeDepth + 1];
        }
    }

    protected void locateRoot() {
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        Object fromVar = this.getFromVar();
        Object toVar = this.getToVar();
        if (this.nodeDataFilter == null || idVar == null || fromVar == null || toVar == null) {
            return;
        }
        int idVarIndex = this.nodeDataFilter.getVariableIndex(idVar);
        for (int i = 0; i < this.nodeDataFilter.getNumberObservations(-1); ++i) {
            Object nId = this.nodeDataFilter.getValue(idVarIndex, (long)i);
            Object pId = this.getParentNodeId(nId);
            if (pId != null && this.getNodeIndex(pId) >= 0) continue;
            this.rootNodeId = nId;
            break;
        }
        if (this.focusNodeId == null) {
            this.focusNodeId = this.rootNodeId;
        }
    }

    protected double computeLevelWidth(int num) {
        return (double)(num - 1) * this.computeNodeShellSize() + (double)this.maxWidth;
    }

    protected double computeNodeShellSize() {
        return (double)this.maxWidth * 1.1;
    }

    protected void computeTreeDepth() {
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        Object fromVar = this.getFromVar();
        Object toVar = this.getToVar();
        if (this.nodeDataFilter == null || idVar == null || fromVar == null || toVar == null) {
            return;
        }
        this.treeDepth = 0;
        this.absoluteTreeDepth = 0;
        int idVarIndex = this.nodeDataFilter.getVariableIndex(idVar);
        for (int i = 0; i < this.nodeDataFilter.getNumberObservations(-1); ++i) {
            Object nId = this.nodeDataFilter.getValue(idVarIndex, (long)i);
            Object pIdWrtOrigRoot = this.getParentNodeIdWrtOrigRoot(nId);
            if (pIdWrtOrigRoot != null) {
                int nodeRealDepth = this.getAbsoluteDepth(nId);
                this.absoluteTreeDepth = Math.max(this.absoluteTreeDepth, nodeRealDepth);
            }
            Object pId = this.getParentNodeId(nId);
            if (pId == null) continue;
            int nodeDepth = this.getDepth(nId);
            if (!this.isNodeVisible(i) || this.isCollapsed(this.getNodeIndex(pId))) continue;
            this.treeDepth = Math.max(this.treeDepth, nodeDepth);
        }
        this.reinitColorRamp = true;
        this.initColorRamp();
    }

    protected void buildTree() {
        if (this.treeDepthChanged) {
            this.computeTreeDepth();
            this.computeSizes();
        }
        this.buildLensMetaData();
        this.layoutTree();
        this.treeDepthChanged = false;
    }

    public int getTreeLayout() {
        return this.treeLayout;
    }

    public void setTreeLayout(String layoutName) {
        if (layoutName == null) {
            return;
        }
        if ((layoutName = layoutName.toLowerCase()).equalsIgnoreCase("verthorz") || layoutName.equalsIgnoreCase("stackedleaves")) {
            this.setTreeLayout(3);
        } else if (layoutName.startsWith("expl")) {
            this.setTreeLayout(0);
        } else if (layoutName.startsWith("horiz")) {
            this.setTreeLayout(2);
        } else if (layoutName.startsWith("vert")) {
            this.setTreeLayout(1);
        } else if (layoutName.startsWith("lensfulltree")) {
            this.setTreeLayout(4);
        } else if (layoutName.startsWith("lenssubtree")) {
            this.setTreeLayout(5);
        } else if (layoutName.startsWith("listview")) {
            this.setTreeLayout(6);
        }
    }

    public void setTreeLayout(int layout) {
        if (layout == this.treeLayout) {
            return;
        }
        if (this.focusNodeId != null) {
            this.oldLayoutFocusNodeIdx = this.getNodeIndex(this.focusNodeId);
        }
        this.treeLayout = layout;
        switch (layout) {
            default: {
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                this.backToOriginalRoot(false);
                this.orthogonalLinks = true;
                break;
            }
            case 5: {
                this.backToOriginalRoot(false);
                if (this.isCollapsed(this.getNodeIndex(this.rootNodeId))) {
                    this.expandTree(0);
                } else {
                    this.expandTree(1);
                }
                this.orthogonalLinks = true;
                this.zoomScale = 1.0;
                this.setZoomFitType(-1);
                break;
            }
            case 4: {
                this.backToOriginalRoot(true);
                this.orthogonalLinks = false;
                this.zoomScale = 1.0;
                this.setZoomFitType(-1);
            }
        }
        if (this.popupMenu != null) {
            switch (this.treeLayout) {
                case 0: {
                    MenuUtilities.setMenuItemSelected((JPopupMenu)this.popupMenu, (String)"TREE_LAYOUT_EXPLORER", (boolean)true);
                    break;
                }
                case 1: {
                    MenuUtilities.setMenuItemSelected((JPopupMenu)this.popupMenu, (String)"TREE_LAYOUT_VERTICAL", (boolean)true);
                    break;
                }
                case 2: {
                    MenuUtilities.setMenuItemSelected((JPopupMenu)this.popupMenu, (String)"TREE_LAYOUT_HORIZONTAL", (boolean)true);
                    break;
                }
                case 3: {
                    MenuUtilities.setMenuItemSelected((JPopupMenu)this.popupMenu, (String)"TREE_LAYOUT_STACKED_LEAVES", (boolean)true);
                    break;
                }
                case 6: {
                    MenuUtilities.setMenuItemSelected((JPopupMenu)this.popupMenu, (String)"TREE_LAYOUT_LIST_VIEW", (boolean)true);
                    break;
                }
                case 4: {
                    MenuUtilities.setMenuItemSelected((JPopupMenu)this.popupMenu, (String)"TREE_LAYOUT_LENS_FULL_TREE", (boolean)true);
                    break;
                }
                case 5: {
                    MenuUtilities.setMenuItemSelected((JPopupMenu)this.popupMenu, (String)"TREE_LAYOUT_LENS_SUB_TREE", (boolean)true);
                }
            }
        }
        this.treeDepthChanged = true;
        if (!this.isRebuildRequired()) {
            this.computeNodeSizes();
            this.updateView(true, true);
        }
        this.setFocusNode(this.rootNodeId);
        this.repaint();
        this.breadthOrderBuilt = false;
    }

    protected void computeNodeSizes() {
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        Object labelVar = this.roleManager.getVariable((Object)this.nodeLabelRole, 0);
        if (idVar == null && labelVar == null || this.nodeDataFilter == null) {
            return;
        }
        int labelVarIndex = -1;
        labelVarIndex = labelVar != null ? this.nodeDataFilter.getVariableIndex(labelVar) : this.nodeDataFilter.getVariableIndex(idVar);
        this.maxHeight = 0;
        this.maxWidth = 0;
        for (int i = 0; i < this.nodeDataFilter.getNumberObservations(-1); ++i) {
            Object l = this.nodeDataFilter.getValue(labelVarIndex, (long)i);
            if (l == null) continue;
            if (this.sizeNodesToFitText) {
                this.maxWidth = Math.max(this.maxWidth, this.getNodeWidth(l.toString(), this.getGraphics()));
            }
            this.maxHeight = Math.max(this.maxHeight, this.getNodeHeight(l.toString(), this.getGraphics()));
        }
        this.maxWidth = this.sizeNodesToFitText ? Math.min(169, this.maxWidth) : 169;
        int handleIconWidth = this.expandIcon.getWidth(this);
        int handleIconHeight = this.expandIcon.getHeight(this);
        switch (this.treeLayout) {
            case 2: {
                this.maxWidth += (handleIconWidth > handleIconHeight ? handleIconWidth : handleIconHeight) + 4;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.maxHeight += (handleIconWidth > handleIconHeight ? handleIconWidth : handleIconHeight) + 4;
            }
        }
    }

    protected void computeSizes() {
        this.preferredHeight = 0;
        this.preferredWidth = 0;
        switch (this.treeLayout) {
            case 2: {
                if (this.vspaces == null || this.vspaces.length != this.treeDepth + 1) {
                    this.vspaces = new int[this.treeDepth + 1];
                    this.hspaces = new int[this.treeDepth + 1];
                }
                this.vspaces[0] = 5;
                this.hspaces[0] = 5;
                for (int i = 1; i <= this.treeDepth; ++i) {
                    this.vspaces[i] = this.vspaces[i - 1] + this.maxHeight + 8;
                    this.hspaces[i] = this.hspaces[i - 1] + 15 + 24;
                }
                this.preferredWidth = this.hspaces[this.treeDepth] + 15 + this.maxWidth / 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (this.vspaces == null || this.vspaces.length != this.treeDepth + 1) {
                    this.vspaces = new int[this.treeDepth + 1];
                    this.hspaces = new int[this.treeDepth + 1];
                }
                this.vspaces[0] = 0;
                this.hspaces[0] = 5;
                for (int i = 1; i <= this.treeDepth; ++i) {
                    this.vspaces[i] = this.vspaces[i - 1] + this.maxHeight * 2 + 15;
                    this.hspaces[i] = 5;
                }
                this.preferredHeight = this.vspaces[this.treeDepth] + this.maxHeight * 2 + 15;
            }
        }
    }

    protected void buildDepthList() {
        int i;
        Object idVar = this.roleManager.getVariable((Object)RoleInterface.ROLE_NODE_ID);
        if (this.nodeDataFilter == null || idVar == null) {
            return;
        }
        if (!this.breadthOrderBuilt) {
            this.buildBreadthFirstOrderList();
        }
        if (this.depthList == null || this.depthList.length != this.treeDepth + 1) {
            this.depthList = new ArrayList[this.treeDepth + 1];
            for (i = 0; i <= this.treeDepth; ++i) {
                int size = 1;
                if (i > 0) {
                    size = 10;
                }
                this.depthList[i] = new ArrayList(size);
            }
        } else {
            for (i = 0; i <= this.treeDepth; ++i) {
                this.depthList[i].clear();
            }
        }
        for (i = 0; i < this.breadthIndexOrdering.size(); ++i) {
            int depth;
            Integer I = new Integer(i);
            Object nId = this.breadthIndexOrdering.get(I);
            if (!this.isNodeVisible(this.getNodeIndex(nId)) || (depth = this.getDepth(nId)) < 0 || depth > this.treeDepth) continue;
            this.depthList[depth].add(nId);
        }
    }

    protected void layoutTree() {
        switch (this.treeLayout) {
            case 2: {
                this.preferredHeight = 0;
                this.doHorizontalPositioning(this.rootNodeId, this.vspaces[0]);
                break;
            }
            default: {
                this.preferredWidth = 0;
                this.doVerticalPositioning(this.rootNodeId, 5, new Vector(), 0);
                break;
            }
            case 6: {
                this.preferredWidth = 0;
                this.doListViewPositioning(this.rootNodeId, 5, new Vector(), 0);
                break;
            }
            case 4: 
            case 5: {
                this.initXRanges();
                this.doFullTreeLensPositioning();
                this.preferredWidth = this.compWidth;
                this.updateLensMetadata();
            }
        }
    }

    protected void updateLensMetadata() {
        int i;
        if (this.screenLinearArea == null) {
            return;
        }
        for (i = 0; i <= this.treeDepth; ++i) {
            int fullSizeNodes = (int)Math.floor(((double)(this.compWidth - 10) - this.computeNodeShellSize()) / this.computeNodeShellSize());
            double dx = (double)fullSizeNodes * this.computeNodeShellSize();
            this.screenLinearArea[i][0] = this.lensScreenLocs[i] - dx / 2.0;
            this.screenLinearArea[i][1] = this.lensScreenLocs[i] + dx / 2.0;
        }
        for (i = 0; i <= this.treeDepth; ++i) {
            double halfLinearScreenArea = (this.screenLinearArea[i][1] - this.screenLinearArea[i][0]) / 2.0;
            this.worldLinearArea[i][0] = this.lensLocs[i] - halfLinearScreenArea;
            this.worldLinearArea[i][1] = this.lensLocs[i] + halfLinearScreenArea;
        }
        block2: for (i = 0; i <= this.treeDepth; ++i) {
            int xpos;
            int nodeIndex;
            int j;
            if (this.depthList[i].size() == 0) continue;
            this.linearNodeEnd[i] = 0;
            this.linearNodeStart[i] = 0;
            for (j = 0; j < this.depthList[i].size(); ++j) {
                nodeIndex = this.getNodeIndex(this.depthList[i].get(j));
                xpos = this.getXPosition(nodeIndex);
                if (!((double)xpos >= this.worldLinearArea[i][0])) continue;
                this.linearNodeStart[i] = j;
                break;
            }
            for (j = this.depthList[i].size() - 1; j >= 0; --j) {
                nodeIndex = this.getNodeIndex(this.depthList[i].get(j));
                xpos = this.getXPosition(nodeIndex);
                if (!((double)xpos < this.worldLinearArea[i][1])) continue;
                this.linearNodeEnd[i] = j;
                continue block2;
            }
        }
    }

    protected int getLabelHeight(String label) {
        if (label == null) {
            return 0;
        }
        int textLines = this.getNumberOfTextLines(label);
        switch (textLines) {
            default: {
                return 21;
            }
            case 2: {
                return 34;
            }
            case 3: {
                return 47;
            }
            case 4: {
                return 60;
            }
            case 5: 
        }
        return 73;
    }

    protected void doListViewPositioning(Object nodeId, int minX, Vector left, int nextLeave) {
        Object nId;
        Integer xloc;
        int temp;
        boolean flip;
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        if (idVar == null || this.nodeDataFilter == null) {
            return;
        }
        int idVarIndex = this.nodeDataFilter.getVariableIndex(idVar);
        int depth = this.getDepth(nodeId);
        if (depth < 0) {
            return;
        }
        int xval = minX;
        int yval = this.vspaces[depth];
        int nodeIndex = this.getNodeIndex(nodeId);
        if (depth == 0) {
            if (left == null) {
                left = new Vector<Integer>();
            } else {
                left.removeAllElements();
            }
            left.setSize(this.treeDepth + 1);
        }
        ArrayList visibleChildren = this.getVisibleChildren(nodeId, this.children);
        int nk = 0;
        if (visibleChildren != null) {
            nk = visibleChildren.size();
        }
        if (left.get(depth) != null) {
            xval = ((Number)left.get(depth)).intValue();
            xval += this.maxWidth / 2;
        } else {
            xval = this.hspaces[depth] + this.maxWidth / 2;
        }
        xval = Math.max(xval, minX);
        yval = this.vspaces[depth] + this.maxHeight;
        if (nk == 0 || this.isCollapsed(this.getNodeIndex(nodeId))) {
            xval = Math.max(xval, nextLeave + this.maxWidth / 2);
            this.setPosition(nodeIndex, xval, yval);
            nextLeave = xval += this.maxWidth / 2 + this.hspaces[depth];
            Integer xloc2 = new Integer(xval);
            left.setElementAt(xloc2, depth);
            if (xval > this.preferredWidth) {
                this.preferredWidth = xval;
            }
            return;
        }
        int subleft = 0;
        int subright = 0;
        yval = this.vspaces[depth + 1];
        boolean bl = flip = this.treeLayout == 6;
        if (flip) {
            for (int k = 0; k < nk; ++k) {
                int ik = this.getNodeIndex(visibleChildren.get(k));
                Object nId2 = this.nodeDataFilter.getValue(idVarIndex, (long)ik);
                ArrayList vc = this.getChildren(nId2);
                if (vc == null || vc.size() <= 0 && !this.isCollapsed(ik) && !this.hasChildren(ik)) continue;
                flip = false;
                break;
            }
        }
        if (flip) {
            if (left.size() < depth + 1 + nk) {
                left.setSize(depth + 1 + nk);
            }
            if (left.get(depth) != null) {
                xval = ((Number)left.get(depth)).intValue();
                xval += this.maxWidth / 2;
            }
            for (int ii = 0; ii < nk; ++ii) {
                if (left.get(depth + ii + 1) == null) continue;
                temp = ((Number)left.get(depth + ii + 1)).intValue();
                xval = Math.max(xval, temp += this.maxWidth / 2);
            }
            xval = Math.max(xval, minX);
            int kl = depth + 1;
            yval = this.vspaces[kl];
            xloc = new Integer(xval + this.maxWidth / 2 + this.hspaces[depth]);
            for (int k = 0; k < nk; ++k) {
                nId = visibleChildren.get(k);
                int cIndex = this.getNodeIndex(nId);
                String l = this.getNodeLabel(cIndex);
                int labelH = this.getLabelHeight(l);
                this.setPosition(cIndex, xval, yval);
                yval += labelH + 2;
                left.setElementAt(xloc, depth + k + 1);
            }
            temp = yval;
            if (temp > this.preferredHeight) {
                this.preferredHeight = temp;
            }
        } else {
            int newmin = xval - (nk - 1) * (this.maxWidth / 2 + this.hspaces[depth]);
            newmin = Math.max(newmin, this.maxWidth / 2 + this.hspaces[depth]);
            for (int k = 0; k < nk; ++k) {
                nId = visibleChildren.get(k);
                this.doListViewPositioning(nId, newmin, left, nextLeave);
                if (k != 0 && k != nk - 1) continue;
                if (k == 0) {
                    subleft = this.getXPosition(this.getNodeIndex(nId));
                }
                if (k != nk - 1) continue;
                subright = this.getXPosition(this.getNodeIndex(nId));
            }
            xval = Math.max(xval, (subleft + subright) / 2);
            xloc = new Integer(Math.max(xval + this.maxWidth / 2, subright + this.maxWidth / 2) + this.hspaces[depth]);
        }
        temp = xloc;
        if (temp > this.preferredWidth) {
            this.preferredWidth = temp;
        }
        if ((temp = yval + this.maxHeight + 5) > this.preferredHeight) {
            this.preferredHeight = temp;
        }
        left.setElementAt(xloc, depth);
        yval = this.vspaces[depth] + this.maxHeight;
        this.setPosition(nodeIndex, xval, yval);
    }

    protected void doVerticalPositioning(Object nodeId, int minX, Vector left, int nextLeave) {
        Integer xloc;
        int temp;
        boolean flip;
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        if (idVar == null || this.nodeDataFilter == null) {
            return;
        }
        int idVarIndex = this.nodeDataFilter.getVariableIndex(idVar);
        int depth = this.getDepth(nodeId);
        if (depth < 0) {
            return;
        }
        int xval = minX;
        int yval = this.vspaces[depth];
        int nodeIndex = this.getNodeIndex(nodeId);
        if (depth == 0) {
            if (left == null) {
                left = new Vector<Integer>();
            } else {
                left.removeAllElements();
            }
            left.setSize(this.treeDepth + 1);
        }
        ArrayList visibleChildren = this.getVisibleChildren(nodeId, this.children);
        int nk = 0;
        if (visibleChildren != null) {
            nk = visibleChildren.size();
        }
        if (left.get(depth) != null) {
            xval = ((Number)left.get(depth)).intValue();
            xval += this.maxWidth / 2;
        } else {
            xval = this.hspaces[depth] + this.maxWidth / 2;
        }
        xval = Math.max(xval, minX);
        yval = this.vspaces[depth] + this.maxHeight;
        if (nk == 0 || this.isCollapsed(this.getNodeIndex(nodeId))) {
            xval = Math.max(xval, nextLeave + this.maxWidth / 2);
            this.setPosition(nodeIndex, xval, yval);
            nextLeave = xval += this.maxWidth / 2 + this.hspaces[depth];
            Integer xloc2 = new Integer(xval);
            left.setElementAt(xloc2, depth);
            if (xval > this.preferredWidth) {
                this.preferredWidth = xval;
            }
            return;
        }
        int subleft = 0;
        int subright = 0;
        yval = this.vspaces[depth + 1];
        boolean bl = flip = this.treeLayout == 3;
        if (flip) {
            for (int k = 0; k < nk; ++k) {
                int ik = this.getNodeIndex(visibleChildren.get(k));
                Object nId = this.nodeDataFilter.getValue(idVarIndex, (long)ik);
                ArrayList vc = this.getChildren(nId);
                if (vc == null || vc.size() <= 0 && !this.isCollapsed(ik) && !this.hasChildren(ik)) continue;
                flip = false;
                break;
            }
        }
        if (flip) {
            if (left.size() < depth + 1 + nk) {
                left.setSize(depth + 1 + nk);
            }
            if (left.get(depth) != null) {
                xval = ((Number)left.get(depth)).intValue();
                xval += this.maxWidth / 2;
            }
            for (int ii = 0; ii < nk; ++ii) {
                if (left.get(depth + ii + 1) == null) continue;
                temp = ((Number)left.get(depth + ii + 1)).intValue();
                xval = Math.max(xval, temp += this.maxWidth / 2);
            }
            xval = Math.max(xval, minX);
            int kl = depth + 1;
            int delta = this.maxHeight + 5;
            yval = this.vspaces[kl] + this.maxHeight / 2 + 10;
            xloc = new Integer(xval + this.maxWidth / 2 + this.hspaces[depth]);
            for (int k = 0; k < nk; ++k) {
                Object nId = visibleChildren.get(k);
                int cIndex = this.getNodeIndex(nId);
                this.setPosition(cIndex, xval, yval + delta * k);
                left.setElementAt(xloc, depth + k + 1);
            }
            temp = yval + delta * nk;
            if (temp > this.preferredHeight) {
                this.preferredHeight = temp;
            }
        } else {
            int newmin = xval - (nk - 1) * (this.maxWidth / 2 + this.hspaces[depth]);
            newmin = Math.max(newmin, this.maxWidth / 2 + this.hspaces[depth]);
            Number d = (Number)left.elementAt(depth);
            Number d1 = (Number)left.elementAt(depth + 1);
            int dv = 0;
            int dv1 = 0;
            if (d != null) {
                dv = d.intValue();
            }
            if (d1 != null) {
                dv1 = d1.intValue();
            }
            int max = Math.max(dv, dv1);
            left.setElementAt(new Integer(max), depth + 1);
            for (int k = 0; k < nk; ++k) {
                Object nId = visibleChildren.get(k);
                this.doVerticalPositioning(nId, newmin, left, nextLeave);
                if (k != 0 && k != nk - 1) continue;
                if (k == 0) {
                    subleft = this.getXPosition(this.getNodeIndex(nId));
                }
                if (k != nk - 1) continue;
                subright = this.getXPosition(this.getNodeIndex(nId));
            }
            xval = Math.max(xval, (subleft + subright) / 2);
            xloc = new Integer(Math.max(xval + this.maxWidth / 2, subright + this.maxWidth / 2) + this.hspaces[depth]);
        }
        temp = xloc;
        if (temp > this.preferredWidth) {
            this.preferredWidth = temp;
        }
        if ((temp = yval + this.maxHeight + 5) > this.preferredHeight) {
            this.preferredHeight = temp;
        }
        left.setElementAt(xloc, depth);
        yval = this.vspaces[depth] + this.maxHeight;
        this.setPosition(nodeIndex, xval, yval);
    }

    protected int doHorizontalPositioning(Object nodeId, int yPos) {
        int nodeIndex = this.getNodeIndex(nodeId);
        int depth = this.getDepth(nodeId);
        int level = depth;
        if (level < 0) {
            return yPos;
        }
        ArrayList visibleChildren = this.getVisibleChildren(nodeId);
        int nk = 0;
        if (visibleChildren != null) {
            nk = visibleChildren.size();
        }
        int yval = yPos + this.maxHeight / 2 + 4;
        int xval = this.hspaces[level] + 15 + 12 + this.maxWidth / 2;
        this.setPosition(nodeIndex, xval, yval);
        if (nk == 0 || this.isCollapsed(nodeIndex)) {
            if ((yval += this.maxHeight / 2) > this.preferredHeight) {
                this.preferredHeight = yval + 4;
            }
            if ((xval += 15 + this.maxWidth / 2) > this.preferredWidth) {
                this.preferredWidth = xval;
            }
            return yval;
        }
        yval += this.maxHeight / 2 + 4;
        for (int k = 0; k < nk; ++k) {
            Object nId = visibleChildren.get(k);
            yval = this.doHorizontalPositioning(nId, yval);
        }
        return yval;
    }

    protected void initXRanges() {
        if (this.xRanges == null || this.xRanges.length != this.treeDepth + 1) {
            this.xRanges = new double[this.treeDepth + 1][2];
        }
        for (int i = 0; i <= this.treeDepth; ++i) {
            this.xRanges[i][0] = this.compWidth;
            this.xRanges[i][1] = 0.0;
        }
    }

    protected void doFullTreeLensPositioning() {
        int i;
        if (this.depthList == null || this.depthList.length == 0) {
            return;
        }
        for (i = 0; i <= this.treeDepth; ++i) {
            ArrayList layer = this.depthList[i];
            int layerSize = layer.size();
            if (layerSize == 0) continue;
            int yval = this.vspaces[i] + this.maxHeight;
            double xval = 0.0;
            double levelWidth = this.computeLevelWidth(layerSize);
            if (levelWidth > (double)(this.compWidth - 10)) {
                xval = 5.0 + (double)this.maxWidth / 2.0;
                double step = this.computeNodeShellSize();
                for (int j = 0; j < layerSize; ++j) {
                    Object n = layer.get(j);
                    if (n == null) continue;
                    this.setPosition(this.getNodeIndex(n), (int)xval, yval);
                    this.xRanges[i][0] = Math.min(this.xRanges[i][0], xval);
                    this.xRanges[i][1] = Math.max(this.xRanges[i][1], xval);
                    xval += step;
                }
                continue;
            }
            double parentCenter = this.compWidth / 2;
            Object n = layer.get(0);
            Object parent = this.getParentNodeId(n);
            parentCenter = this.getXPosition(this.getNodeIndex(parent));
            xval = 0.0;
            xval = i == 0 ? (double)this.compWidth / 2.0 : (parentCenter - levelWidth / 2.0 < 5.0 ? 5.0 + (double)this.maxWidth / 2.0 : (parentCenter + levelWidth / 2.0 > (double)(this.compWidth - 5) ? (double)(this.compWidth - 5) - levelWidth + (double)this.maxWidth / 2.0 : parentCenter - levelWidth / 2.0 + (double)this.maxWidth / 2.0));
            for (int j = 0; j < layerSize; ++j) {
                n = layer.get(j);
                this.setPosition(this.getNodeIndex(n), (int)xval, yval);
                this.xRanges[i][0] = Math.min(this.xRanges[i][0], xval);
                this.xRanges[i][1] = Math.max(this.xRanges[i][1], xval);
                xval += this.computeNodeShellSize();
            }
        }
        for (i = 0; i <= this.treeDepth; ++i) {
            double cx;
            double dx = this.xRanges[i][1] - this.xRanges[i][0];
            this.lensLocs[i] = cx = this.xRanges[i][0] + dx / 2.0;
            double scale = dx / ((double)(this.compWidth - 10) - this.computeNodeShellSize());
            double startX = 5.0 + this.computeNodeShellSize() / 2.0;
            this.lensScreenLocs[i] = scale != 0.0 ? startX + (this.lensLocs[i] - this.xRanges[i][0]) / scale : (double)this.compWidth / 2.0;
        }
    }

    protected void centerNode(Object n, boolean fireEvent) {
        if (this.nodeDataFilter == null || n == null) {
            return;
        }
        int nIndex = this.getNodeIndex(n);
        if (nIndex < 0 || nIndex >= this.nodeDataFilter.getNumberObservations(-1)) {
            return;
        }
        if (!this.isNodeVisible(nIndex) && this.unhidePathToNode(n)) {
            this.buildTree();
        }
        int nx = this.getXPosition(nIndex);
        int ny = this.getYPosition(nIndex);
        switch (this.treeLayout) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                if (this.isNodeInView(n)) {
                    return;
                }
                if ((this.zoomFitType == 0 && this.zoomFitType == 1 && this.zoomFitType == 2 || !(this.zoomScale >= 1.0)) && this.zoomValueSelected) break;
                this.linearCenterView(nx, ny, fireEvent);
                break;
            }
            case 4: 
            case 5: {
                this.lensCenterView(n, nx, ny, fireEvent);
            }
        }
    }

    protected boolean isNodeInView(Object n) {
        if (this.nodeDataFilter == null || n == null) {
            return false;
        }
        int nIndex = this.getNodeIndex(n);
        if (nIndex < 0 || nIndex >= this.nodeDataFilter.getNumberObservations(-1)) {
            return false;
        }
        int nx = (int)((double)this.getXPosition(nIndex) * this.zoomScale);
        int ny = (int)((double)this.getYPosition(nIndex) * this.zoomScale);
        int ox = (int)((double)this.origin.x * this.zoomScale);
        int oy = (int)((double)this.origin.y * this.zoomScale);
        return nx >= ox && nx <= ox + this.compWidth && ny >= oy && ny <= oy + this.compHeight;
    }

    protected void lensCenterView(Object n, int nx, int ny, boolean fireEvent) {
        int level;
        ArrayList layer;
        int layerIndex;
        if (n == null) {
            return;
        }
        if (ny < this.origin.y || ny > this.origin.y + this.compHeight) {
            int cy = this.origin.y + this.compHeight / 2;
            int dy = ny - cy;
            this.moveOrigin(0, dy, false);
        }
        if ((layerIndex = (layer = this.depthList[level = this.getLevelAtPosition(ny)]).indexOf(n)) >= this.linearNodeStart[level] && layerIndex <= this.linearNodeEnd[level]) {
            return;
        }
        int dx = (int)(this.lensLocs[level] - (double)nx);
        this.lensLocs[level] = nx;
        this.adjustOtherLenses(level, dx);
        this.updateLensMetadata();
        if (fireEvent) {
            this.backBufferValid = false;
            this.repaint();
        }
    }

    protected void linearCenterView(int nx, int ny, boolean fireEvent) {
        int cx = (int)((double)this.origin.x * this.zoomScale) + this.compWidth / 2;
        int cy = (int)((double)this.origin.y * this.zoomScale) + this.compHeight / 2;
        int dx = (int)(((double)nx * this.zoomScale - (double)cx) / this.zoomScale);
        int dy = (int)(((double)ny * this.zoomScale - (double)cy) / this.zoomScale);
        this.moveOrigin(dx, dy, fireEvent);
    }

    public void setOrigin(int ox, int oy, boolean fireEvent) {
        double zs = 1.0;
        if (this.zoomScale < 1.0) {
            zs = this.zoomScale;
        }
        if (this.scaledPreferredWidth > this.compWidth) {
            if (ox < 0) {
                ox = 0;
            }
            if ((double)ox > (double)this.scaledPreferredWidth / zs - (double)this.compWidth) {
                ox = (int)((double)this.scaledPreferredWidth / zs - (double)this.compWidth);
            }
        } else {
            ox = 0;
        }
        if (this.scaledPreferredHeight > this.compHeight) {
            if (oy < 0) {
                oy = 0;
            }
            if ((double)oy > (double)this.scaledPreferredHeight / zs - (double)this.compHeight) {
                oy = (int)((double)this.scaledPreferredHeight / zs - (double)this.compHeight);
            }
        } else {
            oy = 0;
        }
        this.origin.x = ox;
        this.origin.y = oy;
        if (fireEvent) {
            this.changeSupport.firePropertyChange("resize", null, new Integer(this.treeLayout));
            this.backBufferValid = false;
            this.repaint();
        }
    }

    public void moveOrigin(int dx, int dy, boolean fireEvent) {
        this.setOrigin(this.origin.x + dx, this.origin.y + dy, fireEvent);
    }

    public void setViewContext(String nId, int viewXPos, int viewYPos) {
        if (nId == null) {
            return;
        }
        if (this.isRebuildRequired()) {
            this.viewContextNodeId = nId;
            this.viewContextXPos = viewXPos;
            this.viewContextYPos = viewYPos;
            return;
        }
        this.viewContextNodeId = null;
        int nodeIndex = this.getNodeIndex(nId);
        this.maintainViewContext(nodeIndex, viewXPos, viewYPos, false);
    }

    protected void maintainViewContext(int nodeIndex, int oldX, int oldY, boolean fireEvent) {
        if (this.scaledPreferredWidth <= this.compWidth && this.scaledPreferredHeight <= this.compHeight) {
            return;
        }
        if (nodeIndex < 0) {
            return;
        }
        double[] pt = this.project(this.getXPosition(nodeIndex), this.getYPosition(nodeIndex), null);
        double dx = pt[0] - (double)oldX;
        double dy = pt[1] - (double)oldY;
        this.moveOrigin((int)dx, (int)dy, fireEvent);
    }

    public RoleManager getRoleManager() {
        return this.roleManager;
    }

    protected void setFocusNode(Object nodeId) {
        this.focusNodeId = nodeId;
        this.centerNode(this.focusNodeId, false);
        this.changeSupport.firePropertyChange("resize", null, new Integer(this.treeLayout));
        this.backBufferValid = false;
        this.repaint();
    }

    protected int getStringWidth(String label, Graphics g) {
        if (label == null || g == null) {
            return 0;
        }
        FontMetrics fm = g.getFontMetrics();
        int width = 0;
        int textLines = this.getNumberOfTextLines(label);
        if (textLines > 1) {
            ArrayList v = OrgViewer.makeMultiLineStrings(label);
            for (int i = 0; i < v.size(); ++i) {
                String s = v.get(i).toString();
                Rectangle2D r = fm.getStringBounds(s, g);
                int w = (int)Math.ceil(r.getWidth());
                width = Math.max(width, w);
            }
        } else {
            Rectangle2D r = fm.getStringBounds(label, g);
            width = (int)Math.ceil(r.getWidth());
        }
        return width;
    }

    protected int getNodeWidth(String label, Graphics g) {
        if (label == null || g == null) {
            return 0;
        }
        int width = this.getStringWidth(label, g) + 8;
        if (this.drawIcon) {
            width += 32;
        }
        return width;
    }

    protected int getNodeHeight(String label, Graphics g) {
        if (label == null || g == null) {
            return 0;
        }
        int textLines = this.getNumberOfTextLines(label);
        switch (textLines) {
            default: {
                return 34;
            }
            case 3: {
                return 47;
            }
            case 4: {
                return 60;
            }
            case 5: 
        }
        return 73;
    }

    protected int getNumberOfTextLines(String label) {
        if (label == null) {
            return 0;
        }
        int numTextLines = 1;
        int startIndex = -1;
        String newLine = "\\n";
        String newLine2 = "\n";
        while ((startIndex = label.indexOf(newLine, startIndex + 1)) >= 0) {
            ++numTextLines;
        }
        if (numTextLines == 1) {
            while ((startIndex = label.indexOf(newLine2, startIndex + 1)) >= 0) {
                ++numTextLines;
            }
        }
        return numTextLines;
    }

    protected int getDepth(Object nodeId) {
        if (nodeId == null || this.rootNodeId == null) {
            return -1;
        }
        if (this.rootNodeId.equals(nodeId)) {
            return 0;
        }
        int depth = 1;
        Object parentId = this.getParentNodeId(nodeId);
        while (parentId != null && !this.rootNodeId.equals(parentId)) {
            parentId = this.getParentNodeId(parentId);
            ++depth;
        }
        return depth;
    }

    protected int getAbsoluteDepth(Object nodeId) {
        Object origRoot = null;
        origRoot = this.rootsStack != null && this.rootsStack.size() > 0 ? this.rootsStack.peek() : this.rootNodeId;
        if (nodeId == null || origRoot == null) {
            return -1;
        }
        int depth = 0;
        Object parentId = this.getParentNodeIdWrtOrigRoot(nodeId);
        while (parentId != null) {
            parentId = this.getParentNodeIdWrtOrigRoot(parentId);
            ++depth;
        }
        return depth;
    }

    protected double[] getBranchPosition(int nodeIndex, double[] pos) {
        if (this.xPosition == null || this.yPosition == null || nodeIndex < 0 || nodeIndex > this.xPosition.length) {
            return pos;
        }
        if (pos == null) {
            pos = new double[]{this.getXPosition(nodeIndex), (double)this.getYPosition(nodeIndex) + (double)this.maxHeight * 0.75 + 15.0};
        }
        return pos;
    }

    protected double[] getHandlePosition(int nodeIndex, double[] pos) {
        if (this.xPosition == null || this.yPosition == null || nodeIndex < 0 || nodeIndex > this.xPosition.length) {
            return null;
        }
        ArrayList children = this.getChildren(this.getNodeId(nodeIndex));
        if (!(this.hasChildren(nodeIndex) || children != null && children.size() != 0)) {
            return null;
        }
        if (pos == null) {
            pos = new double[2];
        }
        if (this.treeLayout == 2) {
            Object nodeId = this.getNodeId(nodeIndex);
            int nodeDepth = this.getDepth(nodeId);
            if (nodeDepth > this.treeDepth) {
                return null;
            }
            pos[0] = this.hspaces[nodeDepth];
            pos[1] = this.getYPosition(nodeIndex);
        } else {
            pos[0] = this.getXPosition(nodeIndex);
            pos[1] = (double)this.getYPosition(nodeIndex) + (double)this.maxHeight * 0.35;
        }
        return pos;
    }

    protected int getHandleAt(int x, int y) {
        switch (this.treeLayout) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                return this.linearGetHandleAt(x, y);
            }
            case 4: 
            case 5: {
                return this.lensGetHandleAt(x, y);
            }
        }
        return -1;
    }

    protected int lensGetHandleAt(int x, int y) {
        double[] t;
        int nIndex;
        int j;
        if (this.xPosition == null || this.yPosition == null) {
            return -1;
        }
        if (this.linearNodeStart == null || this.linearNodeEnd == null) {
            return -1;
        }
        int worldY = this.origin.y + y;
        int level = this.getLevelAtPosition(worldY);
        int handleIconWidth = 1;
        int handleIconHeight = 1;
        if (this.expandIcon != null) {
            handleIconWidth = this.expandIcon.getWidth(this);
            handleIconHeight = this.expandIcon.getHeight(this) / 2;
        }
        int halfHandleIconWidth = handleIconWidth / 2;
        int halfHandleIconHeight = handleIconHeight / 2;
        Rectangle r = new Rectangle(0, 0, (int)((double)handleIconWidth * this.zoomScale), (int)((double)handleIconHeight * this.zoomScale));
        double[] hloc = new double[2];
        double[] pt1 = new double[2];
        for (j = this.linearNodeStart[level]; j <= this.linearNodeEnd[level] && this.depthList[level] != null && this.depthList[level].size() != 0; ++j) {
            nIndex = this.getNodeIndex(this.depthList[level].get(j));
            t = this.getHandlePosition(nIndex, hloc);
            if (t == null) continue;
            hloc = t;
            pt1 = this.project(hloc[0], hloc[1], pt1);
            r.x = (int)(pt1[0] - (double)halfHandleIconWidth);
            r.y = (int)pt1[1];
            r.x = (int)((double)r.x * this.zoomScale);
            r.y = (int)((double)r.y * this.zoomScale);
            if (!r.contains(x, y)) continue;
            return nIndex;
        }
        for (j = this.linearNodeStart[level] - 1; j >= 0 && this.depthList[level] != null && this.depthList[level].size() != 0; --j) {
            nIndex = this.getNodeIndex(this.depthList[level].get(j));
            t = this.getHandlePosition(nIndex, hloc);
            if (t == null) continue;
            hloc = t;
            pt1 = this.project(hloc[0], hloc[1], pt1);
            r.x = (int)(pt1[0] - (double)halfHandleIconWidth);
            r.y = (int)(pt1[1] - (double)halfHandleIconHeight);
            r.x = (int)((double)r.x * this.zoomScale);
            r.y = (int)((double)r.y * this.zoomScale);
            if (!r.contains(x, y)) continue;
            return nIndex;
        }
        for (j = this.linearNodeEnd[level]; j < this.depthList[level].size() && this.depthList[level] != null && this.depthList[level].size() != 0; ++j) {
            nIndex = this.getNodeIndex(this.depthList[level].get(j));
            t = this.getHandlePosition(nIndex, hloc);
            if (t == null) continue;
            hloc = t;
            pt1 = this.project(hloc[0], hloc[1], pt1);
            r.x = (int)(pt1[0] - (double)halfHandleIconWidth);
            r.y = (int)(pt1[1] - (double)halfHandleIconHeight);
            r.x = (int)((double)r.x * this.zoomScale);
            r.y = (int)((double)r.y * this.zoomScale);
            if (!r.contains(x, y)) continue;
            return nIndex;
        }
        return -1;
    }

    protected int linearGetHandleAt(int x, int y) {
        double[] hloc = new double[2];
        int handleIconWidth = 1;
        int handleIconHeight = 1;
        if (this.expandIcon != null) {
            handleIconWidth = this.expandIcon.getWidth(this);
            handleIconHeight = this.expandIcon.getHeight(this);
        }
        if (this.treeLayout != 2) {
            handleIconHeight /= 2;
        }
        int halfHandleIconWidth = handleIconWidth / 2;
        int halfHandleIconHeight = handleIconHeight / 2;
        Rectangle r = new Rectangle(0, 0, (int)((double)handleIconWidth * this.zoomScale), (int)((double)handleIconHeight * this.zoomScale));
        if (this.xPosition == null) {
            return -1;
        }
        for (int i = 0; i < this.xPosition.length; ++i) {
            double[] t;
            if (!this.isNodeVisible(i) || (t = this.getHandlePosition(i, hloc)) == null) continue;
            hloc = t;
            r.x = (int)hloc[0] - halfHandleIconWidth;
            r.y = this.treeLayout == 2 ? (int)hloc[1] - halfHandleIconHeight : (int)hloc[1];
            double[] pt = this.project(r.x, r.y, null);
            r.x = (int)(pt[0] * this.zoomScale);
            r.y = (int)(pt[1] * this.zoomScale);
            if (!r.contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    protected boolean setPosition(int nodeIndex, int x, int y) {
        if (this.xPosition == null || nodeIndex < 0 || nodeIndex > this.xPosition.length) {
            return false;
        }
        this.xPosition[nodeIndex] = x;
        this.yPosition[nodeIndex] = y;
        return true;
    }

    protected int getXPosition(int nodeIndex) {
        if (this.xPosition == null || nodeIndex < 0 || nodeIndex > this.xPosition.length) {
            return -1;
        }
        return this.xPosition[nodeIndex];
    }

    protected int getYPosition(int nodeIndex) {
        if (this.yPosition == null || nodeIndex < 0 || nodeIndex > this.yPosition.length) {
            return -1;
        }
        return this.yPosition[nodeIndex];
    }

    protected String getURL(int nodeIndex) {
        if (this.nodeDataFilter == null || nodeIndex < 0 || nodeIndex >= this.nodeDataFilter.getNumberObservations(-1)) {
            return null;
        }
        Object nodeURLVar = this.roleManager.getVariable((Object)this.nodeURLRole, 0);
        if (nodeURLVar == null) {
            return null;
        }
        Object o = this.nodeDataFilter.getValue(nodeURLVar, (long)nodeIndex);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    protected boolean hasChildren(int nodeIndex) {
        if (this.nodeDataFilter == null || nodeIndex < 0 || nodeIndex >= this.nodeDataFilter.getNumberObservations(-1)) {
            return false;
        }
        Object hasChildrenVar = this.roleManager.getVariable((Object)this.nodeHasChildrenRole, 0);
        if (hasChildrenVar == null) {
            return false;
        }
        Object o = this.nodeDataFilter.getValue(hasChildrenVar, (long)nodeIndex);
        if (o == null) {
            return false;
        }
        if (Boolean.TRUE.equals(o)) {
            return true;
        }
        return "true".equalsIgnoreCase(o.toString());
    }

    public Hashtable getTreeState() {
        return this.saveState(this.rootNodeId, null);
    }

    public void setTreeState(Hashtable collapsed) {
        if (collapsed == null) {
            return;
        }
        if (this.isRebuildRequired()) {
            this.treeState = collapsed;
        } else {
            this.treeState = null;
            this.restoreState(this.rootNodeId, collapsed);
            collapsed.clear();
        }
    }

    private void restoreState(Object n, Hashtable collapsed) {
        if (n == null || collapsed == null) {
            return;
        }
        int index = this.getNodeIndex(n);
        this.setNodeVisible(index, true);
        ArrayList children = this.getChildren(n);
        if (children == null) {
            return;
        }
        if (collapsed.containsKey(n)) {
            boolean hideSubtree = (Boolean)collapsed.get(n);
            if (hideSubtree != this.isCollapsed(index)) {
                this.setCollapsed(index, hideSubtree, false);
            }
            if (hideSubtree) {
                return;
            }
        }
        for (int i = 0; i < children.size(); ++i) {
            Object o = children.get(i);
            this.restoreState(o, collapsed);
        }
    }

    private Hashtable saveState(Object n, Hashtable h) {
        block6: {
            ArrayList children;
            block5: {
                if (n == null) {
                    return null;
                }
                if (h == null) {
                    h = new Hashtable<Object, Boolean>();
                }
                int index = this.getNodeIndex(n);
                children = this.getChildren(n);
                if (!this.isCollapsed(index) || children == null || children.size() <= 0) break block5;
                h.put(n, new Boolean(true));
                if (this.treeLayout != 5 || children == null) break block6;
                for (int i = 0; i < children.size(); ++i) {
                    Object o = children.get(i);
                    this.saveState(o, h);
                }
                break block6;
            }
            h.put(n, new Boolean(false));
            if (children != null) {
                for (int i = 0; i < children.size(); ++i) {
                    Object o = children.get(i);
                    this.saveState(o, h);
                }
            }
        }
        return h;
    }

    public void setRoot(Object nId) {
        if (nId == null || nId.equals(this.rootNodeId)) {
            return;
        }
        if (this.isRebuildRequired()) {
            this.pendingRoots.add(nId);
        } else {
            this.setViewRoot(nId, false);
        }
    }

    protected boolean setViewRoot(Object nodeId, boolean fireRebuild) {
        if (nodeId == null || nodeId.equals(this.rootNodeId) || this.nodeDataFilter == null) {
            return false;
        }
        if (this.rootsStack == null) {
            this.rootsStack = new Stack();
        }
        this.rootsStack.push(this.rootNodeId);
        if (this.collapsedNodes == null) {
            this.collapsedNodes = new Hashtable();
        }
        Hashtable collapsed = this.saveState(this.rootNodeId, null);
        this.collapsedNodes.put(this.rootNodeId, collapsed);
        this.setCollapsed(this.getNodeIndex(this.rootNodeId), true, false);
        this.setNodeVisible(this.getNodeIndex(this.rootNodeId), false);
        this.rootNodeId = nodeId;
        this.restoreState(this.rootNodeId, collapsed);
        if (fireRebuild) {
            this.updateView(true, true);
            this.setFocusNode(this.rootNodeId);
            this.repaint();
        }
        this.breadthOrderBuilt = false;
        return true;
    }

    protected boolean lastRoot(boolean rebuild) {
        if (this.rootsStack == null || this.rootsStack.size() < 1) {
            return false;
        }
        Object prevRoot = this.rootNodeId;
        Object nodeId = this.rootsStack.pop();
        if (nodeId == null) {
            return false;
        }
        Hashtable prevRootCollapsed = this.saveState(prevRoot, null);
        this.rootNodeId = nodeId;
        Object o = this.collapsedNodes.get(this.rootNodeId);
        this.collapsedNodes.remove(this.rootNodeId);
        if (o instanceof Hashtable) {
            Hashtable collapsed = (Hashtable)o;
            this.restoreState(this.rootNodeId, collapsed);
        }
        this.restoreState(prevRoot, prevRootCollapsed);
        if (rebuild) {
            this.breadthOrderBuilt = false;
            this.updateView(true, true);
            this.setFocusNode(this.rootNodeId);
            this.repaint();
        }
        return true;
    }

    protected void backToOriginalRoot(boolean rebuild) {
        if (this.rootsStack == null || this.rootsStack.isEmpty()) {
            return;
        }
        while (!this.rootsStack.isEmpty()) {
            this.lastRoot(false);
        }
        if (rebuild) {
            this.breadthOrderBuilt = false;
            this.updateView(true, true);
            this.setFocusNode(this.rootNodeId);
            this.repaint();
        }
    }

    protected boolean unhidePathToNode(Object n) {
        int nodeIndex = this.getNodeIndex(n);
        if (n == null) {
            return false;
        }
        if (this.isNodeVisible(nodeIndex)) {
            return true;
        }
        Object parent = this.getParentNodeId(n);
        ArrayList<Object> ancestry = new ArrayList<Object>(20);
        while (parent != null) {
            ancestry.add(0, parent);
            int parIndex = this.getNodeIndex(parent);
            if (this.isNodeVisible(parIndex) && this.isCollapsed(parIndex)) break;
            parent = this.getParentNodeId(parent);
        }
        if (ancestry.size() > 0) {
            this.openPath(n, ancestry);
        }
        return true;
    }

    protected void openPath(Object node, ArrayList ancestry) {
        if (node == null || ancestry == null || ancestry.size() == 0) {
            return;
        }
        for (int i = 0; i < ancestry.size(); ++i) {
            Object n = ancestry.get(i);
            int nIndex = this.getNodeIndex(n);
            if (!this.isNodeVisible(nIndex) || !this.isCollapsed(nIndex)) continue;
            this.setCollapsed(nIndex, false, false);
        }
    }

    protected void setSubtreeVisible(int nodeIndex, boolean visible) {
        Object nodeId = this.getNodeId(nodeIndex);
        if (nodeId == null) {
            return;
        }
        this.setNodeVisible(nodeIndex, visible);
        if (visible && this.isCollapsed(nodeIndex)) {
            return;
        }
        ArrayList children = this.getChildren(nodeId);
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                this.setSubtreeVisible(this.getNodeIndex(children.get(i)), visible);
            }
        }
    }

    protected void collapseNodesAtLevel(int level) {
        if (this.depthList == null || level < 0 || level > this.depthList.length) {
            return;
        }
        for (int i = 0; i < this.depthList[level].size(); ++i) {
            Object n = this.depthList[level].get(i);
            int nodeIndex = this.getNodeIndex(n);
            if (this.isCollapsed(nodeIndex) || !this.setCollapsed(nodeIndex, true, false) || this.getDepth(this.focusNodeId) <= this.getDepth(n)) continue;
            this.storeFocusNodeState(n, this.focusNodeId);
        }
    }

    protected boolean setCollapsed(int nodeIndex, boolean collapse) {
        return this.setCollapsed(nodeIndex, collapse, true);
    }

    protected boolean setCollapsed(int nodeIndex, boolean collapse, boolean buildAndDraw) {
        if (this.collapsed == null || nodeIndex < 0 || nodeIndex > this.collapsed.length) {
            return false;
        }
        if (this.getChildren(this.getNodeId(nodeIndex)) == null) {
            return false;
        }
        this.collapsed[nodeIndex] = collapse;
        this.setSubtreeVisible(nodeIndex, !collapse);
        this.setNodeVisible(nodeIndex, true);
        this.treeDepthChanged = true;
        if (buildAndDraw) {
            this.updateView(true, false);
        }
        return true;
    }

    protected boolean isCollapsed(int nodeIndex) {
        if (this.collapsed == null || nodeIndex < 0 || nodeIndex >= this.collapsed.length) {
            return true;
        }
        return this.collapsed[nodeIndex];
    }

    protected void setNodeCollapsed(int nodeIndex) {
        int l;
        if (nodeIndex < 0 || nodeIndex > this.collapsed.length) {
            return;
        }
        Object nId = this.getNodeId(nodeIndex);
        boolean collapsed = this.isCollapsed(nodeIndex);
        if (this.treeLayout == 5 && (l = this.getLevelAtPosition((int)((double)this.getYPosition(nodeIndex) * this.zoomScale))) > 0) {
            this.collapseNodesAtLevel(l);
        }
        if ((this.zoomFitType == 0 || this.zoomFitType == 1 || this.zoomFitType == 2) & this.zoomValueSelected) {
            this.reInitZoomScale = false;
        }
        this.setCollapsed(nodeIndex, !collapsed);
        if (!this.restoreFocusNodeState(nId)) {
            this.setFocusNode(nId);
        }
    }

    protected boolean setNodeVisible(int nodeIndex, boolean vis) {
        if (this.visible == null || nodeIndex < 0 || nodeIndex >= this.visible.length) {
            return false;
        }
        this.visible[nodeIndex] = vis;
        return true;
    }

    protected boolean isNodeVisible(int nodeIndex) {
        if (this.visible == null || nodeIndex < 0 || nodeIndex >= this.visible.length) {
            return false;
        }
        return this.visible[nodeIndex];
    }

    protected int getNodeIndexInLinkModel(Object nodeId) {
        if (nodeId == null || this.idToIndexMapInLinkModel == null) {
            return -1;
        }
        Object o = this.idToIndexMapInLinkModel.get(nodeId);
        return o == null ? -1 : (Integer)o;
    }

    protected int getNodeIndex(Object nodeId) {
        if (nodeId == null || this.idToIndexMap == null) {
            return -1;
        }
        Object o = this.idToIndexMap.get(nodeId);
        return o == null ? -1 : (Integer)o;
    }

    protected Object getNodeId(int nodeIndex) {
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        if (this.nodeDataFilter == null || idVar == null) {
            return null;
        }
        return this.nodeDataFilter.getValue(idVar, (long)nodeIndex);
    }

    protected String getNodeLabel(int nodeIndex) {
        Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
        Object labelVar = this.roleManager.getVariable((Object)this.nodeLabelRole, 0);
        if (this.nodeDataFilter == null || idVar == null && labelVar == null || nodeIndex < 0 || nodeIndex >= this.nodeDataFilter.getNumberObservations(-1)) {
            return null;
        }
        int labelVarIndex = -1;
        labelVarIndex = labelVar != null ? this.nodeDataFilter.getVariableIndex(labelVar) : this.nodeDataFilter.getVariableIndex(idVar);
        Object o = this.nodeDataFilter.getValue(labelVarIndex, (long)nodeIndex);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    protected int getNodeIndexFromLabel(Object label) {
        if (label == null) {
            return -1;
        }
        Object labelVar = this.roleManager.getVariable((Object)this.nodeLabelRole, 0);
        for (int i = 0; i < this.nodeDataFilter.getNumberObservations(-1); ++i) {
            Object o = this.nodeDataFilter.getValue(labelVar, (long)i);
            if (!label.equals(o)) continue;
            return i;
        }
        return -1;
    }

    protected Object getParentNodeIdWrtOrigRoot(Object nodeId) {
        Object origRoot = null;
        origRoot = this.rootsStack != null && this.rootsStack.size() > 0 ? this.rootsStack.peek() : this.rootNodeId;
        if (this.areEqual(nodeId, origRoot)) {
            return null;
        }
        Object parentIdVar = this.roleManager.getVariable((Object)this.nodeParentIDRole, 0);
        Object fromVar = this.getFromVar();
        Object toVar = this.getToVar();
        if (this.nodeDataFilter == null || fromVar == null || toVar == null) {
            return null;
        }
        if (parentIdVar != null) {
            int nodeIndex = this.getNodeIndex(nodeId);
            if (nodeIndex < 0) {
                return null;
            }
            int parentIdVarIndex = this.nodeDataFilter.getVariableIndex(parentIdVar);
            Object retO = this.nodeDataFilter.getValue(parentIdVarIndex, (long)nodeIndex);
            if (this.areEqual(retO, "")) {
                return null;
            }
            return retO;
        }
        if (this.linkDataFilter != null) {
            int nodeIndex = this.getNodeIndexInLinkModel(nodeId);
            if (nodeIndex < 0) {
                return null;
            }
            int fromVarIndex = this.linkDataFilter.getVariableIndex(fromVar);
            return this.linkDataFilter.getValue(fromVarIndex, (long)nodeIndex);
        }
        return null;
    }

    protected Object getParentNodeId(Object nodeId) {
        if (this.areEqual(nodeId, this.rootNodeId)) {
            return null;
        }
        Object parentIdVar = this.roleManager.getVariable((Object)this.nodeParentIDRole, 0);
        Object fromVar = this.getFromVar();
        Object toVar = this.getToVar();
        if (this.nodeDataFilter == null || fromVar == null || toVar == null) {
            return null;
        }
        if (parentIdVar != null) {
            int nodeIndex = this.getNodeIndex(nodeId);
            if (nodeIndex < 0) {
                return null;
            }
            int parentIdVarIndex = this.nodeDataFilter.getVariableIndex(parentIdVar);
            Object retO = this.nodeDataFilter.getValue(parentIdVarIndex, (long)nodeIndex);
            if (this.areEqual(retO, "")) {
                return null;
            }
            return retO;
        }
        if (this.linkDataFilter != null) {
            int nodeIndex = this.getNodeIndexInLinkModel(nodeId);
            if (nodeIndex < 0) {
                return null;
            }
            int fromVarIndex = this.linkDataFilter.getVariableIndex(fromVar);
            return this.linkDataFilter.getValue(fromVarIndex, (long)nodeIndex);
        }
        return null;
    }

    protected ArrayList[] buildChildrenInfo() {
        ArrayList[] children;
        block8: {
            Hashtable[] cTable;
            Object toVar;
            Object fromVar;
            block7: {
                children = null;
                Object idVar = this.roleManager.getVariable((Object)this.nodeIDRole, 0);
                Object parentIdVar = this.roleManager.getVariable((Object)this.nodeParentIDRole, 0);
                fromVar = this.getFromVar();
                toVar = this.getToVar();
                if (this.nodeDataFilter == null || idVar == null || fromVar == null || toVar == null) {
                    return null;
                }
                children = new ArrayList[this.nodeDataFilter.getNumberObservations(-1)];
                cTable = new Hashtable[this.nodeDataFilter.getNumberObservations(-1)];
                if (parentIdVar == null) break block7;
                int idVarIndex = this.nodeDataFilter.getVariableIndex(idVar);
                int parentIdVarIndex = this.nodeDataFilter.getVariableIndex(parentIdVar);
                for (int i = 0; i < this.nodeDataFilter.getNumberObservations(-1); ++i) {
                    Object parentId;
                    int pIndex;
                    Object nId = this.nodeDataFilter.getValue(idVarIndex, (long)i);
                    if (this.getNodeIndex(nId) != i || (pIndex = this.getNodeIndex(parentId = this.nodeDataFilter.getValue(parentIdVarIndex, (long)i))) < 0 || pIndex > this.nodeDataFilter.getNumberObservations(-1)) continue;
                    if (children[pIndex] == null) {
                        children[pIndex] = new ArrayList();
                    }
                    if (cTable[pIndex] == null) {
                        cTable[pIndex] = new Hashtable();
                    }
                    if (cTable[pIndex].containsKey(nId) || !this.isNodeVisible(this.getNodeIndex(nId))) continue;
                    children[pIndex].add(nId);
                    cTable[pIndex].put(nId, nId);
                }
                break block8;
            }
            if (this.linkDataFilter == null) break block8;
            int fromVarIndex = this.linkDataFilter.getVariableIndex(fromVar);
            int toVarIndex = this.linkDataFilter.getVariableIndex(toVar);
            for (int i = 0; i < this.linkDataFilter.getNumberObservations(-1); ++i) {
                Object nId = this.linkDataFilter.getValue(toVarIndex, (long)i);
                Object parentId = this.linkDataFilter.getValue(fromVarIndex, (long)i);
                int pIndex = this.getNodeIndex(parentId);
                if (pIndex < 0 || pIndex > this.nodeDataFilter.getNumberObservations(-1)) continue;
                if (children[pIndex] == null) {
                    children[pIndex] = new ArrayList();
                }
                if (cTable[pIndex] == null) {
                    cTable[pIndex] = new Hashtable();
                }
                if (cTable[pIndex].containsKey(nId) || !this.isNodeVisible(this.getNodeIndex(nId))) continue;
                children[pIndex].add(nId);
                cTable[pIndex].put(nId, nId);
            }
        }
        return children;
    }

    protected ArrayList getVisibleChildren(Object nodeId, ArrayList[] children) {
        if (children == null) {
            return null;
        }
        if (this.isCollapsed(this.getNodeIndex(nodeId))) {
            return null;
        }
        int nodeIndex = this.getNodeIndex(nodeId);
        if (nodeIndex < 0 || nodeIndex >= children.length) {
            return null;
        }
        return children[nodeIndex];
    }

    protected Object getFirstChild(Object nodeId) {
        if (nodeId == null) {
            return null;
        }
        ArrayList c = this.getChildren(nodeId);
        if (c == null || c.size() == 0) {
            return null;
        }
        return c.get(0);
    }

    protected Object getLastChild(Object nodeId) {
        if (nodeId == null) {
            return null;
        }
        ArrayList c = this.getChildren(nodeId);
        if (c == null || c.size() == 0) {
            return null;
        }
        return c.get(c.size() - 1);
    }

    protected ArrayList getChildren(Object nodeId) {
        if (nodeId == null || this.nodeDataFilter == null || this.children == null) {
            return null;
        }
        int nIndex = this.getNodeIndex(nodeId);
        return this.getChildren(nIndex);
    }

    protected ArrayList getChildren(int nIndex) {
        if (this.children == null || nIndex < 0 || nIndex >= this.nodeDataFilter.getNumberObservations(-1)) {
            return null;
        }
        return this.children[nIndex];
    }

    protected int getNumberOfChildren(Object nodeId) {
        ArrayList children = this.getChildren(nodeId);
        if (children == null) {
            return 0;
        }
        return children.size();
    }

    protected int getNumberOfChildren(int nIndex) {
        ArrayList children = this.getChildren(nIndex);
        if (children == null) {
            return 0;
        }
        return children.size();
    }

    protected ArrayList getVisibleChildren(Object nodeId) {
        if (this.isCollapsed(this.getNodeIndex(nodeId))) {
            return null;
        }
        return this.getChildren(nodeId);
    }

    protected boolean areEqual(Object n1, Object n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 != null) {
            return n1.equals(n2);
        }
        return false;
    }

    protected void buildBreadthFirstOrderList() {
        if (this.rootNodeId == null) {
            return;
        }
        LinkedHashMap<Object, Integer> l = new LinkedHashMap<Object, Integer>(this.nodeDataFilter.getNumberObservations(-1));
        LinkedHashMap<Integer, Object> l2 = new LinkedHashMap<Integer, Object>(this.nodeDataFilter.getNumberObservations(-1));
        Queue q = new Queue();
        q.enqueue(this.rootNodeId);
        int count = 0;
        while (!q.isEmpty()) {
            Object n = q.dequeue();
            Integer I = new Integer(count++);
            l.put(n, I);
            l2.put(I, n);
            ArrayList k = this.getChildren(n);
            if (k == null) continue;
            for (int i = 0; i < k.size(); ++i) {
                Object n2 = k.get(i);
                if (l.containsKey(n2)) continue;
                q.enqueue(n2);
            }
        }
        this.breadthOrdering = l;
        this.breadthIndexOrdering = l2;
        this.breadthOrderBuilt = true;
    }

    private boolean isStacked(Object n) {
        if (n == null) {
            return false;
        }
        int index = this.getNodeIndex(n);
        if (index < 0) {
            return false;
        }
        ArrayList children = this.getChildren(n);
        if (children != null && children.size() > 0) {
            return false;
        }
        Object parentId = this.getParentNodeId(n);
        if (parentId == null) {
            return false;
        }
        ArrayList c = this.getChildren(parentId);
        if (c == null) {
            return false;
        }
        for (int i = 0; i < c.size(); ++i) {
            ArrayList v = this.getChildren(c.get(i));
            if (v == null || v.size() <= 0) continue;
            return false;
        }
        return true;
    }

    protected boolean isChildrenOnStack(Object nId) {
        ArrayList children = this.getChildren(nId);
        if (children == null || children.size() <= 0) {
            return false;
        }
        for (int i = 0; i < children.size(); ++i) {
            if (this.isLabelOnStack(children.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean isLabelOnStack(Object n) {
        if (this.treeLayout != 6) {
            return false;
        }
        return this.isStacked(n);
    }

    protected boolean isNodeOnStack(Object n) {
        if (this.treeLayout != 3) {
            return false;
        }
        return this.isStacked(n);
    }

    protected Object getLeftSibling(Object n) {
        if (n == null) {
            return null;
        }
        int index = this.getNodeIndex(n);
        if (index < 0) {
            return null;
        }
        if (n.equals(this.rootNodeId)) {
            return null;
        }
        Object parent = this.getParentNodeId(n);
        if (parent == null) {
            return null;
        }
        if (n.equals(this.getFirstChild(parent))) {
            return null;
        }
        ArrayList children = this.getChildren(parent);
        Object obj = children.get(children.indexOf(n) - 1);
        if (this.isNodeVisible(this.getNodeIndex(obj))) {
            return obj;
        }
        return null;
    }

    protected Object getRightSibling(Object n) {
        if (n == null) {
            return null;
        }
        int index = this.getNodeIndex(n);
        if (index < 0) {
            return null;
        }
        if (n.equals(this.rootNodeId)) {
            return null;
        }
        Object parent = this.getParentNodeId(n);
        if (parent == null) {
            return null;
        }
        ArrayList children = this.getVisibleChildren(parent);
        if (children == null) {
            return null;
        }
        if (n.equals(children.get(children.size() - 1))) {
            return null;
        }
        int idx = children.indexOf(n);
        Object obj = children.get(idx + 1);
        if (this.isNodeVisible(this.getNodeIndex(obj))) {
            return obj;
        }
        return null;
    }

    protected Object getLeftMostAtLevel(Object n, int level) {
        Object n2;
        if (n == null) {
            return null;
        }
        if (level < 0) {
            return null;
        }
        if (!this.breadthOrderBuilt) {
            this.buildBreadthFirstOrderList();
        }
        int breadthOrderIndex = (Integer)this.breadthOrdering.get(n) - 1;
        while ((n2 = this.breadthIndexOrdering.get(new Integer(breadthOrderIndex))) != null) {
            if (this.getDepth(n2) != level) {
                return this.breadthIndexOrdering.get(new Integer(breadthOrderIndex + 1));
            }
            --breadthOrderIndex;
        }
        return null;
    }

    protected Object getRightMostAtLevel(Object n, int level) {
        Object n2;
        if (n == null) {
            return null;
        }
        if (level < 0) {
            return null;
        }
        if (!this.breadthOrderBuilt) {
            this.buildBreadthFirstOrderList();
        }
        int breadthOrderIndex = (Integer)this.breadthOrdering.get(n) + 1;
        while ((n2 = this.breadthIndexOrdering.get(new Integer(breadthOrderIndex))) != null) {
            if (this.getDepth(n2) != level) {
                return this.breadthIndexOrdering.get(new Integer(breadthOrderIndex - 1));
            }
            ++breadthOrderIndex;
        }
        if (breadthOrderIndex == this.breadthOrdering.size()) {
            return this.breadthIndexOrdering.get(new Integer(breadthOrderIndex - 1));
        }
        return null;
    }

    protected Object getDownRelative(Object n) {
        if (n == null) {
            return null;
        }
        int index = this.getNodeIndex(n);
        if (index < 0) {
            return null;
        }
        Object n2 = this.getRightRelative(n, false, true);
        if (n2 != null && this.isNodeVisible(this.getNodeIndex(n2))) {
            return n2;
        }
        n2 = this.getParentNodeId(n);
        if (n2 == null) {
            return null;
        }
        while (!this.areEqual(n2, this.rootNodeId)) {
            Object t = this.getRightRelative(n2, false, true);
            if (t != null && this.isNodeVisible(this.getNodeIndex(t))) {
                return t;
            }
            n2 = this.getParentNodeId(n2);
        }
        return null;
    }

    protected Object getUpRelative(Object n) {
        if (n == null || this.areEqual(this.rootNodeId, n)) {
            return null;
        }
        int index = this.getNodeIndex(n);
        if (index < 0) {
            return null;
        }
        Object n2 = null;
        if (this.areEqual(n, this.getFirstChild(this.getParentNodeId(n)))) {
            return this.getParentNodeId(n);
        }
        int ci = this.getChildIndex(n);
        if (ci < 1) {
            return null;
        }
        ArrayList children = this.getChildren(this.getParentNodeId(n));
        n2 = children.get(ci - 1);
        while (!this.isCollapsed(this.getNodeIndex(n2))) {
            Object t = this.getLastChild(n2);
            if (t == null) {
                return n2;
            }
            n2 = t;
        }
        return n2;
    }

    private Object getNextVisibleRightMostRelative(Object n) {
        int visIdx;
        if (n == null) {
            return null;
        }
        int level = this.getDepth(n);
        if (level < 0) {
            return null;
        }
        if (!this.breadthOrderBuilt) {
            this.buildBreadthFirstOrderList();
        }
        int orderIdxOfTheNode = (Integer)this.breadthOrdering.get(n);
        int breadthOrderIndex = orderIdxOfTheNode - 1;
        Object n2 = null;
        while (true) {
            Object v = this.breadthIndexOrdering.get(new Integer(breadthOrderIndex));
            n2 = v;
            if (v == null) break;
            if (this.getDepth(n2) != level) {
                breadthOrderIndex = orderIdxOfTheNode + 1;
                visIdx = -1;
                while (true) {
                    Object v2 = this.breadthIndexOrdering.get(new Integer(breadthOrderIndex));
                    n2 = v2;
                    if (this.getDepth(v2) != level) break;
                    if (this.isNodeVisible(this.getNodeIndex(n2))) {
                        visIdx = breadthOrderIndex;
                    }
                    ++breadthOrderIndex;
                }
                n2 = this.breadthIndexOrdering.get(new Integer(visIdx));
                break;
            }
            if (this.isNodeVisible(this.getNodeIndex(n2))) break;
            --breadthOrderIndex;
        }
        if (n2 == null) {
            breadthOrderIndex = orderIdxOfTheNode + 1;
            visIdx = orderIdxOfTheNode;
            while (true) {
                Object v = this.breadthIndexOrdering.get(new Integer(breadthOrderIndex));
                n2 = v;
                if (this.getDepth(v) != level) break;
                if (this.isNodeVisible(this.getNodeIndex(n2))) {
                    visIdx = breadthOrderIndex;
                }
                ++breadthOrderIndex;
            }
            n2 = this.breadthIndexOrdering.get(new Integer(visIdx));
        }
        return n2;
    }

    protected Object getLeftRelative(Object n, boolean wrap, boolean sameParent) {
        int breadthOrderIndex;
        Object n2;
        if (n == null) {
            return null;
        }
        int index = this.getNodeIndex(n);
        if (index < 0) {
            return null;
        }
        Object ls = this.getLeftSibling(n);
        if (ls != null) {
            return ls;
        }
        if (!this.breadthOrderBuilt) {
            this.buildBreadthFirstOrderList();
        }
        if ((n2 = this.breadthIndexOrdering.get(new Integer((breadthOrderIndex = ((Integer)this.breadthOrdering.get(n)).intValue()) - 1))) != null) {
            int idx = this.getNodeIndex(n2);
            if (idx >= 0) {
                if (sameParent) {
                    if (this.areEqual(this.getParentNodeId(n), this.getParentNodeId(n2))) {
                        if (!this.isNodeVisible(this.getNodeIndex(n2))) {
                            n2 = this.getNextVisibleRightMostRelative(n2);
                        }
                        return n2;
                    }
                } else {
                    if (this.getDepth(n) == this.getDepth(n2)) {
                        if (!this.isNodeVisible(this.getNodeIndex(n2))) {
                            n2 = this.getNextVisibleRightMostRelative(n2);
                        }
                        return n2;
                    }
                    if (wrap && (n2 = this.getRightMostAtLevel(n, this.getDepth(n))) != null) {
                        if (!this.isNodeVisible(this.getNodeIndex(n2))) {
                            n2 = this.getNextVisibleRightMostRelative(n2);
                        }
                        return n2;
                    }
                }
            } else if (wrap) {
                n2 = this.getNextVisibleRightMostRelative(n);
                return n2;
            }
        } else if (wrap && (n2 = this.getRightMostAtLevel(n, this.getDepth(n))) != null) {
            if (!this.isNodeVisible(this.getNodeIndex(n2))) {
                n2 = this.getNextVisibleRightMostRelative(n2);
            }
            return n2;
        }
        return null;
    }

    private Object getNextVisibleLeftMostRelative(Object n) {
        int visIdx;
        if (n == null) {
            return null;
        }
        int level = this.getDepth(n);
        if (level < 0) {
            return null;
        }
        if (!this.breadthOrderBuilt) {
            this.buildBreadthFirstOrderList();
        }
        int orderIdxOfTheNode = (Integer)this.breadthOrdering.get(n);
        int breadthOrderIndex = orderIdxOfTheNode + 1;
        Object n2 = null;
        while (true) {
            Object v = this.breadthIndexOrdering.get(new Integer(breadthOrderIndex));
            n2 = v;
            if (v == null) break;
            if (this.getDepth(n2) != level) {
                breadthOrderIndex = orderIdxOfTheNode - 1;
                visIdx = -1;
                while (true) {
                    Object v2 = this.breadthIndexOrdering.get(new Integer(breadthOrderIndex));
                    n2 = v2;
                    if (this.getDepth(v2) != level) break;
                    if (this.isNodeVisible(this.getNodeIndex(n2))) {
                        visIdx = breadthOrderIndex;
                    }
                    --breadthOrderIndex;
                }
                n2 = this.breadthIndexOrdering.get(new Integer(visIdx));
                break;
            }
            if (this.isNodeVisible(this.getNodeIndex(n2))) break;
            ++breadthOrderIndex;
        }
        if (n2 == null) {
            breadthOrderIndex = orderIdxOfTheNode - 1;
            visIdx = orderIdxOfTheNode;
            while (true) {
                Object v = this.breadthIndexOrdering.get(new Integer(breadthOrderIndex));
                n2 = v;
                if (this.getDepth(v) != level) break;
                if (this.isNodeVisible(this.getNodeIndex(n2))) {
                    visIdx = breadthOrderIndex;
                }
                --breadthOrderIndex;
            }
            n2 = this.breadthIndexOrdering.get(new Integer(visIdx));
        }
        return n2;
    }

    protected Object getRightRelative(Object n, boolean wrap, boolean sameParent) {
        int breadthOrderIndex;
        Object n2;
        if (n == null) {
            return null;
        }
        int index = this.getNodeIndex(n);
        if (index < 0) {
            return null;
        }
        Object rs = this.getRightSibling(n);
        if (rs != null) {
            return rs;
        }
        if (!this.breadthOrderBuilt) {
            this.buildBreadthFirstOrderList();
        }
        if ((n2 = this.breadthIndexOrdering.get(new Integer((breadthOrderIndex = ((Integer)this.breadthOrdering.get(n)).intValue()) + 1))) != null) {
            int idx = this.getNodeIndex(n);
            if (idx >= 0) {
                if (sameParent) {
                    if (this.areEqual(this.getParentNodeId(n), this.getParentNodeId(n2))) {
                        return n2;
                    }
                } else {
                    if (this.getDepth(n) == this.getDepth(n2)) {
                        if (!this.isNodeVisible(this.getNodeIndex(n2))) {
                            n2 = this.getNextVisibleLeftMostRelative(n2);
                        }
                        return n2;
                    }
                    if (wrap && (n2 = this.getLeftMostAtLevel(n, this.getDepth(n))) != null) {
                        if (!this.isNodeVisible(this.getNodeIndex(n2))) {
                            n2 = this.getNextVisibleLeftMostRelative(n2);
                        }
                        return n2;
                    }
                }
            } else if (wrap) {
                n2 = this.getNextVisibleLeftMostRelative(n);
                return n2;
            }
        } else if (wrap && (n2 = this.getLeftMostAtLevel(n, this.getDepth(n))) != null) {
            if (!this.isNodeVisible(this.getNodeIndex(n2))) {
                n2 = this.getNextVisibleLeftMostRelative(n2);
            }
            return n2;
        }
        return null;
    }

    protected int getChildIndex(Object n) {
        if (n == null) {
            return -1;
        }
        Object parent = this.getParentNodeId(n);
        if (parent == null) {
            return -1;
        }
        ArrayList children = this.getChildren(parent);
        if (children == null || children.size() == 0) {
            return -1;
        }
        return children.indexOf(n);
    }

    public static ArrayList makeMultiLineStrings(Object label) {
        if (label == null) {
            return null;
        }
        ArrayList<String> v = new ArrayList<String>(4);
        String l = label.toString();
        int startIndex = 0;
        int endIndex = -1;
        String newLine = "\\n";
        while ((endIndex = l.indexOf(newLine, startIndex)) >= 0) {
            v.add(l.substring(startIndex, endIndex));
            startIndex = endIndex + 2;
        }
        v.add(l.substring(startIndex));
        String newLine2 = "\n";
        if (startIndex == 0) {
            v.clear();
            while ((endIndex = l.indexOf(newLine2, startIndex)) >= 0) {
                v.add(l.substring(startIndex, endIndex));
                startIndex = endIndex + 1;
            }
            v.add(l.substring(startIndex));
        }
        return v;
    }

    public Cursor getMoveClosedCursor() {
        return this.moveClosedCursor;
    }

    public void setMoveClosedCursor(Cursor moveClosedCursor) {
        this.moveClosedCursor = moveClosedCursor;
    }

    public Cursor getZoomCursor() {
        return this.zoomCursor;
    }

    public void setZoomCursor(Cursor zoomCursor) {
        this.zoomCursor = zoomCursor;
    }

    public Cursor getMoveOpenCursor() {
        return this.moveOpenCursor;
    }

    public void setMoveOpenCursor(Cursor moveOpenCursor) {
        this.moveOpenCursor = moveOpenCursor;
    }

    public void removeDrillDownListener(DrilldownListenerInterface d) {
        if (d != null) {
            this.drillDownListeners.remove(d);
        }
    }

    public void addDrillDownListener(DrilldownListenerInterface d) {
        if (d != null) {
            this.drillDownListeners.add(d);
        }
    }

    protected void fireDrillDownEvent(int nodeIndex, boolean expandNode) {
        Object nodeId = this.getNodeId(nodeIndex);
        if (nodeId == null) {
            return;
        }
        if (this.drillDownListeners.size() == 0) {
            return;
        }
        String url = this.getURL(nodeIndex);
        if (url == null) {
            url = nodeId.toString();
        }
        if (expandNode) {
            url = "EXPAND: " + nodeId.toString();
        }
        Hashtable<Integer, Object> drillInfo = new Hashtable<Integer, Object>();
        drillInfo.put(DrilldownEvent.DRILLDOWN_KEY_URL, url);
        drillInfo.put(DrilldownEvent.DRILLDOWN_KEY_NODE_ID, nodeId.toString());
        drillInfo.put(DrilldownEvent.DRILLDOWN_KEY_NODE_X_POSITION, new Double(this.getXPosition(nodeIndex) - this.getOrigin().x));
        drillInfo.put(DrilldownEvent.DRILLDOWN_KEY_NODE_Y_POSITION, new Double(this.getYPosition(nodeIndex) - this.getOrigin().y));
        drillInfo.put(DrilldownEvent.DRILLDOWN_KEY_TREE_LAYOUT, this.getTreeLayoutName());
        DrilldownEvent e = new DrilldownEvent(url, drillInfo);
        for (int i = 0; i < this.drillDownListeners.size(); ++i) {
            DrilldownListenerInterface d = (DrilldownListenerInterface)this.drillDownListeners.elementAt(i);
            d.drilldown(e);
        }
    }

    public String getTreeLayoutName() {
        switch (this.getTreeLayout()) {
            case 6: {
                return "listview";
            }
            case 5: {
                return "lenssubtree";
            }
            case 4: {
                return "lensfulltree";
            }
            case 3: {
                return "stackedleaves";
            }
            case 0: {
                return "explorer";
            }
            case 1: {
                return "vertical";
            }
        }
        return "horizontal";
    }

    public boolean areNodesSizedToFitText() {
        return this.sizeNodesToFitText;
    }

    public void setSizeNodesToFitText(boolean sizeNodesToFitText) {
        this.sizeNodesToFitText = sizeNodesToFitText;
    }

    public void setDrawIcon(boolean drawIcon) {
        this.drawIcon = drawIcon;
    }

    public boolean isIconDrawn() {
        return this.drawIcon;
    }

    public Object getRootNodeId() {
        return this.rootNodeId;
    }

    public Stack getRootsStack() {
        return this.rootsStack;
    }

    public int[] getViewCenter() {
        return new int[]{this.origin.x + this.compWidth / 2, this.origin.y + this.compHeight / 2};
    }

    public void setViewCenter(int cx, int cy) {
        if (this.isRebuildRequired()) {
            this.viewCenterX = cx;
            this.viewCenterY = cy;
        } else {
            int ox = cx - this.compWidth / 2;
            int oy = cy - this.compHeight / 2;
            this.moveOrigin(ox, oy, false);
        }
    }

    public boolean setTreeExpansionLevel(int level) {
        return this.setTreeExpansionLevel(level, true);
    }

    private boolean setTreeExpansionLevel(int level, boolean fireRebuild) {
        if (level >= 0) {
            if (this.treeLayout == 5) {
                this.focusNodeId = this.rootNodeId;
            }
            this.treeExpansionLevel = level;
            if (this.isRebuildRequired()) {
                this.treeExpLevelChanged = true;
            } else {
                this.treeExpLevelChanged = false;
                this.expandTree(level);
                if (fireRebuild) {
                    this.updateView(true, false);
                }
            }
            return true;
        }
        return false;
    }

    private void expandTree(int level) {
        if (level < 0) {
            return;
        }
        if (this.treeLayout == 5) {
            this.focusNodeId = this.rootNodeId;
            level = level >= 1 ? 1 : 0;
        }
        int idVarIndex = this.nodeDataFilter.getVariableIndex(this.roleManager.getVariable((Object)this.nodeIDRole, 0));
        for (int i = 0; i < this.nodeDataFilter.getNumberObservations(-1); ++i) {
            Object nId = this.nodeDataFilter.getValue(idVarIndex, (long)i);
            int depth = this.getDepth(nId);
            if (depth < level || this.getChildren(nId) == null) continue;
            this.setCollapsed(i, true, false);
            if (depth <= level) continue;
            this.setNodeVisible(i, false);
        }
    }

    public int getTreeExpansionLevel() {
        return this.treeExpansionLevel;
    }

    private void showAllChildren(Object pId) {
        ArrayList children = this.getChildren(pId);
        if (children != null) {
            this.setCollapsed(this.getNodeIndex(pId), false, false);
            for (int i = 0; i < children.size(); ++i) {
                this.showAllChildren(children.get(i));
            }
        }
    }

    protected void showAllNodes() {
        this.showAllChildren(this.rootNodeId);
        this.updateView(true, true);
        this.setFocusNode(this.rootNodeId);
        this.repaint();
        this.breadthOrderBuilt = false;
    }

    protected void reset() {
        this.backToOriginalRoot(true);
    }

    protected void storeFocusNodeState(Object parentNode, Object focusNode) {
        if (parentNode == null || focusNode == null) {
            return;
        }
        if (this.focusNodeStateTable == null) {
            this.focusNodeStateTable = new Hashtable();
        }
        this.focusNodeStateTable.put(parentNode, focusNode);
    }

    protected boolean restoreFocusNodeState(Object parentNode) {
        if (parentNode == null || this.focusNodeStateTable == null) {
            return false;
        }
        if (this.isCollapsed(this.getNodeIndex(parentNode))) {
            return false;
        }
        Object fn = this.focusNodeStateTable.get(parentNode);
        if (fn == null) {
            return false;
        }
        this.setFocusNode(fn);
        return true;
    }

    public void dispose() {
        this.clearColorRamp();
        this.nodeDataModel = null;
        this.nodeDataFilter = null;
        this.linkDataModel = null;
        this.linkDataFilter = null;
        this.nodeIDRole = null;
        this.nodeParentIDRole = null;
        this.nodeLabelRole = null;
        this.nodeGroupRole = null;
        this.nodeTipRole = null;
        this.nodeIconRole = null;
        this.nodeURLRole = null;
        this.nodeHasChildrenRole = null;
        this.linkIDRole = null;
        this.linkFromRole = null;
        this.linkToRole = null;
        this.linkTipRole = null;
        if (this.roleManager != null) {
            this.roleManager.removeRoleListener((RoleListenerInterface)this);
        }
        this.roleManager = null;
        this.roles = null;
        this.rootNodeId = null;
        if (this.idToIndexMap != null) {
            this.idToIndexMap.clear();
        }
        this.idToIndexMap = null;
        if (this.idToIndexMapInLinkModel != null) {
            this.idToIndexMapInLinkModel.clear();
        }
        this.idToIndexMapInLinkModel = null;
        if (this.pendingProperties != null) {
            this.pendingProperties.removeChangesBySource(null);
        }
        this.pendingProperties = null;
        this.userSetProperties = null;
        this.xPosition = null;
        this.yPosition = null;
        this.collapsed = null;
        this.visible = null;
        this.vspaces = null;
        this.hspaces = null;
        this.backBuffer = null;
        this.origin = null;
        this.style = null;
        this.expandIcon = null;
        this.collapseIcon = null;
        this.defaultNodeIcon = null;
        this.defaults = null;
        this.focusNodeId = null;
        this.nodeFont = null;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ArrayList a = this.children[i];
                if (a != null) {
                    a.clear();
                }
                this.children[i] = null;
            }
        }
        this.children = null;
        if (this.breadthOrdering != null) {
            this.breadthOrdering.clear();
        }
        this.breadthOrdering = null;
        if (this.breadthIndexOrdering != null) {
            this.breadthIndexOrdering.clear();
        }
        this.breadthIndexOrdering = null;
        this.depthList = null;
        if (this.rootsStack != null) {
            this.rootsStack.clear();
        }
        this.rootsStack = null;
        if (this.collapsedNodes != null) {
            this.collapsedNodes.clear();
        }
        this.collapsedNodes = null;
        this.lensValues = null;
        this.lensLocs = null;
        this.lensScreenLocs = null;
        this.worldLinearArea = null;
        this.screenLinearArea = null;
        this.linearNodeStart = null;
        this.linearNodeEnd = null;
        this.findDialog = null;
        this.parentFrame = null;
        this.defaultCursor = null;
        this.handCursor = null;
        this.moveOpenCursor = null;
        this.moveClosedCursor = null;
        if (this.iconCache != null) {
            this.iconCache.clear();
        }
        this.iconCache = null;
        if (this.focusNodeStateTable != null) {
            this.focusNodeStateTable.clear();
        }
        this.focusNodeStateTable = null;
    }

    public void setDrawRaisedNodes(boolean drawRaisedNodes) {
        this.drawRaisedNodes = drawRaisedNodes;
        this.backBufferValid = false;
        this.repaint();
    }

    public boolean areNodesDrawnRaised() {
        return this.drawRaisedNodes;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 2: {
                this.repaint();
                break;
            }
            default: {
                this.backBufferValid = false;
                this.build(Boolean.TRUE);
                this.repaint();
            }
        }
    }

    protected boolean isNodeRoleSet(Object role) {
        if (this.nodeDataFilter == null) {
            return false;
        }
        Object var = this.roleManager.getVariable(role, 0);
        return var != null && this.nodeDataFilter != null && this.nodeDataFilter.getVariableIndex(var) >= 0;
    }

    protected void initColorRamp() {
        if (!this.reinitColorRamp) {
            return;
        }
        RampStyleElement rampSE = ((Style)SILKGlobal.getInstance().getPropertyValue(29)).getRampStyleElement(this.colorRamp);
        this.minColor = rampSE.getStartColor();
        this.neutralColor = rampSE.getColorAttribute("fillGradientNeutralColor", null);
        if (this.neutralColor == null) {
            this.neutralValue = Double.NaN;
        }
        this.maxColor = rampSE.getEndColor();
        this.missingColor = ((Style)SILKGlobal.getInstance().getPropertyValue(29)).getFillStyleElement("Missing").getFillColor();
        this.underflowColor = this.overlflowColor = Color.RED;
        double colorMin = Double.NaN;
        double colorMax = Double.NaN;
        if (this.isNodeRoleSet(this.nodeColorRole)) {
            Object colorVar = this.roleManager.getVariable((Object)RoleInterface.ROLE_COLOR, 0);
            int colorVarIndex = this.nodeDataFilter.getVariableIndex(colorVar);
            if (colorVarIndex < 0) {
                return;
            }
            Object o = ((DataFilterInfoInterface)this.nodeDataFilter).getMinimumValue(this.nodeDataFilter.getVariableId(colorVarIndex), true);
            if (o instanceof Number) {
                colorMin = ((Number)o).doubleValue();
            }
            if ((o = ((DataFilterInfoInterface)this.nodeDataFilter).getMaximumValue(this.nodeDataFilter.getVariableId(colorVarIndex), true)) instanceof Number) {
                colorMax = ((Number)o).doubleValue();
            }
        } else {
            colorMax = this.absoluteTreeDepth;
            colorMin = 0.0;
        }
        this.setValues(colorMin, Double.NaN, colorMax);
        this.zeroCenter = true;
        this.reinitColorRamp = false;
    }

    protected void clearColorRamp() {
        this.minColor = null;
        this.neutralColor = null;
        this.maxColor = null;
        this.reinitColorRamp = true;
    }

    protected Color getMappedColor(int obs, int colorVarIndex) {
        if (this.nodeDataFilter == null) {
            return null;
        }
        double value = Double.NaN;
        if (colorVarIndex >= 0) {
            value = this.nodeDataFilter.getNumericValue(colorVarIndex, (long)obs);
        }
        return this.getMappedColor(value);
    }

    protected Color getMappedColor(double value) {
        if (this.reinitColorRamp) {
            this.initColorRamp();
        }
        return this.getColorByValue(value);
    }

    protected void applyStyleElement() {
        this.initColorRamp();
    }

    private Color getColorByValue(double d) {
        Color maxc;
        Color minc;
        double max;
        double min;
        if (Double.isNaN(d)) {
            return this.missingColor;
        }
        if (d < this.minValue) {
            return this.underflowColor;
        }
        if (d > this.maxValue) {
            return this.overlflowColor;
        }
        if (this.neutralColor == null || Double.isNaN(this.neutralValue)) {
            min = this.minValue;
            max = this.maxValue;
            minc = this.minColor;
            maxc = this.maxColor;
        } else if (d < this.neutralValue) {
            min = this.minValue;
            max = this.neutralValue;
            minc = this.minColor;
            maxc = this.neutralColor == null ? this.maxColor : this.neutralColor;
        } else {
            min = this.neutralValue;
            max = this.maxValue;
            minc = this.neutralColor == null ? this.minColor : this.neutralColor;
            maxc = this.maxColor;
        }
        if (d == min) {
            return minc;
        }
        if (d == max) {
            return maxc;
        }
        double factor = 1.0 / ((max - min) / (d - min));
        int r1 = minc.getRed();
        int g1 = minc.getGreen();
        int b1 = minc.getBlue();
        int t1 = minc.getAlpha();
        int r2 = maxc.getRed();
        int g2 = maxc.getGreen();
        int b2 = maxc.getBlue();
        int t2 = maxc.getAlpha();
        int r = (int)(((double)r2 - (double)r1) * factor + (double)r1);
        int g = (int)(((double)g2 - (double)g1) * factor + (double)g1);
        int b = (int)(((double)b2 - (double)b1) * factor + (double)b1);
        int t = (int)(((double)t2 - (double)t1) * factor + (double)t1);
        Color rc = new Color(r, g, b, t);
        return rc;
    }

    private void setValues(double min, double neutral, double max) {
        if (Double.isNaN(min)) {
            min = neutral;
        }
        if (Double.isNaN(max)) {
            max = neutral;
        }
        if (Double.isNaN(min) || Double.isNaN(max)) {
            return;
        }
        if (min > max) {
            double temp = min;
            min = max;
            max = temp;
        }
        if (this.neutralColor != null) {
            if (Double.isNaN(neutral)) {
                neutral = min + (max - min) / 2.0;
            }
            if (this.zeroCenter && min < 0.0 && max > 0.0) {
                neutral = 0.0;
            }
        } else {
            neutral = Double.NaN;
        }
        this.minValue = min;
        this.maxValue = max;
        this.neutralValue = neutral;
        if (this.minValue == this.maxValue) {
            this.neutralValue = this.minValue;
            this.minValue -= 1.0;
            this.maxValue += 1.0;
        }
    }

    private class Queue
    extends ArrayList {
        private static final long serialVersionUID = 8599324405933182590L;

        private Queue() {
        }

        public void enqueue(Object o) {
            this.add(o);
        }

        public Object dequeue() {
            if (this.size() <= 0) {
                return null;
            }
            Object o = this.get(0);
            this.remove(0);
            return o;
        }
    }
}

