/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.matrix;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.silk.BaseHistComponent;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.matrix.MatrixChartFactoryInterface;
import com.sas.graphics.silk.util.AbstractChartFactory;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.LegendParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.Extract;
import com.sas.graphics.xml.GraphParserFactory;
import java.awt.Color;
import java.awt.Font;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractMatrixChartFactory
extends AbstractChartFactory
implements MatrixChartFactoryInterface {
    private static final String MATRIX_CHART_ID = "__MATRIX_CHART_ID__";
    protected Hashtable xVarList = new Hashtable();
    protected Vector componentList = new Vector();
    protected Roles roles = Roles.getInstance(null);
    protected SILKNumber xRole = this.roles.getRoleObject("ROLE_X");
    protected SILKNumber yRole = this.roles.getRoleObject("ROLE_Y");
    protected SILKNumber groupRole = this.roles.getRoleObject("ROLE_GROUP");
    protected SILKNumber colorRole = this.roles.getRoleObject("ROLE_COLOR");
    public static final int LABEL = 1;
    public static final int HISTOGRAM = 2;
    private int diagonalType = 1;

    @Override
    public boolean applyAxesToCrossing(String xVar, String yVar, AxisInterface xAxis, AxisInterface yAxis) {
        JComponent jc = this.fetchComponent(xVar, yVar);
        if (jc == null) {
            return false;
        }
        if (jc instanceof GraphInterface) {
            ((GraphInterface)jc).setExternalAxis((Object)"X", xAxis);
            ((GraphInterface)jc).setExternalAxis((Object)"Y", yAxis);
            return true;
        }
        return false;
    }

    @Override
    public JComponent getComponentAtCrossing(String xVar, String yVar) {
        JComponent jc = this.createComponent(xVar, yVar);
        if (xVar == null && yVar == null) {
            return jc;
        }
        this.storeComponent(xVar, yVar, jc);
        if (jc instanceof ComponentInterface && jc instanceof ComponentInterface) {
            ((ComponentInterface)jc).enablePopup(false);
        }
        if (jc instanceof CellItemInterface) {
            ((CellItemInterface)jc).setAxesVisible(false);
        }
        if (jc instanceof PropertyInterface) {
            PropertyInterface p = (PropertyInterface)jc;
            p.setPropertyValue(64, (Object)Boolean.FALSE);
            p.setPropertyValue(32, (Object)new Integer(0));
            p.setPropertyValue(33, (Object)new Integer(0));
            p.setPropertyValue(2, (Object)new Boolean(false));
            p.setPropertyValue(34, (Object)new Boolean(false));
            p.applyPropertyChanges();
            if (xVar != yVar) {
                this.propertyMulticaster.addListener(p);
            }
        }
        return jc;
    }

    @Override
    public boolean areChangesPending(Object source) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return false;
        }
        Object[] components = this.componentList.toArray();
        for (int i = 0; i < components.length; ++i) {
            int[] list;
            if (components[i] == null || !(components[i] instanceof PropertyInterface) || (list = ((PropertyInterface)components[i]).getPendingChanges(source)) == null || list.length <= 0) continue;
            return true;
        }
        return super.areChangesPending(source);
    }

    public boolean setStyle(Object newStyle) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return super.setStyle(newStyle);
        }
        boolean rc = false;
        Color labelColor = this.style.getTextStyleElement("LabelText").getTextColor();
        Font font = this.style.getTextStyleElement("LabelText").getFont();
        Object[] components = this.componentList.toArray();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null) continue;
            if (components[i] instanceof GraphInterface) {
                rc = ((GraphInterface)components[i]).setStyle(newStyle) || rc;
                continue;
            }
            if (!(components[i] instanceof JLabel)) continue;
            JLabel label = (JLabel)components[i];
            label.setForeground(labelColor);
            label.setFont(font.deriveFont(this.getLabelFontSize(label)));
        }
        rc = super.setStyle(newStyle) || rc;
        return rc;
    }

    public boolean addRole(Object variableId, Object role) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return false;
        }
        Object[] components = this.componentList.toArray();
        boolean rc = false;
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            rc = ((RoleInterface)components[i]).addRole(variableId, role) || rc;
        }
        return rc;
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public Object getAllVariables(Object role) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return null;
        }
        Object[] components = this.componentList.toArray();
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            return ((RoleInterface)components[i]).getAllVariables(role);
        }
        return null;
    }

    public Object getLimit(Object role) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return null;
        }
        Object[] components = this.componentList.toArray();
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            return ((RoleInterface)components[i]).getLimit(role);
        }
        return null;
    }

    public int getMaxAllowed(Object role) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return 0;
        }
        Object[] components = this.componentList.toArray();
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            return ((RoleInterface)components[i]).getMaxAllowed(role);
        }
        return 0;
    }

    public Object getRole(Object variableId) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return null;
        }
        Object[] components = this.componentList.toArray();
        Object[] rc = null;
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            Object roles = ((RoleInterface)components[i]).getRole(variableId);
            Vector v = new Vector();
            Enumeration e = Extract.elements((Object)roles);
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (this.xRole.equals(o) || this.yRole.equals(o)) continue;
                v.addElement(o);
            }
            if (v.size() <= 0) break;
            rc = v.toArray();
            break;
        }
        return rc;
    }

    public Object getRoleValue(Object role, int which) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return null;
        }
        Object[] components = this.componentList.toArray();
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            return ((RoleInterface)components[i]).getRoleValue(role, which);
        }
        return null;
    }

    public Object getSortOrder(Object role) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return null;
        }
        Object[] components = this.componentList.toArray();
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            return ((RoleInterface)components[i]).getSortOrder(role);
        }
        return null;
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return null;
        }
        Object[] components = this.componentList.toArray();
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            Object[] componentRoles = ((RoleInterface)components[i]).getSupportedRoles(id, discrete);
            if (componentRoles == null || componentRoles.length == 0) {
                return null;
            }
            Vector<Object> supportedRoles = new Vector<Object>();
            for (int j = 0; j < componentRoles.length; ++j) {
                if (this.xRole.equals(componentRoles[j]) || this.yRole.equals(componentRoles[j])) continue;
                supportedRoles.addElement(componentRoles[j]);
            }
            return supportedRoles.toArray();
        }
        return null;
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public Object getVariable(Object role) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return null;
        }
        Object[] components = this.componentList.toArray();
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            return ((RoleInterface)components[i]).getVariable(role);
        }
        return null;
    }

    public boolean isDiscrete(Object role) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return false;
        }
        Object[] components = this.componentList.toArray();
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            return ((RoleInterface)components[i]).isDiscrete(role);
        }
        return false;
    }

    public boolean removeRole(Object variableId, Object role) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return false;
        }
        Object[] components = this.componentList.toArray();
        boolean rc = false;
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            rc = ((RoleInterface)components[i]).removeRole(variableId, role) || rc;
        }
        return rc;
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public boolean requiresMultipleRoleAssignments() {
        if (this.componentList == null || this.componentList.size() == 0) {
            return false;
        }
        Object[] components = this.componentList.toArray();
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            return ((RoleInterface)components[i]).requiresMultipleRoleAssignments();
        }
        return false;
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return false;
        }
        Object[] components = this.componentList.toArray();
        boolean rc = false;
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            rc = ((RoleInterface)components[i]).setDiscrete(role, discrete) || rc;
        }
        return rc;
    }

    public boolean setLimit(Object role, Object value) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return false;
        }
        Object[] components = this.componentList.toArray();
        boolean rc = false;
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            rc = ((RoleInterface)components[i]).setLimit(role, value) || rc;
        }
        return rc;
    }

    public boolean setRole(Object variableId, Object role) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return false;
        }
        Object[] components = this.componentList.toArray();
        boolean rc = false;
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            rc = ((RoleInterface)components[i]).setRole(variableId, role) || rc;
        }
        return rc;
    }

    public boolean setSortOrder(Object role, Object order) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return false;
        }
        Object[] components = this.componentList.toArray();
        boolean rc = false;
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            rc = ((RoleInterface)components[i]).setSortOrder(role, order) || rc;
        }
        return rc;
    }

    public boolean supportsMultipleAssignments(Object role) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return false;
        }
        Object[] components = this.componentList.toArray();
        for (int i = 1; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof RoleInterface)) continue;
            return ((RoleInterface)components[i]).supportsMultipleAssignments(role);
        }
        return false;
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return false;
        }
        Object[] components = this.componentList.toArray();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null || !(components[i] instanceof BaseComponentInterface)) continue;
            return ((BaseComponentInterface)components[i]).applyWhereClause(clause, clearPrevious);
        }
        return false;
    }

    public void dispose() {
        this.clearAllComponents();
        this.xVarList = null;
        this.componentList = null;
        this.roles = null;
        this.xRole = null;
        this.yRole = null;
        super.dispose();
    }

    public void clearAllComponents() {
        if (this.xVarList == null || this.componentList == null) {
            return;
        }
        Enumeration e = this.xVarList.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof Hashtable)) continue;
            Enumeration e2 = ((Hashtable)o).elements();
            while (e2.hasMoreElements()) {
                Object o2 = e2.nextElement();
                if (!(o2 instanceof BaseComponentInterface)) continue;
                if (o2 instanceof BaseElementComponent) {
                    BaseElement[] arr = ((BaseElementComponent)o2).getCharts();
                    if (arr != null) {
                        for (int i = 0; i < arr.length; ++i) {
                            DataFilterReadInterface dfri = arr[i].getFilter();
                            FilterFactory.detachFilter((DataFilterReadInterface)dfri);
                            if (dfri == null) continue;
                            dfri.removeSource();
                        }
                    }
                } else {
                    DataFilterReadInterface dfri = ((BaseComponentInterface)o2).getFilter();
                    FilterFactory.detachFilter((DataFilterReadInterface)dfri);
                    if (dfri != null) {
                        dfri.removeSource();
                    }
                }
                ((BaseComponentInterface)o2).dispose();
            }
            ((Hashtable)o).clear();
        }
        this.xVarList.clear();
        this.componentList.clear();
        this.propertyMulticaster.removeAllListeners();
    }

    protected JComponent fetchComponent(String xVar, String yVar) {
        if (xVar == null || yVar == null) {
            return null;
        }
        Object o = this.xVarList.get(xVar);
        if (o instanceof Hashtable) {
            return (JComponent)((Hashtable)o).get(yVar);
        }
        return null;
    }

    protected void storeComponent(String xVar, String yVar, JComponent jc) {
        if (xVar == null || yVar == null || jc == null) {
            return;
        }
        Hashtable h = null;
        Object o = this.xVarList.get(xVar);
        if (o == null) {
            h = new Hashtable();
            this.xVarList.put(xVar, h);
        } else if (o instanceof Hashtable) {
            h = (Hashtable)o;
        }
        if (h != null) {
            h.put(yVar, jc);
        }
        if (!this.componentList.contains(jc)) {
            this.componentList.add(jc);
        }
    }

    protected abstract JComponent createComponent(String var1, String var2);

    protected JLabel getLabel(Object variable) {
        String label = "<HTML><CENTER>{0}</CENTER></HTML>";
        Object[] args = new Object[]{this.getDataFilter().getVariableDescription(variable).toString()};
        String text = MessageFormat.format(label, args);
        JLabel jl = new JLabel(text, 0);
        Font font = this.style.getTextStyleElement("LabelText").getFont();
        jl.setFont(font.deriveFont(this.getLabelFontSize(jl)));
        return jl;
    }

    protected JComponent getHistogram(Object data, Object variable) {
        BaseHistComponent hist = new BaseHistComponent();
        hist.setDataSource(data);
        hist.setRole(variable, (Object)RoleInterface.ROLE_X);
        return hist;
    }

    private float getLabelFontSize(JLabel label) {
        double cellHeight;
        float font_size;
        if (this.componentList == null || this.componentList.size() == 0) {
            if (label != null) {
                return label.getFont().getSize();
            }
            return 0.0f;
        }
        Object[] components = this.componentList.toArray();
        double height = 0.0;
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JComponent)) continue;
            height = ((JComponent)components[i]).getHeight();
            break;
        }
        if ((font_size = (float)((cellHeight = height - 50.0) * 0.021 * 1.38889)) < 9.0f) {
            font_size = 9.0f;
        } else if (font_size > 16.0f) {
            font_size = 16.0f;
        }
        return font_size;
    }

    public boolean initComponentsFromXML(Element chart, Hashtable context) {
        if (chart == null || this.componentList == null) {
            return false;
        }
        Object[] components = this.componentList.toArray();
        if (components == null) {
            return false;
        }
        for (int i = 0; i < components.length; ++i) {
            Object o;
            if (!(components[i] instanceof GraphInterface)) continue;
            Object oldId = null;
            BaseElement be = null;
            if (components[i] instanceof BaseElementComponent && (o = ((BaseElementComponent)components[i]).getChart(null)) instanceof BaseElement) {
                be = (BaseElement)o;
                oldId = be.getId();
                be.setId((Object)MATRIX_CHART_ID);
            }
            SILKParser.initComponentFromXML((Object)components[i], (Element)chart, (Hashtable)context);
            if (be == null) continue;
            be.setId(oldId);
        }
        this.setLegendVisible(this.groupRole.toString(), false);
        this.setLegendVisible(this.colorRole.toString(), false);
        return true;
    }

    public Element getComponentStatgraphXML(Hashtable context) {
        int j;
        Object o;
        if (this.componentList == null) {
            return null;
        }
        Object[] components = this.componentList.toArray();
        if (components == null) {
            return null;
        }
        int i = 0;
        while (++i < components.length && !(components[i] instanceof GraphInterface)) {
        }
        if (i >= components.length) {
            return null;
        }
        ElementParserInterface parser = GraphParserFactory.loadParser((Object)components[i]);
        if (context == null) {
            context = new Hashtable<String, Boolean>();
        }
        Object val = context.get("SCRIPT_ROLES");
        context.put("SCRIPT_ROLES", new Boolean(true));
        Object oldId = null;
        BaseElement be = null;
        if (components[i] instanceof BaseElementComponent && (o = ((BaseElementComponent)components[i]).getChart(null)) instanceof BaseElement) {
            be = (BaseElement)o;
            oldId = be.getId();
            be.setId((Object)MATRIX_CHART_ID);
        }
        Element chart = parser.putToXML(context, components[i]);
        if (be != null) {
            be.setId(oldId);
        }
        int c = 1;
        Element ce = ParserUtils.getChildWithTagName((String)"Role", (Element)chart, (int)c);
        while (ce != null) {
            ce = ParserUtils.getChildWithTagName((String)"Role", (Element)chart, (int)(++c));
        }
        chart.removeAttribute("data");
        NodeList children = chart.getChildNodes();
        int numChildren = children.getLength();
        Vector<Node> invalidChildren = new Vector<Node>();
        for (j = 0; j < numChildren; ++j) {
            int k;
            Node child = children.item(j);
            NodeList nl = child.getChildNodes();
            for (k = 0; k < nl.getLength(); ++k) {
                Node n = nl.item(k);
                if (!"Role".equalsIgnoreCase(n.getNodeName())) continue;
                NamedNodeMap nnm = n.getAttributes();
                Node type = nnm.getNamedItem("type");
                if (!this.xRole.toString().equalsIgnoreCase(type.getNodeValue()) && !this.yRole.toString().equalsIgnoreCase(type.getNodeValue())) continue;
                invalidChildren.add(n);
            }
            for (k = 0; k < invalidChildren.size(); ++k) {
                child.removeChild((Node)invalidChildren.elementAt(k));
            }
            invalidChildren.clear();
        }
        for (j = 0; j < invalidChildren.size(); ++j) {
            chart.removeChild((Node)invalidChildren.elementAt(j));
        }
        if (val != null) {
            context.put("SCRIPT_ROLES", (Boolean)val);
        }
        return chart;
    }

    public Element getLegendStatgraphXML(Hashtable context) {
        LegendObjectJ2D legend = this.legendBuilder.getLegend(this.currentLegend);
        if (legend != null) {
            LegendParser lp = new LegendParser();
            return lp.putToXML(context, (Object)legend);
        }
        return null;
    }

    public void initLegendsFromXML(Element element) {
        if (element == null) {
            return;
        }
        Element legendXML = ParserUtils.getChildWithTagName((String)"Legend", (Element)element);
        if (legendXML == null && "Legend".equalsIgnoreCase(element.getTagName())) {
            legendXML = element;
        }
        LegendObjectJ2D legend = this.legendBuilder.getLegend(this.currentLegend);
        if (legendXML != null && legend != null) {
            LegendParser.parseLegend((Element)legendXML, (LegendInterface)legend);
        }
    }

    public void initLegends() {
        this.legendBuilder.removeAllCharts();
        this.legendBuilder.addCharts((Collection)this.componentList);
    }

    public void buildLegends(int roleInt, boolean rebuildLegends) {
        switch (roleInt) {
            case 2: 
            case 6: 
            case 7: {
                Hashtable context = new Hashtable();
                Element legendXML = this.getLegendStatgraphXML(context);
                if (rebuildLegends) {
                    this.legendBuilder.buildLegends();
                    SILKNumber[] names = this.legendBuilder.getLegendNames();
                    if (names != null && names.length > 0) {
                        LegendObjectJ2D legend = this.legendBuilder.getLegend(names[0]);
                        if (legend != null && legendXML != null) {
                            LegendParser.parseLegend((Element)legendXML, (LegendInterface)legend);
                        }
                        if (names.length > 0) {
                            this.currentLegend = names[0];
                        }
                    } else {
                        this.currentLegend = null;
                    }
                } else {
                    this.legendBuilder.updateLegends();
                }
                this.setLegendVisible(this.groupRole.toString(), false);
                this.setLegendVisible(this.colorRole.toString(), false);
            }
        }
    }

    public void setLegendVisible(String legendName, boolean visible) {
        if (this.componentList == null || this.componentList.size() == 0) {
            return;
        }
        Object[] components = this.componentList.toArray();
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof PropertyInterface)) continue;
                PropertyInterface p = (PropertyInterface)components[i];
                p.setPropertyValue(23, (Object)legendName);
                p.setPropertyValue(420, (Object)new Boolean(false));
                p.applyPropertyChanges();
            }
        }
    }

    public void setDiagonal(int type) {
        this.diagonalType = type;
    }

    public int getDiagonal() {
        return this.diagonalType;
    }
}

