/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.map;

import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ZoomWindow
extends JDialog {
    private static final long serialVersionUID = -7671967541159493534L;
    ImagePanel imagePanel;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.map.silk_map_NLS");

    public ZoomWindow(Frame parent) {
        super(parent);
        this.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ZoomWindow.Zoom_Window.txt", (String)"Zoom Window"));
        this.setModal(false);
        this.setSize(200, 200);
        this.imagePanel = new ImagePanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.imagePanel);
    }

    public void setImage(BufferedImage i) {
        this.imagePanel.setImage(i);
    }

    public void setOffset(Point p) {
        this.imagePanel.setOffset(p);
    }

    public class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = -3673227665935045341L;
        BufferedImage image = null;
        Point offset = null;

        @Override
        public void paintComponent(Graphics g) {
            if (this.image != null) {
                if (this.offset == null) {
                    this.offset = new Point(this.image.getWidth() / 4, this.image.getHeight() / 4);
                }
                g.setColor(Color.lightGray);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.drawImage(this.image, this.getWidth() / 2 - 2 * this.offset.x, this.getHeight() / 2 - this.offset.y * 2, null);
            }
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public void setImage(BufferedImage image) {
            this.image = image;
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point offset) {
            this.offset = offset;
        }
    }
}

