/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.map;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.map.Bucket;
import com.sas.graphics.util.SortedVector;

public class Categorization {
    public static final int CONTINUOUS = 0;
    public static final int DISCRETE = 1;
    public static final int QUANTILE = 2;
    public static final int EQUALWIDTH = 3;
    public static final int CUSTOMDISCRETE = 4;
    public static final int CUSTOMCONTINUOUS = 5;
    private static final String[] names = new String[]{"Continuous", "Discrete", "Quantile", "EqualWidth", "CustomDiscrete", "CustomContinuous"};
    private int categoryType = 2;
    private int categorySize = 2;
    private double[] categoryRanges = null;

    public Categorization() {
        this.categoryType = 0;
        this.categorySize = 2;
    }

    public Categorization(int type) {
        this.categoryType = type;
    }

    public Categorization(int type, int size) {
        this.categoryType = type;
        this.categorySize = size;
    }

    public void setCategoryType(int i) {
        this.categoryType = i;
    }

    public int getCategoryType() {
        return this.categoryType;
    }

    public void setCategorySize(int i) {
        this.categorySize = i;
    }

    public int getCategorySize() {
        return this.categorySize;
    }

    public void setCustomCategoryRanges(double[] d) {
        this.categoryRanges = d;
    }

    public double[] getCustomCategoryRanges() {
        return this.categoryRanges;
    }

    public String getCategorizationName() {
        return names[this.categoryType];
    }

    public double[] getNumericRanges(DataFilterReadInterface data, Object role) {
        switch (this.categoryType) {
            case 0: {
                return Categorization.getContinuousRanges(data, role, this.categorySize);
            }
            case 2: {
                return this.getQuantileRanges(data, role, this.categorySize);
            }
            case 3: {
                return Categorization.getEqualWidthRanges(data, role, this.categorySize);
            }
            case 1: {
                return Categorization.getDiscreteRanges(data, role);
            }
            case 4: 
            case 5: {
                return this.categoryRanges;
            }
        }
        return null;
    }

    private static SortedVector getUniqueValueVector(DataFilterReadInterface data, Object role, boolean sorted) {
        SortedVector vec = new SortedVector();
        vec.setSortingOn(false);
        int num = data.getNumberObservations(role);
        for (int i = 0; i < num; ++i) {
            Object o = data.getValue(role, (long)i);
            if (data.isMissing(role, o) || !data.isGraphed((long)i)) continue;
            vec.addElement(o);
        }
        vec.setSortingOn(true);
        return vec;
    }

    private static SortedVector getValueVector(DataFilterReadInterface data, Object role) {
        SortedVector vec = new SortedVector(true);
        vec.setSortingOn(false);
        int num = data.getNumberObservations(role);
        for (int i = 0; i < num; ++i) {
            Object o = data.getValue(role, (long)i);
            if (data.isMissing(role, o) || !data.isGraphed((long)i)) continue;
            vec.addElement(o);
        }
        vec.setSortingOn(true);
        return vec;
    }

    public static double[] getContinuousRanges(DataFilterReadInterface data, Object role, int numLevels) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        if (data == null || role == null || numLevels < 1) {
            return new double[0];
        }
        int num = data.getNumberObservations(role);
        for (int i = 0; i < num; ++i) {
            Object o = data.getValue(role, (long)i);
            if (data.isMissing(role, o) || !data.isGraphed((long)i)) continue;
            double d = (Double)o;
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        double[] ranges = new double[numLevels];
        if (num == 0) {
            return new double[0];
        }
        double minData = min;
        double maxData = num == 1 ? minData : max;
        for (int i = 0; i <= numLevels - 1; ++i) {
            ranges[i] = minData + (maxData - minData) / (double)(numLevels - 1) * (double)i;
        }
        ranges[0] = minData;
        ranges[numLevels - 1] = maxData;
        return ranges;
    }

    public static double[] getEqualWidthRanges(DataFilterReadInterface data, Object role, int numLevels) {
        if (data == null || role == null || numLevels < 1) {
            return new double[0];
        }
        SortedVector uniqueValues = Categorization.getUniqueValueVector(data, role, true);
        double minData = (Double)uniqueValues.firstElement();
        double maxData = (Double)uniqueValues.lastElement();
        double[] bucketInfo = Bucket.calcMidpoints(numLevels, minData, maxData);
        double start = bucketInfo[0];
        double size = bucketInfo[1];
        double[] ranges = new double[numLevels + 1];
        for (int i = 0; i < numLevels - 1; ++i) {
            ranges[i + 1] = start + (double)i * size + size / 2.0;
        }
        ranges[0] = minData;
        ranges[numLevels] = maxData;
        return ranges;
    }

    public static double[] getDiscreteRanges(DataFilterReadInterface data, Object role) {
        return Categorization.getDiscreteRanges(data, role, true);
    }

    public static double[] getDiscreteRanges(DataFilterReadInterface data, Object role, boolean sorted) {
        if (data == null || role == null) {
            return new double[0];
        }
        SortedVector uniqueValues = Categorization.getUniqueValueVector(data, role, sorted);
        double[] ranges = new double[uniqueValues.size()];
        int j = 0;
        for (int i = 0; i < uniqueValues.size(); ++i) {
            ranges[j++] = (Double)uniqueValues.elementAt(i);
        }
        return ranges;
    }

    public static String[] getStringRanges(DataFilterReadInterface data, Object role) {
        return Categorization.getStringRanges(data, role, true);
    }

    public static String[] getStringRanges(DataFilterReadInterface data, Object role, boolean sorted) {
        if (data == null || role == null) {
            return new String[0];
        }
        SortedVector uniqueValues = Categorization.getUniqueValueVector(data, role, sorted);
        String[] values = new String[uniqueValues.size()];
        for (int i = 0; i < uniqueValues.size(); ++i) {
            values[i] = (String)uniqueValues.elementAt(i);
        }
        return values;
    }

    private double[] getQuantileRanges(DataFilterReadInterface data, Object role, int numLevels) {
        int i;
        if (data == null || role == null) {
            return null;
        }
        SortedVector uniqueValues = Categorization.getUniqueValueVector(data, role, true);
        SortedVector nonUniqueValues = Categorization.getValueVector(data, role);
        double[] numericValues = new double[nonUniqueValues.size()];
        for (i = 0; i < nonUniqueValues.size(); ++i) {
            numericValues[i] = (Double)nonUniqueValues.elementAt(i);
        }
        if (numLevels > uniqueValues.size()) {
            numLevels = uniqueValues.size();
        }
        double[] values = new double[numLevels + 1];
        int iNumUniqueValues = uniqueValues.size();
        if (numLevels == iNumUniqueValues) {
            double[] foo = new double[iNumUniqueValues + 1];
            for (i = 0; i < iNumUniqueValues; ++i) {
                foo[i + 1] = (Double)uniqueValues.elementAt(i);
            }
            foo[0] = foo[1];
            return foo;
        }
        Quantile[] asQuantiles = new Quantile[numLevels];
        for (int g = 0; g < numLevels; ++g) {
            asQuantiles[g] = new Quantile();
        }
        int iNumNonMissingValues = numericValues.length;
        double dPercentileStep = (double)iNumNonMissingValues / (double)numLevels;
        for (int iLevel = 0; iLevel < numLevels; ++iLevel) {
            asQuantiles[iLevel].iStart = (int)Math.floor(dPercentileStep * (double)iLevel);
            asQuantiles[iLevel].dVal = numericValues[asQuantiles[iLevel].iStart];
        }
        this.Balance(asQuantiles, numericValues, 0);
        for (i = 0; i < asQuantiles.length; ++i) {
            values[i] = numericValues[asQuantiles[i].iStart];
        }
        values[0] = (Double)uniqueValues.firstElement();
        values[values.length - 1] = (Double)uniqueValues.lastElement();
        return values;
    }

    protected int Balance(Quantile[] asQuantiles, double[] adValues, int iCurrentPos) {
        int j;
        int nVals = adValues.length;
        int nQtiles = asQuantiles.length;
        if (iCurrentPos == 0) {
            int j2;
            boolean bFound;
            Quantile q;
            int i;
            block0: for (i = 1; i < nQtiles; ++i) {
                q = asQuantiles[i];
                Quantile qPrev = asQuantiles[i - 1];
                if (q.dVal != qPrev.dVal) {
                    while (q.iStart != 0 && q.dVal == adValues[q.iStart - 1]) {
                        --q.iStart;
                    }
                }
                int iStart = q.iStart;
                while (q.dVal <= qPrev.dVal) {
                    if (q.iStart >= nVals - 1) {
                        q.iStart = iStart;
                        q.dVal = adValues[iStart];
                        i = nQtiles;
                        continue block0;
                    }
                    if (q.iStart < qPrev.iStart) {
                        q.iStart = qPrev.iStart;
                    }
                    q.dVal = adValues[++q.iStart];
                }
            }
            if (asQuantiles[nQtiles - 1].dVal == adValues[nVals - 1]) {
                while (adValues[nVals - 1] == adValues[asQuantiles[nQtiles - 1].iStart - 1]) {
                    asQuantiles[nQtiles - 1].dVal = adValues[--asQuantiles[nQtiles - 1].iStart];
                }
            }
            i = nQtiles;
            while (--i >= 0) {
                q = asQuantiles[i];
                if (i == nQtiles - 1) {
                    q.nVals = nVals - q.iStart;
                } else {
                    Quantile qNext = asQuantiles[i + 1];
                    while (q.dVal >= qNext.dVal) {
                        if (qNext.iStart < q.iStart) {
                            q.iStart = qNext.iStart;
                        }
                        q.dVal = adValues[--q.iStart];
                    }
                    q.nVals = qNext.iStart - q.iStart;
                }
                q.bLock = q.dVal == adValues[q.iStart + q.nVals - 1] && q.nVals > (int)((double)nVals / (double)nQtiles);
            }
            i = nQtiles;
            while (--i > 0) {
                bFound = false;
                if (asQuantiles[i].bLock) continue;
                while (!bFound) {
                    j2 = i;
                    while (--j2 >= 0) {
                        if (asQuantiles[j2].bLock) {
                            j2 = -1;
                            break;
                        }
                        if (asQuantiles[i].nVals - 1 <= asQuantiles[j2].nVals) continue;
                        if (this.Balance(asQuantiles, adValues, i) != 0) {
                            i = nQtiles;
                        }
                        j2 = -1;
                        break;
                    }
                    bFound = j2 == -1;
                }
            }
            for (i = 0; i < nQtiles - 1; ++i) {
                bFound = false;
                if (asQuantiles[i].bLock) continue;
                while (!bFound) {
                    for (j2 = i + 1; j2 < nQtiles; ++j2) {
                        if (asQuantiles[j2].bLock) {
                            j2 = nQtiles;
                            break;
                        }
                        if (asQuantiles[i].nVals - 1 <= asQuantiles[j2].nVals) continue;
                        if (this.Balance(asQuantiles, adValues, -(i + 1)) != 0) {
                            i = -1;
                        }
                        j2 = nQtiles;
                        break;
                    }
                    bFound = j2 == nQtiles;
                }
            }
            return 0;
        }
        if (iCurrentPos < 0) {
            int i;
            iCurrentPos = -(iCurrentPos + 1);
            int j3 = 0;
            Quantile q = asQuantiles[iCurrentPos];
            Quantile qNext = asQuantiles[iCurrentPos + 1];
            if (!qNext.bLock) {
                int iMost = q.nVals - qNext.nVals - 1;
                int iLeast = Math.max(1, iMost / 2);
                if (iMost < 0) {
                    return 0;
                }
                if (iMost == 0) {
                    iMost = 1;
                }
                i = q.iStart + q.nVals - 1;
                for (j3 = iLeast - 1; j3 < iMost && !(adValues[i - j3] > adValues[i - j3 - 1]); ++j3) {
                }
                if (j3 == iMost) {
                    return 0;
                }
                q.nVals -= ++j3;
                qNext.iStart -= j3;
                qNext.nVals += j3;
                qNext.dVal = adValues[qNext.iStart];
            }
            for (i = iCurrentPos; i < nQtiles - 1; ++i) {
                if (asQuantiles[i].nVals - 1 <= asQuantiles[i + 1].nVals || asQuantiles[i].bLock || asQuantiles[i + 1].bLock) continue;
                j3 += this.Balance(asQuantiles, adValues, -(i + 1));
                break;
            }
            return j3;
        }
        Quantile q = asQuantiles[iCurrentPos];
        Quantile qPrev = asQuantiles[iCurrentPos - 1];
        if (q.bLock || qPrev.bLock || q.dVal == adValues[nVals - 1]) {
            return 0;
        }
        int iMost = q.nVals - qPrev.nVals - 1;
        int iLeast = Math.max(1, iMost / 2);
        if (iMost < 0) {
            return 0;
        }
        if (iMost == 0) {
            iMost = 1;
        }
        int i = q.iStart;
        for (j = iLeast - 1; j < iMost && !(adValues[i + j] < adValues[i + j + 1]); ++j) {
        }
        if (j == iMost) {
            return 0;
        }
        qPrev.nVals += ++j;
        q.iStart += j;
        q.dVal = adValues[q.iStart];
        q.nVals -= j;
        int ii = --iCurrentPos;
        while (--ii >= 0) {
            if (asQuantiles[iCurrentPos].nVals - 1 <= asQuantiles[ii].nVals) continue;
            if (asQuantiles[iCurrentPos].bLock || asQuantiles[ii].bLock) break;
            j += this.Balance(asQuantiles, adValues, iCurrentPos);
            break;
        }
        return j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sort(double[] sortlist, int n_in) {
        int curlen;
        int parent;
        Object o;
        int n = n_in;
        if (sortlist == null || sortlist.length == 0) {
            return;
        }
        if (n < 0) {
            n = sortlist.length;
        }
        Object object = o = new Object();
        synchronized (object) {
            parent = n / 2 + 1;
            curlen = n;
            o = null;
        }
        while (true) {
            double holder;
            if (parent > 1) {
                holder = sortlist[--parent - 1];
            } else {
                holder = sortlist[curlen - 1];
                sortlist[curlen - 1] = sortlist[0];
                if (--curlen == 0) {
                    sortlist[0] = holder;
                    return;
                }
            }
            int curnode = parent;
            int largest_child = parent + parent;
            while (largest_child <= curlen) {
                if (largest_child < curlen && sortlist[largest_child - 1] < sortlist[largest_child]) {
                    ++largest_child;
                }
                if (holder < sortlist[largest_child - 1]) {
                    sortlist[curnode - 1] = sortlist[largest_child - 1];
                    curnode = largest_child;
                    largest_child += largest_child;
                    continue;
                }
                largest_child = curlen + 1;
            }
            sortlist[curnode - 1] = holder;
        }
    }

    protected class Quantile {
        double dVal;
        int iStart;
        int nVals;
        boolean bLock;

        protected Quantile() {
        }
    }
}

