/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.map;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.LinearRing;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.WKBMultiPolygon;
import com.sas.graphics.util.WKBPolygon;

public class BlobReader {
    private char[] charArray = null;
    private int charArrayPointer = 0;
    public WKBMultiPolygon[] multiPolygons = null;
    public int numMultiPolygons = 0;
    public double xMin;
    public double xMax;
    public double yMin;
    public double yMax;
    protected DataFilterReadInterface spatialData = null;
    protected Object spatialRoleID = null;

    public BlobReader() {
    }

    public BlobReader(DataFilterReadInterface data, Object role) {
        this.spatialData = data;
        this.spatialRoleID = role;
        this.readMapFromStrings();
    }

    public void setData(DataFilterReadInterface data, Object role) {
        this.spatialData = data;
        this.spatialRoleID = role;
        this.readMapFromStrings();
    }

    public int getNumMultiPolygons() {
        return this.numMultiPolygons;
    }

    public WKBMultiPolygon[] getMultiPolygons() {
        return this.multiPolygons;
    }

    protected void readMapFromStrings() {
        this.numMultiPolygons = this.spatialData.getNumberObservations(this.spatialRoleID);
        this.multiPolygons = new WKBMultiPolygon[this.numMultiPolygons];
        for (int i = 0; i < this.numMultiPolygons; ++i) {
            try {
                String tempString = (String)this.spatialData.getValue(this.spatialRoleID, (long)i);
                if (tempString.length() == 0) {
                    this.multiPolygons[i] = null;
                    continue;
                }
                this.charArray = tempString.toCharArray();
                this.charArrayPointer = 0;
                this.multiPolygons[i] = this.readMultiPolygon();
                continue;
            }
            catch (Throwable e) {
                System.out.println("Error reading map data: index=" + i);
            }
        }
    }

    public WKBMultiPolygon readMultiPolygon() {
        long numPolygons;
        int type;
        WKBMultiPolygon multiPolygon = new WKBMultiPolygon();
        String endian = new String(this.charArray, this.charArrayPointer, 2);
        this.charArrayPointer += 4;
        multiPolygon.byteOrder = this.getByteFromString(endian) == 1;
        String typeString = new String(this.charArray, this.charArrayPointer, 4);
        this.charArrayPointer += 4;
        multiPolygon.wkbType = type = this.getIntFromString(typeString, multiPolygon.byteOrder);
        String numPolygonsString = new String(this.charArray, this.charArrayPointer, 8);
        this.charArrayPointer += 8;
        multiPolygon.num_wkbPolygons = numPolygons = this.getLongFromString(numPolygonsString, multiPolygon.byteOrder);
        multiPolygon.WKBPolygons = new WKBPolygon[(int)numPolygons];
        int i = 0;
        while ((long)i < numPolygons) {
            multiPolygon.WKBPolygons[i] = this.readPolygon();
            ++i;
        }
        return multiPolygon;
    }

    public WKBPolygon readPolygon() {
        WKBPolygon polygon = new WKBPolygon();
        String interiorEndianString = new String(this.charArray, this.charArrayPointer, 2);
        this.charArrayPointer += 4;
        polygon.byteOrder = this.getByteFromString(interiorEndianString) == 1;
        String typeString = new String(this.charArray, this.charArrayPointer, 4);
        this.charArrayPointer += 4;
        polygon.wkbType = this.getIntFromString(typeString, polygon.byteOrder);
        String numRingsString = new String(this.charArray, this.charArrayPointer, 8);
        this.charArrayPointer += 8;
        polygon.numRings = this.getLongFromString(numRingsString, polygon.byteOrder);
        polygon.rings = new LinearRing[(int)polygon.numRings];
        int i = 0;
        while ((long)i < polygon.numRings) {
            polygon.rings[i] = new LinearRing();
            String numPointsString = new String(this.charArray, this.charArrayPointer, 8);
            this.charArrayPointer += 8;
            polygon.rings[i].numPoints = this.getLongFromString(numPointsString, polygon.byteOrder);
            this.charArrayPointer += 8;
            polygon.rings[i].points = new Vec3d[(int)polygon.rings[i].numPoints];
            int j = 0;
            while ((long)j < polygon.rings[i].numPoints) {
                String xString = new String(this.charArray, this.charArrayPointer, 16);
                this.charArrayPointer += 16;
                String yString = new String(this.charArray, this.charArrayPointer, 16);
                this.charArrayPointer += 16;
                polygon.rings[i].points[j] = new Vec3d(this.getDoubleFromString(xString, polygon.byteOrder), this.getDoubleFromString(yString, polygon.byteOrder), 0.0);
                if (polygon.rings[i].points[j].x < this.xMin) {
                    this.xMin = polygon.rings[i].points[j].x;
                }
                if (polygon.rings[i].points[j].x > this.xMax) {
                    this.xMax = polygon.rings[i].points[j].x;
                }
                if (polygon.rings[i].points[j].y < this.yMin) {
                    this.yMin = polygon.rings[i].points[j].y;
                }
                if (polygon.rings[i].points[j].y > this.yMax) {
                    this.yMax = polygon.rings[i].points[j].y;
                }
                ++j;
            }
            ++i;
        }
        return polygon;
    }

    public byte getByteFromString(String tempString) {
        return Byte.parseByte(tempString, 16);
    }

    public int getIntFromString(String tempString, boolean bigEndian) {
        if (bigEndian) {
            tempString = this.swapEnd(tempString);
        }
        return Integer.parseInt(tempString, 16);
    }

    public long getLongFromString(String tempString, boolean bigEndian) {
        if (bigEndian) {
            tempString = this.swapEnd(tempString);
        }
        return Long.parseLong(tempString, 16);
    }

    public double getDoubleFromString(String tempString, boolean bigEndian) {
        if (bigEndian) {
            tempString = this.swapEnd(tempString);
        }
        return Double.longBitsToDouble(this.getLongBitsFromString(tempString));
    }

    public long getLongBitsFromString(String tempString) {
        long l = 0L;
        int shift = 0;
        for (int i = 15; i >= 0; --i) {
            switch (tempString.charAt(i)) {
                case '0': {
                    break;
                }
                case '1': {
                    l += 1L << shift;
                    break;
                }
                case '2': {
                    l += 2L << shift;
                    break;
                }
                case '3': {
                    l += 3L << shift;
                    break;
                }
                case '4': {
                    l += 4L << shift;
                    break;
                }
                case '5': {
                    l += 5L << shift;
                    break;
                }
                case '6': {
                    l += 6L << shift;
                    break;
                }
                case '7': {
                    l += 7L << shift;
                    break;
                }
                case '8': {
                    l += 8L << shift;
                    break;
                }
                case '9': {
                    l += 9L << shift;
                    break;
                }
                case 'A': 
                case 'a': {
                    l += 10L << shift;
                    break;
                }
                case 'B': 
                case 'b': {
                    l += 11L << shift;
                    break;
                }
                case 'C': 
                case 'c': {
                    l += 12L << shift;
                    break;
                }
                case 'D': 
                case 'd': {
                    l += 13L << shift;
                    break;
                }
                case 'E': 
                case 'e': {
                    l += 14L << shift;
                    break;
                }
                case 'F': 
                case 'f': {
                    l += 15L << shift;
                }
            }
            shift += 4;
        }
        return l;
    }

    public String swapEnd(String tempString) {
        char[] ary = tempString.toCharArray();
        char[] rev = new char[ary.length];
        int placement = 0;
        for (int i = ary.length - 1; i >= 0; i -= 2) {
            rev[placement++] = ary[i - 1];
            rev[placement++] = ary[i];
        }
        return new String(rev);
    }
}

