/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.icicle;

import com.sas.graphics.silk.icicle.IcicleNode;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.GeometryInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.TreeModelInterface;
import com.sas.graphics.silk.interfaces.TreeNodeInterface;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.styles.Style;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Vector;

public class IcicleRenderer
implements RenderInterface,
GeometryInterface {
    Color borderColor;
    Color nodeSolidColor;
    IcicleNode root;
    int nodeHeight;
    int maxLevel;
    private Rectangle chartArea = null;
    ResourceBundle rb = null;
    Object tipText;
    private TreeModelInterface data = null;
    private GraphInterface graph = null;
    private double nodeSizeMin = 0.0;
    private double nodeSizeMax = 1.0;
    private double nodeColorMin = 0.0;
    private double nodeColorMax = 1.0;

    public IcicleRenderer(TreeModelInterface model) {
        this.data = model;
        this.root = null;
        this.borderColor = Color.black;
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.icicle.silk_icicle_NLS");
    }

    public void setGraph(GraphInterface graph) {
        this.graph = graph;
    }

    public void setNodeSizeRange(double min, double max) {
        this.nodeSizeMin = min;
        this.nodeSizeMax = max;
    }

    public void setNodeColorRange(double min, double max) {
        this.nodeColorMin = min;
        this.nodeColorMax = max;
    }

    private void drawNode(Graphics2D g2d, IcicleNode node) {
        if (node == null) {
            return;
        }
        node.setWidth((int)((double)this.chartArea.width * node.getNodeSize() / this.root.getNodeSize()));
        ColorSchemeInterface csi = null;
        if (this.graph != null) {
            csi = this.graph.getColorScheme();
        }
        Style style = csi.getStyle();
        ColorRamp ramp = new ColorRamp((Object)style.getRampStyleElement("TwoColorAltRamp").getThreeColors(), (Object)new Double(0.0), (Object)new Double(1.0), 0L);
        if (style != null) {
            double nodeColor = Double.NaN;
            if (node.data instanceof TreeNodeInterface) {
                nodeColor = ((TreeNodeInterface)node.data).getNodeColorValue();
            }
            Color c = null;
            if (this.nodeSizeMin == this.nodeSizeMax) {
                Color[] clrs = ramp.getColors();
                c = clrs[clrs.length - 1];
            } else if (!this.data.isDefined(2)) {
                nodeColor = node.getNodeSize();
                c = ramp.queryDouble(nodeColor, this.nodeSizeMin, this.nodeSizeMax, false, null);
            } else if (this.nodeColorMin == this.nodeColorMax) {
                Color[] clrs = ramp.getColors();
                c = clrs[clrs.length - 1];
            } else {
                c = ramp.queryDouble(nodeColor, this.nodeColorMin, this.nodeColorMax, false, null);
            }
            g2d.setColor(c);
        } else if (this.nodeSolidColor != null) {
            g2d.setColor(this.nodeSolidColor);
        }
        g2d.fillRect(node.getXStart(), this.chartArea.y + node.getLevel() * this.nodeHeight, node.getWidth(), this.nodeHeight);
        if (csi != null) {
            g2d.setColor(csi.getColorSchemeItemColor(6));
            g2d.drawRect(node.getXStart(), this.chartArea.y + node.getLevel() * this.nodeHeight, node.getWidth(), this.nodeHeight);
        }
        if (node.sibling != null) {
            node.sibling.setXStart(node.getXStart() + node.getWidth());
        }
        if (node.child != null) {
            node.child.setXStart(node.getXStart());
        }
        this.drawNode(g2d, node.sibling);
        if (!this.data.isCollapsed(node.getId())) {
            this.drawNode(g2d, node.child);
        }
    }

    private void drawSelectedNode(Graphics2D g2d, IcicleNode node) {
        if (node == null || this.chartArea == null) {
            return;
        }
        if (this.data.isSelected(node.getId())) {
            g2d.setStroke(new BasicStroke(3.0f));
            if (this.graph != null && this.graph.getColorScheme() != null) {
                g2d.setColor(this.graph.getColorScheme().getColorSchemeItemColor(6));
            } else {
                g2d.setColor(new Color(255, 197, 0));
            }
            g2d.drawRect(node.getXStart(), this.chartArea.y + node.getLevel() * this.nodeHeight, node.getWidth(), this.nodeHeight);
        }
        this.drawSelectedNode(g2d, node.sibling);
        if (!this.data.isCollapsed(node.getId())) {
            this.drawSelectedNode(g2d, node.child);
        }
    }

    public IcicleNode retrieveFocusedNode(IcicleNode node, int xPos, int yPos) {
        IcicleNode cn = null;
        if (node == null) {
            return cn;
        }
        int xs = this.chartArea.x + node.getXStart();
        int ys = this.chartArea.y + node.getLevel() * this.nodeHeight;
        int xe = xs + node.getWidth();
        int ye = ys + this.nodeHeight;
        if (xPos >= xs && yPos >= ys && xPos < xe && yPos < ye) {
            cn = node;
        } else {
            cn = this.retrieveFocusedNode(node.sibling, xPos, yPos);
            if (cn == null) {
                cn = this.retrieveFocusedNode(node.child, xPos, yPos);
            }
        }
        return cn;
    }

    public IcicleNode getSelectedNode(IcicleNode node) {
        IcicleNode cn = null;
        if (node == null) {
            return cn;
        }
        if (this.data.isSelected(node.getId())) {
            return node;
        }
        cn = this.getSelectedNode(node.sibling);
        if (cn == null) {
            cn = this.getSelectedNode(node.child);
        }
        return cn;
    }

    public void getSelectedNode(Vector selectedNodes, IcicleNode node) {
        if (node == null) {
            return;
        }
        if (this.data.isSelected(node.getId())) {
            selectedNodes.addElement(node);
        }
        this.getSelectedNode(selectedNodes, node.sibling);
        this.getSelectedNode(selectedNodes, node.child);
    }

    public IcicleNode getCollapsedNode(IcicleNode node) {
        IcicleNode cn = null;
        if (node == null) {
            return cn;
        }
        if (this.data.isCollapsed(node.getId())) {
            return node;
        }
        cn = this.getCollapsedNode(node.sibling);
        if (cn == null) {
            cn = this.getCollapsedNode(node.child);
        }
        return cn;
    }

    public void getCollapsedNode(Vector collapsedNodes, IcicleNode node) {
        if (node == null) {
            return;
        }
        if (this.data.isCollapsed(node.getId())) {
            collapsedNodes.addElement(node);
        }
        this.getCollapsedNode(collapsedNodes, node.sibling);
        this.getCollapsedNode(collapsedNodes, node.child);
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setRoot(IcicleNode node) {
        this.root = node;
    }

    public void setMaxLevel(int lvl) {
        this.maxLevel = lvl;
    }

    public Object getTipText(MouseEvent me) {
        IcicleNode currentNode = this.retrieveFocusedNode(this.root, me.getX(), me.getY());
        if (currentNode != null) {
            this.tipText = currentNode.data instanceof TreeNodeInterface ? ((TreeNodeInterface)currentNode.data).getToolTipText() : currentNode.getNodeText();
            if (this.tipText != null) {
                return this.tipText;
            }
            return currentNode.getNodeText();
        }
        return null;
    }

    public long getMasks() {
        return 0L;
    }

    public long setMasks(long mask, long bits) {
        return 0L;
    }

    public boolean isVisible() {
        return true;
    }

    public void setVisible(boolean viz) {
    }

    public Object getOpacityValue() {
        return new Double(0.0);
    }

    public boolean setOpacityValue(Object newOpacity) {
        return false;
    }

    public Color getNodeSolidColor() {
        return this.nodeSolidColor;
    }

    public void setNodeSolidColor(Color colorIn) {
        this.nodeSolidColor = colorIn;
    }

    public void draw(Object p, boolean callHighlightDraw) {
        Graphics2D g2d = (Graphics2D)p;
        if (this.chartArea == null) {
            return;
        }
        this.nodeHeight = this.chartArea.height / (this.maxLevel + 1);
        this.root.setXStart(this.chartArea.x);
        this.drawNode(g2d, this.root);
        if (callHighlightDraw) {
            this.drawHighlight(p);
        }
        g2d.setStroke(new BasicStroke(2.0f));
    }

    public void drawHighlight(Object p) {
        this.drawSelectedNode((Graphics2D)p, this.root);
    }

    public double[] getBoundingBox() {
        return null;
    }

    public Rectangle getScreenArea() {
        return this.chartArea;
    }

    public Object getTransformObject() {
        return null;
    }

    public boolean setBoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        return false;
    }

    public boolean setScreenArea(int xmin, int ymin, int width, int height) {
        this.chartArea = new Rectangle(xmin, ymin, width, height);
        return true;
    }

    public boolean setTransformObject(Object transIn) {
        return false;
    }

    public void dispose() {
        this.borderColor = null;
        this.nodeSolidColor = null;
        if (this.root != null) {
            this.root.dispose();
        }
        this.root = null;
        this.data = null;
        this.graph = null;
        this.chartArea = null;
        this.rb = null;
    }
}

