/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.heatmap;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.heatmap.HeatmapModel;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GeometryInterface;
import com.sas.graphics.silk.interfaces.HeatmapPropertyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.LegendObject;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.FillPattern;
import com.sas.graphics.util.HTMLColors;
import com.sas.graphics.util.Markers;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;

public class HeatmapChart
implements GeometryInterface,
RenderInterface,
RoleInterface,
UpdateInterface,
DataFilterListenerInterface,
PropertyInterface,
HeatmapPropertyInterface {
    public static final int COLOR_RANGE_DISCRETE = 1;
    public static final int COLOR_RANGE_CONTINUOUS = 2;
    protected boolean visible = true;
    protected double opacity = 1.0;
    protected boolean rebuildRequired = true;
    protected boolean chartBorderOn = false;
    protected Color chartBorderColor;
    protected Color selectionColor;
    protected Color outlineColor;
    protected boolean outlineOn = true;
    protected DataFilterReadInterface dataIn = null;
    protected HeatmapModel heatmapModel = null;
    protected DataFilterReadInterface dataOut = null;
    protected TransformInterface transObj = null;
    protected LegendObject legend;
    protected Axes xAxis = null;
    protected Axes yAxis = null;
    protected Object xVariable = null;
    protected Object yVariable = null;
    protected Object respVariable = null;
    protected Object tipVariable = null;
    protected Object colorIndexVariable;
    protected double minTime;
    protected double maxTime;
    protected double xMin;
    protected double xMax;
    protected double yMin;
    protected double yMax;
    protected double rMin;
    protected double rMax;
    protected SASFormat respFormat;
    protected int[] displayList = null;
    protected ArrayList selectionList;
    protected ArrayList redrawListener;
    protected ArrayList marginListener;
    protected Object marginSource;
    protected boolean dataChanged = false;
    protected boolean dataPrepared = false;
    protected double[] chartBBox = new double[6];
    protected double[] scr1 = new double[3];
    protected double[] scr2 = new double[3];
    protected Rectangle2D clipRect;
    protected Dimension chartAreaDimension;
    protected Insets innerMargin;
    protected double xSpace;
    protected double ySpace;
    protected double cellXSize;
    protected double cellYSize;
    protected boolean innerMarginChanged = false;
    protected boolean redraw = true;
    protected Style style = null;
    protected ColorInterface continuousColorRamp;
    protected ColorInterface discreteColorRamp;
    protected int axisLabelLength = 8;
    protected ArrayList propertyIndex;
    protected ArrayList propertyValue;
    protected int minimumCellWidth = 4;
    protected int minimumCellHeight = 18;
    protected int maximumXCellCount;
    protected int maximumYCellCount;
    protected int cellXCount;
    protected int cellYCount;
    protected int colorRangeType = 1;
    protected Color outOfRangeColor;
    protected Color missingColor;
    protected Color underflowColor;
    protected Color overflowColor;
    protected int cellMarker = -1;
    protected Color cellBackground;
    protected double xScaleFactor = 0.8;
    protected double yScaleFactor = 0.8;
    protected boolean cellEquated = false;
    protected boolean cellBackgroundOn = true;
    protected boolean drawOutline;
    protected boolean missingCellOn;
    protected boolean defaultViewport = true;
    protected boolean fitToScreen = true;
    protected boolean dataSelected = false;
    protected boolean mouseAction = false;
    TexturePaint selectionPaint = null;
    private LinkedHashMap colorMap = null;
    private Color[] colorList = null;
    private LinkedHashMap groupIndexMap = null;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
    public static int[] supportedProperties = new int[]{801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 816};
    protected UserSetPropertyBitMask userSetProperties = new UserSetPropertyBitMask(supportedProperties);

    public HeatmapChart(Object dataObject) {
        this.chartBorderColor = Color.black;
        this.selectionColor = new Color(255, 197, 0);
        this.outlineColor = Color.black;
        this.selectionList = new ArrayList();
        this.redrawListener = new ArrayList();
        this.innerMargin = new Insets(0, 0, 0, 0);
        this.outOfRangeColor = Color.gray;
        this.missingColor = Color.black;
        this.underflowColor = Color.white;
        this.overflowColor = Color.cyan;
        this.cellBackground = new Color(200, 200, 200);
        this.propertyIndex = new ArrayList();
        this.propertyValue = new ArrayList();
        this.setDataSource(dataObject);
        this.userSetProperties.appendProperties(supportedProperties);
    }

    public HeatmapChart() {
        this(null);
    }

    public void setXAxis(Axes axis) {
        this.xAxis = axis;
    }

    public void setYAxis(Axes axis) {
        this.yAxis = axis;
    }

    public void setLegend(LegendObject leg) {
        this.legend = leg;
    }

    public void setStyle(Style style) {
        this.style = style;
        this.continuousColorRamp = null;
        if (this.discreteColorRamp != null) {
            this.updateDiscreteColorRamp();
        }
        this.buildColorMap();
        this.setupLegend();
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public void setDataChanged(boolean changed) {
        if (changed) {
            this.rebuildRequired = true;
            this.dataChanged = true;
        }
    }

    private void decideVariables() {
        this.xVariable = this.getVariable(HeatmapModel.X_ROLE_NAME);
        this.yVariable = this.getVariable(HeatmapModel.Y_ROLE_NAME);
        this.respVariable = this.getVariable(HeatmapModel.RESP_ROLE_NAME);
        this.colorIndexVariable = this.getVariable(HeatmapModel.COLOR_INDEX_ROLE_NUMBER);
    }

    public void setChartAreaDimension(Dimension d) {
        this.chartAreaDimension = d;
        this.xAxis.setChartAreaDimension(d);
        this.yAxis.setChartAreaDimension(d);
    }

    public boolean setChartClipArea(Rectangle2D rect) {
        if (rect == null || !this.prepareChartData()) {
            return false;
        }
        this.clipRect = rect;
        this.xAxis.setAxisLength(this.clipRect.getWidth());
        this.yAxis.setAxisLength(this.clipRect.getHeight());
        this.xAxis.setGridLineLength(this.clipRect.getHeight());
        this.yAxis.setGridLineLength(this.clipRect.getWidth());
        boolean newBounding = this.decideDisplayedCellCounts(null);
        this.updateInnerMargin();
        return newBounding;
    }

    public void adjustChartArea(Rectangle2D rect) {
        double yCount;
        double xCount;
        if (!this.cellEquated) {
            return;
        }
        if (rect == null || !this.prepareChartData()) {
            return;
        }
        this.clipRect = rect;
        this.decideDisplayedCellCounts(null);
        if (this.defaultViewport) {
            xCount = this.getCellCount(true);
            yCount = this.getCellCount(false);
        } else {
            xCount = !this.heatmapModel.isDateTime() ? this.chartBBox[3] - this.chartBBox[0] : (this.chartBBox[3] - this.chartBBox[0]) / this.heatmapModel.getDateTimeSpan();
            yCount = this.chartBBox[4] - this.chartBBox[1];
        }
        double xs = this.clipRect.getWidth() / xCount;
        double ys = this.clipRect.getHeight() / yCount;
        if (xs != ys) {
            double space = Math.min(xs, ys);
            double w = space * xCount;
            double h = space * yCount;
            double halfXDiff = (this.clipRect.getWidth() - w) * 0.5;
            double halfYDiff = (this.clipRect.getHeight() - h) * 0.5;
            this.clipRect.setRect(this.clipRect.getX() + halfXDiff, this.clipRect.getY() + halfYDiff, w, h);
        }
    }

    public void controllYAxisTickmarks(int height) {
        if (!this.fitToScreen) {
            return;
        }
        this.prepareChartData();
        int maximum = (int)((double)height / (double)this.minimumCellHeight);
        if (this.yMax - this.yMin > (double)maximum) {
            this.yAxis.setMajorTicks((Object)Boolean.FALSE);
            this.yAxis.setValues((Object)Boolean.FALSE);
        } else {
            this.yAxis.setMajorTicks((Object)Boolean.TRUE);
            this.yAxis.setValues((Object)Boolean.TRUE);
        }
    }

    public double[] getDataBoundingBox() {
        double xHalfIncr;
        double[] dr = new double[6];
        double d = xHalfIncr = this.heatmapModel.isDateTime() ? 0.5 * this.heatmapModel.getDateTimeSpan() : 0.5;
        if (this.heatmapModel.isDateTime()) {
            dr[0] = this.minTime - xHalfIncr;
            dr[3] = this.maxTime + xHalfIncr;
        } else {
            dr[0] = 0.0;
            dr[3] = this.heatmapModel.getUniqueXValueCount();
        }
        dr[1] = 0.0;
        dr[4] = this.heatmapModel.getUniqueYValueCount();
        return dr;
    }

    public double getMaximumDisplayRange(boolean xDir) {
        double range = xDir ? (this.heatmapModel.isDateTime() ? (double)this.maximumXCellCount * this.heatmapModel.getDateTimeSpan() : (double)this.maximumXCellCount) : (double)this.maximumYCellCount;
        return range;
    }

    public double getMinimumDisplayRange(boolean xDir) {
        double range = xDir ? (this.heatmapModel.isDateTime() ? this.heatmapModel.getDateTimeSpan() : 1.0) : 1.0;
        return range;
    }

    public Insets getOuterMargin(Graphics2D g) {
        int axisLen;
        int right;
        Insets margin = new Insets(0, 0, 0, 0);
        if (this.chartAreaDimension == null || this.chartAreaDimension.width < 0 || this.chartAreaDimension.height < 0) {
            return margin;
        }
        if (!this.prepareChartData()) {
            return margin;
        }
        int leftx = this.xAxis.getLeftWidth(g);
        int lefty = this.yAxis.getLeftWidth(g);
        int top = this.yAxis.getTopHeight(g);
        int right_rl = this.yAxis.getReferenceLineLabelWidth(g);
        int top_rl = this.xAxis.getReferenceLineLabelHeight(g);
        int right_sav = right = 0;
        for (int i = 0; i < 2; ++i) {
            right = Math.max(right, right_rl);
            axisLen = this.chartAreaDimension.width - right - Math.max(leftx, lefty);
            int r = (int)((double)this.xAxis.getValueWidth(g, -1) * 0.5);
            int halfBar = (int)(0.5 * Math.max((double)this.minimumCellWidth, (double)axisLen / (double)this.getCellCount(true)));
            r -= halfBar;
            r = Math.max(0, r);
            right = right_sav + r;
            if (r == 0) break;
        }
        right = Math.max(right, right_rl);
        axisLen = this.chartAreaDimension.width - right - Math.max(leftx, lefty);
        this.xAxis.setAxisLength((double)axisLen);
        int bottom = this.xAxis.getBottomHeight(g);
        if (this.xAxis.getTickMarkValueHeight(g) == 0) {
            right = 0;
        }
        axisLen = this.chartAreaDimension.height - top - bottom;
        int halfBar = (int)(0.5 * Math.max((double)this.minimumCellHeight, (double)axisLen / (double)this.getCellCount(false)));
        top -= halfBar;
        top = Math.max(0, top);
        top = Math.max(top, top_rl);
        margin.left = Math.max(leftx, lefty);
        margin.right = right;
        margin.top = top;
        margin.bottom = bottom;
        return margin;
    }

    public double getNearestDateTimeValue(double v, boolean ceil) {
        double timeSpan = this.heatmapModel.getDateTimeSpan();
        int numSpan = (int)((v - this.minTime) / timeSpan);
        if (ceil) {
            return (double)(numSpan + 1) * timeSpan + this.minTime;
        }
        return (double)numSpan * timeSpan + this.minTime;
    }

    public Dimension getCellDimension() {
        return new Dimension((int)this.xSpace, (int)this.ySpace);
    }

    public void setInnerMargin(Insets im) {
        if (this.clipRect == null) {
            return;
        }
        this.decideDisplayedCellCounts(im);
        int xBox = this.getCellCount(true);
        int yBox = this.getCellCount(false);
        this.xSpace = xBox == 1 ? (double)(Math.min(im.left, im.right) * 2) : (this.clipRect.getWidth() - (double)im.left - (double)im.right) / ((double)xBox - 1.0);
        this.ySpace = yBox == 1 ? (double)(Math.min(im.top, im.bottom) * 2) : (this.clipRect.getHeight() - (double)im.top - (double)im.bottom) / ((double)yBox - 1.0);
    }

    public Insets getInnerMargin() {
        return this.innerMargin;
    }

    public boolean isInnerMarginChanged() {
        return this.innerMarginChanged;
    }

    protected void updateInnerMargin() {
        if (this.clipRect == null) {
            return;
        }
        this.xSpace = this.clipRect.getWidth() / (double)this.getCellCount(true);
        this.ySpace = this.clipRect.getHeight() / (double)this.getCellCount(false);
        this.innerMargin.right = this.innerMargin.left = (int)(0.5 * this.xSpace);
        this.innerMargin.top = this.innerMargin.bottom = (int)(0.5 * this.ySpace);
        this.innerMarginChanged = true;
    }

    private int getCellCount(boolean xDir) {
        if (xDir) {
            if (!this.heatmapModel.isDateTime()) {
                return (int)(this.xMax - this.xMin + 1.0);
            }
            return (int)((this.xMax - this.xMin) / this.heatmapModel.getDateTimeSpan() + 1.0);
        }
        return (int)(this.yMax - this.yMin + 1.0);
    }

    private int getCellIndex(boolean xDir, double v) {
        if (xDir) {
            if (this.heatmapModel.isDateTime()) {
                return (int)((v - this.minTime) / this.heatmapModel.getDateTimeSpan());
            }
            return (int)v;
        }
        return (int)v;
    }

    private double getCellValue(boolean xDir, int idx) {
        double v = 0.0;
        if (xDir) {
            v = idx % this.cellXCount;
            if (this.heatmapModel.isDateTime()) {
                v = this.minTime + v * this.heatmapModel.getDateTimeSpan();
            }
        } else {
            v = idx / this.cellXCount;
        }
        return v;
    }

    private Object getCellResponse(int idx) {
        Object rObj;
        if (this.heatmapModel.isSpreadSheetData()) {
            Object var = this.heatmapModel.isTransposed() ? this.heatmapModel.getUniqueYValues()[(int)this.getCellValue(false, idx)] : this.heatmapModel.getUniqueXValues()[(int)this.getCellValue(true, idx)];
            rObj = this.dataOut.getValue(var, (long)this.displayList[idx]);
            if (!this.heatmapModel.isNumericResponse()) {
                if (!this.missingCellOn && this.dataOut.isMissing(var, rObj)) {
                    rObj = "";
                } else {
                    Object format = this.dataOut.getFormat(var, null);
                    rObj = this.dataOut.getFormattedValue(var, rObj, format);
                }
            }
        } else {
            rObj = this.dataOut.getValue(this.respVariable, (long)this.displayList[idx]);
        }
        if (rObj == null || rObj instanceof String && ((String)rObj).trim().length() <= 0) {
            rObj = new Double(Double.NaN);
        } else if (this.heatmapModel.isNumericResponse() && !(rObj instanceof Number)) {
            int ci = this.getColorIndex(rObj);
            rObj = new Double(ci == -1 ? Double.NaN : (double)ci);
        }
        return rObj;
    }

    private int getColorIndex(Object v) {
        if (v == null || v instanceof String && ((String)v).length() == 0) {
            return -1;
        }
        Object[] colorValues = this.heatmapModel.getUniqueResponseValues(false);
        if (colorValues != null) {
            for (int i = 0; i < colorValues.length; ++i) {
                if (!v.equals(colorValues[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean decideDisplayedCellCounts(Insets im) {
        int unit;
        if (this.fitToScreen) {
            return false;
        }
        if (im != null) {
            if (this.cellEquated) {
                unit = Math.max(this.minimumCellWidth, this.minimumCellHeight);
                this.maximumXCellCount = (int)((this.clipRect.getWidth() - (double)(im.left + im.right)) / (double)unit) + 1;
                this.maximumYCellCount = (int)((this.clipRect.getHeight() - (double)(im.top + im.bottom)) / (double)unit) + 1;
            } else {
                this.maximumXCellCount = (int)((this.clipRect.getWidth() - (double)(im.left + im.right)) / (double)this.minimumCellWidth) + 1;
                this.maximumYCellCount = (int)((this.clipRect.getHeight() - (double)(im.top + im.bottom)) / (double)this.minimumCellHeight) + 1;
            }
        } else if (this.cellEquated) {
            unit = Math.max(this.minimumCellWidth, this.minimumCellHeight);
            this.maximumXCellCount = (int)(this.clipRect.getWidth() / (double)unit);
            this.maximumYCellCount = (int)(this.clipRect.getHeight() / (double)unit);
        } else {
            this.maximumXCellCount = (int)(this.clipRect.getWidth() / (double)this.minimumCellWidth);
            this.maximumYCellCount = (int)(this.clipRect.getHeight() / (double)this.minimumCellHeight);
        }
        this.maximumXCellCount = Math.max(1, this.maximumXCellCount);
        this.maximumYCellCount = Math.max(1, this.maximumYCellCount);
        boolean newBounding = false;
        if (this.defaultViewport) {
            if (this.maximumXCellCount != this.getCellCount(true)) {
                if (!this.heatmapModel.isDateTime()) {
                    this.xMax = this.xMin + (double)this.maximumXCellCount - 1.0;
                    this.xMax = Math.min(this.xMax, (double)(this.heatmapModel.getUniqueXValueCount() - 1));
                } else {
                    this.xMax = this.xMin + (double)(this.maximumXCellCount - 1) * this.heatmapModel.getDateTimeSpan();
                    this.xMax = Math.min(this.xMax, this.maxTime);
                    this.xAxis.setAxis((Object)new Double(this.xMin), (Object)new Double(this.xMax), -1, -1, null, Boolean.TRUE, null);
                }
                newBounding = true;
                double xHalfIncr = this.heatmapModel.isDateTime() ? 0.5 * this.heatmapModel.getDateTimeSpan() : 0.5;
                this.chartBBox[3] = this.xMax + (this.heatmapModel.isDateTime() ? xHalfIncr : xHalfIncr * 2.0);
            }
            if (this.maximumYCellCount != this.getCellCount(false)) {
                this.yMax = this.heatmapModel.getUniqueYValueCount() - 1;
                this.yMin = Math.max(0.0, this.yMax - (double)(this.maximumYCellCount - 1));
                newBounding = true;
                this.chartBBox[1] = this.yMin;
            }
        }
        return !this.dataChanged && newBounding;
    }

    private boolean isCellDisplayed(int idx) {
        if (this.displayList[idx] == -1) {
            return false;
        }
        return !(this.getCellValue(true, idx) < this.xMin || this.getCellValue(true, idx) > this.xMax || this.getCellValue(false, idx) < this.yMin) && !(this.getCellValue(false, idx) > this.yMax);
    }

    private String getColorRangeString(double min, double max, boolean minEx, boolean maxEx) {
        String str = Double.isInfinite(min) && Double.isInfinite(max) ? ". - ." : (Double.isInfinite(min) ? (maxEx ? "< " + this.respFormat.format((Object)new Double(max)) : "<= " + this.respFormat.format((Object)new Double(max))) : (Double.isInfinite(max) ? (minEx ? "> " + this.respFormat.format((Object)new Double(min)) : ">= " + this.respFormat.format((Object)new Double(min))) : this.respFormat.format((Object)new Double(min)) + " - " + this.respFormat.format((Object)new Double(max))));
        return str;
    }

    private Color getCellColor(Object v) {
        if (v == null && v instanceof Number && Double.isNaN(((Number)v).doubleValue())) {
            return this.missingColor;
        }
        if (!this.heatmapModel.isNumericResponse()) {
            int groupIndex = this.getGroupIndex(v, this.heatmapModel.getUniqueResponseValues(true));
            StyleElement overrides = null;
            if (this.colorMap != null && this.colorMap.containsKey(groupIndex)) {
                overrides = new StyleElement();
                overrides.setAttribute("fillColor", HTMLColors.getColorString((Color)((Color)this.colorMap.get(groupIndex))));
            }
            StyleElement se = SILKUtilities.getStyleElement((String)v.toString(), (int)groupIndex, (int)2, (Style)this.style, (String)"GraphDataStyleDefault", overrides);
            return se.getAsFillStyle().getFillColor();
        }
        if (!(v instanceof Number)) {
            return this.missingColor;
        }
        double dvalue = ((Number)v).doubleValue();
        double c_uniform = this.rMax - this.rMin == 0.0 ? 1.0 : (dvalue - this.rMin) / (this.rMax - this.rMin);
        Color c = this.colorRangeType == 2 ? this.continuousColorRamp.queryDouble(c_uniform, false, null) : this.discreteColorRamp.queryDouble(c_uniform, false, null);
        if (c == null) {
            c = this.outOfRangeColor;
        }
        return c;
    }

    private void updateDiscreteColorRamp() {
        Object[] breaks = this.discreteColorRamp.getBreaks();
        Color[] c = new Color[breaks.length - 1];
        Color[] dc = this.style.getDataFillColors();
        for (int i = 0; i < c.length; ++i) {
            c[i] = breaks[i].toString().trim().length() == 0 || breaks[i].toString().trim().equals(".") ? this.missingColor : dc[i % dc.length];
        }
        this.discreteColorRamp.setColors((Object)c, (Object)breaks);
    }

    private void updateDefaultColorRamp(int type) {
        if (this.colorRangeType == 2) {
            if (this.continuousColorRamp == null) {
                this.continuousColorRamp = new ColorRamp((Object)this.style.getRampStyleElement("ThreeColorRamp").getColors(), 0.0, 1.0, 0L);
                this.continuousColorRamp.setUnderflowColor(this.underflowColor);
                this.continuousColorRamp.setUnderflowColor(this.overflowColor);
                this.continuousColorRamp.setMissingColor(this.missingColor);
            }
        } else {
            Color[] dc = this.style.getDataFillColors();
            if (this.heatmapModel.isNumericResponse()) {
                Color[] c = new Color[]{dc[0], dc[1], dc[2]};
                double[] d = new double[]{0.0, 0.3333, 0.6666, 1.0};
                this.discreteColorRamp = new ColorRamp((Object)c, (Object)d, 0L);
            } else {
                Object[] values = this.heatmapModel.getUniqueResponseValues(true);
                int n = values.length;
                Color[] colors = new Color[n];
                for (int i = 0; i < n; ++i) {
                    colors[i] = this.getCellColor(values[i]);
                }
                this.discreteColorRamp = new ColorRamp((Object)colors, (Object)values, 0L);
            }
            this.discreteColorRamp.setMissingColor(this.missingColor);
        }
    }

    private void setupLegend() {
        if (this.legend == null || !this.dataPrepared) {
            return;
        }
        this.updateDefaultColorRamp(this.colorRangeType);
        if (this.colorRangeType == 2) {
            Object[] breaks = this.continuousColorRamp.getBreaks();
            int len = breaks.length;
            Object[] legendValues = new Object[len];
            for (int i = 0; i < len; ++i) {
                legendValues[i] = new Double(((Number)breaks[i]).doubleValue() * (this.rMax - this.rMin) + this.rMin);
            }
            this.legend.setValues(this.continuousColorRamp.getColors(), null, legendValues, null, true);
            this.legend.setLabel((Object)this.respFormat);
        } else {
            Object[] breaks = this.discreteColorRamp.getBreaks();
            Color[] colors = this.discreteColorRamp.getColors();
            if (this.heatmapModel.isNumericResponse()) {
                int len = breaks.length - 1;
                Object[] legendValues = new Object[len];
                Color[] legendColors = new Color[len];
                for (int i = 0; i < len; ++i) {
                    legendColors[i] = colors[i];
                    double b1 = ((Number)breaks[i]).doubleValue() * (this.rMax - this.rMin) + this.rMin;
                    double b2 = ((Number)breaks[i + 1]).doubleValue() * (this.rMax - this.rMin) + this.rMin;
                    legendValues[i] = this.getColorRangeString(b1, b2, true, false);
                }
                this.legend.setValues(legendColors, null, legendValues, null, false);
            } else {
                Object[] values = this.heatmapModel.getUniqueResponseValues(true);
                if (values != null) {
                    Color[] cols = new Color[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        cols[i] = this.getCellColor(values[i]);
                    }
                    this.legend.setValues(cols, null, values, null, false);
                }
            }
            this.legend.setLabel((Object)SASFormat.getInstance((String)"$CHAR80"));
        }
    }

    public void setMarginListener(ArrayList listener, Object source) {
        this.marginListener = listener;
        this.marginSource = source;
    }

    public boolean isHighlightRequired() {
        return this.selectionList.size() > 0 || this.dataSelected;
    }

    private boolean prepareChartData() {
        if (this.dataPrepared) {
            return true;
        }
        if (this.heatmapModel == null) {
            return false;
        }
        if (this.dataOut != null) {
            this.dataOut.removeDataFilterListener((Object)this);
        }
        this.dataOut = (DataFilterReadInterface)this.heatmapModel.getDataSource();
        if (this.dataOut == null) {
            return false;
        }
        this.dataOut.addDataFilterListener((Object)this);
        this.decideVariables();
        Object[] xValues = null;
        if (!this.heatmapModel.isDateTime()) {
            xValues = this.heatmapModel.getUniqueXValues();
            this.xMin = 0.0;
            this.xMax = (double)this.heatmapModel.getUniqueXValueCount() - 1.0;
        } else {
            this.xMin = this.heatmapModel.getMinimumTime();
            this.xMax = this.heatmapModel.getMaximumTime();
        }
        Object[] yValues = this.heatmapModel.getUniqueYValues();
        this.yMin = 0.0;
        this.yMax = (double)this.heatmapModel.getUniqueYValueCount() - 1.0;
        this.rMin = this.heatmapModel.getMinimumResponse();
        this.rMax = this.heatmapModel.getMaximumResponse();
        this.respFormat = this.heatmapModel.getResponseFormat(this.rMin, this.rMax);
        if (xValues == null && (Double.isNaN(this.xMin) || Double.isNaN(this.xMax)) || yValues == null || Double.isNaN(this.rMin) || Double.isNaN(this.rMax)) {
            return false;
        }
        this.xAxis.setFireEvent(false);
        this.yAxis.setFireEvent(false);
        this.xAxis.setDataSource((Object)this.dataOut);
        this.yAxis.setDataSource((Object)this.dataOut);
        this.xAxis.setRole(this.xVariable, (Object)"XAxis");
        this.yAxis.setRole(this.yVariable, (Object)"YAxis");
        if (this.heatmapModel.isDateTime()) {
            this.xAxis.setGridLines((Object)Boolean.FALSE);
        }
        double halfCellSize = 0.5;
        this.xAxis.setTickInCenter(true, halfCellSize);
        this.yAxis.setTickInCenter(true, halfCellSize);
        this.xAxis.setLabel(this.heatmapModel.getVariableDescription(this.xVariable));
        if (this.heatmapModel.isDateTime()) {
            this.xAxis.setMinimumTimeSpan(this.heatmapModel.getDateTimeSpan());
            this.xAxis.setAxis((Object)new Double(this.xMin), (Object)new Double(this.xMax), -1, -1, null, Boolean.TRUE, null);
            double[] ends = this.xAxis.getMinMaxTickMarkValues();
            this.xMin = ends[0];
            this.xMax = ends[1];
            this.minTime = this.xMin;
            this.maxTime = this.xMax;
        } else {
            this.xAxis.setAxis((Object)new Double(0.0), (Object)new Double(xValues.length - 1), -1, -1, xValues, Boolean.TRUE, null);
        }
        this.yAxis.setLabel(this.heatmapModel.getVariableDescription(this.yVariable));
        this.yAxis.setAxis((Object)new Double(0.0), (Object)new Double(yValues.length - 1), -1, -1, yValues, Boolean.TRUE, null);
        this.xAxis.setFireEvent(true);
        this.yAxis.setFireEvent(true);
        this.dataPrepared = true;
        if (this.legend != null && (this.respVariable != null || this.heatmapModel.isSpreadSheetData())) {
            this.setupLegend();
            this.legend.setTitle((Object)((String)this.heatmapModel.getVariableDescription(this.respVariable)));
        }
        return true;
    }

    protected boolean buildHeatmap() {
        int obs = this.dataOut.getNumberObservations(-1);
        int xIdx = this.dataOut.getVariableIndex(this.xVariable);
        int yIdx = this.dataOut.getVariableIndex(this.yVariable);
        int rIdx = this.dataOut.getVariableIndex(this.respVariable);
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < obs; ++i) {
            if (!this.dataOut.isGraphed((long)i)) continue;
            Object xObj = this.dataOut.getValue(xIdx, (long)i);
            Object yObj = this.dataOut.getValue(yIdx, (long)i);
            Object rObj = this.dataOut.getValue(rIdx, (long)i);
            if (this.heatmapModel.isDateTime() && this.dataOut.isMissing(xIdx, xObj) || !this.missingCellOn && this.dataOut.isMissing(rIdx, rObj)) continue;
            x = this.heatmapModel.isDateTime() ? ((Number)xObj).doubleValue() : (double)this.heatmapModel.getXValueIndex(xObj);
            y = this.heatmapModel.getYValueIndex(yObj);
            int idx = this.getCellIndex(false, y) * this.cellXCount + this.getCellIndex(true, x);
            this.displayList[idx] = i;
            if (!this.dataOut.isSelected((long)i)) continue;
            this.selectionList.add(new Integer(idx));
        }
        this.buildColorMap();
        this.setupLegend();
        return true;
    }

    protected void buildColorMap() {
        if (this.dataOut == null) {
            return;
        }
        int obs = this.dataOut.getNumberObservations(-1);
        int rIdx = this.dataOut.getVariableIndex(this.respVariable);
        if (this.colorMap == null) {
            this.colorMap = new LinkedHashMap();
        } else {
            this.colorMap.clear();
        }
        int cIdx = this.dataOut.getVariableIndex(this.colorIndexVariable);
        if (!(this.dataOut.isNumericVariable(rIdx) || cIdx < 0 && this.colorList == null)) {
            Object[] values = this.heatmapModel.getUniqueResponseValues(true);
            this.buildGroupIndexMap();
            for (int i = 0; i < obs; ++i) {
                int groupIndex;
                Object rObj = this.dataOut.getValue(rIdx, (long)i);
                if (rObj == null || (groupIndex = this.getGroupIndex(rObj, values)) < 0 || this.colorMap.containsKey(groupIndex)) continue;
                StyleElement se = SILKUtilities.getStyleElement((String)rObj.toString(), (int)groupIndex, (int)2, (Style)this.style, (String)"GraphDataStyleDefault", null);
                Color fillColor = null;
                if (se != null) {
                    fillColor = se.getAsFillStyle().getFillColor();
                }
                if (this.colorList != null && groupIndex < this.colorList.length) {
                    fillColor = this.colorList[groupIndex];
                }
                if (fillColor == null) continue;
                this.colorMap.put(groupIndex, fillColor);
            }
        }
    }

    protected boolean buildHeatmap_spreadSheet() {
        int obs = this.dataOut.getNumberObservations(-1);
        double x = 0.0;
        double y = 0.0;
        if (this.heatmapModel.isTransposed()) {
            int xIdx = this.dataOut.getVariableIndex(this.xVariable);
            for (int i = 0; i < obs; ++i) {
                if (!this.dataOut.isGraphed((long)i)) continue;
                Object xObj = this.dataOut.getValue(xIdx, (long)i);
                if (this.heatmapModel.isDateTime() && this.dataOut.isMissing(xIdx, xObj)) continue;
                x = this.heatmapModel.isDateTime() ? ((Number)xObj).doubleValue() : (double)this.heatmapModel.getXValueIndex(xObj);
                Object[] yvars = this.heatmapModel.getUniqueYValues();
                for (int yIdx = 0; yIdx < yvars.length; ++yIdx) {
                    Object rObj = this.dataOut.getValue(yvars[yIdx], (long)i);
                    if (!this.missingCellOn && this.dataOut.isMissing(yvars[yIdx], rObj)) continue;
                    y = yIdx;
                    int idx = this.getCellIndex(false, y) * this.cellXCount + this.getCellIndex(true, x);
                    this.displayList[idx] = i;
                    if (!this.dataOut.isSelected((long)i)) continue;
                    this.selectionList.add(new Integer(idx));
                }
            }
        } else {
            int yIdx = this.dataOut.getVariableIndex(this.yVariable);
            for (int i = 0; i < obs; ++i) {
                if (!this.dataOut.isGraphed((long)i)) continue;
                Object yObj = this.dataOut.getValue(yIdx, (long)i);
                if (this.heatmapModel.isDateTime() && this.dataOut.isMissing(yIdx, yObj)) continue;
                y = this.heatmapModel.getYValueIndex(yObj);
                Object[] xvars = this.heatmapModel.getUniqueXValues();
                for (int xIdx = 0; xIdx < xvars.length; ++xIdx) {
                    Object rObj = this.dataOut.getValue(xvars[xIdx], (long)i);
                    if (!this.missingCellOn && this.dataOut.isMissing(xvars[xIdx], rObj)) continue;
                    x = xIdx;
                    int idx = this.getCellIndex(false, y) * this.cellXCount + this.getCellIndex(true, x);
                    this.displayList[idx] = i;
                    if (!this.dataOut.isSelected((long)i)) continue;
                    this.selectionList.add(new Integer(idx));
                }
            }
        }
        return true;
    }

    protected void buildGroupIndexMap() {
        int obs = this.dataOut.getNumberObservations(-1);
        int rIdx = this.dataOut.getVariableIndex(this.respVariable);
        int cIdx = this.dataOut.getVariableIndex(this.colorIndexVariable);
        if (cIdx >= 0) {
            if (this.groupIndexMap == null) {
                this.groupIndexMap = new LinkedHashMap();
            } else {
                this.groupIndexMap.clear();
            }
            for (int i = 0; i < obs; ++i) {
                Object rObj = this.dataOut.getValue(rIdx, (long)i);
                if (this.groupIndexMap.containsKey(rObj)) continue;
                this.groupIndexMap.put(rObj, this.dataOut.getValue(cIdx, (long)i));
            }
        }
    }

    protected int getGroupIndex(Object rObj, Object[] values) {
        int cIdx = this.dataOut.getVariableIndex(this.colorIndexVariable);
        if (cIdx >= 0) {
            if (this.groupIndexMap == null) {
                this.buildGroupIndexMap();
            }
            if (this.groupIndexMap.containsKey(rObj)) {
                return ((Number)this.groupIndexMap.get(rObj)).intValue();
            }
        } else {
            for (int j = 0; j < values.length; ++j) {
                if (!rObj.equals(values[j])) continue;
                return j;
            }
        }
        return -1;
    }

    protected String getDescription(Object x, Object y, Object r, Object t) {
        Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapChart.Probe.fmt.txt", (String)"{0} : {1}"));
        String xstr = "";
        String ystr = "";
        String rstr = "";
        String tstr = "";
        if (this.heatmapModel.isSpreadSheetData()) {
            if (this.heatmapModel.isTransposed()) {
                if (x != null) {
                    xstr = probeMessage.toString((Object)((String)this.heatmapModel.getVariableDescription(this.xVariable)), (Object)this.getValueLabel(this.xVariable, x)) + "\n";
                }
                if (y != null && r != null) {
                    rstr = probeMessage.toString((Object)((String)y), (Object)this.getValueLabel(this.respVariable, r)) + "\n";
                }
            } else {
                if (x != null && r != null) {
                    rstr = probeMessage.toString((Object)((String)x), (Object)this.getValueLabel(this.respVariable, r)) + "\n";
                }
                if (y != null) {
                    ystr = probeMessage.toString((Object)((String)this.heatmapModel.getVariableDescription(this.yVariable)), (Object)this.getValueLabel(this.yVariable, y)) + "\n";
                }
            }
        } else {
            if (x != null) {
                xstr = probeMessage.toString((Object)((String)this.heatmapModel.getVariableDescription(this.xVariable)), (Object)this.getValueLabel(this.xVariable, x)) + "\n";
            }
            if (y != null) {
                ystr = probeMessage.toString((Object)((String)this.heatmapModel.getVariableDescription(this.yVariable)), (Object)this.getValueLabel(this.yVariable, y)) + "\n";
            }
            if (r != null) {
                rstr = probeMessage.toString((Object)((String)this.heatmapModel.getVariableDescription(this.respVariable)), (Object)this.getValueLabel(this.respVariable, r)) + "\n";
            }
        }
        if (t != null) {
            tstr = "\n" + probeMessage.toString((Object)((String)this.heatmapModel.getVariableDescription(this.tipVariable)), (Object)this.getValueLabel(this.tipVariable, t));
        }
        String str = xstr + ystr + rstr + tstr;
        return str;
    }

    protected String getValueLabel(Object variableId, Object value) {
        String label;
        if (variableId == this.respVariable) {
            label = this.respFormat == null ? value.toString() : this.respFormat.format(value);
        } else {
            Object format = this.dataOut.getFormat(variableId, null);
            label = value instanceof String && value.equals(this.heatmapModel.getMissingSymbol()) ? value.toString() : this.dataOut.getFormattedValue(variableId, value, format);
        }
        return label.trim();
    }

    public boolean setSelection(Rectangle rect, boolean extend) {
        double y;
        double x;
        int idx;
        int i;
        int j;
        double[] ul = this.transObj.unProject((double)rect.x, (double)(rect.y + rect.height), 0.0, null);
        double[] lr = this.transObj.unProject((double)(rect.x + rect.width), (double)rect.y, 0.0, null);
        Rectangle2D.Double selRect = new Rectangle2D.Double(ul[0], ul[1], lr[0] - ul[0], lr[1] - ul[1]);
        double w = this.heatmapModel.isDateTime() ? this.heatmapModel.getDateTimeSpan() : 1.0;
        double h = 1.0;
        w *= this.xScaleFactor;
        h *= this.yScaleFactor;
        int x1 = Math.max(0, this.getCellIndex(true, ul[0]));
        int y1 = Math.max(0, this.getCellIndex(false, ul[1]));
        int x2 = Math.min(this.cellXCount - 1, this.getCellIndex(true, lr[0]) + 1);
        int y2 = Math.min(this.cellYCount - 1, this.getCellIndex(false, lr[1]) + 1);
        Rectangle2D.Double bbox = new Rectangle2D.Double();
        HashMap<Object, String> sel = new HashMap<Object, String>();
        if (extend) {
            for (int i2 = 0; i2 < this.selectionList.size(); ++i2) {
                sel.put(this.selectionList.get(i2), "select");
            }
            for (j = y1; j <= y2; ++j) {
                for (i = x1; i <= x2; ++i) {
                    idx = j * this.cellXCount + i;
                    if (!this.isCellDisplayed(idx)) continue;
                    x = this.getCellValue(true, idx);
                    y = this.getCellValue(false, idx);
                    if (this.heatmapModel.isDateTime()) {
                        ((Rectangle2D)bbox).setRect(x - 0.5 * w, y, w, h);
                    } else {
                        ((Rectangle2D)bbox).setRect(x, y, w, h);
                    }
                    if (!selRect.intersects(bbox)) continue;
                    Integer obj = new Integer(idx);
                    if (sel.containsKey(obj)) {
                        sel.remove(obj);
                        continue;
                    }
                    sel.put(obj, "select");
                }
            }
        } else {
            for (j = y1; j <= y2; ++j) {
                for (i = x1; i <= x2; ++i) {
                    idx = j * this.cellXCount + i;
                    if (!this.isCellDisplayed(idx)) continue;
                    x = this.getCellValue(true, idx);
                    y = this.getCellValue(false, idx);
                    if (this.heatmapModel.isDateTime()) {
                        ((Rectangle2D)bbox).setRect(x - 0.5 * w, y, w, h);
                    } else {
                        ((Rectangle2D)bbox).setRect(x, y, w, h);
                    }
                    if (!selRect.intersects(bbox)) continue;
                    sel.put(new Integer(idx), "select");
                }
            }
        }
        boolean fire = false;
        if (this.selectionList.size() != sel.size()) {
            fire = true;
        } else {
            int size = this.selectionList.size();
            for (int i3 = 0; i3 < size; ++i3) {
                if (sel.containsKey(this.selectionList.get(i3))) continue;
                fire = true;
                break;
            }
        }
        if (fire) {
            this.mouseAction = true;
            this.selectionList.clear();
            this.heatmapModel.setSelectionAll(false);
            if (sel.size() > 0) {
                Iterator iter = sel.keySet().iterator();
                idx = 0;
                int[] obs = new int[sel.size()];
                while (iter.hasNext()) {
                    Object next = iter.next();
                    this.selectionList.add(next);
                    obs[idx] = this.displayList[(Integer)next];
                    ++idx;
                }
                this.heatmapModel.setSelection(obs, true);
            }
            this.mouseAction = false;
            return false;
        }
        return true;
    }

    public void setSelection(int mouseX, int mouseY, boolean extend) {
        int index = this.getSelectedIndex(mouseX, mouseY);
        Integer selectedValue = index >= 0 ? new Integer(index) : null;
        this.mouseAction = true;
        if (extend) {
            if (index >= 0) {
                boolean selected;
                boolean bl = selected = this.selectionList.contains(selectedValue);
                if (selected) {
                    this.selectionList.remove(selectedValue);
                    this.heatmapModel.setSelection(this.displayList[index], false);
                } else {
                    this.selectionList.add(selectedValue);
                    this.heatmapModel.setSelection(this.displayList[index], true);
                }
            }
        } else {
            this.selectionList.clear();
            this.heatmapModel.setSelectionAll(false);
            if (index >= 0) {
                this.selectionList.add(selectedValue);
                this.heatmapModel.setSelection(this.displayList[index], true);
            }
        }
        this.mouseAction = false;
    }

    public void setSelection(Object Role, ArrayList values, boolean extend) {
        this.selectionList.clear();
        if (values == null) {
            return;
        }
        this.mouseAction = true;
        int[] obs = Role == "X" ? new int[this.cellYCount * values.size()] : new int[this.cellXCount * values.size()];
        int num = 0;
        for (int i = 0; i < values.size(); ++i) {
            Integer I;
            int idx;
            int j;
            Object obj = values.get(i);
            if (Role == "X") {
                double x = this.heatmapModel.isDateTime() ? ((Number)obj).doubleValue() : (double)this.heatmapModel.getXValueIndex(obj);
                for (j = 0; j < this.cellYCount; ++j) {
                    idx = (int)((double)(j * this.cellXCount) + x);
                    I = new Integer(idx);
                    if (this.selectionList.contains(I)) continue;
                    this.selectionList.add(I);
                    obs[num] = this.displayList[idx];
                    ++num;
                }
                continue;
            }
            double y = this.heatmapModel.getYValueIndex(obj);
            for (j = 0; j < this.cellXCount; ++j) {
                idx = (int)(y * (double)this.cellXCount + (double)j);
                I = new Integer(idx);
                if (this.selectionList.contains(I)) continue;
                this.selectionList.add(I);
                obs[num] = this.displayList[idx];
                ++num;
            }
        }
        this.heatmapModel.setSelectionAll(false);
        this.heatmapModel.setSelection(obs, true);
        this.mouseAction = false;
    }

    public String getToolTipText(int mouseX, int mouseY) {
        if (!this.visible) {
            return null;
        }
        String desc = null;
        int index = this.getSelectedIndex(mouseX, mouseY);
        if (index >= 0) {
            Object rObj;
            Object yObj;
            Object xObj;
            if (this.heatmapModel.isSpreadSheetData()) {
                if (this.heatmapModel.isTransposed()) {
                    xObj = this.dataOut.getValue(this.xVariable, (long)this.displayList[index]);
                    yObj = this.heatmapModel.getUniqueYValues()[(int)this.getCellValue(false, index)];
                    rObj = this.dataOut.getValue(yObj, (long)this.displayList[index]);
                } else {
                    xObj = this.heatmapModel.getUniqueXValues()[(int)this.getCellValue(true, index)];
                    yObj = this.dataOut.getValue(this.yVariable, (long)this.displayList[index]);
                    rObj = this.dataOut.getValue(xObj, (long)this.displayList[index]);
                }
            } else {
                xObj = this.dataOut.getValue(this.xVariable, (long)this.displayList[index]);
                yObj = this.dataOut.getValue(this.yVariable, (long)this.displayList[index]);
                rObj = this.dataOut.getValue(this.respVariable, (long)this.displayList[index]);
            }
            desc = this.getDescription(xObj, yObj, rObj, null);
        }
        return desc;
    }

    private int getSelectedIndex(int mouseX, int mouseY) {
        if (this.redraw) {
            return -1;
        }
        double[] pt = this.transObj.unProject((double)mouseX, (double)mouseY, 0.0, null);
        double w = this.heatmapModel.isDateTime() ? this.heatmapModel.getDateTimeSpan() : 1.0;
        double h = 1.0;
        w *= this.xScaleFactor;
        h *= this.yScaleFactor;
        int x1 = Math.max(0, this.getCellIndex(true, pt[0]));
        int y1 = Math.max(0, this.getCellIndex(false, pt[1]));
        int x2 = Math.min(this.cellXCount - 1, x1 + 1);
        int y2 = Math.min(this.cellYCount - 1, y1 + 1);
        Rectangle2D.Double bbox = new Rectangle2D.Double();
        int index = -1;
        block0: for (int j = y1; j <= y2; ++j) {
            for (int i = x1; i <= x2; ++i) {
                int idx = j * this.cellXCount + i;
                if (!this.isCellDisplayed(idx)) continue;
                double x = this.getCellValue(true, idx);
                double y = this.getCellValue(false, idx);
                if (this.heatmapModel.isDateTime()) {
                    ((Rectangle2D)bbox).setRect(x - 0.5 * w, y, w, h);
                } else {
                    ((Rectangle2D)bbox).setRect(x, y, w, h);
                }
                if (!bbox.contains(pt[0], pt[1])) continue;
                index = idx;
                continue block0;
            }
        }
        return index;
    }

    public boolean create(Object createData) {
        return true;
    }

    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    public boolean build(Object buildData) {
        if (!this.rebuildRequired) {
            return true;
        }
        this.displayList = null;
        this.selectionList.clear();
        this.cellXCount = !this.heatmapModel.isDateTime() ? this.heatmapModel.getUniqueXValueCount() : (int)((this.maxTime - this.minTime) / this.heatmapModel.getDateTimeSpan() + 1.0);
        this.cellYCount = this.heatmapModel.getUniqueYValueCount();
        int numCells = this.cellXCount * this.cellYCount;
        this.displayList = new int[numCells];
        for (int i = 0; i < numCells; ++i) {
            this.displayList[i] = -1;
        }
        boolean rc = this.heatmapModel.isSpreadSheetData() ? this.buildHeatmap_spreadSheet() : this.buildHeatmap();
        this.rebuildRequired = false;
        this.dataChanged = false;
        this.redraw = true;
        return rc;
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(buildData);
        this.draw(drawContext, false);
        return status;
    }

    public long getMasks() {
        return 0L;
    }

    public long setMasks(long mask, long bits) {
        return 0L;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean viz) {
        this.visible = viz;
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Object getOpacityValue() {
        return new Double(this.opacity);
    }

    public boolean setOpacityValue(Object newOpacity) {
        if (newOpacity == null || !(newOpacity instanceof Number)) {
            return false;
        }
        double newValue = ((Number)newOpacity).doubleValue();
        if (newValue < 0.0 || newValue > 1.0) {
            return false;
        }
        if (newValue != this.opacity) {
            this.opacity = newValue;
            this.fireRedrawEvent(new RedrawEvent((Object)this));
        }
        return true;
    }

    public void draw(Object p, boolean callHighlightDraw) {
        if (p == null || !(p instanceof Graphics2D) || this.transObj == null || !this.visible) {
            return;
        }
        if (this.displayList == null || this.displayList.length == 0) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        Composite comp = g.getComposite();
        if (this.opacity < 1.0) {
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, (float)this.opacity);
            g.setComposite(alphaComp);
        }
        double xw1 = 0.0;
        double yw1 = 0.0;
        double xw2 = this.heatmapModel.isDateTime() ? this.heatmapModel.getDateTimeSpan() : 1.0;
        double yw2 = 1.0;
        this.transObj.project(xw1, yw1, 0.0, this.scr1);
        this.transObj.project(xw2, yw2, 0.0, this.scr2);
        this.xSpace = this.scr2[0] - this.scr1[0];
        this.ySpace = this.scr1[1] - this.scr2[1];
        double[] scr = new double[3];
        int x1 = this.getCellIndex(true, this.xMin);
        int x2 = this.getCellIndex(true, this.xMax);
        int y1 = this.getCellIndex(false, this.yMin);
        int y2 = this.getCellIndex(false, this.yMax);
        this.cellXSize = this.xSpace * this.xScaleFactor;
        this.cellYSize = this.ySpace * this.yScaleFactor;
        this.drawOutline = this.outlineOn;
        int CUTOFF = 3;
        if (this.cellXSize < (double)CUTOFF || this.cellYSize < (double)CUTOFF) {
            this.drawOutline = false;
            if (this.cellXSize < (double)CUTOFF) {
                this.cellXSize = Math.min((double)CUTOFF, this.xSpace);
            }
            if (this.cellYSize < (double)CUTOFF) {
                this.cellYSize = Math.min((double)CUTOFF, this.ySpace);
            }
            this.cellXSize = Math.max(1.0, this.cellXSize);
            this.cellYSize = Math.max(1.0, this.cellYSize);
            this.xAxis.setGridLines((Object)Boolean.FALSE);
            this.yAxis.setGridLines((Object)Boolean.FALSE);
        } else {
            if (!this.heatmapModel.isDateTime()) {
                this.xAxis.setGridLines((Object)Boolean.TRUE);
            }
            this.yAxis.setGridLines((Object)Boolean.TRUE);
        }
        for (int j = y1; j <= y2; ++j) {
            for (int i = x1; i <= x2; ++i) {
                int idx = j * this.cellXCount + i;
                if (this.displayList[idx] == -1) continue;
                double x = this.getCellValue(true, idx);
                double y = this.getCellValue(false, idx);
                Object r = this.getCellResponse(idx);
                if (this.heatmapModel.isDateTime()) {
                    this.transObj.project(x, y + 0.5, 0.0, scr);
                } else {
                    this.transObj.project(x + 0.5, y + 0.5, 0.0, scr);
                }
                Rectangle boundingBox = new Rectangle();
                boundingBox.x = (int)(scr[0] - this.cellXSize * 0.5);
                boundingBox.y = (int)(scr[1] - this.cellYSize * 0.5);
                boundingBox.width = (int)(this.cellXSize + 1.0);
                boundingBox.height = (int)(this.cellYSize + 1.0);
                if (this.cellMarker > -1) {
                    if (this.cellBackgroundOn && this.cellBackground != null) {
                        g.setColor(this.cellBackground);
                        g.fillRect(boundingBox.x, boundingBox.y, boundingBox.width, boundingBox.height);
                    }
                    double ms = Math.min(this.cellXSize, this.cellYSize);
                    Markers.draw((Graphics)g, (Color)this.getCellColor(r), (Color)this.outlineColor, (int)this.cellMarker, (int)((int)ms), (int)((int)scr[0]), (int)((int)scr[1]));
                    continue;
                }
                g.setColor(this.getCellColor(r));
                g.fillRect(boundingBox.x, boundingBox.y, boundingBox.width, boundingBox.height);
                if (!this.drawOutline) continue;
                g.setColor(this.outlineColor);
                g.drawRect(boundingBox.x, boundingBox.y, boundingBox.width, boundingBox.height);
            }
        }
        if (this.chartBorderOn) {
            g.setColor(this.chartBorderColor);
            g.drawRect((int)this.clipRect.getX(), (int)this.clipRect.getY(), (int)this.clipRect.getWidth(), (int)this.clipRect.getHeight());
        }
        if (callHighlightDraw) {
            this.drawHighlight(p);
        }
        g.setComposite(comp);
        this.redraw = false;
    }

    public void drawHighlight(Object p) {
        if (p == null || !(p instanceof Graphics2D) || this.transObj == null || !this.visible) {
            return;
        }
        if (this.displayList == null) {
            return;
        }
        Graphics2D g = (Graphics2D)p;
        int size = this.selectionList.size();
        if (size > 0) {
            int idx = 0;
            for (int i = 0; i < size; ++i) {
                idx = (Integer)this.selectionList.get(i);
                if (!this.isCellDisplayed(idx)) continue;
                this.drawHightlightedCell(g, idx);
            }
        } else {
            this.selectionList.clear();
            for (int i = 0; i < this.displayList.length; ++i) {
                if (!this.isCellDisplayed(i) || !this.dataOut.isSelected((long)this.displayList[i])) continue;
                this.drawHightlightedCell(g, i);
                this.selectionList.add(new Integer(i));
            }
            this.dataSelected = false;
        }
    }

    private void drawHightlightedCell(Graphics2D g, int idx) {
        double[] scr = new double[3];
        double x = this.getCellValue(true, idx);
        double y = this.getCellValue(false, idx);
        if (this.heatmapModel.isDateTime()) {
            this.transObj.project(x, y + 0.5, 0.0, scr);
        } else {
            this.transObj.project(x + 0.5, y + 0.5, 0.0, scr);
        }
        Rectangle boundingBox = new Rectangle();
        boundingBox.x = (int)(scr[0] - this.cellXSize * 0.5);
        boundingBox.y = (int)(scr[1] - this.cellYSize * 0.5);
        boundingBox.width = (int)(this.cellXSize + 1.0);
        boundingBox.height = (int)(this.cellYSize + 1.0);
        if (this.cellMarker > -1) {
            double ms = Math.min(this.cellXSize, this.cellYSize);
            Markers.draw((Graphics)g, (Color)this.selectionColor, (Color)this.outlineColor, (int)this.cellMarker, (int)((int)ms), (int)((int)scr[0]), (int)((int)scr[1]));
        } else {
            g.setColor(this.selectionColor);
            if (this.selectionPaint != null && boundingBox.width > 5 && boundingBox.height > 5) {
                g.setPaint(this.selectionPaint);
            }
            g.fillRect(boundingBox.x, boundingBox.y, boundingBox.width, boundingBox.height);
            g.setColor(this.selectionColor);
            if (this.drawOutline) {
                g.drawRect(boundingBox.x, boundingBox.y, boundingBox.width, boundingBox.height);
            }
        }
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        if (this.dataIn == null) {
            return null;
        }
        return this.dataIn.getSource();
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null || !(source instanceof DataFilterReadInterface)) {
            return false;
        }
        this.dataIn = (DataFilterReadInterface)source;
        if (this.heatmapModel == null) {
            this.heatmapModel = new HeatmapModel();
        }
        if (this.heatmapModel != null) {
            this.heatmapModel.setDataSource(this.dataIn);
            this.dataOut = null;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return true;
    }

    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    public Object getVariable(Object role) {
        if (this.heatmapModel == null) {
            return null;
        }
        return this.heatmapModel.getVariable(role);
    }

    public Object getRole(Object variableId) {
        if (this.heatmapModel == null) {
            return null;
        }
        return this.heatmapModel.getRole(variableId);
    }

    public boolean setRole(Object variableId, Object role) {
        if (this.heatmapModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.heatmapModel.setRole(variableId, role);
    }

    public boolean addRole(Object variableId, Object role) {
        if (this.heatmapModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.heatmapModel.addRole(variableId, role);
    }

    public boolean removeRole(Object variableId, Object role) {
        if (this.heatmapModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.heatmapModel.removeRole(variableId, role);
    }

    public boolean isDiscrete(Object role) {
        if (this.heatmapModel == null) {
            return false;
        }
        return this.heatmapModel.isDiscrete(role);
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.heatmapModel == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.heatmapModel.setDiscrete(role, discrete);
    }

    public Object getSortOrder(Object role) {
        if (this.heatmapModel == null) {
            return null;
        }
        return this.heatmapModel.getSortOrder(role);
    }

    public boolean setSortOrder(Object role, Object order) {
        if (this.heatmapModel == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.heatmapModel.setSortOrder(role, order);
    }

    public Object getRoleValue(Object role, int which) {
        if (this.heatmapModel == null) {
            return null;
        }
        return this.heatmapModel.getRoleValue(role, which);
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Object[] roles = null;
        roles = discrete ? new Object[]{HeatmapModel.ROLES.getRoleObject("ROLE_X"), HeatmapModel.ROLES.getRoleObject("ROLE_Y"), HeatmapModel.ROLES.getRoleObject("ROLE_RESPONSE"), HeatmapModel.ROLES.getRoleObject("ROLE_COLOR_INDEX")} : new Object[]{HeatmapModel.ROLES.getRoleObject("ROLE_COLOR_INDEX")};
        return roles;
    }

    public int getMaxAllowed(Object role) {
        return 1;
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public Object getTransformObject() {
        return this.transObj;
    }

    public boolean setTransformObject(Object transIn) {
        if (transIn == null || !(transIn instanceof TransformInterface)) {
            return false;
        }
        this.transObj = (TransformInterface)transIn;
        return true;
    }

    public double[] getBoundingBox() {
        if (!this.dataChanged) {
            return this.chartBBox;
        }
        this.defaultViewport = true;
        if (!this.prepareChartData()) {
            return null;
        }
        if (this.heatmapModel.isZeroObservation()) {
            this.yMin = 0.0;
            this.xMin = 0.0;
            this.yMax = 1.0;
            this.xMax = 1.0;
            this.chartBBox[0] = this.xMin;
            this.chartBBox[1] = this.yMin;
            this.chartBBox[2] = 0.0;
            this.chartBBox[3] = this.xMax;
            this.chartBBox[4] = this.yMax;
            this.chartBBox[5] = 0.0;
            return this.chartBBox;
        }
        double xHalfIncr = this.heatmapModel.isDateTime() ? 0.5 * this.heatmapModel.getDateTimeSpan() : 0.5;
        this.chartBBox[0] = this.xMin - (this.heatmapModel.isDateTime() ? xHalfIncr : 0.0);
        this.chartBBox[1] = this.yMin;
        this.chartBBox[2] = 0.0;
        this.chartBBox[3] = this.xMax + (this.heatmapModel.isDateTime() ? xHalfIncr : xHalfIncr * 2.0);
        this.chartBBox[4] = this.yMax + 1.0;
        this.chartBBox[5] = 0.0;
        return this.chartBBox;
    }

    public boolean setBoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        this.yMin = Math.max(0.0, Math.floor(ymin));
        this.yMax = Math.min((double)(this.heatmapModel.getUniqueYValueCount() - 1), Math.ceil(ymax));
        if (this.heatmapModel.isDateTime()) {
            this.xMin = Math.max(this.minTime, this.getNearestDateTimeValue(xmin, false));
            this.xMax = Math.min(this.maxTime, this.getNearestDateTimeValue(xmax, true));
        } else {
            this.xMin = Math.max(0.0, Math.floor(xmin));
            this.xMax = Math.min((double)(this.heatmapModel.getUniqueXValueCount() - 1), Math.ceil(xmax));
        }
        if (this.chartBBox[0] != xmin || this.chartBBox[1] != ymin || this.chartBBox[3] != xmax || this.chartBBox[4] != ymax) {
            this.chartBBox[0] = xmin;
            this.chartBBox[1] = ymin;
            this.chartBBox[2] = zmin;
            this.chartBBox[3] = xmax;
            this.chartBBox[4] = ymax;
            this.chartBBox[5] = zmax;
            this.updateInnerMargin();
            this.xAxis.setScreenArea((int)this.clipRect.getX(), (int)this.clipRect.getY(), (int)this.clipRect.getWidth(), (int)this.clipRect.getHeight());
            this.yAxis.setScreenArea((int)this.clipRect.getX(), (int)this.clipRect.getY(), (int)this.clipRect.getWidth(), (int)this.clipRect.getHeight());
            this.controllYAxisTickmarks((int)this.clipRect.getHeight());
            this.defaultViewport = false;
            RedrawEvent e = new RedrawEvent((Object)this);
            e.newBoundingBox = this.chartBBox;
            e.type = 2;
            this.fireRedrawEvent(e);
        }
        return true;
    }

    public Rectangle getScreenArea() {
        return null;
    }

    public boolean setScreenArea(int xmin, int ymin, int width, int height) {
        return false;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.isAdjusting) {
            return;
        }
        switch (evt.type) {
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                if (this.mouseAction) break;
                this.selectionList.clear();
                int[] arr = (int[])evt.oldValue;
                if (arr == null) {
                    boolean sel;
                    boolean bl = sel = this.dataOut.isSelected(0L);
                    if (sel) {
                        this.dataSelected = true;
                    }
                } else {
                    boolean sel;
                    boolean bl = sel = this.dataOut.isSelected((long)arr[0]);
                    if (sel) {
                        this.dataSelected = true;
                    }
                }
                this.fireRedrawEvent(new RedrawEvent((Object)this));
                break;
            }
            case 1: 
            case 3: {
                this.rebuildRequired = true;
                this.dataChanged = true;
                this.dataPrepared = false;
                this.fireRedrawEvent(new RedrawEvent((Object)this));
            }
        }
    }

    public HeatmapModel getHeatmapModel() {
        return this.heatmapModel;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.selectionColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.selectionColor = col;
        }
        FillPattern fillPattern = new FillPattern();
        this.selectionPaint = fillPattern.getHatch45(this.selectionColor);
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.outlineColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.outlineColor = col;
        }
        this.userSetProperties.set(801);
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public boolean isOutlineOn() {
        return this.outlineOn;
    }

    public void setOutlineOn(boolean on) {
        this.outlineOn = on;
        this.userSetProperties.set(802);
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Color getChartBorderColor() {
        return this.chartBorderColor;
    }

    public void setChartBorderColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.chartBorderColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.chartBorderColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public boolean isChartBorderOn() {
        return this.chartBorderOn;
    }

    public void setChartBorderOn(boolean on) {
        this.chartBorderOn = on;
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Color getOutOfRangeColor() {
        return this.outOfRangeColor;
    }

    public void setOutOfRangeColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.outOfRangeColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.outOfRangeColor = col;
        }
        this.userSetProperties.set(806);
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Color getMissingColor() {
        return this.missingColor;
    }

    public void setMissingColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.missingColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.missingColor = col;
        }
        this.userSetProperties.set(813);
        if (this.continuousColorRamp != null) {
            this.continuousColorRamp.setMissingColor(this.missingColor);
        }
        if (this.discreteColorRamp != null) {
            this.discreteColorRamp.setMissingColor(this.missingColor);
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Color getUnderflowColor() {
        return this.underflowColor;
    }

    public void setUnderflowColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.underflowColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.underflowColor = col;
        }
        this.userSetProperties.set(814);
        if (this.continuousColorRamp != null) {
            this.continuousColorRamp.setUnderflowColor(this.underflowColor);
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Color getOverflowColor() {
        return this.overflowColor;
    }

    public void setOverflowColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.overflowColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.overflowColor = col;
        }
        this.userSetProperties.set(815);
        if (this.continuousColorRamp != null) {
            this.continuousColorRamp.setOverflowColor(this.overflowColor);
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public ColorInterface getColorRamp() {
        return this.colorRangeType == 1 ? this.discreteColorRamp : this.continuousColorRamp;
    }

    public void setColorRamp(ColorInterface ramp, int rangeType) {
        if (ramp == null) {
            return;
        }
        switch (rangeType) {
            case 1: {
                this.discreteColorRamp = ramp;
                this.discreteColorRamp.setMissingColor(this.missingColor);
                this.userSetProperties.set(804);
                break;
            }
            case 2: {
                if (!this.heatmapModel.isNumericResponse()) {
                    return;
                }
                this.continuousColorRamp = ramp;
                this.continuousColorRamp.setOverflowColor(this.overflowColor);
                this.continuousColorRamp.setUnderflowColor(this.underflowColor);
                this.continuousColorRamp.setMissingColor(this.missingColor);
                this.userSetProperties.set(805);
                break;
            }
            default: {
                return;
            }
        }
        this.colorRangeType = rangeType;
        this.userSetProperties.set(803);
        this.setupLegend();
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public int getColorRangeType() {
        return this.colorRangeType;
    }

    public void setColorRangeType(int type) {
        if (this.colorRangeType == type) {
            return;
        }
        switch (type) {
            case 1: {
                break;
            }
            case 2: {
                if (this.heatmapModel.isNumericResponse()) break;
                return;
            }
            default: {
                return;
            }
        }
        this.colorRangeType = type;
        this.userSetProperties.set(803);
        this.setupLegend();
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public int getCellMarker() {
        return this.cellMarker;
    }

    public void setCellMarker(int marker) {
        this.cellMarker = marker;
        this.userSetProperties.set(807);
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public Color getCellBackground() {
        return this.cellBackground;
    }

    public void setCellBackground(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.cellBackground = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.cellBackground = col;
        }
        this.userSetProperties.set(808);
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public double getCellWidthScaleFactor() {
        return this.xScaleFactor;
    }

    public void setCellWidthScaleFactor(double scale) {
        if (scale <= 0.0 || scale > 1.0) {
            return;
        }
        this.xScaleFactor = scale;
        this.userSetProperties.set(809);
        if (this.cellEquated) {
            this.yScaleFactor = this.xScaleFactor;
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public double getCellHeightScaleFactor() {
        return this.yScaleFactor;
    }

    public void setCellHeightScaleFactor(double scale) {
        if (scale <= 0.0 || scale > 1.0) {
            return;
        }
        if (this.cellEquated) {
            return;
        }
        this.yScaleFactor = scale;
        this.userSetProperties.set(810);
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public boolean isCellEquated() {
        return this.cellEquated;
    }

    public void setCellEquated(boolean eq) {
        if (eq == this.cellEquated) {
            return;
        }
        this.cellEquated = eq;
        this.userSetProperties.set(811);
        this.updateInnerMargin();
        if (eq && !this.defaultViewport) {
            this.defaultViewport = true;
            if (this.heatmapModel.isDateTime()) {
                this.xMin = this.minTime;
                this.xMax = this.maxTime;
            } else {
                this.xMin = 0.0;
                this.xMax = this.heatmapModel.getUniqueXValueCount() - 1;
            }
            this.yMin = 0.0;
            this.yMax = this.heatmapModel.getUniqueYValueCount() - 1;
            this.rebuildRequired = true;
            this.dataChanged = true;
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public boolean isCellBackgroundOn() {
        return this.cellBackgroundOn;
    }

    public void setCellBackgroundOn(boolean on) {
        this.cellBackgroundOn = on;
        this.fireRedrawEvent(new RedrawEvent((Object)this));
    }

    public boolean isFitToScreen() {
        return this.fitToScreen;
    }

    public void setFitToScreen(boolean fit) {
        this.fitToScreen = fit;
    }

    protected void fireRedrawEvent(RedrawEvent e) {
        if (this.redraw) {
            return;
        }
        block4: for (int i = 0; i < this.redrawListener.size(); ++i) {
            RedrawListener listener = (RedrawListener)this.redrawListener.get(i);
            if (listener == null) continue;
            switch (e.type) {
                default: {
                    listener.redraw(e);
                    continue block4;
                }
                case 2: {
                    listener.boundingBoxChanged(e);
                    listener.outerMarginChanged(e);
                    continue block4;
                }
                case 3: {
                    listener.outerMarginChanged(e);
                }
            }
        }
    }

    public void addRedrawListener(RedrawListener listener) {
        if (!this.redrawListener.contains(listener)) {
            this.redrawListener.add(listener);
        }
    }

    public void removeRedrawListener(RedrawListener listener) {
        if (this.redrawListener.contains(listener)) {
            this.redrawListener.remove(this.redrawListener.indexOf(listener));
        }
    }

    public Object getPropertyValue(int idx) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            return this.propertyValue.get(i);
        }
        switch (idx) {
            case 801: {
                return this.outlineColor;
            }
            case 802: {
                return new Boolean(this.outlineOn);
            }
            case 803: {
                return new Integer(this.colorRangeType);
            }
            case 804: {
                return this.discreteColorRamp;
            }
            case 805: {
                return this.continuousColorRamp;
            }
            case 806: {
                return this.outOfRangeColor;
            }
            case 813: {
                return this.missingColor;
            }
            case 814: {
                return this.underflowColor;
            }
            case 815: {
                return this.overflowColor;
            }
            case 807: {
                return new Integer(this.cellMarker);
            }
            case 808: {
                return this.cellBackground;
            }
            case 809: {
                return new Double(this.xScaleFactor);
            }
            case 810: {
                return new Double(this.yScaleFactor);
            }
            case 811: {
                return new Boolean(this.cellEquated);
            }
            case 816: {
                return this.getColorList();
            }
        }
        return null;
    }

    public boolean setPropertyValue(int idx, Object value) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            this.propertyValue.set(i, value);
        } else {
            this.propertyIndex.add(new Integer(idx));
            this.propertyValue.add(value);
        }
        return true;
    }

    public int getNumberProperties() {
        return 16;
    }

    public boolean applyPropertyChanges() {
        if (this.propertyIndex.size() <= 0) {
            return false;
        }
        block17: for (int i = 0; i < this.propertyIndex.size(); ++i) {
            int idx = (Integer)this.propertyIndex.get(i);
            Object value = this.propertyValue.get(i);
            switch (idx) {
                case 801: {
                    this.setOutlineColor(value);
                    continue block17;
                }
                case 802: {
                    if (!(value instanceof Boolean)) continue block17;
                    this.setOutlineOn((Boolean)value);
                    continue block17;
                }
                case 803: {
                    if (!(value instanceof Integer)) continue block17;
                    this.setColorRangeType((Integer)value);
                    continue block17;
                }
                case 804: {
                    if (!(value instanceof ColorInterface)) continue block17;
                    this.setColorRamp((ColorInterface)value, 1);
                    continue block17;
                }
                case 805: {
                    if (!(value instanceof ColorInterface)) continue block17;
                    this.setColorRamp((ColorInterface)value, 2);
                    continue block17;
                }
                case 806: {
                    this.setOutOfRangeColor(value);
                    continue block17;
                }
                case 813: {
                    this.setMissingColor(value);
                    continue block17;
                }
                case 814: {
                    this.setUnderflowColor(value);
                    continue block17;
                }
                case 815: {
                    this.setOverflowColor(value);
                    continue block17;
                }
                case 807: {
                    if (!(value instanceof Integer)) continue block17;
                    this.setCellMarker((Integer)value);
                    continue block17;
                }
                case 808: {
                    this.setCellBackground(value);
                    continue block17;
                }
                case 809: {
                    if (!(value instanceof Number)) continue block17;
                    this.setCellWidthScaleFactor(((Number)value).doubleValue());
                    continue block17;
                }
                case 810: {
                    if (!(value instanceof Number)) continue block17;
                    this.setCellHeightScaleFactor(((Number)value).doubleValue());
                    continue block17;
                }
                case 811: {
                    if (!(value instanceof Boolean)) continue block17;
                    this.setCellEquated((Boolean)value);
                    continue block17;
                }
                case 816: {
                    if (!(value instanceof Color[])) continue block17;
                    this.setColorList((Color[])value);
                    continue block17;
                }
            }
        }
        this.fireRedrawEvent(new RedrawEvent((Object)this));
        this.propertyIndex.clear();
        this.propertyValue.clear();
        return true;
    }

    public boolean applyPropertyChanges(Object source) {
        return this.applyPropertyChanges();
    }

    public void cancelPropertyChanges() {
        this.propertyIndex.clear();
        this.propertyValue.clear();
    }

    public void cancelPropertyChanges(Object source) {
    }

    public int[] getPendingChanges() {
        int[] index = new int[this.propertyIndex.size()];
        for (int i = 0; i < this.propertyIndex.size(); ++i) {
            index[i] = (Integer)this.propertyIndex.get(i);
        }
        return index;
    }

    public int[] getPendingChanges(Object source) {
        int[] index = new int[this.propertyIndex.size()];
        return index;
    }

    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 801: 
            case 802: 
            case 803: 
            case 804: 
            case 805: 
            case 806: 
            case 807: 
            case 808: 
            case 809: 
            case 810: 
            case 811: 
            case 816: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int idx) {
        return false;
    }

    public int getNumberPendingProperties() {
        return -1;
    }

    public boolean hasUserSetValue(int id) {
        if (this.userSetProperties.hasProperty(id)) {
            return this.userSetProperties.get(id);
        }
        return true;
    }

    public Color[] getColorList() {
        return this.colorList;
    }

    public void setColorList(Color[] colorList) {
        this.colorList = colorList;
        this.userSetProperties.set(816);
    }
}

