/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.graphtable;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public class TextLabelUI
extends BasicLabelUI {
    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonic();
        Float bold = null;
        Color color = l.getForeground();
        g.setColor(color);
        BasicGraphicsUtils.drawString(g, s, accChar, textX, textY);
        Font f = l.getFont();
        Map<TextAttribute, ?> map = f.getAttributes();
        Object o = map.get(TextAttribute.WEIGHT);
        if (o instanceof Float) {
            bold = (Float)o;
        } else if (o instanceof Number) {
            bold = new Float(((Number)o).floatValue());
        }
        if (bold == null) {
            return;
        }
        if (bold.equals(TextAttribute.WEIGHT_BOLD)) {
            int i;
            Graphics2D g2d = (Graphics2D)g;
            StringBuffer sb = new StringBuffer(s);
            FontRenderContext fontContext = g2d.getFontRenderContext();
            Rectangle2D b = f.getStringBounds(s, fontContext);
            int x = (int)b.getX() + textX;
            int y = -textY;
            int width = (int)b.getWidth();
            int len = sb.length();
            for (i = 0; i < len && sb.charAt(i) == ' '; ++i) {
            }
            String newString = s.substring(i);
            Rectangle2D b2 = f.getStringBounds(newString, fontContext);
            int deltaX = width - (int)b2.getWidth();
            newString = s.trim();
            b2 = f.getStringBounds(newString, fontContext);
            int deltaW = width - (int)b2.getWidth();
            g.drawLine(x += deltaX, -(--y), x + (width -= deltaW), -y);
        }
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonic();
        Rectangle r = new Rectangle();
        g.setColor(l.getBackground());
        r = l.getBounds(r);
        g.fillRect(0, 0, r.width, r.height);
        Color background = l.getBackground();
        g.setColor(background.brighter());
        BasicGraphicsUtils.drawString(g, s, accChar, textX + 1, textY + 1);
        g.setColor(background.darker());
        BasicGraphicsUtils.drawString(g, s, accChar, textX, textY);
    }
}

