/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.graphtable;

import javax.swing.table.AbstractTableModel;

public class MyTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7351861651431364972L;
    private boolean DEBUG = true;
    int rowCount;
    int columnCount;
    int maxRowCount;
    String[] columnNames;
    Object[][] data;

    public MyTableModel(int rowCount, int columnCount, Object[][] dataIn, String[] names) {
        int i;
        this.columnCount = columnCount;
        this.rowCount = rowCount;
        this.data = new Object[rowCount][columnCount];
        this.columnNames = new String[columnCount];
        for (i = 0; i < columnCount; ++i) {
            this.columnNames[i] = new String(" ");
        }
        if (names != null) {
            for (i = 0; i < columnCount; ++i) {
                this.columnNames[i] = names[i];
            }
        }
        if (dataIn != null) {
            for (i = 0; i < rowCount; ++i) {
                for (int j = 0; j < columnCount; ++j) {
                    this.data[i][j] = dataIn[i][j];
                }
            }
        }
    }

    public void setColumnNames(String[] names) {
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                this.columnNames[i] = names[i];
            }
        }
    }

    public void appendRow(Object[] row) {
        int lMax = Math.min(this.columnCount, row.length);
        if (this.rowCount >= this.maxRowCount) {
            return;
        }
        if (row != null) {
            for (int i = 0; i < lMax; ++i) {
                this.data[this.rowCount][i] = row[i];
            }
        }
        ++this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    public Class getColumnClass(int c) {
        Object obj = this.getValueAt(0, c);
        if (obj == null) {
            return null;
        }
        return obj.getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this.data[0][col] instanceof Integer && !(value instanceof Integer)) {
            try {
                this.data[row][col] = new Integer(value.toString());
                this.fireTableCellUpdated(row, col);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
        if (this.DEBUG) {
            System.out.println("New value of data:");
            this.printDebugData();
        }
    }

    private void printDebugData() {
        int numRows = this.getRowCount();
        int numCols = this.getColumnCount();
        for (int i = 0; i < numRows; ++i) {
            System.out.print("    row " + i + ":");
            for (int j = 0; j < numCols; ++j) {
                System.out.print("  " + this.data[i][j]);
            }
            System.out.println();
        }
        System.out.println("--------------------------");
    }
}

