/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.graphtable;

import com.sas.graphics.silk.graphtable.GTable;
import java.applet.AppletContext;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class GTableCellListener
implements MouseListener,
MouseMotionListener {
    static int prevColumn = -1;
    static int prevRow = -1;
    static int prevClickColumn = -1;
    static int prevClickRow = -1;
    JTable jTableView;
    GTable gTableView;
    TableColumnModel columnModel;
    Cursor handCursor = new Cursor(12);
    Cursor defaultCursor = new Cursor(0);
    AppletContext context = null;
    String docTarget;
    URL docBase = null;
    boolean popUp = false;
    private Hashtable columnTargets = null;

    public GTableCellListener(GTable table, URL docBase, AppletContext context, String target) {
        this.gTableView = table;
        this.jTableView = table;
        this.columnModel = this.jTableView.getColumnModel();
        this.docTarget = target;
        this.columnTargets = new Hashtable();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            this.columnTargets.put(table.getColumnName(i), target);
        }
        this.docBase = docBase;
        this.context = context;
    }

    public void isPopupEvent(boolean pop) {
        this.popUp = pop;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int clickColumn = this.jTableView.columnAtPoint(e.getPoint());
        int clickRow = this.jTableView.rowAtPoint(e.getPoint());
        if (this.popUp) {
            this.popUp = false;
            return;
        }
        int modelColumnIndex = this.jTableView.convertColumnIndexToModel(clickColumn);
        if (clickRow != -1 && clickColumn != -1) {
            Point cell = new Point(clickColumn, clickRow);
            this.gTableView.setSelectedCell(cell);
            this.gTableView.repaint();
            String link = this.gTableView.getLink(clickRow, modelColumnIndex);
            if (link != null) {
                try {
                    URL url = new URL(this.docBase, link);
                    String columnN = this.gTableView.getColumnName(modelColumnIndex);
                    Object targ = this.columnTargets.get(columnN);
                    if (targ == null) {
                        targ = this.docTarget;
                    }
                    if (this.context != null) {
                        this.context.showDocument(url, targ.toString());
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.gTableView.setCursor(this.defaultCursor);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.isPopupEvent(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.isPopupEvent(true);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int viewColumn = this.jTableView.columnAtPoint(e.getPoint());
        int viewRow = this.jTableView.rowAtPoint(e.getPoint());
        int modelColumnIndex = this.jTableView.convertColumnIndexToModel(viewColumn);
        if (modelColumnIndex != prevColumn || viewRow != prevRow) {
            this.setCursor(viewRow, modelColumnIndex);
        }
    }

    private void setCursor(int row, int column) {
        if (row >= 0 && column >= 0) {
            String link = this.gTableView.getLink(row, column);
            if (link != null) {
                this.gTableView.setCursor(this.handCursor);
                if (this.context != null) {
                    this.context.showStatus(link);
                }
            } else {
                this.gTableView.setCursor(this.defaultCursor);
                if (this.context != null) {
                    this.context.showStatus(" ");
                }
            }
        } else {
            this.gTableView.setCursor(this.defaultCursor);
        }
        prevRow = row;
        prevColumn = column;
    }

    public void setTarget(String columnName, String target) {
        if (target != null && columnName != null) {
            this.columnTargets.remove(columnName);
            this.columnTargets.put(columnName, target);
        }
    }

    public String getTarget(String colName) {
        Object o = this.columnTargets.get(colName);
        if (o != null) {
            return o.toString();
        }
        return null;
    }
}

