/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.graphtable;

import com.sas.graphics.silk.graphtable.FormattedColumnCellRenderer;
import com.sas.graphics.silk.graphtable.GTableAggregatedDataFilter;
import com.sas.graphics.silk.graphtable.GTableCellListener;
import com.sas.graphics.silk.graphtable.GTablePanel;
import com.sas.graphics.silk.graphtable.GraphicalColumnCellRenderer;
import com.sas.graphics.silk.graphtable.ImageColumnCellRenderer;
import com.sas.graphics.silk.graphtable.TextAreaRenderer;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.ui.CopyOptionsDialog;
import com.sas.graphics.silk.ui.RadioMenu;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.ExcelAdapter;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.table.ColumnHeaderRenderer;
import com.sas.graphics.silk.util.table.GTableModel;
import com.sas.graphics.silk.util.table.HeaderTextPaneRenderer;
import com.sas.graphics.silk.util.table.SILKTableInterface;
import com.sas.graphics.silk.util.table.TableConstants;
import com.sas.graphics.silk.util.table.TableSorter;
import com.sas.graphics.silk.util.table.TableStyle;
import com.sas.graphics.util.AboutFrame;
import com.sas.graphics.util.SASIcon;
import com.sas.text.SASFormat;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class GTable
extends JTable
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 8818658225040841933L;
    private static int actualRowCount = 0;
    private static String metaHeaderString;
    private int selectedModelRow = -1;
    private int selectedModelColumn = -1;
    private JApplet applet = null;
    private TableSorter model = null;
    private GTableModel gtModel = null;
    private GTablePanel gtPanel = null;
    private String[] columnFormat;
    private String target = new String("_blank");
    private String name;
    private Hashtable renderMode;
    private TableStyle style;
    private int paneWidth;
    private int[] headerWidth;
    private int[] cellWidth;
    private int[] maxWidth;
    private int tableWidth = 0;
    private boolean resizeCalled = false;
    private boolean columnsResized = false;
    private AboutFrame aboutFrame = null;
    private SASIcon sasIcon = null;
    public int maxComputedCellWidth = 200;
    public ImageIcon ascendingIcon = null;
    public ImageIcon descendingIcon = null;
    public ImageIcon linkIcon = null;
    protected GTableCellListener listener;
    protected GTable otherGTable = null;
    protected JPopupMenu popMenu = new JPopupMenu();
    protected JMenu printMenu = new JMenu();
    protected RadioMenu sortMenu = new RadioMenu();
    protected RadioMenu displayMenu = new RadioMenu();
    protected JMenu helpMenu = new JMenu();
    protected JCheckBoxMenuItem obsColumn = null;
    public boolean showPopMenu = false;
    protected boolean statistics = false;
    ResourceBundle resourceBundle;
    String[] mainMenu = new String[]{"Popupmenu.Main.Spacer.txt", "Popupmenu.Main.Hide.txt", "Popupmenu.Main.ShowAll.txt", "Popupmenu.Main.Spacer.txt"};
    String[] sortMode = new String[]{"Popupmenu.Sort.Ascending.txt", "Popupmenu.Sort.Descending.txt", "Popupmenu.Sort.DataOrder.txt"};
    String[] displayMode = new String[]{"Popupmenu.Display.Text.txt", "Popupmenu.Display.Graphics.txt", "Popupmenu.Display.Funnel.txt"};
    String[] helpMode = new String[]{"Popupmenu.Help.AboutApplet.txt"};
    String[] printMode = new String[]{"Popupmenu.Print.ScreenView.txt", "Popupmenu.Print.FitToPage.txt"};
    String about = new String("Popupmenu.Help.AboutApplet.txt");
    String spacer = new String("Popupmenu.View.Spacer.txt");
    String helpMenuActionCommand = "Popupmenu.Help.Menu.txt";
    static int prevColumn;
    static int prevRow;
    int RMBColumn = -1;
    Date date;
    private LinkedHashMap alignments = new LinkedHashMap();
    protected Hashtable colorRamps = new Hashtable();

    public GTable(GTableModel gtm, TableStyle style, String name, boolean stats, boolean showPopMenu, int paneWidth, GTablePanel panel) {
        this.name = new String(name);
        this.showPopMenu = showPopMenu;
        this.statistics = stats;
        this.paneWidth = paneWidth;
        this.gtPanel = panel;
        this.loadIcons();
        this.style = style;
        if (showPopMenu) {
            this.setupColumnHeaderMenu();
        }
        this.setTableRowHeight();
        this.setModel(gtm);
        if (!GraphicsEnvironment.isHeadless()) {
            new ExcelAdapter((JTable)this);
        }
    }

    public TableSorter getGTableModel() {
        return this.model;
    }

    public void setSyncTable(GTable gt) {
        this.otherGTable = gt;
    }

    public String getLink(int row, int column) {
        return this.model.getLink(row, column);
    }

    public Color getCellItemColor(int row, int column, int item) {
        if (this.model != null && this.model.isObsNumberColumnVisible() && column == 0 && this.style != null) {
            return this.style.getItemColor(2);
        }
        Color color = this.model.getCellItemColor(row, column);
        if (color == null) {
            color = this.style.getItemColor(item);
        }
        return color;
    }

    public JPopupMenu getPopupMenu() {
        return this.popMenu;
    }

    public int getRenderMode(int columnIndex) {
        Object o;
        int columnCount = this.model.getColumnCount();
        if (columnIndex >= 0 && columnIndex < columnCount && (o = this.renderMode.get(this.model.getColumnName(columnIndex))) instanceof Number) {
            return ((Number)o).intValue();
        }
        return TableConstants.RENDERMODE_TEXT;
    }

    public int getTableWidth() {
        return this.tableWidth;
    }

    public void setStyle(TableStyle st) {
        this.style = st;
    }

    public TableStyle getStyle() {
        return this.style;
    }

    public int getViewRowFromModel(int row) {
        return this.model.getViewRowFromModel(row);
    }

    public int getModelRowFromView(int row) {
        return this.model.getModelRowFromView(row);
    }

    public Point getSelectedCell(Point loc) {
        if (this.selectedModelColumn >= 0) {
            loc.x = this.convertColumnIndexToView(this.selectedModelColumn);
        }
        loc.y = this.model.getViewRowFromModel(this.selectedModelRow);
        return loc;
    }

    public void setSelectedCell(Point cellIndex) {
        this.selectedModelRow = this.model.getModelRowFromView(cellIndex.y);
        if (cellIndex.x >= 0) {
            this.selectedModelColumn = this.convertColumnIndexToModel(cellIndex.x);
        }
    }

    public void setModel(GTableModel gtm) {
        if (gtm == this.gtModel) {
            return;
        }
        this.gtModel = gtm;
        if (this.gtModel != null) {
            this.gtModel.addTableModelListener((TableModelListener)this);
        }
        TableSorter map = this.model = new TableSorter(this.gtModel, this.name, this.statistics);
        metaHeaderString = map.getMetaHeaderString();
        actualRowCount = this.model.getRowCount();
        super.setModel((TableModel)this.model);
        this.setupTableView();
        this.model.addMouseListenerToHeaderInTable((JTable)this, this.ascendingIcon, this.descendingIcon, this.linkIcon);
    }

    public void setAppletContext(JApplet app) {
        this.applet = app;
        this.removeMouseListenerToTable(this);
        this.addMouseListenerToTable(this, this.applet, this.target);
        if (this.applet != null) {
            this.model.setAppletContext(this.applet.getAppletContext(), this.applet.getDocumentBase(), this.target);
            this.gtModel.applet = this.applet;
        }
    }

    public void setTarget(String t) {
        this.target = new String(t);
        this.removeMouseListenerToTable(this);
        this.addMouseListenerToTable(this, this.applet, this.target);
        if (this.applet != null) {
            this.model.setAppletContext(this.applet.getAppletContext(), this.applet.getDocumentBase(), this.target);
        }
    }

    public void setTarget(String columnName, String t) {
        if (t != null && columnName != null) {
            int index;
            if (this.listener == null) {
                this.setTarget(this.target);
            }
            if ((index = this.gtModel.getColumnIndex(columnName)) < 0) {
                return;
            }
            String cName = this.gtModel.getColumnName(index);
            this.listener.setTarget(cName, t);
        }
    }

    public String getTarget(String columnName) {
        if (columnName == null || this.listener == null) {
            return null;
        }
        return this.listener.getTarget(columnName);
    }

    public void setNativeLookAndFeel(boolean set) {
        if (set) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setColumnFormats(String[] formats) {
        if (formats != null) {
            for (int i = 0; i < formats.length; ++i) {
                this.columnFormat[i] = formats[i];
            }
        }
    }

    public void setRenderMode(int viewModelIndex, int mode) {
        ColorInterface oldRamp = null;
        if (this.model.getColumnClass(viewModelIndex) == Image.class || this.model.getColumnClass(viewModelIndex) == ImageIcon.class) {
            return;
        }
        TableColumnModel columnModel = this.getColumnModel();
        int columnCount = this.model.getColumnCount();
        if (viewModelIndex >= 0 && viewModelIndex < columnCount) {
            TableColumn viewColumn = columnModel.getColumn(viewModelIndex);
            Class cellClass = this.model.getColumnClass(viewModelIndex);
            boolean number = this.isNumericClass(cellClass);
            TableCellRenderer renderer = viewColumn.getCellRenderer();
            if (renderer instanceof FormattedColumnCellRenderer) {
                oldRamp = ((FormattedColumnCellRenderer)renderer).ramp;
            } else if (renderer instanceof GraphicalColumnCellRenderer) {
                oldRamp = ((GraphicalColumnCellRenderer)renderer).ramp;
            }
            this.renderMode.put(this.model.getColumnName(viewModelIndex), new Integer(mode));
            int[] modes = new int[this.model.getColumnCount()];
            for (int i = 0; i < modes.length; ++i) {
                modes[i] = this.getRenderMode(i);
            }
            this.gtModel.setRenderModes(modes);
            if (mode == TableConstants.RENDERMODE_TEXT) {
                FormattedColumnCellRenderer fCellRenderer = new FormattedColumnCellRenderer(cellClass, this.columnFormat[viewModelIndex], this);
                fCellRenderer.setRamp(oldRamp);
                viewColumn.setCellRenderer(fCellRenderer);
            } else {
                boolean funnel = false;
                if (mode == TableConstants.RENDERMODE_FUNNEL) {
                    funnel = true;
                }
                if (number) {
                    Object min = this.model.getColumnMinValue(viewModelIndex);
                    Object max = this.model.getColumnMaxValue(viewModelIndex);
                    GraphicalColumnCellRenderer cellRenderer = new GraphicalColumnCellRenderer(cellClass, min, max, this, funnel);
                    cellRenderer.setRamp(oldRamp);
                    viewColumn.setCellRenderer(cellRenderer);
                } else {
                    GraphicalColumnCellRenderer cellRenderer = new GraphicalColumnCellRenderer(cellClass, this, this.gtPanel, true, false);
                    viewColumn.setCellRenderer(cellRenderer);
                }
            }
        }
    }

    public void resizeColumns(int paneWidth) {
        this.paneWidth = paneWidth;
        this.setColumnWidths(paneWidth);
        this.resizeCalled = true;
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public void hideColumn(int columnIndex) {
        this.model.setHiddenColumn(columnIndex);
    }

    public void sortColumn(int columnIndex, boolean ascending) {
        int sortOrder = ascending ? 0 : 1;
        this.sortColumn(columnIndex, sortOrder);
    }

    public void sortColumn(int columnIndex, int sortOrder) {
        this.model.setColumnSortState((JTable)this, columnIndex, sortOrder);
    }

    public int getSortState(int index) {
        return this.model.getSortState(index);
    }

    private void loadIcons() {
        Image image = ResourceLoader.getImage((Component)this, (String)"icons/ascendingIcon.gif");
        if (image != null) {
            this.ascendingIcon = new ImageIcon(image);
        }
        if ((image = ResourceLoader.getImage((Component)this, (String)"icons/descendingIcon.gif")) != null) {
            this.descendingIcon = new ImageIcon(image);
        }
        if ((image = ResourceLoader.getImage((Component)this, (String)"icons/linkIcon.gif")) != null) {
            this.linkIcon = new ImageIcon(image);
        }
    }

    private void setupTableView() {
        int i;
        if (this.listener == null) {
            this.addMouseListenerToTable(this, this.applet, this.target);
        }
        TableColumnModel columnModel = this.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        if (this.renderMode == null) {
            this.renderMode = new Hashtable();
            for (i = 0; i < columnCount; ++i) {
                this.renderMode.put(this.model.getColumnName(i), new Integer(this.model.getRenderMode(i)));
            }
        }
        this.columnFormat = new String[columnCount];
        for (i = 0; i < columnCount; ++i) {
            this.columnFormat[i] = this.model.getColumnFormat(i);
        }
        String[] link = new String[columnCount];
        if (this.model != null) {
            for (i = 0; i < columnCount; ++i) {
                link[i] = this.model.getColumnLink(i);
            }
        }
        for (i = 0; i < columnCount; ++i) {
            Class cellClass = this.model.getColumnClass(i);
            boolean cellWrap = this.model.getColumnWrap(i);
            String cellFormat = this.columnFormat[i];
            int cellRenderMode = this.getRenderMode(i);
            Object headerRenderer = null;
            boolean headerWrap = this.model.isHeaderWrapped();
            headerRenderer = headerWrap ? new HeaderTextPaneRenderer(this.ascendingIcon, this.descendingIcon, this.linkIcon, (SILKTableInterface)this.gtPanel, this.model, this.style) : new ColumnHeaderRenderer(this.ascendingIcon, this.descendingIcon, this.linkIcon, (JTable)this);
            headerRenderer.setStyle(this.style);
            headerRenderer.setLinks(link, columnCount);
            TableColumn viewColumn = columnModel.getColumn(i);
            viewColumn.setHeaderRenderer((TableCellRenderer)headerRenderer);
            if (headerRenderer instanceof JComponent) {
                ((JComponent)headerRenderer).setToolTipText(this.model.getColumnDescription(i));
            }
            boolean number = this.isNumericClass(cellClass);
            if (cellRenderMode == TableConstants.RENDERMODE_TEXT) {
                if (cellClass != Image.class && cellClass != ImageIcon.class) {
                    if (cellClass == String.class && cellWrap) {
                        TextAreaRenderer textRenderer = new TextAreaRenderer(cellClass, cellFormat, this, this.gtPanel);
                        viewColumn.setCellRenderer(textRenderer);
                        continue;
                    }
                    FormattedColumnCellRenderer fCellRenderer = new FormattedColumnCellRenderer(cellClass, cellFormat, this);
                    viewColumn.setCellRenderer(fCellRenderer);
                    continue;
                }
                ImageColumnCellRenderer iCellRenderer = new ImageColumnCellRenderer(cellClass, cellFormat, this);
                viewColumn.setCellRenderer(iCellRenderer);
                continue;
            }
            if (cellRenderMode == TableConstants.RENDERMODE_IMAGE || cellRenderMode == TableConstants.RENDERMODE_IMAGEICON) {
                ImageColumnCellRenderer iCellRenderer = new ImageColumnCellRenderer(cellClass, cellFormat, this);
                viewColumn.setCellRenderer(iCellRenderer);
                continue;
            }
            boolean funnel = false;
            if (cellRenderMode == TableConstants.RENDERMODE_FUNNEL) {
                funnel = true;
            }
            if (number) {
                Object min = this.model.getColumnMinValue(i);
                Object max = this.model.getColumnMaxValue(i);
                GraphicalColumnCellRenderer cellRenderer = new GraphicalColumnCellRenderer(cellClass, min, max, this, funnel);
                viewColumn.setCellRenderer(cellRenderer);
                continue;
            }
            GraphicalColumnCellRenderer cellRenderer = new GraphicalColumnCellRenderer(cellClass, this, this.gtPanel, true, false);
            viewColumn.setCellRenderer(cellRenderer);
        }
        this.computeWidths();
        this.setColumnWidths(0);
        if (this.alignments.size() > 0) {
            for (i = 0; i < this.model.getColumnCount(); ++i) {
                Object o = this.alignments.get(this.model.getColumnName(i));
                if (!(o instanceof Number)) continue;
                int align = ((Number)o).intValue();
                this.setHorizontalAlignment(i, align);
            }
        }
        Enumeration e = this.colorRamps.keys();
        while (e.hasMoreElements()) {
            Object col = e.nextElement();
            Object o = this.colorRamps.get(col);
            if (!(o instanceof ColorInterface)) continue;
            this.gtPanel.setColorRamp(col, (ColorInterface)o);
        }
    }

    private void setupColumnHeaderMenu() {
        JMenuItem mi;
        JCheckBoxMenuItem cmi;
        int i;
        this.resourceBundle = ResourceBundle.getBundle("com.sas.graphics.silk.graphtable.GTable");
        String str = this.GRS(this.resourceBundle, "Popupmenu.Main.Sort.txt", "Default:Sort");
        this.sortMenu.setText(str);
        for (i = 0; i < this.sortMode.length; ++i) {
            str = this.GRS(this.resourceBundle, this.sortMode[i], "Default:Sort");
            cmi = new JCheckBoxMenuItem(str);
            cmi.setActionCommand(this.sortMode[i]);
            cmi.addItemListener(this);
            this.sortMenu.add(cmi);
        }
        str = this.GRS(this.resourceBundle, "Popupmenu.Main.Print.txt", "Default:Print");
        this.printMenu.setText(str);
        for (i = 0; i < this.printMode.length; ++i) {
            str = this.GRS(this.resourceBundle, this.printMode[i], "Default:Print");
            mi = new JMenuItem(str);
            mi.setActionCommand(this.printMode[i]);
            mi.addActionListener(this);
            this.printMenu.add(mi);
        }
        str = this.GRS(this.resourceBundle, "Popupmenu.Main.Display.txt", "Default:View");
        this.displayMenu.setText(str);
        for (i = 0; i < this.displayMode.length; ++i) {
            str = this.GRS(this.resourceBundle, this.displayMode[i], "Default");
            cmi = new JCheckBoxMenuItem(str, false);
            cmi.setActionCommand(this.displayMode[i]);
            cmi.addItemListener(this);
            this.displayMenu.add(cmi);
        }
        str = this.GRS(this.resourceBundle, "Popupmenu.Main.Help.txt", "Default:Help");
        this.helpMenu.setText(str);
        this.helpMenu.setActionCommand(this.helpMenuActionCommand);
        for (i = 0; i < this.helpMode.length; ++i) {
            str = this.GRS(this.resourceBundle, this.helpMode[i], "Default");
            mi = new JMenuItem(str);
            mi.setActionCommand(this.helpMode[i]);
            mi.addActionListener(this);
            this.helpMenu.add(mi);
        }
        JMenu copy = new JMenu(this.GRS(this.resourceBundle, "Popupmenu.Main.Copy.txt", "Copy"));
        JMenuItem image = new JMenuItem(this.GRS(this.resourceBundle, "Popumenu.Copy.Image.txt", "Image"));
        image.setActionCommand("Copy.Image");
        image.addActionListener(this);
        copy.add(image);
        JMenuItem excel = new JMenuItem(this.GRS(this.resourceBundle, "PopupMenu.Copy.Excel.txt", "As Spreadsheet..."));
        excel.setActionCommand("Copy.Excel");
        excel.addActionListener(this);
        copy.add(excel);
        this.popMenu.setLabel("GTable");
        this.popMenu.add((JMenuItem)this.sortMenu);
        this.popMenu.add((JMenuItem)this.displayMenu);
        if (!this.gtPanel.isFilterOn() && !this.gtPanel.isRowHeaderOn()) {
            this.obsColumn = new JCheckBoxMenuItem(this.GRS(this.resourceBundle, "Popupmenu.Main.ObsNumberColumn.txt", "Show Obs # Column"));
            this.obsColumn.setSelected(this.gtPanel.isObsNumberColumnVisible());
            this.obsColumn.setActionCommand("obsColumn");
            this.obsColumn.addItemListener(this);
            this.popMenu.addSeparator();
            this.popMenu.add(this.obsColumn);
        }
        for (int i2 = 0; i2 < this.mainMenu.length; ++i2) {
            if (this.mainMenu[i2].compareTo("Popupmenu.Main.Spacer.txt") == 0) {
                this.popMenu.addSeparator();
                continue;
            }
            str = this.GRS(this.resourceBundle, this.mainMenu[i2], "Default");
            JMenuItem mi2 = new JMenuItem(str);
            mi2.setActionCommand(this.mainMenu[i2]);
            mi2.addActionListener(this);
            if (i2 == 4 || i2 == 6) continue;
            this.popMenu.add(mi2);
        }
        this.popMenu.add(copy);
        this.popMenu.add(this.printMenu);
        if (SILKGlobal.isTestMode()) {
            this.popMenu.addSeparator();
            ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.menus.silk_menus_NLS");
            JMenuItem saveAsXML = new JMenuItem(ResourceLoader.getResourceString((Object)rb, (String)"Popup.Save_As_XML.txt", (String)"Save As XML..."));
            saveAsXML.setActionCommand("DEBUG__SAVE_AS_XML");
            this.popMenu.add(saveAsXML);
        }
        this.add(this.popMenu);
    }

    public void computeWidths() {
        TableColumnModel columnModel = this.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        this.headerWidth = new int[columnCount];
        this.cellWidth = new int[columnCount];
        this.maxWidth = new int[columnCount];
        this.tableWidth = 0;
        for (int i = 0; i < columnCount; ++i) {
            TableColumn viewColumn = columnModel.getColumn(i);
            int modelColumnIndex = viewColumn.getModelIndex();
            this.headerWidth[i] = this.getColumnHeaderWidth(viewColumn);
            this.cellWidth[i] = this.getColumnCellWidth(viewColumn);
            if (this.model.getColumnClass(modelColumnIndex) == String.class) {
                this.cellWidth[i] = Math.min(this.cellWidth[i], this.maxComputedCellWidth);
            }
            this.maxWidth[i] = this.cellWidth[i] > this.headerWidth[i] ? this.cellWidth[i] : this.headerWidth[i];
            int width = this.model.getColumnWidth(i);
            if (width >= 0) {
                this.maxWidth[i] = width;
            }
            this.tableWidth += this.maxWidth[i];
        }
    }

    private void setColumnWidths(int paneWidth) {
        if (this.model == null) {
            return;
        }
        this.columnsResized = true;
        TableColumnModel columnModel = this.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        if (this.tableWidth > paneWidth) {
            for (int i = 0; i < columnCount; ++i) {
                TableColumn viewColumn = columnModel.getColumn(i);
                viewColumn.setMinWidth(this.maxWidth[i]);
                viewColumn.setPreferredWidth(this.maxWidth[i]);
                if (this.model.getColumnWidth(i) < 0) continue;
                viewColumn.setMaxWidth(this.maxWidth[i]);
            }
            this.sizeColumnsToFit(0);
        } else if (this.tableWidth <= paneWidth) {
            int i;
            int resizableColumnsWidth = 0;
            int nonResizableColumnsWidth = 0;
            double factor = 1.0;
            int totalWidth = 0;
            int numResizableColumns = 0;
            int[] colIndex = new int[columnCount];
            for (i = 0; i < columnCount; ++i) {
                if (this.model.getColumnWidth(i) < 0) {
                    resizableColumnsWidth = (int)((double)resizableColumnsWidth + (double)this.maxWidth[i]);
                    colIndex[numResizableColumns] = i;
                    ++numResizableColumns;
                    continue;
                }
                nonResizableColumnsWidth = (int)((double)nonResizableColumnsWidth + (double)this.maxWidth[i]);
            }
            if (numResizableColumns > 0) {
                int newWidth;
                TableColumn viewColumn;
                factor = (double)(paneWidth - nonResizableColumnsWidth - 1) / (double)resizableColumnsWidth;
                totalWidth = nonResizableColumnsWidth;
                for (i = 0; i < numResizableColumns - 1; ++i) {
                    int index = colIndex[i];
                    viewColumn = columnModel.getColumn(index);
                    newWidth = (int)(factor * (double)this.maxWidth[index]);
                    viewColumn.setMinWidth(newWidth);
                    viewColumn.setWidth(newWidth);
                    totalWidth += newWidth;
                    this.sizeColumnsToFit(index);
                }
                int last = colIndex[numResizableColumns - 1];
                viewColumn = columnModel.getColumn(last);
                newWidth = paneWidth - 1 - totalWidth - 1;
                viewColumn.setMinWidth(newWidth);
                viewColumn.setWidth(newWidth);
                totalWidth += newWidth;
                this.sizeColumnsToFit(last);
            }
        }
        this.setAutoResizeMode(0);
    }

    private int getColumnHeaderWidth(TableColumn viewColumn) {
        int IconSize = 20;
        TableCellRenderer headerRenderer = viewColumn.getHeaderRenderer();
        Component comp = headerRenderer.getTableCellRendererComponent(this, viewColumn.getHeaderValue(), false, false, 0, 0);
        int headerWidth = comp.getPreferredSize().width;
        return headerWidth + IconSize;
    }

    private int getColumnCellWidth(TableColumn viewColumn) {
        int maxCellWidth = -1;
        int delta = 5;
        int rowCount = this.model.getRowCount();
        int modelColumnIndex = viewColumn.getModelIndex();
        TableCellRenderer cellRenderer = viewColumn.getCellRenderer();
        for (int i = 0; i < rowCount; ++i) {
            Component comp = cellRenderer.getTableCellRendererComponent(this, this.model.getValueAt(i, modelColumnIndex), false, false, i, modelColumnIndex);
            int cellW = comp.getPreferredSize().width;
            maxCellWidth = cellW > maxCellWidth ? cellW : maxCellWidth;
        }
        return maxCellWidth + delta;
    }

    private void setTableRowHeight() {
        TableColumnModel columnModel = this.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        int maxH = this.getRowHeight();
        int h = 0;
        for (int i = 0; i < columnCount; ++i) {
            TableColumn tableColumn = columnModel.getColumn(i);
            h = this.getMaxRowHeight(tableColumn);
            maxH = Math.max(maxH, h);
        }
        this.setRowHeight(maxH);
    }

    private int getMaxRowHeight(TableColumn tableColumn) {
        int c = tableColumn.getModelIndex();
        int h = 0;
        int maxH = 0;
        int rowCount = this.getRowCount();
        int incr = rowCount < 100 ? 1 : rowCount / 100;
        for (int i = 0; i < rowCount; i += incr) {
            TableCellRenderer cellRenderer = this.getCellRenderer(i, c);
            Component comp = cellRenderer.getTableCellRendererComponent(this, this.getValueAt(i, c), false, false, i, c);
            h = comp.getPreferredSize().height;
            maxH = h > maxH ? h : maxH;
        }
        return maxH;
    }

    public void addMouseListenerToTable(GTable table, JApplet app, String target) {
        AppletContext context = null;
        URL docBase = null;
        if (app != null) {
            context = app.getAppletContext();
            docBase = app.getDocumentBase();
        }
        this.listener = new GTableCellListener(table, docBase, context, target);
        table.addMouseListener(this.listener);
        table.addMouseMotionListener(this.listener);
    }

    public void removeMouseListenerToTable(GTable table) {
        if (this.listener != null) {
            table.removeMouseListener(this.listener);
            table.removeMouseMotionListener(this.listener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(this.mainMenu[1]) && !this.model.getColumnName(this.RMBColumn).equals(metaHeaderString)) {
            this.model.setHiddenColumn(this.RMBColumn);
            this.setColumnWidths(this.paneWidth);
        } else if (command.equals(this.mainMenu[2])) {
            this.model.showAllColumns();
            if (this.otherGTable != null) {
                this.model.setHiddenColumn(0);
            }
            this.setColumnWidths(this.paneWidth);
        } else if (command.equals(this.printMode[0])) {
            this.gtPanel.printPanel(0);
        } else if (command.equals(this.printMode[1])) {
            this.gtPanel.printPanel(1);
        } else {
            if (command.equals(this.helpMode[0])) {
                String title = this.GRS(this.resourceBundle, "AboutDialog.TitleText.txt", "GTable");
                String version = this.GRS(this.resourceBundle, "AboutDialog.VersionText.txt", "GTable");
                if (this.aboutFrame == null) {
                    if (this.sasIcon == null) {
                        this.sasIcon = new SASIcon((Component)this);
                    }
                    this.aboutFrame = new AboutFrame((Object)this.resourceBundle, this.sasIcon, title, version, false);
                }
                this.aboutFrame.setSize(460, 300);
                this.aboutFrame.setVisible(true);
                this.aboutFrame.toFront();
                return;
            }
            if (command.equals("Copy.Image")) {
                CopyToClipboard.toClipboard((JComponent)this.gtPanel);
            } else if (command.equals("Copy.Excel")) {
                TableSorter otherGTableSorter = null;
                GTableModel otherGTableModel = null;
                ListSelectionModel otherGTableSelectionModel = null;
                if (this.otherGTable != null) {
                    otherGTableSorter = this.otherGTable.model;
                    otherGTableModel = this.otherGTable.gtModel;
                    otherGTableSelectionModel = this.otherGTable.getSelectionModel();
                }
                String title = this.GRS(this.resourceBundle, "GTable.Copy.Excel.dialog.title.txt", "Copy as spreadsheet");
                CopyOptionsDialog.showCopyDialog((Object)new GTableAggregatedDataFilter(this.model, this.gtModel, this.getSelectionModel(), otherGTableSorter, otherGTableModel, otherGTableSelectionModel), null, (String)title);
            }
        }
        this.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int fullModelIndex = this.model.getColumnIndexInModel(this.RMBColumn);
        Object item = e.getItem();
        int eventType = e.getStateChange();
        if (item instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem cmi = (JCheckBoxMenuItem)item;
            String command = cmi.getActionCommand();
            if (eventType == 1) {
                if (command.equalsIgnoreCase(((JCheckBoxMenuItem)this.displayMenu.getItem(TableConstants.RENDERMODE_TEXT)).getActionCommand())) {
                    this.setRenderMode(this.RMBColumn, TableConstants.RENDERMODE_TEXT);
                } else if (command.equalsIgnoreCase(((JCheckBoxMenuItem)this.displayMenu.getItem(TableConstants.RENDERMODE_GRAPHICS)).getActionCommand())) {
                    this.setRenderMode(this.RMBColumn, TableConstants.RENDERMODE_GRAPHICS);
                } else if (command.equalsIgnoreCase(((JCheckBoxMenuItem)this.displayMenu.getItem(TableConstants.RENDERMODE_FUNNEL)).getActionCommand())) {
                    this.setRenderMode(this.RMBColumn, TableConstants.RENDERMODE_FUNNEL);
                } else if (command.equalsIgnoreCase(((JCheckBoxMenuItem)this.sortMenu.getItem(0)).getActionCommand())) {
                    this.gtPanel.sortColumn(fullModelIndex + this.model.getMetaColumnCount(), true);
                } else if (command.equalsIgnoreCase(((JCheckBoxMenuItem)this.sortMenu.getItem(1)).getActionCommand())) {
                    this.gtPanel.sortColumn(fullModelIndex + this.model.getMetaColumnCount(), false);
                } else if (command.equalsIgnoreCase(((JCheckBoxMenuItem)this.sortMenu.getItem(2)).getActionCommand())) {
                    this.gtPanel.sortColumn(fullModelIndex + this.model.getMetaColumnCount(), 2);
                }
                cmi.removeItemListener(this);
                this.displayMenu.selectItem(cmi);
                cmi.addItemListener(this);
            }
            if (command.equalsIgnoreCase("obsColumn")) {
                this.gtPanel.setObsNumberColumnVisible(cmi.isSelected());
            }
            this.repaint();
        }
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        Class columnClass;
        TableColumnModel columnModel = this.getColumnModel();
        int viewColumnIndex = columnModel.getColumnIndexAtX(e.getX());
        super.processMouseEvent(e);
        if (e.isPopupTrigger()) {
            this.RMBColumn = viewColumnIndex >= 0 ? this.convertColumnIndexToModel(viewColumnIndex) : -1;
        }
        if (this.obsColumn != null) {
            this.obsColumn.removeItemListener(this);
            this.obsColumn.setSelected(this.gtPanel.isObsNumberColumnVisible());
            this.obsColumn.addItemListener(this);
        }
        if ((columnClass = this.model.getColumnClass(this.RMBColumn)) == null) {
            this.RMBColumn = -1;
        }
        if (this.RMBColumn < 0 || this.model.getColumnName(this.RMBColumn).equals(metaHeaderString) || this.model.getColumnName(this.RMBColumn).equals(TableSorter.OBS_HEADER)) {
            return;
        }
        this.displayMenu.setEnabled(true);
        this.sortMenu.setEnabled(true);
        this.setupDisplayMenuItems(this.RMBColumn);
        this.setupSortMenuItems(this.RMBColumn);
        boolean number = this.isNumericClass(columnClass);
        if (number) {
            this.displayMenu.getItem(TableConstants.RENDERMODE_FUNNEL).setEnabled(true);
        } else {
            this.displayMenu.getItem(TableConstants.RENDERMODE_FUNNEL).setEnabled(false);
        }
        if (columnClass == Image.class || columnClass == ImageIcon.class) {
            this.sortMenu.setEnabled(false);
        }
        if (e.isPopupTrigger() && this.showPopMenu) {
            this.popMenu.show(this, e.getX(), e.getY());
            if (this.listener != null) {
                this.listener.isPopupEvent(true);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getSource() == this.gtModel && this.gtModel.hasDataChanged()) {
            this.revalidate();
            return;
        }
        if (this.gtModel != null && e.getSource() != this.gtModel) {
            this.gtModel.tableChanged(e);
        }
        int currentRowCount = this.getRowCount();
        super.tableChanged(e);
        this.invalidate();
        if (this.model != null) {
            int columnIndex = this.model.getSortColumnIndex();
            boolean ascending = this.model.getAscending();
            int dataOrder = this.model.getSortOrder();
            if (e.getFirstRow() == -1) {
                this.setupTableView();
            }
            if (currentRowCount != actualRowCount) {
                this.scrollRectToVisible(this.getCellRect(currentRowCount - 1, 0, true));
            }
            this.setTableRowHeight();
            if (this.resizeCalled && !this.columnsResized) {
                this.computeWidths();
                this.setColumnWidths(this.paneWidth);
            }
            if (this.otherGTable != null) {
                TableSorter sorter = this.otherGTable.getGTableModel();
                int otherColumnIndex = sorter.getSortColumnIndex();
                int otherDataOrder = sorter.getSortOrder();
                if (columnIndex != otherColumnIndex || dataOrder != otherDataOrder) {
                    sorter.sortByColumn((JTable)this.otherGTable, columnIndex, ascending, true);
                }
            }
            this.model.sortByColumn((JTable)this, columnIndex, ascending, false);
            this.model.addMouseListenerToHeaderInTable((JTable)this, this.ascendingIcon, this.descendingIcon, this.linkIcon);
        }
    }

    public String GRS(ResourceBundle rb, String name, String defStrg) {
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (rb != null) {
                s = rb.getString(name);
            }
        }
        catch (MissingResourceException e) {
            s = null;
        }
        if (s == null) {
            s = defStrg;
        }
        return s;
    }

    private void setupDisplayMenuItems(int rmbColumn) {
        int renderMode = this.getRenderMode(rmbColumn);
        JCheckBoxMenuItem cmi = renderMode == TableConstants.RENDERMODE_TEXT ? (JCheckBoxMenuItem)this.displayMenu.getItem(TableConstants.RENDERMODE_TEXT) : (renderMode == TableConstants.RENDERMODE_GRAPHICS ? (JCheckBoxMenuItem)this.displayMenu.getItem(TableConstants.RENDERMODE_GRAPHICS) : (JCheckBoxMenuItem)this.displayMenu.getItem(TableConstants.RENDERMODE_FUNNEL));
        if (cmi != null) {
            cmi.removeItemListener(this);
            cmi.setState(true);
            this.displayMenu.selectItem(cmi);
            cmi.addItemListener(this);
        }
    }

    private void setupSortMenuItems(int rmbColumn) {
        int sortCol = this.model.getSortColumnIndex();
        int sortOrder = this.model.getSortOrder();
        int fullModelIndex = this.model.getColumnIndexInModel(rmbColumn) + this.model.getMetaColumnCount();
        if (sortCol == fullModelIndex) {
            JCheckBoxMenuItem cmi;
            switch (sortOrder) {
                case 0: {
                    cmi = (JCheckBoxMenuItem)this.sortMenu.getItem(0);
                    break;
                }
                case 1: {
                    cmi = (JCheckBoxMenuItem)this.sortMenu.getItem(1);
                    break;
                }
                default: {
                    cmi = (JCheckBoxMenuItem)this.sortMenu.getItem(2);
                }
            }
            if (cmi != null) {
                cmi.removeItemListener(this);
                cmi.setState(true);
                this.sortMenu.selectItem(cmi);
                cmi.addItemListener(this);
            }
        } else {
            this.sortMenu.clearAll();
        }
    }

    @Override
    public void setTableHeader(JTableHeader tableHeader) {
        super.setTableHeader(tableHeader);
        if (this.model != null) {
            this.model.addMouseListenerToHeaderInTable((JTable)this, this.ascendingIcon, this.descendingIcon, this.linkIcon);
        }
    }

    private boolean isNumericClass(Class cellClass) {
        for (Class cc = cellClass; cc != null && cc != Object.class; cc = cc.getSuperclass()) {
            if (cc != Number.class) continue;
            return true;
        }
        return false;
    }

    public boolean setHorizontalAlignment(int modelColumnIndex, int alignment) {
        int viewColumnIndex;
        TableColumn viewColumn;
        TableCellRenderer renderer;
        TableColumnModel columnModel = this.getColumnModel();
        int columnCount = this.model.getColumnCount();
        if (modelColumnIndex >= 0 && modelColumnIndex < columnCount && (renderer = (viewColumn = columnModel.getColumn(viewColumnIndex = this.convertColumnIndexToView(modelColumnIndex))).getCellRenderer()) instanceof DefaultTableCellRenderer && !(renderer instanceof GraphicalColumnCellRenderer)) {
            ((DefaultTableCellRenderer)renderer).setHorizontalAlignment(alignment);
            this.alignments.remove(this.model.getColumnName(modelColumnIndex));
            this.alignments.put(this.model.getColumnName(modelColumnIndex), new Integer(alignment));
            return true;
        }
        return false;
    }

    public boolean setHorizontalAlignment(String colName, int alignment) {
        if (colName == null) {
            return false;
        }
        int index = this.model.getColumnIndexInVisibleModel(this.gtModel.getColumnIndex(colName));
        if (index < 0) {
            return false;
        }
        return this.setHorizontalAlignment(index, alignment);
    }

    public int getHorizontalAlignment(String colName) {
        Object o = this.alignments.get(colName);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return -1;
    }

    public String getHelpMenuActionCommand() {
        return this.helpMenuActionCommand;
    }

    String getFormattedValue(Object value, int row, int column) {
        if (!this.gtModel.isNumericVariable(this.model.getColumnIndexInModel(column)) && value == null || value instanceof String && ((String)value).trim().length() == 0) {
            return "   ";
        }
        if (this.gtModel.isNumericVariable(this.model.getColumnIndexInModel(column)) && value == null || value instanceof Number && Double.isNaN(((Number)value).doubleValue())) {
            return " . ";
        }
        boolean nRow = false;
        SASFormat format = null;
        Object o = this.gtModel.getFormat((Object)this.gtModel.getColumnName(this.model.getColumnIndexInModel(column)), SASFormat.class);
        if (o instanceof SASFormat) {
            format = (SASFormat)o;
        }
        Object v = this.getValueAt(row, 0);
        int metaRowCount = this.model.getMetaRowCount();
        int rowCount = this.getRowCount();
        if (v != null && v.toString().equalsIgnoreCase(this.model.getMetaName(5)) && metaRowCount > 0 && row >= rowCount - metaRowCount) {
            nRow = true;
        }
        if (format != null && !nRow) {
            return " " + format.format(value) + " ";
        }
        return " " + value.toString() + " ";
    }

    public void setColorRamp(Object column, ColorInterface ramp) {
        if (column == null || ramp == null) {
            return;
        }
        this.colorRamps.put(column, ramp);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setHeaderFont(Font f) {
        TableColumnModel columnModel;
        if (f == null) {
            return;
        }
        if (this.getTableHeader() != null) {
            this.getTableHeader().setFont(f);
        }
        if ((columnModel = this.getColumnModel()) == null) {
            return;
        }
        int columnCount = columnModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableCellRenderer tcr = columnModel.getColumn(i).getHeaderRenderer();
            if (tcr instanceof ColumnHeaderRenderer) {
                ((ColumnHeaderRenderer)tcr).setFont(f);
                continue;
            }
            if (!(tcr instanceof HeaderTextPaneRenderer)) continue;
            ((HeaderTextPaneRenderer)tcr).setFont(f);
        }
    }

    public void dispose() {
        if (this.model != null) {
            this.model.removeMouseListenerToHeaderInTable((JTable)this);
            this.model.removeTableModelListener((TableModelListener)this);
        }
        this.model = null;
        if (this.gtModel != null) {
            this.gtModel.removeTableModelListener((TableModelListener)this);
        }
        this.gtModel = null;
    }

    static {
        prevColumn = -1;
        prevRow = -1;
    }
}

