/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.graphtable;

import com.sas.graphics.silk.graphtable.GTable;
import com.sas.graphics.silk.graphtable.TextLabelUI;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.util.table.TableSorter;
import com.sas.graphics.silk.util.table.TableStyle;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class FormattedColumnCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 470041351292648661L;
    private static int count = 0;
    private double dMin = 0.0;
    private double dMax = 1.0;
    private int selectedRow = -1;
    private int selectedColumn = -1;
    SASFormat format = null;
    Color defaultForeColor;
    Color selectedForeColor;
    Color defaultBackColor;
    Color selectedBackColor;
    Color linkColor;
    Color visitedLinkColor;
    Font defaultFont;
    Font linkFont;
    TableSorter model;
    GTable gTable;
    boolean first = true;
    Point cell = new Point();
    public TextLabelUI textUI = new TextLabelUI();
    AttributedString as;
    Class colClass;
    String sVal = new String(" ");
    Class sClass = this.sVal.getClass();
    TableStyle style;
    ColorInterface ramp = null;
    JCheckBox box = new JCheckBox();
    JPanel panel = new JPanel();

    public FormattedColumnCellRenderer() {
        ++count;
        this.box.setHorizontalAlignment(0);
    }

    public FormattedColumnCellRenderer(Class colClass, String formatString, GTable table) {
        this();
        if (formatString.compareTo("NONE") != 0) {
            this.format = SASFormat.getInstance((String)formatString);
        }
        this.gTable = table;
        this.model = this.gTable.getGTableModel();
        this.colClass = colClass;
        if (this.colClass != this.sClass) {
            this.setHorizontalAlignment(4);
        }
        this.style = this.gTable.getStyle();
        this.defaultForeColor = this.gTable.getForeground();
        this.defaultBackColor = this.gTable.getBackground();
        this.selectedForeColor = new Color(0, 0, 196);
        this.selectedBackColor = new Color(224, 224, 128);
        this.linkColor = new Color(0, 0, 176);
        this.setBorder(UIManager.getBorder("TableCell.cellBorder"));
        this.setUI(this.textUI);
        this.defaultFont = table.getFont();
        Hashtable<TextAttribute, Float> map = new Hashtable<TextAttribute, Float>();
        map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        this.linkFont = this.defaultFont.deriveFont(map);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Object max;
        int modelColumnIndex = table.convertColumnIndexToModel(column);
        Object min = this.gTable.getGTableModel().getColumnMinValue(modelColumnIndex);
        if (min instanceof Number) {
            this.dMin = ((Number)min).doubleValue();
        }
        if ((max = this.gTable.getGTableModel().getColumnMaxValue(modelColumnIndex)) instanceof Number) {
            this.dMax = ((Number)max).doubleValue();
        }
        if (this.dMax == this.dMin) {
            this.dMin = this.dMax - 1.0;
        }
        String link = this.model.getLink(row, modelColumnIndex);
        boolean noValue = false;
        if (value == null) {
            this.setText(" . ");
        } else if (value instanceof String && ((String)value).trim().length() == 0) {
            this.setText("   ");
            noValue = true;
        } else if (value instanceof Number && Double.isNaN(((Number)value).doubleValue())) {
            this.setText(" . ");
        } else {
            boolean nRow = false;
            Object v = this.gTable.getValueAt(row, 0);
            int metaRowCount = this.gTable.getGTableModel().getMetaRowCount();
            int rowCount = this.gTable.getRowCount();
            if (v != null && v.toString().equalsIgnoreCase("N") && metaRowCount > 0 && row >= rowCount - metaRowCount) {
                nRow = true;
            }
            if (this.format != null && !nRow) {
                String str = this.format.format(value);
                String str1 = new String(" " + str + " ");
                this.setText(str1);
            } else {
                String str = value.toString();
                String str1 = new String(" " + str + " ");
                this.setText(str1);
            }
        }
        if (link != null && !noValue) {
            this.setFont(this.linkFont);
        } else {
            this.setFont(this.defaultFont);
        }
        this.cell = this.gTable.getSelectedCell(this.cell);
        this.selectedColumn = this.cell.x;
        this.selectedRow = this.cell.y;
        if (table.isCellSelected(row, column)) {
            this.setBackground(this.style.selectedBackColor);
            this.setForeground(this.style.selectedForeColor);
        } else {
            Color rampColor = null;
            if (this.ramp != null && value instanceof Number) {
                rampColor = this.ramp.queryDouble(((Number)value).doubleValue(), this.dMin, this.dMax, false, null);
                this.setBackground(rampColor);
            } else {
                Color bg = this.gTable.getCellItemColor(row, column, 0);
                this.setBackground(bg);
            }
            if (this.ramp != null && value instanceof Number) {
                float[] vals = new float[4];
                float luminance = 0.299f * (vals = rampColor.getComponents(vals))[0] + 0.587f * vals[1] + 0.114f * vals[2];
                if (luminance > 0.5686f) {
                    this.setForeground(Color.black);
                } else {
                    this.setForeground(Color.white);
                }
            } else if (row >= this.model.getRowCount() - this.model.getMetaRowCount()) {
                this.setForeground(this.style.metaDataColor);
            } else if (link != null) {
                this.setForeground(this.style.linkColor);
            } else {
                this.setForeground(this.style.cellForeColor);
            }
        }
        if (row == this.selectedRow && column == this.selectedColumn && link != null) {
            this.setForeground(this.style.visitedLinkColor);
        }
        if (this.colClass == Boolean.class) {
            this.box.setSelected((Boolean)value);
            return this.box;
        }
        if (this.colClass == Color.class) {
            this.panel.setBackground((Color)value);
            return this.panel;
        }
        return this;
    }

    public void setSelectedCell(int row, int column) {
        this.selectedRow = row;
        this.selectedColumn = column;
    }

    public void setRamp(ColorInterface rampIn) {
        this.ramp = rampIn;
    }

    public ColorInterface getRamp() {
        return this.ramp;
    }

    @Override
    public void setForeground(Color c) {
        if (this.box != null) {
            this.box.setForeground(c);
        }
        super.setForeground(c);
    }

    @Override
    public void setBackground(Color c) {
        if (this.box != null) {
            this.box.setBackground(c);
        }
        super.setBackground(c);
    }
}

