/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dtree;

import com.sas.graphics.silk.dtree.DTreeNode;
import com.sas.graphics.silk.dtree.NodeRenderer;
import com.sas.graphics.silk.dtree.TreeCanvas;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.Text;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;

public class TextNodeRenderer
implements NodeRenderer {
    public TreeCanvas tree;
    public static int columnSpacing = 10;
    public static int rowSpacing = 5;
    private int minFontSize = 6;
    private static GlobalDefaults defaults = new GlobalDefaults();

    public TextNodeRenderer(TreeCanvas c) {
        this.tree = c;
    }

    private void drawBackground(Graphics2D g, boolean flagged, Rectangle bounds, double nodeSize) {
        if (flagged) {
            GraphBackground b = this.tree.flaggedNodeBackground;
            b.drawBackground(g, (Component)this.tree, bounds);
        } else if (!this.tree.useNodeColorRamp || Double.isNaN(nodeSize)) {
            GraphBackground b = this.tree.nodeBackground;
            b.drawBackground(g, (Component)this.tree, bounds);
        } else if (this.tree.nodeColorRamp != null) {
            ColorInterface ramp = this.tree.nodeColorRamp;
            if (this.tree.minNodeSize == this.tree.maxNodeSize) {
                Color[] clrs = ramp.getColors();
                g.setColor(clrs[clrs.length - 1]);
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            } else {
                Color c = ramp.queryDouble(nodeSize, this.tree.minNodeSize, this.tree.maxNodeSize, false, null);
                g.setColor(c);
                g.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, 5, 5);
            }
        }
    }

    public void drawText(Graphics2D g, Object nodeText, boolean isFlagged, double nodeSize, Rectangle bounds) {
        int i;
        String[][] text;
        AffineTransform defaultXfm = g.getTransform();
        AffineTransform xfm = new AffineTransform(defaultXfm);
        xfm.translate(0.0, g.getClipBounds().y);
        xfm.scale(this.tree.xScale, this.tree.yScale);
        g.setTransform(xfm);
        if (nodeText == null) {
            return;
        }
        if (nodeText instanceof String[][]) {
            text = (String[][])nodeText;
        } else {
            text = new String[1][1];
            text[0][0] = nodeText.toString();
        }
        Text txt = this.tree.getNodeText(isFlagged);
        if (!txt.isVisible()) {
            return;
        }
        Font oldFnt = txt.getFont();
        Point p = new Point();
        float[] vals = new float[4];
        Color bk = this.tree.nodeColorRamp.queryDouble(nodeSize, false, null);
        vals = bk.getComponents(vals);
        float luminance = 0.299f * vals[0] + 0.587f * vals[1] + 0.114f * vals[2];
        if (luminance > 0.5686f) {
            txt.setColor((Object)Color.black);
        } else {
            txt.setColor((Object)Color.white);
        }
        FontRenderContext frc = g.getFontRenderContext();
        int textHeight = (int)txt.getStringBounds("T", frc).getHeight();
        p = bounds.getLocation();
        int xPos = p.x + columnSpacing;
        int n = i = this.tree.showNodeLabels ? 0 : 1;
        while (i < text.length) {
            int yPos = p.y + rowSpacing;
            xPos += TextNodeRenderer.getMaxStringWidth(text[i], txt, g, frc);
            for (int j = 0; j < text[i].length; ++j) {
                if (text[i][j] != null && text[i][j].length() > 0) {
                    txt.drawText(g, text[i][j], new Point(xPos - (int)txt.getStringBounds(text[i][j], frc).getWidth(), yPos));
                }
                yPos += textHeight + rowSpacing;
            }
            xPos += columnSpacing;
            ++i;
        }
        txt.setFont((Object)oldFnt);
        g.setTransform(defaultXfm);
    }

    protected static int getMaxStringWidth(String[] strs, Text style, Graphics2D g, FontRenderContext frc) {
        int rc = 0;
        for (int i = 0; i < strs.length; ++i) {
            int width = (int)style.getStringBounds(strs[i], frc).getWidth();
            if (rc >= width) continue;
            rc = width;
        }
        return rc;
    }

    public Dimension getSize(Graphics2D g, Text text, String[][] parsedText, boolean flagged, boolean empty, boolean showNodeLabels) {
        int i;
        if (empty || parsedText == null) {
            return new Dimension(50, 50);
        }
        Dimension d = new Dimension(4 * columnSpacing, 2 * rowSpacing);
        String[][] columns = parsedText;
        FontRenderContext frc = g == null ? new FontRenderContext(null, false, false) : g.getFontRenderContext();
        int textHeight = (int)text.getStringBounds("T", frc).getHeight();
        d.height = textHeight * columns[0].length + rowSpacing * (2 + columns[0].length);
        int n = i = showNodeLabels ? 0 : 1;
        while (i < columns.length) {
            d.width += TextNodeRenderer.getMaxStringWidth(columns[i], text, g, frc);
            ++i;
        }
        return d;
    }

    @Override
    public Dimension getSize(Object nodeText, Object node, Graphics2D graphics, boolean isEmpty, boolean isFlagged) {
        if (nodeText != null && !(nodeText instanceof String[][])) {
            nodeText = DTreeNode.parseText(nodeText.toString());
        }
        return this.getSize(graphics, this.tree.getNodeText(isFlagged), nodeText, isFlagged, isEmpty, this.tree.showNodeLabels);
    }

    @Override
    public void drawNode(Object nodeText, Object data, Object node, Graphics2D graphics, boolean isFlagged, double nodeSize, Rectangle b) {
        if (this.tree.isFitToPageMode()) {
            this.tree.emptyNodes = this.tree.xScale < 0.05 || this.tree.yScale < 0.05;
        }
        this.drawBackground(graphics, isFlagged, b, nodeSize);
        if (!this.tree.emptyNodes) {
            this.drawText(graphics, nodeText, isFlagged, nodeSize, b);
        }
    }
}

