/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dtree;

import com.sas.graphics.silk.dtree.AbstractDTreeNode;
import com.sas.graphics.silk.dtree.CollapseButton;
import com.sas.graphics.silk.dtree.Contour;
import com.sas.graphics.silk.dtree.DTreeNode;
import com.sas.graphics.silk.dtree.TreeLink;
import java.awt.Graphics;
import java.awt.Rectangle;

public class PrintableNode
extends AbstractDTreeNode {
    boolean isPrintable;
    boolean isVisited;
    private DTreeNode visualNode;
    private PrintableNode parent;
    private PrintableNode child;
    private PrintableNode sibling;
    private PrintableNode leftSibling;
    private int level;
    private Object id;
    private Rectangle bounds;
    private Rectangle printBounds;

    public PrintableNode(DTreeNode n) {
        this.visualNode = n;
        this.isPrintable = true;
        this.isVisited = false;
        this.bounds = this.visualNode.getBounds();
        this.printBounds = new Rectangle();
        this.id = this.visualNode.getID();
    }

    @Override
    public boolean isPrintingNode() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrintableNode) {
            PrintableNode n = (PrintableNode)obj;
            if (this.id.equals(n.id)) {
                return true;
            }
        }
        return false;
    }

    public DTreeNode getDTreeNode() {
        return this.visualNode;
    }

    public boolean isPrintable() {
        return this.isPrintable;
    }

    public void setPrintable(boolean isPrintable) {
        this.isPrintable = isPrintable;
    }

    @Override
    public Object getID() {
        return this.visualNode.getID();
    }

    public boolean isVisited() {
        return this.isVisited;
    }

    @Override
    public PrintableNode getParent() {
        return this.parent;
    }

    @Override
    public PrintableNode getChild() {
        return this.child;
    }

    public PrintableNode getPrintableChild() {
        for (PrintableNode n = this.child; n != null; n = n.getSibling()) {
            if (!n.isVisited || !n.isPrintable) continue;
            return n;
        }
        return null;
    }

    public PrintableNode getPrintableSibling() {
        for (PrintableNode n = this.sibling; n != null; n = n.getSibling()) {
            if (!n.isVisited || !n.isPrintable) continue;
            return n;
        }
        return null;
    }

    @Override
    public PrintableNode getSibling() {
        return this.sibling;
    }

    public PrintableNode getLeftSibling() {
        return this.leftSibling;
    }

    public void setVisited(boolean isVisited) {
        this.isVisited = isVisited;
    }

    public void setParent(PrintableNode parent) {
        this.parent = parent;
    }

    public void setChild(PrintableNode c) {
        if (c == null) {
            return;
        }
        c.setParent(this);
        if (this.child != null) {
            this.child.setSibling(c);
        } else {
            this.child = c;
        }
    }

    public void setSibling(PrintableNode s) {
        if (this.sibling != null) {
            this.sibling.setSibling(s);
        } else {
            this.sibling = s;
            s.setLeftSibling(this);
        }
    }

    public void setLeftSibling(PrintableNode s) {
        this.leftSibling = s;
    }

    @Override
    public Contour getContour() {
        return this.visualNode.getContour();
    }

    @Override
    public int getBorderWidth() {
        return this.visualNode.getBorderWidth();
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Rectangle r) {
        this.bounds = r;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.visualNode.paintComponent(g);
    }

    public Rectangle getPrintBounds() {
        return this.printBounds;
    }

    public void setPrintBounds(Rectangle printBounds) {
        this.printBounds = printBounds;
    }

    public void setDTreeNode(DTreeNode visualNode) {
        this.visualNode = visualNode;
    }

    @Override
    public TreeLink getLink() {
        return this.visualNode.getLink();
    }

    @Override
    public CollapseButton getCollapse() {
        return this.visualNode.getCollapse();
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

