/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dtree;

import com.sas.graphics.silk.dtree.TreeCanvas;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PrintPreview
extends JDialog {
    private static final int padding = 8;
    private final Color bgColor = new Color(178, 178, 178);
    private final Color mlColor = new Color(0, 0, 255);
    public PageFormat mFormat;
    public DisplayOptionDialog displayOptionDialog;
    public PrinterJob pj;
    private static final int disableAlpha = 180;
    private int pageNumber;
    private int minPage;
    private int maxPage;
    private boolean showMarginLines;
    private JScrollPane previewPane;
    private PageNavigationPanel pageNavigationPanel;
    private SinglePagePreview spp;
    private int tNumPages;
    private TreeCanvas canvas;
    private JButton printButton;
    private JButton printSetupButton;
    private JButton displayOptionButton;
    private JButton marginButton;
    private JButton closeButton;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.dtree.silk_dtree_NLS");

    public PrintPreview(Dialog owner, PageFormat pf, TreeCanvas canvas) {
        super(owner, "PrintPreview", true);
        this.canvas = canvas;
        this.mFormat = new PageFormat();
        this.mFormat.setOrientation(pf.getOrientation());
        this.mFormat.setPaper(pf.getPaper());
        Point location = owner.getLocation();
        this.setLocation(location.x + 100, location.y + 30);
        this.init();
    }

    public PrintPreview(Frame owner, PageFormat pf, TreeCanvas canvas) {
        super(owner, "PrintPreview", true);
        this.canvas = canvas;
        this.mFormat = new PageFormat();
        this.mFormat.setOrientation(pf.getOrientation());
        this.mFormat.setPaper(pf.getPaper());
        Point location = owner.getLocation();
        this.setLocation(location.x + 100, location.y + 30);
        this.init();
    }

    private void init() {
        this.setPreviewDialogSize();
        this.refreshPageNumbers();
        this.pj = PrinterJob.getPrinterJob();
        this.showMarginLines = true;
        this.previewPane = new JScrollPane();
        this.previewPane.getViewport().setBackground(this.bgColor);
        this.previewPane.setBackground(this.bgColor);
        this.previewPane.setHorizontalScrollBarPolicy(30);
        this.previewPane.setVerticalScrollBarPolicy(20);
        this.getContentPane().add((Component)this.makeButtonPanel(), "North");
        this.getContentPane().add((Component)this.previewPane, "Center");
        this.refresh();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PrintPreview.this.close();
            }
        });
    }

    private void setPreviewDialogSize() {
        int w = (int)(this.mFormat.getWidth() + 32.0);
        int h = (int)(this.mFormat.getHeight() + (double)this.makeButtonPanel().getPreferredSize().height + 48.0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        w = w > screenSize.width ? screenSize.width : w;
        h = h > screenSize.height ? screenSize.height : h;
        w = w < 750 ? 650 : w;
        h = h < 350 ? 250 : h;
        this.setSize(w, h);
    }

    public PageFormat getPageFormat() {
        return this.mFormat;
    }

    public boolean isPageFormatChanged(PageFormat pf) {
        if (this.mFormat.getOrientation() != pf.getOrientation()) {
            this.mFormat.setOrientation(pf.getOrientation());
            return true;
        }
        if ((int)this.mFormat.getWidth() != (int)pf.getWidth() || this.mFormat.getHeight() != pf.getHeight()) {
            return true;
        }
        Paper paper = pf.getPaper();
        Paper mPaper = this.mFormat.getPaper();
        return (int)mPaper.getImageableX() != (int)paper.getImageableX() || (int)mPaper.getImageableY() != (int)paper.getImageableY() || (int)mPaper.getImageableWidth() != (int)paper.getImageableWidth() || (int)mPaper.getImageableHeight() != (int)paper.getImageableHeight();
    }

    private void refreshPageNumbers() {
        if (this.canvas.previewImages.keySet().size() > 0) {
            this.pageNumber = 1;
            this.minPage = 1;
            this.maxPage = this.tNumPages = this.canvas.printablePages.size();
        } else {
            this.pageNumber = 0;
            this.maxPage = 0;
            this.minPage = 0;
            this.tNumPages = 0;
        }
    }

    public void setPageNumber(int pn) {
        if (pn >= 0) {
            this.pageNumber = pn;
        }
        this.checkPage();
    }

    private JPanel makeButtonPanel() {
        this.printButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"PrintPreview.Print.txt", (String)"Print..."));
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.print();
            }
        });
        this.printSetupButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"PrintPreview.Setup.txt", (String)"Setup..."));
        this.printSetupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.printSetup();
            }
        });
        this.displayOptionButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"PrintPreview.Display_Options.txt", (String)"Display Options..."));
        this.displayOptionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.displaySetup();
            }
        });
        this.marginButton = new IconButton(PrintPreview.makeImageIcon("PrintPreview_MarginsToggle.gif"), "ToggleMarginLines", 3);
        this.marginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.toggleMarginLines();
            }
        });
        this.closeButton = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"PrintPreview.Close.txt", (String)"Close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.close();
            }
        });
        this.pageNavigationPanel = new PageNavigationPanel();
        JPanel controlPane = new JPanel();
        controlPane.setLayout(new FlowLayout());
        controlPane.add(this.printButton);
        controlPane.add(new VerticalSeparator());
        controlPane.add(this.printSetupButton);
        controlPane.add(new VerticalSeparator());
        controlPane.add(this.displayOptionButton);
        controlPane.add(new VerticalSeparator());
        controlPane.add(this.pageNavigationPanel);
        controlPane.add(new VerticalSeparator());
        controlPane.add(this.marginButton);
        controlPane.add(new VerticalSeparator());
        controlPane.add(this.closeButton);
        controlPane.setMinimumSize(controlPane.getPreferredSize());
        return controlPane;
    }

    public void print() {
        this.pj.setPageable(this.canvas);
        if (this.pj.printDialog()) {
            try {
                PageFormat p = this.pj.defaultPage();
                if (this.isPageFormatChanged(p)) {
                    this.mFormat = p;
                    this.canvas.createBookPages(this.mFormat);
                }
                this.pj.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }

    public void printSetup() {
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        PageFormat pf = this.pj.pageDialog(this.mFormat);
        if (this.isPageFormatChanged(pf)) {
            this.mFormat = pf;
            this.canvas.printPreview(this.mFormat, false);
        }
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
        this.getGlassPane().setVisible(true);
    }

    public void displaySetup() {
        this.displayOptionDialog(this);
    }

    public void nextPage() {
        ++this.pageNumber;
        this.checkPage();
    }

    public void prevPage() {
        --this.pageNumber;
        this.checkPage();
    }

    public void next10Page() {
        this.pageNumber += 10;
        this.checkPage();
    }

    public void prev10Page() {
        this.pageNumber -= 10;
        this.checkPage();
    }

    public void firstPage() {
        this.pageNumber = this.minPage;
        this.checkPage();
    }

    public void lastPage() {
        this.pageNumber = this.maxPage;
        this.checkPage();
    }

    private void checkPage() {
        if (this.pageNumber <= this.minPage) {
            this.pageNumber = this.minPage;
        }
        if (this.pageNumber >= this.maxPage) {
            this.pageNumber = this.maxPage;
        }
        this.pageNavigationPanel.refresh();
        this.refreshPreviewPane();
    }

    public void toggleMarginLines() {
        this.showMarginLines = !this.showMarginLines;
        this.repaint();
    }

    public void close() {
        this.canvas.previewDialog = null;
        this.displayOptionDialog = null;
        this.resetDisplayOptions();
        this.flush();
        this.dispose();
    }

    private void resetDisplayOptions() {
        this.canvas.pageOrder = 0;
        this.canvas.setPrintHeader(false);
        this.canvas.setPrintFooter(false);
    }

    public void refresh() {
        this.flush();
        this.refreshPageNumbers();
        this.checkPage();
        this.pageNavigationPanel.refresh();
    }

    public void applyChanges() {
        this.canvas.printPreview(this.mFormat, false);
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
        this.getGlassPane().setVisible(true);
    }

    private void refreshPreviewPane() {
        int y;
        int x;
        Cursor oldCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        JViewport viewport = this.previewPane.getViewport();
        if (this.spp == null) {
            this.spp = new SinglePagePreview(-1);
        }
        this.previewPane.setViewportView(this.spp);
        Point newPosition = this.spp.getScrollPosition();
        if (newPosition == null) {
            newPosition = new Point(0, 0);
        }
        if ((x = newPosition.x - 1) < 0) {
            x = 1;
        }
        if ((y = newPosition.y - 1) < 0) {
            y = 1;
        }
        viewport.setViewPosition(new Point(x, y));
        viewport.setViewPosition(newPosition);
        this.setCursor(oldCursor);
    }

    public void flush() {
        if (this.spp != null) {
            this.spp.flush();
        }
        this.spp = null;
    }

    public void displayOptionDialog(Dialog owner) {
        this._DisplayOptionDialog(owner);
    }

    public void displayOptionDialog(Frame owner) {
        this._DisplayOptionDialog(owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _DisplayOptionDialog(Window owner) {
        PrintPreview printPreview = this;
        synchronized (printPreview) {
            if (this.displayOptionDialog != null && this.displayOptionDialog.isShowing()) {
                return;
            }
            this.displayOptionDialog = owner instanceof Dialog ? new DisplayOptionDialog((Dialog)owner) : new DisplayOptionDialog((Frame)owner);
        }
        this.displayOptionDialog.pack();
        this.displayOptionDialog.setLocationRelativeTo(owner);
        this.displayOptionDialog.setVisible(true);
        this.displayOptionDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Window w;
                if (PrintPreview.this.displayOptionDialog != null && (w = PrintPreview.this.displayOptionDialog.getOwner()) instanceof PrintPreview) {
                    ((PrintPreview)w).refresh();
                }
                PrintPreview.this.displayOptionDialog = null;
            }
        });
    }

    public Insets getMargins() {
        DoubleInsets ii = this.getMargins(null);
        return new Insets((int)(ii.top + 0.5), (int)(ii.left + 0.5), (int)(ii.bottom + 0.5), (int)(ii.right + 0.5));
    }

    private DoubleInsets getMargins(DoubleInsets ii) {
        PageFormat f = this.getPageFormat();
        double pw = f.getWidth();
        double ph = f.getHeight();
        double ix = f.getImageableX();
        double iy = f.getImageableY();
        double iw = f.getImageableWidth();
        double ih = f.getImageableHeight();
        double left = ix;
        double top = iy;
        double right = pw - (ix + iw);
        double bottom = ph - (iy + ih);
        if (ii != null) {
            ii.reset(top, left, bottom, right);
        } else {
            ii = new DoubleInsets(top, left, bottom, right);
        }
        return ii;
    }

    private static ImageIcon makeImageIcon(String name) {
        String iconPath = "com/sas/graphics/util/";
        URL url = TreeCanvas.class.getClassLoader().getResource("com/sas/graphics/util/" + name);
        return new ImageIcon(url);
    }

    private static final String intToString(int i) {
        return "" + i;
    }

    private class DoubleInsets {
        public double top;
        public double left;
        public double bottom;
        public double right;

        public DoubleInsets(double top, double left, double bottom, double right) {
            this.reset(top, left, bottom, right);
        }

        public void reset(double top, double left, double bottom, double right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }
    }

    class VerticalSeparator
    extends JComponent {
        private Dimension prefSize = new Dimension(10, 25);
        private Color lineColor = Color.gray.brighter();

        public VerticalSeparator() {
            this.setOpaque(false);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.prefSize;
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            int x = w / 2;
            int y0 = h / 10;
            int y1 = 9 * h / 10;
            g.setColor(this.lineColor);
            g.drawLine(x, y0, x, y1);
        }
    }

    private class HorizontalSeparator
    extends JComponent {
        private final Dimension prefSize;

        public HorizontalSeparator() {
            this.setOpaque(false);
            int h = new JLabel((String)"W").getPreferredSize().height;
            this.prefSize = new Dimension(1, h);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.prefSize;
        }

        @Override
        public void paint(Graphics g) {
            Dimension size = this.getSize();
            int width = size.width;
            int height = size.height;
            int midY = height / 2;
            Color bgColor = this.getBackground();
            g.setColor(bgColor.brighter());
            g.drawLine(0, midY + 1, width - 1, midY + 1);
            g.setColor(bgColor.darker());
            g.drawLine(1, midY, width, midY);
        }
    }

    class IconButton
    extends JButton {
        Dimension mySize;
        int rounding;

        public IconButton(Icon ii, String toolTip, int cornerRadius) {
            super(ii);
            this.setOpaque(false);
            this.setSizeFromIcon(ii);
            int n = this.rounding = cornerRadius >= 0 ? cornerRadius : ii.getIconWidth();
            if (toolTip != null) {
                this.setToolTipText(toolTip);
            }
        }

        private void setSizeFromIcon(Icon ii) {
            int w = ii.getIconWidth();
            int h = ii.getIconHeight();
            this.mySize = new Dimension(w, h);
            this.setSize(w, h);
            this.setMinimumSize(this.mySize);
            this.setMaximumSize(this.mySize);
            this.setPreferredSize(this.mySize);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (!this.isEnabled()) {
                Color bg = this.getBackground();
                Color dmColor = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 180);
                g.setColor(dmColor);
                int w = this.getWidth();
                int h = this.getHeight();
                g.fillRoundRect(0, 0, w, h, this.rounding, this.rounding);
            }
        }
    }

    private class SinglePagePreview
    extends JPanel {
        private final int shadowDepth = 5;
        private final int pageBorderThickness = 1;
        private final Color shadowColor = new Color(128, 128, 128);
        private final Color pageBorderColor = Color.black;
        private Dimension mySize;
        private BufferedImage pageImage;
        private Point scrollPosition;

        public SinglePagePreview(int pageno) {
            this.setBackground(PrintPreview.this.bgColor);
            this.setOpaque(false);
            this._setSize();
        }

        public void _setSize() {
            PageFormat f = PrintPreview.this.getPageFormat();
            int fw = (int)f.getWidth();
            int fh = (int)f.getHeight();
            if (this.mySize == null) {
                this.mySize = new Dimension(0, 0);
            }
            this.mySize.setSize(fw + 5 + 2, fh + 5 + 2);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.mySize;
        }

        public Point getScrollPosition() {
            return this.scrollPosition;
        }

        public void setScrollPosition(Point p) {
            this.scrollPosition = p;
        }

        public int getPageNumber() {
            return PrintPreview.this.pageNumber;
        }

        public void flush() {
            if (this.pageImage != null) {
                this.pageImage.flush();
            }
            this.pageImage = null;
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
            if (w < 10 || h < 10) {
                return;
            }
            if (((PrintPreview)PrintPreview.this).canvas.previewImages.keySet().size() > 0) {
                PageFormat f = PrintPreview.this.getPageFormat();
                int fw = (int)f.getWidth();
                int fh = (int)f.getHeight();
                Insets fm = PrintPreview.this.getMargins();
                int fx0 = 0;
                int fx1 = fm.left;
                int fx2 = fw - fm.right;
                int fx3 = fw;
                int fy0 = 0;
                int fy1 = fm.top;
                int fy2 = fh - fm.bottom;
                int fy3 = fh;
                int px0 = 9;
                int py0 = 9;
                int px1 = px0 + fx1;
                int py1 = py0 + fy1;
                int px2 = px0 + fx2;
                int py2 = py0 + fy2;
                int px3 = px0 + fx3;
                int py3 = py0 + fy3;
                int pw = px3 - px0;
                int ph = py3 - py0;
                int pn = this.getPageNumber();
                this.pageImage = ((PrintPreview)PrintPreview.this).canvas.previewImages.get(pn);
                g.translate(px0, py0);
                ((Graphics2D)g).drawRenderedImage(this.pageImage, new AffineTransform());
                g.translate(-px0, -py0);
                int t = 1;
                g.setColor(this.shadowColor);
                g.fillRect(px3 + t, py0 - t + 5, 5, ph + t + t);
                g.fillRect(px0 - t + 5, py3 + t, pw + t + t, 5);
                g.setColor(this.pageBorderColor);
                for (int i = 1; i <= t; ++i) {
                    g.drawRect(px0 - i, py0 - i, pw + i + i, ph + i + i);
                }
                if (PrintPreview.this.showMarginLines && (fx0 < fx1 || fx2 < fx2 || fy0 < fy1 || fy2 < fy3)) {
                    g.setColor(PrintPreview.this.mlColor);
                    g.drawLine(px0, py1 - 1, px3, py1 - 1);
                    g.drawLine(px0, py2 + 1, px3, py2 + 1);
                    g.drawLine(px1 - 1, py0, px1 - 1, py3);
                    g.drawLine(px2 + 1, py0, px2 + 1, py3);
                }
            } else {
                Graphics2D g2 = (Graphics2D)g;
                Image icon = ResourceLoader.getImage((Component)this, (String)"/icons/MessageError_16.gif");
                g2.drawImage(icon, 10, 10, this);
                g2.setColor(Color.BLACK);
                g2.setFont(g2.getFont().deriveFont(1));
                g2.drawString(ResourceLoader.getResourceString((Object)PrintPreview.this.rb, (String)"PrintPreview.Big_Node.txt", (String)"The Current node size is too big to fit in to available page size."), 30, 15);
                g2.drawString(ResourceLoader.getResourceString((Object)PrintPreview.this.rb, (String)"PrintPreview.Reduce_Node.txt", (String)"Either reduce the Node size or change the page setup."), 30, 35);
            }
        }
    }

    private class DisplayOptionDialog
    extends JDialog
    implements ActionListener {
        JTextField depthTextField;
        JLabel treeDepthLabel;
        JRadioButton mDownThenOver;
        JRadioButton mOverThenDown;
        JCheckBox showHeader;
        JCheckBox showFooter;
        JButton mOk;
        JButton mCancel;
        ImageIcon dtoIcon;
        ImageIcon otdIcon;
        JLabel pageOrderLabel;
        ResourceBundle rb;

        public DisplayOptionDialog(Dialog owner) {
            super(owner, "Display Setup");
            this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.dtree.silk_dtree_NLS");
            this.setLocationRelativeTo(owner);
            this.setResizable(false);
            this.getContentPane().add((Component)this.makeDisplayOptionPanel(), "Center");
        }

        public DisplayOptionDialog(Frame owner) {
            super(owner, "Display Setup");
            this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.dtree.silk_dtree_NLS");
            this.setLocationRelativeTo(owner);
            this.setResizable(false);
            this.getContentPane().add((Component)this.makeDisplayOptionPanel(), "Center");
        }

        private JPanel makeDisplayOptionPanel() {
            this.setModal(true);
            this.treeDepthLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"PrintPreview.Display.TreeDepth.txt", (String)"Specify Tree Depth for Printing"));
            this.depthTextField = new JTextField(4);
            this.depthTextField.setText(PrintPreview.intToString(((PrintPreview)PrintPreview.this).canvas.maxTreeDepth));
            this.treeDepthLabel.setLabelFor(this.depthTextField);
            this.depthTextField.addActionListener(this);
            this.otdIcon = new ImageIcon(ResourceLoader.getImage((Component)this, (String)"/icons/PageOrderLeftRightTopBottom.gif"));
            this.dtoIcon = new ImageIcon(ResourceLoader.getImage((Component)this, (String)"/icons/PageOrderTopBottomLeftRight.gif"));
            this.mDownThenOver = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"PrintPreview.Display.PageOrder.DownThanOver.txt", (String)"Top-Bottom, Left-Right"));
            this.mOverThenDown = new JRadioButton(ResourceLoader.getResourceString((Object)this.rb, (String)"PrintPreview.Display.PageOrder.OverThanDown.txt", (String)"Left-Right, Top-Bottom"));
            this.mOverThenDown.setSelected(true);
            ButtonGroup group = new ButtonGroup();
            group.add(this.mDownThenOver);
            group.add(this.mOverThenDown);
            this.mDownThenOver.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DisplayOptionDialog.this.mDownThenOver.isSelected()) {
                        DisplayOptionDialog.this.pageOrderLabel.setIcon(DisplayOptionDialog.this.dtoIcon);
                    }
                }
            });
            this.mOverThenDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DisplayOptionDialog.this.mOverThenDown.isSelected()) {
                        DisplayOptionDialog.this.pageOrderLabel.setIcon(DisplayOptionDialog.this.otdIcon);
                    }
                }
            });
            this.showHeader = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"PrintPreview.Display.ShowHeader.txt", (String)"Show Header on each page"));
            this.showFooter = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"PrintPreview.Display.ShowFooter.txt", (String)"Show Footer on each page"));
            this.showHeader.setEnabled(PrintPreview.this.canvas.isHeaderOn());
            this.showFooter.setEnabled(PrintPreview.this.canvas.isFooterOn());
            this.mOk = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"PrintPreview.Display.OK.txt", (String)"OK"));
            this.mOk.addActionListener(this);
            this.mCancel = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"PrintPreview.Display.Cancel.txt", (String)"Cancel"));
            this.mCancel.addActionListener(this);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            JPanel displayOptionPanel = new JPanel();
            displayOptionPanel.setLayout(new BorderLayout());
            displayOptionPanel.add((Component)this.showHeader, "North");
            displayOptionPanel.add((Component)this.showFooter, "South");
            JPanel pageOrderPanel = new JPanel();
            pageOrderPanel.setLayout(new BoxLayout(pageOrderPanel, 1));
            pageOrderPanel.setBorder(new TitledBorder(ResourceLoader.getResourceString((Object)this.rb, (String)"PrintPreview.Display.Page_Order.txt", (String)"Page Order")));
            pageOrderPanel.add(this.mOverThenDown);
            pageOrderPanel.add(this.mDownThenOver);
            JPanel iconPanel = new JPanel(new BorderLayout());
            this.pageOrderLabel = new JLabel();
            this.pageOrderLabel.setIcon(this.otdIcon);
            iconPanel.add(this.pageOrderLabel);
            JPanel p = new JPanel(new GridLayout(1, 2));
            p.add((Component)pageOrderPanel, 0);
            p.add((Component)this.pageOrderLabel, 1);
            JPanel treePanel = new JPanel(new FlowLayout(0));
            treePanel.add(this.treeDepthLabel);
            treePanel.add(this.depthTextField);
            panel.add(displayOptionPanel);
            panel.add(new HorizontalSeparator());
            panel.add(p);
            panel.add(new HorizontalSeparator());
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)panel, "Center");
            panel2.add((Component)treePanel, "South");
            panel2.setBorder(new EtchedBorder(1));
            JPanel buttonPanel = new JPanel(new FlowLayout(2));
            buttonPanel.add(this.mOk);
            buttonPanel.add(this.mCancel);
            JPanel mainPanel = new JPanel(new BorderLayout());
            mainPanel.add((Component)panel2, "Center");
            mainPanel.add((Component)buttonPanel, "South");
            this.readModel();
            return mainPanel;
        }

        private void writeModel() {
            String s = this.depthTextField.getText();
            if (((PrintPreview)PrintPreview.this).canvas.userTreeDepth != Integer.parseInt(s)) {
                ((PrintPreview)PrintPreview.this).canvas.rebuild = true;
            }
            ((PrintPreview)PrintPreview.this).canvas.userTreeDepth = Integer.parseInt(s);
            int oldOrder = ((PrintPreview)PrintPreview.this).canvas.pageOrder;
            ((PrintPreview)PrintPreview.this).canvas.pageOrder = this.mOverThenDown.isSelected() ? 0 : 1;
            if (!((PrintPreview)PrintPreview.this).canvas.rebuild && oldOrder != ((PrintPreview)PrintPreview.this).canvas.pageOrder) {
                ((PrintPreview)PrintPreview.this).canvas.rebuild = true;
            }
            boolean b = PrintPreview.this.canvas.isPrintingHeader();
            boolean b1 = PrintPreview.this.canvas.isPrintingFooter();
            PrintPreview.this.canvas.setPrintHeader(this.showHeader.isSelected());
            PrintPreview.this.canvas.setPrintFooter(this.showFooter.isSelected());
            if (!((PrintPreview)PrintPreview.this).canvas.rebuild && (b ^ this.showHeader.isSelected() || b1 ^ this.showFooter.isSelected())) {
                ((PrintPreview)PrintPreview.this).canvas.rebuild = true;
            }
        }

        private void readModel() {
            this.depthTextField.setText(PrintPreview.intToString(((PrintPreview)PrintPreview.this).canvas.userTreeDepth));
            this.mOverThenDown.setSelected(((PrintPreview)PrintPreview.this).canvas.pageOrder == 0);
            this.mDownThenOver.setSelected(((PrintPreview)PrintPreview.this).canvas.pageOrder == 1);
            this.showHeader.setEnabled(PrintPreview.this.canvas.isHeaderOn());
            if (this.showHeader.isEnabled()) {
                this.showHeader.setSelected(PrintPreview.this.canvas.isPrintingHeader());
            }
            this.showFooter.setEnabled(PrintPreview.this.canvas.isFooterOn());
            if (this.showFooter.isEnabled()) {
                this.showFooter.setSelected(PrintPreview.this.canvas.isPrintingFooter());
            }
        }

        private void close() {
            this.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.getGlassPane().setVisible(true);
            this.dispose();
        }

        private void validateTreeDepth() {
            String s = this.depthTextField.getText();
            try {
                int depth = Integer.parseInt(s);
                if (depth < 0 || depth > ((PrintPreview)PrintPreview.this).canvas.maxTreeDepth) {
                    this.depthTextField.setText(PrintPreview.intToString(-1));
                }
            }
            catch (NumberFormatException x) {
                this.depthTextField.setText(PrintPreview.intToString(-1));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JTextField) {
                this.validateTreeDepth();
            } else if (e.getActionCommand().equals("OK")) {
                this.validateTreeDepth();
                this.writeModel();
                PrintPreview.this.applyChanges();
                this.close();
            } else if (e.getActionCommand().equals("Cancel")) {
                this.close();
            }
        }
    }

    private class PageNavigationPanel
    extends JPanel {
        private IconButton firstButton;
        private IconButton prev1Button;
        private IconButton next1Button;
        private IconButton lastButton;
        private JTextField pageNumberMsg;
        private JLabel maxPageMsg;
        private JPanel pageMsg;

        public PageNavigationPanel() {
            this.init();
        }

        private void init() {
            this.setLayout(new FlowLayout());
            this.maxPageMsg = new JLabel("    ");
            this.pageNumberMsg = new JTextField("", 3);
            this.pageNumberMsg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PageNavigationPanel.this.validatePageNumberMsg();
                }
            });
            this.pageMsg = new JPanel();
            this.pageMsg.setLayout(new FlowLayout());
            this.pageMsg.add(new JLabel(ResourceLoader.getResourceString((Object)PrintPreview.this.rb, (String)"PrintPreview.Page.txt", (String)"Page")));
            this.pageMsg.add(this.pageNumberMsg);
            this.pageMsg.add(new JLabel(ResourceLoader.getResourceString((Object)PrintPreview.this.rb, (String)"PrintPreview.Of.txt", (String)"of")));
            this.pageMsg.add(this.maxPageMsg);
            this.firstButton = new IconButton(PrintPreview.makeImageIcon("PrintPreview_First.gif"), "FirstPage", 10);
            this.firstButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrintPreview.this.firstPage();
                }
            });
            this.prev1Button = new IconButton(PrintPreview.makeImageIcon("PrintPreview_Previous.gif"), "PreviousPage", 10);
            this.prev1Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrintPreview.this.prevPage();
                }
            });
            this.next1Button = new IconButton(PrintPreview.makeImageIcon("PrintPreview_Next.gif"), "NextPage", 10);
            this.next1Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrintPreview.this.nextPage();
                }
            });
            this.lastButton = new IconButton(PrintPreview.makeImageIcon("PrintPreview_Last.gif"), "LastPage", 10);
            this.lastButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrintPreview.this.lastPage();
                }
            });
            this.add(this.firstButton);
            this.add(this.prev1Button);
            this.add(this.pageMsg);
            this.add(this.next1Button);
            this.add(this.lastButton);
        }

        public void refresh() {
            this.refreshMaxPageMsg();
            this.refreshEnables();
        }

        public void refreshMaxPageMsg() {
            int p = PrintPreview.this.maxPage;
            this.maxPageMsg.setText(PrintPreview.intToString(p) + "  ");
        }

        private void validatePageNumberMsg() {
            String s = this.pageNumberMsg.getText();
            try {
                PrintPreview.this.pageNumber = Integer.parseInt(s);
                PrintPreview.this.checkPage();
            }
            catch (NumberFormatException x) {
                this.pageNumberMsg.setText(PrintPreview.intToString(PrintPreview.this.pageNumber));
            }
        }

        private void refreshEnables() {
            int p = PrintPreview.this.pageNumber;
            int min = PrintPreview.this.minPage;
            int max = PrintPreview.this.maxPage;
            boolean prev = p > min;
            this.prev1Button.setEnabled(prev);
            this.firstButton.setEnabled(prev);
            boolean next = p < max;
            this.next1Button.setEnabled(next);
            this.lastButton.setEnabled(next);
            this.pageNumberMsg.setText(PrintPreview.intToString(p));
            this.pageNumberMsg.setEnabled(true);
            this.setEnabled(true);
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (!this.isEnabled()) {
                Color bg = this.getBackground();
                Color dmColor = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 180);
                g.setColor(dmColor);
                this.paintOver(g, this.pageMsg);
            }
        }

        private void paintOver(Graphics g, JComponent c) {
            Rectangle r = c.getBounds();
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }
}

