/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dtree;

import com.sas.graphics.silk.dtree.AbstractDTreeNode;
import com.sas.graphics.silk.dtree.CollapseButton;
import com.sas.graphics.silk.dtree.Contour;
import com.sas.graphics.silk.dtree.TreeCanvas;
import com.sas.graphics.silk.dtree.TreeLink;
import com.sas.graphics.silk.interfaces.TreeModelInterface;
import com.sas.graphics.silk.interfaces.TreeNodeInterface;
import com.sas.graphics.styles.Style;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.StringTokenizer;
import javax.swing.tree.TreeNode;

public class DTreeNode
extends AbstractDTreeNode {
    private static final long serialVersionUID = -1704162906963096480L;
    private DTreeNode parent;
    private DTreeNode child;
    private DTreeNode sibling;
    private DTreeNode leftSibling;
    private int borderWidth;
    private Contour contour;
    private CollapseButton collapse;
    private TreeLink link;
    private boolean hasChildren = false;
    private String[][] parsedNodeText = null;
    private String[][] parsedTipText = null;
    private int FromChild = 0;
    private int FromParent = 1;
    private int FromSibling = 2;
    protected boolean isFocus = false;
    private static int nodeSpacing = 12;
    protected int minSize = 30;
    private double[][] graphData;
    private TreeNode data = null;
    private TreeModelInterface treeModel = null;
    TreeCanvas canvas = null;

    public DTreeNode(TreeNode n, TreeCanvas canvas) {
        this.data = n;
        this.treeModel = canvas.tree;
        this.canvas = canvas;
        this.collapse = new CollapseButton();
        this.collapse.setColapsed(canvas.tree.isCollapsed(this.getID()));
        this.add(this.collapse);
        this.contour = new Contour();
    }

    @Override
    public void paintComponent(Graphics g) {
        double color = this.getNodeColor();
        if (!this.treeModel.isDefined(2)) {
            color = this.getNodeSize();
        }
        Rectangle nodeBounds = new Rectangle(nodeSpacing, nodeSpacing, this.getBounds().width - 2 * nodeSpacing, this.getBounds().height - 2 * nodeSpacing);
        this.drawBorder((Graphics2D)g, nodeBounds);
        Rectangle oldClip = g.getClipBounds();
        g.setClip(oldClip.createIntersection(nodeBounds));
        if (this.treeModel.isFlagged(this.getID()) && this.canvas.showFlaggedNodeGraphs && this.getGraphData() != null) {
            this.canvas.graphNodeRenderer.drawNode(this.canvas.nodesUseTipText ? this.getParsedToolTipText() : this.getParsedText(), this.getGraphData(), this.data, (Graphics2D)g, this.treeModel.isFlagged(this.getID()), color, nodeBounds);
        } else if (this.canvas.showNodeGraphs && this.getGraphData() != null) {
            this.canvas.graphNodeRenderer.drawNode(this.canvas.nodesUseTipText ? this.getParsedToolTipText() : this.getParsedText(), this.getGraphData(), this.data, (Graphics2D)g, this.treeModel.isFlagged(this.getID()), color, nodeBounds);
        } else {
            this.canvas.nodeRenderer.drawNode(this.canvas.nodesUseTipText ? this.getParsedToolTipText() : this.getParsedText(), this.getGraphData(), this.data, (Graphics2D)g, this.treeModel.isFlagged(this.getID()), color, nodeBounds);
        }
        g.setClip(oldClip);
    }

    public void drawBorder(Graphics2D g, Rectangle nodeBounds) {
        int width;
        Style style = this.canvas.style;
        Color outlineColor = style.getLineStyleElement("Outlines").getLineColor();
        g.setColor(outlineColor);
        int n = width = this.treeModel.isFlagged(this.getID()) ? this.canvas.flaggedNodeOutlineWidth : this.canvas.nodeOutlineWidth;
        if (width <= 0) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        if (this.treeModel.isSelected(this.getID())) {
            g.setStroke(new BasicStroke(width + 5, 0, 2, 0.0f, null, 0.0f));
            g.drawRoundRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height, 5, 5);
        } else {
            g.setStroke(new BasicStroke(width, 0, 2, 0.0f, null, 0.0f));
            g.drawRoundRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height, 5, 5);
        }
        if (this.isFocus) {
            g.setColor(Color.white);
            g.setStroke(new BasicStroke(5.0f, 0, 2, 0.0f, new float[]{8.0f, 8.0f}, 0.0f));
            g.drawRoundRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height, 5, 5);
        }
        g.setStroke(oldStroke);
    }

    @Override
    public Object getID() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getId();
        }
        return this.data.toString();
    }

    public String[][] getParsedText() {
        if (this.parsedNodeText == null) {
            this.parsedNodeText = DTreeNode.parseText(this.getNodeText());
        }
        return this.parsedNodeText;
    }

    public String getNodeText() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getNodeText();
        }
        return this.data.toString();
    }

    public String[][] getParsedToolTipText() {
        if (this.parsedTipText == null) {
            this.parsedTipText = DTreeNode.parseText(this.getToolTipText());
        }
        return this.parsedTipText;
    }

    @Override
    public String getToolTipText() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getToolTipText();
        }
        return this.getNodeText();
    }

    public double getNodeSize() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getNodeSize();
        }
        return Double.NaN;
    }

    public double getNodeColor() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getNodeColorValue();
        }
        return Double.NaN;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean b) {
        this.hasChildren = b;
    }

    public double[][] getGraphData() {
        return this.graphData;
    }

    public void setGraphData(double[][] gData) {
        this.graphData = gData;
    }

    public String getAboveText() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getAboveText();
        }
        return null;
    }

    public void setAboveText(String text) {
        if (this.data instanceof TreeNodeInterface) {
            ((TreeNodeInterface)this.data).setAboveText(text);
        }
    }

    public String getBelowText() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getBelowText();
        }
        return null;
    }

    public void setBelowText(String text) {
        if (this.data instanceof TreeNodeInterface) {
            ((TreeNodeInterface)this.data).setBelowText(text);
        }
    }

    public String getSurrogateString() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getSurrogateString();
        }
        return null;
    }

    public int getLinkWidth() {
        if (this.data instanceof TreeNodeInterface) {
            return ((TreeNodeInterface)this.data).getLinkWidth();
        }
        return 1;
    }

    public void setLinkWidth(int i) {
        if (this.data instanceof TreeNodeInterface) {
            ((TreeNodeInterface)this.data).setLinkWidth(i);
        }
    }

    @Override
    public TreeLink getLink() {
        return this.link;
    }

    public void setLink(TreeLink t) {
        this.link = t;
    }

    @Override
    public CollapseButton getCollapse() {
        return this.collapse;
    }

    public void pruneChildren() {
        this.child = null;
    }

    @Override
    public DTreeNode getChild() {
        return this.child;
    }

    public void setChild(DTreeNode c) {
        if (c == null) {
            return;
        }
        c.setParentNode(this);
        if (this.child != null) {
            this.child.setSibling(c);
        } else {
            this.child = c;
        }
    }

    public void setSibling(DTreeNode s) {
        if (this.sibling != null) {
            this.sibling.setSibling(s);
        } else {
            this.sibling = s;
            s.setLeftSibling(this);
        }
    }

    public DTreeNode getLeftSibling() {
        return this.leftSibling;
    }

    public void setLeftSibling(DTreeNode s) {
        this.leftSibling = s;
    }

    public DTreeNode getParentNode() {
        return this.parent;
    }

    public void setParentNode(DTreeNode t) {
        this.parent = t;
    }

    @Override
    public DTreeNode getSibling() {
        return this.sibling;
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public Contour getContour() {
        return this.contour;
    }

    public void setContour(Contour c) {
        this.contour = c;
    }

    public DTreeNode getRightMostChild() {
        if (this.getChild() != null) {
            return this.getEndOfList(this.getChild());
        }
        return null;
    }

    public DTreeNode getEndOfList(DTreeNode t) {
        if (t.getSibling() == null) {
            return t;
        }
        return this.getEndOfList(t.getSibling());
    }

    public DTreeNode getRightRelative(boolean wrap) {
        if (this.getSibling() != null) {
            return this.getSibling();
        }
        if (this.getParentNode() == null) {
            if (!wrap) {
                return null;
            }
            return this.getChild();
        }
        int searchDir = this.FromChild;
        DTreeNode pNode = this.getParentNode();
        int level = 1;
        do {
            if (searchDir != this.FromChild && pNode.getChild() != null) {
                pNode = pNode.getChild();
                searchDir = this.FromParent;
                --level;
                continue;
            }
            if (pNode.getSibling() != null) {
                pNode = pNode.getSibling();
                searchDir = this.FromSibling;
                continue;
            }
            if (pNode.getParentNode() != null) {
                pNode = pNode.getParentNode();
                searchDir = this.FromChild;
                ++level;
                continue;
            }
            if (!wrap) {
                return null;
            }
            return this.getLeftMostAtLevel(pNode, level++);
        } while (level != 0);
        return pNode;
    }

    public DTreeNode getLeftRelative(boolean wrap) {
        if (this.getLeftSibling() != null) {
            return this.getLeftSibling();
        }
        if (this.getParentNode() == null) {
            return null;
        }
        int searchDir = this.FromChild;
        DTreeNode pNode = this.getParentNode();
        int level = 1;
        do {
            if (searchDir != this.FromChild && pNode.getRightMostChild() != null) {
                pNode = pNode.getRightMostChild();
                searchDir = this.FromParent;
                --level;
                continue;
            }
            if (pNode.getLeftSibling() != null) {
                pNode = pNode.getLeftSibling();
                searchDir = this.FromSibling;
                continue;
            }
            if (pNode.getParentNode() != null) {
                pNode = pNode.getParentNode();
                searchDir = this.FromChild;
                ++level;
                continue;
            }
            if (!wrap) {
                return null;
            }
            return this.getRightMostAtLevel(pNode, level);
        } while (level != 0);
        return pNode;
    }

    public DTreeNode getLeftMostAtLevel(DTreeNode pNode, int level) {
        if (level == 0) {
            return pNode;
        }
        DTreeNode tmpNode = pNode.getChild() != null ? this.getLeftMostAtLevel(pNode.getChild(), level - 1) : null;
        if (tmpNode == null && pNode.getSibling() != null) {
            tmpNode = this.getLeftMostAtLevel(pNode.getSibling(), level);
        }
        return tmpNode;
    }

    public DTreeNode getRightMostAtLevel(DTreeNode pNode, int level) {
        if (level == 0) {
            return pNode;
        }
        DTreeNode tmpNode = null;
        if (pNode.getRightMostChild() != null) {
            tmpNode = this.getRightMostAtLevel(pNode.getRightMostChild(), level - 1);
        }
        if (tmpNode == null && pNode.getLeftSibling() != null) {
            tmpNode = this.getRightMostAtLevel(pNode.getLeftSibling(), level);
        }
        return tmpNode;
    }

    public static String[][] parseText(String text) {
        if (text == null) {
            return null;
        }
        StringTokenizer lineParser = new StringTokenizer(text, "\n");
        String[][] rc = new String[lineParser.countTokens()][];
        int maxCols = 0;
        int i = 0;
        while (lineParser.hasMoreTokens()) {
            StringTokenizer colParser = new StringTokenizer(lineParser.nextToken(), "\t");
            rc[i] = new String[colParser.countTokens()];
            if (colParser.countTokens() > maxCols) {
                maxCols = colParser.countTokens();
            }
            int j = 0;
            while (colParser.hasMoreTokens()) {
                rc[i][j] = colParser.nextToken();
                ++j;
            }
            ++i;
        }
        String[][] temp = rc;
        if (maxCols == 0) {
            return null;
        }
        rc = new String[maxCols][];
        for (i = 0; i < maxCols; ++i) {
            rc[i] = DTreeNode.getCol(i, temp);
        }
        return rc;
    }

    public static String[] getCol(int i, String[][] arr) {
        String[] rc = new String[arr.length];
        for (int j = 0; j < arr.length; ++j) {
            rc[j] = arr[j].length > i ? arr[j][i].trim() : new String("");
        }
        return rc;
    }

    public static int getNodeSpacing() {
        return nodeSpacing;
    }

    public String getTipText() {
        if (this.getToolTipText() == null) {
            return this.getNodeText();
        }
        return this.getToolTipText();
    }

    public String[][] getTipTextArray() {
        return this.getParsedToolTipText();
    }
}

