/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.dtree;

import com.sas.graphics.silk.dtree.AbstractDTreeNode;
import com.sas.graphics.silk.dtree.Contour;
import com.sas.graphics.silk.dtree.DTreeNode;
import com.sas.graphics.silk.dtree.Line;
import com.sas.graphics.silk.dtree.PrintableNode;
import java.awt.Point;
import java.awt.Rectangle;

public class DTreeLayout {
    public static void treeLayout(DTreeNode t, int orientation, Point parentOffset) {
        for (DTreeNode c = t.getChild(); c != null; c = c.getSibling()) {
            DTreeLayout.treeLayout(c, orientation, parentOffset);
        }
        if (t.getChild() != null) {
            if (orientation == 0) {
                DTreeLayout.attachParentHorizontal(t, DTreeLayout.joinHorizontal(t), parentOffset);
            } else {
                DTreeLayout.attachParentVertical(t, DTreeLayout.joinVertical(t), parentOffset);
            }
        } else {
            DTreeLayout.layoutLeaf(t, orientation);
        }
    }

    public static void printTreeLayout(PrintableNode t, int orientation, Point parentOffset) {
        for (PrintableNode c = t.getChild(); c != null; c = c.getSibling()) {
            DTreeLayout.printTreeLayout(c, orientation, parentOffset);
        }
        PrintableNode printNode = t;
        if (printNode.isVisited && printNode.isPrintable) {
            PrintableNode childNode = printNode.getPrintableChild();
            if (childNode != null) {
                if (orientation == 0) {
                    DTreeLayout.attachParentHorizontal(t, DTreeLayout.joinPrintHorizontal(t), parentOffset);
                } else {
                    DTreeLayout.attachParentVertical(t, DTreeLayout.joinPrintVertical(t), parentOffset);
                }
            } else {
                DTreeLayout.layoutLeaf(t, orientation);
            }
        } else {
            Rectangle r = t.getBounds();
            r.x = 0;
            r.y = 0;
            t.setBounds(r);
        }
    }

    public static void attachParentHorizontal(AbstractDTreeNode t, int h, Point parentOffset) {
        if (t == null || parentOffset == null) {
            return;
        }
        int x = t.getBorderWidth() + parentOffset.x;
        int y2 = (h - t.getBounds().height) / 2 - t.getBorderWidth();
        int y1 = y2 + t.getBounds().height + 2 * t.getBorderWidth() - h;
        AbstractDTreeNode childNode = t.isPrintingNode() ? ((PrintableNode)t).getPrintableChild() : t.getChild();
        Rectangle r = t.getChild().getBounds();
        r.x = x + t.getBounds().width;
        r.y = y1;
        childNode.setBounds(r);
        t.getContour().getUpper().setHead(new Line(t.getBounds().width, 0, new Line(x, y1, t.getContour().getUpper().getHead())));
        t.getContour().getLower().setHead(new Line(t.getBounds().width, 0, new Line(x, y2, t.getContour().getLower().getHead())));
    }

    public static void attachParentVertical(AbstractDTreeNode t, int h, Point parentOffset) {
        if (t == null || parentOffset == null) {
            return;
        }
        int y = t.getBorderWidth() + parentOffset.y;
        int x2 = (h - t.getBounds().width) / 2 - t.getBorderWidth();
        int x1 = x2 + t.getBounds().width + 2 * t.getBorderWidth() - h;
        AbstractDTreeNode childNode = t.isPrintingNode() ? ((PrintableNode)t).getPrintableChild() : t.getChild();
        Rectangle r = childNode.getBounds();
        r.y = y + t.getBounds().height;
        r.x = x1;
        childNode.setBounds(r);
        t.getContour().getUpper().setHead(new Line(0, t.getBounds().height, new Line(x2, y, t.getContour().getUpper().getHead())));
        t.getContour().getLower().setHead(new Line(0, t.getBounds().height, new Line(x1, y, t.getContour().getLower().getHead())));
    }

    public static void layoutLeaf(AbstractDTreeNode t, int orientation) {
        if (orientation == 1) {
            t.getContour().getUpper().setTail(new Line(0, t.getBounds().height + 2 * t.getBorderWidth(), null));
            t.getContour().getUpper().setHead(t.getContour().getUpper().getTail());
            t.getContour().getLower().setTail(new Line(t.getBounds().width + 2 * t.getBorderWidth(), 0, null));
            t.getContour().getLower().setHead(new Line(0, t.getBounds().height + 2 * t.getBorderWidth(), t.getContour().getLower().getTail()));
        } else {
            t.getContour().getUpper().setTail(new Line(t.getBounds().width + 2 * t.getBorderWidth(), 0, null));
            t.getContour().getUpper().setHead(t.getContour().getUpper().getTail());
            t.getContour().getLower().setTail(new Line(0, -t.getBounds().height - 2 * t.getBorderWidth(), null));
            t.getContour().getLower().setHead(new Line(t.getBounds().width + 2 * t.getBorderWidth(), 0, t.getContour().getLower().getTail()));
        }
    }

    public static int joinPrintHorizontal(PrintableNode t) {
        int h;
        if (t == null) {
            return -1;
        }
        PrintableNode c = t.getPrintableChild();
        Contour.clone(c.getContour(), t.getContour());
        int sum = h = c.getBounds().height + 2 * c.getBorderWidth();
        c = c.getSibling();
        while (c != null) {
            Rectangle r;
            int d = DTreeLayout.mergeHorizontal(t.getContour(), c.getContour());
            if (c.isVisited && c.isPrintable) {
                r = c.getBounds();
                r.y = d + h;
                r.x = 0;
                c.setBounds(r);
                h = c.getBounds().height + 2 * c.getBorderWidth();
                sum += d + h;
                c = c.getSibling();
                continue;
            }
            r = c.getBounds();
            r.x = 0;
            r.y = 0;
            c.setBounds(r);
            c = c.getSibling();
        }
        return sum;
    }

    public static int joinPrintVertical(PrintableNode t) {
        int h = 0;
        int sum = 0;
        if (t == null) {
            return -1;
        }
        PrintableNode c = t.getPrintableChild();
        Contour.clone(c.getContour(), t.getContour());
        sum = h = c.getBounds().width + 2 * c.getBorderWidth();
        c = c.getSibling();
        while (c != null) {
            Rectangle r;
            int d = DTreeLayout.mergeVertical(t.getContour(), c.getContour());
            if (c.isVisited && c.isPrintable) {
                r = c.getBounds();
                r.x = d + h;
                r.y = 0;
                c.setBounds(r);
                h = c.getBounds().width + 2 * c.getBorderWidth();
                sum += d + h;
                c = c.getSibling();
                continue;
            }
            r = c.getBounds();
            r.x = 0;
            r.y = 0;
            c.setBounds(r);
            c = c.getSibling();
        }
        return sum;
    }

    public static int joinHorizontal(DTreeNode t) {
        int h;
        if (t == null) {
            return -1;
        }
        DTreeNode c = t.getChild();
        Contour.clone(c.getContour(), t.getContour());
        int sum = h = c.getBounds().height + 2 * c.getBorderWidth();
        for (c = c.getSibling(); c != null; c = c.getSibling()) {
            int d = DTreeLayout.mergeHorizontal(t.getContour(), c.getContour());
            Rectangle r = c.getBounds();
            r.y = d + h;
            r.x = 0;
            c.setBounds(r);
            h = c.getBounds().height + 2 * c.getBorderWidth();
            sum += d + h;
        }
        return sum;
    }

    public static int joinVertical(DTreeNode t) {
        int h;
        if (t == null) {
            return -1;
        }
        DTreeNode c = t.getChild();
        Contour.clone(c.getContour(), t.getContour());
        int sum = h = c.getBounds().width + 2 * c.getBorderWidth();
        for (c = c.getSibling(); c != null; c = c.getSibling()) {
            int d = DTreeLayout.mergeVertical(t.getContour(), c.getContour());
            Rectangle r = c.getBounds();
            r.x = d + h;
            r.y = 0;
            c.setBounds(r);
            h = c.getBounds().width + 2 * c.getBorderWidth();
            sum += d + h;
        }
        return sum;
    }

    public static int mergeHorizontal(Contour c1, Contour c2) {
        int total = 0;
        int y = 0;
        int x = 0;
        Line upper = c1.getLower().getHead();
        Line lower = c2.getUpper().getHead();
        while (upper != null && lower != null) {
            int d = DTreeLayout.offsetX(x, y, lower.getDX(), lower.getDY(), upper.getDX(), upper.getDY());
            y += d;
            total += d;
            if (x + lower.getDX() <= upper.getDX()) {
                y += lower.getDY();
                x += lower.getDX();
                lower = lower.getLink();
                continue;
            }
            y -= upper.getDY();
            x -= upper.getDX();
            upper = upper.getLink();
        }
        if (lower != null) {
            Line b = DTreeLayout.bridgeHorizontal(c1.getUpper().getTail(), 0, 0, lower, x, y);
            c1.getUpper().setTail(b.getLink() != null ? c2.getUpper().getTail() : b);
            c1.getLower().setTail(c2.getLower().getTail());
        } else {
            Line b = DTreeLayout.bridgeHorizontal(c2.getLower().getTail(), x, y, upper, 0, 0);
            if (b.getLink() == null) {
                c1.getLower().setTail(b);
            }
        }
        c1.getLower().setHead(c2.getLower().getHead());
        return total;
    }

    public static int mergeVertical(Contour c1, Contour c2) {
        int total = 0;
        int y = 0;
        int x = 0;
        Line upper = c1.getUpper().getHead();
        Line lower = c2.getLower().getHead();
        while (upper != null && lower != null) {
            int d = DTreeLayout.offsetY(x, y, lower.getDX(), lower.getDY(), upper.getDX(), upper.getDY());
            x += d;
            if (y + lower.getDY() < upper.getDY()) {
                y += lower.getDY();
                x += lower.getDX();
                lower = lower.getLink();
            } else {
                y -= upper.getDY();
                x -= upper.getDX();
                upper = upper.getLink();
            }
            total += d;
        }
        if (lower != null) {
            Line b = DTreeLayout.bridgeVertical(c1.getLower().getTail(), 0, 0, lower, x, y);
            c1.getUpper().setTail(b.getLink() != null ? c2.getUpper().getTail() : b);
            c1.getLower().setTail(c2.getLower().getTail());
        } else {
            Line b = DTreeLayout.bridgeVertical(c2.getUpper().getTail(), x, y, upper, 0, 0);
            if (b.getLink() == null) {
                c1.getLower().setTail(b);
            }
        }
        c1.getUpper().setHead(c2.getUpper().getHead());
        return total;
    }

    public static int offsetX(int p1, int p2, int a1, int a2, int b1, int b2) {
        int d;
        if (b1 <= p1 || p1 + a1 <= 0) {
            return 0;
        }
        int t = b1 * a2 - a1 * b2;
        if (t > 0) {
            if (p1 < 0) {
                int s = p1 * a2;
                d = s / a1 - p2;
            } else if (p1 > 0) {
                int s = p1 * b2;
                d = s / b1 - p2;
            } else {
                d = -p2;
            }
        } else if (b1 < p1 + a1) {
            int s = (b1 - p1) * a2;
            d = b2 - (p2 + s / a1);
        } else if (b1 > p1 + a1) {
            int s = (a1 + p1) * b2;
            d = s / b1 - (p2 + a2);
        } else {
            d = b2 - (p2 + a2);
        }
        return Math.max(0, d);
    }

    public static int offsetY(int p1, int p2, int a1, int a2, int b1, int b2) {
        int d;
        if (b2 <= p2 || p2 + a2 <= 0) {
            return 0;
        }
        int t = b2 * a1 - a2 * b1;
        if (t > 0) {
            if (p2 < 0) {
                int s = p2 * a1;
                d = s / a2 - p1;
            } else if (p2 > 0) {
                int s = p2 * b1;
                d = s / b2 - p1;
            } else {
                d = -p1;
            }
        } else if (b2 < p2 + a2) {
            int s = (b2 - p2) * a1;
            d = b1 - (p1 + s / a2);
        } else if (b2 > p2 + a2) {
            int s = (a2 + p2) * b1;
            d = s / b2 - (p1 + a1);
        } else {
            d = b1 - (p1 + a1);
        }
        return Math.max(0, d);
    }

    public static Line bridgeHorizontal(Line line1, int x1, int y1, Line line2, int x2, int y2) {
        int dy;
        int dx = x2 + line2.getDX() - x1;
        if (line2.getDX() == 0) {
            dy = line2.getDY();
        } else {
            int s = dx * line2.getDY();
            dy = s / line2.getDX();
        }
        Line r = new Line(dx, dy, line2.getLink());
        line1.setLink(new Line(0, y2 + line2.getDY() - dy - y1, r));
        return r;
    }

    public static Line bridgeVertical(Line line1, int x1, int y1, Line line2, int x2, int y2) {
        int dx;
        int dy = y2 + line2.getDY() - y1;
        if (line2.getDY() == 0) {
            dx = line2.getDX();
        } else {
            int s = dy * line2.getDX();
            dx = s / line2.getDY();
        }
        Line r = new Line(dx, dy, line2.getLink());
        line1.setLink(new Line(x2 + line2.getDX() - dx - x1, 0, r));
        return r;
    }
}

