/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.data;

import com.sas.graphics.silk.data.DataModelEntry;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.util.Extract;
import java.util.Vector;

public class KeyLinker
implements DataFilterListenerInterface {
    private Vector dataEntries = new Vector();
    private boolean ignoreEvents = false;
    private String name = "KeyLinker";
    private boolean enabled = true;

    public KeyLinker() {
    }

    public KeyLinker(DataFilterReadInterface data1, String data1KeyVar, DataFilterReadInterface data2, String data2KeyVar) {
        this.addDataModel(data1, data1KeyVar);
        this.addDataModel(data2, data2KeyVar);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int size() {
        return this.dataEntries.size();
    }

    public String getName() {
        return this.name;
    }

    public DataFilterReadInterface getDataModelAt(int index) {
        if (index < 0 || index >= this.dataEntries.size()) {
            return null;
        }
        return ((DataModelEntry)this.dataEntries.elementAt((int)index)).dfri;
    }

    public Object getKeyVariableAt(int index) {
        if (index < 0 || index >= this.dataEntries.size()) {
            return null;
        }
        return ((DataModelEntry)this.dataEntries.elementAt((int)index)).keyVar;
    }

    public void setName(String nameIn) {
        this.name = nameIn;
    }

    public String toString() {
        return this.name;
    }

    public boolean addDataModel(DataFilterReadInterface data, String keyVar) {
        if (data == null || keyVar == null) {
            return false;
        }
        if (this.getDataModelEntryForModel(data) != null) {
            return false;
        }
        if (!data.verifyVariable((Object)keyVar)) {
            return false;
        }
        data.addDataFilterListener((Object)this);
        this.dataEntries.addElement(new DataModelEntry(data, keyVar));
        return true;
    }

    public boolean removeDataModel(DataFilterReadInterface dfri) {
        DataModelEntry dme = this.getDataModelEntryForModel(dfri);
        if (dme == null) {
            return false;
        }
        dme.dfri.removeDataFilterListener((Object)this);
        this.dataEntries.remove(dme);
        return true;
    }

    public void removeAllDataModels() {
        Object[] entries = new DataModelEntry[this.size()];
        this.dataEntries.copyInto(entries);
        for (int i = 0; i < entries.length; ++i) {
            ((DataModelEntry)entries[i]).dfri.removeDataFilterListener((Object)this);
            this.dataEntries.remove(entries[i]);
        }
    }

    public int getIndexOfDataModel(DataFilterReadInterface dfri) {
        DataModelEntry dme = this.getDataModelEntryForModel(dfri);
        if (dme == null) {
            return -1;
        }
        return this.dataEntries.indexOf(dme);
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt == null) {
            return;
        }
        if (this.ignoreEvents || !this.enabled) {
            return;
        }
        this.ignoreEvents = true;
        DataModelEntry eventSource = this.getDataModelEntryForModel(evt.source);
        if (eventSource == null) {
            return;
        }
        switch (evt.type) {
            case 1: {
                break;
            }
            case 2: {
                int first = 0;
                int type = Extract.getSourceType((Object)evt.oldValue);
                if (evt.newValue == null) {
                    this.ignoreEvents = false;
                    return;
                }
                int last = ((Number)evt.newValue).intValue() - 1;
                for (int i = first; i <= last; ++i) {
                    int index = evt.oldValue == null ? i : Extract.getInteger((Object)evt.oldValue, (int)i, (int)type);
                    Object keyValue = eventSource.getKeyValue(index);
                    boolean isSelected = eventSource.dfri.isSelected((long)index);
                    for (int j = 0; j < this.dataEntries.size(); ++j) {
                        if (eventSource == this.dataEntries.elementAt(j)) continue;
                        ((DataModelEntry)this.dataEntries.elementAt(j)).select(keyValue, isSelected);
                    }
                }
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
        }
        this.ignoreEvents = false;
    }

    private DataModelEntry getDataModelEntryForModel(Object model) {
        if (this.dataEntries == null || this.dataEntries.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.dataEntries.size(); ++i) {
            DataModelEntry dme = (DataModelEntry)this.dataEntries.elementAt(i);
            if (dme.dfri != model) continue;
            return dme;
        }
        return null;
    }
}

