/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.data;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import java.util.Enumeration;
import java.util.Vector;

class DataModelEntry {
    DataFilterReadInterface dfri = null;
    String keyVar = null;
    Vector uniqueValues = new Vector();

    public DataModelEntry(DataFilterReadInterface dataIn, String keyVarIn) {
        this.dfri = dataIn;
        this.keyVar = keyVarIn;
        this.computeUniqueValues();
    }

    private void computeUniqueValues() {
        int i;
        this.uniqueValues.removeAllElements();
        Vector<Object> uniques = new Vector<Object>();
        for (i = 0; i < this.dfri.getNumberObservations(-1); ++i) {
            Object obj = this.dfri.getValue((Object)this.keyVar, (long)i);
            if (uniques.contains(obj)) continue;
            uniques.addElement(obj);
        }
        for (i = 0; i < uniques.size(); ++i) {
            this.uniqueValues.addElement(new ValueEntry(uniques.elementAt(i)));
        }
    }

    public Object getKeyValue(int index) {
        if (this.dfri == null || this.keyVar == null) {
            return null;
        }
        return this.dfri.getValue((Object)this.keyVar, (long)index);
    }

    public void select(Object keyValue, boolean isSelected) {
        ValueEntry entry = this.getValue(keyValue);
        if (entry == null) {
            return;
        }
        entry.select(isSelected);
    }

    private ValueEntry getValue(Object keyValue) {
        if (this.uniqueValues == null || this.uniqueValues.isEmpty()) {
            return null;
        }
        Enumeration e = this.uniqueValues.elements();
        while (e.hasMoreElements()) {
            ValueEntry entry = (ValueEntry)e.nextElement();
            if (!entry.value.equals(keyValue)) continue;
            return entry;
        }
        return null;
    }

    class ValueEntry {
        public Object value = null;
        public int[] indexList = null;

        public ValueEntry(Object valueIn) {
            int i;
            this.value = valueIn;
            int numObs = DataModelEntry.this.dfri.getNumberObservations(-1);
            Vector<Integer> vec = new Vector<Integer>();
            for (i = 0; i < numObs; ++i) {
                Object obj = DataModelEntry.this.dfri.getValue((Object)DataModelEntry.this.keyVar, (long)i);
                if (!obj.equals(valueIn)) continue;
                vec.addElement(new Integer(i));
            }
            this.indexList = new int[vec.size()];
            for (i = 0; i < this.indexList.length; ++i) {
                this.indexList[i] = (Integer)vec.elementAt(i);
            }
        }

        public void select(boolean selected) {
            if (DataModelEntry.this.dfri == null || this.indexList == null) {
                return;
            }
            DataModelEntry.this.dfri.setSelected((Object)this.indexList, selected);
        }
    }
}

