/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.constchart.layout;

import com.sas.graphics.silk.constchart.layout.AdjacencyInfo;
import com.sas.graphics.silk.constchart.layout.GraphComponentInterface;
import com.sas.graphics.silk.util.nld.DataFilterModel;
import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDNode;
import java.util.Vector;

public class GraphInformation
implements GraphComponentInterface {
    private DataFilterModel model = null;
    private Vector[] adjacencyList = null;
    private int nVisNodes = 0;

    public GraphInformation(DataFilterModel model) {
        this.model = model;
        int nNodes = model.nodes.size();
        for (int i = 0; i < nNodes; ++i) {
            NLDNode n = (NLDNode)model.nodes.elementAt(i);
            if (!n.isVisible()) continue;
            ++this.nVisNodes;
        }
        this.init();
    }

    public boolean isNodeVisible(int nodeIdx) {
        if (nodeIdx < 0 || nodeIdx >= this.model.nodes.size()) {
            return false;
        }
        return ((NLDNode)this.model.nodes.elementAt(nodeIdx)).isVisible();
    }

    private void init() {
        this.adjacencyList = new Vector[this.model.nodes.size()];
        for (int i = 0; i < this.model.links.size(); ++i) {
            AdjacencyInfo adjI;
            NLDLink link = (NLDLink)this.model.links.get(i);
            int from = link.getFromIndex();
            int to = link.getToIndex();
            if (from >= 0 && this.isNodeVisible(from)) {
                if (this.adjacencyList[from] == null) {
                    this.adjacencyList[from] = new Vector();
                }
                if (to >= 0 && this.isNodeVisible(to) && !this.isInfoPresent(from, adjI = new AdjacencyInfo(to, i))) {
                    this.adjacencyList[from].addElement(adjI);
                }
            }
            if (to < 0 || !this.isNodeVisible(to)) continue;
            if (this.adjacencyList[to] == null) {
                this.adjacencyList[to] = new Vector();
            }
            if (from < 0 || !this.isNodeVisible(from) || this.isInfoPresent(to, adjI = new AdjacencyInfo(from, i))) continue;
            this.adjacencyList[to].addElement(adjI);
        }
    }

    private boolean isInfoPresent(int nodeIdx, AdjacencyInfo adjI) {
        if (nodeIdx < 0 || nodeIdx > this.adjacencyList.length) {
            return false;
        }
        Vector vec = this.adjacencyList[nodeIdx];
        for (int i = 0; i < vec.size(); ++i) {
            AdjacencyInfo oneInfo = (AdjacencyInfo)vec.elementAt(i);
            if (adjI.getNodeIndex() != oneInfo.getNodeIndex()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getNumberNodes() {
        return this.model.nodes.size();
    }

    public int getVisibleNodeCount() {
        return this.nVisNodes;
    }

    @Override
    public int getDegree(int nodeIndex) {
        int degree = 0;
        if (this.adjacencyList != null && nodeIndex < this.adjacencyList.length && this.adjacencyList[nodeIndex] != null && this.isNodeVisible(nodeIndex)) {
            degree = this.adjacencyList[nodeIndex].size();
        }
        return degree;
    }

    public Vector[] getAdjacencyList() {
        return this.adjacencyList;
    }

    @Override
    public int getAdjacentVertex(int nodeIndex, int i) {
        AdjacencyInfo info = this.getAdjacencyInfo(nodeIndex, i);
        if (info == null) {
            return -1;
        }
        return info.getNodeIndex();
    }

    @Override
    public double getLinkWeight(int nodeIndex, int i) {
        AdjacencyInfo info = this.getAdjacencyInfo(nodeIndex, i);
        if (info == null) {
            return -1.0;
        }
        NLDLink link = (NLDLink)this.model.links.get(info.getLinkIndex());
        return link.getValue();
    }

    public AdjacencyInfo getAdjacencyInfo(int nodeIndex, int i) {
        AdjacencyInfo info = null;
        if (this.adjacencyList != null && nodeIndex < this.adjacencyList.length && this.adjacencyList[nodeIndex] != null && i >= 0 && i < this.adjacencyList[nodeIndex].size() && this.isNodeVisible(nodeIndex)) {
            info = (AdjacencyInfo)this.adjacencyList[nodeIndex].elementAt(i);
        }
        return info;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Number of nodes = " + this.adjacencyList.length + "\n\n");
        for (int i = 0; i < this.adjacencyList.length; ++i) {
            sb.append("Node = " + i + " adjList = {");
            for (int j = 0; j < this.getDegree(i); ++j) {
                sb.append(this.getAdjacentVertex(i, j));
                if (j >= this.getDegree(i) - 1) continue;
                sb.append(", ");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

