/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.constchart.layout;

import com.sas.graphics.silk.constchart.layout.AdjacencyInfo;
import com.sas.graphics.silk.constchart.layout.GraphComponent;
import com.sas.graphics.silk.constchart.layout.GraphComponentAttrs;
import com.sas.graphics.silk.constchart.layout.GraphComponentInterface;
import com.sas.graphics.silk.constchart.layout.GraphDistance;
import com.sas.graphics.silk.constchart.layout.GraphInformation;
import com.sas.graphics.silk.constchart.layout.IntegerQueue;
import com.sas.graphics.silk.constchart.layout.MISF;
import com.sas.graphics.silk.constchart.layout.PQueue;
import com.sas.graphics.silk.constchart.layout.Point;
import com.sas.graphics.silk.util.nld.DataFilterModel;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDRect;
import java.util.Random;
import java.util.Vector;

public class GRIPLayout {
    private static boolean DEBUG_MODE = false;
    private static int LARGE_N_NODE = 300;
    private static int VERY_SMALL_N_NODE = 4;
    public static final double RADIUS = 500.0;
    private int diam = 0;
    private DataFilterModel model = null;
    private Random random = new Random("Random".hashCode());
    private Random pointRandom = new Random("PointRandom".hashCode());
    private GraphInformation graphInfo = null;
    private GraphComponentInterface[] components = null;
    private GraphComponentAttrs[] gca = null;
    NLDRect globalBounds = null;
    private double oldxm;
    private double oldym;
    private double oldxd;
    private double oldyd;
    private double newxm;
    private double newym;
    private double newxd;
    private double newyd;

    public GRIPLayout(DataFilterModel model) {
        this.model = model;
        this.graphInfo = new GraphInformation(model);
        this.globalBounds = new NLDRect(0, 0, 900, 600);
    }

    public void doGRIPLayout() {
        boolean plotAllVert = false;
        int numOfInitVert = 3;
        int initRounds = 20;
        int finalRounds = 30;
        double bounds = 50.0;
        this.components = this.getGraphComponents(this.graphInfo);
        int numberOfComponents = this.components.length;
        this.gca = this.initializeGraphComponents((GraphComponent[])this.components, numberOfComponents, 2, numOfInitVert, false, false, 0, 1, plotAllVert, initRounds, finalRounds, 1, 0.1f, 0.1f, bounds);
        for (int i = 0; i < numberOfComponents; ++i) {
            this.misfEngine((GraphComponent)this.components[i], this.gca[i], 0.17, finalRounds, true, 3.0f, 0.15f, bounds);
        }
        if (numberOfComponents > 1) {
            this.adjustComponentPositions((GraphComponent[])this.components, this.gca);
        }
    }

    private GraphComponentInterface[] getGraphComponents(GraphInformation graph) {
        int i;
        int numOfVert = graph.getNumberNodes();
        NodeSplitMap[] nodeMap = new NodeSplitMap[numOfVert];
        for (int i2 = 0; i2 < nodeMap.length; ++i2) {
            nodeMap[i2] = new NodeSplitMap();
            nodeMap[i2].comp = -1;
        }
        int currentAdjacencyList = 0;
        for (int vert = 0; vert < numOfVert; ++vert) {
            if (nodeMap[vert].comp != -1) continue;
            int[] processed = this.bfs(graph, vert, numOfVert);
            int currPosition = 0;
            nodeMap[vert].comp = currentAdjacencyList;
            nodeMap[vert].vert = currPosition++;
            for (int index = vert + 1; index < numOfVert; ++index) {
                if (processed[index] != 1) continue;
                nodeMap[index].comp = currentAdjacencyList;
                nodeMap[index].vert = currPosition++;
            }
            ++currentAdjacencyList;
        }
        if (currentAdjacencyList == 1) {
            GraphComponent gc = new GraphComponent();
            gc.setNumberOfVertices(this.graphInfo.getNumberNodes());
            gc.setAdjacencyList(this.graphInfo.getAdjacencyList());
            int[] vertexList = new int[numOfVert];
            for (i = 0; i < numOfVert; ++i) {
                vertexList[i] = i;
            }
            gc.setVertexList(vertexList);
            return new GraphComponent[]{gc};
        }
        int[] numVertAdjList = new int[currentAdjacencyList];
        for (int i3 = 0; i3 < currentAdjacencyList; ++i3) {
            numVertAdjList[i3] = 0;
        }
        for (int vert = 0; vert < numOfVert; ++vert) {
            int n = nodeMap[vert].comp;
            numVertAdjList[n] = numVertAdjList[n] + 1;
        }
        int[][] vertexList = new int[currentAdjacencyList][];
        for (i = 0; i < currentAdjacencyList; ++i) {
            vertexList[i] = new int[numVertAdjList[i]];
        }
        for (int vert = 0; vert < numOfVert; ++vert) {
            vertexList[nodeMap[vert].comp][nodeMap[vert].vert] = vert;
        }
        GraphComponentInterface[] graphComponents = new GraphComponent[currentAdjacencyList];
        for (int i4 = 0; i4 < currentAdjacencyList; ++i4) {
            graphComponents[i4] = new GraphComponent();
            ((GraphComponent)graphComponents[i4]).setNumberOfVertices(numVertAdjList[i4]);
            ((GraphComponent)graphComponents[i4]).setVertexList(vertexList[i4]);
        }
        for (int vert = 0; vert < numOfVert; ++vert) {
            int adjListNum = nodeMap[vert].comp;
            if (adjListNum == -1) continue;
            int newVert = nodeMap[vert].vert;
            int numAdjVert = graph.getDegree(vert);
            Vector<AdjacencyInfo> newAdjList = new Vector<AdjacencyInfo>();
            for (int i5 = 0; i5 < numAdjVert; ++i5) {
                AdjacencyInfo oldAdjInfo = graph.getAdjacencyInfo(vert, i5);
                int adjVert = oldAdjInfo.getNodeIndex();
                AdjacencyInfo newAdjInfo = new AdjacencyInfo(nodeMap[adjVert].vert, oldAdjInfo.getLinkIndex());
                newAdjList.addElement(newAdjInfo);
            }
            ((GraphComponent)graphComponents[adjListNum]).setAdjacencyList(newVert, newAdjList);
        }
        return graphComponents;
    }

    private int[] createBFS(GraphComponentInterface graphComponent, int[] vertices, int numVert, int level, int[] vertDepth) {
        int count;
        int depthLim = (int)Math.pow(2.0, level);
        int numKept = 0;
        int[] marked = new int[graphComponent.getNumberNodes() + 1];
        this.diam = 0;
        for (count = 0; count <= graphComponent.getNumberNodes(); ++count) {
            marked[count] = -1;
        }
        for (count = 0; count < graphComponent.getNumberNodes(); ++count) {
            if (marked[count + 1] != -1) continue;
            int[] processed = this.bfs(graphComponent, vertices[count], depthLim);
            marked[count + 1] = 1;
            ++numKept;
            for (int index = count + 1; index < graphComponent.getNumberNodes(); ++index) {
                if (processed[vertices[index]] != 1) continue;
                marked[index + 1] = 0;
            }
        }
        marked[0] = numKept;
        return marked;
    }

    private int[] bfs(GraphComponentInterface graphComponent, int root, int depthLimit) {
        GraphComponent gc;
        int[] color = new int[graphComponent.getNumberNodes()];
        IntegerQueue vertQ = new IntegerQueue(graphComponent.getNumberNodes(), 0);
        IntegerQueue depthQ = new IntegerQueue(graphComponent.getNumberNodes(), 0);
        for (int count = 0; count < graphComponent.getNumberNodes(); ++count) {
            color[count] = 0;
        }
        int currentDepth = 1;
        int vert = root;
        while (currentDepth <= depthLimit + 1) {
            color[vert] = 1;
            int deg = graphComponent.getDegree(vert);
            for (int count = 0; count < deg; ++count) {
                int adjVert = graphComponent.getAdjacentVertex(vert, count);
                if (adjVert < 0 || color[adjVert] != 0) continue;
                color[adjVert] = -1;
                vertQ.enqueue(adjVert);
                depthQ.enqueue(currentDepth);
            }
            if (vertQ.size() <= 0) break;
            vert = vertQ.dequeue();
            currentDepth = depthQ.dequeue() + 1;
        }
        if (this.diam < currentDepth) {
            this.diam = currentDepth;
        }
        if (graphComponent instanceof GraphComponent && (gc = (GraphComponent)graphComponent).getDiameter() < currentDepth) {
            gc.setDiameter(this.diam);
        }
        vertQ.freeQueue();
        depthQ.freeQueue();
        return color;
    }

    private int[] randomBFS(int[] vertices, int numVert) {
        int[] marked = new int[numVert + 1];
        int numKept = numVert;
        Random random = new Random(System.currentTimeMillis());
        while (numKept == numVert) {
            numKept = 0;
            for (int count = 1; count <= numVert; ++count) {
                int randNum = random.nextInt() % 5;
                if (randNum % 2 == 0) {
                    marked[count] = 1;
                    ++numKept;
                    continue;
                }
                marked[count] = 0;
            }
        }
        marked[0] = numKept;
        return marked;
    }

    private int[][] nbr_bfs(GraphComponentInterface graphComponent, int root, int[][][] nbrs, int[] nbr, int[] vertDepth) {
        int count;
        int i;
        int[] color = new int[graphComponent.getNumberNodes()];
        IntegerQueue vertQ = new IntegerQueue(2 * graphComponent.getNumberNodes(), 10);
        int bottomNbrsLayer = 0;
        int[] nbrCounter = new int[vertDepth[root] + 1];
        int numOfCloseVert = 3;
        int closeVertItr = 0;
        boolean closeVertDone = false;
        int[][] closeVert = new int[numOfCloseVert][2];
        nbrs[root] = new int[vertDepth[root] + 2][];
        for (i = 0; i <= vertDepth[root]; ++i) {
            nbrs[root][i] = new int[2 * nbr[i]];
            nbrCounter[i] = 0;
        }
        for (count = 0; count < graphComponent.getNumberNodes(); ++count) {
            color[count] = 0;
        }
        int currDist = 32;
        int vert = root;
        do {
            color[vert] = 1;
            int deg = graphComponent.getDegree(vert);
            for (count = 0; count < deg; ++count) {
                int adjVert = graphComponent.getAdjacentVertex(vert, count);
                if (adjVert < 0 || color[adjVert] != 0) continue;
                color[adjVert] = -1;
                vertQ.enqueue(adjVert);
                vertQ.enqueue(currDist);
                for (i = bottomNbrsLayer; i <= Math.min(vertDepth[adjVert], vertDepth[root]); ++i) {
                    if (nbrCounter[i] < 2 * nbr[i]) {
                        int n = i;
                        int n2 = nbrCounter[n];
                        nbrCounter[n] = n2 + 1;
                        nbrs[root][i][n2] = adjVert;
                        int n3 = i;
                        int n4 = nbrCounter[n3];
                        nbrCounter[n3] = n4 + 1;
                        nbrs[root][i][n4] = currDist;
                        continue;
                    }
                    bottomNbrsLayer = i + 1;
                }
                if (closeVertDone || closeVertItr >= numOfCloseVert || vertDepth[adjVert] <= vertDepth[root]) continue;
                closeVert[closeVertItr][1] = currDist;
                closeVert[closeVertItr++][0] = adjVert;
                if (closeVertItr != numOfCloseVert) continue;
                closeVertDone = true;
            }
            if (vertQ.size() <= 0) break;
            vert = vertQ.dequeue();
            currDist = vertQ.dequeue() + 32;
        } while ((!closeVertDone || bottomNbrsLayer <= vertDepth[root]) && vertQ.size() >= 0);
        vertQ.freeQueue();
        return closeVert;
    }

    private static void DEBUG(String s) {
        if (DEBUG_MODE) {
            System.out.println(s);
        }
    }

    public GraphDistance[] nbr_dijkstra(GraphComponentInterface graphComponent, int root, GraphDistance[][][] nbrs, int[] nbr, int[] vertDepth) {
        int[] color = new int[graphComponent.getNumberNodes()];
        PQueue vertQ = new PQueue(graphComponent.getNumberNodes());
        int bottomNbrsLayer = 0;
        int[] nbrCounter = new int[vertDepth[root] + 1];
        int numOfCloseVert = 3;
        int closeVertItr = 0;
        boolean closeVertDone = false;
        GraphDistance[] closeVert = new GraphDistance[numOfCloseVert];
        nbrs[root] = new GraphDistance[vertDepth[root] + 2][];
        for (int i = 0; i <= vertDepth[root]; ++i) {
            nbrs[root][i] = new GraphDistance[nbr[i]];
            nbrCounter[i] = 0;
        }
        for (int count = 0; count < graphComponent.getNumberNodes(); ++count) {
            color[count] = 0;
        }
        vertQ.enqueue(root, 0.0);
        GraphDistance gd = new GraphDistance();
        while (!(vertQ.getCount() <= 0 || closeVertDone && bottomNbrsLayer > vertDepth[root])) {
            int vert = vertQ.dequeueMin(gd);
            if (color[vert] == 1) continue;
            if (vert != root) {
                for (int i = bottomNbrsLayer; i <= Math.min(vertDepth[vert], vertDepth[root]); ++i) {
                    if (nbrCounter[i] < nbr[i]) {
                        if (nbrs[root][i][nbrCounter[i]] == null) {
                            nbrs[root][i][nbrCounter[i]] = new GraphDistance();
                        }
                        nbrs[root][i][nbrCounter[i]].setVertex(vert);
                        nbrs[root][i][nbrCounter[i]].setDistance(gd.getDistance());
                        int n = i;
                        nbrCounter[n] = nbrCounter[n] + 1;
                        continue;
                    }
                    bottomNbrsLayer = i + 1;
                }
                if (!closeVertDone && vertDepth[vert] > vertDepth[root]) {
                    if (closeVert[closeVertItr] == null) {
                        closeVert[closeVertItr] = new GraphDistance();
                    }
                    closeVert[closeVertItr].setDistance(gd.getDistance());
                    closeVert[closeVertItr].setVertex(vert);
                    if (++closeVertItr == numOfCloseVert) {
                        closeVertDone = true;
                    }
                }
            }
            color[vert] = 1;
            int deg = graphComponent.getDegree(vert);
            for (int count = 0; count < deg; ++count) {
                int adjVert = graphComponent.getAdjacentVertex(vert, count);
                if (adjVert < 0 || color[adjVert] == 1) continue;
                double distVertToNbr = graphComponent.getLinkWeight(vert, count);
                vertQ.enqueue(adjVert, distVertToNbr + gd.getDistance());
            }
        }
        vertQ.freeQueue();
        return closeVert;
    }

    public MISF createMISF(GraphComponentInterface graphComponent, boolean useRandom, int numOfInitialVertices, boolean skipFiltration, int[] vertDepth) {
        int numOfVert = graphComponent.getNumberNodes();
        int log2n = (int)(Math.log(numOfVert) / Math.log(2.0)) + 2;
        int[] misf = new int[numOfVert];
        MISF result = new MISF();
        for (int count = 0; count < numOfVert; ++count) {
            misf[count] = count;
            vertDepth[count] = 0;
        }
        this.diam = (int)Math.sqrt(numOfVert);
        if (skipFiltration) {
            result.setDepth(1);
            result.setSize(new int[]{numOfVert});
            result.setFilterList(misf);
            return result;
        }
        this.orderByDegree(graphComponent, misf, numOfVert);
        int[] misfSize = new int[log2n];
        misfSize[0] = graphComponent.getNumberNodes();
        for (int level = 1; level < log2n; ++level) {
            int prev_misfSize = misfSize[level - 1];
            int[] marked = null;
            marked = useRandom ? this.randomBFS(misf, prev_misfSize) : this.createBFS(graphComponent, misf, prev_misfSize, level, vertDepth);
            misfSize[level] = marked[0];
            int misfIndex = 0;
            for (int markedIndex = 1; misfIndex <= misfSize[level - 1] && markedIndex < marked.length; ++markedIndex) {
                if (marked[markedIndex] != 1) continue;
                vertDepth[misf[markedIndex - 1]] = level;
                int temp = misf[misfIndex];
                misf[misfIndex] = misf[markedIndex - 1];
                misf[markedIndex - 1] = temp;
                ++misfIndex;
            }
            if (misfSize[level] >= numOfInitialVertices + 1) continue;
            for (int count = misfSize[level]; count < numOfInitialVertices; ++count) {
                vertDepth[misf[count]] = level;
            }
            misfSize[level] = numOfInitialVertices;
            log2n = level + 1;
        }
        if (misfSize[log2n - 1] > numOfInitialVertices) {
            for (int count = numOfInitialVertices; count < misfSize[log2n - 1]; ++count) {
                vertDepth[misf[count]] = log2n - 2;
            }
            misfSize[log2n - 1] = numOfInitialVertices;
        }
        result.setDepth(log2n);
        result.setSize(misfSize);
        result.setFilterList(misf);
        return result;
    }

    private void orderByDegree(GraphComponentInterface graphComponent, int[] misf, int numOfVert) {
        int position;
        int degree;
        int vert;
        int index;
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int vert2 = 0; vert2 < numOfVert; ++vert2) {
            int d = graphComponent.getDegree(vert2);
            min = Math.min(min, d);
            max = Math.max(max, d);
        }
        int[] offset = new int[max + 1];
        int[] degreeProcessed = new int[max + 1];
        int[] numDegree = new int[max + 1];
        for (index = 0; index <= max; ++index) {
            numDegree[index] = 0;
            degreeProcessed[index] = 0;
        }
        for (vert = 0; vert < numOfVert; ++vert) {
            int n = graphComponent.getDegree(vert);
            numDegree[n] = numDegree[n] + 1;
        }
        offset[0] = 0;
        offset[1] = 0;
        for (index = 2; index <= max; ++index) {
            offset[index] = offset[index - 1] + numDegree[index - 1];
        }
        offset[0] = offset[max] + numDegree[max];
        vert = 0;
        while (vert < numOfVert) {
            degree = graphComponent.getDegree(vert);
            position = offset[degree] + degreeProcessed[degree];
            misf[position] = vert++;
            int n = degree;
            degreeProcessed[n] = degreeProcessed[n] + 1;
        }
        int i = 0;
        while (i < numOfVert) {
            degree = graphComponent.getDegree(i);
            position = numOfVert - offset[degree] - degreeProcessed[degree];
            misf[position] = i++;
            int n = degree;
            degreeProcessed[n] = degreeProcessed[n] - 1;
        }
    }

    private GraphComponentAttrs[] initializeGraphComponents(GraphComponent[] graphComponents, int numComponents, int dim, int _numOfInitVert, boolean displayPar, boolean randBFS, int FR_full, int FR_levels, boolean plotAllVert, int initRounds, int finalRounds, int heat_fraction, float r, float s, double bounds) {
        double temp = this.getAverageWeightOfEdge(graphComponents, numComponents);
        int totalNNodes = this.graphInfo.getNumberNodes();
        double edge = (int)temp;
        if (Double.isNaN(temp)) {
            int compW = this.globalBounds.width();
            int compH = this.globalBounds.height();
            edge = (int)Math.sqrt(compW * compH / totalNNodes);
        }
        GraphComponentAttrs[] result = new GraphComponentAttrs[numComponents];
        int numOfInitVert = 3;
        for (int currComponent = 0; currComponent < numComponents; ++currComponent) {
            GraphComponent graph = graphComponents[currComponent];
            int numOfVert = graph.getNumberNodes();
            double tInit = edge / 6.0;
            numOfInitVert = Math.min(numOfInitVert, _numOfInitVert);
            int[] vertDepth = new int[numOfVert];
            boolean skipFilteration = false;
            if (numOfVert < 3) {
                skipFilteration = true;
            }
            MISF misf = this.createMISF(graph, randBFS, numOfInitVert, skipFilteration, vertDepth);
            GRIPLayout.DEBUG("MISF for graph " + currComponent + " = " + misf);
            int d = graph.getDiameter() == 0 ? this.diam : graph.getDiameter();
            Point[] pos = new Point[numOfVert];
            for (int i = 0; i < numOfVert; ++i) {
                pos[i] = this.getRandomPoint(bounds);
            }
            GraphComponentAttrs gca = new GraphComponentAttrs(misf, d, edge, misf.getDepth() - 1, numOfInitVert, displayPar, false, true, 0, initRounds, true, numOfVert, plotAllVert, tInit, pos);
            gca.setVertDepth(vertDepth);
            int[] nbr = this.setNBRSize(numOfVert, graph, misf.getDepth(), misf.getSize(), numOfInitVert);
            gca.setNbr(nbr);
            result[currComponent] = gca;
        }
        return result;
    }

    private double getAverageWeightOfEdge(GraphComponent[] graphComponents, int numComponents) {
        int totalNNodes = this.graphInfo.getNumberNodes();
        if (totalNNodes > LARGE_N_NODE || totalNNodes < VERY_SMALL_N_NODE) {
            return 36.0;
        }
        return Double.NaN;
    }

    private int[] setNBRSize(int numOfVert, GraphComponent graph, int misfDepth, int[] misfSize, int numOfInitVert) {
        int itr;
        double avgDeg = 0.0;
        int maxCxty = 0;
        int initCxty = 10000;
        int smallLevel = 0;
        int visNodeCount = 0;
        for (int vert = 0; vert < numOfVert; ++vert) {
            avgDeg += (double)graph.getDegree(vert);
            ++visNodeCount;
        }
        maxCxty = (int)avgDeg;
        if (maxCxty < initCxty) {
            maxCxty = initCxty;
        }
        avgDeg /= (double)visNodeCount;
        for (itr = 0; itr < misfDepth && misfSize[itr] > 0; ++itr) {
            if (!((double)misfSize[itr] * (double)misfSize[itr] - (double)initCxty <= 0.0)) continue;
            smallLevel = itr;
            break;
        }
        int[] nbr = new int[misfDepth];
        for (itr = 0; itr < misfDepth && misfSize[itr] > 0; ++itr) {
            nbr[itr] = itr >= smallLevel ? Math.max(misfSize[itr] - 1, numOfInitVert - 1) : (int)Math.min(this.sched(itr, 0, 2, 10000, 1) * (double)maxCxty / (double)misfSize[itr], (double)(misfSize[itr] - 1));
        }
        nbr[0] = Math.min(2 * nbr[0], visNodeCount - 1);
        return nbr;
    }

    double sched(int x, int max, int maxVal, int min, int minVal) {
        if (x <= max) {
            return maxVal;
        }
        if (max <= x && x <= min) {
            return (double)(minVal - maxVal) / (double)(min - max) * (double)(x - max) + (double)maxVal;
        }
        return minVal;
    }

    int sched3(int x, int max, int maxVal, int min, int minVal) {
        if (x <= max) {
            return maxVal;
        }
        if (max <= x && x <= min) {
            double k = -Math.log((double)minVal / (double)maxVal) / (double)min;
            return (int)Math.ceil((double)maxVal * Math.exp(-k * (double)x));
        }
        return minVal;
    }

    private void misfEngine(GraphComponent gc, GraphComponentAttrs gca, double heatFraction, int finalRounds, boolean displayPar, float s, float r, double bounds) {
        if (gc.getNumberNodes() < 3) {
            return;
        }
        boolean loop = true;
        int edge = (int)gca.getEdge();
        double tInit = edge / 6;
        GRIPLayout.DEBUG("misfEngine(): roundsCtr=" + gca.getRoundsCtr() + " rounds=" + gca.getRounds());
        int numOfVert = gc.getNumberNodes();
        int[] misf = gca.getMisf().getFilterList();
        int roundsCtr = gca.getRoundsCtr();
        int currLevel = gca.getCurrLevel();
        int rounds = 20;
        int[] misfSize = gca.getMisf().getSize();
        int misfDepth = gca.getMisf().getDepth();
        int numOfInitVert = gca.getNumOfInitVert();
        long dTime = 0L;
        long reInitTime = 0L;
        long refineTime = 0L;
        long springKKTime = 0L;
        while (currLevel >= 0) {
            int currVert;
            GRIPLayout.DEBUG("DrawGraph: current level is " + currLevel + " with size " + misfSize[currLevel]);
            if (displayPar) {
                loop = false;
            }
            GraphDistance[] closeVert = null;
            int itr = misfSize[currLevel];
            if (currLevel == misfDepth - 1 && gca.getFirstRound()) {
                int i;
                Point baricenter = new Point(0.0, 0.0);
                gca.setFirstRound(false);
                for (i = 0; i < numOfInitVert; ++i) {
                    currVert = misf[i];
                    gca.getPosition()[currVert].setValue(this.getRandomPoint(bounds));
                    long t1 = System.currentTimeMillis();
                    closeVert = this.nbr_dijkstra(gc, currVert, gca.getNbrs(), gca.getNbr(), gca.getVertDepth());
                    long t2 = System.currentTimeMillis();
                    dTime += t2 - t1;
                }
                for (i = 0; i < itr; ++i) {
                    baricenter.add(gca.getPosition()[misf[i]], baricenter);
                }
                baricenter.divide(3.0, baricenter);
                for (i = 0; i < itr; ++i) {
                    gca.getPosition()[misf[i]].subtract(baricenter, gca.getPosition()[misf[i]]);
                }
            }
            long t1 = System.currentTimeMillis();
            if (roundsCtr == rounds) {
                for (int i = 0; i < itr; ++i) {
                    gca.getNbrs()[misf[i]][currLevel] = null;
                }
                --currLevel;
                if (itr == numOfVert) break;
                roundsCtr = 0;
                rounds = this.sched3(misfSize[currLevel], 0, gca.getRounds(), numOfVert, finalRounds);
                for (int vert = 0; vert < itr; ++vert) {
                    gca.getHeat()[misf[vert]] = tInit;
                }
                while (itr < misfSize[currLevel]) {
                    currVert = misf[itr];
                    closeVert = this.nbr_dijkstra(gc, currVert, gca.getNbrs(), gca.getNbr(), gca.getVertDepth());
                    gca.getPosition()[currVert].setValue(gca.getPosition()[closeVert[0].getVertex()]);
                    gca.getPosition()[currVert].add(gca.getPosition()[closeVert[1].getVertex()], gca.getPosition()[currVert]);
                    gca.getPosition()[currVert].add(gca.getPosition()[closeVert[2].getVertex()], gca.getPosition()[currVert]);
                    gca.getPosition()[currVert].divide(3.0, gca.getPosition()[currVert]);
                    gca.getOldDisplacement()[currVert].add(gca.getOldDisplacement()[closeVert[0].getVertex()], gca.getOldDisplacement()[currVert]);
                    gca.getOldDisplacement()[currVert].add(gca.getOldDisplacement()[closeVert[1].getVertex()], gca.getOldDisplacement()[currVert]);
                    gca.getOldDisplacement()[currVert].add(gca.getOldDisplacement()[closeVert[2].getVertex()], gca.getOldDisplacement()[currVert]);
                    gca.getOldDisplacement()[currVert].divide(3.0, gca.getOldDisplacement()[currVert]);
                    gca.getOldDisplacementNorm()[currVert] = gca.getOldDisplacement()[currVert].distance(null);
                    int count = 0;
                    while (count++ < 3) {
                        this.springKKLocal(currVert, gca, closeVert, 3);
                        this.updateLocalTemp(currVert, gca);
                        gca.getOldDisplacement()[currVert].setValue(gca.getDisplacement()[currVert]);
                        gca.getOldDisplacementNorm()[currVert] = gca.getDisplacementNorm()[currVert];
                        gca.getDisplacement()[currVert].multiply(gca.getHeat()[currVert], gca.getDisplacement()[currVert]);
                        if (gca.getDisplacementNorm()[currVert] != 0.0) {
                            gca.getDisplacement()[currVert].divide(gca.getDisplacementNorm()[currVert], gca.getDisplacement()[currVert]);
                        }
                        gca.getPosition()[currVert].add(gca.getDisplacement()[currVert], gca.getPosition()[currVert]);
                    }
                    ++itr;
                }
            }
            long t2 = System.currentTimeMillis();
            reInitTime += t2 - t1;
            t1 = System.currentTimeMillis();
            if (roundsCtr++ < rounds) {
                int i;
                for (i = 0; i < itr; ++i) {
                    long ta = System.currentTimeMillis();
                    if (currLevel < 1) {
                        if (gc.getNumberNodes() < LARGE_N_NODE) {
                            this.springFullFR(misf[i], gc, gca);
                        } else {
                            this.springFR(misf[i], gca.getNbrs()[misf[i]][currLevel], currLevel, gc, gca);
                        }
                    } else {
                        this.springKK(misf[i], gca.getNbrs()[misf[i]][currLevel], currLevel, gca);
                    }
                    long tb = System.currentTimeMillis();
                    springKKTime += tb - ta;
                    this.updateLocalTemp(misf[i], gca);
                    gca.getOldDisplacement()[misf[i]].setValue(gca.getDisplacement()[misf[i]]);
                    gca.getOldDisplacementNorm()[misf[i]] = gca.getDisplacementNorm()[misf[i]];
                    gca.getDisplacement()[misf[i]].multiply(gca.getHeat()[misf[i]], gca.getDisplacement()[misf[i]]);
                    if (gca.getDisplacementNorm()[misf[i]] == 0.0) continue;
                    gca.getDisplacement()[misf[i]].divide(gca.getDisplacementNorm()[misf[i]], gca.getDisplacement()[misf[i]]);
                }
                for (i = 0; i < itr; ++i) {
                    gca.getPosition()[misf[i]].add(gca.getDisplacement()[misf[i]], gca.getPosition()[misf[i]]);
                }
            }
            t2 = System.currentTimeMillis();
            refineTime += t2 - t1;
        }
        boolean createList = false;
        if (loop && gca.isCreateListSwitch()) {
            createList = true;
            gca.setCreateListSwitch(false);
        }
        gca.setCurrLevel(currLevel);
        gca.setCreateList(gca.isCreateList() || createList);
        gca.setRoundsCtr(roundsCtr);
        gca.setRounds(rounds);
    }

    private void updateLocalTemp(int vert, float r, float s, GraphComponentAttrs gca) {
        double temp = gca.getHeat()[vert];
        double normOldDisp = gca.getOldDisplacementNorm()[vert];
        double normNewDisp = gca.getDisplacementNorm()[vert];
        if (normOldDisp != 0.0 && normNewDisp != 0.0) {
            double scalProd = gca.getDisplacement()[vert].scalarProduct(gca.getOldDisplacement()[vert]);
            double cos = scalProd / (normOldDisp * normNewDisp);
            temp = gca.getOldCos()[vert] * cos > 0.0 ? (temp += temp * (double)s * cos * (double)r) : (temp += temp * cos * (double)r);
            gca.getOldCos()[vert] = cos;
            gca.getHeat()[vert] = temp;
        }
        GRIPLayout.DEBUG("Heat[" + vert + "]=" + temp);
    }

    private void updateLocalTemp(int vert, GraphComponentAttrs gca) {
        double temp = gca.getHeat()[vert];
        double normOldDisp = gca.getOldDisplacementNorm()[vert];
        double normNewDisp = gca.getDisplacementNorm()[vert];
        if (normOldDisp != 0.0 && normNewDisp != 0.0) {
            double scalProd = gca.getDisplacement()[vert].scalarProduct(gca.getOldDisplacement()[vert]);
            double cos = scalProd / (normOldDisp * normNewDisp);
            double r = 0.15;
            double s = 3.0;
            temp = gca.getOldCos()[vert] * cos > 0.0 ? (temp += temp * s * cos * r) : (temp += temp * cos * r);
            gca.getOldCos()[vert] = cos;
            gca.getHeat()[vert] = temp;
        }
        GRIPLayout.DEBUG("Heat[" + vert + "]=" + temp);
    }

    private void springFullFR(int vert, GraphComponent graph, GraphComponentAttrs gca) {
        double norm2;
        int otherVertex;
        Point[] disp = gca.getDisplacement();
        disp[vert].setValue(0.0, 0.0);
        Point vect = new Point(0.0, 0.0);
        double edge = gca.getEdge();
        double fedge2 = 0.1 * edge * edge;
        Point displacement = gca.getDisplacement()[vert];
        int degree = graph.getDegree(vert);
        for (int adjVert = 0; adjVert < degree; ++adjVert) {
            otherVertex = graph.getAdjacentVertex(vert, adjVert);
            if (otherVertex < 0) continue;
            vect.setValue(0.0, 0.0);
            vect.add(gca.getPosition()[otherVertex], vect);
            vect.subtract(gca.getPosition()[vert], vect);
            norm2 = vect.distanceSq(0.0, 0.0);
            vect.multiply(norm2 / (edge * edge), vect);
            displacement.add(vect, displacement);
        }
        int numOfVert = graph.getNumberNodes();
        for (int i = 0; i < numOfVert; ++i) {
            if (i == vert) continue;
            otherVertex = i;
            vect.setValue(0.0, 0.0);
            vect.add(gca.getPosition()[vert], vect);
            vect.subtract(gca.getPosition()[otherVertex], vect);
            norm2 = vect.distanceSq(0.0, 0.0);
            if (norm2 == 0.0) {
                int x = this.random.nextInt() % 2;
                int y = this.random.nextInt() % 2;
                norm2 = 0.01;
                vect.setValue(x, y);
            }
            vect.multiply(fedge2 / norm2, vect);
            displacement.add(vect, displacement);
        }
        double norm = displacement.distance(0.0, 0.0);
        int intNorm = 0;
        intNorm = norm > 0.0 ? (int)Math.floor(norm + 0.5) : -((int)Math.floor(0.5 - norm));
        gca.getDisplacementNorm()[vert] = intNorm;
        if (gca.getDisplacementNorm()[vert] != 0.0) {
            displacement.multiply(edge / norm, displacement);
            gca.getDisplacementNorm()[vert] = displacement.distance(0.0, 0.0);
        }
    }

    private void springFR(int vert, GraphDistance[] vertNbrs, int misfLayer, GraphComponent graph, GraphComponentAttrs gca) {
        double _norm2;
        int overt;
        double edge = gca.getEdge();
        double fedge2 = 0.03 * edge * edge;
        Point vect = new Point();
        gca.getDisplacement()[vert].setValue(0.0, 0.0);
        int deg = graph.getDegree(vert);
        for (int adjVert = 0; adjVert < deg; ++adjVert) {
            overt = graph.getAdjacentVertex(vert, adjVert);
            if (overt >= 0 && gca.getNbrs()[overt] == null) continue;
            vect.setValue(0.0, 0.0);
            vect.add(gca.getPosition()[overt], vect);
            vect.subtract(gca.getPosition()[vert], vect);
            _norm2 = vect.distanceSq(0.0, 0.0);
            vect.multiply(_norm2 / (edge * edge), vect);
            gca.getDisplacement()[vert].add(vect, gca.getDisplacement()[vert]);
        }
        int[] nbr = gca.getNbr();
        for (int i = 0; i < nbr[misfLayer]; ++i) {
            overt = vertNbrs[i].getVertex();
            vect.setValue(0.0, 0.0);
            vect.add(gca.getPosition()[vert], vect);
            vect.subtract(gca.getPosition()[overt], vect);
            _norm2 = vect.distanceSq(0.0, 0.0);
            if (_norm2 == 0.0) {
                int x = this.random.nextInt() % 2;
                int y = this.random.nextInt() % 2;
                _norm2 = 0.01;
                vect.setValue(x, y);
            }
            vect.multiply(fedge2 / _norm2, vect);
            gca.getDisplacement()[vert].add(vect, gca.getDisplacement()[vert]);
        }
        double _norm = gca.getDisplacement()[vert].distance(0.0, 0.0);
        int intNorm = 0;
        intNorm = _norm > 0.0 ? (int)Math.floor(_norm + 0.5) : -((int)Math.floor(0.5 - _norm));
        gca.getDisplacementNorm()[vert] = intNorm;
        GRIPLayout.DEBUG("dispNorm[" + vert + "]=" + gca.getDisplacementNorm()[vert]);
        if (gca.getDisplacementNorm()[vert] != 0.0) {
            gca.getDisplacement()[vert].multiply(edge / _norm, gca.getDisplacement()[vert]);
            gca.getDisplacementNorm()[vert] = gca.getDisplacement()[vert].distance(0.0, 0.0);
        }
        GRIPLayout.DEBUG("dispNorm[" + vert + "]=" + gca.getDisplacementNorm()[vert]);
        GRIPLayout.DEBUG("Leaving FR_spring()");
    }

    void springKK(int vert, GraphDistance[] vertNbrs, int misfLayer, GraphComponentAttrs gca) {
        GRIPLayout.DEBUG("Entering KK_spring()\n");
        gca.getDisplacement()[vert].setValue(0.0, 0.0);
        double edge = gca.getEdge();
        for (int i = 0; i < gca.getNbr()[misfLayer]; ++i) {
            if (vertNbrs == null || vertNbrs[i] == null) continue;
            int overt = vertNbrs[i].getVertex();
            double dist2 = vertNbrs[i].getDistance() * vertNbrs[i].getDistance();
            if (dist2 == 0.0) continue;
            Point vect = new Point();
            vect.add(gca.getPosition()[overt], vect);
            vect.subtract(gca.getPosition()[vert], vect);
            double _norm2 = vect.distanceSq(0.0, 0.0);
            vect.multiply(_norm2 / (dist2 * edge * edge) - 1.0, vect);
            gca.getDisplacement()[vert].add(vect, gca.getDisplacement()[vert]);
        }
        double _norm = gca.getDisplacement()[vert].distance(0.0, 0.0);
        int intNorm = 0;
        intNorm = _norm > 0.0 ? (int)Math.floor(_norm + 0.5) : -((int)Math.floor(0.5 - _norm));
        gca.getDisplacementNorm()[vert] = intNorm;
        if (intNorm != 0) {
            gca.getDisplacement()[vert].multiply(gca.getEdge() / _norm, gca.getDisplacement()[vert]);
            gca.getDisplacementNorm()[vert] = gca.getDisplacement()[vert].distance(0.0, 0.0);
        }
        GRIPLayout.DEBUG("Leaving KK_spring()");
    }

    void springKKLocal(int vert, GraphComponentAttrs gca, GraphDistance[] closeVert, int size) {
        GRIPLayout.DEBUG("Entering KK_spring_local()");
        gca.getDisplacement()[vert].setValue(0.0, 0.0);
        double edge = gca.getEdge();
        Point vect = new Point();
        for (int i = 0; i < size; ++i) {
            vect.setValue(0.0, 0.0);
            GRIPLayout.DEBUG("looking at close vert " + closeVert[i].getVertex() + " with dist " + closeVert[i].getDistance());
            gca.getPosition()[closeVert[i].getVertex()].subtract(gca.getPosition()[vert], vect);
            double _norm2 = vect.distanceSq(0.0, 0.0);
            vect.multiply(_norm2 / (closeVert[i].getDistance() * closeVert[i].getDistance() * edge * edge) - 1.0, vect);
            gca.getDisplacement()[vert].add(vect, gca.getDisplacement()[vert]);
        }
        gca.getDisplacementNorm()[vert] = gca.getDisplacement()[vert].distance(0.0, 0.0);
        GRIPLayout.DEBUG("Leaving KK_spring_local()");
    }

    public GraphComponentInterface[] getComponents() {
        return this.components;
    }

    public void setComponents(GraphComponentInterface[] components) {
        this.components = components;
    }

    public GraphComponentAttrs[] getGca() {
        return this.gca;
    }

    public void setGca(GraphComponentAttrs[] gca) {
        this.gca = gca;
    }

    private void adjustComponentPositions(GraphComponent[] gc, GraphComponentAttrs[] gca) {
        int nComponents = gca.length;
        int[] sortedComponentIndex = this.sortComponentsByDiameter(gca);
        Point[] componentOffset = new Point[nComponents];
        for (int i = 0; i < nComponents; ++i) {
            componentOffset[i] = new Point();
        }
        int centerRadius = (int)Math.round((double)gca[sortedComponentIndex[0]].getDiameter() * 1.5);
        boolean axis = true;
        boolean posDir = true;
        int lastMax = 0;
        double lastCoord = 0.0;
        for (int counter = 1; counter < nComponents; ++counter) {
            GraphComponentAttrs oneGCA = gca[sortedComponentIndex[counter]];
            int diam = oneGCA.getDiameter();
            if (diam == 1) continue;
            if (diam > lastMax) {
                lastMax = diam;
            }
            lastCoord = posDir ? (lastCoord += (double)Math.round((double)diam * 1.5)) : (lastCoord -= (double)Math.round((double)diam * 1.5));
            double edge = oneGCA.getEdge();
            if (!axis) {
                componentOffset[sortedComponentIndex[counter]].setValue(lastCoord * edge, (double)centerRadius * edge);
            } else if (axis) {
                componentOffset[sortedComponentIndex[counter]].setValue((double)centerRadius * edge, lastCoord * edge);
            }
            if (posDir) {
                if ((double)centerRadius > 0.0) {
                    axis = false;
                    posDir = false;
                    lastCoord = 0.0;
                    continue;
                }
                centerRadius *= -1;
                axis = true;
                posDir = true;
                lastCoord = 0.0;
                centerRadius += lastMax + 2;
                lastMax = 0;
                continue;
            }
            if (centerRadius > 0) {
                centerRadius *= -1;
                axis = false;
                posDir = false;
                lastCoord = 0.0;
                continue;
            }
            axis = false;
            posDir = true;
            lastCoord = 0.0;
        }
        for (int i = 1; i < nComponents; ++i) {
            Point[] pos = gca[sortedComponentIndex[i]].getPosition();
            for (int j = 0; j < pos.length; ++j) {
                pos[j].add(componentOffset[sortedComponentIndex[i]], pos[j]);
            }
        }
    }

    private int[] sortComponentsByDiameter(GraphComponentAttrs[] gc) {
        int i;
        int nComponents = gc.length;
        int maxDiameter = 0;
        for (int i2 = 0; i2 < gc.length; ++i2) {
            maxDiameter = Math.max(maxDiameter, gc[i2].getDiameter());
        }
        int[] sortedComponents = new int[nComponents];
        int[] diameterCount = new int[maxDiameter + 1];
        int[] componentProcessed = new int[maxDiameter + 1];
        int[] offset = new int[maxDiameter + 1];
        for (i = 1; i <= maxDiameter; ++i) {
            diameterCount[i] = 0;
            componentProcessed[i] = 0;
        }
        for (i = 0; i < nComponents; ++i) {
            int n = gc[i].getDiameter();
            diameterCount[n] = diameterCount[n] + 1;
        }
        offset[maxDiameter] = 0;
        for (i = maxDiameter - 1; i >= 1; --i) {
            offset[i] = offset[i + 1] + diameterCount[i + 1];
        }
        i = 0;
        while (i < nComponents) {
            int diameter = gc[i].getDiameter();
            sortedComponents[offset[diameter] + componentProcessed[diameter]] = i++;
            int n = diameter;
            componentProcessed[n] = componentProcessed[n] + 1;
        }
        return sortedComponents;
    }

    public void updateModelPositions() {
        for (int i = 0; i < this.gca.length; ++i) {
            Point[] pos = this.gca[i].getPosition();
            int[] vertexList = ((GraphComponent)this.components[i]).getVertexList();
            for (int j = 0; j < pos.length; ++j) {
                NLDNode n = (NLDNode)this.model.nodes.get(vertexList[j]);
                n.setOrgXPosition(pos[j].getX());
                n.setOrgYPosition(pos[j].getY());
            }
        }
        this.calculateCentroid();
        this.applyTransf();
    }

    private boolean calculateCentroid() {
        double oldxmin = Double.POSITIVE_INFINITY;
        double oldxmax = Double.NEGATIVE_INFINITY;
        double oldymin = Double.POSITIVE_INFINITY;
        double oldymax = Double.NEGATIVE_INFINITY;
        int totalNNodes = this.graphInfo.getNumberNodes();
        int nodeCount = 0;
        for (int i = 0; i < totalNNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            if (!n.isVisible()) continue;
            ++nodeCount;
            double x = n.getXPosition();
            double y = n.getYPosition();
            if (i == 0) {
                oldxmin = oldxmax = x;
                oldymin = oldymax = y;
                continue;
            }
            oldxmin = Math.min(x, oldxmin);
            oldxmax = Math.max(x, oldxmax);
            oldymin = Math.min(y, oldymin);
            oldymax = Math.max(y, oldymax);
        }
        this.oldxm = (oldxmin + oldxmax) / 2.0;
        this.oldym = (oldymin + oldymax) / 2.0;
        this.oldxd = oldxmax - oldxmin;
        this.oldyd = oldymax - oldymin;
        double fac = 0.0;
        int visCount = this.graphInfo.getVisibleNodeCount();
        fac = visCount == 1 ? 0.01 : 0.6 + 0.1 * Math.min(2.0, Math.sqrt(nodeCount));
        double newxmin = -fac;
        double newxmax = fac;
        double newymin = -fac;
        double newymax = fac;
        this.newxm = (newxmin + newxmax) / 2.0;
        this.newym = (newymin + newymax) / 2.0;
        this.newxd = newxmax - newxmin;
        this.newyd = newymax - newymin;
        return true;
    }

    private void applyTransf() {
        double yexp;
        double xexp;
        double xshift = this.newxm - this.oldxm;
        double yshift = this.newym - this.oldym;
        int totalNNodes = this.graphInfo.getNumberNodes();
        int visCount = this.graphInfo.getVisibleNodeCount();
        if (visCount == 1) {
            xexp = this.newxd / (this.oldxd + 1.0);
            yexp = this.newyd / (this.oldyd + 1.0);
        } else {
            xexp = this.newxd / this.oldxd;
            yexp = this.newyd / this.oldyd;
        }
        double expand = Math.min(xexp, yexp);
        for (int i = 0; i < totalNNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            if (!n.isVisible()) continue;
            double x = n.getXPosition() + xshift;
            double y = n.getYPosition() + yshift;
            x = this.newxm + (x - this.newxm) * expand;
            y = this.newym + (y - this.newym) * expand;
            n.setCurXPosition(x);
            n.setCurYPosition(y);
        }
    }

    private Point getRandomPoint(double spaceBounds) {
        double x = this.pointRandom.nextDouble() * spaceBounds;
        double y = this.pointRandom.nextDouble() * spaceBounds;
        return new Point(x, y);
    }

    private class NodeSplitMap {
        int comp;
        int vert;

        private NodeSplitMap() {
        }
    }
}

