/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.constchart;

import com.sas.graphics.silk.constchart.ConstViewer;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.nld.DataFilterLinkModel;
import com.sas.graphics.silk.util.nld.DataFilterModel;
import com.sas.graphics.silk.util.nld.DataFilterNodeModel;
import com.sas.graphics.silk.util.nld.DvrLink;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.nld.NLD;
import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.VectorNodeModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;

public class DataFilterConstViewer
extends ConstViewer
implements GraphInterface {
    private static final long serialVersionUID = -1916305154519339163L;
    private GraphInterface giHandler;

    public DataFilterConstViewer() {
        this.initActionCmds();
        this.setSupport(0.0);
        this.setDefaultNodeSize(0.02);
    }

    public DataFilterConstViewer(NLDModel m) {
        super(m);
        this.initActionCmds();
        this.setSupport(0.0);
    }

    public DataFilterConstViewer(NLDModel m, GraphInterface giHandler) {
        this(m);
        this.giHandler = giHandler;
    }

    private void initActionCmds() {
        String[] nodeOptActionStrArray = new String[]{"NLD_SEL_CON_NODES", "NLD_SEL_ALL_CON_NODES", "NLD_SUBSET", "NLD_RESET"};
        this.setNodeOptionActionArray(nodeOptActionStrArray);
    }

    public void preProcessAutoLayout(boolean readDataAgain) {
        this.setDefaultArrowSize(0.05);
        this.setDefaultZoom(1.0);
        if (readDataAgain) {
            this.readDataValues();
        }
        this.resetView();
    }

    private void readDataValues() {
        DataFilterNodeModel nodes = null;
        if (this.model instanceof DataFilterModel && this.model.getNumNodes() > 0) {
            nodes = (DataFilterNodeModel)this.model.nodes;
        }
        if (nodes != null) {
            this.readNodeValue(nodes);
            this.readNodeSize(nodes);
            this.initNodeMinMaxValueColorSize();
            this.proj();
            for (int ind = 0; ind < this.numNodes; ++ind) {
                double value = nodes.getNumValue(7, ind);
                double scaledValue = this.minNodeVal == this.maxNodeVal ? 1.0 : 1.0 * (value - this.minNodeVal) / (this.maxNodeVal - this.minNodeVal);
                this.setNodeColor(scaledValue, ind, true);
                this.setNodeSize(scaledValue, ind, true);
                this.setNodeShape(ind, true);
                this.setNodeLabelTextColor(ind);
            }
        }
    }

    private boolean readNodeValue(DataFilterNodeModel nodes) {
        int roleValueIndex;
        if (nodes != null && (roleValueIndex = nodes.getPropertyIndex("Value")) >= 0 && roleValueIndex <= nodes.getNumberInputRoles()) {
            nodes.setNodeValues(nodes.getVariable(roleValueIndex), roleValueIndex);
            return true;
        }
        return false;
    }

    private boolean readNodeSize(DataFilterNodeModel nodes) {
        int roleSizeIndex;
        if (nodes != null && (roleSizeIndex = nodes.getPropertyIndex("Size")) >= 0 && roleSizeIndex <= nodes.getNumberInputRoles()) {
            nodes.setNodeValues(nodes.getVariable(roleSizeIndex), roleSizeIndex);
            return true;
        }
        return false;
    }

    public void preProcessUserLayout() {
        this.setDefaultArrowSize(15.0);
        this.setDefaultZoom(1.0);
        this.resetView();
        DataFilterNodeModel nodes = null;
        if (this.model instanceof DataFilterModel && this.model.getNumNodes() > 0) {
            nodes = (DataFilterNodeModel)this.model.nodes;
        }
        if (nodes != null) {
            boolean isXYRolePresent = false;
            int roleXIndex = nodes.getPropertyIndex("X");
            int roleYIndex = nodes.getPropertyIndex("Y");
            if (roleXIndex >= 0 && roleXIndex <= nodes.getNumberInputRoles() && roleYIndex >= 0 && roleYIndex <= nodes.getNumberInputRoles()) {
                nodes.setNodeValues(nodes.getVariable(roleXIndex), roleXIndex);
                nodes.setNodeValues(nodes.getVariable(roleYIndex), roleYIndex);
                isXYRolePresent = true;
            }
            if (isXYRolePresent) {
                if (this.sizeMapNodes) {
                    if (!this.readNodeSize(nodes)) {
                        this.rebuild(false);
                        this.unprojectNodes();
                    } else {
                        this.setNodeSizes();
                    }
                } else {
                    this.rebuild(false);
                    this.unprojectNodes();
                }
            }
        }
    }

    public Color colmap(double val) {
        if (val < 0.0 || val > 1.0) {
            return this.rampColors[0];
        }
        return super.colmap(val);
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        if (this.animStopIcon != null && this.animStopIcon.isMouseOverIcon(e.getX(), e.getY())) {
            if (this.isLayoutInterrupted()) {
                return;
            }
            this.setPauseLayout(true);
            this.model.setArrangeFirstTime(false);
            this.setCursor(this.actionMode);
            return;
        }
        if (this.preMousePressed(e)) {
            this.initMode(e);
            if (!this.actionModeValid || this.movenode) {
                this.postMousePressed(e);
            }
        }
        if (this.isAnimating() || this.model.isLayoutThreadAlive()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    protected synchronized void initMode(MouseEvent e) {
        if (this.actionModeValid) {
            switch (this.actionMode) {
                case 0: {
                    return;
                }
                case 1: {
                    this.brush = true;
                    return;
                }
                case 7: {
                    this.movenode = true;
                    return;
                }
                case 2: {
                    this.viewport = true;
                    return;
                }
                case 4: {
                    this.pan = true;
                    return;
                }
                case 3: {
                    this.zoom = true;
                    return;
                }
                case 6: {
                    if ((e.getModifiers() & 2) != 0) {
                        this.extsel = true;
                    } else {
                        this.select = true;
                    }
                    return;
                }
            }
            return;
        }
    }

    @Override
    protected boolean isSelRectDrawn(MouseEvent e) {
        if (this.pressNLDNode == null) {
            this.drawSelectionRect(e.getX(), e.getY());
            return true;
        }
        return false;
    }

    @Override
    protected boolean isNodeSelReq() {
        return this.pressNLDNode == null;
    }

    @Override
    protected void setNodeShape(int ind, boolean doShapemap) {
        Object shapeVobj = ((DataFilterNodeModel)this.model.nodes).getVariable(6);
        if (null != shapeVobj) {
            doShapemap = true;
            this.setShapeMappingNodes(true);
        } else {
            doShapemap = false;
            this.setShapeMappingNodes(false);
        }
        super.setNodeShape(ind, doShapemap);
    }

    @Override
    public void setNodeColor(double scaledValue, int ind, boolean doColmap) {
        Object colorVobj = ((DataFilterNodeModel)this.model.nodes).getVariable(4);
        Object valueVobj = ((DataFilterNodeModel)this.model.nodes).getVariable(7);
        if (null != colorVobj || null != valueVobj) {
            doColmap = false;
            this.setColorMappingNodes(true);
            if (null != colorVobj) {
                doColmap = true;
            }
        } else {
            doColmap = false;
            this.setColorMappingNodes(false);
        }
        super.setNodeColor(scaledValue, ind, doColmap);
    }

    @Override
    public void setLinkColor(double scaledValue, int ind, boolean doColmap) {
        Object colorVobj = ((DataFilterLinkModel)this.model.links).getVariable(7);
        Object valueVobj = ((DataFilterLinkModel)this.model.links).getVariable(6);
        if (null != colorVobj || null != valueVobj) {
            doColmap = false;
            this.setColorMappingLinks(true);
            if (null != colorVobj) {
                doColmap = true;
            }
        } else {
            doColmap = false;
            this.setColorMappingLinks(false);
        }
        super.setLinkColor(scaledValue, ind, doColmap);
    }

    @Override
    public void setLinkWidth(double scaledValue, int ind, boolean doWidthMap) {
        Object widthVobj = ((DataFilterLinkModel)this.model.links).getVariable(5);
        Object valueVobj = ((DataFilterLinkModel)this.model.links).getVariable(6);
        if (null != widthVobj || null != valueVobj) {
            doWidthMap = false;
            this.setWidthMappingLinks(true);
            if (null != widthVobj) {
                doWidthMap = true;
            }
        } else {
            doWidthMap = false;
            this.setWidthMappingLinks(false);
            scaledValue = this.defaultLinkWidth;
        }
        super.setLinkWidth(scaledValue, ind, doWidthMap);
    }

    @Override
    public void setNodeSize(double scaledValue, int ind, boolean doSizeMap) {
        Object sizeVobj = ((DataFilterNodeModel)this.model.nodes).getVariable(5);
        Object valueVobj = ((DataFilterNodeModel)this.model.nodes).getVariable(7);
        if (null != sizeVobj || null != valueVobj) {
            doSizeMap = false;
            this.setSizeMappingNodes(true);
            if (null != sizeVobj) {
                doSizeMap = true;
            }
        } else {
            doSizeMap = false;
            this.setSizeMappingNodes(false);
        }
        super.setNodeSize(scaledValue, ind, doSizeMap);
    }

    public void colormapLinks() {
        boolean doColmap = true;
        if (!(this.model.links instanceof DataFilterLinkModel)) {
            return;
        }
        if (this.minLinkVal == this.maxLinkVal && this.minLColVal == this.maxLColVal) {
            doColmap = false;
        }
        Object vobj = ((DataFilterLinkModel)this.model.links).getVariable(7);
        Object val_obj = ((DataFilterLinkModel)this.model.links).getVariable(6);
        Object iobj = ((DataFilterLinkModel)this.model.links).getVariable(0);
        double scaledColVal = 0.0;
        double scaledValue = 0.0;
        if (vobj != null) {
            DataFilterReadInterface linkFilter = ((DataFilterLinkModel)this.model.links).getFilter();
            int nLinksInFilter = linkFilter.getNumberObservations(-1);
            int linkIndex = 0;
            for (int filtrIdx = 0; filtrIdx < nLinksInFilter && linkIndex < this.numLinks; ++filtrIdx) {
                String filterLinkId;
                DvrLink l = (DvrLink)((Object)((DataFilterLinkModel)this.model.links).elementAt(linkIndex));
                String vecLinkId = l.getID();
                if (!vecLinkId.equalsIgnoreCase(filterLinkId = linkFilter.getValue(iobj, (long)filtrIdx).toString())) continue;
                int i = linkIndex;
                Object obj = linkFilter.getValue(vobj, (long)filtrIdx);
                Color c = this.getColor(obj);
                if (c != null) {
                    l.setColor(c);
                    this.linkColors[i] = c;
                } else if (linkFilter.isNumericVariable(vobj)) {
                    if (obj != null) {
                        double colval = ((Number)obj).doubleValue();
                        if (!Double.isNaN(colval)) {
                            l.setColorValue(colval);
                            scaledColVal = this.maxLColVal == this.minLColVal ? 1.0 : 1.0 * (colval - this.minLColVal) / (this.maxLColVal - this.minLColVal);
                            this.linkColors[i] = this.colmap(scaledColVal);
                        } else {
                            this.linkColors[i] = this.getLinkErrorColor();
                        }
                    } else {
                        this.linkColors[i] = this.getLinkErrorColor();
                    }
                    l.setColor(this.linkColors[i]);
                } else {
                    this.linkColors[i] = this.getLinkErrorColor();
                    l.setColor(this.linkColors[i]);
                }
                ++linkIndex;
            }
        } else if (val_obj != null) {
            double value = 0.0;
            double colval = 0.0;
            for (int i = 0; i < this.numLinks; ++i) {
                value = this.model.links.getNumValue(6, i);
                scaledValue = this.minLinkVal == this.maxLinkVal ? 1.0 : 1.0 * (value - this.minLinkVal) / (this.maxLinkVal - this.minLinkVal);
                colval = this.model.links.getNumValue(10, i);
                scaledColVal = this.maxLColVal == this.minLColVal ? scaledValue : 1.0 * (colval - this.minLColVal) / (this.maxLColVal - this.minLColVal);
                this.linkColors[i] = this.colmapLinks ? (doColmap ? this.colmap(scaledColVal) : this.getLinkErrorColor()) : this.linkColor;
                this.model.links.setColor(i, this.linkColors[i]);
            }
        } else {
            for (int i = 0; i < this.numLinks; ++i) {
                this.linkColors[i] = this.linkColor;
                this.model.links.setColor(i, this.linkColors[i]);
            }
        }
    }

    public void colormapNodes() {
        if (!(this.model.nodes instanceof DataFilterNodeModel)) {
            return;
        }
        boolean doColmap = true;
        double scaledColVal = 0.0;
        if (this.minNodeVal == this.maxNodeVal && this.minNColVal == this.maxNColVal) {
            doColmap = false;
        }
        Object vobj = ((DataFilterNodeModel)this.model.nodes).getVariable(4);
        Object val_obj = ((DataFilterNodeModel)this.model.nodes).getVariable(7);
        Object iObj = ((DataFilterNodeModel)this.model.nodes).getVariable(0);
        if (iObj == null) {
            return;
        }
        if (vobj != null) {
            DataFilterReadInterface nodeFilter = ((DataFilterNodeModel)this.model.nodes).getFilter();
            int nNodesInFilter = nodeFilter.getNumberObservations(-1);
            int nodeIndex = 0;
            for (int filtrIdx = 0; filtrIdx < nNodesInFilter && nodeIndex < this.numNodes; ++filtrIdx) {
                String filterNodeId;
                NLDNode n = (NLDNode)((DataFilterNodeModel)this.model.nodes).elementAt(nodeIndex);
                String vecNodeId = n.getID();
                if (!vecNodeId.equalsIgnoreCase(filterNodeId = nodeFilter.getValue(iObj, (long)filtrIdx).toString())) continue;
                int i = nodeIndex;
                Object obj = nodeFilter.getValue(vobj, (long)filtrIdx);
                Color c = this.getColor(obj);
                if (c != null) {
                    n.setColor(c);
                    this.nodeColors[i] = c;
                } else if (nodeFilter.isNumericVariable(vobj)) {
                    if (obj != null) {
                        double colval = ((Number)obj).doubleValue();
                        if (!Double.isNaN(colval)) {
                            n.setColorValue(colval);
                            scaledColVal = this.maxNColVal == this.minNColVal ? 1.0 : 1.0 * (colval - this.minNColVal) / (this.maxNColVal - this.minNColVal);
                            this.nodeColors[i] = this.colmap(scaledColVal);
                        } else {
                            this.nodeColors[i] = this.getNodeErrorColor();
                        }
                    } else {
                        this.nodeColors[i] = this.getNodeErrorColor();
                    }
                    n.setColor(this.nodeColors[i]);
                } else {
                    this.nodeColors[i] = this.getNodeErrorColor();
                    n.setColor(this.nodeColors[i]);
                }
                ++nodeIndex;
            }
        } else if (val_obj != null) {
            double value = 0.0;
            double colval = 0.0;
            double scaledValue = 0.0;
            for (int i = 0; i < this.numNodes; ++i) {
                value = this.model.nodes.getNumValue(7, i);
                scaledValue = this.minNodeVal == this.maxNodeVal ? 1.0 : 1.0 * (value - this.minNodeVal) / (this.maxNodeVal - this.minNodeVal);
                colval = this.model.nodes.getNumValue(16, i);
                scaledColVal = this.maxNColVal == this.minNColVal ? scaledValue : 1.0 * (colval - this.minNColVal) / (this.maxNColVal - this.minNColVal);
                this.nodeColors[i] = this.colmapNodes ? (doColmap ? this.colmap(scaledColVal) : this.getNodeErrorColor()) : this.nodeColor;
                this.model.nodes.setColor(i, this.nodeColors[i]);
            }
        } else {
            for (int i = 0; i < this.numNodes; ++i) {
                this.nodeColors[i] = this.nodeColor;
                this.model.nodes.setColor(i, this.nodeColors[i]);
            }
        }
    }

    private Color getColor(Object o) {
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o instanceof String) {
            return NLD.decodeColor((String)o.toString());
        }
        return null;
    }

    @Override
    protected Font getStopIconToolTipFont() {
        Style style = (Style)SILKGlobal.getInstance().getPropertyValue(29);
        TextStyleElement tse = style.getTextStyleElement("ValueText");
        return tse.getFont();
    }

    @Override
    protected void setNodeAttr() {
        VectorNodeModel nodes = this.model.nodes;
        this.numNodes = nodes.size();
        if (this.numNodes <= 0) {
            return;
        }
        double nS_Test = 0.05;
        if (this.numNodes < 20) {
            nS_Test = 0.047;
        } else if (this.numNodes > 1600) {
            nS_Test = 0.01;
        } else {
            int t = this.numNodes / 79 + 1;
            nS_Test = 0.05 * Math.exp(-0.07 * (double)t);
        }
        this.setDefaultNodeSize(nS_Test);
        super.setNodeAttr();
    }

    public void addViewportListener(Object listener) {
    }

    public AxisInterface getAxis(Object which) {
        return null;
    }

    public LegendInterface getLegend(Object which) {
        return null;
    }

    public Rectangle getLegendBounds() {
        return null;
    }

    public Object getLegendPosition(Object which) {
        return null;
    }

    public int getSelectionBehavior() {
        return -1;
    }

    public Object getSelectionBehaviorValue() {
        return null;
    }

    public Component getToolBar() {
        if (this.giHandler == null) {
            return null;
        }
        return this.giHandler.getToolBar();
    }

    public boolean isModelAttributeHonored(Object attribute) {
        return false;
    }

    public void removeViewportListener(Object listener) {
    }

    public boolean setExternalAxis(Object which, AxisInterface axis) {
        return false;
    }

    public boolean setHonorModelAttribute(Object attribute, boolean honorit) {
        return false;
    }

    public boolean setLegendBounds(Rectangle rect) {
        return false;
    }

    public boolean setLegendPosition(Object which, Object positionIn) {
        return false;
    }

    public boolean setSelectionBehavior(int behavior, Object value) {
        return false;
    }

    public boolean setToolBar(Component toolBarIn) {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.setToolBar(toolBarIn);
    }

    public void addDrilldownListener(DrilldownListenerInterface d) {
    }

    public void enablePopup(boolean on) {
        if (this.giHandler == null) {
            return;
        }
        this.giHandler.enablePopup(on);
    }

    public TipInterface getChartTip() {
        return null;
    }

    public Dialog getDialog(Object id, Object listener) {
        if (this.giHandler == null) {
            return null;
        }
        return this.giHandler.getDialog(id, listener);
    }

    public TextStyleInterface getFootnote(int index) {
        if (this.giHandler == null) {
            return null;
        }
        return this.giHandler.getFootnote(index);
    }

    public JPopupMenu getPopupMenu() {
        if (this.giHandler == null) {
            return null;
        }
        return this.giHandler.getPopupMenu();
    }

    public TextStyleInterface getTitle(int index) {
        if (this.giHandler == null) {
            return null;
        }
        return this.giHandler.getTitle(index);
    }

    public boolean isEditable() {
        return false;
    }

    public void removeDrilldownListener(DrilldownListenerInterface d) {
    }

    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.setDialog(id, dialogIn, addSelf);
    }

    public boolean setEditable(boolean editable) {
        return false;
    }

    public boolean setFootnote(int index, String textString) {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.setFootnote(index, textString);
    }

    public boolean setFootnote(int index, TextStyleInterface textObject) {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.setFootnote(index, textObject);
    }

    public boolean setTitle(int index, String textString) {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.setTitle(index, textString);
    }

    public boolean setTitle(int index, TextStyleInterface textObject) {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.setTitle(index, textObject);
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.applyWhereClause(clause, clearPrevious);
    }

    public AnnotateInterface getAnnotate() {
        return null;
    }

    public Object getChartObject(Object id) {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.getChartObject(id);
    }

    public ColorSchemeInterface getColorScheme() {
        if (this.giHandler == null) {
            return null;
        }
        return this.giHandler.getColorScheme();
    }

    public String getColorSchemeName() {
        if (this.giHandler == null) {
            return null;
        }
        return this.giHandler.getColorSchemeName();
    }

    public DataFilterReadInterface getFilter() {
        if (this.giHandler == null) {
            return null;
        }
        return this.giHandler.getFilter();
    }

    public DataFilterReadInterface getFilter(Object id) {
        if (this.giHandler == null) {
            return null;
        }
        return this.giHandler.getFilter(id);
    }

    public boolean getUsageMode(int mode) {
        return false;
    }

    public String getWhereClause() {
        if (this.giHandler == null) {
            return null;
        }
        return this.giHandler.getWhereClause();
    }

    public boolean isActionEnabled(String action) {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.isActionEnabled(action);
    }

    public boolean isBackBufferDrawEnabled() {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.isBackBufferDrawEnabled();
    }

    public boolean isDataListening() {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.isDataListening();
    }

    public boolean setActionEnabled(String action, boolean enable) {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.setActionEnabled(action, enable);
    }

    public void setBackBufferDrawEnabled(boolean drawback) {
        if (this.giHandler == null) {
            return;
        }
        this.giHandler.setBackBufferDrawEnabled(drawback);
    }

    public boolean setColorScheme(Object newScheme) {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.setColorScheme(newScheme);
    }

    public boolean setDataListening(boolean listen) {
        if (this.giHandler == null) {
            return false;
        }
        return this.giHandler.setDataListening(listen);
    }

    public void setUsageMode(int mode, boolean on) {
        if (this.giHandler == null) {
            return;
        }
        this.giHandler.setUsageMode(mode, on);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.giHandler = null;
    }

    @Override
    public synchronized void paint(Graphics g) {
        super.paint(g);
        this.paintBorder(g);
    }

    static {
        DEFAULT_SHAPE_TYPE = 1;
        DEFAULT_SHAPE_STRING = "Circle";
    }
}

