/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.constchart;

import com.sas.graphics.silk.ui.AnimationStopIcon;
import com.sas.graphics.util.AboutFrame;
import com.sas.graphics.util.SASIcon;
import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDMouseFrame;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDViewer;
import com.sas.graphics.util.nld.VectorLinkModel;
import com.sas.graphics.util.nld.VectorNodeModel;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class ConstViewer
extends NLDViewer {
    private static final long serialVersionUID = 2781905292115179573L;
    private JCheckBoxMenuItem intoCB = null;
    private JCheckBoxMenuItem outofCB = null;
    private JCheckBoxMenuItem amongCB = null;
    private JCheckBoxMenuItem allCB = null;
    private JCheckBoxMenuItem animCB = null;
    private JMenuItem open = null;
    private JMenuItem arrange = null;
    private JMenuItem resetModel = null;
    protected AnimationStopIcon animStopIcon = null;
    private JMenuItem subSet = null;
    private JMenuItem superSet = null;
    private JMenuItem selectAll = null;
    private JMenu nodeOptMenu = null;
    private JMenu actionMenu = null;
    private JMenuItem selConNode = null;
    private JMenuItem selAllConNode = null;
    private JPopupMenu popup = null;
    private JCheckBoxMenuItem selectLinksCB = null;
    protected String dstype = "arcs";
    private double support = 20.0;
    protected String layout = "auto";
    private double maxcnt = 1.0;
    protected double mincnt = 1.0;
    private double minval = 0.0;
    protected double minNodeVal = 0.0;
    protected double maxNodeVal = 0.0;
    protected double minLinkVal = 0.0;
    protected double maxLinkVal = 0.0;
    private boolean handlePopup = true;
    private boolean scaleSupport = true;
    private boolean scaleLinkWidth = true;
    private boolean scaleNodeSize = true;
    private String buildDate = "0000.0000";
    private Vector subSetNodeIds = null;
    private boolean subSetNodesVisibility = false;
    private String[] nodeOptActionStrArray = new String[]{"NLD_SEL_CON_NODES", "NLD_SEL_ALL_CON_NODES", "NLD_SUBSET", "NLD_RESET"};
    String hierEng = "hier";
    String arcEng = "arcs";
    String assocEng = "assoc";
    String hierNLS;
    String arcNLS;
    String assocNLS;
    String autoEng = "auto";
    String userEng = "user";
    String autoNLS = null;
    String userNLS = null;
    private boolean doSuperSetEnable = false;
    protected int animTipX = -1;
    protected int animTipY = -1;
    private Vector buildNodesIndices = new Vector();
    private Vector selectedNodesIndices = new Vector();
    private Vector buildLinksIndices = new Vector();
    private Vector selectedLinksIndices = new Vector();
    private boolean clickOnSelectedNode = false;
    private boolean clickOnSelectedLink = false;
    private boolean ctrlPressedWithMousePressed = false;
    private boolean shiftPressedWithMousePressed = false;
    private boolean mouseDraggedCalled = false;
    protected static int columnSpacing = 5;
    protected static int rowSpacing = 3;
    MouseEvent lastEvent = null;
    private Object context = null;
    private Vector toggledNodeList = new Vector();
    protected double minSize;
    protected double maxSize;
    protected double minNColVal;
    protected double maxNColVal;
    protected double minWidth;
    protected double maxWidth;
    protected double minLColVal;
    protected double maxLColVal;

    public ConstViewer() {
        this.setCenterSelected(false);
        this.setInitialValues();
    }

    public ConstViewer(NLDModel m) {
        this.setCenterSelected(false);
        this.model = m;
        this.model.setNodeShape(NLDViewer.DEFAULT_SHAPE_STRING);
        this.setInitialValues();
    }

    public void dispose() {
        this.setPauseLayout(true);
        while (this.model.isLayoutThreadAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        this.animStopIcon = null;
        super.dispose();
        this.subSetNodeIds = null;
    }

    private void setInitialValues() {
        this.buildAsNonSelected = true;
        this.pickLinks = false;
        this.lens = false;
        this.fan = false;
        this.textBorderType = 0;
        this.model.setChartType(1);
        this.setFontSize(10);
        this.rbstr = "com.sas.graphics.silk.constchart.constchart";
        try {
            this.appRB = ResourceBundle.getBundle(this.rbstr);
        }
        catch (MissingResourceException e) {
            this.appRB = null;
        }
        catch (ClassCastException e) {
            this.appRB = null;
        }
        this.model.setAction(this.GRS("PopupMenu.CS.OpenURL.txt", "Open URL"));
        this.setTextValign(0);
        this.setTextHalign(1);
        if (this.model != null) {
            this.model.setHideLinks(false);
        }
        this.setSize(600, 650);
        this.nodeColor = new Color(97, 115, 169);
        this.linkColor = Color.black;
        this.selectColor = new Color(253, 200, 97);
        this.rampColors[0] = new Color(228, 26, 28);
        this.rampColors[1] = new Color(77, 175, 74);
        this.rampColors[2] = new Color(80, 80, 204);
        String stopIconTipText = this.GRS("Animation.Stop.Tip.txt", "Animation in Progress. \nClick here to stop animation.");
        String stopText = this.GRS("Animation.Stop.txt", "Stop layout");
        AnimationStopIcon icon = new AnimationStopIcon((Component)((Object)this), stopText, stopIconTipText);
        this.setAnimationIcon(icon);
    }

    public void copy(NLDViewer viewer) {
        super.copy(viewer);
        if (viewer instanceof ConstViewer) {
            ConstViewer chart = (ConstViewer)viewer;
            this.dstype = chart.dstype;
            this.support = chart.support;
            this.layout = chart.layout;
            this.mincnt = chart.mincnt;
            this.maxcnt = chart.maxcnt;
            this.minNodeVal = chart.minNodeVal;
            this.maxNodeVal = chart.maxNodeVal;
            this.minLinkVal = chart.minLinkVal;
            this.maxLinkVal = chart.maxLinkVal;
        }
    }

    public void setScaleSupport(boolean flag) {
        this.scaleSupport = flag;
    }

    public void setScaleLinkWidth(boolean flag) {
        this.scaleLinkWidth = flag;
    }

    public void setScaleNodeSize(boolean flag) {
        this.scaleNodeSize = flag;
    }

    public boolean isScaleSupport() {
        return this.scaleSupport;
    }

    public boolean isScaleLinkWidth() {
        return this.scaleLinkWidth;
    }

    public boolean isScaleNodeSize() {
        return this.scaleNodeSize;
    }

    public void setSupport(double val) {
        this.setSupport(val, false);
    }

    public void setSupport(double val, boolean update) {
        this.support = this.scaleSupport ? Math.min(Math.max(0.0, val), 100.0) : val;
        if (update) {
            this.ready = false;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.mincnt = this.scaleSupport ? this.minval + this.support * this.maxcnt / 100.0 : this.support;
            VectorLinkModel links = this.model.links;
            for (int i = 0; i < this.numLinks; ++i) {
                if (links.getNumValue(6, i) >= this.mincnt) {
                    links.setCulled(i, false);
                    continue;
                }
                links.setCulled(i, true);
            }
            this.rebuildRequired = true;
            this.projectAndBuild(true);
            this.setCursor(Cursor.getDefaultCursor());
            this.ready = true;
        }
    }

    public double getSupport() {
        return this.support;
    }

    public void setDataTypeNames() {
        this.arcNLS = this.GRS("AppletInfo.arcs.txt", this.arcEng);
        this.hierNLS = this.GRS("AppletInfo.hier.txt", this.hierEng);
        this.assocNLS = this.GRS("AppletInfo.assoc.txt", this.assocEng);
    }

    public String getDatasetType() {
        return this.dstype;
    }

    public void setDatasetType(String type) {
        this.dstype = type;
        this.colmapNodes = !this.dstype.equalsIgnoreCase("arcs");
    }

    public void showArrows(boolean flag) {
        this.model.setDirected(flag);
    }

    public boolean areArrowsShown() {
        return this.model.getDirected();
    }

    public void setLayout(String type) {
        this.autoNLS = this.GRS("AppletInfo.auto.txt", this.autoEng);
        this.userNLS = this.GRS("AppletInfo.user.txt", this.userEng);
        if (type.equalsIgnoreCase(this.userEng) || type.equalsIgnoreCase(this.userNLS)) {
            this.setUserLayout(true);
            this.setPauseLayout(true);
            while (this.model.isLayoutThreadAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        } else {
            this.setUserLayout(false);
            if (this.applet != null) {
                this.setLayoutStrategy(0);
            }
        }
    }

    public void setUserLayout(boolean flag) {
        super.setUserLayout(flag);
        this.layout = flag ? "user" : "auto";
    }

    public String getChartLayout() {
        return this.layout;
    }

    public JPopupMenu getDefaultPopupMenu(ItemListener il) {
        JPopupMenu popup = new JPopupMenu();
        String[] menlabs = new String[]{this.GRS("PopupMenu.DWG.ResetView.txt", "Reset View"), this.GRS("PopupMenu.DWG.ResetModel.txt", "Reset Model"), this.GRS("PopupMenu.DWG.Select.txt", "Select..."), this.GRS("PopupMenu.DWG.SelectAll.txt", "Select All"), this.GRS("PopupMenu.DWG.Redo.txt", "Redo Layout")};
        String[] commands = new String[]{"resetV", "resetM", "filter", "selAll", "arrange"};
        JMenuItem mi = this.AddToMenu(popup, menlabs[0], commands[0], (ActionListener)((Object)this));
        if (this.applet != null) {
            mi = this.resetModel = this.AddToMenu(popup, menlabs[1], commands[1], (ActionListener)((Object)this));
        }
        mi = this.AddToMenu(popup, menlabs[2], commands[2], (ActionListener)((Object)this));
        mi = this.selectAll = this.AddToMenu(popup, menlabs[3], commands[3], (ActionListener)((Object)this));
        mi = this.arrange = this.AddToMenu(popup, menlabs[4], commands[4], (ActionListener)((Object)this));
        int layoutType = this.getLayoutStrategy();
        boolean animCBEnable = (layoutType == 0 || layoutType == 2) && !this.isAnimating() && !this.userLayout && !this.model.isLayoutThreadAlive();
        this.animCB = this.AddOnOffToMenu(popup, this.GRS("PopupMenu.CS.Animate.txt", "Animate Layout"), "animCB", this.getAnimationFlag(), il, animCBEnable);
        this.arrange.setEnabled(animCBEnable);
        if (this.applet != null) {
            this.resetModel.setEnabled(animCBEnable);
        }
        popup.addSeparator();
        if (this.applet != null) {
            this.open = this.AddToMenu(popup, this.GRS("PopupMenu.CS.OpenURL.txt", "Open URL"), "open", (ActionListener)((Object)this), false);
        }
        this.allCB = this.AddOnOffToMenu(popup, this.GRS("PopupMenu.CS.all.txt", "Show all links"), "allCB", !this.model.isHideLinks(), il, true);
        this.intoCB = this.AddOnOffToMenu(popup, this.GRS("PopupMenu.CS.into.txt", "Show links into selection"), "intoCB", true, il, false);
        this.outofCB = this.AddOnOffToMenu(popup, this.GRS("PopupMenu.CS.outof.txt", "Show links out of selection"), "outofCB", true, il, false);
        this.amongCB = this.AddOnOffToMenu(popup, this.GRS("PopupMenu.CS.among.txt", "Show links among selection"), "amongCB", true, il, false);
        JMenu m = new JMenu(this.GRS("PopupMenu.Help.txt", "Help"));
        if (m != null) {
            popup.add(m);
            m.setName("Help");
        }
        if (this.applet != null && (mi = new JMenuItem(this.GRS("PopupMenu.Help.Applet.txt", "Constellation Chart Applet Help"))) != null) {
            mi.setActionCommand("hp_Help");
            mi.addActionListener((ActionListener)((Object)this));
            m.add(mi);
        }
        if ((mi = new JMenuItem(this.GRS("PopupMenu.Help.Mouse.txt", "Mouse Help"))) != null) {
            mi.setActionCommand("hp_Mouse");
            mi.addActionListener((ActionListener)((Object)this));
            m.add(mi);
        }
        m.addSeparator();
        if (this.applet != null && (mi = new JMenuItem(this.GRS("PopupMenu.Help.AboutSASInstitute.txt", "SAS Institute on the Web"))) != null) {
            mi.setActionCommand("hp_SAS");
            mi.addActionListener((ActionListener)((Object)this));
            m.add(mi);
        }
        if ((mi = new JMenuItem(this.GRS("PopupMenu.Help.AboutApplet.txt", "About Constellation Chart Applet"))) != null) {
            mi.setActionCommand("hp_Applet");
            mi.addActionListener((ActionListener)((Object)this));
            m.add(mi);
        }
        if (this.applet != null && (this.selectLinksCB = new JCheckBoxMenuItem(this.GRS("PopupMenu.SelectLinks.txt", "Select Links"))) != null) {
            this.selectLinksCB.setActionCommand("SelectLinks");
            this.selectLinksCB.setSelected(this.getPickLinks());
            this.selectLinksCB.addItemListener((ItemListener)((Object)this));
            popup.addSeparator();
            popup.add(this.selectLinksCB);
        }
        return popup;
    }

    protected boolean isSelRectDrawn(MouseEvent e) {
        int mods = e.getModifiers();
        if ((mods & 1) == 0) {
            this.drawSelectionRect(e.getX(), e.getY());
            return true;
        }
        return false;
    }

    protected boolean isNodeSelReq() {
        return !this.shiftPressedWithMousePressed;
    }

    public synchronized void mouseDragged(MouseEvent e) {
        if (!this.ready || this.emptyPlot) {
            return;
        }
        this.tooltipTimer.restart();
        this.tipText = null;
        if (this.tipLocation == null) {
            this.tipLocation = new Point();
        }
        this.tipLocation.x = e.getX();
        this.tipLocation.y = e.getY();
        if (this.isAnimating() || this.model.isLayoutThreadAlive()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int xd = this.prevx - x;
        int yd = this.prevy - y;
        this.drag = true;
        if (this.movenode) {
            this.mouseDraggedCalled = true;
            if (this.isSelRectDrawn(e)) {
                return;
            }
            double[] win1 = new double[3];
            double[] obj1 = new double[3];
            double[] win2 = new double[3];
            double[] obj2 = new double[3];
            double[] delta = new double[2];
            win1[0] = x;
            win1[1] = y;
            win2[0] = this.prevx;
            win2[1] = this.prevy;
            this.channel.gluUnProject(win1, obj1);
            this.channel.gluUnProject(win2, obj2);
            delta[0] = obj1[0] - obj2[0];
            delta[1] = obj1[1] - obj2[1];
            for (int i = 0; i < this.numNodes; ++i) {
                NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
                if (this.model.nodes.isSelected(i)) {
                    n.setCurPosition(n.getCurXPosition() + delta[0], n.getCurYPosition() + delta[1]);
                }
                if (!this.isUserLayout()) continue;
                double[] win3 = new double[3];
                double[] obj3 = new double[3];
                obj3[0] = n.getCurXPosition();
                obj3[1] = n.getCurYPosition();
                this.channel.gluProject(obj3, win3);
                n.setOrgXPosition(win3[0]);
                n.setOrgYPosition(win3[1]);
            }
            this.build();
            this.buildSelected();
            this.repaint();
            this.prevx = x;
            this.prevy = y;
        } else if (this.viewport) {
            this.viewportActive = true;
            this.dragMinX = Math.min(x, this.pressX);
            this.dragMinY = Math.min(y, this.pressY);
            this.dragMaxX = Math.max(x, this.pressX);
            this.dragMaxY = Math.max(y, this.pressY);
            this.prevx = this.dragMinX;
            this.prevy = this.dragMinY;
            this.diffx = Math.abs(x - this.pressX);
            this.diffy = Math.abs(y - this.pressY);
            this.repaint();
        } else if (this.zoom) {
            if (this.lens) {
                double minfac = 0.1;
                double percent = 1.0 * (double)yd / (double)this.compHeight;
                double thresh = 0.01;
                if (Math.abs(percent) < thresh) {
                    return;
                }
                if (this.lensFactor < 1.0) {
                    double sqrtlen = Math.sqrt(this.lensFactor);
                    this.lensFactor += sqrtlen * percent;
                } else {
                    this.lensFactor *= 1.0 + percent;
                }
                if (this.lensFactor <= minfac) {
                    this.lensFactor = minfac;
                }
                this.channel.setLensFactor(this.lensFactor);
            } else {
                if (Math.abs(yd) < 5) {
                    return;
                }
                this.zoomval *= 1.0 - 1.5 * (double)yd / (double)this.compHeight;
                this.setNodeImages();
                this.checkImages();
                this.proj();
                this.build();
                this.buildSelected();
            }
            this.prevx = x;
            this.prevy = y;
            this.repaint();
            if (this.applet != null) {
                this.applet.getAppletContext().showStatus("");
            }
        } else if (this.pan) {
            if (Math.abs(xd) < 5 && Math.abs(yd) < 5) {
                return;
            }
            double wxd = 0.0;
            double wyd = 0.0;
            if (this.lens) {
                double[] ps = new double[]{this.prevx, this.prevy, 0.0};
                double[] pw = new double[3];
                this.channel.gluUnProject(ps, pw);
                double[] cs = new double[]{x, y, 0.0};
                double[] cw = new double[3];
                this.channel.gluUnProject(cs, cw);
                wxd = pw[0] - cw[0];
                wyd = pw[1] - cw[1];
                wyd = -wyd;
            } else {
                wxd = this.pixsize * (double)xd;
                wyd = this.pixsize * (double)yd;
            }
            this.centerx += wxd;
            this.centery -= wyd;
            this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
            this.prevx = x;
            this.prevy = y;
            this.projectAndBuild(true);
        } else if (this.select || this.extsel) {
            Graphics gc = this.getGraphics();
            gc.setColor(Color.white);
            gc.setXORMode(Color.black);
            gc.drawRect(this.prevx, this.prevy, this.diffx, this.diffy);
            this.dragMinX = Math.min(this.dragMinX, Math.min(x, this.prevx));
            this.dragMinY = Math.min(this.dragMinY, Math.min(y, this.prevy));
            this.dragMaxX = Math.max(this.dragMaxX, Math.max(x, this.prevx));
            this.dragMaxY = Math.max(this.dragMaxY, Math.max(y, this.prevy));
            this.prevx = this.dragMinX;
            this.prevy = this.dragMinY;
            this.diffx = this.dragMaxX - this.dragMinX;
            this.diffy = this.dragMaxY - this.dragMinY;
            gc.drawRect(this.prevx, this.prevy, this.diffx, this.diffy);
            gc.dispose();
        } else if (this.brush) {
            this.doBrushing(x, y, xd, yd);
        } else if (this.chgview) {
            this.repaint();
            Graphics gc = this.getGraphics();
            gc.setColor(Color.white);
            gc.setXORMode(Color.black);
            int xp = Math.min(x, this.prevx);
            int yp = Math.min(y, this.prevy);
            int w = Math.abs(xd);
            int h = Math.abs(yd);
            gc.drawRect(xp, yp, w, h);
            int ch = Math.min(h / 4, w / 4);
            gc.drawLine(xp + w / 2, yp + h / 2 - ch, xp + w / 2, yp + h / 2 + ch);
            gc.drawLine(xp + w / 2 - ch, yp + h / 2, xp + w / 2 + ch, yp + h / 2);
            gc.dispose();
        }
        if (this.isAnimating() || this.model.isLayoutThreadAlive()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public synchronized void mouseMoved(MouseEvent e) {
        if (this.emptyPlot) {
            return;
        }
        super.mouseMoved(e);
        if (this.animStopIcon != null && this.animStopIcon.isMouseOverIcon(e.getX(), e.getY())) {
            this.setCursor(Cursor.getDefaultCursor());
        } else if (this.isAnimating() || this.model.isLayoutThreadAlive()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
        int x = e.getX();
        int y = e.getY();
        this.animTipX = x;
        this.animTipY = y;
    }

    private boolean isOnNode(Object context) {
        if (context == null) {
            return false;
        }
        return context instanceof NLDNode;
    }

    private Object getContext(int x, int y) {
        return this.pick(x, y);
    }

    private boolean isNodeSelected(Object context) {
        if (context == null) {
            return false;
        }
        if (context instanceof NLDNode) {
            return ((NLDNode)context).isSelected();
        }
        return false;
    }

    private void selectSingleNode(Stack hit, boolean doSelect) {
        Object value;
        boolean update = false;
        int[] indices = null;
        int cntr = 0;
        indices = new int[hit.size()];
        while (!hit.empty()) {
            String name = (String)hit.pop();
            int index = -1;
            if (!name.equals("")) {
                index = new Integer(name.substring(1));
            }
            if (name.charAt(0) != 'N') continue;
            Integer idx = new Integer(index);
            if (doSelect) {
                if (!this.selectedNodesIndices.contains(idx)) {
                    this.selectedNodesIndices.add(idx);
                }
            } else {
                indices[cntr++] = index;
                if (this.selectedNodesIndices.contains(idx)) {
                    this.selectedNodesIndices.remove(idx);
                }
            }
            if (!this.buildNodesIndices.contains(idx)) {
                this.buildNodesIndices.add(idx);
            }
            update = true;
        }
        if (update) {
            this.myMouseAction = true;
            if (!doSelect) {
                this.model.nodes.setSelected(indices, doSelect, cntr, this.handleEvents);
            } else {
                cntr = 0;
                int nSelNodes = this.selectedNodesIndices.size();
                int[] select_indices = new int[nSelNodes];
                for (int i = 0; i < nSelNodes; ++i) {
                    value = this.selectedNodesIndices.elementAt(i);
                    if (value == null) {
                        --i;
                        continue;
                    }
                    select_indices[i] = ((Number)value).intValue();
                    ++cntr;
                }
                this.model.nodes.setSelected(select_indices, doSelect, cntr, this.handleEvents);
            }
            this.myMouseAction = false;
            this.model.updateLinks();
        }
        if (this.handleEvents || !update) {
            int nodeCount = this.buildNodesIndices.size();
            int[] nodeIdxArray = new int[nodeCount];
            for (int i = 0; i < nodeCount; ++i) {
                value = this.buildNodesIndices.elementAt(i);
                if (value == null) {
                    --i;
                    continue;
                }
                nodeIdxArray[i] = ((Number)value).intValue();
            }
            this.buildSelected(nodeIdxArray, nodeCount, null, 0);
            this.repaint();
        }
    }

    private Stack removeDuplicateHits(Stack hit) {
        if (hit == null) {
            return new Stack();
        }
        Stack uniqueHits = new Stack();
        while (!hit.empty()) {
            Object elem = hit.pop();
            if (uniqueHits.contains(elem)) continue;
            uniqueHits.push(elem);
        }
        return uniqueHits;
    }

    private void selectMultipleNodesAndLinks(Stack nodeHit, Stack linkHit, boolean cntrlPressed) {
        Object value;
        int i;
        int nUnSelect;
        int i2;
        int nSelect;
        int[] indices_to_unselect;
        Integer idx;
        int index;
        String name;
        Stack uniqueHits;
        boolean nodeUpdate = false;
        boolean linkUpdate = false;
        int[] nodeIndices = null;
        int[] linkIndices = null;
        int nodeCntr = 0;
        int linkCntr = 0;
        Vector<Integer> nodeIndicesToUnselect = null;
        Vector<Integer> linkIndicesToUnselect = null;
        nodeHit = uniqueHits = this.removeDuplicateHits(nodeHit);
        linkHit = this.pickLinks ? (uniqueHits = this.removeDuplicateHits(linkHit)) : new Stack();
        if (!cntrlPressed) {
            nodeIndices = new int[nodeHit.size()];
            if (this.pickLinks) {
                linkIndices = new int[linkHit.size()];
            }
        } else {
            nodeIndicesToUnselect = new Vector<Integer>();
            if (this.pickLinks) {
                linkIndicesToUnselect = new Vector<Integer>();
            }
        }
        while (!nodeHit.empty()) {
            name = (String)nodeHit.pop();
            index = -1;
            if (!name.equals("")) {
                index = new Integer(name.substring(1));
            }
            if (name.charAt(0) != 'N') continue;
            idx = new Integer(index);
            if (!cntrlPressed) {
                nodeIndices[nodeCntr++] = index;
                if (!this.selectedNodesIndices.contains(idx)) {
                    this.selectedNodesIndices.add(idx);
                }
                if (!this.buildNodesIndices.contains(idx)) {
                    this.buildNodesIndices.add(idx);
                }
            } else if (this.selectedNodesIndices.contains(idx)) {
                nodeIndicesToUnselect.add(idx);
                this.selectedNodesIndices.removeElement(idx);
                if (!this.buildNodesIndices.contains(idx)) {
                    this.buildNodesIndices.add(idx);
                }
            } else {
                this.selectedNodesIndices.add(idx);
                if (!this.buildNodesIndices.contains(idx)) {
                    this.buildNodesIndices.add(idx);
                }
            }
            nodeUpdate = true;
        }
        while (!linkHit.empty()) {
            name = (String)linkHit.pop();
            index = -1;
            if (!name.equals("")) {
                index = new Integer(name.substring(1));
            }
            if (name.charAt(0) != 'A') continue;
            idx = new Integer(index);
            if (!cntrlPressed) {
                linkIndices[linkCntr++] = index;
                if (!this.selectedLinksIndices.contains(idx)) {
                    this.selectedLinksIndices.add(idx);
                }
                if (!this.buildLinksIndices.contains(idx)) {
                    this.buildLinksIndices.add(idx);
                }
            } else if (this.selectedLinksIndices.contains(idx)) {
                linkIndicesToUnselect.add(idx);
                this.selectedLinksIndices.removeElement(idx);
                if (!this.buildLinksIndices.contains(idx)) {
                    this.buildLinksIndices.add(idx);
                }
            } else {
                this.selectedLinksIndices.add(idx);
                if (!this.buildLinksIndices.contains(idx)) {
                    this.buildLinksIndices.add(idx);
                }
            }
            linkUpdate = true;
        }
        if (nodeUpdate) {
            this.myMouseAction = true;
            if (!cntrlPressed) {
                this.model.nodes.unselectAll(this.handleEvents);
                this.model.nodes.setSelected(nodeIndices, true, nodeCntr, this.handleEvents);
            } else {
                int cntrSelected = this.selectedNodesIndices.size();
                int[] indices_to_select = new int[cntrSelected];
                int cntrUnSelected = nodeIndicesToUnselect.size();
                indices_to_unselect = new int[cntrUnSelected];
                nSelect = 0;
                for (i2 = 0; i2 < cntrSelected; ++i2) {
                    Object value2 = this.selectedNodesIndices.elementAt(i2);
                    if (value2 == null) {
                        --i2;
                        continue;
                    }
                    ++nSelect;
                    indices_to_select[i2] = ((Number)value2).intValue();
                }
                nUnSelect = 0;
                for (i = 0; i < cntrUnSelected; ++i) {
                    value = nodeIndicesToUnselect.elementAt(i);
                    if (value == null) {
                        --i;
                        continue;
                    }
                    ++nUnSelect;
                    indices_to_unselect[i] = ((Number)value).intValue();
                }
                if (nSelect > 0) {
                    this.model.nodes.setSelected(indices_to_select, true, nSelect, this.handleEvents);
                }
                if (nUnSelect > 0) {
                    this.model.nodes.setSelected(indices_to_unselect, false, nUnSelect, this.handleEvents);
                }
            }
            this.myMouseAction = false;
            this.model.updateLinks();
        }
        if (linkUpdate) {
            this.myMouseAction = true;
            if (!cntrlPressed) {
                this.model.links.unselectAll(this.handleEvents);
                this.model.links.setSelected(linkIndices, true, linkCntr, this.handleEvents);
            } else {
                int cntrSelected = this.selectedLinksIndices.size();
                int[] indices_to_select = new int[cntrSelected];
                int cntrUnSelected = linkIndicesToUnselect.size();
                indices_to_unselect = new int[cntrUnSelected];
                nSelect = 0;
                for (i2 = 0; i2 < cntrSelected; ++i2) {
                    Object value3 = this.selectedLinksIndices.elementAt(i2);
                    if (value3 == null) {
                        --i2;
                        continue;
                    }
                    ++nSelect;
                    indices_to_select[i2] = ((Number)value3).intValue();
                }
                nUnSelect = 0;
                for (i = 0; i < cntrUnSelected; ++i) {
                    value = linkIndicesToUnselect.elementAt(i);
                    if (value == null) {
                        --i;
                        continue;
                    }
                    ++nUnSelect;
                    indices_to_unselect[i] = ((Number)value).intValue();
                }
                if (nSelect > 0) {
                    this.model.links.setSelected(indices_to_select, true, nSelect, this.handleEvents);
                }
                if (nUnSelect > 0) {
                    this.model.links.setSelected(indices_to_unselect, false, nUnSelect, this.handleEvents);
                }
            }
            this.myMouseAction = false;
            this.model.updateLinks();
        }
        if (this.handleEvents || !nodeUpdate || !linkUpdate) {
            int nodeCount = this.buildNodesIndices.size();
            int[] nodeIdxArray = new int[nodeCount];
            for (int i3 = 0; i3 < nodeCount; ++i3) {
                Object value4 = this.buildNodesIndices.elementAt(i3);
                if (value4 == null) {
                    --i3;
                    continue;
                }
                nodeIdxArray[i3] = ((Number)value4).intValue();
            }
            int linkCount = 0;
            int[] linkIdxArray = null;
            if (this.pickLinks) {
                linkCount = this.buildLinksIndices.size();
                linkIdxArray = new int[linkCount];
                for (int i4 = 0; i4 < linkCount; ++i4) {
                    Object value5 = this.buildLinksIndices.elementAt(i4);
                    if (value5 == null) {
                        --i4;
                        continue;
                    }
                    linkIdxArray[i4] = ((Number)value5).intValue();
                }
            }
            this.buildSelected(nodeIdxArray, nodeCount, linkIdxArray, linkCount);
            this.repaint();
        }
    }

    private synchronized void selectConnectedNodes(int idx, boolean update) {
        int nNodes = this.model.nodes.size();
        for (int i = 0; i < nNodes; ++i) {
            NLDNode nT;
            if (!((NLDNode)this.model.nodes.elementAt(i)).isVisible()) continue;
            int toIdx = ((NLDNode)this.model.nodes.elementAt(i)).getIndex();
            int linkIdT = this.model.getLink(idx, toIdx);
            int linkIdF = this.model.getLink(toIdx, idx);
            if (linkIdT < 0 && linkIdF < 0 || (nT = (NLDNode)this.model.nodes.elementAt(toIdx)).isSelected()) continue;
            if (!this.selectedNodesIndices.contains(new Integer(toIdx))) {
                this.selectedNodesIndices.add(new Integer(toIdx));
            }
            if (this.buildNodesIndices.contains(new Integer(toIdx))) continue;
            this.buildNodesIndices.add(new Integer(toIdx));
        }
        if (update) {
            this.myMouseAction = true;
            int cntr = 0;
            int nSelNodes = this.selectedNodesIndices.size();
            int[] select_indices = new int[nSelNodes];
            for (int i = 0; i < nSelNodes; ++i) {
                Object value = this.selectedNodesIndices.elementAt(i);
                if (value == null) {
                    --i;
                    continue;
                }
                select_indices[i] = ((Number)value).intValue();
                ++cntr;
            }
            this.model.nodes.setSelected(select_indices, true, cntr, this.handleEvents);
            this.myMouseAction = false;
            this.model.updateLinks();
            cntr = 0;
            if (this.handleEvents) {
                int nodeCount = this.buildNodesIndices.size();
                int[] nodeIdxArray = new int[nodeCount];
                for (int i = 0; i < nodeCount; ++i) {
                    Object value = this.buildNodesIndices.elementAt(i);
                    if (value == null) {
                        --i;
                        continue;
                    }
                    nodeIdxArray[i] = ((Number)value).intValue();
                    ++cntr;
                }
                this.buildSelected(nodeIdxArray, cntr, null, 0);
                this.repaint();
            }
        }
    }

    private synchronized void selectAllConnectedNodes() {
        int nSelNode = this.selectedNodesIndices.size();
        for (int i = 0; i < nSelNode; ++i) {
            int nodeIdx = (Integer)this.selectedNodesIndices.elementAt(i);
            if (!this.buildNodesIndices.contains(new Integer(nodeIdx))) {
                this.buildNodesIndices.add(new Integer(nodeIdx));
            }
            this.selectConnectedNodes(nodeIdx, false);
        }
        this.myMouseAction = true;
        int cntrSelected = this.selectedNodesIndices.size();
        int[] indices_to_select = new int[cntrSelected];
        int nSelect = 0;
        for (int i = 0; i < cntrSelected; ++i) {
            Object value = this.selectedNodesIndices.elementAt(i);
            if (value == null) {
                --i;
                continue;
            }
            ++nSelect;
            indices_to_select[i] = ((Number)value).intValue();
        }
        if (nSelect > 0) {
            this.model.nodes.setSelected(indices_to_select, true, nSelect, this.handleEvents);
        }
        this.myMouseAction = false;
        this.model.updateLinks();
        if (this.handleEvents) {
            int nodeCount = this.buildNodesIndices.size();
            int[] nodeIdxArray = new int[nodeCount];
            for (int i = 0; i < nodeCount; ++i) {
                Object value = this.buildNodesIndices.elementAt(i);
                if (value == null) {
                    --i;
                    continue;
                }
                nodeIdxArray[i] = ((Number)value).intValue();
            }
            this.buildSelected(nodeIdxArray, nodeCount, null, 0);
            this.repaint();
        }
    }

    private synchronized void selectNLDObject(MouseEvent e) {
        if (this.movenode) {
            int x = e.getX();
            int y = e.getY();
            Object cntxt = this.getContext(x, y);
            boolean isClickOnNode = this.isOnNode(cntxt);
            int mods = e.getModifiers();
            this.ctrlPressedWithMousePressed = (mods & 2) != 0;
            this.mouseDraggedCalled = false;
            if (!isClickOnNode) {
                this.pressX = this.prevx = x;
                this.pressY = this.prevy = y;
                this.diffx = 0;
                this.diffy = 0;
                if (this.ctrlPressedWithMousePressed) {
                    return;
                }
                this.myMouseAction = true;
                this.ignoreBuild = true;
                this.model.nodes.unselectAll(this.handleEvents);
                this.model.links.unselectAll(this.handleEvents);
                this.ignoreBuild = false;
                this.myMouseAction = false;
                this.buildNodesIndices = new Vector();
                this.selectedNodesIndices = new Vector();
                this.buildLinksIndices = new Vector();
                this.selectedLinksIndices = new Vector();
                return;
            }
            this.clickOnSelectedNode = this.isNodeSelected(cntxt);
            if (!this.clickOnSelectedNode) {
                if (!this.ctrlPressedWithMousePressed) {
                    this.myMouseAction = true;
                    this.ignoreBuild = true;
                    this.model.nodes.unselectAll(this.handleEvents);
                    this.model.links.unselectAll(this.handleEvents);
                    this.ignoreBuild = false;
                    this.myMouseAction = false;
                    this.buildNodesIndices = new Vector();
                    this.selectedNodesIndices = new Vector();
                }
                Stack hit = this.PickObjects(x, y, 3, 3, true, this.nodelist);
                this.selectSingleNode(hit, true);
            } else if (this.ctrlPressedWithMousePressed) {
                Stack hit = this.PickObjects(x, y, 3, 3, true, this.nodelist);
                this.selectSingleNode(hit, false);
            }
        } else {
            this.myMouseAction = true;
            this.ignoreBuild = true;
            this.model.nodes.unselectAll(this.handleEvents);
            this.model.links.unselectAll(this.handleEvents);
            this.ignoreBuild = false;
            this.myMouseAction = false;
            this.buildNodesIndices = new Vector();
            this.buildLinksIndices = new Vector();
        }
    }

    public synchronized void mousePressed(MouseEvent e) {
        if (this.animStopIcon != null && this.animStopIcon.isMouseOverIcon(e.getX(), e.getY())) {
            if (this.isLayoutInterrupted()) {
                return;
            }
            this.setPauseLayout(true);
            this.model.setArrangeFirstTime(false);
            this.setCursor(this.actionMode);
            return;
        }
        this.tipLocation = e.getPoint();
        this.tipText = null;
        this.tooltipTimer.restart();
        if (this.preMousePressed(e)) {
            // empty if block
        }
        this.postMousePressed(e);
        if (this.isAnimating() || this.model.isLayoutThreadAlive()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public synchronized boolean preMousePressed(MouseEvent e) {
        this.dragMinX = Integer.MAX_VALUE;
        this.dragMinY = Integer.MAX_VALUE;
        this.dragMaxX = Integer.MIN_VALUE;
        this.dragMaxY = Integer.MIN_VALUE;
        if (!this.ready || this.emptyPlot) {
            return false;
        }
        int x = e.getX();
        int y = e.getY();
        if (this.actionMode != 1) {
            this.resetBrushInformation();
            this.repaint();
        }
        if (this.brushActive) {
            if (!this.brushResize) {
                this.handleID = this.onHandle(x, y);
                if (this.handleID > 0) {
                    this.brushResize = true;
                    this.startStretchX = x;
                    this.startStretchY = y;
                    this.brush = true;
                    this.brushPress = false;
                    this.brushDrag = false;
                    return false;
                }
                this.handleID = -1;
            }
            if (this.isInside(x, y)) {
                if (this.moveCloseCursor != null) {
                    this.setCursor(this.moveCloseCursor);
                } else {
                    System.out.println(this.GRS("ConstViewer.Custom_Cursor_Error.txt", "Custom cursor not found. Using predefined cursor."));
                    this.setCursor(Cursor.getPredefinedCursor(13));
                }
                this.brush = true;
                this.brushPress = true;
                this.brushPressX = e.getX();
                this.brushPressY = e.getY();
                return false;
            }
            this.brushActive = false;
            this.brushPress = false;
            this.brushDrag = false;
            this.diffx = 0;
            this.diffy = 0;
            if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
                return false;
            }
        }
        this.drag = false;
        this.pressX = this.prevx = x;
        this.pressY = this.prevy = y;
        return true;
    }

    public synchronized void paint(Graphics g) {
        super.paint(g);
        if (this.isAnimating() && this.animStopIcon != null) {
            this.animStopIcon.draw(g);
        }
        this.showStopIconTip(g, this.animTipX, this.animTipY);
    }

    private static String[] getCol(int i, String[][] arr) {
        String[] rc = new String[arr.length];
        for (int j = 0; j < arr.length; ++j) {
            rc[j] = arr[j].length > i ? arr[j][i].trim() : new String("");
        }
        return rc;
    }

    private static String[][] parseStopIconTipText(String text) {
        if (text == null) {
            return null;
        }
        StringTokenizer lineParser = new StringTokenizer(text, "\n");
        String[][] rc = new String[lineParser.countTokens()][];
        int maxCols = 0;
        int i = 0;
        while (lineParser.hasMoreTokens()) {
            StringTokenizer colParser = new StringTokenizer(lineParser.nextToken(), "\t");
            rc[i] = new String[colParser.countTokens()];
            if (colParser.countTokens() > maxCols) {
                maxCols = colParser.countTokens();
            }
            int j = 0;
            while (colParser.hasMoreTokens()) {
                rc[i][j] = colParser.nextToken();
                ++j;
            }
            ++i;
        }
        String[][] temp = rc;
        rc = new String[maxCols][];
        for (i = 0; i < maxCols; ++i) {
            rc[i] = ConstViewer.getCol(i, temp);
        }
        return rc;
    }

    protected int getMaxStringWidth(String[] strs, Font style, Graphics2D g, FontRenderContext frc) {
        int rc = 0;
        for (int i = 0; i < strs.length; ++i) {
            int width = (int)style.getStringBounds(strs[i], frc).getWidth();
            if (rc >= width) continue;
            rc = width;
        }
        return rc;
    }

    protected Font getStopIconToolTipFont() {
        return new Font("Arial", 0, 10);
    }

    private void paintStopIconTip(JComponent component, Graphics2D g, Point origin, Object text) {
        if (g == null || origin == null || text == null) {
            return;
        }
        Font font = this.getStopIconToolTipFont();
        String[][] parsedText = null;
        parsedText = text instanceof String[][] ? (String[][])text : ConstViewer.parseStopIconTipText(text.toString());
        Dimension size = null;
        size = parsedText == null ? new Dimension(50, 50) : new Dimension((parsedText.length + 1) * columnSpacing, 2 * rowSpacing);
        FontRenderContext frc = g.getFontRenderContext();
        int textHeight = (int)font.getStringBounds("T", frc).getHeight();
        size.height = parsedText == null || parsedText.length == 0 ? 0 : textHeight * parsedText[0].length + rowSpacing * (2 + parsedText[0].length);
        size.width += columnSpacing * (4 + parsedText.length);
        for (int i = 0; i < parsedText.length; ++i) {
            size.width += this.getMaxStringWidth(parsedText[i], font, g, frc);
        }
        origin.x -= size.width + columnSpacing;
        origin.y -= size.height + rowSpacing;
        if (origin.x < 0) {
            origin.x = 0;
        }
        if (origin.y < 0) {
            origin.y = 0;
        }
        Graphics2D g2 = g;
        Composite composite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g.setColor(new Color(245, 245, 220));
        g.fillRect(origin.x, origin.y, size.width, size.height);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.black);
        g.drawRect(origin.x, origin.y, size.width - 1, size.height - 1);
        g.setColor(Color.black);
        if (text == null) {
            text = "";
        }
        int xPos = origin.x + columnSpacing;
        int yPos = origin.y + rowSpacing + textHeight;
        for (int i = 0; i < parsedText.length; ++i) {
            yPos = origin.y + rowSpacing + textHeight;
            xPos += this.getMaxStringWidth(parsedText[i], font, g2, frc);
            for (int j = 0; j < parsedText[i].length; ++j) {
                if (parsedText[i][j] != null && parsedText[i][j].length() > 0) {
                    g.drawString(parsedText[i][j], xPos - (int)font.getStringBounds(parsedText[i][j], frc).getWidth(), yPos);
                }
                yPos += textHeight + rowSpacing;
            }
            xPos += columnSpacing;
        }
        g2.setComposite(composite);
    }

    private void showStopIconTip(Graphics g, int x, int y) {
        if (this.animStopIcon == null) {
            return;
        }
        String s = null;
        if (g == null || !(g instanceof Graphics2D)) {
            return;
        }
        if (this.animStopIcon != null && this.animStopIcon.isMouseOverIcon(x, y)) {
            s = this.animStopIcon.getTooltipText();
        }
        if (s == null) {
            return;
        }
        Point tipPos = this.animStopIcon.getTipPos();
        this.paintStopIconTip((JComponent)((Object)this), (Graphics2D)g, tipPos, s);
    }

    public synchronized void postMousePressed(MouseEvent e) {
        Object o = null;
        int mods = e.getModifiers();
        boolean doubleClick = e.getClickCount() > 1;
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger()) {
            if (this.popup == null) {
                this.popup = this.getDefaultPopupMenu((ItemListener)((Object)this));
            }
            this.setPopupLabels();
            this.popup.show(e.getComponent(), x, y);
        }
        if (this.emptyPlot) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (!doubleClick) {
            o = this.pick(x, y);
        }
        this.lastPressNLDNode = this.pressNLDNode;
        this.pressNLDNode = null;
        if (o instanceof NLDNode) {
            this.pressNLDNode = (NLDNode)o;
        }
        if (this.movenode) {
            if (!this.isAnimating()) {
                this.selectNLDObject(e);
            }
            return;
        }
        this.shiftPressedWithMousePressed = false;
        this.ctrlPressedWithMousePressed = false;
        if ((mods & 1) != 0) {
            this.shiftPressedWithMousePressed = true;
            this.extsel = true;
            if ((mods & 2) != 0) {
                this.movenode = true;
                this.nodeMoved = true;
                this.ctrlPressedWithMousePressed = true;
            } else {
                this.select = true;
                this.ctrlPressedWithMousePressed = false;
            }
        } else {
            this.shiftPressedWithMousePressed = false;
            this.ctrlPressedWithMousePressed = false;
            if ((mods & 8) != 0) {
                this.pan = true;
            } else if ((mods & 2) != 0) {
                this.zoom = true;
                this.ctrlPressedWithMousePressed = true;
            } else {
                this.select = true;
            }
        }
    }

    public synchronized void mouseReleased(MouseEvent e) {
        boolean doubleClick;
        if (this.animStopIcon != null && this.animStopIcon.isMouseOverIcon(e.getX(), e.getY())) {
            if (this.isLayoutInterrupted()) {
                return;
            }
            this.setPauseLayout(true);
            this.model.setArrangeFirstTime(false);
            return;
        }
        this.tooltipTimer.restart();
        this.tipText = null;
        if (this.tipLocation == null) {
            this.tipLocation = new Point();
        }
        this.tipLocation.x = e.getX();
        this.tipLocation.y = e.getY();
        if (this.brushActive) {
            if (this.isInside(e.getX(), e.getY())) {
                this.setCursor(this.moveOpenCursor);
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            this.setCursor(this.actionMode);
        }
        if (this.brushResize) {
            this.diffx += this.stretchX;
            this.diffy += this.stretchY;
            this.prevx = this.stretchPrevX;
            this.prevy = this.stretchPrevY;
            this.startStretchX = 0;
            this.startStretchY = 0;
            this.stretchX = 0;
            this.stretchY = 0;
            this.updateHandles();
        } else if (this.brushPress) {
            if (this.brushDrag) {
                this.updateHandles();
            } else {
                return;
            }
        }
        boolean bl = doubleClick = e.getClickCount() > 1;
        if (doubleClick) {
            this.openURL();
            return;
        }
        if (!(this.drag || this.extsel || this.brush || this.pan || this.zoom || this.movenode)) {
            this.showBackgroundURL(e.getX(), e.getY());
        }
        if (e.isPopupTrigger()) {
            if (this.handlePopup) {
                if (this.popup == null) {
                    this.popup = this.getDefaultPopupMenu((ItemListener)((Object)this));
                }
                this.setPopupLabels();
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
            this.resetFlags();
            return;
        }
        if (this.emptyPlot) {
            return;
        }
        this.lastEvent = e;
        this.processMouseEvt();
    }

    public void processMouseEvt() {
        if (this.lastEvent == null) {
            return;
        }
        int x = this.lastEvent.getX();
        int y = this.lastEvent.getY();
        int xd = this.prevx - x;
        int yd = this.prevy - y;
        boolean build = false;
        if (this.movenode) {
            if (this.isAnimating() || this.model.isLayoutThreadAlive()) {
                this.resetFlags();
                return;
            }
            if (this.isNodeSelReq()) {
                boolean ctrlPressed = this.ctrlPressedWithMousePressed;
                Stack nodeHit = this.PickObjects(this.prevx, this.prevy, this.diffx, this.diffy, true, this.nodelist);
                Stack linkHit = null;
                if (this.pickLinks) {
                    linkHit = this.PickObjects(this.prevx, this.prevy, this.diffx, this.diffy, true, this.linklist);
                }
                this.selectMultipleNodesAndLinks(nodeHit, linkHit, ctrlPressed);
            } else if (!this.mouseDraggedCalled && (this.clickOnSelectedNode || this.clickOnSelectedLink) && !this.ctrlPressedWithMousePressed) {
                this.myMouseAction = true;
                this.ignoreBuild = true;
                this.model.nodes.unselectAll(this.handleEvents);
                this.model.links.unselectAll(this.handleEvents);
                this.ignoreBuild = false;
                this.myMouseAction = false;
                this.buildNodesIndices = new Vector();
                this.selectedNodesIndices = new Vector();
                this.buildLinksIndices = new Vector();
                this.selectedLinksIndices = new Vector();
                Stack nodeHit = this.PickObjects(x, y, 3, 3, true, this.nodelist);
                this.selectSingleNode(nodeHit, true);
            }
            this.resetFlags();
        } else {
            if (this.brush) {
                if (this.isAnimating() || this.model.isLayoutThreadAlive()) {
                    this.resetFlags();
                    return;
                }
                this.myMouseAction = true;
                this.ignoreBuild = true;
                this.model.nodes.unselectAll(this.handleEvents);
                this.model.links.unselectAll(this.handleEvents);
                this.ignoreBuild = false;
                this.myMouseAction = false;
                boolean update = false;
                int x1 = 0;
                int dx = 0;
                int y1 = 0;
                int dy = 0;
                boolean dragOp = false;
                if (this.brushDrag || this.brushResize) {
                    x1 = this.prevx;
                    y1 = this.prevy;
                    dx = this.diffx;
                    dy = this.diffy;
                    dragOp = true;
                } else if (this.drag) {
                    x1 = Math.min(x, this.prevx);
                    dx = this.diffx = this.dragMaxX - this.dragMinX;
                    y1 = Math.min(y, this.prevy);
                    dy = this.diffy = this.dragMaxY - this.dragMinY;
                    dragOp = true;
                }
                int[] indices = null;
                int cntr = 0;
                int[] indices2 = null;
                int cntr2 = 0;
                if (dragOp) {
                    int index;
                    String name;
                    this.selectedNodesIndices.clear();
                    this.buildNodesIndices.clear();
                    Stack hit = this.PickObjects(x1, y1, dx, dy, true, this.nodelist);
                    indices = new int[hit.size()];
                    while (!hit.empty()) {
                        name = (String)hit.pop();
                        if (name.equals("")) continue;
                        index = new Integer(name.substring(1));
                        if (name.charAt(0) != 'N') continue;
                        indices[cntr++] = index;
                        if (!this.selectedNodesIndices.contains(new Integer(index))) {
                            this.selectedNodesIndices.add(new Integer(index));
                        }
                        if (!this.buildNodesIndices.contains(new Integer(index))) {
                            this.buildNodesIndices.add(new Integer(index));
                        }
                        update = true;
                    }
                    if (this.pickLinks) {
                        hit = this.PickObjects(x1, y1, dx, dy, true, this.linklist);
                    } else {
                        hit.removeAllElements();
                    }
                    indices2 = new int[hit.size()];
                    while (!hit.empty()) {
                        name = (String)hit.pop();
                        if (name.equals("")) continue;
                        index = new Integer(name.substring(1));
                        if (name.charAt(0) != 'A') continue;
                        indices2[cntr2++] = index;
                        update = true;
                    }
                    if (update) {
                        this.myMouseAction = true;
                        this.model.nodes.setSelected(indices, true, cntr, this.handleEvents);
                        this.model.links.setSelected(indices2, true, cntr2, this.handleEvents);
                        this.myMouseAction = false;
                        this.model.updateLinks();
                    }
                } else {
                    int index;
                    String name;
                    this.selectedNodesIndices.clear();
                    this.buildNodesIndices.clear();
                    Stack hit = this.PickObjects(x, y, 3, 3, true, this.nodelist);
                    indices = new int[hit.size()];
                    while (!hit.empty()) {
                        name = (String)hit.pop();
                        index = -1;
                        if (!name.equals("")) {
                            index = new Integer(name.substring(1));
                        }
                        if (name.charAt(0) != 'N') continue;
                        indices[cntr++] = index;
                        if (!this.selectedNodesIndices.contains(new Integer(index))) {
                            this.selectedNodesIndices.add(new Integer(index));
                        }
                        if (!this.buildNodesIndices.contains(new Integer(index))) {
                            this.buildNodesIndices.add(new Integer(index));
                        }
                        update = true;
                    }
                    if (this.pickLinks) {
                        hit = this.PickObjects(x1, y1, dx, dy, true, this.linklist);
                    } else {
                        hit.removeAllElements();
                    }
                    indices2 = new int[hit.size()];
                    while (!hit.empty()) {
                        name = (String)hit.pop();
                        if (name.equals("")) continue;
                        index = new Integer(name.substring(1));
                        if (name.charAt(0) != 'A') continue;
                        indices2[cntr2++] = index;
                        update = true;
                    }
                    if (update) {
                        this.myMouseAction = true;
                        this.model.nodes.setSelected(indices, true, cntr, this.handleEvents);
                        this.model.links.setSelected(indices2, true, cntr2, this.handleEvents);
                        this.myMouseAction = false;
                        this.model.updateLinks();
                    }
                }
                if (this.handleEvents || !update) {
                    this.buildSelected(indices, cntr, indices2, cntr2);
                    this.repaint();
                }
                this.resetFlags();
                return;
            }
            if (this.viewport) {
                this.viewportActive = false;
                int x1 = this.prevx;
                int dx = this.diffx;
                int y1 = this.prevy;
                int dy = this.diffy;
                if (dx < 5 || dy < 5) {
                    this.repaint();
                    return;
                }
                double xm = this.compWidth / 2;
                double ym = this.compHeight / 2;
                this.centerx -= this.pixsize * (xm - ((double)x1 + 0.5 * (double)dx));
                this.centery += this.pixsize * (ym - ((double)y1 + 0.5 * (double)dy));
                this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
                float zoomFactor1 = (float)dy / (float)this.compHeight;
                float zoomFactor2 = (float)dx / (float)this.compWidth;
                float zoomFactor = Math.max(zoomFactor1, zoomFactor2);
                this.zoomval *= (double)zoomFactor;
                this.setNodeImages();
                this.checkImages();
                this.proj();
                Vector selNodeIdx = this.model.nodes.getSelected();
                Vector selLinkIdx = this.model.links.getSelected();
                int nSelNodes = selNodeIdx.size();
                int nSelLinks = selLinkIdx.size();
                if (nSelNodes > 0 || nSelLinks > 0) {
                    this.model.updateLinks();
                    int i = 0;
                    int[] indices = new int[nSelNodes];
                    while (i < nSelNodes) {
                        indices[i] = (Integer)selNodeIdx.elementAt(i++);
                    }
                    int[] indices2 = new int[nSelLinks];
                    i = 0;
                    while (i < nSelLinks) {
                        indices2[i] = (Integer)selLinkIdx.elementAt(i++);
                    }
                    this.buildSelected(indices, nSelNodes, indices2, nSelLinks);
                }
                this.build();
                this.repaint();
                this.diffy = 0;
                this.diffx = 0;
            } else if (this.select || this.extsel) {
                int x1 = 0;
                int dx = 0;
                int y1 = 0;
                int dy = 0;
                if (this.select && !this.extsel) {
                    this.myMouseAction = true;
                    this.ignoreBuild = true;
                    this.model.nodes.unselectAll(this.handleEvents);
                    this.model.links.unselectAll(this.handleEvents);
                    this.model.updateLinks();
                    this.ignoreBuild = false;
                    this.myMouseAction = false;
                }
                boolean update = false;
                if (this.drag) {
                    x1 = Math.min(x, this.prevx);
                    this.diffx = dx = this.dragMaxX - this.dragMinX;
                    y1 = Math.min(y, this.prevy);
                    this.diffy = dy = this.dragMaxY - this.dragMinY;
                } else {
                    x1 = x;
                    y1 = y;
                    dy = 3;
                    dx = 3;
                }
                Stack hit = this.PickObjects(x1, y1, dx, dy, true, this.nodelist);
                int[] indices = new int[hit.size()];
                int cntr = 0;
                while (!hit.empty()) {
                    String name = (String)hit.pop();
                    if (name.equals("")) continue;
                    int index = new Integer(name.substring(1));
                    if (name.charAt(0) != 'N') continue;
                    indices[cntr++] = index;
                    update = true;
                }
                if (this.pickLinks) {
                    hit = this.PickObjects(x1, y1, dx, dy, true, this.linklist);
                } else {
                    hit.removeAllElements();
                }
                int[] indices2 = new int[hit.size()];
                int cntr2 = 0;
                while (!hit.empty()) {
                    String name = (String)hit.pop();
                    if (name.equals("")) continue;
                    int index = new Integer(name.substring(1));
                    if (name.charAt(0) != 'A') continue;
                    indices2[cntr2++] = index;
                    update = true;
                }
                if (update) {
                    if (this.extsel) {
                        this.toggleSelected(indices, cntr);
                        this.toggleSelectedLinks(indices2, cntr2);
                    } else {
                        this.myMouseAction = true;
                        this.model.nodes.setSelected(indices, true, cntr, this.handleEvents);
                        this.model.links.setSelected(indices2, true, cntr2, this.handleEvents);
                        this.myMouseAction = false;
                    }
                    this.model.updateLinks();
                }
                if (this.select && !this.extsel && this.handleEvents) {
                    this.buildSelected(indices, cntr, indices2, cntr2);
                    this.repaint();
                } else if (this.extsel && this.handleEvents) {
                    Integer idx;
                    int i;
                    Integer idx2;
                    int i2;
                    Hashtable<Integer, Integer> h1 = new Hashtable<Integer, Integer>();
                    for (i2 = 0; i2 < this.lastNumSelectedNodes; ++i2) {
                        idx2 = new Integer(this.lastSelectedNodes[i2]);
                        h1.put(idx2, idx2);
                    }
                    for (i2 = 0; i2 < cntr; ++i2) {
                        idx2 = new Integer(indices[i2]);
                        h1.put(idx2, idx2);
                    }
                    Hashtable<Integer, Integer> h2 = new Hashtable<Integer, Integer>();
                    for (i = 0; i < this.lastNumSelectedLinks; ++i) {
                        idx = new Integer(this.lastSelectedLinks[i]);
                        h2.put(idx, idx);
                    }
                    for (i = 0; i < cntr2; ++i) {
                        idx = new Integer(indices2[i]);
                        h2.put(idx, idx);
                    }
                    int j = 0;
                    int[] idx1 = new int[h1.size()];
                    Enumeration e = h1.elements();
                    while (e != null && e.hasMoreElements()) {
                        idx1[j++] = (Integer)e.nextElement();
                    }
                    j = 0;
                    int[] idx22 = new int[h2.size()];
                    e = h2.elements();
                    while (e != null && e.hasMoreElements()) {
                        idx22[j++] = (Integer)e.nextElement();
                    }
                    this.buildSelected(idx1, idx1.length, idx22, idx22.length);
                    this.repaint();
                }
                this.diffy = 0;
                this.diffx = 0;
            } else if (this.chgview) {
                double xm = this.compWidth / 2;
                double ym = this.compHeight / 2;
                this.centerx -= this.pixsize * (xm - ((double)x + 0.5 * (double)xd));
                this.centery += this.pixsize * (ym - ((double)y + 0.5 * (double)yd));
                this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
                double xrat = 1.0 * (double)Math.abs(xd) / (double)this.compWidth;
                double yrat = 1.0 * (double)Math.abs(yd) / (double)this.compHeight;
                double zrat = Math.max(xrat, yrat);
                this.zoomval *= zrat;
                this.proj();
                if (!build) {
                    this.repaint();
                }
            }
        }
        if (build) {
            this.build();
            this.repaint();
        }
        this.resetFlags();
    }

    public void reset() {
        boolean user;
        this.resetView(true);
        this.model.nodes.resetAll();
        boolean bl = user = this.layout.equalsIgnoreCase(this.userEng) || this.layout.equalsIgnoreCase(this.userNLS);
        if (user) {
            this.read_X_Y_Positions();
            this.unprojectNodes();
        } else if (!this.dstype.equals(this.hierEng) && !this.dstype.equals(this.hierNLS)) {
            this.model.arrange();
        }
        if (!this.isDeselectAll()) {
            this.model.deselectAll();
            this.setDeselectAll(true);
        }
        this.nodeMoved = false;
        this.resetView(true);
    }

    public void toggleSelected(int[] indices, int cntr) {
        int[] indxTrue = new int[cntr];
        int[] indxFalse = new int[cntr];
        int numFalse = 0;
        int numTrue = 0;
        for (int i = 0; i < cntr; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(indices[i]);
            if (!n.isSelected()) {
                indxTrue[numTrue++] = indices[i];
                continue;
            }
            indxFalse[numFalse++] = indices[i];
        }
        boolean update = false;
        if (numTrue > 0) {
            update = true;
            this.myMouseAction = true;
            this.model.nodes.setSelected(indxTrue, true, numTrue, this.handleEvents);
            this.myMouseAction = false;
        }
        if (!this.handleEvents || update) {
            // empty if block
        }
    }

    public void toggleSelectedLinks(int[] indices, int cntr) {
        int[] indxTrue = new int[cntr];
        int[] indxFalse = new int[cntr];
        int numFalse = 0;
        int numTrue = 0;
        for (int i = 0; i < cntr; ++i) {
            NLDLink l = (NLDLink)this.model.links.elementAt(indices[i]);
            if (!l.isSelected()) {
                indxTrue[numTrue++] = indices[i];
                continue;
            }
            indxFalse[numFalse++] = indices[i];
        }
        boolean update = false;
        if (numTrue > 0) {
            update = true;
            this.myMouseAction = true;
            this.model.links.setSelected(indxTrue, true, numTrue, this.handleEvents);
            this.myMouseAction = false;
        }
        if (numFalse > 0) {
            update = true;
            this.myMouseAction = true;
            this.model.links.setSelected(indxFalse, false, numFalse, this.handleEvents);
            this.myMouseAction = false;
        }
        if (this.handleEvents && update) {
            this.build();
            this.repaint();
        }
    }

    public void setSelected(Object o, boolean state, boolean update) {
        NLDNode n = null;
        n = o instanceof NLDNode ? (NLDNode)o : this.model.nodes.getNode(o);
        if (n == null) {
            return;
        }
        this.setSelected(n, state, update);
    }

    public Object pick(int x, int y) {
        this.context = super.pick(x, y);
        return this.context;
    }

    private void setSelected(NLDNode n, boolean state, boolean update) {
        this.setSelected(n, state);
        if (state) {
            this.setDeselectAll(false);
        }
        if (update) {
            this.build();
            this.repaint();
        }
    }

    public void rebuild(boolean flag) {
        this.rebuildRequired = true;
        super.rebuild(flag);
    }

    public void rebuild() {
        this.rebuild(true);
    }

    public void load() {
        this.load(true);
    }

    public void load(boolean paint) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.numNodes = this.model.getNumNodes();
        this.numLinks = this.model.getNumLinks();
        if (this.numNodes == 0 && this.numLinks == 0) {
            boolean ok = this.model.loadModel((NLDViewer)this);
            if (!ok) {
                this.numLinks = 0;
                this.numNodes = 0;
                this.emptyPlot = true;
                this.setPauseLayout(true);
                while (this.model.isLayoutThreadAlive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                }
                this.setCursor(Cursor.getDefaultCursor());
                if (this.applet != null) {
                    this.applet.getAppletContext().showStatus("");
                }
                return;
            }
            this.numNodes = this.model.getNumNodes();
            this.numLinks = this.model.getNumLinks();
        }
        if (this.numNodes <= 0) {
            this.emptyPlot = true;
            this.setPauseLayout(true);
            while (this.model.isLayoutThreadAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ok) {}
            }
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.emptyPlot = false;
        if (this.emptyPlot) {
            return;
        }
        this.analyze();
        this.setNodeAttr();
        this.setArcAttr();
        this.model.updateLinks();
        if (this.dstype.equals(this.arcEng) || this.dstype.equals(this.arcNLS)) {
            this.placeArcNodes();
        } else if (this.dstype.equals(this.assocEng) || this.dstype.equals(this.assocNLS)) {
            this.placeAssocNodes();
        } else {
            this.placeHierNodes();
            this.model.resetSizes();
            this.numNodes = this.model.getNumNodes();
            this.numLinks = this.model.getNumLinks();
        }
        if (this.subSetNodeIds != null && this.subSetNodeIds.size() > 0) {
            int nNodes = this.model.nodes.size();
            NLDNode n = null;
            for (int i = 0; i < nNodes; ++i) {
                n = (NLDNode)this.model.nodes.elementAt(i);
                if (this.subSetNodesVisibility) {
                    n.setVisible(this.subSetNodeIds.contains(n.getID()));
                    continue;
                }
                n.setVisible(!this.subSetNodeIds.contains(n.getID()));
            }
            this.subSetNodeIds.clear();
            this.subSetNodeIds = null;
            this.subSetNodesVisibility = false;
        }
        if (!(this.layout.equalsIgnoreCase(this.userEng) || this.layout.equalsIgnoreCase(this.userNLS) || this.dstype.equals(this.hierEng) || this.dstype.equals(this.hierNLS))) {
            this.model.arrange();
        }
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.Processing.txt", "Processing diagram..."));
        }
        if (!(this.layout.equalsIgnoreCase(this.userEng) || this.layout.equalsIgnoreCase(this.userNLS) || this.dstype.equals(this.hierEng) || this.dstype.equals(this.hierNLS))) {
            if (!this.isAnimating()) {
                if (this.getLayoutStrategy() == 3 || this.getLayoutStrategy() == 1 || this.getLayoutStrategy() == 2) {
                    this.build();
                    this.buildSelected();
                }
                if (paint) {
                    this.repaint();
                }
            }
        } else {
            this.build();
            this.buildSelected();
            if (paint) {
                this.repaint();
            }
        }
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
        if (this.DEBUG) {
            System.out.println(this.GRS("StatusText.NumberOfNodes.txt", "number of nodes=") + this.numNodes);
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.ready = true;
    }

    protected void reProjection() {
        super.reProjection();
        if (this.userLayout) {
            this.unprojectNodes();
        }
    }

    private void openURL() {
        this.openURL(this.context);
        this.context = null;
    }

    private boolean isAnyMoreSelectionPossible() {
        int nNode = this.model.nodes.size();
        Vector<Integer> unSelectedNodeIdx = new Vector<Integer>();
        int visibleNodeCount = 0;
        for (int i = 0; i < nNode; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            if (!n.isVisible()) continue;
            int idx = n.getIndex();
            if (!this.selectedNodesIndices.contains(new Integer(idx))) {
                unSelectedNodeIdx.addElement(new Integer(idx));
            }
            ++visibleNodeCount;
        }
        if (unSelectedNodeIdx.size() == 0) {
            return false;
        }
        int nUnSelNode = unSelectedNodeIdx.size();
        for (int i = 0; i < nUnSelNode; ++i) {
            int unSelIdx = (Integer)unSelectedNodeIdx.elementAt(i);
            int nSelNode = this.selectedNodesIndices.size();
            for (int j = 0; j < nSelNode; ++j) {
                int selIdx = (Integer)this.selectedNodesIndices.elementAt(j);
                int linkIdT = this.model.getLink(selIdx, unSelIdx);
                int linkIdF = this.model.getLink(unSelIdx, selIdx);
                if (linkIdT < 0 && linkIdF < 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSubsetPossible() {
        int nNode = this.model.nodes.size();
        int visibleNodeCount = 0;
        for (int i = 0; i < nNode; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            if (!n.isVisible()) continue;
            ++visibleNodeCount;
        }
        return visibleNodeCount != this.selectedNodesIndices.size();
    }

    public void setPopupLabels() {
        if (this.context instanceof NLDNode) {
            NLDNode n = (NLDNode)this.context;
            String urlStr = this.getUrlString(n);
            if (this.open != null) {
                if (urlStr != null && !urlStr.equals("")) {
                    this.open.setText(urlStr);
                    this.open.setEnabled(true);
                } else {
                    this.open.setText(this.getAction(n));
                    this.open.setEnabled(false);
                }
            }
            boolean isFreeNode = this.model.isFreeNode(n);
            boolean nextLevelSelected = this.model.isNextLevelSelected(n);
            if (this.selConNode != null) {
                this.selConNode.removeActionListener((ActionListener)((Object)this));
                this.selConNode.setEnabled(((NLDNode)this.context).isSelected() && this.movenode && !isFreeNode && !nextLevelSelected);
                this.selConNode.addActionListener((ActionListener)((Object)this));
            }
            if (this.selAllConNode != null) {
                this.selAllConNode.removeActionListener((ActionListener)((Object)this));
                this.selAllConNode.setEnabled(((NLDNode)this.context).isSelected() && this.movenode);
                this.selAllConNode.addActionListener((ActionListener)((Object)this));
            }
        } else {
            if (this.open != null) {
                String action = this.model.getAction();
                if (action != null) {
                    this.open.setText(action);
                }
                this.open.setEnabled(false);
            }
            if (this.selConNode != null) {
                this.selConNode.removeActionListener((ActionListener)((Object)this));
                this.selConNode.setEnabled(false);
                this.selConNode.addActionListener((ActionListener)((Object)this));
            }
            if (this.selAllConNode != null) {
                this.selAllConNode.removeActionListener((ActionListener)((Object)this));
                this.selAllConNode.setEnabled(false);
                this.selAllConNode.addActionListener((ActionListener)((Object)this));
            }
        }
        int layoutType = this.getLayoutStrategy();
        this.animCB.setEnabled(false);
        this.arrange.setEnabled(false);
        if (layoutType == 0 || layoutType == 2) {
            if (!(this.isAnimating() || this.userLayout || this.model.isLayoutThreadAlive())) {
                this.animCB.setEnabled(true);
                this.arrange.setEnabled(true);
            }
        } else if (layoutType == 1 || layoutType == 3) {
            this.arrange.setEnabled(true);
        }
        if (this.applet != null && this.resetModel != null) {
            this.resetModel.setEnabled(!this.isAnimating() && !this.model.isLayoutThreadAlive());
        }
        if (this.applet == null && this.resetModel == null && this.userLayout) {
            this.arrange.setEnabled(true);
        }
        if (this.actionMenu != null) {
            this.actionMenu.setEnabled(!this.isAnimating() && !this.model.isLayoutThreadAlive());
        }
        if (this.subSet != null) {
            this.subSet.removeActionListener((ActionListener)((Object)this));
            this.subSet.setEnabled(false);
            this.subSet.addActionListener((ActionListener)((Object)this));
        }
        if (this.selectedNodesIndices.size() > 0) {
            if (this.selAllConNode != null) {
                this.selAllConNode.removeActionListener((ActionListener)((Object)this));
                this.selAllConNode.setEnabled(this.movenode && this.isAnyMoreSelectionPossible());
                this.selAllConNode.addActionListener((ActionListener)((Object)this));
            }
            if (this.subSet != null) {
                this.subSet.removeActionListener((ActionListener)((Object)this));
                this.subSet.setEnabled(!this.isAnimating() && this.isSubsetPossible());
                this.subSet.addActionListener((ActionListener)((Object)this));
            }
        }
        if (this.superSet != null) {
            this.superSet.removeActionListener((ActionListener)((Object)this));
            this.superSet.setEnabled(this.doSuperSetEnable && !this.isAnimating());
            this.superSet.addActionListener((ActionListener)((Object)this));
        }
        if (this.nodeOptMenu != null) {
            if (this.selAllConNode.isEnabled() || this.selConNode.isEnabled() || this.subSet.isEnabled() || this.superSet.isEnabled()) {
                this.nodeOptMenu.setEnabled(!this.isAnimating());
            } else {
                this.nodeOptMenu.setEnabled(false);
            }
        }
        boolean hideLinks = this.model.isHideLinks();
        boolean state = !this.isSelectAll();
        this.selectAll.setEnabled(state);
        if (hideLinks) {
            this.intoCB.setEnabled(state);
            this.outofCB.setEnabled(state);
            this.amongCB.setEnabled(true);
        } else {
            this.intoCB.setEnabled(false);
            this.outofCB.setEnabled(false);
            this.amongCB.setEnabled(false);
        }
        if (this.selectLinksCB != null) {
            if (this.model.isHideLinks()) {
                this.selectLinksCB.setSelected(false);
                this.selectLinksCB.setEnabled(false);
            } else {
                this.selectLinksCB.setEnabled(true);
                this.selectLinksCB.setSelected(this.getPickLinks());
            }
        }
    }

    private void setAnimationIcon(AnimationStopIcon icon) {
        this.animStopIcon = icon;
    }

    public synchronized void itemStateChanged(ItemEvent evt) {
        JCheckBoxMenuItem obj = (JCheckBoxMenuItem)evt.getSource();
        if (obj == null) {
            return;
        }
        String cmd = obj.getActionCommand();
        if (cmd.equals("intoCB")) {
            int mask = this.model.getLinksMask();
            mask = obj.getState() ? (mask |= 1) : (mask &= 0xFFFFFFFE);
            this.model.setLinksMask(mask);
            this.model.updateLinks();
            this.buildSelected();
            this.repaint();
            if (obj != this.intoCB) {
                this.intoCB.setState(obj.getState());
            }
        } else if (cmd.equals("outofCB")) {
            int mask = this.model.getLinksMask();
            mask = obj.getState() ? (mask |= 2) : (mask &= 0xFFFFFFFD);
            this.model.setLinksMask(mask);
            this.model.updateLinks();
            this.buildSelected();
            this.repaint();
            if (obj != this.outofCB) {
                this.outofCB.setState(obj.getState());
            }
        } else if (cmd.equals("amongCB")) {
            int mask = this.model.getLinksMask();
            mask = obj.getState() ? (mask |= 4) : (mask &= 0xFFFFFFFB);
            this.model.setLinksMask(mask);
            this.model.updateLinks();
            this.buildSelected();
            this.repaint();
            if (obj != this.amongCB) {
                this.amongCB.setState(obj.getState());
            }
        } else if (cmd.equals("allCB")) {
            this.model.setHideLinks(!obj.getState());
            this.model.updateLinks();
            this.rebuildRequired = true;
            this.build();
            this.buildSelected();
            this.repaint();
            if (obj != this.allCB) {
                this.allCB.setState(obj.getState());
            }
        } else if (cmd.equals("SelectLinks")) {
            this.setPickLinks(obj.isSelected());
        } else if (cmd.equals("animCB")) {
            this.setAnimationFlag(obj.isSelected());
        }
        this.context = null;
    }

    public synchronized void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equalsIgnoreCase("hp_Applet")) {
            String title = this.GRS("AboutDialog.TitleText.txt", "SAS/GRAPH\u00ae 9.2 Constellation Applet");
            String version = null;
            if (this.aboutFrame == null) {
                if (this.sasIcon == null) {
                    this.sasIcon = new SASIcon((Component)((Object)this));
                }
                this.aboutFrame = new AboutFrame((Object)this.appRB, this.sasIcon, title, version, this.buildDate, this.useRBsizing);
            }
            if (!this.useRBsizing) {
                this.aboutFrame.setSize(350, 500);
            }
            this.aboutFrame.show();
            this.aboutFrame.toFront();
            return;
        }
        if (command.equalsIgnoreCase("hp_Help")) {
            try {
                URL url = new URL(this.applet.getCodeBase(), this.helpUrlString);
                this.applet.getAppletContext().showDocument(url, this.urlTarget);
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
            return;
        }
        if (command.equalsIgnoreCase("hp_Mouse")) {
            String title = this.GRS("MouseDialog.Title.txt", "Mouse Help");
            if (this.mouseFrame == null) {
                String[] mouseActions = new String[]{this.GRS("MouseDialog.Key0.txt", "MOVE = Probe"), this.GRS("MouseDialog.Key1", "CLICK (a node) = Select/Unselect the node"), this.GRS("MouseDialog.Key2.txt", "CLICK (outside a node) = Unselect all nodes"), this.GRS("MouseDialog.Key3.txt", "Shift + CLICK (a node) = Extended Sel/Unsel the node"), this.GRS("MouseDialog.Key4.txt", "DRAG = Select all nodes inside the region"), this.GRS("MouseDialog.Key6.txt", "Shift + DRAG = Extended Selection"), this.GRS("MouseDialog.Key5.txt", "Shift + CTRL + DRAG = Move selected node(s)"), this.GRS("MouseDialog.Key7.txt", "CTRL + DRAG = Zoom"), this.GRS("MouseDialog.Key8.txt", "CTRL + ALT + DRAG = Change view"), this.GRS("MouseDialog.Key9.txt", "RIGHT = Popup Menu")};
                this.mouseFrame = new NLDMouseFrame(this.appRB, title, mouseActions, this.useRBsizing);
            }
            if (!this.useRBsizing) {
                this.mouseFrame.setSize(350, 250);
            }
            this.mouseFrame.show();
            this.mouseFrame.toFront();
            return;
        }
        if (command.equalsIgnoreCase("hp_SAS")) {
            try {
                URL url = new URL(this.applet.getDocumentBase(), "http://www.sas.com");
                this.applet.getAppletContext().showDocument(url, this.urlTarget);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            return;
        }
        if (command.equals("resetM")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.reset();
            this.setCursor(Cursor.getDefaultCursor());
        } else if (command.equals("resetV")) {
            this.resetView(true);
        } else if (command.equals("selAll")) {
            this.selectAll();
        } else if (command.equals("deselAll")) {
            this.model.deselectAll();
            this.deselAll = true;
            this.build();
            this.repaint();
        } else if (command.equals("arrange")) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.layout.equalsIgnoreCase(this.userEng) || this.layout.equalsIgnoreCase(this.userNLS)) {
                this.read_X_Y_Positions();
                this.resetView(false);
                this.unprojectNodes();
            } else if (!this.dstype.equals(this.hierEng) && !this.dstype.equals(this.hierNLS)) {
                this.model.setArrangeFirstTime(false);
                this.model.arrange();
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.build();
            this.buildSelected();
            this.repaint();
        } else if (command.equals("filter")) {
            this.filter();
        } else if (command.equals("open")) {
            this.openURL();
        } else if (command.equals(this.nodeOptActionStrArray[0])) {
            if (this.getActionMode() == 7 && this.isNodeSelected(this.context)) {
                this.selectConnectedNodes(((NLDNode)this.context).getIndex(), true);
            }
        } else if (command.equals(this.nodeOptActionStrArray[1])) {
            this.selectAllConnectedNodes();
        } else if (command.equals(this.nodeOptActionStrArray[2])) {
            if (this.selectedNodesIndices.size() > 0) {
                this.doSuperSetEnable = true;
                this.toggleVisibliltyOfUnselectedNodes(false);
                if (this.model.nodes.size() - this.toggledNodeList.size() > 1) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (!(this.dstype.equals(this.hierEng) || this.dstype.equals(this.hierNLS) || this.isUserLayout() || this.selectedNodesIndices.size() <= 0)) {
                        this.model.setArrangeFirstTime(true);
                        this.model.arrange();
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                    this.build();
                    this.buildSelected();
                    this.repaint();
                }
            }
        } else if (command.equals(this.nodeOptActionStrArray[3])) {
            this.doSuperSetEnable = false;
            this.toggleVisibliltyOfUnselectedNodes(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!(this.dstype.equals(this.hierEng) || this.dstype.equals(this.hierNLS) || this.isUserLayout())) {
                this.model.setArrangeFirstTime(true);
                this.model.arrange();
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.build();
            this.buildSelected();
            this.repaint();
        }
        this.context = null;
    }

    private void read_X_Y_Positions() {
        this.model.loadNodePositions();
    }

    private void toggleVisibliltyOfUnselectedNodes(boolean flag) {
        int nNodes;
        if (!flag) {
            nNodes = this.model.nodes.size();
            for (int i = 0; i < nNodes; ++i) {
                NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
                n.setVisible(n.isSelected());
                if (n.isSelected()) continue;
                this.toggledNodeList.addElement(new Integer(i));
            }
        } else {
            nNodes = this.model.nodes.size();
            for (int i = 0; i < nNodes; ++i) {
                ((NLDNode)this.model.nodes.elementAt(i)).setVisible(true);
            }
            this.toggledNodeList.clear();
        }
        this.myMouseAction = true;
        int cntr = 0;
        int nSelNodes = this.selectedNodesIndices.size();
        int[] select_indices = new int[nSelNodes];
        for (int i = 0; i < nSelNodes; ++i) {
            Object value = this.selectedNodesIndices.elementAt(i);
            if (value == null) {
                --i;
                continue;
            }
            select_indices[i] = ((Number)value).intValue();
            ++cntr;
        }
        this.model.nodes.setSelected(select_indices, false, cntr, this.handleEvents);
        this.selectedNodesIndices.clear();
        this.myMouseAction = false;
        this.model.updateLinks();
        if (this.handleEvents) {
            if (!this.isUserLayout()) {
                this.calculateCentroid();
            }
            int nodeCount = this.toggledNodeList.size();
            int[] nodeIdxArray = new int[nodeCount];
            cntr = 0;
            for (int i = 0; i < nodeCount; ++i) {
                Object value = this.toggledNodeList.elementAt(i);
                if (value == null) {
                    --i;
                    continue;
                }
                nodeIdxArray[i] = ((Number)value).intValue();
                ++cntr;
            }
            this.buildSelected(nodeIdxArray, cntr, null, 0);
        }
        this.build();
        this.repaint();
        this.toggledNodeList = new Vector();
    }

    private void analyze() {
        VectorLinkModel links = this.model.links;
        this.numLinks = links.size();
        for (int i = 0; i < this.numLinks; ++i) {
            NLDLink a = (NLDLink)links.elementAt(i);
            if (a.getFromIndex() != -1 && a.getToIndex() != -1) continue;
            links.dynamicRemove(i);
            --i;
            --this.numLinks;
        }
    }

    public void updateLinkHeads() {
        VectorLinkModel links = this.model.links;
        for (int i = 0; i < this.numLinks; ++i) {
            NLDLink alink = (NLDLink)links.elementAt(i);
            alink.setDirected(this.model.getDefaultDirected());
        }
        this.model.updateLinks();
    }

    private void placeArcNodes() {
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.arranging.txt", "Arranging diagram..."));
        }
        VectorNodeModel nodes = this.model.nodes;
        if (!this.layout.equalsIgnoreCase(this.userEng) && !this.layout.equalsIgnoreCase(this.userNLS)) {
            double rad = 0.8;
            int deno = this.numNodes > 2 ? this.numNodes - 2 : 2;
            for (int ind = 0; ind < this.numNodes; ++ind) {
                double x = rad * Math.cos(Math.PI * 2 * (double)ind / (double)deno);
                double y = rad * Math.sin(Math.PI * 2 * (double)ind / (double)deno);
                nodes.setInitX(ind, x);
                nodes.setInitY(ind, y);
            }
        } else {
            this.proj();
            this.unprojectNodes();
        }
        VectorLinkModel arcs = this.model.links;
        if (this.colmapLinks) {
            int r;
            double[] values = new double[this.numLinks];
            double min = Double.MAX_VALUE;
            double max = -min;
            for (r = 0; r < this.numLinks; ++r) {
                values[r] = arcs.getNumValue(6, r);
                min = Math.min(min, values[r]);
                max = Math.max(max, values[r]);
            }
            if (max == min) {
                Color c = this.colmap(0.5);
                for (int r2 = 0; r2 < this.numLinks; ++r2) {
                    arcs.setColor(r2, c);
                    this.linkColors[r2] = c;
                }
            } else {
                for (r = 0; r < this.numLinks; ++r) {
                    double value = (values[r] - min) / (max - min);
                    Color c = this.colmap(value);
                    arcs.setColor(r, c);
                    this.linkColors[r] = c;
                }
            }
        }
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
    }

    private void initLinkMinMaxValueColorWidth() {
        double colval;
        double linkWidth;
        double value;
        VectorLinkModel links = this.model.links;
        this.numLinks = links.size();
        if (this.numLinks <= 0) {
            return;
        }
        double maxValue = value = links.getNumValue(6, 0);
        double minValue = value;
        double maxWidthValVal = linkWidth = links.getNumValue(5, 0);
        double minWidthValVal = linkWidth;
        double maxColVal = colval = links.getNumValue(10, 0);
        double minColVal = colval;
        for (int i = 0; i < this.numLinks; ++i) {
            value = links.getNumValue(6, i);
            minValue = Math.min(minValue, value);
            maxValue = Math.max(maxValue, value);
            linkWidth = links.getNumValue(5, i);
            minWidthValVal = Math.min(minWidthValVal, linkWidth);
            maxWidthValVal = Math.max(maxWidthValVal, linkWidth);
            colval = links.getNumValue(10, i);
            minColVal = Math.min(minColVal, colval);
            maxColVal = Math.max(maxColVal, colval);
        }
        if (minColVal == Double.MAX_VALUE && maxColVal == Double.MIN_VALUE) {
            maxColVal = minColVal;
        }
        if (minValue == Double.MAX_VALUE && maxValue == Double.MIN_VALUE) {
            maxValue = minValue;
        }
        if (minWidthValVal == Double.MAX_VALUE && maxWidthValVal == Double.MIN_VALUE) {
            minWidthValVal = maxWidthValVal;
        }
        this.minLinkVal = minValue;
        this.maxLinkVal = maxValue;
        this.minLColVal = minColVal;
        this.maxLColVal = maxColVal;
        this.minWidth = minWidthValVal;
        this.maxWidth = maxWidthValVal;
    }

    protected void initNodeMinMaxValueColorSize() {
        double maxNSize;
        double maxColVal;
        double maxVal;
        VectorNodeModel nodes = this.model.nodes;
        if (this.numNodes <= 0) {
            return;
        }
        double minVal = maxVal = nodes.getNumValue(7, 0);
        double minColVal = maxColVal = nodes.getNumValue(16, 0);
        double minNSize = maxNSize = nodes.getNumValue(5, 0);
        for (int i = 1; i < this.numNodes; ++i) {
            double nodeval = nodes.getNumValue(7, i);
            minVal = Math.min(minVal, nodeval);
            maxVal = Math.max(maxVal, nodeval);
            double colval = nodes.getNumValue(16, i);
            minColVal = Math.min(minColVal, colval);
            maxColVal = Math.max(maxColVal, colval);
            double size = nodes.getNumValue(5, i);
            minNSize = Math.min(minNSize, size);
            maxNSize = Math.max(maxNSize, size);
        }
        if (minColVal == Double.MAX_VALUE && maxColVal == Double.MIN_VALUE) {
            maxColVal = minColVal;
        }
        if (minVal == Double.MAX_VALUE && maxVal == Double.MIN_VALUE) {
            maxVal = minVal;
        }
        if (minNSize == Double.MAX_VALUE && maxNSize == Double.MIN_VALUE) {
            minNSize = maxNSize;
        }
        this.minNColVal = minColVal;
        this.maxNColVal = maxColVal;
        this.minNodeVal = minVal;
        this.maxNodeVal = maxVal;
        this.minSize = minNSize;
        this.maxSize = maxNSize;
    }

    private void setArcAttr() {
        if (this.layout.equalsIgnoreCase(this.userEng) || this.layout.equalsIgnoreCase(this.userNLS)) {
            double[] wl = new double[2];
            double[] wr = new double[2];
            wl = this.unProject(0.0, 0.0, wl);
            wr = this.unProject(1.0, 0.0, wr);
            double pixsz = wr[0] - wl[0];
            pixsz = 1.0;
            this.setDefaultArrowSize(15.0 * pixsz);
        } else {
            this.setDefaultArrowSize(0.05);
        }
        VectorLinkModel links = this.model.links;
        this.numLinks = links.size();
        if (this.numLinks <= 0) {
            return;
        }
        this.linkColors = new Color[this.numLinks];
        this.linkWidths = new double[this.numLinks];
        for (int i = 0; i < this.numLinks; ++i) {
            NLDLink alink = (NLDLink)links.elementAt(i);
            alink.setSelectColor(this.selectColor);
            if (!this.dstype.equalsIgnoreCase("assoc")) {
                if (alink.getColor() == null) {
                    links.setColor(i, this.linkColor);
                    this.linkColors[i] = this.linkColor;
                } else if (links.getValue(10, i) == null) {
                    this.setColorMappingLinks(false);
                }
            } else if (links.getValue(10, i) == null && links.getValue(6, i) == null) {
                this.setColorMappingLinks(false);
            }
            alink.setDirected(this.model.getDefaultDirected());
        }
    }

    protected void setNodeAttr() {
        VectorNodeModel nodes = this.model.nodes;
        this.numNodes = nodes.size();
        if (this.numNodes <= 0) {
            return;
        }
        boolean user = this.layout.equalsIgnoreCase(this.userEng) || this.layout.equalsIgnoreCase(this.userNLS);
        this.setPixelSize(1.0);
        this.nodeColors = new Color[this.numNodes];
        this.nodeSizes = new double[this.numNodes];
        this.nodeShapes = new int[this.numNodes];
        if (this.shapeMapNodes) {
            this.setTextValign(0);
            this.setTextHalign(1);
            this.channel.setTextBorderType(0);
        } else if (this.fixedShapeNoneSelected) {
            this.setTextValign(1);
            this.setTextHalign(1);
            this.channel.setTextBorderType(3);
        } else {
            this.setTextValign(0);
            this.setTextHalign(1);
            this.channel.setTextBorderType(0);
        }
        for (int i = 0; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            if (!this.dstype.equalsIgnoreCase("assoc")) {
                if (n.getColor() == null) {
                    nodes.setColor(i, this.nodeColor);
                    this.nodeColors[i] = this.nodeColor;
                } else if (nodes.getValue(16, i) == null) {
                    this.setColorMappingNodes(false);
                }
            } else if (nodes.getValue(16, i) == null && nodes.getValue(7, i) == null) {
                this.setColorMappingNodes(false);
            }
            n.setShowLabel(this.showLabels);
            n.setTextColor(this.textColor);
            n.setSelectColor(this.selectColor);
            if (!this.dstype.equalsIgnoreCase("assoc") && n.getSize() < 0.0) {
                if (user) {
                    nodes.setSize(i, this.nodeSizes[i]);
                    nodes.setSize(i, (double)this.defaultUserNodeSize);
                } else {
                    this.nodeSizes[i] = this.defaultNodeSize;
                    nodes.setSize(i, this.defaultNodeSize);
                }
            }
            this.nodeShapes[i] = n.getType();
        }
    }

    protected void setNodeSize(double scaledValue, int ind, boolean doSizeMap) {
        double scaledSize;
        boolean user;
        VectorNodeModel nodes = this.model.nodes;
        double size = nodes.getNumValue(5, ind);
        boolean bl = user = this.layout.equalsIgnoreCase(this.userEng) || this.layout.equalsIgnoreCase(this.userNLS);
        if (!user) {
            if (this.sizeMapNodes) {
                if (doSizeMap) {
                    if (this.applet != null && this.minSize == this.maxSize) {
                        if (this.minNodeVal == this.maxNodeVal) {
                            scaledSize = this.defaultNodeSize;
                        } else {
                            scaledSize = (size - this.minNodeVal) / (this.maxNodeVal - this.minNodeVal);
                            scaledSize = this.defaultNodeSize + scaledValue * this.defaultNodeSizeIncrease;
                        }
                    } else if (this.minSize == this.maxSize) {
                        scaledSize = this.defaultNodeSize;
                    } else if (this.scaleNodeSize) {
                        if (size < 0.0) {
                            scaledSize = this.defaultNodeSize;
                        } else {
                            scaledSize = (size - this.minSize) / (this.maxSize - this.minSize);
                            scaledSize = this.defaultNodeSize * (1.0 + scaledSize);
                        }
                    } else {
                        scaledSize = size < 0.0 ? this.defaultNodeSize : size;
                    }
                } else if (this.minNodeVal == this.maxNodeVal) {
                    scaledSize = this.defaultNodeSize;
                } else {
                    scaledSize = scaledValue;
                    scaledSize = this.defaultNodeSize * (1.0 + scaledSize);
                }
            } else {
                scaledSize = this.nodeSize < 0.0 ? this.defaultNodeSize : this.defaultNodeSize * (1.0 + this.nodeSize / 100.0);
            }
        } else {
            double nValue;
            scaledSize = this.sizeMapNodes ? (doSizeMap ? (this.applet != null && this.minSize == this.maxSize ? (this.minNodeVal == this.maxNodeVal ? (double)this.defaultUserNodeSize + 0.5 * (double)this.defaultUserNodeSize : (double)this.defaultUserNodeSize + scaledValue * (double)this.defaultUserNodeSize) : (this.minSize == this.maxSize ? (double)this.defaultUserNodeSize : (size < 0.0 ? (double)this.defaultUserNodeSize : size))) : (this.minNodeVal == this.maxNodeVal ? (double)this.defaultUserNodeSize : (nValue = nodes.getNumValue(7, ind)))) : (this.nodeSize < 0.0 ? (double)this.defaultUserNodeSize : (double)this.defaultUserNodeSize * (1.0 + this.nodeSize / 100.0));
        }
        this.nodeSizes[ind] = scaledSize;
        nodes.setSize(ind, this.nodeSizes[ind]);
    }

    protected void setLinkWidth(double scaledValue, int ind, boolean doWidthMap) {
        double scaledWidth;
        VectorLinkModel links = this.model.links;
        double width = links.getNumValue(5, ind);
        if (this.widthMapLinks) {
            if (doWidthMap) {
                if (this.minWidth == this.maxWidth) {
                    scaledWidth = 3.0;
                } else if (this.scaleLinkWidth) {
                    scaledWidth = 1.0 * (width - this.minWidth) / (this.maxWidth - this.minWidth);
                    scaledWidth = this.defaultLinkWidth + scaledWidth * this.defaultLinkWidthIncrease;
                } else {
                    scaledWidth = width;
                }
            } else if (this.minLinkVal == this.maxLinkVal) {
                scaledWidth = 3.0;
            } else {
                scaledWidth = scaledValue;
                scaledWidth = this.defaultLinkWidth + scaledWidth * this.defaultLinkWidthIncrease;
            }
        } else {
            scaledWidth = this.linkWidth;
        }
        this.linkWidths[ind] = scaledWidth;
        links.setWidth(ind, this.linkWidths[ind]);
    }

    protected void setNodeShape(int ind, boolean doShapemap) {
        VectorNodeModel nodes = this.model.nodes;
        int shapeVal = (int)nodes.getNumValue(6, ind);
        int shapeType = DEFAULT_SHAPE_TYPE;
        if (this.shapeMapNodes) {
            shapeType = doShapemap ? (shapeVal == -1 ? DEFAULT_SHAPE_TYPE : shapeVal % 4) : ConstViewer.shapeToType((String)this.model.getNodeShape());
            this.nodeShapes[ind] = shapeType;
            nodes.setShape(ind, ConstViewer.shapeTypeToString((int)shapeType));
            nodes.setType(ind, this.nodeShapes[ind]);
        } else {
            this.nodeShapes[ind] = ConstViewer.shapeToType((String)this.model.getNodeShape());
            nodes.setShape(ind, this.model.getNodeShape());
            nodes.setType(ind, this.nodeShapes[ind]);
        }
    }

    protected void setNodeColor(double scaledValue, int ind, boolean doColmap) {
        VectorNodeModel nodes = this.model.nodes;
        NLDNode n = (NLDNode)nodes.elementAt(ind);
        double colval = nodes.getNumValue(16, ind);
        double scaledColVal = 0.0;
        if (this.colmapNodes) {
            if (doColmap) {
                if (this.applet != null && this.maxNColVal == this.minNColVal) {
                    if (this.minNodeVal == this.maxNodeVal) {
                        scaledColVal = 0.5;
                    } else {
                        double value = this.model.nodes.getNumValue(7, ind);
                        scaledColVal = 1.0 * (value - this.minNodeVal) / (this.maxNodeVal - this.minNodeVal);
                    }
                } else {
                    scaledColVal = this.maxNColVal == this.minNColVal ? 1.0 : 1.0 * (colval - this.minNColVal) / (this.maxNColVal - this.minNColVal);
                }
            } else {
                scaledColVal = this.minNodeVal == this.maxNodeVal ? 1.0 : scaledValue;
            }
            Color nColor = n.getColor();
            this.nodeColors[ind] = nColor == null ? this.colmap(scaledColVal) : nColor;
            nodes.setColor(ind, this.nodeColors[ind]);
        } else {
            this.nodeColors[ind] = this.nodeColor;
            nodes.setColor(ind, this.nodeColor);
        }
    }

    protected void setLinkColor(double scaledValue, int ind, boolean doColmap) {
        VectorLinkModel links = this.model.links;
        NLDLink l = (NLDLink)links.elementAt(ind);
        double colval = links.getNumValue(10, ind);
        double scaledColVal = 0.0;
        if (this.colmapLinks) {
            if (doColmap) {
                if (this.applet != null && this.maxLColVal == this.minLColVal) {
                    if (this.minLinkVal == this.maxLinkVal) {
                        links.setColor(ind, this.linkColor);
                    } else {
                        scaledColVal = scaledValue;
                    }
                } else {
                    scaledColVal = this.maxLColVal == this.minLColVal ? 1.0 : 1.0 * (colval - this.minLColVal) / (this.maxLColVal - this.minLColVal);
                }
            } else {
                scaledColVal = this.minLinkVal == this.maxLinkVal ? 1.0 : scaledValue;
            }
            Color lColor = l.getColor();
            this.linkColors[ind] = lColor == null ? this.colmap(scaledColVal) : lColor;
            links.setColor(ind, this.linkColors[ind]);
        } else {
            this.linkColors[ind] = this.linkColor;
            links.setColor(ind, this.linkColor);
        }
    }

    public void setNodeLabelTextColor() {
        int ind = 0;
        while (ind < this.numNodes) {
            this.setNodeLabelTextColor(ind++);
        }
    }

    protected void setNodeLabelTextColor(int index) {
        NLDNode n = (NLDNode)this.model.nodes.elementAt(index);
        if (!this.shapeMapNodes && this.fixedShapeNoneSelected && this.colmapNodes) {
            Color nColor = this.nodeColors[index];
            if (nColor != null) {
                float[] vals = new float[4];
                float luminance = 0.299f * (vals = nColor.getComponents(vals))[0] + 0.587f * vals[1] + 0.114f * vals[2];
                if (luminance > 0.5686f) {
                    n.setTextColor(Color.black);
                } else {
                    n.setTextColor(Color.white);
                }
            } else {
                n.setTextColor(this.textColor);
            }
        } else {
            n.setTextColor(this.textColor);
        }
    }

    private void placeAssocNodes() {
        double scaledWidth;
        NLDNode n;
        int ind;
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.arranging.txt", "Arranging diagram..."));
        }
        VectorNodeModel nodes = this.model.nodes;
        this.initNodeMinMaxValueColorSize();
        boolean user = this.layout.equalsIgnoreCase(this.userEng) || this.layout.equalsIgnoreCase(this.userNLS);
        boolean doColmap = true;
        boolean doSizeMap = true;
        if (!user) {
            this.proj();
            for (ind = 0; ind < this.numNodes; ++ind) {
                n = (NLDNode)this.model.nodes.elementAt(ind);
                double value = nodes.getNumValue(7, ind);
                double scaledValue = this.minNodeVal == this.maxNodeVal ? 1.0 : 1.0 * (value - this.minNodeVal) / (this.maxNodeVal - this.minNodeVal);
                this.setNodeColor(scaledValue, ind, doColmap);
                this.setNodeSize(scaledValue, ind, doSizeMap);
                this.setNodeShape(ind, true);
                this.setNodeLabelTextColor(ind);
            }
        } else {
            this.proj();
            this.unprojectNodes();
            for (ind = 0; ind < this.numNodes; ++ind) {
                n = (NLDNode)this.model.nodes.elementAt(ind);
                double scaledValue = 1.0;
                if (this.minNodeVal == this.maxNodeVal && this.minNodeVal < 0.0) {
                    if (!(n.getSize() < 0.0)) continue;
                    this.nodeSizes[ind] = this.defaultUserNodeSize;
                    nodes.setSize(ind, this.nodeSizes[ind]);
                    continue;
                }
                if (this.minNodeVal == this.maxNodeVal) {
                    scaledValue = 1.0;
                } else {
                    double value = nodes.getNumValue(7, ind);
                    scaledValue = 1.0 * (value - this.minNodeVal) / (this.maxNodeVal - this.minNodeVal);
                }
                this.setNodeColor(scaledValue, ind, doColmap);
                this.setNodeSize(scaledValue, ind, doSizeMap);
                this.setNodeLabelTextColor(ind);
                Object o = nodes.getValue(6, ind);
                int type = 0;
                if (o != null && o instanceof Number) {
                    type = ((Number)o).intValue();
                }
                this.nodeShapes[ind] = type;
                nodes.setType(ind, type);
            }
        }
        VectorLinkModel links = this.model.links;
        this.initLinkMinMaxValueColorWidth();
        this.maxcnt = this.maxLinkVal - this.minLinkVal;
        this.minval = this.minLinkVal;
        this.mincnt = this.support;
        if (this.scaleSupport) {
            this.mincnt = this.minval + this.support * this.maxcnt / 100.0;
        }
        doColmap = true;
        boolean doWidthMap = false;
        if (this.minLinkVal == this.maxLinkVal) {
            double scaledValue = 1.0;
            boolean cull = false;
            for (int i = 0; i < this.numLinks; ++i) {
                if (!user) {
                    this.setLinkWidth(scaledValue, i, doWidthMap);
                } else {
                    double linkWidth = links.getNumValue(5, i);
                    if (linkWidth < 0.0) {
                        this.linkWidths[i] = scaledWidth = this.defaultLinkWidth;
                        links.setWidth(i, scaledWidth);
                    }
                }
                this.setLinkColor(scaledValue, i, doColmap);
                links.setCulled(i, cull);
            }
        } else {
            for (int i = 0; i < this.numLinks; ++i) {
                double value = links.getNumValue(6, i);
                double scaledValue = 1.0 * (value - this.minLinkVal) / (this.maxLinkVal - this.minLinkVal);
                links.setCulled(i, value < this.mincnt);
                this.setLinkColor(scaledValue, i, doColmap);
                if (!user) {
                    this.setLinkWidth(scaledValue, i, doWidthMap);
                    continue;
                }
                double linkWidth = links.getNumValue(5, i);
                if (!(linkWidth < 0.0)) continue;
                this.linkWidths[i] = scaledWidth = this.defaultLinkWidth + this.defaultLinkWidthIncrease * scaledValue;
                links.setWidth(i, scaledWidth);
            }
        }
    }

    private void placeHierNodes() {
        Color col;
        double colval;
        double y;
        double x;
        double rang;
        double angle;
        double size;
        String currsub;
        NLDNode n;
        NLDLink a;
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.analyzing.txt", "Analyzing diagram..."));
        }
        int numsubs = 0;
        VectorLinkModel links = this.model.links;
        VectorNodeModel nodes = this.model.nodes;
        int num = links.size();
        Hashtable<String, NLDNode> subsTable = new Hashtable<String, NLDNode>();
        for (int r = 0; r < num; ++r) {
            a = (NLDLink)links.elementAt(r);
            int i = a.getFromIndex();
            n = (NLDNode)nodes.elementAt(i);
            currsub = n.getID();
            if (subsTable.containsKey(currsub)) continue;
            ++numsubs;
            subsTable.put(currsub, n);
        }
        Vector subs = new Vector();
        Enumeration elems = subsTable.elements();
        while (elems.hasMoreElements()) {
            subs.addElement(elems.nextElement());
        }
        int[] subcnt = new int[numsubs];
        double[] subtot = new double[numsubs];
        double[] submin = new double[numsubs];
        double[] submax = new double[numsubs];
        double filemin = 0.0;
        double filemax = 0.0;
        int sid = -1;
        int numNodes = nodes.numNodes() + 1;
        int numrows = numNodes - 1 - numsubs;
        for (int r = 0; r < numsubs; ++r) {
            subcnt[r] = 0;
        }
        Vector[] kids = new Vector[numsubs];
        for (int r = 0; r < num; ++r) {
            a = (NLDLink)links.elementAt(r);
            if (!a.isVisible()) continue;
            int index = a.getFromIndex();
            n = nodes.getNode(index);
            sid = subs.indexOf(n);
            size = a.getValue();
            if (size == 0.0) {
                System.out.println(this.GRS("StatusText.wrongSize.txt", "wrong size"));
            } else {
                a.setValue(size);
            }
            if (r == 0) {
                filemin = size;
                filemax = size;
            } else {
                filemin = Math.min(filemin, size);
                filemax = Math.max(filemax, size);
            }
            if (subcnt[sid] == 0) {
                subcnt[sid] = 1;
                subtot[sid] = size;
                submin[sid] = size;
                submax[sid] = size;
                kids[sid] = new Vector();
            } else {
                int n2 = sid;
                subcnt[n2] = subcnt[n2] + 1;
                int n3 = sid;
                subtot[n3] = subtot[n3] + size;
                submin[sid] = Math.min(submin[sid], size);
                submax[sid] = Math.max(submax[sid], size);
            }
            n = nodes.getNode(a.getToIndex());
            a.setValue(size);
            kids[sid].addElement(n);
        }
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus(this.GRS("StatusText.assembling.txt", "Assembling diagram"));
        }
        double[] subang = new double[numsubs];
        double bigsub = 0.0;
        double smallsub = 0.0;
        for (sid = 0; sid < numsubs; ++sid) {
            if (sid == 0) {
                subang[0] = 0.0;
                bigsub = subtot[0];
                smallsub = subtot[0];
                continue;
            }
            subang[sid] = subang[sid - 1] + 360.0 * (double)subcnt[sid - 1] / (double)numrows;
            bigsub = Math.max(bigsub, subtot[sid]);
            smallsub = Math.min(smallsub, subtot[sid]);
        }
        NLDNode center = new NLDNode(0.0, 0.0);
        center.setID("Center");
        nodes.addObservation(center);
        int centerInd = nodes.indexOf((Object)center);
        center.setIndex(centerInd);
        center.setVisible(true);
        center.setType(4);
        center.setShowLabel(false);
        double rad1 = 0.4;
        if (this.lens) {
            rad1 = 0.2;
        }
        for (sid = 0; sid < numsubs; ++sid) {
            angle = subang[sid] + 180.0 * (double)subcnt[sid] / (double)numrows;
            rang = angle * Math.PI / 180.0;
            x = 0.0 + rad1 * Math.sin(rang);
            y = 0.0 + rad1 * Math.cos(rang);
            n = (NLDNode)subs.elementAt(sid);
            n.setType(this.model.getNodeType());
            n.setSize(0.02);
            if (this.colmapNodes) {
                colval = (subtot[sid] - smallsub) / (bigsub - smallsub);
                col = this.colmap(colval);
                n.setColor(col);
                this.nodeColors[sid] = col;
            }
            n.setShowLabel(this.showLabels);
            n.setPosition(x, y);
            a = new NLDLink(centerInd, n.getIndex());
            a.setWidth(1.0);
            int idx = links.indexOf((Object)a);
            if (idx >= 0 && idx < this.linkWidths.length) {
                this.linkWidths[idx] = 1.0;
            }
            links.addObservation(a);
            a.setIndex(links.indexOf((Object)a));
            a.setIndex(links.indexOf((Object)a));
        }
        double rad2 = 0.8;
        for (sid = 0; sid < numsubs; ++sid) {
            int numkids = kids[sid].size();
            double midang = subang[sid] + 180.0 * (double)subcnt[sid] / (double)numrows;
            for (int i = 0; i < numkids; ++i) {
                n = (NLDNode)kids[sid].elementAt(i);
                currsub = n.getID();
                size = n.getValue();
                angle = midang + (double)(-1 + 2 * (i % 2)) * 180.0 * (double)(subcnt[sid] - i) / (double)numrows;
                rang = angle * Math.PI / 180.0;
                x = 0.0 + rad2 * Math.sin(rang);
                y = 0.0 + rad2 * Math.cos(rang);
                n.setPosition(x, y);
                if (this.colmapNodes) {
                    colval = submax[sid] == submin[sid] ? 0.5 : 1.0 * (size - submin[sid]) / (submax[sid] - submin[sid]);
                    col = this.colmap(colval);
                    n.setColor(col);
                    this.nodeColors[sid] = col;
                }
                n.setType(this.model.getNodeType());
                n.setSize(0.01);
                this.nodeSizes[sid] = 0.01;
                n.setShowLabel(this.showLabels);
            }
        }
        num = links.size();
        for (int i = 0; i < num; ++i) {
            a = (NLDLink)links.elementAt(i);
            n = (NLDNode)nodes.elementAt(a.getToIndex());
            links.setColor(i, n.getColor());
        }
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
    }

    public void setNodeSizes() {
        VectorNodeModel nodes = this.model.nodes;
        this.initNodeMinMaxValueColorSize();
        boolean user = this.layout.equalsIgnoreCase(this.userEng) || this.layout.equalsIgnoreCase(this.userNLS);
        boolean doSizeMap = true;
        if (!user) {
            for (int ind = 0; ind < this.numNodes; ++ind) {
                NLDNode n = (NLDNode)this.model.nodes.elementAt(ind);
                n.setSize(this.nodeSizes[ind]);
            }
        } else {
            this.proj();
            this.unprojectNodes();
            for (int ind = 0; ind < this.numNodes; ++ind) {
                NLDNode n = (NLDNode)this.model.nodes.elementAt(ind);
                double scaledValue = 1.0;
                if (this.minNodeVal == this.maxNodeVal && this.minNodeVal < 0.0) {
                    if (!(n.getSize() < 0.0)) continue;
                    nodes.setSize(ind, (double)this.defaultUserNodeSize);
                    continue;
                }
                if (this.minNodeVal == this.maxNodeVal) {
                    scaledValue = 1.0;
                } else {
                    double value = nodes.getNumValue(7, ind);
                    scaledValue = (value - this.minNodeVal) / (this.maxNodeVal - this.minNodeVal);
                }
                this.setNodeSize(scaledValue, ind, doSizeMap);
            }
        }
    }

    public void setLinkWidths() {
        VectorLinkModel links = this.model.links;
        int numLinks = links.size();
        for (int i = 0; i < numLinks; ++i) {
            links.setWidth(i, this.linkWidths[i]);
        }
    }

    public void setNodeShapes() {
        VectorNodeModel nodes = this.model.nodes;
        int numNodes = nodes.size();
        this.textBorderType = 0;
        this.setTextValign(0);
        this.setTextHalign(1);
        this.channel.setTextBorderType(this.textBorderType);
        for (int i = 0; i < numNodes; ++i) {
            NLDNode n = (NLDNode)nodes.elementAt(i);
            n.setType(this.nodeShapes[i]);
        }
    }

    public void setNodeShape(String shape) {
        super.setNodeShape(shape);
        if (!shape.equalsIgnoreCase(noneEng) && !shape.equalsIgnoreCase(noneNLS)) {
            this.textBorderType = 0;
            this.setTextValign(0);
            this.setTextHalign(1);
            this.channel.setTextBorderType(this.textBorderType);
        } else {
            this.textBorderType = 3;
            this.setTextValign(1);
            this.setTextHalign(1);
            this.channel.setTextBorderType(this.textBorderType);
        }
    }

    public void setNodeShape(String shape, boolean changeNodeShape) {
        if (shape == null) {
            return;
        }
        this.setNodeShape(shape);
        if (changeNodeShape) {
            int type = this.model.getNodeType();
            VectorNodeModel nodes = this.model.nodes;
            int numNodes = nodes.size();
            for (int i = 0; i < numNodes; ++i) {
                NLDNode n = (NLDNode)nodes.elementAt(i);
                n.setType(type);
            }
        }
    }

    public void setHandlePopup(boolean val) {
        this.handlePopup = val;
    }

    public void setDefaultNodeSize(double size) {
        this.defaultNodeSize = size;
    }

    public void setBuildDate(String bldDate) {
        if (bldDate != null) {
            this.buildDate = bldDate;
        }
    }

    public void layoutChart() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.dstype.equals(this.hierEng) && !this.dstype.equals(this.hierNLS)) {
            this.model.arrange();
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.build();
        this.repaint();
    }

    public void setMenuItems(JMenuItem mi) {
        if (mi.getActionCommand().equalsIgnoreCase(this.nodeOptActionStrArray[0])) {
            this.selConNode = mi;
        } else if (mi.getActionCommand().equalsIgnoreCase(this.nodeOptActionStrArray[1])) {
            this.selAllConNode = mi;
        } else if (mi.getActionCommand().equalsIgnoreCase(this.nodeOptActionStrArray[2])) {
            this.subSet = mi;
        } else if (mi.getActionCommand().equalsIgnoreCase(this.nodeOptActionStrArray[3])) {
            this.superSet = mi;
        }
    }

    public void setNodeOptMenu(JMenu m) {
        this.nodeOptMenu = m;
    }

    public void setActionMenu(JMenu m) {
        this.actionMenu = m;
    }

    public void setNodeOptionActionArray(String[] actionCmd) {
        for (int i = 0; i < actionCmd.length; ++i) {
            this.nodeOptActionStrArray[i] = actionCmd[i];
        }
    }

    public Hashtable getSubsetNodes() {
        int nNodes = this.model.nodes.size();
        Vector<String> visNodes = new Vector<String>();
        Vector<String> invisNodes = new Vector<String>();
        for (int i = 0; i < nNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            if (n.isVisible()) {
                visNodes.addElement(n.getID());
                continue;
            }
            invisNodes.addElement(n.getID());
        }
        if (visNodes.size() <= invisNodes.size()) {
            if (visNodes.size() > 0) {
                Hashtable<Integer, Vector<String>> retHashTable = new Hashtable<Integer, Vector<String>>();
                retHashTable.put(new Integer(1), visNodes);
                return retHashTable;
            }
            return null;
        }
        if (invisNodes.size() > 0) {
            Hashtable<Integer, Vector<String>> retHashTable = new Hashtable<Integer, Vector<String>>();
            retHashTable.put(new Integer(0), invisNodes);
            return retHashTable;
        }
        return null;
    }

    public void setSubsetNodes(Vector nodeIds, boolean areNodesVisible) {
        if (nodeIds == null || nodeIds.size() == 0) {
            return;
        }
        this.subSetNodeIds = nodeIds;
        this.subSetNodesVisibility = areNodesVisible;
        this.doSuperSetEnable = true;
    }

    public Object getId() {
        if (this.id == null) {
            this.id = "Constellation";
        }
        return this.id;
    }
}

