/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.GraphToolbarInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.interfaces.TreeInterface;
import com.sas.graphics.silk.treeview.DataFilterTreeViewer;
import com.sas.graphics.silk.ui.BaseLinksPanel;
import com.sas.graphics.silk.ui.BaseNodesPanel;
import com.sas.graphics.silk.ui.DataOptionsDialog;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.RoleManager;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.nld.DataFilterLinkModel;
import com.sas.graphics.silk.util.nld.DataFilterModel;
import com.sas.graphics.silk.util.nld.DataFilterNodeModel;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.nld.NLD;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.VectorNodeModel;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.border.LineBorder;

public class TreeviewComponent
extends JComponent
implements TreeInterface,
Printable,
MouseListener,
ActionListener,
GraphInterface,
RoleInterface,
PropertyInterface,
RoleListenerInterface,
ItemListener {
    private static final long serialVersionUID = -6754160566988607114L;
    protected GradientPaint gp;
    protected Image backImage;
    protected Image gpBackImage;
    protected Image scaledBackImage;
    protected double imageBlend;
    protected int imageFitStyle;
    protected boolean bufferUpdateRequired;
    protected int gradientOrientation;
    private JPopupMenu popup;
    private DataFilterTreeViewer chart;
    private DataFilterModel model;
    private boolean showPopup = true;
    private Component toolbar = null;
    private Frame parentFrame = null;
    private ResourceBundle resourceBundle;
    private JMenuItem grphOptions = null;
    private JMenuItem dataOptions = null;
    private JMenuItem actionToolbar = null;
    private ColorSchemeInterface colorScheme = null;
    private int noBreakPoints = 3;
    private Double[] breakpoints = new Double[this.noBreakPoints];
    private Color[] colors = new Color[this.noBreakPoints];
    private long flags;
    private ColorRamp clrRamp;
    private Dialog graphDialog = null;
    private Hashtable properties = null;
    private boolean chartLoaded = false;
    private boolean widthMappingLinks = true;
    private boolean colorMappingLinks = true;
    private boolean fixColorLinks = false;
    private int lwidth = 1;
    Cursor zoomCursor;
    Cursor moveOpen;
    private JPopupMenu onNodePopUp = null;
    private JPopupMenu offNodePopUp = null;
    Style style = null;
    private boolean colorMappingNodes = true;
    private boolean fixColorNodes = false;
    DataOptionsDialog dataDlg = null;
    private RoleManager roleManager = null;
    private Roles roleIndex = Roles.getInstance(null);
    private boolean firstShowDialog = true;

    public TreeviewComponent() {
        this.resourceBundle = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
        this.model = new DataFilterModel();
        this.chart = new DataFilterTreeViewer(this.model);
        this.chart.setInApplet(false);
        this.chart.setHandlePopup(false);
        this.moveOpen = this.chart.getMoveOpenCursor();
        if (this.moveOpen == null) {
            this.chart.setMoveOpenCursor(this.getCustomCursor(6, 2, "icons/MoveOpen.gif"));
        }
        if ((this.zoomCursor = this.chart.getZoomCursor()) == null) {
            this.chart.setZoomCursor(this.getCustomCursor(6, 2, "icons/Zoom.gif"));
        }
        this.setActionMode(4);
        this.moveOpen = this.chart.getMoveOpenCursor();
        if (this.moveOpen == null) {
            this.chart.setMoveOpenCursor(this.getCustomCursor(6, 2, "icons/MoveOpen.gif"));
        }
        this.chart.setColorMapping(false);
        this.chart.setDebug(false);
        this.chart.setRBSizing(true);
        String[] actionCmd = new String[]{"NLD_SET_ROOT", "NLD_SELECT_NODE", "NLD_SELECT_SUB_TREE", "NLD_HIDE_SUB_TREE"};
        this.chart.setNodeOptionActionArray(actionCmd);
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        ttm.registerComponent(this);
        ttm.setInitialDelay(0);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.chart));
        this.imageBlend = 1.0;
        this.imageFitStyle = 1;
        this.gradientOrientation = 0;
        this.roleManager = new RoleManager();
        this.roleManager.addRoleListener((RoleListenerInterface)this);
        this.addMouseListener(this);
        this.chart.addMouseListener(this);
        this.setStyle("SILKDefault");
        this.properties = new Hashtable();
        this.initRoleManager();
        SILKGlobal.register((PropertyInterface)this);
    }

    protected Cursor getCustomCursor(int x, int y, String imgName) {
        Image img = null;
        Toolkit tk = this.getToolkit();
        if (imgName == null || tk == null) {
            return null;
        }
        img = ResourceLoader.getImage((Component)this, (String)imgName);
        if (img == null) {
            return null;
        }
        Cursor c = null;
        if (!GraphicsEnvironment.isHeadless()) {
            c = tk.createCustomCursor(img, new Point(x, y), imgName);
        }
        return c;
    }

    public Object getId() {
        return this.chart.getId();
    }

    public void setId(Object id) {
        this.chart.setId(id);
    }

    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    public Object getChart(Object id) {
        return this.chart;
    }

    private void setActionMenuItemStatus(JMenu actionMenu) {
        if (actionMenu == null || !actionMenu.isEnabled()) {
            return;
        }
        switch (this.chart.getActionMode()) {
            case 5: {
                break;
            }
            case 3: {
                MenuUtilities.setMenuItemSelected((JMenu)actionMenu, (String)"ACTION_MODE_ZOOM", (boolean)true);
                break;
            }
            case 6: {
                MenuUtilities.setMenuItemSelected((JMenu)actionMenu, (String)"ACTION_MODE_SELECT", (boolean)true);
                break;
            }
            default: {
                MenuUtilities.setMenuItemSelected((JMenu)actionMenu, (String)"ACTION_MODE_PAN", (boolean)true);
            }
        }
    }

    private void createOnNodePopUp() {
        JCheckBoxMenuItem hideTree;
        JCheckBoxMenuItem selTree;
        JCheckBoxMenuItem selNode;
        JMenu subNodeOptMenu;
        JMenuItem setRoot;
        if (this.onNodePopUp != null) {
            return;
        }
        this.onNodePopUp = new JPopupMenu();
        if (this.grphOptions == null) {
            this.grphOptions = new JMenuItem(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"TreeviewComponent.Popup.GraphProperties.txt", (String)"Graph Properties..."));
            this.grphOptions.setActionCommand("grphOptions");
            this.grphOptions.addActionListener(this);
        }
        this.onNodePopUp.add(this.grphOptions);
        JMenu actionMenu = MenuUtilities.getMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/TreeviewComponentActionMenu.xml"), (ActionListener)this);
        this.setActionMenuItemStatus(actionMenu);
        this.onNodePopUp.add(actionMenu);
        this.onNodePopUp.addSeparator();
        if (this.dataOptions == null) {
            this.dataOptions = new JMenuItem(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"TreeviewComponent.Popup.DataOptions.txt", (String)"Data Options..."));
            this.dataOptions.setActionCommand("dataOptions");
            this.dataOptions.addActionListener(this);
        }
        this.onNodePopUp.add(this.dataOptions);
        this.onNodePopUp.addSeparator();
        JMenuItem copyToClipboard = new JMenuItem(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"TreeviewComponent.Popup.Copy.txt", (String)"Copy"));
        copyToClipboard.setActionCommand("copyToClipboard");
        copyToClipboard.addActionListener(this);
        this.onNodePopUp.add(copyToClipboard);
        this.onNodePopUp.addSeparator();
        if (SILKGlobal.isTestMode()) {
            ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.menus.silk_menus_NLS");
            JMenuItem saveAsXML = new JMenuItem(ResourceLoader.getResourceString((Object)rb, (String)"Popup.Save_As_XML.txt", (String)"Save As XML..."));
            saveAsXML.setActionCommand("saveAsXML");
            saveAsXML.addActionListener(this);
            this.onNodePopUp.add(saveAsXML);
            this.onNodePopUp.addSeparator();
        }
        if ((setRoot = MenuUtilities.getMenuItem((JMenu)(subNodeOptMenu = MenuUtilities.getMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/TreeviewComponentNodeOptMenu.xml"), (ActionListener)this)), (String)"NLD_SET_ROOT")) != null) {
            setRoot.addActionListener((ActionListener)((Object)this.chart));
        }
        if ((selNode = (JCheckBoxMenuItem)MenuUtilities.getMenuItem((JMenu)subNodeOptMenu, (String)"NLD_SELECT_NODE")) != null) {
            selNode.addItemListener((ItemListener)((Object)this.chart));
        }
        if ((selTree = (JCheckBoxMenuItem)MenuUtilities.getMenuItem((JMenu)subNodeOptMenu, (String)"NLD_SELECT_SUB_TREE")) != null) {
            selTree.addItemListener((ItemListener)((Object)this.chart));
        }
        if ((hideTree = (JCheckBoxMenuItem)MenuUtilities.getMenuItem((JMenu)subNodeOptMenu, (String)"NLD_HIDE_SUB_TREE")) != null) {
            hideTree.addItemListener((ItemListener)((Object)this.chart));
        }
        this.initViewerMenuItems(subNodeOptMenu);
        this.onNodePopUp.add(subNodeOptMenu);
        String helpString = this.chart.GRS("PopupMenu.Help.txt", "Help");
        String resetViewString = this.chart.GRS("PopupMenu.DWG.ResetView.txt", "Reset View");
        String selectString = this.chart.GRS("PopupMenu.DWG.Select.txt", "Select...");
        String selectAllString = this.chart.GRS("PopupMenu.DWG.SelectAll.txt", "Select All");
        String showAllNodesString = this.chart.GRS("PopupMenu.DWG.ShowAll.txt", "Show All Nodes");
        String setRootString = this.chart.GRS("PopupMenu.CS.SetRoot.txt", "Set Root");
        String selNodeString = this.chart.GRS("PopupMenu.CS.SelectNode.txt", "Select Node");
        String selSubTreeString = this.chart.GRS("PopupMenu.CS.SelectSubtree.txt", "Select Subtree");
        String hideSubTreeString = this.chart.GRS("PopupMenu.CS.HideSubtree.txt", "Hide Subtree");
        boolean remSepAfterShowAllNodes = false;
        JPopupMenu p = this.chart.getDefaultPopupMenu();
        for (int i = 0; i < p.getComponents().length; ++i) {
            Component c = p.getComponent(i);
            JMenuItem mi = null;
            JMenu m = null;
            if (c instanceof JMenu) {
                m = (JMenu)c;
            } else if (c instanceof JMenuItem) {
                mi = (JMenuItem)c;
            } else if (c instanceof JSeparator && remSepAfterShowAllNodes) {
                remSepAfterShowAllNodes = false;
                continue;
            }
            if (m != null && m.getText().equalsIgnoreCase(helpString) || mi != null && mi.getText().equalsIgnoreCase(resetViewString) || mi != null && mi.getText().equalsIgnoreCase(selectAllString) || mi != null && mi.getText().equalsIgnoreCase(selectString)) continue;
            if (mi != null && mi.getText().equalsIgnoreCase(showAllNodesString)) {
                remSepAfterShowAllNodes = true;
                continue;
            }
            if (mi != null && mi.getText().equalsIgnoreCase(setRootString) || mi != null && mi.getText().equalsIgnoreCase(selNodeString) || mi != null && mi.getText().equalsIgnoreCase(selSubTreeString) || mi != null && mi.getText().equalsIgnoreCase(hideSubTreeString)) continue;
            this.onNodePopUp.add(c);
            --i;
        }
    }

    private void setNodeOptMenuEnabled(boolean flag) {
        JPopupMenu p = this.onNodePopUp;
        if (p == null) {
            return;
        }
        String nodeOptMenuStr = this.chart.GRS("PopupMenu.CS.NodeOpt.txt", "Node Options");
        for (int i = 0; i < p.getComponents().length; ++i) {
            Component c = p.getComponent(i);
            JMenu m = null;
            if (c instanceof JMenu) {
                m = (JMenu)c;
            }
            if (m == null || !m.getText().equalsIgnoreCase(nodeOptMenuStr)) continue;
            m.setEnabled(flag);
            break;
        }
    }

    private void createOffNodePopUp() {
        if (this.onNodePopUp == null) {
            this.createOnNodePopUp();
        }
        this.offNodePopUp = this.onNodePopUp;
    }

    private void initViewerMenuItems(JMenu p) {
        if (p == null) {
            return;
        }
        for (int i = 0; i < p.getMenuComponentCount(); ++i) {
            Component c = p.getMenuComponent(i);
            JMenuItem mi = null;
            if (c instanceof JMenuItem) {
                mi = (JMenuItem)c;
            }
            if (mi == null) continue;
            this.chart.setMenuItems(mi);
        }
    }

    @Override
    public JPopupMenu getDefaultPopupMenu() {
        boolean showNodeMenuItems = this.isOnNode();
        if (showNodeMenuItems) {
            if (this.onNodePopUp == null) {
                this.createOnNodePopUp();
            }
            this.setNodeOptMenuEnabled(true);
            this.popup = this.onNodePopUp;
        } else {
            if (this.offNodePopUp == null) {
                this.createOffNodePopUp();
            }
            this.setNodeOptMenuEnabled(false);
            this.popup = this.offNodePopUp;
        }
        return this.popup;
    }

    private boolean isOnNode() {
        Object cntxt = this.chart.getCurrentContext();
        if (cntxt == null) {
            return false;
        }
        return cntxt instanceof NLDNode;
    }

    @Override
    public void setStartAngle(double val) {
        this.chart.setStartAngle(val);
    }

    public Color getBackColor() {
        return this.chart.getBackColor();
    }

    @Override
    public void reset() {
        this.chart.reset();
    }

    @Override
    public void showAll() {
        this.chart.showAll();
    }

    @Override
    public void hideSubtree(Object id, boolean state) {
        this.chart.hideSubtree(id, state);
    }

    @Override
    public void setSelected(Object o, boolean tree, boolean state, boolean update) {
        this.chart.setSelected(o, tree, state, update);
    }

    @Override
    public Object pick(int x, int y) {
        return this.chart.pick(x, y);
    }

    @Override
    public boolean isSubtreeSelected(Object obj) {
        return this.chart.isSubtreeSelected(obj);
    }

    @Override
    public boolean isRootDefault() {
        return this.chart.isRootDefault();
    }

    @Override
    public void load() {
        this.chart.load();
        this.chartLoaded = true;
    }

    public void stop() {
        this.chart.stop();
    }

    @Override
    public Object getSelectedNodesIds() {
        return this.chart.getSelectedNodesIds();
    }

    @Override
    public Object getSelectedNodesLabels() {
        return this.chart.getSelectedNodesLabels();
    }

    @Override
    public Object getSelectedNodesURLs() {
        return this.chart.getSelectedNodesURLs();
    }

    @Override
    public void resetView(boolean build) {
        this.chart.resetView(build);
    }

    public void resetView() {
        this.chart.resetView();
    }

    @Override
    public void setUserLayout(boolean flag) {
        this.chart.setUserLayout(flag);
    }

    @Override
    public void setLabels(boolean val) {
        this.chart.setLabels(val);
    }

    public boolean areLabelsShown() {
        return this.chart.areLabelsShown();
    }

    @Override
    public void setTooltipsMode(String mode) {
        this.chart.setTooltipsMode(mode);
    }

    @Override
    public void setHelpLocation(String param) {
        this.chart.setHelpLocation(param);
    }

    @Override
    public void setURLTarget(String param) {
        this.chart.setURLTarget(param);
    }

    @Override
    public void setTextColor(Object c) {
        this.chart.setTextColor(c);
    }

    @Override
    public void setSelectColor(Object col) {
        this.chart.setSelectColor(col);
    }

    @Override
    public void setBackColor(Object col) {
        this.chart.setBackColor(col);
    }

    @Override
    public void setBackImage(Object im) {
        this.chart.setBackImage(im);
    }

    @Override
    public void setImageURL(String param) {
        this.chart.setImageURL(param);
    }

    @Override
    public void setDrawImage(String param) {
        this.setDrawImage(param);
    }

    @Override
    public String getDrawImage() {
        return this.chart.getDrawImage();
    }

    @Override
    public void setImagePosition(Point loc) {
        this.chart.setImagePosition(loc);
    }

    @Override
    public void setHeight(int val) {
        this.chart.setComponentSize(this.chart.getWidth(), val);
    }

    @Override
    public void setWidth(int val) {
        this.chart.setComponentSize(val, this.chart.getHeight());
    }

    @Override
    public void setNodeColor(Object param) {
        this.chart.setNodeColor(param);
    }

    @Override
    public Color getNodeColor() {
        return this.chart.getNodeColor();
    }

    @Override
    public void setLinkColor(Object param) {
        this.chart.setLinkColor(param);
    }

    public void setLinkWidth(int width) {
        this.chart.setLinkWidth(width);
    }

    public int getLinkWidth() {
        return this.chart.getLinkWidth();
    }

    @Override
    public String getTextBorderType() {
        return this.chart.getTextBorderType();
    }

    @Override
    public String getNodeBorderType() {
        return this.chart.getNodeBorderType();
    }

    @Override
    public void setNodeBorderType(String param) {
        this.chart.setNodeBorderType(param);
    }

    @Override
    public void setTextBorderType(String param) {
        this.chart.setTextBorderType(param);
    }

    @Override
    public void setFontName(String param) {
        this.chart.setFontName(param);
    }

    @Override
    public void setFontSize(int val) {
        this.chart.setFontSize(val);
    }

    @Override
    public void setFontStyle(int val) {
        this.chart.setFontStyle(val);
    }

    @Override
    public Font getFont() {
        if (this.chart != null) {
            return this.chart.getFont();
        }
        return super.getFont();
    }

    @Override
    public void setSelectIdFunction(String param) {
        this.chart.setSelectIdFunction(param);
    }

    @Override
    public void setSelectLabelFunction(String param) {
        this.chart.setSelectLabelFunction(param);
    }

    @Override
    public void setSelectURLFunction(String param) {
        this.chart.setSelectURLFunction(param);
    }

    @Override
    public void setTooltips(boolean flag) {
        this.chart.setTooltips(flag);
    }

    @Override
    public String getNodeSeparator() {
        return this.chart.getNodeSeparator();
    }

    @Override
    public void setNodeSeparator(String param) {
        this.chart.setNodeSeparator(param);
    }

    @Override
    public void setColorMapping(boolean flag) {
        this.chart.setColorMapping(flag);
    }

    @Override
    public void setRBSizing(boolean flag) {
        this.chart.setRBSizing(flag);
    }

    @Override
    public void setDuplicateCheck(boolean flag) {
        this.model.setDuplicateCheck(flag);
    }

    @Override
    public void setAppletStub(AppletStub appletStub) {
        this.chart.setAppletStub(appletStub);
    }

    @Override
    public void setLens(boolean flag) {
        this.chart.setLens(flag);
    }

    public boolean isLensActive() {
        return this.chart.isLensActive();
    }

    @Override
    public void setFan(boolean flag) {
        this.chart.setFan(flag);
    }

    @Override
    public void setSpreadFactor(double fac) {
        this.chart.setSpreadFactor(fac);
    }

    public double getSpreadFactor() {
        return this.chart.getSpreadFactor();
    }

    @Override
    public void setCutoffFactor(double fac) {
        this.chart.setCutoffFactor(fac);
    }

    public double getCutoffFactor() {
        return this.chart.getCutoffFactor();
    }

    @Override
    public void setLensFactor(double fac) {
        this.chart.setLensFactor(fac);
    }

    public double getLensFactor() {
        return this.chart.getLensFactor();
    }

    @Override
    public void setHandleColor(Object c) {
        this.chart.setHandleColor(c);
    }

    @Override
    public void setSelected(Object id, boolean state) {
        this.chart.setSelected(id, state);
    }

    public boolean isSelected(Object id) {
        return this.chart.isSelected(id);
    }

    public void setTreeDirection(String d) {
        this.chart.setTreeDirection(d);
    }

    public String getTreeDirection() {
        return this.chart.getTreeDirection();
    }

    public void setLongestPath(int val) {
        this.chart.setLongestPath(val);
    }

    public void setTreeSpan(double val) {
        this.chart.setTreeSpan(val);
    }

    public double getTreeSpan() {
        return this.chart.getTreeSpan();
    }

    public double[] project(double x, double y, double[] out) {
        return this.chart.project(x, y, out);
    }

    public double[] project(double x, double y, double z, double[] out) {
        return this.chart.project(x, y, z, out);
    }

    public double[] unProject(double pixelX, double pixelY, double[] out) {
        return this.chart.unProject(pixelX, pixelY, out);
    }

    public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
        return this.chart.unProject(pixelX, pixelY, pixelZ, out);
    }

    public boolean isReverse(int axis) {
        return false;
    }

    public void setReverse(int axis, boolean flag) {
    }

    @Override
    public void setXMLFile(String param) {
        this.model.setXMLFile(param);
    }

    @Override
    public void setXMLData(String param) {
        this.model.setXMLData(param);
    }

    public Hashtable getTreeState() {
        VectorNodeModel nodeModel = this.model.nodes;
        Hashtable<String, NLDNode> nodeState = new Hashtable<String, NLDNode>();
        for (int i = 0; i < nodeModel.size(); ++i) {
            NLDNode node = (NLDNode)nodeModel.elementAt(i);
            nodeState.put(node.getID(), node);
        }
        return nodeState;
    }

    public void setTreeState(Hashtable nodeState, String CurrNodeid) {
        this.model.dataChanged();
        VectorNodeModel nodeModel = this.model.nodes;
        for (int i = 0; i < nodeModel.size(); ++i) {
            NLDNode newNode = (NLDNode)nodeModel.elementAt(i);
            String id = newNode.getID();
            if (!nodeState.containsKey(id) || CurrNodeid.equals(id)) continue;
            NLDNode oldNode = (NLDNode)nodeState.get(id);
            if (oldNode.isCollapsed()) {
                this.hideSubtree(id, true);
            }
            if (!oldNode.isSelected()) continue;
            this.setSelected(id, true);
        }
    }

    @Override
    public void setDataSource(DataFilterReadInterface n, DataFilterReadInterface l) {
        this.model.setDataSource(n, l);
    }

    @Override
    public boolean setDataSource(int modelType, DataFilterReadInterface source) {
        return this.model.setDataSource(modelType, source);
    }

    public boolean setDataSource(int modelType, Object source) {
        DataFilterReadInterface filter = null;
        if (source == null) {
            return false;
        }
        filter = FilterFactory.getDataSourceFilter((Object)source);
        if (filter == null) {
            return false;
        }
        return this.setDataSource(modelType, filter);
    }

    @Override
    public boolean setRole(int modelType, String variable, String role) {
        if (variable == null || role == null) {
            return false;
        }
        if (modelType == 0) {
            return this.setRole(variable, new Integer(this.model.getRoleInt(0, role)));
        }
        if (modelType == 1) {
            return this.setRole(variable, new Integer(this.model.getRoleInt(1, role)));
        }
        return false;
    }

    @Override
    public Object getDataSource(int modelType) {
        return this.model.getDataSource(modelType);
    }

    public Object getDataSource(Object id) {
        if (id == null || this.model == null) {
            return null;
        }
        if (id instanceof Number) {
            int modelType = ((Number)id).intValue();
            switch (modelType) {
                case 0: 
                case 1: {
                    return this.model.getDataSource(modelType);
                }
            }
        } else if (id instanceof String) {
            if (0 == id.toString().compareTo("Nodes")) {
                return this.model.getDataSource(0);
            }
            if (0 == id.toString().compareTo("Links")) {
                return this.model.getDataSource(1);
            }
        }
        return null;
    }

    @Override
    public Object getVariable(int modelType, String role) {
        return this.model.getVariable(modelType, role);
    }

    @Override
    public Object getRole(int modelType, String variableId) {
        return this.model.getRole(modelType, variableId);
    }

    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    @Override
    public void setModelMode(int newMode) {
        this.model.setModelMode(newMode);
    }

    @Override
    public int getModelMode() {
        return this.model.getModelMode();
    }

    @Override
    public Object getDataSource() {
        return this.model.getDataSource();
    }

    @Override
    public boolean setDataSource(Object source) {
        return this.model.setDataSource(source);
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null || id == null) {
            return false;
        }
        if (id instanceof Number) {
            int idx = ((Number)id).intValue();
            switch (idx) {
                case 0: 
                case 1: {
                    return this.model.setDataSource(idx, source);
                }
            }
        } else if ("Nodes".equalsIgnoreCase(id.toString())) {
            this.model.setDataSource(0, source);
        } else if ("Links".equalsIgnoreCase(id.toString())) {
            this.model.setDataSource(1, source);
        }
        return false;
    }

    public Object getAllVariables(Object role) {
        return this.roleManager.getAllVariables(role);
    }

    @Override
    public Object getVariable(Object role) {
        return this.model.getVariable(role);
    }

    @Override
    public Object getRole(Object variableId) {
        return this.roleManager.getRole(variableId);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        return this.roleManager.setRole(variableId, role);
    }

    public boolean addRole(Object variableId, Object role) {
        return this.setRole(variableId, role);
    }

    public boolean removeRole(Object variableId, Object role) {
        return this.roleManager.removeRole(variableId, role);
    }

    @Override
    public boolean isDiscrete(Object variableId) {
        return false;
    }

    @Override
    public boolean setDiscrete(Object variableId, boolean discrete) {
        return false;
    }

    public Object getRoleValue(Object role, int which) {
        return this.roleManager.getRoleValue(role, which);
    }

    public int getMaxAllowed(Object role) {
        if (role == null) {
            return 0;
        }
        return 1;
    }

    public Object[] getSupportedRoles(Object type, boolean discrete) {
        return this.roleManager.getSupportedRoles(type, discrete);
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public Object getSortOrder(Object role) {
        return null;
    }

    public boolean setSortOrder(Object role, Object order) {
        return false;
    }

    public Object[] getDataIds() {
        return new String[]{"Nodes", "Links"};
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        if (this.roleManager == null) {
            return null;
        }
        return this.roleManager.getSupportedSortableRoles();
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    @Override
    public Object pickID(int x, int y) {
        return this.chart.pickID(x, y);
    }

    public void printComponent() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf = job.pageDialog(job.defaultPage());
        job.setPrintable(this, pf);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip toolTip = new JToolTip();
        toolTip.setBackground(new Color(242, 242, 223));
        Color fcolor = Color.black;
        toolTip.setForeground(fcolor);
        toolTip.setBorder(new LineBorder(fcolor, 1));
        return toolTip;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        this.chart.pick(x, y);
        String toolTipText = this.chart.getTooltipText(evt);
        return toolTipText;
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.chart.setSize(width, height);
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        this.chart.setSize(d);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Rectangle bounds = this.getBounds();
        double width = pageFormat.getImageableWidth();
        double height = pageFormat.getImageableHeight();
        double s_aspect = (double)this.getBounds().width / (double)this.getBounds().height;
        double p_aspect = width / height;
        if (p_aspect <= 1.0) {
            if (s_aspect < 1.0 && s_aspect < p_aspect) {
                width = height * s_aspect;
            } else {
                height = width / s_aspect;
            }
        } else if (s_aspect > 1.0 && s_aspect > p_aspect) {
            height = width / s_aspect;
        } else {
            width = height * s_aspect;
        }
        double xratio = width / bounds.getWidth();
        double yratio = height / bounds.getHeight();
        g2.translate(0.0, 0.0);
        g2.setClip(0, 0, (int)width, (int)height);
        g2.scale(xratio, yratio);
        super.paint(graphics);
        return 0;
    }

    public int numPages(PageFormat pf) {
        return 1;
    }

    public int numPagesX(PageFormat pf) {
        return 1;
    }

    public int numPagesY(PageFormat pf) {
        return 1;
    }

    public Object[] getGraphBackground() {
        Object[] array = new Object[]{this.getBackColor()};
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setImageBackground(Image img, Object fitStyle, int x, int y, double blend) {
        TreeviewComponent treeviewComponent;
        int fit = this.imageFitStyle;
        int flags = 0;
        Image tmp = null;
        int compWidth = this.chart.getWidth();
        int compHeight = this.chart.getHeight();
        if (img == null) {
            this.backImage = null;
            this.scaledBackImage = null;
            TreeviewComponent treeviewComponent2 = this;
            synchronized (treeviewComponent2) {
                this.bufferUpdateRequired = true;
                return true;
            }
        }
        if (fitStyle != null) {
            if (fitStyle instanceof String) {
                if (((String)fitStyle).equalsIgnoreCase("Stretch") || ((String)fitStyle).equalsIgnoreCase("Stretch to fit")) {
                    fit = 0;
                } else if (((String)fitStyle).equalsIgnoreCase("Tile")) {
                    fit = 1;
                } else if (((String)fitStyle).equalsIgnoreCase("Center")) {
                    fit = 2;
                } else {
                    if (!((String)fitStyle).equalsIgnoreCase("Locate")) return false;
                    fit = 3;
                }
            } else if (fitStyle instanceof Number) {
                fit = ((Number)fitStyle).intValue();
            }
        }
        if (!Double.isNaN(blend) && !Double.isInfinite(blend)) {
            this.imageBlend = blend;
        }
        if (this.imageBlend < 0.0) {
            this.imageBlend = 0.0;
        } else if (this.imageBlend > 1.0) {
            this.imageBlend = 1.0;
        }
        switch (fit) {
            case 1: 
            case 2: 
            case 3: {
                this.backImage = img;
                this.scaledBackImage = null;
                this.imageFitStyle = fit;
                break;
            }
            case 0: {
                treeviewComponent = this;
                synchronized (treeviewComponent) {
                    this.imageFitStyle = fit;
                    this.backImage = img;
                    this.scaledBackImage = null;
                }
                tmp = img.getScaledInstance(compWidth, compHeight, 1);
                if (tmp == null || ((flags = super.checkImage(img, -1, -1, this)) & 0x20) == 0) break;
                this.scaledBackImage = tmp;
            }
        }
        this.chart.setBackImage(this.backImage);
        this.chart.setBackground(this.chart.getBackColor());
        treeviewComponent = this;
        synchronized (treeviewComponent) {
            this.bufferUpdateRequired = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setGradientBackground(Object startColor, Object endColor, Object orientation) {
        int y2;
        int y1;
        int x1;
        int x2;
        Color c2;
        Color c1;
        int orient = this.gradientOrientation;
        GradientPaint gpNew = null;
        Image img = null;
        Graphics2D g = null;
        int compWidth = this.chart.getWidth();
        int compHeight = this.chart.getHeight();
        if ((startColor == null || endColor == null) && this.gp == null) {
            return false;
        }
        if (startColor == null) {
            c1 = this.gp.getColor1();
        } else if (startColor instanceof Color) {
            c1 = (Color)startColor;
        } else {
            if (!(startColor instanceof String)) return false;
            c1 = NLD.decodeColor((String)((String)startColor));
            if (c1 == null) {
                return false;
            }
        }
        if (endColor == null) {
            c2 = this.gp.getColor2();
        } else if (endColor instanceof Color) {
            c2 = (Color)endColor;
        } else {
            if (!(endColor instanceof String)) return false;
            c2 = NLD.decodeColor((String)((String)endColor));
            if (c2 == null) {
                return false;
            }
        }
        if (orientation != null) {
            if (orientation instanceof String) {
                if (((String)orientation).equalsIgnoreCase("Left to right")) {
                    orient = 0;
                } else if (((String)orientation).equalsIgnoreCase("Right to left")) {
                    orient = 1;
                } else if (((String)orientation).equalsIgnoreCase("Top to bottom")) {
                    orient = 2;
                } else if (((String)orientation).equalsIgnoreCase("Bottom to top")) {
                    orient = 3;
                } else {
                    if (!((String)orientation).equalsIgnoreCase("Diagonal")) return false;
                    orient = 4;
                }
            } else {
                if (!(orientation instanceof Number)) return false;
                orient = ((Number)orientation).intValue();
            }
        }
        switch (orient) {
            default: {
                return false;
            }
            case 2: {
                x1 = x2 = compWidth / 2;
                y1 = 0;
                y2 = compHeight;
                break;
            }
            case 3: {
                x1 = x2 = compWidth / 2;
                y1 = compHeight;
                y2 = 0;
                break;
            }
            case 0: {
                x1 = 0;
                x2 = compWidth;
                y1 = y2 = compHeight / 2;
                break;
            }
            case 1: {
                x1 = compWidth;
                x2 = 0;
                y1 = y2 = compHeight / 2;
                break;
            }
            case 4: {
                y1 = 0;
                x1 = 0;
                x2 = compWidth;
                y2 = compHeight;
            }
        }
        gpNew = new GradientPaint(x1, y1, c1, x2, y2, c2);
        if (gpNew == null) {
            return false;
        }
        img = this.createImage();
        if (img == null) {
            return false;
        }
        g = this.getGraphics2D(img);
        if (g == null) {
            return false;
        }
        g.setPaint(gpNew);
        g.fillRect(0, 0, compWidth, compHeight);
        g.dispose();
        this.gp = gpNew;
        this.gpBackImage = img;
        Color backColor = c1;
        this.gradientOrientation = orient;
        this.chart.setBackColor(backColor);
        this.chart.setBackImage(img);
        this.chart.setBackground(backColor);
        TreeviewComponent treeviewComponent = this;
        synchronized (treeviewComponent) {
            this.bufferUpdateRequired = true;
            return true;
        }
    }

    public Color getSolidBackground() {
        if (this.gp != null) {
            return this.gp.getColor1();
        }
        return this.getBackground();
    }

    public boolean setSolidBackground(Object c) {
        Color color;
        if (c == null) {
            return false;
        }
        if (c instanceof Color) {
            color = (Color)c;
        } else if (c instanceof String) {
            color = NLD.decodeColor((String)((String)c));
            if (color == null) {
                return false;
            }
        } else {
            return false;
        }
        this.chart.setBackImage(null);
        this.backImage = null;
        this.chart.setBackColor(color);
        return true;
    }

    public void redrawGraphBackground(Component c) {
        this.repaint();
    }

    public boolean supportsImageBackground() {
        return false;
    }

    public boolean supportsGradientBackground() {
        return true;
    }

    protected String getFitStyleAsString() {
        String s = null;
        switch (this.imageFitStyle) {
            case 1: {
                s = "Tile";
                break;
            }
            case 2: {
                s = "Center";
                break;
            }
            case 3: {
                s = "Locate";
                break;
            }
            case 0: {
                s = "Stretch";
            }
        }
        return s;
    }

    protected Image createImage() {
        int compWidth = this.chart.getWidth();
        int compHeight = this.chart.getHeight();
        if (compWidth <= 0 || compHeight <= 0) {
            return null;
        }
        return this.createImage(compWidth, compHeight);
    }

    protected Graphics2D getGraphics2D(Image source) {
        Graphics g = null;
        g = source == null ? this.getGraphics() : source.getGraphics();
        if (g instanceof Graphics2D) {
            return (Graphics2D)g;
        }
        if (g != null) {
            g.dispose();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (this.parentFrame == null) {
            Container con;
            for (con = this.getParent(); con != null && !(con instanceof Frame); con = con.getParent()) {
            }
            if (con != null && con instanceof Frame) {
                this.parentFrame = (Frame)con;
            }
        }
        if (command.equals("grphOptions")) {
            if (this.graphDialog == null) {
                this.createGraphDialog();
            }
            this.showGraphOptionsDialog();
        } else if (command.equals("dataOptions")) {
            if (null == this.dataDlg) {
                this.createDataDialog();
            }
            this.ShowDataOptionsDialog();
        } else if (command.equals("toolbar")) {
            if (this.toolbar == null) {
                this.toolbar = this.createToolbar();
            }
            if (this.toolbar != null) {
                this.toolbar.setVisible(true);
            }
        } else if (command.equalsIgnoreCase("copyToClipboard")) {
            CopyToClipboard.toClipboard((JComponent)this);
        } else if (command.equalsIgnoreCase("ACTION_MODE_BRUSH")) {
            this.setActionMode(1);
        } else if (command.equalsIgnoreCase("ACTION_MODE_SELECT")) {
            this.setActionMode(6);
        } else if (command.equalsIgnoreCase("ACTION_MODE_ZOOM")) {
            this.setActionMode(3);
        } else if (command.equalsIgnoreCase("ACTION_MODE_PAN")) {
            this.setActionMode(4);
        } else if (command.equalsIgnoreCase("ACTION_MODE_RESET")) {
            this.setActionMode(5);
        } else if (command.equalsIgnoreCase("saveAsXML")) {
            SILKParser.saveAsXML((Object)this, null, (boolean)true);
        }
    }

    public void createGraphDialog() {
        this.graphDialog = new GraphPropertiesDialog(this.parentFrame, ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"TreeviewComponent.TreeviewProps.txt", (String)"Treeview Properties"));
        GraphPanel grphPanel = new GraphPanel((PropertyInterface)this, null);
        GraphPropertiesDialog gpd = (GraphPropertiesDialog)this.graphDialog;
        String title = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"TreeviewComponent.GraphDialog.Graph.txt", (String)"Graph");
        gpd.addRootNode((Object)title, (Component)grphPanel);
        BaseNodesPanel nodesPanel = new BaseNodesPanel(this, this);
        nodesPanel.refreshComponents();
        title = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"TreeviewComponent.GraphDialog.Nodes.txt", (String)"Nodes");
        gpd.addRootNode((Object)title, (Component)nodesPanel);
        BaseLinksPanel linksPanel = new BaseLinksPanel(this, this);
        linksPanel.refreshComponents();
        title = ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"TreeviewComponent.GraphDialog.Links.txt", (String)"Links");
        gpd.addRootNode((Object)title, (Component)linksPanel);
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if ((e.getModifiers() & 4) != 0) {
            this.chart.pick(e.getX(), e.getY());
            this.popup = this.getDefaultPopupMenu();
            this.chart.setPopupLabels();
            if (this.showPopup) {
                this.popup.show(e.getComponent(), x, y);
            }
        }
    }

    @Override
    public synchronized void mouseReleased(MouseEvent e) {
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
    }

    @Override
    public synchronized void mouseClicked(MouseEvent e) {
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
    }

    public void addChartMouseListener(MouseListener ml) {
        this.chart.addMouseListener(ml);
    }

    public Component createToolbar() {
        SILKToolbar toolBar = new SILKToolbar(this.parentFrame);
        toolBar.setTitle(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"TreeviewComponent.GraphToolbar.txt", (String)"Graph Toolbar"));
        toolBar.setButtonEnabled(2, false);
        toolBar.addListener((GraphInterface)this);
        return toolBar;
    }

    public boolean getUsageMode(int mode) {
        return false;
    }

    public void setUsageMode(int mode, boolean on) {
    }

    public void enablePopup(boolean flag) {
        this.showPopup = flag;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = this.getDefaultPopupMenu();
        }
        return this.popup;
    }

    public Object getLegendPosition(Object which) {
        return null;
    }

    public boolean setLegendPosition(Object which, Object positionIn) {
        return false;
    }

    public Rectangle getLegendBounds() {
        return null;
    }

    public boolean setLegendBounds(Rectangle bounds) {
        return false;
    }

    public boolean setTitle(int index, String text) {
        return false;
    }

    public boolean setTitle(int index, TextStyleInterface text) {
        return false;
    }

    public boolean setFootnote(int index, String text) {
        return false;
    }

    public boolean setFootnote(int index, TextStyleInterface text) {
        return false;
    }

    public TextStyleInterface getTitle(int index) {
        return null;
    }

    public TextStyleInterface getFootnote(int index) {
        return null;
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        DataFilterReadInterface nodeFilter = null;
        DataFilterReadInterface linkFilter = null;
        if (this.model.links != null && this.model.links instanceof DataFilterLinkModel) {
            linkFilter = ((DataFilterLinkModel)this.model.links).getFilter();
        }
        if (this.model.nodes != null && this.model.nodes instanceof DataFilterNodeModel) {
            nodeFilter = ((DataFilterNodeModel)this.model.nodes).getFilter();
        }
        if (linkFilter != null) {
            linkFilter.removeDataFilterListener((Object)this.model.links);
        }
        if (nodeFilter != null) {
            nodeFilter.removeDataFilterListener((Object)this.model.nodes);
        }
        if (linkFilter != null) {
            linkFilter.applyWhereClause(clause, clearPrevious);
        }
        if (linkFilter != null) {
            linkFilter.addDataFilterListener((Object)this.model.links);
        }
        if (nodeFilter != null) {
            nodeFilter.addDataFilterListener((Object)this.model.nodes);
        }
        if (nodeFilter == null) {
            return false;
        }
        return nodeFilter.applyWhereClause(clause, clearPrevious);
    }

    public String getWhereClause() {
        return this.getWhereClause(0);
    }

    public String getWhereClause(int modelType) {
        DataFilterReadInterface filter = null;
        if (modelType == 0 && this.model.nodes instanceof DataFilterNodeModel) {
            if (this.model.nodes != null) {
                filter = ((DataFilterNodeModel)this.model.nodes).getFilter();
            }
        } else if (modelType == 1 && this.model.links instanceof DataFilterLinkModel && this.model.links != null) {
            filter = ((DataFilterLinkModel)this.model.links).getFilter();
        }
        if (filter == null) {
            return null;
        }
        return filter.getWhereClause();
    }

    public Component getToolBar() {
        if (this.toolbar == null) {
            this.toolbar = this.createToolbar();
        }
        return this.toolbar;
    }

    public boolean setToolBar(Component d) {
        this.toolbar = d;
        if (this.toolbar != null) {
            if (this.toolbar instanceof GraphToolbarInterface) {
                ((GraphToolbarInterface)this.toolbar).addListener((GraphInterface)this);
            }
        } else if (this.actionToolbar != null && this.popup != null) {
            this.popup.remove(this.actionToolbar);
        }
        return true;
    }

    public int getActionMode() {
        if (this.chart != null) {
            return this.chart.getActionMode();
        }
        return -1;
    }

    public boolean setActionMode(int mode) {
        if (mode == 2) {
            return false;
        }
        return this.chart.setActionMode(mode);
    }

    public String getStyle() {
        return this.style.getSchemeName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setStyle(Object newStyle) {
        if (newStyle == null) {
            this.style = null;
        } else if (newStyle instanceof ColorScheme) {
            this.style = ((ColorScheme)newStyle).getStyle();
        } else if (newStyle instanceof Style) {
            this.style = (Style)newStyle;
        } else {
            if (!(newStyle instanceof String)) return false;
            StyleCollection sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48);
            if (sc.getStyle((String)newStyle) == null) return false;
            this.style = sc.getStyle((String)newStyle);
        }
        if (this.style == null) {
            return false;
        }
        this.setColors();
        return true;
    }

    public void setChartTipsOn(boolean flag) {
        this.chart.setChartTipsOn(flag);
    }

    public boolean areChartTipsOn() {
        return this.chart.areChartTipsOn();
    }

    public TipInterface getChartTip() {
        return null;
    }

    public ColorSchemeInterface getColorScheme() {
        return this.colorScheme;
    }

    public String getColorSchemeName() {
        if (this.colorScheme == null) {
            return null;
        }
        return this.colorScheme.getSchemeName();
    }

    public boolean setColorScheme(Object newScheme) {
        return this.setStyle(newScheme);
    }

    public void setColors() {
        if (this.style == null) {
            return;
        }
        Color[] linkColors = this.style.getDataLineColors();
        Color lc = this.style.getLineStyleElement("GraphDataStyleDefault").getLineColor();
        Color[] nodeColors = linkColors;
        Color nc = this.style.getDataStyleElement("GraphDataStyleDefault").getFillColor();
        this.chart.setTextColor(this.style.getTextStyleElement("LabelText").getTextColor());
        this.chart.setBackColor(this.style.getFillStyleElement("WallFill").getFillColor());
        this.chart.setSelectColor(this.style.getFillStyleElement("Selection").getFillColor());
        this.chart.setLinkErrorColor(this.style.getLineStyleElement("Missing").getLineColor());
        this.chart.setNodeErrorColor(this.style.getFillStyleElement("Missing").getFillColor());
        if (!this.isColorMappingLinks()) {
            this.chart.setLinkColor(lc, true);
        } else {
            this.chart.setLinkColor(lc);
        }
        if (!this.isColorMappingNodes()) {
            this.chart.setNodeColor(nc, true);
        } else {
            this.chart.setNodeColor(nc);
        }
        this.breakpoints[0] = new Double(0.0);
        this.breakpoints[1] = new Double(0.5);
        this.breakpoints[2] = new Double(1.0);
        this.colors[0] = nodeColors[0];
        this.colors[1] = nodeColors[1];
        this.colors[2] = nodeColors[2];
        Color[] rampStyleClr = this.style.getRampStyleElement("ThreeColorAltRamp").getColors();
        for (int i = 0; i < rampStyleClr.length; ++i) {
            this.colors[i] = rampStyleClr[i];
        }
        this.flags = 0L;
        this.clrRamp = new ColorRamp((Object)this.colors, (Object)this.breakpoints, this.flags);
        this.chart.setColorRamp(this.clrRamp);
    }

    public DataFilterReadInterface getFilter() {
        if (this.model instanceof DataFilterModel) {
            return this.getFilter(this.model.getModelMode());
        }
        return null;
    }

    public DataFilterReadInterface getFilter(Object id) {
        if (this.model instanceof DataFilterModel) {
            if ("Nodes".equals(id)) {
                return this.getFilter(0);
            }
            if ("Links".equals(id)) {
                return this.getFilter(1);
            }
            return null;
        }
        return null;
    }

    public DataFilterReadInterface getFilter(int modelType) {
        DataFilterModel modl = null;
        if (!(this.model instanceof DataFilterModel)) {
            return null;
        }
        modl = this.model;
        if (modelType == 0 && modl.nodes instanceof DataFilterNodeModel) {
            return ((DataFilterNodeModel)modl.nodes).getFilter();
        }
        if (modelType == 1 && modl.links instanceof DataFilterLinkModel) {
            return ((DataFilterLinkModel)modl.links).getFilter();
        }
        return null;
    }

    public AxisInterface getAxis(Object whichAxis) {
        return null;
    }

    public boolean setExternalAxis(Object which, AxisInterface axis) {
        return false;
    }

    public LegendInterface getLegend(Object which) {
        return null;
    }

    public void dispose() {
        this.gp = null;
        this.backImage = null;
        this.gpBackImage = null;
        this.scaledBackImage = null;
        this.chart = null;
        this.model = null;
        this.breakpoints = null;
        this.colors = null;
        this.clrRamp = null;
        this.popup = null;
        if (this.toolbar != null) {
            this.toolbar.setVisible(false);
        }
        this.toolbar = null;
        this.colorScheme = null;
        this.graphDialog = null;
        this.resourceBundle = null;
        this.properties = null;
        this.zoomCursor = null;
        this.moveOpen = null;
        SILKGlobal.unregister((PropertyInterface)this);
    }

    public Dialog getDialog(Object id, Object listener) {
        if (id instanceof String) {
            String ID = (String)id;
            if (ID.equalsIgnoreCase("Properties")) {
                if (this.graphDialog == null) {
                    this.createGraphDialog();
                }
                return this.graphDialog;
            }
            if (ID.equalsIgnoreCase("Data")) {
                if (null == this.dataDlg) {
                    this.createDataDialog();
                }
                return this.dataDlg;
            }
        }
        return null;
    }

    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        if (dialogIn == null) {
            return false;
        }
        if (id instanceof String) {
            String ID = (String)id;
            if (ID.equalsIgnoreCase("Properties")) {
                this.graphDialog = dialogIn;
                return true;
            }
            if (ID.equalsIgnoreCase("Data") && dialogIn instanceof DataOptionsDialog) {
                this.dataDlg = (DataOptionsDialog)dialogIn;
                return true;
            }
        }
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    public AnnotateInterface getAnnotate() {
        return null;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    public boolean setDataListening(boolean flag) {
        return false;
    }

    public boolean isDataListening() {
        return false;
    }

    public int getSelectionBehavior() {
        return -1;
    }

    public Object getSelectionBehaviorValue() {
        return null;
    }

    public boolean setSelectionBehavior(int behavior, Object value) {
        return false;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean setEditable(boolean editable) {
        return false;
    }

    public void addDrilldownListener(DrilldownListenerInterface dli) {
        this.chart.addDrillDownListener(dli);
    }

    public void removeDrilldownListener(DrilldownListenerInterface dli) {
        this.chart.removeDrillDownListener(dli);
    }

    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    public boolean isActionEnabled(String action) {
        return true;
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 0: 
            case 2: 
            case 9: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 800: 
            case 803: 
            case 804: 
            case 807: 
            case 812: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int id) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(new Integer(id));
    }

    public Object getPropertyValue(int id) {
        if (id < 0) {
            return null;
        }
        Object value = null;
        if (this.properties != null && (value = this.properties.get(new Integer(id))) != null) {
            return value;
        }
        return this.getActualValue(id);
    }

    public Object getActualValue(int index) {
        switch (index) {
            case 9: 
            case 10: {
                return this.getGraphBackground();
            }
            case 11: {
                return new Boolean(this.supportsGradientBackground());
            }
            case 12: {
                return new Boolean(this.supportsImageBackground());
            }
            case 21: {
                return this.chart.getBackColor();
            }
            case 0: {
                return this.colorScheme;
            }
            case 2: {
                return new Boolean(this.chart.areChartTipsOn());
            }
            case 800: {
                return this.chart.getNodeColor();
            }
            case 803: {
                return new Boolean(this.chart.areLabelsShown());
            }
            case 804: {
                this.colorMappingNodes = this.isMappingAllowed(0, "Color");
                return new Boolean(this.colorMappingNodes);
            }
            case 812: {
                this.fixColorNodes = !this.chart.isColorMappingNodes();
                return new Boolean(this.fixColorNodes);
            }
            case 807: {
                return new Boolean(this.isMappingAllowed(0, "Value"));
            }
            case 850: {
                return this.chart.getLinkColor();
            }
            case 851: {
                return null;
            }
            case 852: {
                this.colorMappingLinks = this.isMappingAllowed(1, "Color");
                return new Boolean(this.colorMappingLinks);
            }
            case 863: {
                this.fixColorLinks = !this.chart.isColorMappingLinks();
                return new Boolean(this.fixColorLinks);
            }
            case 853: {
                this.widthMappingLinks = this.isMappingAllowed(1, "Width") && this.chart.isWidthMappingLinks();
                return new Boolean(this.widthMappingLinks);
            }
            case 854: {
                return new Boolean(this.isValueMappingLinks());
            }
            case 859: {
                return new Boolean(this.isMappingAllowed(1, "Value"));
            }
            case 860: {
                return new Boolean(this.isMappingAllowed(1, "Width"));
            }
        }
        return null;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.properties == null) {
            return false;
        }
        if (id < 0) {
            return false;
        }
        if (value != null) {
            this.properties.put(new Integer(id), value);
        }
        return true;
    }

    public int getNumberPendingProperties() {
        if (this.properties == null) {
            return 0;
        }
        return this.properties.size();
    }

    public boolean applyPropertyChanges() {
        if (this.properties == null) {
            return false;
        }
        if (this.properties.isEmpty()) {
            return false;
        }
        boolean nColorSet = false;
        boolean lColorSet = false;
        Color ncolor = this.chart.getNodeColor();
        Color lcolor = this.chart.getLinkColor();
        this.colorMappingLinks = this.chart.isColorMappingLinks();
        this.colorMappingNodes = this.chart.isColorMappingNodes();
        Enumeration keys = this.properties.keys();
        Enumeration values = this.properties.elements();
        while (keys.hasMoreElements()) {
            Object value;
            Integer i = (Integer)keys.nextElement();
            int key = -1;
            if (i != null) {
                key = i;
            }
            if ((value = values.nextElement()) instanceof PropertyEvent) {
                value = ((PropertyEvent)value).value;
            }
            switch (key) {
                case 0: {
                    this.setColorScheme(value);
                    ncolor = this.chart.getNodeColor();
                    lcolor = this.chart.getLinkColor();
                    nColorSet = true;
                    lColorSet = true;
                    break;
                }
                case 2: {
                    this.chart.setChartTipsOn((Boolean)value);
                    break;
                }
                case 21: {
                    this.setSolidBackground(value);
                    break;
                }
                case 800: {
                    ncolor = (Color)value;
                    nColorSet = true;
                    break;
                }
                case 804: {
                    this.colorMappingNodes = (Boolean)value;
                    break;
                }
                case 812: {
                    this.fixColorNodes = (Boolean)value;
                    break;
                }
                case 850: {
                    lcolor = (Color)value;
                    lColorSet = true;
                    break;
                }
                case 851: {
                    this.lwidth = (Integer)value;
                    break;
                }
                case 852: {
                    this.colorMappingLinks = (Boolean)value;
                    break;
                }
                case 863: {
                    this.fixColorLinks = (Boolean)value;
                    break;
                }
                case 853: {
                    this.widthMappingLinks = (Boolean)value;
                    break;
                }
            }
        }
        if (this.colorMappingNodes) {
            if (this.fixColorNodes) {
                this.chart.setNodeColor(ncolor, true);
                this.chart.setColorMappingNodes(false);
            } else {
                this.chart.setNodeColor(ncolor);
                this.chart.setColorMappingNodes(true);
                this.chart.colormapNodes();
            }
        } else if (nColorSet) {
            this.chart.setNodeColor(ncolor, true);
            this.chart.setColorMappingNodes(false);
        }
        if (this.colorMappingLinks) {
            if (this.fixColorLinks) {
                this.chart.setLinkColor(lcolor, true);
                this.chart.setColorMappingLinks(false);
            } else {
                this.chart.setLinkColor(lcolor);
                this.chart.setColorMappingLinks(true);
                this.chart.colormapLinks();
            }
        } else if (lColorSet) {
            this.chart.setLinkColor(lcolor, true);
            this.chart.setColorMappingLinks(false);
        }
        if (this.widthMappingLinks) {
            this.chart.setLinkWidths();
            this.chart.setWidthMappingLinks(true);
        } else {
            this.chart.setLinkWidth(new Integer(this.lwidth), true);
            this.chart.setWidthMappingLinks(false);
        }
        this.chart.rebuild();
        this.chart.repaint();
        this.properties.clear();
        return true;
    }

    public boolean applyPropertyChanges(Object source) {
        return this.applyPropertyChanges();
    }

    public void cancelPropertyChanges() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    public void cancelPropertyChanges(Object source) {
        this.cancelPropertyChanges();
    }

    public int[] getPendingChanges() {
        if (this.properties == null) {
            return null;
        }
        int[] pending = new int[this.properties.size()];
        Enumeration keys = this.properties.keys();
        int cntr = 0;
        while (keys.hasMoreElements()) {
            Integer i = (Integer)keys.nextElement();
            int key = i;
            if (cntr >= pending.length) continue;
            pending[cntr++] = key;
        }
        return pending;
    }

    public int[] getPendingChanges(Object source) {
        return this.getPendingChanges();
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        return rc;
    }

    public boolean isBackBufferDrawEnabled() {
        return true;
    }

    public boolean isModelAttributeHonored(Object attribute) {
        return false;
    }

    public void setBackBufferDrawEnabled(boolean drawback) {
    }

    public boolean setHonorModelAttribute(Object attribute, boolean honorit) {
        return false;
    }

    public void addViewportListener(Object listener) {
    }

    public void removeViewportListener(Object listener) {
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.chartLoaded) {
            this.load();
        }
    }

    public void roleChanged(RoleEvent roleEvent) {
        if (null == roleEvent) {
            return;
        }
        switch (roleEvent.type) {
            case 1: 
            case 2: {
                this.handleSetRole(roleEvent);
                break;
            }
            case 3: {
                this.handleRemoveRole(roleEvent);
            }
        }
        if (this.chartLoaded) {
            this.model.dataChanged();
        }
    }

    private boolean handleRemoveRole(RoleEvent e) {
        Integer roleObj = new Integer(e.role);
        Object var = e.oldValue;
        if (null == roleObj || null == var) {
            return false;
        }
        if (this.model == null) {
            return false;
        }
        if (this.model.nodes == null || this.model.links == null) {
            return false;
        }
        if (this.model instanceof DataFilterModel) {
            boolean isRoleRemoved = this.model.removeRole(var.toString(), roleObj);
            if (roleObj instanceof Number && !((Object)roleObj).equals(RoleInterface.ROLE_LINK_VALUE)) {
                return isRoleRemoved;
            }
            return isRoleRemoved;
        }
        return false;
    }

    private boolean handleSetRole(RoleEvent e) {
        Integer roleObj = new Integer(e.role);
        Object var = this.getFirstObject(this.roleManager.getVariable((Object)roleObj));
        if (null == roleObj || null == var) {
            return false;
        }
        if (this.model == null) {
            return false;
        }
        if (this.model.nodes == null || this.model.links == null) {
            return true;
        }
        if (this.model instanceof DataFilterModel) {
            boolean isRoleSet = this.model.setRole(var.toString(), roleObj);
            if (roleObj instanceof Number) {
                if (!((Object)roleObj).equals(RoleInterface.ROLE_LINK_VALUE)) {
                    return isRoleSet;
                }
                Object value = this.getPropertyValue(861);
                boolean showThreshold = false;
                if (value != null && value instanceof Boolean) {
                    showThreshold = (Boolean)value;
                }
                if (!showThreshold) {
                    return isRoleSet;
                }
            }
            return isRoleSet;
        }
        return false;
    }

    protected Object getFirstObject(Object value) {
        if (value == null) {
            return null;
        }
        return Extract.getObject((Object)value, (int)0, (int)Extract.getSourceType((Object)value));
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent evt) {
        this.chart.itemStateChanged(evt);
    }

    public void createDataDialog() {
        if (this.dataDlg != null) {
            return;
        }
        this.dataDlg = new DataOptionsDialog((RoleInterface)this, (JComponent)this, this.parentFrame);
    }

    public void ShowDataOptionsDialog() {
        if (this.dataDlg == null) {
            return;
        }
        this.dataDlg.setVisible(true);
    }

    public void initRoleManager() {
        SILKNumber roleObj = null;
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_ID");
        this.roleManager.newRole((Object)roleObj, (Object)"Node ID", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_COLOR");
        this.roleManager.newRole((Object)roleObj, (Object)"Node Color", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_LABEL");
        this.roleManager.newRole((Object)roleObj, (Object)"Node Label", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_NODE_TIP");
        this.roleManager.newRole((Object)roleObj, (Object)"Node Tip", 1, (Object)"Nodes", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_ID");
        this.roleManager.newRole((Object)roleObj, (Object)"Link ID", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_FROM");
        this.roleManager.newRole((Object)roleObj, (Object)"Link From", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_TO");
        this.roleManager.newRole((Object)roleObj, (Object)"Link To", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_WIDTH");
        this.roleManager.newRole((Object)roleObj, (Object)"Link Width", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 1);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_COLOR");
        this.roleManager.newRole((Object)roleObj, (Object)"Link Color", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_TIP");
        this.roleManager.newRole((Object)roleObj, (Object)"Link Tip", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
        roleObj = this.roleIndex.getRoleObject("ROLE_LINK_GROUP");
        this.roleManager.newRole((Object)roleObj, (Object)"Link Group", 1, (Object)"Links", -1);
        this.roleManager.setRoleType((Object)roleObj, 0);
    }

    public void setColorMappingLinks(boolean flag) {
        this.chart.setColorMappingLinks(flag);
    }

    public boolean isColorMappingLinks() {
        return this.chart.isColorMappingLinks();
    }

    public void setColorMappingNodes(boolean flag) {
        this.chart.setColorMappingNodes(flag);
    }

    public boolean isColorMappingNodes() {
        return this.chart.isColorMappingNodes();
    }

    public boolean isWidthMappingLinks() {
        return this.chart.isWidthMappingLinks();
    }

    public void setWidthMappingLinks(boolean flag) {
        this.chart.setWidthMappingLinks(flag);
    }

    public boolean isColorMappingNodesAllowed() {
        return this.getVariable(0, "Color") != null;
    }

    public boolean isColorMappingLinksAllowed() {
        return this.getVariable(1, "Color") != null;
    }

    public boolean isValueMappingLinks() {
        Object variable = this.getVariable(1, "Value");
        return variable != null;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.toolbar != null) {
            this.toolbar.setVisible(false);
        }
    }

    public void showGraphOptionsDialog() {
        if (this.graphDialog == null) {
            return;
        }
        if (this.firstShowDialog) {
            if (this.graphDialog instanceof TabbedPropertiesDialog) {
                ((TabbedPropertiesDialog)this.graphDialog).setActiveTab(1);
            } else if (this.graphDialog instanceof GraphPropertiesDialog) {
                ((GraphPropertiesDialog)this.graphDialog).setSelectedNode((Object)ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"TreeviewComponent.GraphDialog.Nodes.txt", (String)"Nodes"));
            }
            this.firstShowDialog = false;
        }
        this.graphDialog.setVisible(true);
    }

    public Color getLinkColor() {
        return this.chart.getLinkColor();
    }

    public boolean isMappingAllowed(int modelType, String role) {
        Object variable = this.getVariable(modelType, role);
        if (variable == null) {
            if (modelType == 1 && role.equalsIgnoreCase("Width")) {
                return false;
            }
            variable = this.getVariable(modelType, "Value");
        }
        return variable != null;
    }
}

