/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.StripLabel;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.CompositeChartPrintInterface;
import com.sas.graphics.silk.interfaces.LayerInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.AbstractGridTableModel;
import com.sas.graphics.silk.util.GraphGroup;
import com.sas.graphics.silk.util.ImagePaginator;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class RegularGridComponent
extends SILKComponent
implements TableModelListener,
CompositeChartPrintInterface,
PropertyInterface,
Pageable,
Printable {
    private static final long serialVersionUID = 909201626823252040L;
    private static final int NEW_MODEL = Integer.MIN_VALUE;
    private TableModel model = null;
    private JScrollPane scroll = null;
    private TrellisPlot grid = null;
    private TrellisLayout layout = null;
    private Border lineBorder = null;
    private Border selectedBorder = null;
    private Dimension cellSize = null;
    private GraphGroup graphGroup = null;
    private int printMode;
    private BufferedImage bufImage = null;
    private ImagePaginator imagePaginator = null;
    private ResourceBundle rb = null;
    private JDialog graphDialog = null;
    protected Vector[][] cellHeaders = null;
    private float cellHeaderFontSize = 0.0f;
    private boolean callGC = false;
    private LinkedHashMap pendingProperties = null;
    private boolean disposeCharts = false;
    private static int[] supportedPrintModes = new int[]{3, 2, 1};

    public RegularGridComponent() {
        this(1, 1);
    }

    public RegularGridComponent(int rows, int columns) {
        SILKGlobal.register((PropertyInterface)this);
        this.pendingProperties = new LinkedHashMap();
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
        this.printMode = 1;
        this.compWidth = 0;
        this.compHeight = 0;
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        Style style = (Style)SILKGlobal.getInstance().getPropertyValue(29);
        Color selectionColor = style.getDataStyleElement("Selection").getLineColor();
        Color backColor = style.getFillStyleElement("Backfill").getFillColor();
        this.lineBorder = new LineBorder(backColor.darker(), 1);
        this.selectedBorder = new LineBorder(selectionColor, 3);
        this.setLayout(null);
        this.createTrellis();
        this.setCellSize(200, 200);
        this.scroll = new JScrollPane((Component)this.grid);
        this.add(this.scroll);
        this.setModel(new GridTableModel(rows, columns));
    }

    public void removeNotify() {
        this.disableLayout();
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        if (this.scroll != null) {
            this.scroll.setBounds(this.graphLayout.getChartArea());
        }
        if (this.grid != null) {
            this.grid.enableLayout();
        }
    }

    protected void paintComponent(Graphics g) {
        if (g instanceof Graphics2D) {
            this.background.drawBackground((Graphics2D)g);
        }
        this.graphLayout.draw(g);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.callGC) {
            System.gc();
            this.callGC = false;
        }
    }

    private void createTrellis() {
        this.layout = new TrellisLayout();
        this.layout.setGridHGap(3);
        this.layout.setGridVGap(3);
        this.grid = new TrellisPlot();
        this.grid.setLayout((LayoutManager)this.layout);
    }

    private void disposeTrellis() {
        if (this.grid != null) {
            this.grid.removeAll();
        }
        this.grid = null;
        this.layout = null;
    }

    public void dispose() {
        SILKGlobal.unregister((PropertyInterface)this);
        if (this.model != null) {
            this.model.removeTableModelListener(this);
        }
        if (this.disposeCharts && this.model != null) {
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                for (int j = 0; j < this.model.getRowCount(); ++j) {
                    Object obj = this.model.getValueAt(j, i);
                    if (!(obj instanceof BaseComponentInterface)) continue;
                    ((BaseComponentInterface)obj).dispose();
                }
            }
        }
        this.model = null;
        if (this.pendingProperties != null) {
            this.pendingProperties.clear();
        }
        this.pendingProperties = null;
        this.disposeTrellis();
    }

    private void clearTrellis() {
        if (this.grid != null) {
            for (int i = this.layout.getGridRows() - 1; i > 0; --i) {
                this.grid.removeRowHeader(i);
                this.grid.removeRow(i);
            }
            for (int j = this.layout.getGridColumns() - 1; j > 0; --j) {
                this.grid.removeColumnHeader(j);
                this.grid.removeColumn(j);
            }
            this.grid.removeRowHeader(0);
            this.grid.removeColumnHeader(0);
            this.grid.removeCellItem(0, 0);
            int numCellHeaders = this.layout.getCell(0, 0).getNumHeaders();
            for (int i = 0; i < numCellHeaders; ++i) {
                this.grid.removeCellHeader(0, 0, i);
            }
        }
    }

    public boolean setStyle(Object o) {
        super.setStyle(o);
        if (this.style == null) {
            return false;
        }
        if (this.grid != null) {
            this.grid.setBackground(this.style.getFillStyleElement("Backfill").getFillColor());
        }
        return true;
    }

    public boolean setModel(TableModel m) {
        if (m != null && m != this.model) {
            if (this.model != null) {
                this.model.removeTableModelListener(this);
            }
            this.model = m;
            this.model.addTableModelListener(this);
            this.updateGrid(Integer.MIN_VALUE);
            return true;
        }
        return false;
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setColumnWeights(double[] colWeights) {
        this.layout.setColumnWeights(colWeights);
    }

    public void setRowWeights(double[] rowWeights) {
        this.layout.setRowWeights(rowWeights);
    }

    public boolean addCellHeader(int row, int column, String text) {
        if (text == null) {
            return false;
        }
        if (this.cellHeaders != null && row < this.model.getRowCount() && column < this.model.getColumnCount()) {
            StripLabel jc;
            if (this.cellHeaders[row][column] == null) {
                this.cellHeaders[row][column] = new Vector();
            }
            this.cellHeaders[row][column].addElement(text);
            int k = this.cellHeaders[row][column].size() - 1;
            Object ch = this.cellHeaders[row][column].elementAt(k);
            if (ch != null && (jc = this.createCellHeaderLabel(ch)) != null) {
                this.grid.addCellHeader(row, column, k, (JComponent)jc);
            }
            return true;
        }
        return false;
    }

    public Vector getCellHeaders(int r, int c) {
        if (this.cellHeaders == null || r >= this.cellHeaders.length || c >= this.cellHeaders[r].length) {
            return null;
        }
        return this.cellHeaders[r][c];
    }

    public boolean removeCellHeader(int row, int column, int headerIndex) {
        if (this.cellHeaders != null && row < this.model.getRowCount() && column < this.model.getColumnCount() && this.cellHeaders[row][column] != null && headerIndex < this.cellHeaders[row][column].size()) {
            this.cellHeaders[row][column].removeElementAt(headerIndex);
            return true;
        }
        return false;
    }

    private void disposeGraphGroup() {
        if (this.graphGroup != null) {
            this.graphGroup.dispose();
            this.graphGroup = null;
        }
    }

    private void createGraphGroup() {
        if (this.graphGroup == null) {
            this.graphGroup = new GraphGroup();
        }
    }

    private void updateGrid(int type) {
        switch (type) {
            case -2147483648: 
            case -1: 
            case 0: 
            case 1: {
                this.rebuildGrid();
                this.setStyle(this.style);
                this.repaint();
            }
        }
    }

    private void rebuildGrid() {
        if (this.model != null) {
            Object o;
            int i;
            this.disposeGraphGroup();
            this.createGraphGroup();
            this.cellHeaders = new Vector[this.model.getRowCount()][this.model.getColumnCount()];
            this.disableLayout();
            this.clearTrellis();
            for (i = 0; i < this.model.getRowCount() - 1; ++i) {
                this.grid.addRow();
            }
            for (int j = 0; j < this.model.getColumnCount() - 1; ++j) {
                this.grid.addColumn();
            }
            this.setGridSize();
            for (i = 0; i < this.model.getRowCount(); ++i) {
                for (int j = 0; j < this.model.getColumnCount(); ++j) {
                    JComponent jc;
                    TipInterface tip;
                    o = this.model.getValueAt(i, j);
                    Component c = null;
                    c = o instanceof Component ? (Component)o : new JLabel();
                    c.addMouseMotionListener((MouseMotionListener)((Object)this));
                    if (c instanceof ComponentInterface && (tip = ((ComponentInterface)c).getChartTip()) != null) {
                        tip.setEnabled(false);
                    }
                    if (c instanceof JComponent && (jc = (JComponent)c).getBorder() == null) {
                        jc.setBorder(this.lineBorder);
                    }
                    this.graphGroup.addChart((Object)c);
                    this.grid.addCellItem(i, j, c);
                    if (this.cellHeaders == null || i >= this.cellHeaders.length || j >= this.cellHeaders[i].length || this.cellHeaders[i][j] == null) continue;
                    for (int k = 0; k < this.cellHeaders[i][j].size(); ++k) {
                        StripLabel jc2;
                        Object ch = this.cellHeaders[i][j].elementAt(k);
                        if (ch == null || (jc2 = this.createCellHeaderLabel(ch)) == null) continue;
                        this.grid.addCellHeader(i, j, k, (JComponent)jc2);
                    }
                }
            }
            if (this.model instanceof AbstractGridTableModel) {
                int i2;
                AbstractGridTableModel gridModel = (AbstractGridTableModel)this.model;
                for (i2 = 0; i2 < gridModel.getRowCount(); ++i2) {
                    o = gridModel.getRowHeader(i2);
                    if (!(o instanceof Component)) continue;
                    this.grid.addRowHeader(i2, (Component)o);
                }
                for (i2 = 0; i2 < gridModel.getColumnCount(); ++i2) {
                    o = gridModel.getColumnHeader(i2);
                    if (!(o instanceof Component)) continue;
                    this.grid.addColumnHeader(i2, (Component)o);
                }
            }
            this.enableLayout();
            this.callGC = true;
        }
    }

    protected StripLabel createCellHeaderLabel(Object o) {
        if (o == null) {
            return null;
        }
        StripLabel label = new StripLabel(o.toString());
        label.setBorder(this.lineBorder);
        label.setHorizontalAlignment(0);
        if (this.cellHeaderFontSize != 0.0f) {
            label.setFont(label.getFont().deriveFont(this.cellHeaderFontSize));
        }
        return label;
    }

    protected void computeStripLabelFontSize() {
        int rowCount;
        float font_size = 0.0f;
        if (this.model != null && (rowCount = this.model.getRowCount()) != 0) {
            int height = Math.max(this.getPreferredSize().height, this.compHeight);
            int rowHeight = height / rowCount;
            double cellHeight = rowHeight - 50;
            font_size = (float)(cellHeight * 0.021 * 1.38889);
            if (font_size < 9.0f) {
                font_size = 9.0f;
            } else if (font_size > 16.0f) {
                font_size = 16.0f;
            }
        }
        this.cellHeaderFontSize = font_size;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateGrid(e.getType());
    }

    protected void doResize(int compWidthIn, int compHeightIn) {
        if (compWidthIn == this.compWidth && compHeightIn == this.compHeight) {
            return;
        }
        super.doResize(compWidthIn, compHeightIn);
        this.computeStripLabelFontSize();
        if (this.scroll != null) {
            this.scroll.setBounds(this.graphLayout.getChartArea());
        }
    }

    public void setCellSize(int width, int height) {
        if (width > 0 && height > 0) {
            this.cellSize = new Dimension(width, height);
        }
        this.setGridSize();
    }

    public Dimension getCellSize() {
        return new Dimension(this.cellSize);
    }

    private void setGridSize() {
        if (this.model != null) {
            int gridWidth = this.cellSize.width * this.model.getColumnCount();
            int gridHeight = this.cellSize.height * this.model.getRowCount();
            this.grid.setSize(gridWidth, gridHeight);
            this.grid.setPreferredSize(new Dimension(gridWidth, gridHeight));
        }
    }

    public int[] getGridLocationForComponent(Component c) {
        if (c == null) {
            return null;
        }
        int[] cellLoc = new int[]{-1, -1};
        block0: for (int i = 0; i < this.model.getRowCount(); ++i) {
            for (int j = 0; j < this.model.getColumnCount(); ++j) {
                if (c != this.grid.getCellItem(i, j)) continue;
                cellLoc[0] = i;
                cellLoc[1] = j;
                continue block0;
            }
        }
        return cellLoc;
    }

    public int[] getGridLocationFromScreenLocation(int x, int y) {
        Rectangle r;
        if (x < 0 || x >= this.compWidth || y < 0 || y >= this.compHeight) {
            return null;
        }
        int[] cellLoc = new int[]{-1, -1};
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            r = this.grid.getCellItem(i, 0).getBounds();
            if (y < r.y || y > r.y + r.height) continue;
            cellLoc[0] = i;
            break;
        }
        for (int j = 0; j < this.model.getColumnCount(); ++j) {
            r = this.grid.getCellItem(0, j).getBounds();
            if (x < r.x || x > r.x + r.width) continue;
            cellLoc[1] = j;
            break;
        }
        return cellLoc;
    }

    public Component getComponentAtScreenLocation(int x, int y) {
        int[] loc = this.getGridLocationFromScreenLocation(x, y);
        if (loc == null) {
            return null;
        }
        if (this.model == null) {
            return null;
        }
        Object o = this.model.getValueAt(loc[0], loc[1]);
        if (o instanceof Component) {
            return (Component)o;
        }
        return null;
    }

    public void setDialogVisible(String id, boolean visible) {
        if ("Properties".equalsIgnoreCase(id)) {
            if (this.graphDialog == null) {
                this.graphDialog = this.getGraphDialog();
            }
            this.graphDialog.setVisible(visible);
        }
    }

    private JDialog getGraphDialog() {
        PropertyMulticaster pm = this.graphGroup.getMulticaster();
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        Frame parentFrame = parent instanceof Frame ? (Frame)parent : null;
        TabbedPropertiesDialog graphDlg = new TabbedPropertiesDialog(parentFrame, (Component)((Object)this), ResourceLoader.getResourceString((Object)this.rb, (String)"RegularGridComponent.Properties.txt", (String)"Graph Properties"));
        graphDlg.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"RegularGrid.Graph.txt", (String)"Graph"), (TabPanelInterface)new GraphPanel((PropertyInterface)pm, (PropertyInterface)pm));
        return graphDlg;
    }

    public void setSelected(Collection c, boolean selected) {
        if (c != null) {
            Iterator it = c.iterator();
            if (it == null) {
                return;
            }
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof JComponent)) continue;
                JComponent jc = (JComponent)o;
                if (selected) {
                    jc.setBorder(this.selectedBorder);
                    continue;
                }
                jc.setBorder(this.lineBorder);
            }
        }
    }

    private boolean verifyIndices(int r, int c) {
        if (this.model == null) {
            return false;
        }
        if (r < 0 || r >= this.model.getRowCount()) {
            return false;
        }
        return c >= 0 && c < this.model.getColumnCount();
    }

    public void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
        if (listener != null && this.model != null && this.grid != null) {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                for (int j = 0; j < this.model.getColumnCount(); ++j) {
                    Component c = this.grid.getCellItem(i, j);
                    c.addMouseListener(listener);
                }
            }
        }
    }

    public void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        if (l != null) {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                for (int j = 0; j < this.model.getColumnCount(); ++j) {
                    Component c = this.grid.getCellItem(i, j);
                    c.removeMouseListener(l);
                }
            }
        }
    }

    @Override
    public int getNumberOfPages() {
        PageFormat pageFormat = this.getPageFormat(0);
        switch (this.printMode) {
            case 1: {
                this.createPrintObjects(pageFormat);
                return this.imagePaginator.getNumberOfPages();
            }
            case 2: {
                return this.model.getRowCount() * this.model.getColumnCount();
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return (PageFormat)SILKGlobal.getInstance().getPropertyValue(57);
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    private void createPrintObjects(PageFormat pageFormat) {
        if (this.bufImage == null) {
            Dimension gridPrefSize = this.grid.getPreferredSize();
            this.bufImage = new BufferedImage(gridPrefSize.width, gridPrefSize.height, 1);
            this.grid.paint(this.bufImage.getGraphics());
        }
        if (this.imagePaginator == null) {
            this.imagePaginator = new ImagePaginator(this.bufImage);
            if (!this.imagePaginator.isSplit()) {
                this.imagePaginator.splitViewToPages(pageFormat);
            }
        }
    }

    private void disposePrintObjects() {
        this.bufImage = null;
        if (this.imagePaginator != null) {
            this.imagePaginator.disposeImages();
        }
        this.imagePaginator = null;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        switch (this.printMode) {
            case 1: {
                this.createPrintObjects(pageFormat);
                Image img = this.imagePaginator.getImage(pageIndex);
                if (pageIndex == this.imagePaginator.getNumberOfPages() - 1) {
                    this.disposePrintObjects();
                }
                if (img != null) {
                    int x = (int)((pageFormat.getWidth() - pageFormat.getImageableWidth()) / 2.0);
                    int y = (int)((pageFormat.getHeight() - pageFormat.getImageableHeight()) / 2.0);
                    graphics.drawImage(img, x, y, (ImageObserver)((Object)this));
                    return 0;
                }
                return 1;
            }
            case 2: {
                if (this.model == null) {
                    return 1;
                }
                int numCharts = this.model.getRowCount() * this.model.getColumnCount();
                if (pageIndex == numCharts - 1) {
                    this.disposePrintObjects();
                }
                if (pageIndex < numCharts) {
                    int r = pageIndex / this.model.getColumnCount();
                    int c = pageIndex % this.model.getColumnCount();
                    Graphics2D g2 = (Graphics2D)graphics;
                    g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                    Dimension d = this.grid.getCellItem(0, 0).getSize();
                    double scaleX = pageFormat.getImageableWidth() / (double)d.width;
                    double scaleY = pageFormat.getImageableHeight() / (double)d.height;
                    double scale = Math.min(scaleX, scaleY);
                    AffineTransform defaultXfm = g2.getTransform();
                    AffineTransform xfm = new AffineTransform(defaultXfm);
                    xfm.scale(scale, scale);
                    g2.setTransform(xfm);
                    BufferedImage buffImg = new BufferedImage(this.cellSize.width, this.cellSize.height, 1);
                    this.initBuffer(buffImg, this.cellSize.width, d.height, this.getBackground());
                    Graphics2D g3 = (Graphics2D)buffImg.getGraphics();
                    this.grid.getCellItem(r, c).paint(g3);
                    g2.drawImage(buffImg, 0, 0, this.getBackground(), (ImageObserver)((Object)this));
                    return 0;
                }
                return 1;
            }
            case 3: {
                if (pageIndex == 0) {
                    this.disposePrintObjects();
                    Graphics2D g2 = (Graphics2D)graphics;
                    Dimension d = this.grid.getPreferredSize();
                    double scaleX = pageFormat.getImageableWidth() / (double)d.width;
                    double scaleY = pageFormat.getImageableHeight() / (double)d.height;
                    double scale = Math.min(scaleX, scaleY);
                    double w = scale * (double)d.width;
                    double ht = scale * (double)d.height;
                    int xTrans = (int)Math.max((pageFormat.getImageableWidth() - w) / 2.0, 0.0);
                    int yTrans = (int)Math.max((pageFormat.getImageableHeight() - ht) / 2.0, 0.0);
                    g2.translate(pageFormat.getImageableX() + (double)xTrans, pageFormat.getImageableY() + (double)yTrans);
                    AffineTransform defaultXfm = g2.getTransform();
                    AffineTransform xfm = new AffineTransform(defaultXfm);
                    xfm.scale(scale, scale);
                    g2.setTransform(xfm);
                    this.grid.paint((Graphics)g2);
                    return 0;
                }
                return 1;
            }
        }
        return 1;
    }

    private void initBuffer(BufferedImage buffImg, int w, int ht, Color clr) {
        int clrVal = clr.getRGB();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < ht; ++j) {
                buffImg.setRGB(i, j, clrVal);
            }
        }
    }

    public int getPrintMode() {
        return this.printMode;
    }

    public boolean setPrintMode(int printMode) {
        switch (printMode) {
            case 1: 
            case 2: 
            case 3: {
                this.printMode = printMode;
                return true;
            }
        }
        return false;
    }

    public int[] getSupportedPrintModes() {
        return supportedPrintModes;
    }

    public void disableLayout() {
        if (this.grid != null) {
            this.grid.disableLayout();
        }
    }

    public void enableLayout() {
        if (this.grid != null) {
            this.grid.enableLayout();
        }
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.pendingProperties != null) {
            Set keys = this.pendingProperties.keySet();
            if (keys != null && keys.size() > 0) {
                Iterator i = keys.iterator();
                while (i != null && i.hasNext()) {
                    Object key = i.next();
                    Object val = this.pendingProperties.get(key);
                    if (val instanceof PropertyEvent) {
                        val = ((PropertyEvent)val).value;
                    }
                    if (!(key instanceof Number)) continue;
                    switch (((Number)key).intValue()) {
                        case 0: {
                            this.setColorScheme(val);
                            break;
                        }
                        case 19401: {
                            if (!(val instanceof Boolean)) break;
                            this.disposeCharts = (Boolean)val;
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        if (this.pendingProperties != null) {
            this.pendingProperties.clear();
        }
    }

    public int getNumberPendingProperties() {
        if (this.pendingProperties != null) {
            return this.pendingProperties.size();
        }
        return 0;
    }

    public int[] getPendingChanges() {
        return null;
    }

    public int[] getPendingChanges(Object source) {
        return null;
    }

    public Object getPropertyValue(int id) {
        Integer ID = new Integer(id);
        switch (id) {
            case 0: {
                if (this.pendingProperties != null && this.pendingProperties.containsKey(ID)) {
                    return this.pendingProperties.get(new Integer(id));
                }
                return this.style;
            }
        }
        return null;
    }

    public boolean hasUserSetValue(int id) {
        return false;
    }

    public boolean isPropertyPending(int id) {
        if (this.pendingProperties != null) {
            return this.pendingProperties.containsKey(new Integer(id));
        }
        return false;
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 0: 
            case 19401: {
                return true;
            }
        }
        return false;
    }

    public boolean setPropertyValue(int id, Object value) {
        switch (id) {
            case 0: 
            case 19401: {
                if (this.pendingProperties == null) break;
                this.pendingProperties.put(new Integer(id), value);
                return true;
            }
        }
        return false;
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    public String getToolTipText(MouseEvent me) {
        if (this.mouseEventSource != this && this.mouseEventSource instanceof LayerInterface) {
            if (this.mouseEventSource instanceof BaseComponentInterface && !((BaseComponentInterface)this.mouseEventSource).areChartTipsOn()) {
                return null;
            }
            if (this.mouseEventSource instanceof Component) {
                this.tipLocation = new Point(this.scroll.getX() + ((Component)this.mouseEventSource).getX() + me.getX(), this.scroll.getY() + ((Component)this.mouseEventSource).getY() + me.getY());
            }
            return ((LayerInterface)this.mouseEventSource).getTipText(me.getX(), me.getY());
        }
        return null;
    }

    public Object getDataSource(Object id) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            for (int j = 0; j < this.model.getColumnCount(); ++j) {
                SourceInterface si;
                Object o = this.model.getValueAt(i, j);
                if (!(o instanceof SourceInterface) || (si = (SourceInterface)o).getDataSource(id) == null) continue;
                return si.getDataSource(id);
            }
        }
        return null;
    }

    public Object[] getDataIds() {
        Vector<Object> dataIds = new Vector<Object>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            for (int j = 0; j < this.model.getColumnCount(); ++j) {
                Object[] ids;
                Object o = this.model.getValueAt(i, j);
                if (!(o instanceof SourceInterface) || (ids = ((SourceInterface)o).getDataIds()) == null) continue;
                for (int k = 0; k < ids.length; ++k) {
                    if (dataIds.contains(ids[k])) continue;
                    dataIds.addElement(ids[k]);
                }
            }
        }
        return dataIds.toArray();
    }

    public Object[] getAssignedVariables() {
        if (this.model != null) {
            Vector<Object> vars = new Vector<Object>();
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                for (int j = 0; j < this.model.getColumnCount(); ++j) {
                    Object comp = this.model.getValueAt(i, j);
                    Object[] cVars = this.getAssignedVariables(comp);
                    if (cVars == null) continue;
                    for (int k = 0; k < cVars.length; ++k) {
                        if (vars.contains(cVars[k])) continue;
                        vars.add(cVars[k]);
                    }
                }
            }
            if (vars.size() > 0) {
                return vars.toArray();
            }
        }
        return null;
    }

    private Object[] getAssignedVariables(Object component) {
        RoleInterface ri;
        Object[] supportedRoles;
        if (component instanceof RoleInterface && (supportedRoles = (ri = (RoleInterface)component).getSupportedRoles(null, true)) != null) {
            Vector vars = new Vector();
            for (int i = 0; i < supportedRoles.length; ++i) {
                Object allVars = ri.getAllVariables(supportedRoles[i]);
                if (allVars == null) continue;
                Enumeration e = Extract.elements((Object)allVars);
                while (e.hasMoreElements()) {
                    Object var = e.nextElement();
                    if (vars.contains(var)) continue;
                    vars.add(var);
                }
            }
            if (vars.size() > 0) {
                return vars.toArray();
            }
        }
        return null;
    }

    public class GridTableModel
    extends AbstractGridTableModel {
        private static final long serialVersionUID = -8766624197807608010L;
        private Vector tableListeners = null;
        private int rows = 0;
        private int columns = 0;
        private Object[][] values = null;
        private Component[] rowHeaders = null;
        private Component[] columnHeaders = null;

        GridTableModel() {
            this(1, 1);
        }

        GridTableModel(int r, int c) {
            if (r <= 0) {
                r = 1;
            }
            if (c <= 0) {
                c = 1;
            }
            this.rows = r;
            this.columns = c;
            this.values = new Object[this.rows][this.columns];
            this.rowHeaders = new Component[this.rows];
            this.columnHeaders = new Component[this.columns];
            this.tableListeners = new Vector();
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            if (l != null && !this.tableListeners.contains(l)) {
                this.tableListeners.add(l);
            }
        }

        public Class getColumnClass(int columnIndex) {
            return JComponent.class;
        }

        @Override
        public int getColumnCount() {
            return this.columns;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return null;
        }

        @Override
        public int getRowCount() {
            return this.rows;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (RegularGridComponent.this.verifyIndices(rowIndex, columnIndex)) {
                return this.values[rowIndex][columnIndex];
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return RegularGridComponent.this.verifyIndices(rowIndex, columnIndex);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            if (l != null) {
                this.tableListeners.remove(l);
            }
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (RegularGridComponent.this.verifyIndices(rowIndex, columnIndex)) {
                this.values[rowIndex][columnIndex] = aValue;
                this.fireTableModelChanged(0, rowIndex, columnIndex);
            }
        }

        private void fireTableModelChanged(int type, int r, int c) {
            if (this.tableListeners.size() > 0) {
                TableModelEvent evt = new TableModelEvent(RegularGridComponent.this.model, r, r, c, type);
                for (int i = 0; i < this.tableListeners.size(); ++i) {
                    ((TableModelListener)this.tableListeners.elementAt(i)).tableChanged(evt);
                }
            }
        }

        @Override
        public Component getRowHeader(int rowIndex) {
            if (RegularGridComponent.this.verifyIndices(rowIndex, 0)) {
                return this.rowHeaders[rowIndex];
            }
            return null;
        }

        @Override
        public Component getColumnHeader(int columnIndex) {
            if (RegularGridComponent.this.verifyIndices(0, columnIndex)) {
                return this.columnHeaders[columnIndex];
            }
            return null;
        }

        public boolean setRowHeader(int row, Component header) {
            if (RegularGridComponent.this.verifyIndices(row, 0) && header != null) {
                this.rowHeaders[row] = header;
                this.fireTableModelChanged(0, row, 0);
                return true;
            }
            return false;
        }

        public boolean setColumnHeader(int column, Component header) {
            if (RegularGridComponent.this.verifyIndices(0, column) && header != null) {
                this.columnHeaders[column] = header;
                this.fireTableModelChanged(0, 0, column);
                return true;
            }
            return false;
        }
    }
}

