/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.orgchart.OrgViewer;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.Footnote;
import com.sas.graphics.silk.util.LegendBuilder;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.Print;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.Title;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.nld.NLDScrollPane;
import com.sas.graphics.util.nld.NLDScrollPaneInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class OrgChartComponent
extends SILKComponent
implements ActionListener {
    private static final long serialVersionUID = -4648245411872305687L;
    private NLDScrollPane nldScrollPane = null;
    private OrgViewer org = null;
    private LegendBuilder legendBuilder = null;
    private boolean drawBackground = true;
    protected Color backgroundColor = null;
    protected Color wallColor = null;
    private boolean backgroundColorSet = false;
    private boolean wallColorSet = false;
    private int printMode = 1;
    private static int[] supportedPrintModes = new int[]{1};
    private int numPages = 1;
    private int widthPages = 1;
    private int heightPages = 1;
    private Dimension prefSize = new Dimension(0, 0);
    private int printTitleHeight = 0;
    private int printFootnoteHeight = 0;

    public OrgChartComponent() {
        this.roles.removeRoleListener((RoleListenerInterface)this);
        this.org = new OrgViewer();
        this.roles = this.org.getRoleManager();
        this.roles.addRoleListener((RoleListenerInterface)this);
        this.setLayout(null);
        this.nldScrollPane = new NLDScrollPane((NLDScrollPaneInterface)this.org);
        this.nldScrollPane.setNegativeYScrolling(false);
        this.add((Component)this.nldScrollPane);
        if (this.org.getMoveOpenCursor() == null) {
            this.org.setMoveOpenCursor(this.getCustomCursor(6, 2, "icons/MoveOpen.gif"));
        }
        if (this.org.getMoveClosedCursor() == null) {
            this.org.setMoveClosedCursor(this.getCustomCursor(6, 2, "icons/MoveClosed.gif"));
        }
        if (this.org.getZoomCursor() == null) {
            this.org.setZoomCursor(this.getCustomCursor(6, 2, "icons/Zoom.gif"));
        }
        this.setStyle(SILKGlobal.getInstance().getPropertyValue(29));
        this.registerAsListenerToPopup();
        this.legendBuilder = new LegendBuilder();
        this.legendBuilder.addChart((PropertyInterface)this.org);
    }

    protected void registerAsListenerToPopup() {
        if (this.org == null) {
            return;
        }
        JPopupMenu popup = this.org.getPopupMenu();
        if (popup == null) {
            return;
        }
        JMenuItem jmi = MenuUtilities.getMenuItem((JPopupMenu)popup, (String)"COPY");
        if (jmi != null) {
            jmi.addActionListener(this);
        }
        if ((jmi = MenuUtilities.getMenuItem((JPopupMenu)popup, (String)"PRINT")) != null) {
            jmi.addActionListener(this);
        }
        if ((jmi = MenuUtilities.getMenuItem((JPopupMenu)popup, (String)"DEBUG__SAVE_AS_XML")) != null) {
            jmi.addActionListener(this);
        }
    }

    public void paintComponent(Graphics g) {
        Color c = this.drawBackground ? this.backgroundColor : this.wallColor;
        g.setColor(c);
        g.fillRect(0, 0, this.compWidth, this.compHeight);
        super.paintComponent(g);
        this.graphLayout.draw(g);
    }

    public void addNotify() {
        super.addNotify();
        this.nldScrollPane.setBounds(this.graphLayout.getChartArea());
    }

    protected void doResize(int compWidthIn, int compHeightIn) {
        super.doResize(compWidthIn, compHeightIn);
        this.nldScrollPane.setBounds(this.graphLayout.getChartArea());
    }

    public boolean setStyle(Object o) {
        boolean rc = super.setStyle(o);
        if (this.org != null) {
            rc |= this.org.setStyle(o);
        }
        this.backgroundColor = this.style.getFillStyleElement("Backfill").getFillColor();
        this.wallColor = this.style.getFillStyleElement("WallFill").getFillColor();
        if (this.org != null) {
            this.org.setBackground(this.wallColor);
        }
        this.buildLegend();
        return rc;
    }

    public void addDrilldownListener(DrilldownListenerInterface dli) {
        if (this.org != null) {
            this.org.addDrillDownListener(dli);
        }
    }

    public void removeDrilldownListener(DrilldownListenerInterface dli) {
        if (this.org != null) {
            this.org.removeDrillDownListener(dli);
        }
    }

    public void mousePressed(MouseEvent me) {
        super.mousePressed(me);
        if (this.nldScrollPane != null && this.org != null) {
            int mods = me.getModifiers();
            this.org.mousePressed(me.getX() - this.nldScrollPane.getBounds().x, me.getY() - this.nldScrollPane.getBounds().y, me.isPopupTrigger(), me.getClickCount(), mods);
        }
    }

    public void mouseReleased(MouseEvent me) {
        super.mouseReleased(me);
        if (this.nldScrollPane != null && this.org != null) {
            int mods = me.getModifiers();
            this.org.mouseReleased(me.getX() - this.nldScrollPane.getBounds().x, me.getY() - this.nldScrollPane.getBounds().y, me.isPopupTrigger(), me.getClickCount(), mods);
        }
    }

    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        if (this.nldScrollPane != null && this.org != null) {
            int mods = e.getModifiers();
            this.org.mouseDragged(e.getX() - this.nldScrollPane.getBounds().x, e.getY() - this.nldScrollPane.getBounds().y, mods);
        }
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        if (this.nldScrollPane != null && this.org != null) {
            int mods = e.getModifiers();
            this.org.mouseMoved(e.getX() - this.nldScrollPane.getBounds().x, e.getY() - this.nldScrollPane.getBounds().y, mods);
        }
    }

    public String getTipText(int screenX, int screenY) {
        String tip;
        if (this.nldScrollPane != null && this.org != null && (tip = this.org.getTipText(screenX - this.nldScrollPane.getBounds().x, screenY - this.nldScrollPane.getBounds().y)) != null) {
            return tip;
        }
        return super.getTipText(screenX, screenY);
    }

    public Object[] getDataIds() {
        if (this.org != null) {
            return this.org.getDataIds();
        }
        return null;
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        if (this.org != null) {
            return this.org.getDataSource(id);
        }
        return null;
    }

    public boolean setDataSource(Object source, Object id) {
        super.setDataSource(source, id);
        if (this.org != null) {
            return this.org.setDataSource(source, id);
        }
        return false;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public boolean addRole(Object variableId, Object role) {
        if (this.org != null) {
            return this.org.addRole(variableId, role);
        }
        return false;
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public Object getAllVariables(Object role) {
        if (this.org != null) {
            return this.org.getAllVariables(role);
        }
        return null;
    }

    public Object getLimit(Object role) {
        if (this.org != null) {
            return this.org.getLimit(role);
        }
        return null;
    }

    public int getMaxAllowed(Object role) {
        if (this.org != null) {
            return this.org.getMaxAllowed(role);
        }
        return 0;
    }

    public Object getRole(Object variableId) {
        if (this.org != null) {
            return this.org.getRole(variableId);
        }
        return null;
    }

    public Object getRoleValue(Object role, int which) {
        return null;
    }

    public Object getSortOrder(Object role) {
        if (this.org != null) {
            return this.org.getSortOrder(role);
        }
        return null;
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        if (this.org != null) {
            return this.org.getSupportedRoles(id, discrete);
        }
        return null;
    }

    public Object[][] getSupportedSortableRoles() {
        if (this.org != null) {
            return this.org.getSupportedSortableRoles();
        }
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        if (this.org != null) {
            return this.org.getSupportedSortDirections(role);
        }
        return null;
    }

    public Object getVariable(Object role) {
        if (this.org != null) {
            return this.org.getVariable(role);
        }
        return null;
    }

    public boolean isDiscrete(Object role) {
        if (this.org != null) {
            return this.org.isDiscrete(role);
        }
        return false;
    }

    public boolean removeRole(Object variableId, Object role) {
        if (this.org != null) {
            return this.org.removeRole(variableId, role);
        }
        return false;
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public boolean requiresMultipleRoleAssignments() {
        if (this.org != null) {
            return this.org.requiresMultipleRoleAssignments();
        }
        return false;
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.org != null) {
            return this.org.setDiscrete(role, discrete);
        }
        return false;
    }

    public boolean setLimit(Object role, Object value) {
        if (this.org != null) {
            return this.org.setLimit(role, value);
        }
        return false;
    }

    public boolean setRole(Object variableId, Object role) {
        if (this.org != null) {
            return this.org.setRole(variableId, role);
        }
        return false;
    }

    public boolean setSortOrder(Object role, Object order) {
        if (this.org != null) {
            return this.org.setSortOrder(role, order);
        }
        return false;
    }

    public boolean supportsMultipleAssignments(Object role) {
        if (this.org != null) {
            return this.org.supportsMultipleAssignments(role);
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equalsIgnoreCase("COPY")) {
            CopyToClipboard.toClipboard((JComponent)((Object)this));
        } else if (command.equalsIgnoreCase("PRINT")) {
            Print.print((Object)this);
        } else if (command.equalsIgnoreCase("DEBUG__SAVE_AS_XML")) {
            SILKParser.saveAsXML((Object)this, null, (boolean)true);
        }
    }

    private int computeNumberOfPages(PageFormat pageFmt) {
        Footnote footnote;
        PageFormat pageFormat = pageFmt;
        int ptw = 0;
        int pfw = 0;
        Title titles = this.graphLayout.getTitle();
        if (titles != null) {
            titles.setComponentBounds(0, 0, this.prefSize.width - 2 * this.silkDefaults.componentXMargin, this.prefSize.height - 2 * this.silkDefaults.componentYMargin);
            Rectangle titleBounds = titles.getBounds();
            this.printTitleHeight = (int)titleBounds.getHeight();
            ptw = (int)titleBounds.getWidth();
            titles.setComponentBounds(0, 0, this.compWidth, this.compHeight);
        }
        if ((footnote = this.graphLayout.getFootnote()) != null) {
            footnote.setComponentBounds(0, 0, this.prefSize.width - 2 * this.silkDefaults.componentXMargin, this.prefSize.height - 2 * this.silkDefaults.componentYMargin);
            this.printFootnoteHeight = (int)footnote.getBounds().getHeight();
            pfw = (int)footnote.getBounds().getWidth();
            footnote.setComponentBounds(0, 0, this.compWidth, this.compHeight);
        }
        int prefWidth = this.prefSize.width = Math.max(this.org.getPreferredWidth(), Math.max(ptw, pfw));
        int prefHeight = this.prefSize.height = this.org.getPreferredHeight() + this.printTitleHeight + this.printFootnoteHeight;
        if (this.org.getTreeLayout() == 4 || this.org.getTreeLayout() == 5) {
            prefWidth = this.prefSize.width = (int)pageFormat.getImageableWidth();
        }
        int printPageWrap = 0;
        if ((double)prefWidth > pageFormat.getImageableWidth()) {
            printPageWrap |= 1;
        }
        if ((double)prefHeight > pageFormat.getImageableHeight()) {
            printPageWrap |= 2;
        }
        this.numPages = 1;
        this.heightPages = 1;
        this.widthPages = 1;
        switch (printPageWrap) {
            default: {
                this.numPages = 1;
                break;
            }
            case 1: {
                this.numPages = this.widthPages = (int)Math.ceil((double)prefWidth / pageFormat.getImageableWidth());
                break;
            }
            case 2: {
                this.numPages = this.heightPages = (int)Math.ceil((double)prefHeight / pageFormat.getImageableHeight());
                break;
            }
            case 3: {
                this.widthPages = (int)Math.ceil((double)prefWidth / pageFormat.getImageableWidth());
                this.heightPages = (int)Math.ceil((double)prefHeight / pageFormat.getImageableHeight());
                this.numPages = this.widthPages * this.heightPages;
            }
        }
        return this.numPages;
    }

    public int getNumberOfPages() {
        PageFormat pageFormat = this.getPageFormat(0);
        switch (this.printMode) {
            default: 
        }
        this.computeNumberOfPages(pageFormat);
        return this.numPages;
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return (PageFormat)SILKGlobal.getInstance().getPropertyValue(57);
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public int getPrintMode() {
        return this.printMode;
    }

    public boolean setPrintMode(int printMode) {
        switch (printMode) {
            case 1: {
                this.printMode = printMode;
                return true;
            }
        }
        return false;
    }

    public int[] getSupportedPrintModes() {
        return supportedPrintModes;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        switch (this.printMode) {
            default: 
        }
        this.computeNumberOfPages(pageFormat);
        if (pageIndex < this.numPages) {
            int oldCompWidth = this.compWidth;
            int oldCompHeight = this.compHeight;
            double pageWidth = pageFormat.getImageableWidth();
            double pageHeight = pageFormat.getImageableHeight();
            int widthPageIndex = pageIndex % this.widthPages;
            int heightPageIndex = pageIndex / this.widthPages % this.heightPages;
            Title titles = null;
            if (heightPageIndex == 0 && (titles = this.graphLayout.getTitle()) != null) {
                titles.setComponentBounds(0, 0, this.prefSize.width - 2 * this.silkDefaults.componentXMargin, this.prefSize.height - 2 * this.silkDefaults.componentYMargin);
                Rectangle titleBounds = titles.getBounds();
                this.printTitleHeight = (int)titleBounds.getHeight();
            }
            Footnote footnote = null;
            if (heightPageIndex == this.heightPages - 1 && (footnote = this.graphLayout.getFootnote()) != null) {
                footnote.setComponentBounds(0, 0, this.prefSize.width - 2 * this.silkDefaults.componentXMargin, this.prefSize.height - 2 * this.silkDefaults.componentYMargin);
                this.printFootnoteHeight = (int)footnote.getBounds().getHeight();
            }
            int pth = heightPageIndex == 0 ? this.printTitleHeight : 0;
            int pfh = heightPageIndex == this.heightPages - 1 ? this.printFootnoteHeight : 0;
            int x = (int)((pageFormat.getWidth() - pageFormat.getImageableWidth()) / 2.0);
            int y = (int)((pageFormat.getHeight() - pageFormat.getImageableHeight()) / 2.0);
            int pageOriginX = (int)((double)widthPageIndex * pageWidth);
            int pageOriginY = (int)((double)heightPageIndex * pageHeight) - pth;
            int chartWidth = this.widthPages > 1 ? (int)(widthPageIndex == this.widthPages - 1 ? (double)(this.prefSize.width - pageOriginX) : pageWidth) : this.prefSize.width;
            int chartHeight = this.heightPages > 1 ? (int)(heightPageIndex == this.heightPages - 1 ? (double)(this.prefSize.height - pageOriginY) : pageHeight - (double)pth) : this.prefSize.height;
            Graphics2D g2 = (Graphics2D)graphics;
            g2.translate(x, y);
            g2.setColor(this.getSolidBackground());
            g2.fillRect(0, 0, chartWidth, chartHeight + pth + pfh);
            if (titles != null) {
                int xpos = (int)((double)widthPageIndex * pageWidth);
                g2.translate(-xpos, 0);
                titles.draw((Object)g2, false);
                g2.translate(xpos, 0);
            }
            if (heightPageIndex == 0) {
                g2.translate(0, this.printTitleHeight);
            }
            Point prevOrigin = new Point(this.org.getOrigin());
            this.nldScrollPane.removeViewer((NLDScrollPaneInterface)this.org);
            this.remove((Component)this.nldScrollPane);
            this.org.setBounds(0, 0, chartWidth, chartHeight);
            this.org.setOrigin(new Point(pageOriginX, pageOriginY), true, true);
            Shape s = g2.getClip();
            g2.setClip(0, 0, this.org.getWidth(), this.org.getHeight());
            this.org.paint(g2);
            g2.setClip(s);
            if (footnote != null) {
                int footnotePositionAdjustment = this.printFootnoteHeight - (this.prefSize.height - 2 * this.silkDefaults.componentXMargin);
                int xpos = (int)((double)widthPageIndex * pageWidth);
                g2.translate(-xpos, chartHeight + footnotePositionAdjustment);
                footnote.draw((Object)g2, false);
                g2.translate(xpos, -(chartHeight + footnotePositionAdjustment));
            }
            this.org.setOrigin(prevOrigin.x, prevOrigin.y, true);
            this.compWidth = oldCompWidth;
            this.compHeight = oldCompHeight;
            this.nldScrollPane.initViewer((NLDScrollPaneInterface)this.org);
            this.add((Component)this.nldScrollPane);
            this.graphLayout.doLayout(new Rectangle(this.getBounds().x, this.getBounds().y, this.compWidth, this.compHeight));
            this.nldScrollPane.setBounds(this.graphLayout.getChartArea());
            this.nldScrollPane.doLayout();
            this.org.setOrigin(prevOrigin, false, false);
            this.nldScrollPane.manageViewport();
            if (pageIndex == this.numPages - 1) {
                this.printTitleHeight = 0;
                this.printFootnoteHeight = 0;
            }
            return 0;
        }
        return 1;
    }

    public Object getChartObject(Object id) {
        return this.org;
    }

    public boolean isBackgroundDrawn() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public String getToolTipText(MouseEvent me) {
        return null;
    }

    public boolean setSolidBackground(Object c) {
        Color color = null;
        if (c instanceof Color) {
            color = (Color)c;
        } else if (c != null) {
            color = ColorParse.getColorFromString((String)c.toString());
        } else {
            return false;
        }
        if (color != null) {
            super.setSolidBackground((Object)color);
            this.backgroundColor = color;
            this.backgroundColorSet = true;
        }
        return true;
    }

    public Color getSolidBackground() {
        return this.backgroundColor;
    }

    public boolean wasBackgroundSet() {
        return this.backgroundColorSet;
    }

    public void setWallColor(Object color) {
        Color c;
        if (color instanceof Color) {
            this.wallColor = (Color)color;
            if (this.org != null) {
                this.org.setBackground(this.wallColor);
            }
            this.wallColorSet = true;
        } else if (color != null && (c = ColorParse.getColorFromString((String)color.toString())) != null) {
            this.wallColor = c;
            if (this.org != null) {
                this.org.setBackground(this.wallColor);
            }
            this.wallColorSet = true;
        }
    }

    public Color getWallColor() {
        return this.wallColor;
    }

    public boolean wasWallColorSet() {
        return this.wallColorSet;
    }

    public void buildLegend() {
        if (this.org == null || this.legendBuilder == null || this.graphLayout == null) {
            return;
        }
        LegendInterface[] legs = this.graphLayout.getLegends();
        if (legs != null) {
            for (int i = 0; i < legs.length; ++i) {
                if (legs[i] instanceof LegendObjectJ2D) {
                    this.removeMouseListener((MouseListener)((LegendObjectJ2D)legs[i]));
                    this.removeMouseMotionListener((MouseMotionListener)((LegendObjectJ2D)legs[i]));
                }
                this.graphLayout.removeLegend(legs[i]);
            }
        }
        this.legendBuilder.updateLegends();
        SILKNumber[] legNames = this.legendBuilder.getLegendNames();
        if (legNames != null && legNames.length > 0) {
            this.graphLayout.addLegend((LegendInterface)this.legendBuilder.getLegend(legNames[0]));
        }
    }

    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.role) {
            case 6: {
                this.buildLegend();
                break;
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.removeAll();
        if (this.legendBuilder != null) {
            this.legendBuilder.removeAllCharts();
        }
        this.legendBuilder = null;
        if (this.nldScrollPane != null) {
            this.nldScrollPane.removeAll();
        }
        this.nldScrollPane = null;
        if (this.org != null) {
            this.org.dispose();
        }
        this.org = null;
    }

    public JPopupMenu getPopupMenu() {
        if (this.org != null) {
            return this.org.getPopupMenu();
        }
        return null;
    }

    public boolean setActionMode(int mode) {
        boolean rc = super.setActionMode(mode);
        if (this.org != null) {
            rc |= this.org.setActionMode(mode);
        }
        return rc;
    }

    public int getActionMode() {
        if (this.org != null) {
            return this.org.getActionMode();
        }
        return super.getActionMode();
    }
}

