/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.silk.LineComponent;
import com.sas.graphics.silk.ScatterComponent;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.ElementParserInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.GraphToolbarInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.ui.AxisPanel;
import com.sas.graphics.silk.ui.DataOptionsDialog;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.AxisComponent;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.MatrixDefaults;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.StringCompare;
import com.sas.graphics.xml.GraphParserFactory;
import com.sas.text.SASFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.w3c.dom.Element;

public class MatrixComponent
extends JComponent
implements ActionListener,
ItemListener,
MouseListener,
Printable,
PropertyInterface,
RoleInterface,
GraphInterface {
    private static final long serialVersionUID = 1026324593728492739L;
    public static final int NONE = 0;
    public static final int LINE = 1;
    public static final int SCATTER = 2;
    private int componentType = 0;
    private static int FULL_MATRIX_THRESHOLD = 8;
    private static int MAX_NUM_MATRIX_VARS = 12;
    protected JComponent[] components = null;
    protected Object dataSource;
    protected DataFilterReadInterface filter = null;
    protected TrellisPlot matrix = null;
    protected TrellisLayout layout = null;
    protected int hGap = 0;
    protected int vGap = 0;
    protected final int BORDER_WIDTH = 1;
    protected Color borderColor = null;
    protected JPopupMenu popup = null;
    protected TabbedPropertiesDialog graphDialog = null;
    protected Dialog dataDialog = null;
    protected Component toolbar = null;
    protected int actionMode = 1;
    protected Style style = null;
    protected Color labelColor = null;
    protected Color backgroundColor = null;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
    protected Frame parentFrame = null;
    protected ArrayList matrixVars = null;
    private boolean externalAxes = true;
    private boolean showExternalAxes = false;
    protected Roles roles = null;
    protected String matrixVar = null;
    protected String engMatrixVar = "MatrixVar";
    private ArrayList externalXAxes = null;
    private ArrayList externalYAxes = null;
    private int currentAxis = 0;
    private boolean alternateAxes = true;
    protected Hashtable properties = null;
    protected Border border = null;
    private boolean showFullMatrix = true;
    private boolean showOnlyLowerTriangle = false;
    private JCheckBoxMenuItem showLowerTriangleMI = null;
    protected MatrixDefaults matrixDefaults = new MatrixDefaults();
    private boolean popupEnabled = true;
    private JMenuItem toolbarMI = null;
    protected Object id = null;
    private boolean showDescription = true;
    private boolean toolbarSet = false;

    public MatrixComponent() {
        if (this.matrixDefaults.fullMatrixThreshold < FULL_MATRIX_THRESHOLD) {
            FULL_MATRIX_THRESHOLD = this.matrixDefaults.fullMatrixThreshold;
        }
        this.matrixVars = new ArrayList();
        this.components = new JComponent[1];
        this.componentType = 1;
        this.vGap = 4;
        this.hGap = 4;
        this.createTrellis();
        JLabel label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.Error.EmptyPlotMatrix.txt", (String)"Empty Plot Matrix"), 0);
        label.addMouseListener(this);
        this.matrix.addCellItem(0, 0, (Component)label);
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        this.border = new LineBorder(this.borderColor, 1);
        this.externalAxes = true;
        this.showExternalAxes = false;
        this.roles = Roles.getInstance(null);
        this.matrixVar = this.roles.getRoleNLSName("ROLE_MATRIX_VAR");
        this.externalXAxes = new ArrayList();
        this.externalYAxes = new ArrayList();
        this.properties = new Hashtable();
        SILKGlobal.register((PropertyInterface)this);
    }

    public MatrixComponent(Object source, int compType, String[] variables) {
        this();
        this.matrix.removeCellItem(0, 0);
        this.setDataSource(source);
        this.componentType = compType;
        if (this.externalAxes) {
            this.showExternalAxes = true;
        }
        for (int i = 0; i < variables.length; ++i) {
            this.matrixVars.add(variables[i]);
            if (this.filter.isNumericVariable((Object)variables[i])) continue;
            this.showExternalAxes = false;
        }
        this.components = new JComponent[this.matrixVars.size() * this.matrixVars.size()];
        this.createMatrix();
    }

    public void createTrellis() {
        this.matrix = new TrellisPlot();
        this.layout = new TrellisLayout();
        this.layout.setGridHGap(this.hGap);
        this.layout.setGridVGap(this.vGap);
        this.matrix.setLayout((LayoutManager)this.layout);
        this.setLayout(new BorderLayout());
        this.add((Component)this.matrix);
    }

    public void createMatrix() {
        int i;
        int i2;
        int numVars = this.matrixVars.size();
        this.matrix.disableLayout();
        for (i2 = 0; i2 < numVars - 1; ++i2) {
            this.matrix.addColumn();
        }
        for (i2 = 0; i2 < numVars - 1; ++i2) {
            this.matrix.addRow();
        }
        this.showFullMatrix = numVars <= FULL_MATRIX_THRESHOLD && !this.showOnlyLowerTriangle;
        int index = 0;
        for (i = 0; i < numVars; ++i) {
            for (int j = 0; j < numVars; ++j) {
                String yVariable = this.matrixVars.get(i).toString();
                String xVariable = this.matrixVars.get(j).toString();
                index = i * numVars + j;
                if (i == j) {
                    String text = this.showDescription ? this.filter.getVariableDescription((Object)xVariable).toString() : xVariable;
                    this.components[index] = new JLabel(text, 0);
                } else if (i < j && !this.showFullMatrix) {
                    this.components[i * numVars + j] = new JLabel();
                } else {
                    this.components[index] = this.createComponent(this.componentType, xVariable, yVariable);
                    ((GraphInterface)this.components[index]).enablePopup(false);
                    this.components[index].addMouseListener(this);
                    if (this.toolbar != null && this.toolbar.isVisible()) {
                        ((GraphInterface)this.components[index]).setActionMode(this.getActionMode());
                    }
                    PropertyInterface p = null;
                    if (this.components[index] instanceof GraphInterface && this.components[index] instanceof PropertyInterface) {
                        p = (PropertyInterface)this.components[index];
                    }
                    if (p != null) {
                        if (this.showExternalAxes) {
                            p.setPropertyValue(238, (Object)new Integer(0));
                            p.setPropertyValue(203, (Object)new Boolean(false));
                            p.setPropertyValue(213, (Object)new Boolean(false));
                            p.setPropertyValue(223, (Object)new Boolean(false));
                            p.setPropertyValue(200, (Object)new Boolean(false));
                            p.setPropertyValue(238, (Object)new Integer(1));
                            p.setPropertyValue(203, (Object)new Boolean(false));
                            p.setPropertyValue(213, (Object)new Boolean(false));
                            p.setPropertyValue(223, (Object)new Boolean(false));
                            p.setPropertyValue(200, (Object)new Boolean(false));
                            p.setPropertyValue(32, (Object)new Integer(0));
                            p.setPropertyValue(33, (Object)new Integer(0));
                        }
                        if (!this.showFullMatrix) {
                            p.setPropertyValue(2015, (Object)new Integer(0));
                        }
                        p.setPropertyValue(2, (Object)new Boolean(false));
                        p.applyPropertyChanges();
                    }
                }
                this.components[index].setBorder(this.border);
                this.matrix.addCellItem(i, j, (Component)this.components[index]);
            }
        }
        if (this.showExternalAxes && this.showFullMatrix) {
            this.layout.setExternalAxesAlignment(1);
            for (i = 0; i < numVars; ++i) {
                boolean primary = true;
                if (this.alternateAxes) {
                    primary = i % 2 == 0;
                }
                Object axisDesc = this.filter.getVariableDescription((Object)this.matrixVars.get(i).toString());
                String axisLabel = null;
                if (axisDesc != null) {
                    axisLabel = axisDesc.toString();
                }
                Object varFormat = this.filter.getFormat(this.matrixVars.get(i), SASFormat.class);
                AxisComponent axis = new AxisComponent(2, axisLabel);
                axis.setPrimary(primary);
                axis.setPropertyValue(200, (Object)new Boolean(false));
                axis.setPropertyValue(231, (Object)new Boolean(false));
                axis.applyPropertyChanges();
                this.matrix.addRowAxis(i, (Component)axis, primary);
                axis.setLabel((Object)new Boolean(false));
                axis.addMouseListener((MouseListener)this);
                axis.setValuesFormat(varFormat);
                this.externalYAxes.add(axis);
                axis = new AxisComponent(1, axisLabel);
                axis.setPrimary(primary);
                this.matrix.addColumnAxis(i, (Component)axis, primary);
                axis.setLabel((Object)new Boolean(false));
                axis.setPropertyValue(200, (Object)new Boolean(false));
                axis.setPropertyValue(231, (Object)new Boolean(false));
                axis.applyPropertyChanges();
                axis.addMouseListener((MouseListener)this);
                axis.setValuesFormat(varFormat);
                this.externalXAxes.add(axis);
            }
            this.matrix.installRowRangeListeners();
            this.matrix.installColumnRangeListeners();
            this.matrix.installMarginListeners();
        }
        this.setPropertyValue(34, new Boolean(false));
        this.applyPropertyChanges();
        this.applyColorScheme();
        this.matrix.enableLayout();
        Rectangle r = this.getBounds();
        if (r.width > 0 && r.height > 0) {
            this.setAxesFontHeights(r);
        }
        this.matrix.addMouseListener((MouseListener)this);
    }

    public JComponent createComponent(int compType, String xVariable, String yVariable) {
        switch (compType) {
            case 1: {
                return this.createLineComponent(xVariable, yVariable);
            }
            case 2: {
                return this.createScatterComponent(xVariable, yVariable);
            }
        }
        return new JLabel();
    }

    private LineComponent createLineComponent(String xVariable, String yVariable) {
        LineComponent line = new LineComponent();
        line.setDataSource(this.dataSource);
        line.setRole((Object)xVariable, (Object)RoleInterface.ROLE_CATEGORY);
        line.setRole((Object)yVariable, (Object)RoleInterface.ROLE_RESPONSE);
        return line;
    }

    private ScatterComponent createScatterComponent(String xVariable, String yVariable) {
        ScatterComponent scatter = new ScatterComponent();
        scatter.setDataSource(this.dataSource);
        scatter.setRole((Object)xVariable, (Object)RoleInterface.ROLE_CATEGORY);
        scatter.setRole((Object)yVariable, (Object)RoleInterface.ROLE_RESPONSE);
        return scatter;
    }

    @Override
    public void addNotify() {
        Container c;
        super.addNotify();
        for (c = this.getParent(); c != null && !(c instanceof Frame); c = c.getParent()) {
        }
        if (c != null && c instanceof Frame) {
            this.parentFrame = (Frame)c;
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.toolbar != null) {
            this.toolbar.setVisible(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            if (this.popup == null) {
                this.popup = this.createPopupMenu();
            }
            this.showLowerTriangleMI.setEnabled(this.matrixVars.size() <= FULL_MATRIX_THRESHOLD);
            if (this.popupEnabled) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem graphOptions = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.Popup.GraphProperties.txt", (String)"Graph Properties..."));
        graphOptions.setActionCommand("graph");
        graphOptions.addActionListener(this);
        popup.add(graphOptions);
        JMenu actionMenu = MenuUtilities.getMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/MatrixComponentActionMenu.xml"), (ActionListener)this);
        popup.add(actionMenu);
        popup.addSeparator();
        JMenuItem dataOptions = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.Popup.DataOptions.txt", (String)"Data Options..."));
        dataOptions.setActionCommand("data");
        dataOptions.addActionListener(this);
        popup.add(dataOptions);
        popup.addSeparator();
        JMenuItem copyToClipboard = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.Popup.Copy.txt", (String)"Copy"));
        copyToClipboard.setActionCommand("copyToClipboard");
        copyToClipboard.addActionListener(this);
        popup.add(copyToClipboard);
        popup.addSeparator();
        this.showLowerTriangleMI = new JCheckBoxMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.Popup.LowerTriangle.txt", (String)"Only Lower Triangular"));
        this.showLowerTriangleMI.setActionCommand("showLowerTriangle");
        this.showLowerTriangleMI.setSelected(this.showOnlyLowerTriangle);
        this.showLowerTriangleMI.addItemListener(this);
        popup.add(this.showLowerTriangleMI);
        return popup;
    }

    public void setAxisPanelStatus() {
        if (this.graphDialog != null) {
            JTabbedPane tabPanel;
            TabPanelInterface tbi = this.graphDialog.getActivePanel();
            AxisPanel ap = null;
            if (tbi instanceof AxisPanel) {
                ap = (AxisPanel)tbi;
            }
            if ((tabPanel = this.graphDialog.getTabbedPane()) != null) {
                for (int j = 0; j < tabPanel.getTabCount(); ++j) {
                    Component c = tabPanel.getComponentAt(j);
                    if (!(c instanceof AxisPanel)) continue;
                    tabPanel.setEnabledAt(j, this.showFullMatrix);
                    if (ap == null || this.showFullMatrix) continue;
                    this.graphDialog.setActiveTab(1);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JMenuItem) {
            String command = ((JMenuItem)source).getActionCommand();
            if (command.equalsIgnoreCase("graph")) {
                if (this.graphDialog == null) {
                    this.graphDialog = this.createGraphDialog();
                }
                if (this.graphDialog != null && this.matrixVars.size() > 1) {
                    this.setAxisPanelStatus();
                    this.graphDialog.setVisible(true);
                } else {
                    System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.Error.NoGraphDialog.txt", (String)"No graph dialog to show!"));
                }
            } else if (command.equalsIgnoreCase("data")) {
                if (this.dataDialog == null) {
                    this.dataDialog = new DataOptionsDialog((RoleInterface)this, (JComponent)this, this.parentFrame);
                }
                if (this.dataDialog != null) {
                    this.dataDialog.setVisible(true);
                } else {
                    System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.Error.NoDataDialog.txt", (String)"No data dialog to show!"));
                }
            } else if (command.equalsIgnoreCase("toolbar")) {
                if (this.toolbar == null) {
                    this.toolbar = this.createToolbar();
                }
                if (this.toolbar != null) {
                    this.toolbar.setVisible(true);
                }
            } else if (command.equalsIgnoreCase("resetView")) {
                this.resetView();
            } else if (command.equalsIgnoreCase("copyToClipboard")) {
                CopyToClipboard.toClipboard((JComponent)this);
            } else if (command.equalsIgnoreCase("ACTION_MODE_BRUSH")) {
                this.setActionMode(1);
            } else if (command.equalsIgnoreCase("ACTION_MODE_SELECT")) {
                this.setActionMode(6);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JCheckBoxMenuItem && ((JCheckBoxMenuItem)source).getActionCommand().equalsIgnoreCase(this.showLowerTriangleMI.getActionCommand())) {
            boolean b = this.showOnlyLowerTriangle;
            this.showLowerTriangleMI.setSelected(((JCheckBoxMenuItem)source).isSelected());
            this.showOnlyLowerTriangle = this.showLowerTriangleMI.isSelected();
            if (b != this.showOnlyLowerTriangle) {
                this.rebuildMatrix();
            }
        }
    }

    private SILKToolbar createToolbar() {
        SILKToolbar toolBar = new SILKToolbar(this.parentFrame);
        toolBar.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.GraphToolbar.txt", (String)"Graph Toolbar"));
        toolBar.setButtonEnabled(3, false);
        toolBar.setButtonEnabled(4, false);
        toolBar.setButtonEnabled(2, false);
        toolBar.setButtonEnabled(5, false);
        toolBar.addListener((GraphInterface)this);
        return toolBar;
    }

    private void resetView() {
        for (int i = 0; i < this.components.length; ++i) {
            if (!(this.components[i] instanceof GraphInterface)) continue;
            ((GraphInterface)this.components[i]).setActionMode(5);
        }
    }

    private TabbedPropertiesDialog createGraphDialog() {
        switch (this.componentType) {
            case 1: 
            case 2: {
                return this.getGraphDialog();
            }
        }
        return null;
    }

    private TabbedPropertiesDialog getGraphDialog() {
        TabbedPropertiesDialog graphDlg = null;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                Dialog d;
                if (!(this.components[i] instanceof ComponentInterface) || !((d = ((ComponentInterface)this.components[i]).getDialog((Object)"Properties", (Object)this)) instanceof TabbedPropertiesDialog)) continue;
                graphDlg = (TabbedPropertiesDialog)d;
                JTabbedPane tabPanel = graphDlg.getTabbedPane();
                if (tabPanel == null) break;
                for (int j = 0; j < tabPanel.getTabCount(); ++j) {
                    Component c = tabPanel.getComponentAt(j);
                    if (!(c instanceof TitlePanel)) continue;
                    tabPanel.remove(c);
                }
                break;
            }
        }
        if (graphDlg != null) {
            graphDlg.setActiveTab(1);
        }
        return graphDlg;
    }

    public boolean setComponentType(int compType) {
        switch (compType) {
            case 1: 
            case 2: {
                this.componentType = compType;
                return true;
            }
        }
        return false;
    }

    public int getComponentType() {
        return this.componentType;
    }

    public void addDrilldownListener(DrilldownListenerInterface dli) {
    }

    public void removeDrilldownListener(DrilldownListenerInterface dli) {
    }

    public AxisInterface getAxis(Object which) {
        return null;
    }

    public boolean setExternalAxis(Object which, AxisInterface axis) {
        return false;
    }

    public LegendInterface getLegend(Object which) {
        return null;
    }

    public Component getToolBar() {
        if (!this.toolbarSet && this.toolbar == null) {
            this.toolbar = this.createToolbar();
        }
        return this.toolbar;
    }

    public boolean setToolBar(Component toolBarIn) {
        this.toolbarSet = true;
        this.toolbar = toolBarIn;
        if (toolBarIn != null && this.toolbar instanceof GraphToolbarInterface) {
            ((GraphToolbarInterface)this.toolbar).addListener((GraphInterface)this);
        }
        if (this.toolbar == null && this.popup != null) {
            this.popup.remove(this.toolbarMI);
        }
        return true;
    }

    public int getActionMode() {
        return this.actionMode;
    }

    public boolean setActionMode(int mode) {
        switch (mode) {
            case 1: 
            case 6: {
                this.actionMode = mode;
                if (this.components == null) {
                    return true;
                }
                for (int i = 0; i < this.components.length; ++i) {
                    if (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) continue;
                    ((GraphInterface)this.components[i]).setActionMode(this.actionMode);
                }
                return true;
            }
        }
        return false;
    }

    public boolean areChartTipsOn() {
        return false;
    }

    public void setChartTipsOn(boolean on) {
    }

    public TipInterface getChartTip() {
        return null;
    }

    public String getStyle() {
        return null;
    }

    public ColorSchemeInterface getColorScheme() {
        return new ColorScheme(this.style);
    }

    public String getColorSchemeName() {
        return this.style.getSchemeName();
    }

    public boolean setColorScheme(Object newScheme) {
        return this.setStyle(newScheme);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setStyle(Object newStyle) {
        if (newStyle == null) {
            return false;
        }
        if (newStyle instanceof Style) {
            this.style = (Style)newStyle;
        }
        if (newStyle instanceof ColorScheme) {
            this.style = ((ColorScheme)newStyle).getStyle();
            return this.applyColorScheme();
        } else {
            if (!(newStyle instanceof String)) return false;
            StyleCollection sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48);
            if (sc.getStyle((String)newStyle) == null) return false;
            this.style = sc.getStyle((String)newStyle);
        }
        return this.applyColorScheme();
    }

    public boolean applyColorScheme() {
        this.backgroundColor = this.style.getFillStyleElement("Backfill").getFillColor();
        this.borderColor = this.backgroundColor.darker();
        this.labelColor = this.style.getTextStyleElement("ValueText").getTextColor();
        this.matrix.setBackground(this.backgroundColor);
        this.border = new LineBorder(this.borderColor, 1);
        if (this.components == null) {
            return true;
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null) continue;
            if (this.components[i] instanceof GraphInterface) {
                ((GraphInterface)this.components[i]).setStyle((Object)this.style);
            } else if (this.components[i] instanceof JLabel) {
                JLabel label = (JLabel)this.components[i];
                label.setForeground(this.labelColor);
            }
            this.components[i].setBorder(this.border);
        }
        if (this.showExternalAxes) {
            Object o;
            int size;
            if (this.externalXAxes != null && this.externalXAxes.size() > 0) {
                size = this.externalXAxes.size();
                for (int i = 0; i < size; ++i) {
                    o = this.externalXAxes.get(i);
                    if (!(o instanceof AxisComponent)) continue;
                    ((AxisComponent)o).setStyle(this.style);
                }
            }
            if (this.externalYAxes != null && this.externalYAxes.size() > 0) {
                size = this.externalYAxes.size();
                for (int i = 0; i < size; ++i) {
                    o = this.externalYAxes.get(i);
                    if (!(o instanceof AxisComponent)) continue;
                    ((AxisComponent)o).setStyle(this.style);
                }
            }
        }
        return true;
    }

    public DataFilterReadInterface getFilter() {
        return this.filter;
    }

    public DataFilterReadInterface getFilter(Object id) {
        return this.getFilter();
    }

    public boolean setDataListening(boolean listen) {
        return false;
    }

    public boolean isDataListening() {
        return true;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean setEditable(boolean editable) {
        return false;
    }

    public boolean applyWhereClause(String whereClause, boolean clear) {
        boolean returnValue = true;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) continue;
                returnValue = ((GraphInterface)this.components[i]).applyWhereClause(whereClause, clear) && returnValue;
            }
        }
        returnValue = this.filter != null ? this.filter.applyWhereClause(whereClause, clear) && returnValue : false;
        return returnValue;
    }

    public String getWhereClause() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getWhereClause();
    }

    public boolean setTitle(int index, String textString) {
        return false;
    }

    public boolean setTitle(int index, TextStyleInterface textObject) {
        return false;
    }

    public TextStyleInterface getTitle(int index) {
        return null;
    }

    public boolean setFootnote(int index, String textString) {
        return false;
    }

    public boolean setFootnote(int index, TextStyleInterface textObject) {
        return false;
    }

    public TextStyleInterface getFootnote(int index) {
        return null;
    }

    public Object getLegendPosition(Object which) {
        return null;
    }

    public boolean setLegendPosition(Object which, Object positionIn) {
        return false;
    }

    public Rectangle getLegendBounds() {
        return null;
    }

    public boolean setLegendBounds(Rectangle rect) {
        return false;
    }

    public boolean isBackBufferDrawEnabled() {
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof GraphInterface)) continue;
                return ((GraphInterface)this.components[i]).isBackBufferDrawEnabled();
            }
        }
        return false;
    }

    public boolean isModelAttributeHonored(Object attribute) {
        return false;
    }

    public void setBackBufferDrawEnabled(boolean drawback) {
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof GraphInterface)) continue;
                ((GraphInterface)this.components[i]).setBackBufferDrawEnabled(drawback);
            }
        }
    }

    public boolean setHonorModelAttribute(Object attribute, boolean honorit) {
        boolean rc = true;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof GraphInterface)) continue;
                rc |= ((GraphInterface)this.components[i]).setHonorModelAttribute(attribute, honorit);
            }
        }
        return rc;
    }

    public void enablePopup(boolean on) {
        this.popupEnabled = on;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = this.createPopupMenu();
        }
        return this.popup;
    }

    public void dispose() {
        this.disposeComponents();
        if (this.toolbar != null) {
            this.toolbar.setVisible(false);
            if (this.toolbar instanceof GraphToolbarInterface) {
                ((GraphToolbarInterface)this.toolbar).removeAllListeners();
            }
        }
        this.toolbar = null;
        if (this.graphDialog != null) {
            this.graphDialog.setVisible(false);
            this.graphDialog.dispose();
        }
        this.graphDialog = null;
        if (this.dataDialog != null) {
            this.dataDialog.setVisible(false);
            this.dataDialog.dispose();
        }
        this.dataDialog = null;
        this.components = null;
        this.dataSource = null;
        this.filter = null;
        this.matrix = null;
        this.layout = null;
        this.popup = null;
        this.style = null;
        this.labelColor = null;
        this.rb = null;
        this.parentFrame = null;
        this.matrixVars = null;
        this.roles = null;
        this.matrixVar = null;
        this.externalXAxes = null;
        this.externalYAxes = null;
        SILKGlobal.unregister((PropertyInterface)this);
    }

    public Dialog getDialog(Object id, Object listener) {
        if (id instanceof String) {
            String ID = (String)id;
            if (StringCompare.equals((String)ID, (String)"Properties")) {
                return this.graphDialog;
            }
            if (StringCompare.equals((String)ID, (String)"Data")) {
                return this.dataDialog;
            }
        }
        return null;
    }

    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        if (dialogIn == null) {
            return false;
        }
        if (id instanceof String) {
            String ID = (String)id;
            if (StringCompare.equals((String)ID, (String)"Properties")) {
                if (dialogIn instanceof TabbedPropertiesDialog) {
                    this.graphDialog = (TabbedPropertiesDialog)dialogIn;
                    return true;
                }
                return false;
            }
            if (StringCompare.equals((String)ID, (String)"Data")) {
                this.dataDialog = dialogIn;
                return true;
            }
        }
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    public AnnotateInterface getAnnotate() {
        return null;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    public int getSelectionBehavior() {
        return -1;
    }

    public Object getSelectionBehaviorValue() {
        return null;
    }

    public boolean setSelectionBehavior(int behavior, Object value) {
        boolean rc = true;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof GraphInterface)) continue;
                rc |= ((GraphInterface)this.components[i]).setSelectionBehavior(behavior, value);
            }
        }
        return rc;
    }

    public void addViewportListener(Object listener) {
    }

    public void removeViewportListener(Object listener) {
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object idIn) {
        this.id = idIn;
    }

    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    public Object getChart(Object id) {
        int irow;
        int icol;
        int n = 0;
        JComponent[] out = null;
        if (this.components == null || this.components.length <= 0) {
            return null;
        }
        if (id == null) {
            out = new JComponent[this.components.length];
            if (out == null) {
                return null;
            }
            for (int i = 0; i < this.components.length; ++i) {
                out[i] = this.components[i];
            }
            return out;
        }
        int type = Extract.getSourceType((Object)id);
        n = Extract.getNumberItems((Object)id, (int)type);
        if (n <= 0) {
            return null;
        }
        switch (n) {
            case 1: {
                icol = Extract.getInteger((Object)id, (int)0, (int)type);
                irow = 0;
                break;
            }
            default: {
                irow = Extract.getInteger((Object)id, (int)0, (int)type);
                icol = Extract.getInteger((Object)id, (int)1, (int)type);
            }
        }
        int i = irow * this.matrixVars.size() + icol;
        if (i < 0 || i >= this.components.length) {
            return null;
        }
        return this.components[i];
    }

    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    public boolean isActionEnabled(String action) {
        return true;
    }

    public boolean isPropertySupported(int id) {
        int i;
        if (this.components == null) {
            return false;
        }
        if (this.showExternalAxes) {
            switch (id) {
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 206: 
                case 213: 
                case 214: 
                case 216: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 237: 
                case 238: 
                case 240: 
                case 242: 
                case 244: 
                case 245: 
                case 246: 
                case 9001: 
                case 9002: 
                case 9014: {
                    return true;
                }
                case 239: {
                    return false;
                }
            }
        }
        if (id == 34) {
            return false;
        }
        if (id == 0) {
            return true;
        }
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof PropertyInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((PropertyInterface)this.components[i]).isPropertySupported(id);
        }
        return false;
    }

    public boolean isPropertyPending(int id) {
        int i;
        if (this.components == null) {
            return false;
        }
        if (this.showExternalAxes) {
            switch (id) {
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 213: 
                case 214: 
                case 216: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 237: 
                case 240: 
                case 242: 
                case 244: 
                case 245: 
                case 246: 
                case 9001: 
                case 9002: {
                    return this.isAxisPropertyPending(id);
                }
                case 239: {
                    return false;
                }
            }
        }
        if (id == 0 && !this.properties.isEmpty() && this.properties.containsKey(new Integer(id))) {
            return true;
        }
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof PropertyInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((PropertyInterface)this.components[i]).isPropertyPending(id);
        }
        return false;
    }

    public Object getPropertyValue(int id) {
        int i;
        if (this.components == null) {
            return null;
        }
        if (this.showExternalAxes) {
            switch (id) {
                case 238: {
                    return new Integer(this.currentAxis);
                }
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 206: 
                case 213: 
                case 214: 
                case 216: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 237: 
                case 240: 
                case 242: 
                case 244: 
                case 245: 
                case 246: 
                case 9001: 
                case 9002: 
                case 9014: {
                    return this.getAxisPropertyValue(id);
                }
                case 239: {
                    return null;
                }
            }
        }
        if (id == 34) {
            return null;
        }
        if (id == 0 && !this.properties.isEmpty() && this.properties.containsKey(new Integer(id))) {
            Object value = this.properties.get(new Integer(id));
            if (value != null) {
                return value;
            }
            return new ColorScheme(this.style);
        }
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof PropertyInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((PropertyInterface)this.components[i]).getPropertyValue(id);
        }
        return null;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.components == null) {
            return false;
        }
        if (this.showExternalAxes) {
            block0 : switch (id) {
                case 238: {
                    Object v = value;
                    if (value != null && value instanceof PropertyEvent) {
                        v = ((PropertyEvent)value).value;
                    }
                    if (v != null && v instanceof Number) {
                        int curAxis = ((Number)v).intValue();
                        switch (curAxis) {
                            case 0: 
                            case 1: {
                                this.currentAxis = curAxis;
                                break block0;
                            }
                        }
                        return false;
                    }
                    return false;
                }
                case 246: {
                    this.setAxisPropertyValue(id, value);
                    break;
                }
                case 244: {
                    int ca = this.currentAxis;
                    this.currentAxis = 0;
                    this.setAxisPropertyValue(id, value);
                    this.currentAxis = ca;
                    break;
                }
                case 245: {
                    int ca = this.currentAxis;
                    this.currentAxis = 1;
                    this.setAxisPropertyValue(id, value);
                    this.currentAxis = ca;
                    break;
                }
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 206: 
                case 213: 
                case 214: 
                case 216: 
                case 222: 
                case 223: 
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 237: 
                case 240: 
                case 242: 
                case 9001: 
                case 9002: {
                    return this.setAxisPropertyValue(id, value);
                }
                case 239: {
                    return false;
                }
            }
        }
        if (id == 0) {
            this.properties.put(new Integer(id), value);
            return true;
        }
        boolean first = true;
        boolean returnVal = false;
        for (int i = 0; i < this.components.length; ++i) {
            if (!(this.components[i] instanceof PropertyInterface)) continue;
            if (first) {
                returnVal = true;
                first = false;
            }
            returnVal = ((PropertyInterface)this.components[i]).setPropertyValue(id, value) && returnVal;
        }
        return returnVal;
    }

    public int getNumberPendingProperties() {
        return 0;
    }

    public boolean applyPropertyChanges() {
        if (this.components == null) {
            return false;
        }
        boolean first = true;
        boolean returnVal = false;
        if (this.showExternalAxes) {
            returnVal = this.applyAxisPropertyChanges();
            first = false;
        }
        if (!this.properties.isEmpty()) {
            Enumeration keys = this.properties.keys();
            Enumeration values = this.properties.elements();
            while (keys.hasMoreElements()) {
                Integer i = (Integer)keys.nextElement();
                int key = -1;
                if (i != null) {
                    key = i;
                }
                Object value = values.nextElement();
                switch (key) {
                    case 0: {
                        this.setColorScheme(value);
                    }
                }
            }
            this.properties.clear();
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] != null && this.components[i] instanceof PropertyInterface) {
                if (first) {
                    returnVal = true;
                    first = false;
                }
                boolean bl = returnVal = ((PropertyInterface)this.components[i]).applyPropertyChanges() && returnVal;
            }
            if (!(this.components[i] instanceof UpdateInterface)) continue;
            UpdateInterface u = (UpdateInterface)this.components[i];
            u.build(null);
        }
        this.repaint();
        return returnVal;
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.components == null) {
            return false;
        }
        boolean first = true;
        boolean returnVal = false;
        if (this.showExternalAxes) {
            returnVal = this.applyAxisPropertyChanges();
            first = false;
        }
        if (!this.properties.isEmpty()) {
            Enumeration keys = this.properties.keys();
            Enumeration values = this.properties.elements();
            while (keys.hasMoreElements()) {
                Integer i = (Integer)keys.nextElement();
                int key = -1;
                if (i != null) {
                    key = i;
                }
                Object value = values.nextElement();
                switch (key) {
                    case 0: {
                        this.setColorScheme(value);
                    }
                }
            }
            this.properties.clear();
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] != null && this.components[i] instanceof PropertyInterface) {
                if (first) {
                    returnVal = true;
                    first = false;
                }
                boolean bl = returnVal = ((PropertyInterface)this.components[i]).applyPropertyChanges(source) && returnVal;
            }
            if (!(this.components[i] instanceof UpdateInterface)) continue;
            UpdateInterface u = (UpdateInterface)this.components[i];
            u.build(null);
        }
        this.repaint();
        return returnVal;
    }

    public void cancelPropertyChanges() {
        if (this.components == null) {
            return;
        }
        if (this.showExternalAxes) {
            this.cancelAxisPropertyChanges();
        }
        this.properties.clear();
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || !(this.components[i] instanceof PropertyInterface)) continue;
            ((PropertyInterface)this.components[i]).cancelPropertyChanges();
        }
    }

    public void cancelPropertyChanges(Object source) {
        if (this.components == null) {
            return;
        }
        if (this.showExternalAxes) {
            this.cancelAxisPropertyChanges();
        }
        this.properties.clear();
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || !(this.components[i] instanceof PropertyInterface)) continue;
            ((PropertyInterface)this.components[i]).cancelPropertyChanges(source);
        }
    }

    public int[] getPendingChanges() {
        return null;
    }

    public int[] getPendingChanges(Object source) {
        return null;
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        return rc;
    }

    private ArrayList getCurrentAxes() {
        switch (this.currentAxis) {
            case 0: {
                return this.externalXAxes;
            }
            case 1: {
                return this.externalYAxes;
            }
        }
        return null;
    }

    private boolean isAxisPropertyPending(int id) {
        ArrayList axes = this.getCurrentAxes();
        if (axes == null || axes.size() == 0) {
            return false;
        }
        Object o = axes.get(0);
        if (o != null && o instanceof PropertyInterface) {
            PropertyInterface p = (PropertyInterface)o;
            return p.isPropertyPending(id);
        }
        return false;
    }

    private Object getAxisPropertyValue(int id) {
        ArrayList axes = this.getCurrentAxes();
        if (axes == null || axes.size() == 0) {
            if (id == 237) {
                return new Boolean(false);
            }
            return null;
        }
        Object o = axes.get(0);
        if (o != null && o instanceof PropertyInterface) {
            PropertyInterface p = (PropertyInterface)o;
            return p.getPropertyValue(id);
        }
        return null;
    }

    private boolean setAxisPropertyValue(int id, Object value) {
        ArrayList axes = this.getCurrentAxes();
        if (axes == null || axes.size() == 0) {
            return false;
        }
        boolean return_flag = true;
        int numAxes = axes.size();
        for (int i = 0; i < numAxes; ++i) {
            Object o = axes.get(i);
            if (o == null || !(o instanceof PropertyInterface)) continue;
            PropertyInterface p = (PropertyInterface)o;
            return_flag = return_flag && p.setPropertyValue(id, value);
        }
        return return_flag;
    }

    private boolean applyAxisPropertyChanges() {
        PropertyInterface p;
        Object o;
        int i;
        int size;
        boolean returnValue = true;
        if (this.externalXAxes != null && this.externalXAxes.size() > 0) {
            size = this.externalXAxes.size();
            for (i = 0; i < size; ++i) {
                o = this.externalXAxes.get(i);
                if (o == null || !(o instanceof PropertyInterface)) continue;
                p = (PropertyInterface)o;
                returnValue = p.applyPropertyChanges() && returnValue;
            }
        }
        if (this.externalYAxes != null && this.externalYAxes.size() > 0) {
            size = this.externalYAxes.size();
            for (i = 0; i < size; ++i) {
                o = this.externalYAxes.get(i);
                if (o == null || !(o instanceof PropertyInterface)) continue;
                p = (PropertyInterface)o;
                returnValue = p.applyPropertyChanges() && returnValue;
            }
        }
        return returnValue;
    }

    private void cancelAxisPropertyChanges() {
        PropertyInterface p;
        Object o;
        int i;
        int size;
        if (this.externalXAxes != null && this.externalXAxes.size() > 0) {
            size = this.externalXAxes.size();
            for (i = 0; i < size; ++i) {
                o = this.externalXAxes.get(i);
                if (o == null || !(o instanceof PropertyInterface)) continue;
                p = (PropertyInterface)o;
                p.cancelPropertyChanges();
            }
        }
        if (this.externalYAxes != null && this.externalYAxes.size() > 0) {
            size = this.externalYAxes.size();
            for (i = 0; i < size; ++i) {
                o = this.externalYAxes.get(i);
                if (o == null || !(o instanceof PropertyInterface)) continue;
                p = (PropertyInterface)o;
                p.cancelPropertyChanges();
            }
        }
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public Object getDataSource(Object id) {
        return this.getDataSource();
    }

    public boolean setDataSource(Object source) {
        if (source == null) {
            return false;
        }
        this.dataSource = source;
        this.filter = FilterFactory.getDataSourceFilter((Object)this.dataSource);
        return this.filter != null;
    }

    public boolean setDataSource(Object source, Object id) {
        return this.setDataSource(source);
    }

    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    public Object getVariable(Object role) {
        int i;
        int roleVal = this.getRoleIntValue(role);
        if (roleVal == 39) {
            return this.matrixVars.toArray();
        }
        for (i = 0; i < this.components.length && !(this.components[i] instanceof RoleInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((RoleInterface)this.components[i]).getVariable(role);
        }
        return null;
    }

    public Object getRole(Object variableId) {
        int i;
        int numVars = this.matrixVars.size();
        if (this.matrixVars != null) {
            for (i = 0; i < numVars; ++i) {
                if (!StringCompare.equals((String)this.matrixVars.get(i).toString(), (String)variableId.toString())) continue;
                return this.matrixVar;
            }
        }
        for (i = 0; i < this.components.length && !(this.components[i] instanceof RoleInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((RoleInterface)this.components[i]).getRole(variableId);
        }
        return null;
    }

    public boolean setRole(Object variableId, Object role) {
        int roleVal = this.getRoleIntValue(role);
        if (roleVal == 39 && variableId != null) {
            int varId = this.filter.getVariableIndex(variableId);
            if (varId < 0 || varId > this.filter.getNumberVariables() || !this.filter.isNumericVariable(variableId)) {
                return false;
            }
            this.matrixVars.add(variableId.toString());
            int numVars = this.matrixVars.size();
            if (numVars > 1) {
                if (this.externalAxes) {
                    this.showExternalAxes = true;
                }
                for (int i = 0; i < numVars; ++i) {
                    if (this.filter.isNumericVariable(this.matrixVars.get(i))) continue;
                    this.showExternalAxes = false;
                }
            }
            this.rebuildMatrix();
            return true;
        }
        int i = 0;
        boolean return_flag = false;
        boolean first = true;
        for (i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || !(this.components[i] instanceof RoleInterface)) continue;
            if (first) {
                return_flag = true;
                first = false;
            }
            return_flag = ((RoleInterface)this.components[i]).setRole(variableId, role) && return_flag;
        }
        return return_flag;
    }

    public boolean requiresMultipleRoleAssignments() {
        return true;
    }

    public boolean addRole(Object variableId, Object role) {
        int roleVal = this.getRoleIntValue(role);
        if (roleVal == 39 && variableId != null) {
            int varId = this.filter.getVariableIndex(variableId);
            if (varId < 0 || varId > this.filter.getNumberVariables() || !this.filter.isNumericVariable(variableId)) {
                return false;
            }
            this.matrixVars.add(variableId.toString());
            int numVars = this.matrixVars.size();
            if (numVars > 1) {
                if (this.externalAxes) {
                    this.showExternalAxes = true;
                }
                for (int i = 0; i < numVars; ++i) {
                    if (this.filter.isNumericVariable(this.matrixVars.get(i))) continue;
                    this.showExternalAxes = false;
                }
            }
            this.rebuildMatrix();
            return true;
        }
        int i = 0;
        boolean return_flag = false;
        boolean first = true;
        for (i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || !(this.components[i] instanceof RoleInterface)) continue;
            if (first) {
                return_flag = true;
                first = false;
            }
            return_flag = ((RoleInterface)this.components[i]).addRole(variableId, role) && return_flag;
        }
        return return_flag;
    }

    public boolean removeRole(Object variableId, Object role) {
        int roleVal = this.getRoleIntValue(role);
        if (roleVal == 39 && this.matrixVars != null) {
            int numVars = this.matrixVars.size();
            for (int i = 0; i < numVars; ++i) {
                if (!StringCompare.equals((String)this.matrixVars.get(i).toString(), (String)variableId.toString())) continue;
                this.matrixVars.remove(i);
                this.rebuildMatrix();
                return true;
            }
        }
        int i = 0;
        boolean return_flag = false;
        boolean first = true;
        for (i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null || !(this.components[i] instanceof RoleInterface)) continue;
            if (first) {
                return_flag = true;
                first = false;
            }
            return_flag = ((RoleInterface)this.components[i]).removeRole(variableId, role) && return_flag;
        }
        return return_flag;
    }

    public Object getRoleValue(Object role, int which) {
        return null;
    }

    public boolean isDiscrete(Object variableId) {
        return false;
    }

    public boolean setDiscrete(Object variableId, boolean discrete) {
        return false;
    }

    public Object[] getSupportedRoles(Object type, boolean discrete) {
        Object[] componentRoles = null;
        Object[] supportedRoles = null;
        if (this.components != null) {
            int i;
            for (i = 0; i < this.components.length && !(this.components[i] instanceof RoleInterface); ++i) {
            }
            if (i < this.components.length) {
                componentRoles = ((RoleInterface)this.components[i]).getSupportedRoles(null, discrete);
            }
        }
        if (componentRoles == null && this.matrixVars.size() < MAX_NUM_MATRIX_VARS) {
            supportedRoles = new Object[]{this.matrixVar};
        } else {
            int k = 0;
            for (int i = 0; i < componentRoles.length; ++i) {
                if (!(componentRoles[i] instanceof SILKNumber)) continue;
                int roleNumber = ((SILKNumber)componentRoles[i]).intValue();
                switch (roleNumber) {
                    case 1: 
                    case 17: 
                    case 24: 
                    case 25: {
                        ++k;
                    }
                }
            }
            int n = componentRoles.length - k + (this.matrixVars.size() < MAX_NUM_MATRIX_VARS ? 1 : 0);
            supportedRoles = new Object[n];
            k = 0;
            boolean ignore = false;
            if (this.matrixVars.size() < MAX_NUM_MATRIX_VARS) {
                supportedRoles[k++] = this.matrixVar;
            }
            for (int i = 0; i < componentRoles.length; ++i) {
                if (!(componentRoles[i] instanceof SILKNumber)) continue;
                ignore = false;
                int roleNumber = ((SILKNumber)componentRoles[i]).intValue();
                switch (roleNumber) {
                    case 1: 
                    case 17: 
                    case 24: 
                    case 25: {
                        ignore = true;
                    }
                }
                if (ignore) continue;
                supportedRoles[k++] = componentRoles[i];
            }
        }
        return supportedRoles;
    }

    public int getMaxAllowed(Object role) {
        if (role == null) {
            return 0;
        }
        int roleVal = this.getRoleIntValue(role);
        if (roleVal == 39) {
            return MAX_NUM_MATRIX_VARS;
        }
        int i = 0;
        if (this.components == null) {
            return 0;
        }
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof RoleInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((RoleInterface)this.components[i]).getMaxAllowed(role);
        }
        return 0;
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public Object getSortOrder(Object role) {
        int i;
        if (role == null) {
            return null;
        }
        if (this.components == null) {
            return null;
        }
        for (i = 0; !(i >= this.components.length || this.components[i] != null && this.components[i] instanceof RoleInterface); ++i) {
        }
        if (i < this.components.length) {
            return ((RoleInterface)this.components[i]).getSortOrder(role);
        }
        return null;
    }

    public boolean setSortOrder(Object role, Object order) {
        if (role == null || order == null) {
            return false;
        }
        boolean return_flag = false;
        boolean first = true;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i] == null || !(this.components[i] instanceof RoleInterface)) continue;
                if (first) {
                    return_flag = true;
                    first = false;
                }
                return_flag = ((RoleInterface)this.components[i]).setSortOrder(role, order) && return_flag;
            }
        }
        return return_flag;
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public int getRoleIntValue(Object role) {
        String s;
        int roleVal = -1;
        if (role instanceof Number) {
            roleVal = ((Number)role).intValue();
        } else if (role instanceof String && (this.roles.equalsRoleNLSName("ROLE_MATRIX_VAR", s = (String)role) || s.equalsIgnoreCase(this.engMatrixVar))) {
            roleVal = 39;
        }
        return roleVal;
    }

    public void rebuildMatrix() {
        this.removeAll();
        this.disposeComponents();
        this.components = new JComponent[this.matrixVars.size() * this.matrixVars.size()];
        this.createTrellis();
        this.createMatrix();
        this.invalidate();
        this.validate();
        this.repaint();
        System.runFinalization();
        System.gc();
    }

    public void disposeComponents() {
        while (this.externalXAxes != null && this.externalXAxes.size() > 0) {
            this.externalXAxes.remove(0);
        }
        while (this.externalYAxes != null && this.externalYAxes.size() > 0) {
            this.externalYAxes.remove(0);
        }
        this.matrix = null;
        this.layout = null;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i] != null && this.components[i] instanceof GraphInterface) {
                    ((GraphInterface)this.components[i]).setToolBar(null);
                    ((GraphInterface)this.components[i]).dispose();
                }
                this.components[i] = null;
            }
        }
        this.components = null;
        if (this.toolbar != null && this.toolbar instanceof GraphToolbarInterface) {
            ((GraphToolbarInterface)this.toolbar).removeAllListeners();
            ((GraphToolbarInterface)this.toolbar).addListener((GraphInterface)this);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setAxesFontHeights(x, y, width, height);
    }

    public void setAxesFontHeights(int x, int y, int width, int height) {
        int numVars = this.matrixVars.size();
        double rowHeight = (float)height / (float)numVars;
        double scaleFactor = 1.0 + (double)(this.matrixVars.size() - 1) / (double)this.matrixVars.size();
        double rh = rowHeight * scaleFactor;
        if (this.showExternalAxes) {
            for (int i = 0; i < numVars; ++i) {
                AxisComponent axis;
                boolean primary = true;
                if (this.alternateAxes) {
                    boolean bl = primary = i % 2 == 0;
                }
                if ((axis = (AxisComponent)this.matrix.getRowAxis(i, primary)) != null) {
                    axis.enableMarginPrefCalc();
                    axis.setDefaultFont(rh);
                }
                if ((axis = (AxisComponent)this.matrix.getColumnAxis(i, primary)) == null) continue;
                axis.enableMarginPrefCalc();
                axis.setDefaultFont(rh);
            }
        }
    }

    public void setAxesFontHeights(Rectangle r) {
        this.setAxesFontHeights(r.x, r.y, r.width, r.height);
    }

    public void setExternalAxesVisible(boolean flag) {
        this.externalAxes = flag;
    }

    public boolean areExternalAxesVisible() {
        return this.externalAxes;
    }

    public boolean setAlternateAxes(boolean flag) {
        this.alternateAxes = flag;
        return true;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (graphics == null || pageFormat == null) {
            return 1;
        }
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)graphics;
            Dimension d = this.getSize();
            double scaleX = pageFormat.getImageableWidth() / (double)d.width;
            double scaleY = pageFormat.getImageableHeight() / (double)d.height;
            double scale = Math.min(scaleX, scaleY);
            double w = scale * (double)d.width;
            double ht = scale * (double)d.height;
            int xTrans = (int)Math.max((pageFormat.getImageableWidth() - w) / 2.0, 0.0);
            int yTrans = (int)Math.max((pageFormat.getImageableHeight() - ht) / 2.0, 0.0);
            g2.translate(pageFormat.getImageableX() + (double)xTrans, pageFormat.getImageableY() + (double)yTrans);
            AffineTransform defaultXfm = g2.getTransform();
            AffineTransform xfm = new AffineTransform(defaultXfm);
            xfm.scale(scale, scale);
            g2.setTransform(xfm);
            this.matrix.paint((Graphics)g2);
            return 0;
        }
        return 1;
    }

    public void setShowOnlyLowerTriangle(boolean f) {
        boolean b = this.showOnlyLowerTriangle;
        this.showOnlyLowerTriangle = f;
        if (b != this.showOnlyLowerTriangle) {
            this.rebuildMatrix();
        }
    }

    public boolean initComponentsFromXML(Element chart, Hashtable context) {
        if (chart == null || this.components == null) {
            return false;
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (!(this.components[i] instanceof GraphInterface)) continue;
            SILKParser.initComponentFromXML((Object)this.components[i], (String)chart.toString(), (Hashtable)context);
        }
        return true;
    }

    public Element getComponentStatgraphXML(Hashtable context) {
        if (this.components == null) {
            return null;
        }
        int i = -1;
        while (++i < this.components.length && !(this.components[i] instanceof GraphInterface)) {
        }
        if (i >= this.components.length) {
            return null;
        }
        ElementParserInterface parser = GraphParserFactory.loadParser((Object)this.components[i]);
        if (context == null) {
            context = new Hashtable<String, Boolean>();
        }
        Object val = context.get("SCRIPT_ROLES");
        context.put("SCRIPT_ROLES", new Boolean(false));
        Element chart = parser.putToXML(context, (Object)this.components[i]);
        if (val != null) {
            context.put("SCRIPT_ROLES", (Boolean)val);
        }
        return chart;
    }

    public boolean getUsageMode(int mode) {
        return false;
    }

    public void setUsageMode(int mode, boolean on) {
    }
}

