/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.GraphToolbarInterface;
import com.sas.graphics.silk.interfaces.ImageListInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.interfaces.URLConsumerInterface;
import com.sas.graphics.silk.interfaces.URLSourceInterface;
import com.sas.graphics.silk.map.BlobReader;
import com.sas.graphics.silk.map.Categorization;
import com.sas.graphics.silk.map.MapObject;
import com.sas.graphics.silk.map.MarkerObject;
import com.sas.graphics.silk.map.ZoomWindow;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.LegendPanel;
import com.sas.graphics.silk.ui.MapAdvancedPanel;
import com.sas.graphics.silk.ui.MapMarkerPanel;
import com.sas.graphics.silk.ui.MapRegionPanel;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.RubberbandRectangle;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.silk.util.ToolTip;
import com.sas.graphics.util.LinearRing;
import com.sas.graphics.util.SortedVector;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.WKBMultiPolygon;
import com.sas.graphics.util.WKBPolygon;
import com.sas.text.SASFormat;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MapComponent
extends SILKComponent
implements DataFilterListenerInterface,
PropertyInterface,
ActionListener,
RoleInterface,
TextListenerInterface,
GraphInterface,
URLSourceInterface {
    private static final long serialVersionUID = 1721870271477149926L;
    protected static final int SPATIALROLE = 1;
    protected static final int MAPRESPONSEROLE = 2;
    protected static final int MARKERROLE = 3;
    protected SILKNumber spatialRole = null;
    protected SILKNumber mapIDRole = null;
    protected SILKNumber mapLevelRole = null;
    protected SILKNumber xRole = null;
    protected SILKNumber yRole = null;
    protected SILKNumber segmentRole = null;
    protected SILKNumber mapResponseIDRole = null;
    protected SILKNumber mapColorRole = null;
    protected SILKNumber mapColorIndexRole = null;
    protected SILKNumber mapWatermarkRole = null;
    protected SILKNumber mapLabelRole = null;
    protected SILKNumber mapOpacityRole = null;
    protected SILKNumber mapTransparencyRole = null;
    protected SILKNumber mapTipRole = null;
    protected SILKNumber graphVarRole = null;
    protected SILKNumber markerXRole = null;
    protected SILKNumber markerYRole = null;
    protected SILKNumber markerColorRole = null;
    protected SILKNumber markerColorIndexRole = null;
    protected SILKNumber markerSizeRole = null;
    protected SILKNumber markerLevelRole = null;
    protected SILKNumber markerTipRole = null;
    protected SILKNumber urlRole = null;
    protected SILKNumber markerUrlRole = null;
    protected DataFilterReadInterface spatialData = null;
    protected DataFilterReadInterface mapResponseData = null;
    protected DataFilterReadInterface markerData = null;
    protected MapObject mapObject = null;
    protected MarkerObject markerObject = null;
    protected boolean colorGraphsByChart = true;
    protected boolean useSimpleMarkers = true;
    protected boolean transformed = false;
    protected boolean showShadows = false;
    protected AppletContext appletContext = null;
    private boolean chartTipsOn = true;
    private Hashtable pending = null;
    private boolean rebuildRequired = false;
    private boolean resizeRequired = false;
    private boolean redrawRequired = false;
    private boolean showLabels = true;
    protected Component toolbar = null;
    protected JPopupMenu menu = null;
    boolean showPopup = true;
    boolean showToolbar = true;
    Boolean savedLegendState = null;
    protected int actionMode = 1;
    protected boolean pickMap = true;
    protected boolean pickMarkers = true;
    boolean showMarkers = true;
    private ResourceBundle rb = null;
    protected double xMin;
    protected double xMax;
    protected double yMin;
    protected double yMax;
    protected double modelAspectRatio = 1.0;
    protected double viewAspectRatio = 1.0;
    protected Point zoomPoint = new Point();
    protected Rectangle mapBounds = new Rectangle();
    protected Rectangle mapAreaBounds = new Rectangle();
    protected ZoomWindow zoomWindow = null;
    protected BufferedImage backBuffer = null;
    protected BufferedImage backBuffer2 = null;
    protected BufferedImage zoomBuffer = null;
    protected boolean useSecondBackBuffer = false;
    protected Point panLastPoint = new Point();
    protected Point panOffset = new Point();
    protected String currentLegend = "map";
    private ToolTip tip = null;
    private String tipText = null;
    private Point tipLocation = null;
    protected RubberbandRectangle rbrect;
    protected Rectangle brushRect = null;
    protected Point brushBeginPoint = null;
    protected Rectangle viewportRect = null;
    protected Point viewportBeginPoint = null;
    protected BlobReader blobReader = null;
    private LegendObjectJ2D legend = null;
    private LegendObjectJ2D markerLegend = null;
    private boolean showZoomWindow = false;
    private boolean zoomAdded = false;
    private boolean brushing = false;
    private boolean movingBrush = false;
    Container parent = null;
    protected Toolkit tk;
    protected static Cursor normalCursor = Cursor.getPredefinedCursor(0);
    protected static Cursor moveCursorOpen = null;
    protected static Cursor moveCursorClose = null;
    protected static Cursor brushCursor = Cursor.getPredefinedCursor(1);
    protected static Cursor zoomCursor = null;
    protected static Cursor panCursor = null;
    protected Cursor cursor;

    public MapComponent(Object sData, Object rData) {
        this();
        this.spatialData = FilterFactory.getDataSourceFilter((Object)sData);
        this.spatialData.addDataFilterListener((Object)this);
        this.mapResponseData = FilterFactory.getDataSourceFilter((Object)rData);
        this.mapResponseData.addDataFilterListener((Object)this);
        this.roles.setDataset((Object)"map", (Object)this.spatialData);
        this.roles.setDataset((Object)"response", (Object)this.mapResponseData);
        this.mapObject.setSpatialData(this.spatialData);
        this.mapObject.setMapResponseData(this.mapResponseData);
    }

    public MapComponent(Object dataIn) {
        this();
        this.spatialData = FilterFactory.getDataSourceFilter((Object)dataIn);
        this.spatialData.addDataFilterListener((Object)this);
        this.roles.setDataset((Object)"map", (Object)this.spatialData);
        this.mapObject.setSpatialData(this.spatialData);
    }

    public MapComponent() {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
        this.spatialRole = this.roleIndex.getRoleObject("ROLE_SPATIAL");
        this.roles.newRole((Object)this.spatialRole, (Object)"SPATIAL", 1, (Object)"map");
        this.xRole = this.roleIndex.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, (Object)"X", 1, (Object)"map");
        this.yRole = this.roleIndex.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, (Object)"Y", 1, (Object)"map");
        this.segmentRole = this.roleIndex.getRoleObject("ROLE_SEGMENT");
        this.roles.newRole((Object)this.segmentRole, (Object)"SEGMENT", 1, (Object)"map");
        this.mapIDRole = this.roleIndex.getRoleObject("ROLE_MAP_ID");
        this.roles.newRole((Object)this.mapIDRole, (Object)"MAP_ID", 1, (Object)"map");
        this.mapLevelRole = this.roleIndex.getRoleObject("ROLE_MAP_LEVEL");
        this.roles.newRole((Object)this.mapLevelRole, (Object)"MAP_LEVEL", 1, (Object)"response");
        this.mapResponseIDRole = this.roleIndex.getRoleObject("ROLE_MAP_RESPONSE_ID");
        this.roles.newRole((Object)this.mapResponseIDRole, (Object)"MAP_RESPONSE_ID", 1, (Object)"response");
        this.mapColorRole = this.roleIndex.getRoleObject("ROLE_MAP_COLOR");
        this.roles.newRole((Object)this.mapColorRole, (Object)"MAP_COLOR", 1, (Object)"response");
        this.mapColorIndexRole = this.roleIndex.getRoleObject("ROLE_MAP_COLOR_INDEX");
        this.roles.newRole((Object)this.mapColorIndexRole, (Object)"MAP_COLOR_INDEX", 1, (Object)"response");
        this.mapWatermarkRole = this.roleIndex.getRoleObject("ROLE_WATERMARK");
        this.roles.newRole((Object)this.mapWatermarkRole, (Object)"WATERMARK", 10, (Object)"response");
        this.mapLabelRole = this.roleIndex.getRoleObject("ROLE_MAP_LABEL");
        this.roles.newRole((Object)this.mapLabelRole, (Object)"MAP_LABEL", 1, (Object)"response");
        this.mapOpacityRole = this.roleIndex.getRoleObject("ROLE_MAP_OPACITY");
        this.roles.newRole((Object)this.mapOpacityRole, (Object)"MAP_OPACITY", 1, (Object)"response");
        this.mapTransparencyRole = this.roleIndex.getRoleObject("ROLE_MAP_TRANSPARENCY");
        this.roles.newRole((Object)this.mapTransparencyRole, (Object)"MAP_TRANSPARENCY", 1, (Object)"response");
        this.mapTipRole = this.roleIndex.getRoleObject("ROLE_TIP");
        this.roles.newRole((Object)this.mapTipRole, (Object)"TIP", 10, (Object)"response");
        this.graphVarRole = this.roleIndex.getRoleObject("ROLE_GRAPH_VAR");
        this.roles.newRole((Object)this.graphVarRole, (Object)"GRAPH_VAR", 5, (Object)"response");
        this.markerXRole = this.roleIndex.getRoleObject("ROLE_MARKER_X");
        this.roles.newRole((Object)this.markerXRole, (Object)"MARKER_X", 1, (Object)"marker");
        this.markerYRole = this.roleIndex.getRoleObject("ROLE_MARKER_Y");
        this.roles.newRole((Object)this.markerYRole, (Object)"MARKER_Y", 1, (Object)"marker");
        this.markerColorRole = this.roleIndex.getRoleObject("ROLE_MARKER_COLOR");
        this.roles.newRole((Object)this.markerColorRole, (Object)"MARKER_COLOR", 1, (Object)"marker");
        this.markerColorIndexRole = this.roleIndex.getRoleObject("ROLE_MARKER_COLOR_INDEX");
        this.roles.newRole((Object)this.markerColorIndexRole, (Object)"MARKERCOLORINDEX", 1, (Object)"marker");
        this.markerSizeRole = this.roleIndex.getRoleObject("ROLE_MARKER_SIZE");
        this.roles.newRole((Object)this.markerSizeRole, (Object)"MARKER_SIZE", 1, (Object)"marker");
        this.markerLevelRole = this.roleIndex.getRoleObject("ROLE_MARKER_LEVEL");
        this.roles.newRole((Object)this.markerLevelRole, (Object)"MARKER_LEVEL", 1, (Object)"marker");
        this.markerTipRole = this.roleIndex.getRoleObject("ROLE_MARKER_TIP");
        this.roles.newRole((Object)this.markerLevelRole, (Object)"MARKER_TIP", 1, (Object)"marker");
        this.urlRole = this.roleIndex.getRoleObject("ROLE_URL");
        this.roles.newRole((Object)this.urlRole, (Object)"URL", 1, (Object)"response");
        this.markerUrlRole = this.roleIndex.getRoleObject("ROLE_MARKER_URL");
        this.roles.newRole((Object)this.markerUrlRole, (Object)"MARKER_URL", 1, (Object)"marker");
        this.mapObject = new MapObject();
        this.mapObject.setRoleManager(this.roles);
        this.markerObject = new MarkerObject();
        this.markerObject.setRoleManager(this.roles);
        this.tip = new ToolTip();
        this.rbrect = new RubberbandRectangle((Component)((Object)this));
        this.blobReader = new BlobReader();
        this.setStyle(SILKGlobal.getInstance().getPropertyValue(29));
        this.pending = new Hashtable();
        this.addMouseMotionListener((MouseMotionListener)((Object)this));
        this.addMouseListener((MouseListener)((Object)this));
        this.tk = this.getToolkit();
        if (moveCursorOpen == null) {
            moveCursorOpen = this.getCustomCursor(6, 2, "icons/MoveOpen.gif");
        }
        if (moveCursorClose == null) {
            moveCursorClose = this.getCustomCursor(6, 2, "icons/MoveClosed.gif");
        }
        if (panCursor == null) {
            panCursor = this.getCustomCursor(6, 2, "icons/move_32.gif");
        }
        if (zoomCursor == null) {
            zoomCursor = this.getCustomCursor(6, 2, "icons/focus_32.gif");
        }
        this.cursor = normalCursor;
        this.setCursor(this.cursor);
        this.mapObject.getText().addTextListener((TextListenerInterface)this);
        this.legend = new LegendObjectJ2D();
        this.legend.setPosition(2);
        this.legend.setVisible(true);
        this.markerLegend = new LegendObjectJ2D();
        this.markerLegend.setPosition(2);
        this.markerLegend.setVisible(true);
        this.graphLayout.addLegend((LegendInterface)this.legend);
        this.graphLayout.addLegend((LegendInterface)this.markerLegend);
    }

    public void addNotify() {
        super.addNotify();
        Object c = this;
        while ((c = ((Component)c).getParent()) != null) {
            if (!(c instanceof Frame)) continue;
            this.parent = (Frame)c;
            break;
        }
        this.zoomWindow = new ZoomWindow((Frame)this.parent);
        this.zoomWindow.setVisible(this.showZoomWindow);
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        String[] names = new String[]{"map", "marker"};
        String[] displayNames = new String[]{ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Map.txt", (String)"Map"), ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Marker.txt", (String)"Marker")};
        if (dialogIn instanceof TabbedPropertiesDialog) {
            switch (category) {
                case 0: {
                    TabPanelInterface tab = ((TabbedPropertiesDialog)dialogIn).getTab(GraphPanel.class);
                    if (tab == null) {
                        ((TabbedPropertiesDialog)dialogIn).addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Graph.txt", (String)"Graph"), (TabPanelInterface)new GraphPanel((PropertyInterface)this, (PropertyInterface)this.tip));
                        break;
                    }
                    tab.addPropertyListener((PropertyInterface)this);
                    break;
                }
                case 1: {
                    TabPanelInterface tab = ((TabbedPropertiesDialog)dialogIn).getTab(MapRegionPanel.class);
                    if (tab == null) {
                        ((TabbedPropertiesDialog)dialogIn).addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Regions.txt", (String)"Regions"), (TabPanelInterface)new MapRegionPanel(this, (PropertyInterface)this.mapObject.getText()));
                    } else {
                        tab.addPropertyListener((PropertyInterface)this);
                    }
                    tab = ((TabbedPropertiesDialog)dialogIn).getTab(MapMarkerPanel.class);
                    if (tab == null) {
                        ((TabbedPropertiesDialog)dialogIn).addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Markers.txt", (String)"Markers"), (TabPanelInterface)new MapMarkerPanel(this, (PropertyInterface)this.mapObject.getText()));
                    } else {
                        tab.addPropertyListener((PropertyInterface)this);
                    }
                    tab = ((TabbedPropertiesDialog)dialogIn).getTab(MapAdvancedPanel.class);
                    if (tab == null) {
                        ((TabbedPropertiesDialog)dialogIn).addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Advanced.txt", (String)"Advanced"), (TabPanelInterface)new MapAdvancedPanel(this, this));
                        break;
                    }
                    tab.addPropertyListener((PropertyInterface)this);
                    break;
                }
                case 3: {
                    TabPanelInterface tab = ((TabbedPropertiesDialog)dialogIn).getTab(LegendPanel.class);
                    if (tab == null) {
                        ((TabbedPropertiesDialog)dialogIn).addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Legend.txt", (String)"Legend"), (TabPanelInterface)new LegendPanel((PropertyInterface)this, names, displayNames));
                        break;
                    }
                    tab.addPropertyListener((PropertyInterface)this);
                    break;
                }
                case 4: {
                    TabPanelInterface tab = ((TabbedPropertiesDialog)dialogIn).getTab(TitlePanel.class);
                    if (tab == null) {
                        ((TabbedPropertiesDialog)dialogIn).addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Titles_Footnoes.txt", (String)"Titles/Footnotes"), (TabPanelInterface)new TitlePanel((PropertyInterface)this, (JComponent)((Object)this)));
                        break;
                    }
                    tab.addPropertyListener((PropertyInterface)this);
                    break;
                }
                case 999: {
                    TabPanelInterface tab = ((TabbedPropertiesDialog)dialogIn).getTab(GraphPanel.class);
                    if (tab == null) {
                        ((TabbedPropertiesDialog)dialogIn).addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Graph.txt", (String)"Graph"), (TabPanelInterface)new GraphPanel((PropertyInterface)this, (PropertyInterface)this.tip));
                    } else {
                        tab.addPropertyListener((PropertyInterface)this);
                    }
                    tab = ((TabbedPropertiesDialog)dialogIn).getTab(MapRegionPanel.class);
                    if (tab == null) {
                        ((TabbedPropertiesDialog)dialogIn).addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Regions.txt", (String)"Regions"), (TabPanelInterface)new MapRegionPanel(this, (PropertyInterface)this.mapObject.getText()));
                    } else {
                        tab.addPropertyListener((PropertyInterface)this);
                    }
                    tab = ((TabbedPropertiesDialog)dialogIn).getTab(MapMarkerPanel.class);
                    if (tab == null) {
                        ((TabbedPropertiesDialog)dialogIn).addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Markers.txt", (String)"Markers"), (TabPanelInterface)new MapMarkerPanel(this, (PropertyInterface)this.mapObject.getText()));
                    } else {
                        tab.addPropertyListener((PropertyInterface)this);
                    }
                    tab = ((TabbedPropertiesDialog)dialogIn).getTab(MapAdvancedPanel.class);
                    if (tab == null) {
                        ((TabbedPropertiesDialog)dialogIn).addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Advanced.txt", (String)"Advanced"), (TabPanelInterface)new MapAdvancedPanel(this, this));
                    } else {
                        tab.addPropertyListener((PropertyInterface)this);
                    }
                    tab = ((TabbedPropertiesDialog)dialogIn).getTab(LegendPanel.class);
                    if (tab == null) {
                        ((TabbedPropertiesDialog)dialogIn).addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Legend.txt", (String)"Legend"), (TabPanelInterface)new LegendPanel((PropertyInterface)this, names, displayNames));
                    } else {
                        tab.addPropertyListener((PropertyInterface)this);
                    }
                    tab = ((TabbedPropertiesDialog)dialogIn).getTab(TitlePanel.class);
                    if (tab == null) {
                        ((TabbedPropertiesDialog)dialogIn).addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Titles_Footnoes.txt", (String)"Titles/Footnotes"), (TabPanelInterface)new TitlePanel((PropertyInterface)this, (JComponent)((Object)this)));
                        break;
                    }
                    tab.addPropertyListener((PropertyInterface)this);
                }
            }
        } else if (dialogIn instanceof GraphPropertiesDialog) {
            GraphPropertiesDialog gpd = (GraphPropertiesDialog)dialogIn;
            GraphPropertiesDialog.PropertiesTreeNode node = null;
            switch (category) {
                case 0: {
                    super.addTabs(id, dialogIn, category, (Object)this);
                    break;
                }
                case 1: {
                    node = gpd.getRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Regions.txt", (String)"Regions"), true);
                    if (node.getPanel() == null) {
                        node.setPanel((Component)new MapRegionPanel(this, (PropertyInterface)this.mapObject.getText()));
                    } else if (node.getPanel() instanceof TabPanelInterface) {
                        ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)this);
                    }
                    node = gpd.getRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Markers.txt", (String)"Markers"), true);
                    if (node.getPanel() == null) {
                        node.setPanel((Component)new MapMarkerPanel(this, (PropertyInterface)this.mapObject.getText()));
                    } else if (node.getPanel() instanceof TabPanelInterface) {
                        ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)this);
                    }
                    node = gpd.getRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Advanced.txt", (String)"Advanced"), true);
                    if (node.getPanel() == null) {
                        node.setPanel((Component)new MapAdvancedPanel(this, this));
                        break;
                    }
                    if (!(node.getPanel() instanceof TabPanelInterface)) break;
                    ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)this);
                    break;
                }
                case 3: {
                    node = gpd.getRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Legend.txt", (String)"Legend"), true);
                    if (node.getPanel() == null) {
                        node.setPanel((Component)new LegendPanel((PropertyInterface)this, names, displayNames));
                        break;
                    }
                    if (!(node.getPanel() instanceof TabPanelInterface)) break;
                    ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)this);
                    break;
                }
                case 4: {
                    node = gpd.getRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Titles_Footnoes.txt", (String)"Titles/Footnotes"), true);
                    if (node.getPanel() == null) {
                        node.setPanel((Component)new TitlePanel((PropertyInterface)this, (JComponent)((Object)this)));
                        break;
                    }
                    if (!(node.getPanel() instanceof TabPanelInterface)) break;
                    ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)this);
                    break;
                }
                case 999: {
                    node = gpd.getRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Regions.txt", (String)"Regions"), true);
                    if (node.getPanel() == null) {
                        node.setPanel((Component)new MapRegionPanel(this, (PropertyInterface)this.mapObject.getText()));
                    } else if (node.getPanel() instanceof TabPanelInterface) {
                        ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)this);
                    }
                    node = gpd.getRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Markers.txt", (String)"Markers"), true);
                    if (node.getPanel() == null) {
                        node.setPanel((Component)new MapMarkerPanel(this, (PropertyInterface)this.mapObject.getText()));
                    } else if (node.getPanel() instanceof TabPanelInterface) {
                        ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)this);
                    }
                    node = gpd.getRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Advanced.txt", (String)"Advanced"), true);
                    if (node.getPanel() == null) {
                        node.setPanel((Component)new MapAdvancedPanel(this, this));
                    } else if (node.getPanel() instanceof TabPanelInterface) {
                        ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)this);
                    }
                    node = gpd.getRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Legend.txt", (String)"Legend"), true);
                    if (node.getPanel() == null) {
                        node.setPanel((Component)new LegendPanel((PropertyInterface)this, names, displayNames));
                    } else if (node.getPanel() instanceof TabPanelInterface) {
                        ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)this);
                    }
                    node = gpd.getRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Titles_Footnoes.txt", (String)"Titles/Footnotes"), true);
                    if (node.getPanel() == null) {
                        node.setPanel((Component)new TitlePanel((PropertyInterface)this, (JComponent)((Object)this)));
                        break;
                    }
                    if (!(node.getPanel() instanceof TabPanelInterface)) break;
                    ((TabPanelInterface)node.getPanel()).addPropertyListener((PropertyInterface)this);
                }
            }
        }
        return false;
    }

    private GraphPropertiesDialog getPropertiesDialog() {
        if (this.propertiesDialog == null) {
            String[] names = new String[]{"map", "marker"};
            String[] displayNames = new String[]{ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Map.txt", (String)"Map"), ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Marker.txt", (String)"Marker")};
            this.createPropertyDialog(this);
            this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Graph.txt", (String)"Graph"), (Component)new GraphPanel((PropertyInterface)this, (PropertyInterface)this.tip));
            this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Regions.txt", (String)"Regions"), (Component)new MapRegionPanel(this, (PropertyInterface)this.mapObject.getText()));
            this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Markers.txt", (String)"Markers"), (Component)new MapMarkerPanel(this, (PropertyInterface)this.mapObject.getText()));
            this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Legend.txt", (String)"Legend"), (Component)new LegendPanel((PropertyInterface)this, names, displayNames));
            this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Titles_Footnoes.txt", (String)"Titles/Footnotes"), (Component)new TitlePanel((PropertyInterface)this, (JComponent)((Object)this)));
            this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Advanced.txt", (String)"Advanced"), (Component)new MapAdvancedPanel(this, this));
            this.propertiesDialog.setSelectedNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Regions.txt", (String)"Regions"));
        }
        return this.propertiesDialog;
    }

    protected Cursor getCustomCursor(int x, int y, String imgName) {
        Image img = null;
        if (imgName == null || this.tk == null) {
            return null;
        }
        img = ResourceLoader.getImage((Component)((Object)this), (String)imgName);
        if (img == null) {
            return null;
        }
        return this.tk.createCustomCursor(img, new Point(x, y), imgName);
    }

    protected void checkCursor(int x, int y, boolean mouseDown) {
        if (this.actionMode != 1) {
            return;
        }
        if (this.brushRect == null) {
            return;
        }
        if (this.brushRect.contains(x, y)) {
            if (mouseDown && this.cursor != moveCursorClose) {
                this.cursor = moveCursorClose;
                this.setCursor(this.cursor);
            } else if (!mouseDown && this.cursor != moveCursorOpen) {
                this.cursor = moveCursorOpen;
                this.setCursor(this.cursor);
            }
        } else if (this.cursor != normalCursor) {
            this.cursor = normalCursor;
            this.setCursor(this.cursor);
        }
    }

    public void paintComponent(Graphics g) {
        Graphics2D useGraphics;
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        super.paintComponent(g);
        if (this.rebuildRequired) {
            this.build(Boolean.TRUE);
            this.rebuildRequired = false;
        }
        if (this.resizeRequired || this.legend != null && this.legend.isUpdateRequired() || this.markerLegend != null && this.markerLegend.isUpdateRequired()) {
            this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
            this.resizeChart();
            this.resizeRequired = false;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.isUsingBackBuffer()) {
            if (this.backBuffer == null || this.useSecondBackBuffer && this.backBuffer2 == null) {
                this.buildBackBuffers();
            }
            if (this.redrawRequired) {
                this.drawChart((Graphics2D)this.backBuffer.getGraphics());
                this.redrawRequired = false;
            }
            g.drawImage(this.backBuffer, 0, 0, null);
        } else {
            this.drawChart(g2);
        }
        Point p = new Point(this.mapBounds.x, this.mapBounds.y);
        if (this.useSecondBackBuffer) {
            useGraphics = (Graphics2D)this.backBuffer2.getGraphics();
            useGraphics.setBackground(new Color(0, 0, 0, 0));
            useGraphics.clearRect(0, 0, this.compWidth, this.compHeight);
        } else {
            useGraphics = g2;
        }
        this.mapObject.drawSelectedRegions(useGraphics, p, 0);
        if (this.showLabels) {
            this.mapObject.drawLabels(g2, p);
        }
        if (this.showMarkers) {
            this.markerObject.drawMarkers(useGraphics, p, 0, 1.0, this.useSimpleMarkers);
        }
        if (this.mapObject.isShowGraphs()) {
            this.mapObject.drawGraphs(useGraphics, p, 1.0);
        }
        if (this.useSecondBackBuffer) {
            g.drawImage(this.backBuffer2, 0, 0, null);
        }
        this.drawBrush(g2);
        this.drawViewport(g2);
        if (this.chartTipsOn && this.tipText != null && this.tipText.length() > 0 && !this.mapObject.isGraphSelected()) {
            this.tip.paint((JComponent)((Object)this), g2, this.tipLocation, (Object)this.tipText);
        }
    }

    private void buildBackBuffers() {
        if (this.compWidth <= 0 || this.compHeight <= 0 || !this.isUsingBackBuffer()) {
            return;
        }
        if (this.backBuffer == null) {
            this.backBuffer = new BufferedImage(this.compWidth, this.compHeight, 1);
        }
        if (this.backBuffer2 == null && this.useSecondBackBuffer) {
            this.backBuffer2 = new BufferedImage(this.compWidth, this.compHeight, 2);
        }
        Graphics2D g = (Graphics2D)this.backBuffer.getGraphics();
        this.drawChart(g);
    }

    private void rebuildMarkerLegend() {
        Object markerColor = this.roles.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR, 0);
        Object markerColorIndex = this.roles.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR_INDEX, 0);
        if (this.markerData == null || markerColor == null && markerColorIndex == null) {
            this.graphLayout.removeLegend((LegendInterface)this.markerLegend);
            return;
        }
        if (!this.graphLayout.containsLegend((Object)this.markerLegend)) {
            this.graphLayout.addLegend((LegendInterface)this.markerLegend);
        }
        Color[] colors = this.markerObject.getMarkerColors();
        Object[] labels = this.markerObject.getMarkerColorLabels();
        if (markerColorIndex != null) {
            boolean sorted = false;
            Object order = this.getSortOrder(RoleInterface.ROLE_MARKER_COLOR_INDEX);
            if (order instanceof Number) {
                sorted = ((Number)order).intValue() == 1;
            }
            SortedVector vec = new SortedVector();
            vec.setRetrieveInSortedOrder(sorted);
            int numObs = this.markerData.getNumberObservations(markerColorIndex);
            for (int i = 0; i < numObs; ++i) {
                Object o = this.markerData.getValue(markerColorIndex, (long)i);
                if (this.markerData.isMissing(markerColorIndex, o)) continue;
                vec.addElement(o);
            }
            Color[] usedColors = new Color[vec.size()];
            labels = new String[vec.size()];
            for (int i = 0; i < usedColors.length; ++i) {
                usedColors[i] = colors[((Double)vec.elementAt(i)).intValue() % 12];
                labels[i] = ((Double)vec.elementAt(i)).toString();
            }
            colors = usedColors;
            this.markerLegend.setValues(colors, null, labels, null, false);
            this.markerData.getVariableDescription(markerColorIndex).toString();
        } else {
            if (this.markerData.isNumericVariable(markerColor) && this.markerObject.getCategorization().getCategoryType() == 0) {
                ColorRamp r = this.markerObject.getColorRamp();
                this.markerLegend.setLabel(this.markerData.getFormat(markerColor, SASFormat.class));
                if (r != null) {
                    this.markerLegend.setValues(colors, null, r.getBreaks(), null, true);
                }
            } else {
                this.markerLegend.setValues(colors, null, labels, null, false);
            }
            this.markerData.getVariableDescription(markerColor).toString();
        }
    }

    private void rebuildLegend() {
        Object mapID = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_ID, 0);
        Object mapResponseID = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_RESPONSE_ID, 0);
        Object mapColor = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR, 0);
        Object mapColorIndex = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR_INDEX, 0);
        int numWatermarkRoles = this.roles.getNumVariablesAssigned((Object)RoleInterface.ROLE_WATERMARK);
        if (this.spatialData == null || this.mapResponseData == null || mapID == null || mapResponseID == null || mapColor == null && numWatermarkRoles < 2) {
            this.graphLayout.removeLegend((LegendInterface)this.legend);
            return;
        }
        if (!this.graphLayout.containsLegend((Object)this.legend)) {
            this.graphLayout.addLegend((LegendInterface)this.legend);
        }
        if (numWatermarkRoles > 1) {
            Object[] watermarkRoles = new Object[numWatermarkRoles];
            for (int i = 0; i < numWatermarkRoles; ++i) {
                watermarkRoles[i] = this.roles.getVariable((Object)RoleInterface.ROLE_WATERMARK, i);
            }
            Object[] labels = new String[numWatermarkRoles];
            Color[] colors = this.mapObject.getWatermarkColors();
            for (int i = 0; i < numWatermarkRoles; ++i) {
                labels[i] = this.mapResponseData.getVariableDescription(watermarkRoles[i]).toString();
            }
            this.legend.setValues(colors, null, labels, null, false);
        } else {
            Color[] colors = this.mapObject.getMapColors();
            Object[] labels = this.mapObject.getMapColorLabels();
            if (mapColorIndex != null) {
                boolean sorted = false;
                Object order = this.getSortOrder(RoleInterface.ROLE_MAP_COLOR_INDEX);
                if (order instanceof Number) {
                    sorted = ((Number)order).intValue() == 1;
                }
                SortedVector vec = new SortedVector();
                vec.setRetrieveInSortedOrder(sorted);
                int numObs = this.mapResponseData.getNumberObservations(mapColorIndex);
                for (int i = 0; i < numObs; ++i) {
                    Object o = this.mapResponseData.getValue(mapColorIndex, (long)this.mapObject.getIndex(i));
                    if (this.mapResponseData.isMissing(mapColorIndex, o)) continue;
                    vec.addElement(o);
                }
                Color[] usedColors = new Color[vec.size()];
                labels = new String[vec.size()];
                for (int i = 0; i < usedColors.length; ++i) {
                    usedColors[i] = colors[((Double)vec.elementAt(i)).intValue() % 12];
                    labels[i] = ((Double)vec.elementAt(i)).toString();
                }
                colors = usedColors;
                this.legend.setValues(colors, null, labels, null, false);
                this.mapResponseData.getVariableDescription(mapColorIndex).toString();
            } else {
                if (this.mapResponseData.isNumericVariable(mapColor) && this.mapObject.getCategorization().getCategoryType() == 0) {
                    ColorRamp r = this.mapObject.getColorRamp();
                    this.legend.setLabel(this.mapResponseData.getFormat(mapColor, SASFormat.class));
                    if (r != null) {
                        this.legend.setValues(colors, null, r.getBreaks(), null, true);
                    }
                } else {
                    this.legend.setValues(colors, null, labels, null, false);
                }
                this.mapResponseData.getVariableDescription(mapColor).toString();
            }
        }
    }

    public void drawBrush(Graphics g) {
        g.setColor(Color.black);
        if (this.brushRect != null) {
            g.drawRect(this.brushRect.x, this.brushRect.y, this.brushRect.width, this.brushRect.height);
        }
    }

    public void drawViewport(Graphics g) {
    }

    public void update(Graphics g) {
        this.drawChart((Graphics2D)g);
        this.paint(g);
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        this.build(buildData);
        this.repaint();
        return true;
    }

    public boolean build(Object obj) {
        this.background.rebuildBackground();
        if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            this.rebuildMap();
            this.rebuildMarkers();
            this.rebuildLegend();
            this.rebuildMarkerLegend();
        }
        this.redrawRequired = true;
        return true;
    }

    protected void drawChart(Graphics2D g) {
        Rectangle rectangle = new Rectangle(0, 0, this.compWidth, this.compHeight);
        this.background.drawBackground(g, (Component)((Object)this), rectangle);
        this.mapObject.drawRegions(g, new Point(this.mapBounds.x, this.mapBounds.y), 0, 1.0);
        this.graphLayout.draw((Graphics)g);
        if (this.showZoomWindow) {
            if (this.zoomBuffer == null) {
                this.zoomBuffer = new BufferedImage(this.mapBounds.width * 2 + 2, this.mapBounds.height * 2 + 2, 2);
            }
            Graphics2D zg = (Graphics2D)this.zoomBuffer.getGraphics();
            this.mapObject.drawRegions(zg, new Point(0, 0), 1, 2.0);
            if (this.showMarkers) {
                this.markerObject.drawMarkers(zg, new Point(0, 0), 1, 2.0, this.useSimpleMarkers);
            }
            this.zoomWindow.setImage(this.zoomBuffer);
        }
    }

    protected void regenerateMapBounds() {
        this.viewAspectRatio = (double)this.mapAreaBounds.width / (double)this.mapAreaBounds.height;
        if (!this.transformed) {
            this.mapBounds = new Rectangle();
            if (this.modelAspectRatio > this.viewAspectRatio) {
                int ySize = (int)((double)this.mapAreaBounds.height * this.viewAspectRatio / this.modelAspectRatio);
                this.mapBounds.x = this.mapAreaBounds.x;
                this.mapBounds.width = this.mapAreaBounds.width;
                this.mapBounds.y = this.mapAreaBounds.y + (this.mapAreaBounds.height - ySize) / 2;
                this.mapBounds.height = ySize;
            } else {
                int xSize = (int)((double)this.mapAreaBounds.width * this.modelAspectRatio / this.viewAspectRatio);
                this.mapBounds.x = this.mapAreaBounds.x + (this.mapAreaBounds.width - xSize) / 2;
                this.mapBounds.width = xSize;
                this.mapBounds.y = this.mapAreaBounds.y;
                this.mapBounds.height = this.mapAreaBounds.height;
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 300);
    }

    protected void doResize(int w, int h) {
        super.doResize(w, h);
        this.clearSelectedRegions();
        this.clearSelectedMarkers();
        this.brushRect = null;
        this.brushBeginPoint = null;
        this.brushing = false;
        this.movingBrush = false;
        this.viewportRect = null;
        this.viewportBeginPoint = null;
        this.resizeRequired = true;
        this.rebuildRequired = true;
        this.redrawRequired = true;
        this.repaint();
    }

    protected void rebuildMap() {
        this.mapObject.rebuild();
    }

    protected void rebuildMarkers() {
        this.markerObject.recreateMarkers();
        this.markerObject.syncColors();
    }

    protected void resizeChart() {
        this.mapAreaBounds = this.graphLayout.getChartArea();
        this.regenerateMapBounds();
        this.mapObject.setTotalBounds(this.mapAreaBounds);
        this.mapObject.setDrawingBounds(this.mapBounds);
        this.mapObject.regeneratePolygons();
        this.markerObject.setDrawingBounds(this.mapBounds);
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.backBuffer2 != null) {
            this.backBuffer2.flush();
        }
        this.backBuffer2 = null;
        this.zoomBuffer = null;
    }

    public void mouseDragged(MouseEvent e) {
        int flags = e.getModifiers();
        if ((flags & 0x10) == 0) {
            return;
        }
        if (this.actionMode == 4) {
            this.mapBounds.x -= this.panLastPoint.x - e.getX();
            this.mapBounds.y -= this.panLastPoint.y - e.getY();
            if (this.brushRect != null) {
                this.brushRect.x -= this.panLastPoint.x - e.getX();
                this.brushRect.y -= this.panLastPoint.y - e.getY();
            }
            this.redrawRequired = true;
            this.repaint();
            this.panLastPoint = e.getPoint();
            this.transformed = true;
        } else if (this.actionMode == 1 && this.brushing) {
            if (this.movingBrush && this.brushBeginPoint != null && this.brushRect != null) {
                this.brushRect.x = this.brushRect.x - this.brushBeginPoint.x + e.getX();
                this.brushRect.y = this.brushRect.y - this.brushBeginPoint.y + e.getY();
                this.brushBeginPoint = e.getPoint();
                this.reselectRegions(this.brushRect);
                this.reselectMarkers(this.brushRect);
                this.repaint();
            } else {
                this.rbrect.stretch(e.getPoint());
            }
        } else if (this.actionMode == 2) {
            this.rbrect.stretch(e.getPoint());
        } else if (this.actionMode == 3) {
            Point p = new Point(e.getX() - this.mapBounds.x + this.panOffset.x, e.getY() - this.mapBounds.y + this.panOffset.y);
            this.zoomWindow.setOffset(p);
            this.zoomWindow.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        Point p = new Point(e.getX() - this.mapBounds.x, e.getY() - this.mapBounds.y);
        this.checkGraphs(p);
        this.tipText = this.getToolTipText(p);
        this.tipLocation = e.getPoint();
        this.checkCursor(this.tipLocation.x, this.tipLocation.y, false);
        this.repaint();
    }

    public String getToolTipText(MouseEvent e) {
        return this.getToolTipText(e.getPoint());
    }

    public void checkGraphs(Point p) {
        this.mapObject.checkGraphs(p);
    }

    public String getToolTipText(Point p) {
        String s = this.markerObject.getToolTipText(p);
        if (s == null) {
            s = this.mapObject.getToolTipText(p, 0);
        }
        if (s != null) {
            return s;
        }
        return null;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.tipText = null;
        this.tipLocation = null;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        this.tipText = null;
        int x = e.getX();
        int y = e.getY();
        int flags = e.getModifiers();
        if ((flags & 4) != 0 && this.showPopup) {
            this.getPopupMenu().show((Component)((Object)this), x, y);
        } else {
            if (this.actionMode == 4) {
                this.panLastPoint = e.getPoint();
            } else if (this.actionMode == 1) {
                if (this.brushRect == null) {
                    this.rbrect.anchor(e.getPoint());
                    this.brushing = true;
                } else if (this.brushRect.contains(e.getPoint())) {
                    this.brushBeginPoint = e.getPoint();
                    this.brushing = true;
                    this.movingBrush = true;
                    this.cursor = moveCursorClose;
                    this.setCursor(this.cursor);
                } else {
                    this.brushRect = null;
                    this.rbrect.anchor(e.getPoint());
                    this.brushing = true;
                    this.movingBrush = false;
                    this.clearSelectedRegions();
                    this.clearSelectedMarkers();
                    this.cursor = normalCursor;
                    this.setCursor(this.cursor);
                }
            } else if (this.actionMode == 2) {
                this.rbrect.anchor(e.getPoint());
            } else if (this.actionMode == 6) {
                if (!e.isControlDown()) {
                    this.clearSelectedRegions();
                    this.clearSelectedMarkers();
                }
                int i = -1;
                if (this.pickMarkers) {
                    this.markerObject.pick((double)x - (double)this.mapBounds.x, (double)y - (double)this.mapBounds.y);
                }
                if (i != -1) {
                    Object URLRole = this.roles.getVariable((Object)RoleInterface.ROLE_MARKER_URL, 0);
                    if (URLRole != null) {
                        // empty if block
                    }
                    Integer myInt = new Integer(i);
                    if (e.isControlDown()) {
                        if (this.isMarkerSelected(myInt)) {
                            this.removeSelectedMarker(myInt);
                        } else {
                            this.addSelectedMarker(myInt);
                        }
                    } else {
                        this.addSelectedMarker(myInt);
                    }
                } else {
                    if (this.pickMap) {
                        i = this.mapObject.pick((double)x - (double)this.mapBounds.x, (double)y - (double)this.mapBounds.y);
                    }
                    if (i != -1) {
                        Object URLRole = this.roles.getVariable((Object)RoleInterface.ROLE_URL, 0);
                        if (URLRole != null) {
                            String s = (String)this.mapResponseData.getValue(URLRole, (long)this.mapObject.getIndex(i));
                            this.fireDrilldownEvent(s);
                        }
                        Integer myInt = new Integer(i);
                        if (e.isControlDown()) {
                            if (this.isRegionSelected(myInt)) {
                                this.removeSelectedRegion(myInt);
                            } else {
                                this.addSelectedRegion(myInt);
                            }
                        } else {
                            this.addSelectedRegion(myInt);
                        }
                    }
                }
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        int flags = e.getModifiers();
        if (this.actionMode == 1 && this.brushing && (flags & 4) == 0) {
            if (this.movingBrush) {
                this.movingBrush = false;
                this.cursor = moveCursorOpen;
                this.setCursor(this.cursor);
            } else {
                Point p = e.getPoint();
                this.rbrect.end(p);
                this.brushRect = this.rbrect.bounds();
                if (this.brushRect.width == 0) {
                    this.brushRect.width = 1;
                }
                if (this.brushRect.height == 0) {
                    this.brushRect.height = 1;
                }
                this.reselectRegions(this.brushRect);
                this.reselectMarkers(this.brushRect);
                this.repaint();
            }
        } else if (this.actionMode == 2) {
            double scale = 1.0;
            Point p = e.getPoint();
            this.rbrect.end(p);
            this.viewportRect = this.rbrect.bounds();
            if (this.viewportRect.width <= 10 || this.viewportRect.height <= 10) {
                return;
            }
            double ar = (double)this.viewportRect.width / (double)this.viewportRect.height;
            scale = ar > this.modelAspectRatio ? (double)this.mapBounds.height / (double)this.viewportRect.height : (double)this.mapBounds.width / (double)this.viewportRect.width;
            int newHeight = (int)((double)this.mapBounds.height * scale);
            int newWidth = (int)((double)this.mapBounds.width * scale);
            Point vcenter = new Point((int)this.viewportRect.getCenterX(), (int)this.viewportRect.getCenterY());
            Point mcenter = new Point((int)this.mapAreaBounds.getCenterX(), (int)this.mapAreaBounds.getCenterY());
            double widthPerc = (double)(vcenter.x - this.mapBounds.x) / (double)this.mapBounds.width;
            double heightPerc = (double)(vcenter.y - this.mapBounds.y) / (double)this.mapBounds.height;
            this.mapBounds.x = mcenter.x - (int)(widthPerc * (double)newWidth);
            this.mapBounds.y = mcenter.y - (int)(heightPerc * (double)newHeight);
            this.mapBounds.width = newWidth;
            this.mapBounds.height = newHeight;
            this.mapObject.setDrawingBounds(this.mapBounds);
            this.mapObject.regeneratePolygons();
            this.markerObject.setDrawingBounds(this.mapBounds);
            this.redrawRequired = true;
            this.repaint();
            this.transformed = true;
        }
    }

    protected void reselectRegions(Rectangle r) {
        Rectangle newR = new Rectangle(r);
        newR.x -= this.mapBounds.x;
        newR.y -= this.mapBounds.y;
        if (this.pickMap) {
            this.mapObject.selectTouchingRegions(newR);
        }
        this.updateFilter();
    }

    protected void reselectMarkers(Rectangle r) {
        Rectangle newR = new Rectangle(r);
        newR.x -= this.mapBounds.x;
        newR.y -= this.mapBounds.y;
        if (this.pickMarkers) {
            this.markerObject.pick(newR);
        }
        this.updateMarkerFilter();
    }

    protected WKBMultiPolygon createNewMultiPolygon() {
        WKBMultiPolygon mp = new WKBMultiPolygon();
        mp.num_wkbPolygons = 0L;
        mp.WKBPolygons = null;
        return mp;
    }

    protected void addAPolygon(WKBMultiPolygon mp, Vector xVector, Vector yVector) {
        WKBPolygon poly = new WKBPolygon();
        poly.numRings = 1L;
        poly.rings = new LinearRing[1];
        poly.rings[0] = new LinearRing();
        poly.rings[0].points = new Vec3d[xVector.size()];
        poly.rings[0].numPoints = xVector.size();
        for (int j = 0; j < xVector.size(); ++j) {
            poly.rings[0].points[j] = new Vec3d(((Double)xVector.elementAt(j)).doubleValue(), ((Double)yVector.elementAt(j)).doubleValue(), 0.0);
        }
        WKBPolygon[] polyArray = new WKBPolygon[(int)mp.num_wkbPolygons + 1];
        int i = 0;
        while ((long)i < mp.num_wkbPolygons) {
            polyArray[i] = mp.WKBPolygons[i];
            ++i;
        }
        polyArray[(int)mp.num_wkbPolygons] = poly;
        mp.WKBPolygons = polyArray;
        ++mp.num_wkbPolygons;
    }

    protected void addARing(WKBPolygon poly, Vector xVector, Vector yVector) {
        LinearRing ring = new LinearRing();
        ring.numPoints = xVector.size();
        for (int j = 0; j < xVector.size(); ++j) {
            ring.points[j] = new Vec3d(((Double)xVector.elementAt(j)).doubleValue(), ((Double)yVector.elementAt(j)).doubleValue(), 0.0);
        }
        LinearRing[] ringArray = new LinearRing[(int)poly.numRings + 1];
        int i = 0;
        while ((long)i < poly.numRings) {
            ringArray[i] = poly.rings[i];
            ++i;
        }
        ringArray[(int)poly.numRings] = ring;
        poly.rings = ringArray;
        ++poly.numRings;
    }

    protected void readMapData() {
        Object spatial = this.roles.getVariable((Object)RoleInterface.ROLE_SPATIAL, 0);
        Object xRole = this.roles.getVariable((Object)RoleInterface.ROLE_X, 0);
        Object yRole = this.roles.getVariable((Object)RoleInterface.ROLE_Y, 0);
        Object segmentRole = this.roles.getVariable((Object)RoleInterface.ROLE_SEGMENT, 0);
        Object mapIDRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_ID, 0);
        Vector<WKBMultiPolygon> polyVector = new Vector<WKBMultiPolygon>();
        Vector<Double> idVector = new Vector<Double>();
        Vector<Double> xVector = new Vector<Double>();
        Vector<Double> yVector = new Vector<Double>();
        Double currentID = null;
        Double currentSegment = null;
        boolean inside = false;
        WKBMultiPolygon currentMultiPolygon = null;
        if (xRole != null && yRole != null && mapIDRole != null && segmentRole != null) {
            int numObs = this.spatialData.getNumberObservations(xRole);
            for (int i = 0; i < numObs; ++i) {
                Double x = (Double)this.spatialData.getValue(xRole, (long)i);
                Double y = (Double)this.spatialData.getValue(yRole, (long)i);
                Double id = (Double)this.spatialData.getValue(mapIDRole, (long)i);
                Double segment = (Double)this.spatialData.getValue(segmentRole, (long)i);
                if (i == 0) {
                    currentID = id;
                    currentSegment = segment;
                    currentMultiPolygon = this.createNewMultiPolygon();
                }
                if (!id.equals(currentID)) {
                    if (inside) {
                        this.addARing(currentMultiPolygon.WKBPolygons[(int)currentMultiPolygon.num_wkbPolygons - 1], xVector, yVector);
                    } else {
                        this.addAPolygon(currentMultiPolygon, xVector, yVector);
                    }
                    polyVector.add(currentMultiPolygon);
                    idVector.add(currentID);
                    currentMultiPolygon = this.createNewMultiPolygon();
                    xVector.clear();
                    yVector.clear();
                    currentID = id;
                    currentSegment = segment;
                    inside = false;
                } else if (!segment.equals(currentSegment)) {
                    if (inside) {
                        this.addARing(currentMultiPolygon.WKBPolygons[(int)currentMultiPolygon.num_wkbPolygons - 1], xVector, yVector);
                    } else {
                        this.addAPolygon(currentMultiPolygon, xVector, yVector);
                    }
                    inside = false;
                    currentSegment = segment;
                }
                if (this.spatialData.isMissing(xRole, (Object)x)) {
                    inside = true;
                    continue;
                }
                xVector.add(x);
                yVector.add(y);
            }
            if (inside) {
                this.addARing(currentMultiPolygon.WKBPolygons[(int)currentMultiPolygon.num_wkbPolygons - 1], xVector, yVector);
            } else {
                this.addAPolygon(currentMultiPolygon, xVector, yVector);
            }
            polyVector.add(currentMultiPolygon);
            idVector.add(currentID);
            WKBMultiPolygon[] polygons = new WKBMultiPolygon[polyVector.size()];
            for (int i = 0; i < polygons.length; ++i) {
                polygons[i] = (WKBMultiPolygon)polyVector.elementAt(i);
            }
            this.mapObject.setMultiPolygons(polygons);
            this.mapObject.setMapIDVector(idVector);
            this.calculateBounds(polygons);
        } else if (spatial != null) {
            if (this.spatialData.getVariableClass(spatial) == String.class) {
                this.blobReader.setData(this.spatialData, spatial);
                this.mapObject.setMultiPolygons(this.blobReader.multiPolygons);
                this.xMin = this.blobReader.xMin;
                this.xMax = this.blobReader.xMax;
                this.yMin = this.blobReader.yMin;
                this.yMax = this.blobReader.yMax;
            } else {
                WKBMultiPolygon[] polygons = new WKBMultiPolygon[this.spatialData.getNumberObservations(spatial)];
                for (int i = 0; i < polygons.length; ++i) {
                    polygons[i] = (WKBMultiPolygon)this.spatialData.getValue(spatial, (long)i);
                }
                this.mapObject.setMultiPolygons(polygons);
                this.calculateBounds(polygons);
            }
        }
        this.mapObject.setExtents(this.xMin, this.xMax, this.yMin, this.yMax);
        this.markerObject.setExtents(this.xMin, this.xMax, this.yMin, this.yMax);
        this.modelAspectRatio = (this.xMax - this.xMin) / (this.yMax - this.yMin);
    }

    private void calculateBounds(WKBMultiPolygon[] polygons) {
        this.yMin = Double.MAX_VALUE;
        this.xMin = Double.MAX_VALUE;
        this.yMax = -1.7976931348623157E308;
        this.xMax = -1.7976931348623157E308;
        for (int i = 0; i < polygons.length; ++i) {
            int j = 0;
            while ((long)j < polygons[i].num_wkbPolygons) {
                int k = 0;
                while ((long)k < polygons[i].WKBPolygons[j].numRings) {
                    int l = 0;
                    while ((long)l < polygons[i].WKBPolygons[j].rings[k].numPoints) {
                        this.xMin = Math.min(this.xMin, polygons[i].WKBPolygons[j].rings[k].points[l].x);
                        this.xMax = Math.max(this.xMax, polygons[i].WKBPolygons[j].rings[k].points[l].x);
                        this.yMin = Math.min(this.yMin, polygons[i].WKBPolygons[j].rings[k].points[l].y);
                        this.yMax = Math.max(this.yMax, polygons[i].WKBPolygons[j].rings[k].points[l].y);
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
        }
    }

    public boolean setMarkerDataSource(Object source) {
        DataFilterReadInterface filter = null;
        if (source == null) {
            return false;
        }
        filter = FilterFactory.getDataSourceFilter((Object)source);
        if (filter == null) {
            return false;
        }
        if (this.dataListen) {
            this.setupListeners(this.markerData, filter);
        }
        this.markerData = filter;
        this.roles.setDataset((Object)"marker", (Object)this.markerData);
        this.markerObject.setData(this.markerData);
        this.redrawRequired = true;
        this.repaint();
        if (this.zoomWindow != null) {
            this.zoomWindow.repaint();
        }
        return true;
    }

    public boolean setSpatialDataSource(Object source) {
        DataFilterReadInterface filter = null;
        if (source == null) {
            return false;
        }
        filter = FilterFactory.getDataSourceFilter((Object)source);
        if (filter == null) {
            return false;
        }
        if (this.dataListen) {
            this.setupListeners(this.spatialData, filter);
        }
        this.spatialData = filter;
        this.roles.setDataset((Object)"map", (Object)this.spatialData);
        this.mapObject.setSpatialData(this.spatialData);
        this.redrawRequired = true;
        this.resizeRequired = true;
        this.rebuildRequired = true;
        this.repaint();
        if (this.zoomWindow != null) {
            this.zoomWindow.repaint();
        }
        return true;
    }

    public boolean setResponseDataSource(Object source) {
        DataFilterReadInterface filter = null;
        if (source == null) {
            return false;
        }
        filter = FilterFactory.getDataSourceFilter((Object)source);
        if (filter == null) {
            return false;
        }
        if (this.dataListen) {
            this.setupListeners(this.mapResponseData, filter);
        }
        this.mapResponseData = filter;
        this.roles.setDataset((Object)"response", (Object)this.mapResponseData);
        this.mapObject.setMapResponseData(this.mapResponseData);
        this.resizeRequired = true;
        this.rebuildRequired = true;
        this.redrawRequired = true;
        this.repaint();
        if (this.zoomWindow != null) {
            this.zoomWindow.repaint();
        }
        return true;
    }

    public Object[] getDataIds() {
        Object[] s = new String[]{ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Map.txt", (String)"Map"), ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Response.txt", (String)"Response"), ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Marker.txt", (String)"Marker")};
        return s;
    }

    public boolean setDataSource(Object source) {
        return false;
    }

    public Object getDataSource() {
        return null;
    }

    public Object getDataSource(Object dataId) {
        String s = (String)dataId;
        if (s.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Map.txt", (String)"Map"))) {
            return this.spatialData;
        }
        if (s.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Response.txt", (String)"Response"))) {
            return this.mapResponseData;
        }
        if (s.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Marker.txt", (String)"Marker"))) {
            return this.markerData;
        }
        return this.mapResponseData;
    }

    public boolean setDataSource(Object dataId, Object source) {
        String s = (String)dataId;
        if (s.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Map.txt", (String)"Map"))) {
            return this.setSpatialDataSource(source);
        }
        if (s.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Response.txt", (String)"Response"))) {
            return this.setResponseDataSource(source);
        }
        if (s.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Marker.txt", (String)"Marker"))) {
            return this.setMarkerDataSource(source);
        }
        this.createDataDialog(this);
        return true;
    }

    public Object getRole(Object variableId) {
        return super.getRole(variableId);
    }

    private String getRolePrefix(Object role) {
        if (role instanceof String) {
            String s = (String)role;
            if (s.equalsIgnoreCase("SPATIAL") || s.equalsIgnoreCase("MAP_ID") || s.equalsIgnoreCase("X") || s.equalsIgnoreCase("Y") || s.equalsIgnoreCase("SEGMENT")) {
                return "map.";
            }
            if (s.equalsIgnoreCase("MAP_LEVEL") || s.equalsIgnoreCase("MAP_RESPONSE_ID") || s.equalsIgnoreCase("MAP_COLOR") || s.equalsIgnoreCase("MAP_COLOR_INDEX") || s.equalsIgnoreCase("WATERMARK") || s.equalsIgnoreCase("MAP_LABEL") || s.equalsIgnoreCase("MAP_OPACITY") || s.equalsIgnoreCase("MAP_TRANSPARENCY") || s.equalsIgnoreCase("TIP") || s.equalsIgnoreCase("GRAPH_VAR") || s.equalsIgnoreCase("URL")) {
                return "response.";
            }
            if (s.equalsIgnoreCase("MARKER_X") || s.equalsIgnoreCase("MARKER_Y") || s.equalsIgnoreCase("MARKER_COLOR") || s.equalsIgnoreCase("MARKERCOLORINDEX") || s.equalsIgnoreCase("MARKER_SIZE") || s.equalsIgnoreCase("MARKER_LEVEL") || s.equalsIgnoreCase("MARKER_TIP") || s.equalsIgnoreCase("MARKER_URL")) {
                return "marker.";
            }
        } else {
            if (role.equals(ROLE_SPATIAL) || role.equals(ROLE_MAP_ID) || role.equals(ROLE_X) || role.equals(ROLE_Y) || role.equals(ROLE_SEGMENT)) {
                return "map.";
            }
            if (role.equals(ROLE_MAP_LEVEL) || role.equals(ROLE_MAP_RESPONSE_ID) || role.equals(ROLE_MAP_COLOR) || role.equals(ROLE_MAP_COLOR_INDEX) || role.equals(ROLE_WATERMARK) || role.equals(ROLE_MAP_LABEL) || role.equals(ROLE_MAP_OPACITY) || role.equals(ROLE_MAP_TRANSPARENCY) || role.equals(ROLE_TIP) || role.equals(ROLE_GRAPH_VAR) || role.equals(ROLE_URL)) {
                return "response.";
            }
            if (role.equals(ROLE_MARKER_X) || role.equals(ROLE_MARKER_Y) || role.equals(ROLE_MARKER_COLOR) || role.equals(ROLE_MARKER_COLOR_INDEX) || role.equals(ROLE_MARKER_SIZE) || role.equals(ROLE_MARKER_LEVEL) || role.equals(ROLE_MARKER_URL)) {
                return "marker.";
            }
        }
        return null;
    }

    public boolean setRole(Object variableId, Object role) {
        boolean rc;
        if (variableId instanceof String && ((String)variableId).indexOf(".") == -1) {
            variableId = this.getRolePrefix(role) + ((String)variableId).toString();
        }
        if (!(rc = super.setRole(variableId, role))) {
            return rc;
        }
        if (role instanceof String && role.toString().equalsIgnoreCase("SPATIAL") || role.equals(ROLE_SPATIAL)) {
            this.readMapData();
        }
        if (role instanceof String && role.toString().equalsIgnoreCase("X") || role.equals(ROLE_X)) {
            this.readMapData();
        }
        if (role instanceof String && role.toString().equalsIgnoreCase("Y") || role.equals(ROLE_Y)) {
            this.readMapData();
        }
        if (role instanceof String && role.toString().equalsIgnoreCase("SEGMENT") || role.equals(ROLE_SEGMENT)) {
            this.readMapData();
        }
        if (role instanceof String && role.toString().equalsIgnoreCase("MAP_ID") || role.equals(ROLE_MAP_ID)) {
            this.readMapData();
        }
        if (role instanceof String && role.toString().equalsIgnoreCase("MAPLEVEL") || role.equals(ROLE_MAP_LEVEL)) {
            this.setShowZoomWindow(true);
        }
        if (role instanceof String && role.toString().equalsIgnoreCase("GRAPHVAR") || role.equals(ROLE_GRAPH_VAR)) {
            // empty if block
        }
        if (role instanceof String && role.toString().equalsIgnoreCase("MAP_COLOR") || role.equals(ROLE_MAP_COLOR)) {
            Object mapColor = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR, 0);
            this.legend.setTitle((Object)this.mapResponseData.getVariableDescription(mapColor).toString());
        }
        if (role instanceof String && role.toString().equalsIgnoreCase("MARKER_COLOR") || role.equals(ROLE_MARKER_COLOR)) {
            Object markerColor = this.roles.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR, 0);
            this.markerLegend.setTitle((Object)this.markerData.getVariableDescription(markerColor).toString());
        }
        this.rolesChanged();
        return rc;
    }

    public boolean addRole(Object variableId, Object role) {
        if (variableId instanceof String && ((String)variableId).indexOf(".") == -1) {
            variableId = this.getRolePrefix(role) + ((String)variableId).toString();
        }
        boolean rc = super.addRole(variableId, role);
        if (role.toString().equalsIgnoreCase("SPATIAL")) {
            this.readMapData();
        }
        this.rolesChanged();
        return rc;
    }

    public boolean removeRole(Object variableId, Object role) {
        if (variableId instanceof String && ((String)variableId).indexOf(".") == -1) {
            variableId = this.getRolePrefix(role) + ((String)variableId).toString();
        }
        boolean rc = super.removeRole(variableId, role);
        this.rolesChanged();
        return rc;
    }

    public Categorization getMapCategorization() {
        return this.mapObject.getCategorization();
    }

    public Categorization getMarkerCategorization() {
        return this.markerObject.getCategorization();
    }

    public void rolesChanged() {
        this.mapObject.rolesChanged();
        this.markerObject.rolesChanged();
        this.resizeRequired = true;
        this.rebuildRequired = true;
        this.redrawRequired = true;
        this.repaint();
    }

    public boolean isDiscrete(Object variableId) {
        return false;
    }

    public boolean setDiscrete(Object variableId, boolean discrete) {
        return false;
    }

    public Object[] getSupportedRoles(Object dataId, boolean b) {
        String s = (String)dataId;
        if (s == null || s.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Map.txt", (String)"Map"))) {
            return this.getSupportedSpatialRoles(b);
        }
        if (s.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Response.txt", (String)"Response"))) {
            return this.getSupportedMapResponseRoles(b);
        }
        if (s.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Marker.txt", (String)"Marker"))) {
            return this.getSupportedMarkerRoles(b);
        }
        return null;
    }

    private Object[] getSupportedSpatialRoles(boolean b) {
        return new Object[]{this.spatialRole, this.mapIDRole, this.xRole, this.yRole, this.segmentRole};
    }

    private Object[] getSupportedMapResponseRoles(boolean b) {
        if (!b) {
            return new Object[]{this.mapLevelRole, this.mapWatermarkRole, this.mapOpacityRole, this.mapTransparencyRole, this.graphVarRole};
        }
        return new Object[]{this.mapResponseIDRole, this.mapColorRole, this.mapLevelRole, this.mapLabelRole, this.mapWatermarkRole, this.mapOpacityRole, this.mapTransparencyRole, this.mapTipRole, this.graphVarRole};
    }

    private Object[] getSupportedMarkerRoles(boolean b) {
        if (!b) {
            return new Object[]{this.markerXRole, this.markerYRole, this.markerSizeRole, this.markerLevelRole};
        }
        return new Object[]{this.markerColorRole, this.markerXRole, this.markerYRole, this.markerSizeRole, this.markerLevelRole};
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.type == 3) {
            this.rebuildRequired = true;
            this.resizeRequired = true;
        }
        if (evt.type == 2) {
            if (evt.source == this.mapResponseData) {
                int[] arr = (int[])evt.oldValue;
                if (arr == null) {
                    this.mapObject.clearSelectedRegions();
                    this.repaint();
                    return;
                }
                Object mapResponseIDRole = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_RESPONSE_ID, 0);
                for (int i = 0; i < arr.length; ++i) {
                    Object o = this.mapResponseData.getValue(mapResponseIDRole, (long)arr[i]);
                    boolean b = this.mapResponseData.isSelected((long)arr[i]);
                    int index = this.mapObject.getMapRegionWithID(o);
                    if (index == -1) continue;
                    if (b) {
                        this.mapObject.addSelectedRegion(new Integer(index));
                        continue;
                    }
                    this.mapObject.removeSelectedRegion(new Integer(index));
                }
            } else if (evt.source == this.markerData) {
                int[] arr = (int[])evt.oldValue;
                if (arr == null) {
                    this.markerObject.clearSelectedMarkers();
                    this.repaint();
                    return;
                }
                for (int i = 0; i < arr.length; ++i) {
                    boolean b = this.markerData.isSelected((long)arr[i]);
                    if (b) {
                        this.markerObject.addSelectedMarker(new Integer(arr[i]));
                        continue;
                    }
                    this.markerObject.removeSelectedMarker(new Integer(arr[i]));
                }
            }
        } else if (!evt.isAdjusting) {
            this.redrawRequired = true;
        }
        this.repaint();
    }

    private void addSelectedRegion(Integer i) {
        this.mapObject.addSelectedRegion(i);
        this.updateFilter();
    }

    private void removeSelectedRegion(Integer i) {
        this.mapObject.removeSelectedRegion(i);
        this.updateFilter();
    }

    private void clearSelectedRegions() {
        this.mapObject.clearSelectedRegions();
        if (this.mapResponseData != null) {
            this.mapResponseData.removeDataFilterListener((Object)this);
            this.mapResponseData.unselectAll();
            this.mapResponseData.addDataFilterListener((Object)this);
        }
    }

    private boolean isRegionSelected(Integer i) {
        return this.mapObject.isRegionSelected(i);
    }

    private void updateFilter() {
        ArrayList selectedRegions = this.mapObject.getSelectedRegions();
        if (this.mapResponseData == null) {
            return;
        }
        this.mapResponseData.removeDataFilterListener((Object)this);
        this.mapResponseData.unselectAll();
        int numMissing = 0;
        for (int j = 0; j < selectedRegions.size(); ++j) {
            if ((Integer)selectedRegions.get(j) != -1) continue;
            ++numMissing;
        }
        int[] ia = new int[selectedRegions.size() - numMissing];
        int index = 0;
        for (int j = 0; j < selectedRegions.size(); ++j) {
            int foo = (Integer)selectedRegions.get(j);
            if (foo == -1) continue;
            ia[index++] = foo;
        }
        this.mapResponseData.setSelected((Object)ia, true);
        this.mapResponseData.addDataFilterListener((Object)this);
    }

    private void addSelectedMarker(Integer i) {
        this.markerObject.addSelectedMarker(i);
        this.updateMarkerFilter();
    }

    private void removeSelectedMarker(Integer i) {
        this.markerObject.removeSelectedMarker(i);
        this.updateMarkerFilter();
    }

    private void clearSelectedMarkers() {
        this.markerObject.clearSelectedMarkers();
        if (this.markerData != null) {
            this.markerData.removeDataFilterListener((Object)this);
            this.markerData.unselectAll();
            this.markerData.addDataFilterListener((Object)this);
        }
    }

    private boolean isMarkerSelected(Integer i) {
        return this.markerObject.isMarkerSelected(i);
    }

    private void updateMarkerFilter() {
        if (this.markerObject == null || this.markerData == null) {
            return;
        }
        ArrayList selectedMarkers = this.markerObject.getSelectedMarkers();
        this.markerData.removeDataFilterListener((Object)this);
        this.markerData.unselectAll();
        int[] ia = new int[selectedMarkers.size()];
        for (int j = 0; j < ia.length; ++j) {
            ia[j] = (Integer)selectedMarkers.get(j);
        }
        this.markerData.setSelected((Object)ia, true);
        this.markerData.addDataFilterListener((Object)this);
    }

    public ColorSchemeInterface getColorScheme() {
        return new ColorScheme(this.style);
    }

    public String getColorSchemeName() {
        return this.style.getSchemeName();
    }

    public boolean setStyle(Object newStyle) {
        super.setStyle(newStyle);
        if (this.legend != null) {
            this.legend.applyStyle(this.style);
        }
        if (this.markerLegend != null) {
            this.markerLegend.applyStyle(this.style);
        }
        if (this.mapObject != null) {
            this.mapObject.setStyle(this.style);
            this.mapObject.syncMapColors();
            this.mapObject.setSelectionColor(this.style.getFillStyleElement("Selection").getFillColor());
        }
        if (this.markerObject != null) {
            this.markerObject.setColorScheme((ColorSchemeInterface)new ColorScheme(this.style));
            this.markerObject.syncColors();
            this.markerObject.setSelectionColor(this.style.getFillStyleElement("Selection").getFillColor());
        }
        this.redrawRequired = true;
        this.rebuildRequired = true;
        this.repaint();
        if (this.zoomWindow != null) {
            this.zoomWindow.repaint();
        }
        return true;
    }

    public boolean isPropertySupported(int id) {
        return false;
    }

    public boolean isPropertyPending(int id) {
        return this.pending.containsKey(new Integer(id));
    }

    public Object getPropertyValue(int id) {
        Object rc = null;
        if (this.currentLegend == "map" && this.legend.isPropertySupported(id)) {
            return this.legend.getPropertyValue(id);
        }
        if (this.currentLegend == "marker" && this.legend.isPropertySupported(id)) {
            return this.markerLegend.getPropertyValue(id);
        }
        switch (id) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                rc = this.background.getPropertyValue(id);
                break;
            }
            case 37: {
                rc = new Boolean(this.useSimpleMarkers);
                break;
            }
            case 0: {
                rc = this.getColorScheme();
                break;
            }
            case 23: {
                if (this.currentLegend == "marker") {
                    rc = ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Marker.txt", (String)"Marker");
                    break;
                }
                if (this.currentLegend != "map") break;
                rc = ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Map.txt", (String)"Map");
                break;
            }
            case 24: {
                String[] s;
                rc = s = new String[]{"map", "marker"};
                break;
            }
            case 25: {
                String[] displayNames = new String[]{ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Map.txt", (String)"Map"), ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Marker.txt", (String)"Marker")};
                rc = displayNames;
                break;
            }
            case 30: {
                rc = this.imageList;
                break;
            }
            case 28: {
                rc = new Boolean(this.imageList != null);
                break;
            }
            case 2: {
                rc = new Boolean(this.chartTipsOn);
                break;
            }
            case 7018: {
                rc = this.getMarkerShapeList();
                break;
            }
            case 7008: {
                rc = this.markerObject.getMarkerType();
                break;
            }
            case 7015: {
                rc = new Boolean(this.roles.getNumVariablesAssigned((Object)RoleInterface.ROLE_LABEL) > 0);
                break;
            }
            case 7016: {
                rc = new Boolean(this.markerXRole != null && this.markerYRole != null);
                break;
            }
            case 7007: {
                rc = new Boolean(this.showMarkers);
                break;
            }
            case 7023: {
                rc = new Boolean(this.mapObject.isShowGraphs());
                break;
            }
            case 7024: {
                rc = new Boolean(this.mapObject.isShowNonExplodedGraphs());
                break;
            }
            case 7025: {
                rc = this.mapObject.getGraphType();
                break;
            }
            case 7029: {
                rc = new Boolean(this.mapObject.isUseColorRamp());
                break;
            }
            case 7034: {
                rc = new Boolean(this.useSecondBackBuffer);
                break;
            }
            case 7031: {
                rc = new Boolean(this.mapObject.isColorGraphsByChart());
                break;
            }
            case 7026: {
                rc = new Boolean(this.mapObject.isExplodeGraphs());
                break;
            }
            case 7027: {
                rc = new Integer((int)this.mapObject.getMinGraphPercent());
                break;
            }
            case 7028: {
                rc = new Integer((int)this.mapObject.getMaxGraphPercent());
                break;
            }
            case 7017: {
                rc = new Boolean(this.showZoomWindow);
                break;
            }
            case 7001: {
                rc = new Boolean(this.mapObject.isShowOutlines());
                break;
            }
            case 7003: {
                rc = new Integer(this.mapObject.getOutlineWidth());
                break;
            }
            case 7002: {
                rc = this.mapObject.getOutlineColor();
                break;
            }
            case 7013: {
                rc = this.mapObject.getDefaultColor();
                break;
            }
            case 7014: {
                rc = this.markerObject.getDefaultColor();
                break;
            }
            case 7032: {
                Object mapColor = this.roles.getVariable((Object)RoleInterface.ROLE_MAP_COLOR, 0);
                rc = new Boolean(this.mapResponseData != null && this.mapResponseData.isNumericVariable(mapColor));
                break;
            }
            case 7033: {
                Object markerColor = this.roles.getVariable((Object)RoleInterface.ROLE_MARKER_COLOR, 0);
                rc = new Boolean(this.markerData != null && this.markerData.isNumericVariable(markerColor));
                break;
            }
            case 7004: {
                rc = new Boolean(this.isShowLabels());
                break;
            }
            case 7005: {
                rc = this.mapObject.getText();
                break;
            }
            case 7006: {
                rc = this.mapObject.getCategorization();
                break;
            }
            case 7009: {
                rc = this.markerObject.getCategorization();
                break;
            }
            case 7010: {
                rc = new Integer((int)(this.markerObject.getMinSize() * 100.0));
                break;
            }
            case 7011: {
                rc = new Integer((int)(this.markerObject.getMaxSize() * 100.0));
                break;
            }
            case 7030: {
                rc = new Boolean(this.markerObject.isUseColorRamp());
                break;
            }
            case 7012: {
                rc = new Boolean(this.showShadows);
                break;
            }
            case 7019: {
                rc = new Boolean(this.pickMap);
                break;
            }
            case 7020: {
                rc = new Boolean(this.pickMarkers);
                break;
            }
            case 7021: {
                rc = new Boolean(this.markerObject.getLinkMarkers());
                break;
            }
            case 7022: {
                rc = this.markerObject.getLinkColor();
                break;
            }
            case 7035: {
                rc = new Boolean(this.mapObject.isDrawAllRegions());
                break;
            }
            case 601: {
                rc = this.graphLayout.getTitle().getTitle(0);
                break;
            }
            case 602: {
                rc = this.graphLayout.getTitle().getTitle(1);
                break;
            }
            case 603: {
                rc = this.graphLayout.getFootnote().getFootnote(0);
            }
        }
        return rc;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.background != null && this.background.isPropertySupported(id)) {
            this.background.setPropertyValue(id, value);
        } else if (this.legend != null && this.legend.isPropertySupported(id) && this.currentLegend == "map") {
            this.legend.setPropertyValue(id, value);
        } else if (this.markerLegend != null && this.markerLegend.isPropertySupported(id) && this.currentLegend == "marker") {
            this.markerLegend.setPropertyValue(id, value);
        } else {
            switch (id) {
                case 23: {
                    this.currentLegend = (String)value;
                    break;
                }
                case 36: {
                    this.appletContext = ((Applet)value).getAppletContext();
                }
                default: {
                    this.pending.put(new Integer(id), value);
                }
            }
        }
        return true;
    }

    public int getNumberPendingProperties() {
        return this.pending.size();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equalsIgnoreCase("MapProperties")) {
            this.getPropertiesDialog().setVisible(true);
        } else if (s.equalsIgnoreCase("DataOptions")) {
            this.createDataDialog(this);
            this.dataDlg.setVisible(true);
        } else if (s.equalsIgnoreCase("Toolbar")) {
            this.getToolBar().setVisible(true);
        } else if (s.equalsIgnoreCase("ZoomWindow")) {
            this.zoomWindow.setVisible(true);
        } else if (s.equalsIgnoreCase("Copy")) {
            CopyToClipboard.toClipboard((JComponent)((Object)this));
        }
    }

    public boolean applyPropertyChanges() {
        boolean rebuildMap = false;
        boolean rebuildMarkers = false;
        boolean resizeChart = false;
        this.background.applyPropertyChanges();
        if (this.legend.getNumberPendingProperties() > 0) {
            this.legend.applyPropertyChanges();
            rebuildMap = true;
            rebuildMarkers = true;
            resizeChart = true;
        }
        if (this.markerLegend.getNumberPendingProperties() > 0) {
            this.markerLegend.applyPropertyChanges();
            rebuildMap = true;
            rebuildMarkers = true;
            resizeChart = true;
        }
        Enumeration keys = this.pending.keys();
        Enumeration values = this.pending.elements();
        while (keys.hasMoreElements()) {
            Integer i = (Integer)keys.nextElement();
            int key = i;
            Object value = values.nextElement();
            switch (key) {
                case 37: {
                    if (value == null || !(value instanceof Boolean)) break;
                    this.useSimpleMarkers = (Boolean)value;
                    rebuildMarkers = true;
                    break;
                }
                case 0: {
                    this.setColorScheme(value);
                    rebuildMap = true;
                    rebuildMarkers = true;
                    resizeChart = true;
                    break;
                }
                case 29: {
                    this.setStyle(value);
                    rebuildMap = true;
                    rebuildMarkers = true;
                    resizeChart = true;
                    break;
                }
                case 30: {
                    if (!(value instanceof ImageListInterface)) break;
                    this.setImageList((ImageListInterface)value);
                    break;
                }
                case 2: {
                    if (!(value instanceof Boolean)) break;
                    this.chartTipsOn = (Boolean)value;
                    break;
                }
                case 7008: {
                    if (!(value instanceof String)) break;
                    this.markerObject.setMarkerType((String)value);
                    break;
                }
                case 7007: {
                    if (value instanceof Boolean) {
                        this.showMarkers = (Boolean)value;
                    }
                    rebuildMarkers = true;
                    break;
                }
                case 7023: {
                    if (!(value instanceof Boolean)) break;
                    this.mapObject.setShowGraphs((Boolean)value);
                    break;
                }
                case 7030: {
                    if (value instanceof Boolean) {
                        this.markerObject.setUseColorRamp((Boolean)value);
                    }
                    rebuildMarkers = true;
                    resizeChart = true;
                    break;
                }
                case 7034: {
                    if (value instanceof Boolean) {
                        this.useSecondBackBuffer = (Boolean)value;
                    }
                    this.repaint();
                    break;
                }
                case 7035: {
                    if (value instanceof Boolean) {
                        this.mapObject.setDrawAllRegions((Boolean)value);
                    }
                    this.repaint();
                    break;
                }
                case 7029: {
                    if (value instanceof Boolean) {
                        this.mapObject.setUseColorRamp((Boolean)value);
                    }
                    rebuildMap = true;
                    resizeChart = true;
                    break;
                }
                case 7031: {
                    if (!(value instanceof Boolean)) break;
                    this.mapObject.setColorGraphsByChart((Boolean)value);
                    break;
                }
                case 7024: {
                    if (!(value instanceof Boolean)) break;
                    this.mapObject.setShowNonExplodedGraphs((Boolean)value);
                    break;
                }
                case 7025: {
                    if (!(value instanceof String)) break;
                    this.mapObject.setGraphType((String)value);
                    break;
                }
                case 7027: {
                    if (!(value instanceof Integer)) break;
                    this.mapObject.setMinGraphPercent(((Integer)value).doubleValue());
                    break;
                }
                case 7028: {
                    if (!(value instanceof Integer)) break;
                    this.mapObject.setMaxGraphPercent(((Integer)value).doubleValue());
                    break;
                }
                case 7026: {
                    if (!(value instanceof Boolean)) break;
                    this.mapObject.setExplodeGraphs((Boolean)value);
                    break;
                }
                case 7020: {
                    if (!(value instanceof Boolean)) break;
                    this.pickMarkers = (Boolean)value;
                    break;
                }
                case 7019: {
                    if (!(value instanceof Boolean)) break;
                    this.pickMap = (Boolean)value;
                    break;
                }
                case 7021: {
                    if (!(value instanceof Boolean)) break;
                    this.markerObject.setLinkMarkers((Boolean)value);
                    break;
                }
                case 7022: {
                    if (!(value instanceof Color)) break;
                    this.markerObject.setLinkColor((Color)value);
                    break;
                }
                case 7017: {
                    if (!(value instanceof Boolean)) break;
                    this.setShowZoomWindow((Boolean)value);
                    break;
                }
                case 7001: {
                    if (!(value instanceof Boolean)) break;
                    this.mapObject.setShowOutlines((Boolean)value);
                    break;
                }
                case 7003: {
                    if (!(value instanceof Integer)) break;
                    this.mapObject.setOutlineWidth((Integer)value);
                    break;
                }
                case 7002: {
                    if (!(value instanceof Color)) break;
                    this.mapObject.setOutlineColor((Color)value);
                    break;
                }
                case 7013: {
                    if (!(value instanceof Color)) break;
                    this.mapObject.setDefaultColor((Color)value);
                    break;
                }
                case 7014: {
                    if (value instanceof Color) {
                        this.markerObject.setDefaultColor((Color)value);
                    }
                    rebuildMarkers = true;
                    break;
                }
                case 7004: {
                    if (!(value instanceof Boolean)) break;
                    this.setShowLabels((Boolean)value);
                    break;
                }
                case 7005: {
                    if (!(value instanceof Text)) break;
                    this.mapObject.setText((Text)value);
                    break;
                }
                case 7006: {
                    if (value instanceof Categorization) {
                        this.mapObject.setCategorization((Categorization)value);
                    }
                    rebuildMap = true;
                    resizeChart = true;
                    break;
                }
                case 7009: {
                    if (value instanceof Categorization) {
                        this.markerObject.setCategorization((Categorization)value);
                    }
                    rebuildMarkers = true;
                    resizeChart = true;
                    break;
                }
                case 7010: {
                    if (value instanceof Integer) {
                        this.markerObject.setMinSize(((Integer)value).doubleValue() / 100.0);
                    }
                    rebuildMarkers = true;
                    break;
                }
                case 7011: {
                    if (value instanceof Integer) {
                        this.markerObject.setMaxSize(((Integer)value).doubleValue() / 100.0);
                    }
                    rebuildMarkers = true;
                    break;
                }
                case 7012: {
                    if (!(value instanceof Boolean)) break;
                    this.setShowShadows((Boolean)value);
                    break;
                }
                case 443: {
                    resizeChart = true;
                    break;
                }
                case 420: {
                    resizeChart = true;
                    break;
                }
                case 604: {
                    if (value instanceof String) {
                        this.setTitle(0, (String)value);
                    } else if (value instanceof TextStyleInterface) {
                        this.setTitle(0, (TextStyleInterface)value);
                    }
                    resizeChart = true;
                    break;
                }
                case 605: {
                    if (value instanceof String) {
                        this.setTitle(1, (String)value);
                    } else if (value instanceof TextStyleInterface) {
                        this.setTitle(1, (TextStyleInterface)value);
                    }
                    resizeChart = true;
                    break;
                }
                case 606: {
                    if (value instanceof String) {
                        this.setFootnote(0, (String)value);
                    } else if (value instanceof TextStyleInterface) {
                        this.setFootnote(0, (TextStyleInterface)value);
                    }
                    resizeChart = true;
                }
            }
        }
        if (rebuildMap || rebuildMarkers) {
            this.rebuildRequired = true;
        }
        if (resizeChart) {
            this.resizeRequired = true;
        }
        this.redrawRequired = true;
        this.pending = new Hashtable();
        this.repaint();
        if (this.zoomWindow != null) {
            this.zoomWindow.repaint();
        }
        return true;
    }

    public void cancelPropertyChanges() {
        this.pending = new Hashtable();
    }

    public int[] getPendingChanges() {
        return null;
    }

    public int[] getPendingChanges(Object source) {
        return null;
    }

    public void cancelPropertyChanges(Object source) {
    }

    public boolean applyPropertyChanges(Object source) {
        return false;
    }

    public boolean isShowZoomWindow() {
        return this.showZoomWindow;
    }

    public void setShowZoomWindow(boolean showZoomWindow) {
        this.showZoomWindow = showZoomWindow;
        if (showZoomWindow && !this.zoomAdded) {
            JMenuItem item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Zoom_Window.txt", (String)"Zoom Window..."));
            this.getPopupMenu().add(item);
            item.setMnemonic(90);
            item.setActionCommand("ZoomWindow");
            item.addActionListener(this);
            this.zoomAdded = true;
        }
        if (this.toolbar != null) {
            ((SILKToolbar)this.toolbar).setButtonEnabled(3, showZoomWindow);
        }
        this.redrawRequired = true;
        this.repaint();
    }

    public void setMapColorCategorization(Categorization c) {
        if (this.mapObject != null) {
            this.mapObject.setCategorization(c);
        }
    }

    public void setMarkerColorCategorization(Categorization c) {
        if (this.markerObject != null) {
            this.markerObject.setCategorization(c);
        }
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public boolean isShowShadows() {
        return this.showShadows;
    }

    public void setShowShadows(boolean showShadows) {
        this.showShadows = showShadows;
        this.mapObject.setShadowsOn(showShadows);
        this.markerObject.setShadowsOn(showShadows);
    }

    public void textUpdated(DvrTextEvent evt) {
        Object o = evt.source;
        if (o != this.mapObject.getText()) {
            // empty if block
        }
        this.redrawRequired = true;
        this.repaint();
    }

    public boolean isShowToolbar() {
        return this.showToolbar;
    }

    public void setShowToolbar(boolean showToolbar) {
        this.showToolbar = showToolbar;
    }

    public Component getToolBar() {
        if (this.toolbar == null) {
            this.toolbar = new SILKToolbar((Frame)this.parent);
            ((SILKToolbar)this.toolbar).setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Map_Toolbar.txt", (String)"Map Toolbar"));
            if (!this.showZoomWindow) {
                ((SILKToolbar)this.toolbar).setButtonEnabled(3, false);
            }
            ((SILKToolbar)this.toolbar).addListener((GraphInterface)this);
        }
        return this.toolbar;
    }

    public boolean setToolBar(Component toolBarIn) {
        if (toolBarIn == null) {
            JPopupMenu menu = this.getPopupMenu();
            int count = menu.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component c = menu.getComponent(i);
                if (!(c instanceof JMenuItem) || !((JMenuItem)c).getActionCommand().equalsIgnoreCase("Toolbar")) continue;
                menu.remove(c);
                break;
            }
        }
        this.toolbar = toolBarIn;
        boolean bl = this.showToolbar = this.toolbar == null;
        if (this.toolbar != null && this.toolbar instanceof GraphToolbarInterface) {
            ((GraphToolbarInterface)this.toolbar).addListener((GraphInterface)this);
        }
        return true;
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            JMenuItem item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Map_Properties.txt", (String)"Map Properties..."));
            item.setMnemonic(77);
            item.addActionListener(this);
            item.setActionCommand("MapProperties");
            this.menu.add(item);
            item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Data_Options.txt", (String)"Data Options..."));
            item.addActionListener(this);
            item.setMnemonic(68);
            item.setActionCommand("DataOptions");
            this.menu.add(item);
            if (this.showToolbar) {
                item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Toolbar.txt", (String)"Toolbar..."));
                this.menu.add(item);
                item.setMnemonic(84);
                item.setActionCommand("Toolbar");
                item.addActionListener(this);
            }
            if (this.showZoomWindow) {
                item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Zoom_Window.txt", (String)"Zoom Window..."));
                this.menu.add(item);
                item.setMnemonic(90);
                item.addActionListener(this);
                item.setActionCommand("ZoomWindow");
                this.zoomAdded = true;
            }
            this.menu.addSeparator();
            item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Copy.txt", (String)"Copy"));
            item.addActionListener(this);
            item.setActionCommand("Copy");
            this.menu.add(item);
        }
        return this.menu;
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        if (this.mapResponseData == null) {
            return false;
        }
        return this.mapResponseData.applyWhereClause(clause, clearPrevious);
    }

    public boolean areChartTipsOn() {
        return this.chartTipsOn;
    }

    public void dispose() {
    }

    public void enablePopup(boolean on) {
        this.showPopup = on;
    }

    public int getActionMode() {
        return this.actionMode;
    }

    public AxisInterface getAxis(Object which) {
        return null;
    }

    public TipInterface getChartTip() {
        return this.tip;
    }

    public Dialog getDialog(Object id, Object id2) {
        return null;
    }

    public DataFilterReadInterface getFilter() {
        return this.mapResponseData;
    }

    public LegendInterface getLegend(Object which) {
        if (which instanceof String) {
            String s = (String)which;
            if (s.equals("marker") || s.equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Marker.txt", (String)"Marker"))) {
                return this.markerLegend;
            }
            return this.legend;
        }
        return null;
    }

    public Rectangle getLegendBounds() {
        return null;
    }

    public Object getLegendPosition(Object which) {
        return null;
    }

    public String getWhereClause() {
        if (this.mapResponseData == null) {
            return null;
        }
        return this.mapResponseData.getWhereClause();
    }

    public boolean isDataListening() {
        return false;
    }

    public boolean setActionMode(int mode) {
        switch (mode) {
            case 5: {
                this.transformed = false;
                this.clearSelectedRegions();
                this.clearSelectedMarkers();
                this.brushRect = null;
                this.brushBeginPoint = null;
                this.brushing = false;
                this.panOffset = new Point();
                this.panLastPoint = new Point();
                this.resizeRequired = true;
                this.rebuildRequired = true;
                this.redrawRequired = true;
                this.repaint();
                return true;
            }
            case 6: {
                this.brushRect = null;
                this.brushBeginPoint = null;
                this.brushing = false;
                this.actionMode = 6;
                this.cursor = normalCursor;
                this.setCursor(this.cursor);
                this.brushRect = null;
                this.repaint();
                break;
            }
            case 1: {
                this.actionMode = 1;
                this.cursor = normalCursor;
                this.setCursor(this.cursor);
                this.repaint();
                break;
            }
            case 2: {
                this.actionMode = 2;
                this.cursor = normalCursor;
                this.setCursor(this.cursor);
                this.brushRect = null;
                this.repaint();
                break;
            }
            case 3: {
                this.actionMode = 3;
                this.cursor = zoomCursor;
                this.setCursor(this.cursor);
                this.brushRect = null;
                this.repaint();
                break;
            }
            case 4: {
                this.actionMode = 4;
                this.cursor = panCursor;
                this.setCursor(this.cursor);
                this.brushRect = null;
                this.repaint();
                break;
            }
            default: {
                return false;
            }
        }
        this.actionMode = mode;
        return true;
    }

    public void setChartTipsOn(boolean on) {
        this.chartTipsOn = on;
    }

    public boolean setDataListening(boolean listen) {
        return false;
    }

    public boolean setDialog(Object id, Dialog dialogIn, boolean b) {
        return false;
    }

    public boolean setLegendBounds(Rectangle rect) {
        return false;
    }

    public boolean setLegendPosition(Object which, Object positionIn) {
        return false;
    }

    private String[] getMarkerShapeList() {
        String[] s = new String[]{ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Circle.txt", (String)"Circle"), ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Cross.txt", (String)"Cross"), ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Diamond.txt", (String)"Diamond"), ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Plus.txt", (String)"Plus"), ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Square.txt", (String)"Square"), ResourceLoader.getResourceString((Object)this.rb, (String)"MapComponent.Star.txt", (String)"Star")};
        return s;
    }

    public synchronized void addURLConsumer(Object context, URLConsumerInterface consumer) {
        if (this.mapObject != null) {
            this.mapObject.addURLConsumer(context, consumer);
        }
        if (this.markerObject != null) {
            this.markerObject.addURLConsumer(context, consumer);
        }
    }

    public synchronized void removeURLConsumer(URLConsumerInterface consumer) {
        if (this.mapObject != null) {
            this.mapObject.removeURLConsumer(consumer);
        }
        if (this.markerObject != null) {
            this.markerObject.removeURLConsumer(consumer);
        }
    }

    public Object getAllVariables(Object role) {
        return null;
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }
}

