/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.dendrogram.DendrogramChart;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.heatmap.HeatmapChart;
import com.sas.graphics.silk.heatmap.HeatmapModel;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.GraphPropertyInterface;
import com.sas.graphics.silk.interfaces.GraphToolbarInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PrintInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.interfaces.ViewportInterface;
import com.sas.graphics.silk.ui.AxisPanel;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.HeatmapChartPanel;
import com.sas.graphics.silk.ui.HeatmapColorPanel;
import com.sas.graphics.silk.ui.LegendPanel;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.LegendObject;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.ViewportWarningIcon;
import com.sas.graphics.util.PropertyEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class HeatmapComponent
extends SILKComponent
implements UpdateInterface,
TransformInterface,
PrintInterface,
Printable,
RedrawListener,
TextListenerInterface,
CellItemInterface,
DataRangeInterface,
PropertyInterface,
GraphPropertyInterface,
ViewportInterface,
ViewportListenerInterface {
    private static final long serialVersionUID = -3051491754119114369L;
    protected static final int BORDER = 5;
    protected static final int MIN_WIDTH = 1;
    protected static final int MIN_HEIGHT = 1;
    protected static final int ERROR_DATA = 1;
    protected static final int ERROR_SPACE = 2;
    protected static final int NONE = 0;
    protected static final int MOVE = 1;
    protected static final int RESIZE_L = 2;
    protected static final int RESIZE_R = 3;
    protected static final int RESIZE_T = 4;
    protected static final int RESIZE_B = 5;
    protected static final int RESIZE_TL = 6;
    protected static final int RESIZE_TR = 7;
    protected static final int RESIZE_BL = 8;
    protected static final int RESIZE_BR = 9;
    protected static final int MIN_SIZE = 4;
    protected static final int HANDLE_SIZE = 6;
    protected static final int DIRECTION_X = 1;
    protected static final int DIRECTION_Y = 2;
    protected static final int DIRECTION_XY = 3;
    protected static final double HEATMAP_FRACTION_X = 0.85;
    protected static final double HEATMAP_FRACTION_Y = 0.8;
    protected static final int TREE_Y = 0;
    protected static final int TREE_X = 1;
    protected static final int NUM_TREES = 2;
    public static final Integer HEATMAP = new Integer(1);
    public static final Integer DENDROGRAM_X = new Integer(2);
    public static final Integer DENDROGRAM_Y = new Integer(3);
    protected int viewportX = 0;
    protected int viewportY = 0;
    protected int viewportWidth;
    protected int viewportHeight;
    protected Rectangle chartClipRect;
    protected double[] chartBBox = null;
    protected double dataXMin;
    protected double dataXMax;
    protected double dataYMin;
    protected double dataYMax;
    protected Insets chartOuterMargin;
    protected Insets compMargin;
    protected Insets chartMargin;
    protected Insets chartInnerMargin = null;
    protected boolean userSetOuterMargin = false;
    protected Image backBuffer = null;
    protected Image backBuffer2 = null;
    protected Image backImage = null;
    protected HeatmapChart chart = null;
    protected Axes xAxis = null;
    protected Axes yAxis = null;
    protected LegendObjectJ2D legend = null;
    protected Rectangle legendBounds = null;
    protected boolean wallOn = true;
    protected GraphBackground wall;
    protected Rectangle rubberband = null;
    protected Color brushColor;
    protected Point startPt;
    protected boolean rectSelection = false;
    protected double zoomFactor = 1.0;
    protected int error = 0;
    protected boolean brushMode = false;
    protected int brushAction;
    protected Rectangle2D.Double resizeL;
    protected Rectangle2D.Double resizeR;
    protected Rectangle2D.Double resizeT;
    protected Rectangle2D.Double resizeB;
    protected Rectangle2D.Double resizeTL;
    protected Rectangle2D.Double resizeTR;
    protected Rectangle2D.Double resizeBL;
    protected Rectangle2D.Double resizeBR;
    protected boolean redrawBKBuffer = true;
    protected boolean updateComp = true;
    protected boolean mouseAction = false;
    protected Cursor openMoveCursor;
    protected Cursor closeMoveCursor;
    protected Image openMoveImage;
    protected Image closeMoveImage;
    protected JPopupMenu popup;
    protected boolean addPanels;
    protected Action tBar;
    protected boolean userSetToolbar;
    protected ArrayList marginListeners;
    protected ArrayList rangeListeners;
    protected boolean updatePanels;
    protected ArrayList propertyIndex;
    protected ArrayList propertyValue;
    protected int selectedAxis;
    protected boolean applyingChanges;
    protected boolean hScrollbarOn;
    protected boolean vScrollbarOn;
    protected double viewportXMin;
    protected double viewportXMax;
    protected double viewportYMin;
    protected double viewportYMax;
    protected HeatmapComponent instance = null;
    protected int vBarRightMargin;
    protected boolean sbarAreaTooSmall;
    protected ArrayList viewportListeners;
    protected Graphics gc;
    protected HeatmapColorPanel heatmapColorPanel = null;
    protected AxisZoomPanHandler xHandler;
    protected AxisZoomPanHandler yHandler;
    protected ViewportWarningIcon warningIcon = null;
    protected boolean mouseOnXAxis;
    protected boolean mouseOnYAxis;
    protected boolean mouseOnHeightX;
    protected boolean mouseOnHeightY;
    protected DendrogramChart[] tree;
    protected boolean[] treeOn;
    protected Object dataId;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
    public static int[] supportedProperties = new int[]{26, 0, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 32, 33, 34, 23, 443, 402, 604, 605, 606, 607, 608, 601, 609, 610, 602, 611, 612, 603, 238};

    public HeatmapComponent() {
        this.viewportWidth = this.compWidth;
        this.viewportHeight = this.compHeight;
        this.chartClipRect = new Rectangle(this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
        this.chartOuterMargin = new Insets(0, 0, 0, 0);
        this.compMargin = new Insets(0, 0, 0, 0);
        this.chartMargin = new Insets(0, 0, 0, 0);
        this.brushColor = Color.black;
        this.wall = new GraphBackground((JComponent)((Object)this));
        this.openMoveImage = ResourceLoader.getImage((Component)((Object)this), (String)"icons/MoveOpen.gif");
        this.closeMoveImage = ResourceLoader.getImage((Component)((Object)this), (String)"icons/MoveClosed.gif");
        this.setDoubleBuffered(false);
        this.popup = null;
        this.addPanels = false;
        this.userSetToolbar = false;
        this.actionMode = 1;
        this.marginListeners = new ArrayList();
        this.rangeListeners = new ArrayList();
        this.propertyIndex = new ArrayList();
        this.propertyValue = new ArrayList();
        this.selectedAxis = 0;
        this.updatePanels = false;
        this.applyingChanges = false;
        this.viewportListeners = new ArrayList();
        this.hScrollbarOn = false;
        this.vScrollbarOn = false;
        this.instance = this;
        this.tree = new DendrogramChart[2];
        this.treeOn = new boolean[2];
        this.setStyle(SILKGlobal.getInstance().getPropertyValue(29));
        this.userSetProperties.appendProperties(supportedProperties);
        this.warningIcon = new ViewportWarningIcon((Component)((Object)this));
    }

    protected void buildPropertiesDialog(Object listner) {
        if (this.propertiesDialog != null) {
            return;
        }
        this.getPropertyDialog();
    }

    protected GraphPropertiesDialog getPropertyDialog() {
        this.createPropertyDialog(this);
        this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapComponent.Graph.txt", (String)"Graph"), (Component)new GraphPanel((PropertyInterface)this, (PropertyInterface)this.tooltip));
        this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapComponent.Chart.txt", (String)"Chart"), (Component)new HeatmapChartPanel(this.chart));
        if (this.getChart().getHeatmapModel().isNumericResponse()) {
            this.heatmapColorPanel = new HeatmapColorPanel(this.chart);
            this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapComponent.Color.txt", (String)"Color"), (Component)this.heatmapColorPanel);
        }
        this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapComponent.Axis.txt", (String)"Axis"), (Component)new AxisPanel((PropertyInterface)this.getAxis(HeatmapModel.X_ROLE_NAME), (PropertyInterface)this.getAxis(HeatmapModel.Y_ROLE_NAME)));
        this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapComponent.Legend.txt", (String)"Legend"), (Component)new LegendPanel((PropertyInterface)this));
        this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapComponent.TitleFootnote.txt", (String)"Title/Footnote"), (Component)new TitlePanel((PropertyInterface)this, (JComponent)((Object)this)));
        this.propertiesDialog.setSelectedNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapComponent.Chart.txt", (String)"Chart"));
        this.propertiesDialog.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapComponent.HeatmapPropertiesDialogTitle.txt", (String)"Heatmap Properties"));
        this.addPanels = true;
        return this.propertiesDialog;
    }

    public void printComponent() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf = job.pageDialog(job.defaultPage());
        job.setPrintable(this, pf);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected Insets getComponentMargin() {
        this.graphLayout.doLayout((JComponent)((Object)this));
        Rectangle chartArea = this.graphLayout.getChartArea();
        Insets margin = new Insets(this.yMargin + chartArea.y, this.xMargin + chartArea.x, this.yMargin + this.compHeight - chartArea.y - chartArea.height, this.xMargin + this.compWidth - chartArea.x - chartArea.width);
        return margin;
    }

    protected void updateMaximumLegendSize(Rectangle rect) {
        if (this.legend == null || this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        int position = ((Number)this.getLegendPosition(null)).intValue();
        int w = 0;
        int h = 0;
        if (this.legendBounds != null) {
            w = this.legendBounds.width;
            h = this.legendBounds.height;
        } else if (position == 2 || position == 1) {
            w = rect == null ? this.viewportWidth - 10 : rect.width;
            h = (int)(0.2 * (double)this.viewportHeight);
        } else if (position == 3 || position == 4) {
            w = (int)(0.2 * (double)this.viewportWidth);
            h = rect == null ? this.viewportHeight - this.getTitleHeight() - this.getFootnoteHeight() - 10 : rect.height;
        }
        this.legend.setMaximumSize(w, h);
    }

    protected int getTitleHeight() {
        int h = 0;
        if (this.graphLayout.getTitle() != null) {
            Rectangle r = this.graphLayout.getTitle().getBounds();
            h = r.height;
        }
        return h;
    }

    protected int getFootnoteHeight() {
        int h = 0;
        if (this.graphLayout.getFootnote() != null) {
            Rectangle r = this.graphLayout.getFootnote().getBounds();
            h += r.height;
        }
        return h;
    }

    protected void setColorsToChart() {
        if (this.chart == null) {
            return;
        }
        this.chart.setOutlineColor(this.style.getLineStyleElement("Outlines").getLineColor());
        this.chart.setSelectionColor(this.style.getFillStyleElement("Selection").getFillColor());
        this.chart.setChartBorderColor(this.style.getLineStyleElement("BorderLines").getLineColor());
        this.chart.setStyle(this.style);
    }

    protected void setColorsToAxis(Axes axis) {
        if (axis == null) {
            return;
        }
        axis.applyStyle(this.style);
    }

    protected void setColorsToLegend() {
        if (this.legend == null) {
            return;
        }
        this.legend.applyStyle(this.style);
    }

    protected void updateChartOuterMargin() {
        this.chartMargin = this.chart.getOuterMargin((Graphics2D)this.gc);
        this.compMargin = this.getComponentMargin();
        this.chartOuterMargin.top = this.compMargin.top + this.chartMargin.top;
        this.chartOuterMargin.bottom = this.compMargin.bottom + this.chartMargin.bottom;
        this.chartOuterMargin.left = this.compMargin.left + this.chartMargin.left;
        this.chartOuterMargin.right = this.compMargin.right + this.chartMargin.right;
    }

    protected boolean updateChartClipArea() {
        boolean imce;
        int w = this.viewportWidth - this.chartOuterMargin.left - this.chartOuterMargin.right;
        int h = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom;
        int xo = this.viewportX + this.chartOuterMargin.left;
        int yo = this.viewportY + this.chartOuterMargin.top;
        this.error = w < 1 || h < 1 ? (this.error |= 2) : (this.error &= 0xFFFFFFFD);
        Rectangle newRect = new Rectangle(xo, yo, w, h);
        if (this.chart.isCellEquated()) {
            Rectangle rectSav = new Rectangle(newRect);
            this.chart.adjustChartArea(newRect);
            if (newRect.width != rectSav.width) {
                this.chartOuterMargin.left = (int)((double)this.chartOuterMargin.left + 0.5 * (double)(rectSav.width - newRect.width));
                this.chartOuterMargin.right = (int)((double)this.chartOuterMargin.right + 0.5 * (double)(rectSav.width - newRect.width));
            }
            if (newRect.height != rectSav.height) {
                this.chartOuterMargin.top = (int)((double)this.chartOuterMargin.top + 0.5 * (double)(rectSav.height - newRect.height));
                this.chartOuterMargin.bottom = (int)((double)this.chartOuterMargin.bottom + 0.5 * (double)(rectSav.height - newRect.height));
            }
        }
        boolean omce = !this.chartClipRect.equals(newRect);
        boolean bl = imce = this.chartClipRect.width != newRect.width || this.chartClipRect.height != newRect.height;
        if (imce) {
            this.chartInnerMargin = null;
        }
        if (this.brushMode && this.rubberband != null) {
            double wRatio = (double)newRect.width / (double)this.chartClipRect.width;
            double hRatio = (double)newRect.height / (double)this.chartClipRect.height;
            this.rubberband.x = (int)((double)newRect.x + (double)(this.rubberband.x - this.chartClipRect.x) * wRatio);
            this.rubberband.y = (int)((double)newRect.y + (double)(this.rubberband.y - this.chartClipRect.y) * hRatio);
            this.rubberband.width = (int)((double)this.rubberband.width * wRatio);
            this.rubberband.height = (int)((double)this.rubberband.height * hRatio);
            this.createHandleRects();
        }
        this.chartClipRect.setRect(newRect);
        boolean newBounding = this.chart.setChartClipArea(this.chartClipRect);
        this.chartBBox = this.chart.getBoundingBox();
        if (this.chartBBox == null) {
            return false;
        }
        if (this.xAxis != null) {
            this.xAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
        if (this.yAxis != null) {
            this.yAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
        this.updateMaximumLegendSize(this.chartClipRect);
        if (newBounding) {
            this.viewportXMin = this.chartBBox[0];
            this.viewportYMin = this.chartBBox[1];
            this.viewportXMax = this.chartBBox[3];
            this.viewportYMax = this.chartBBox[4];
            this.fireViewportChangeEvent();
        }
        if (this.isTreeOn()) {
            for (int i = 0; i < 2; ++i) {
                if (!this.treeOn[i]) continue;
                this.tree[i].setBoundingBox(this.chartBBox[0], this.chartBBox[1], this.chartBBox[2], this.chartBBox[3], this.chartBBox[4], this.chartBBox[5]);
                if (this.tree[i].getOrientation() == 0) {
                    xo = (int)((double)this.compWidth * 0.85) - this.compMargin.right;
                    yo = this.chartClipRect.y;
                    w = (int)((double)this.compWidth * 0.15000000000000002 - (double)this.xMargin);
                    h = this.chartClipRect.height;
                } else {
                    xo = this.chartClipRect.x;
                    yo = this.yMargin + this.compMargin.top;
                    w = this.chartClipRect.width;
                    h = (int)((double)this.compHeight * 0.19999999999999996 - (double)this.yMargin);
                }
                Rectangle treeClipRect = new Rectangle(xo, yo, w, h);
                this.tree[i].setChartClipArea(treeClipRect);
            }
        }
        this.fireMarginChangeEvent(imce, omce);
        return true;
    }

    private void controllYAxisTickmarks() {
        int h = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom;
        this.chart.controllYAxisTickmarks(h);
    }

    private boolean isDataAssigned() {
        if (this.getFilter() == null) {
            return false;
        }
        if (this.isHeatMapOn() && (!this.chart.getHeatmapModel().isSpreadSheetData() && (this.chart.getVariable(HeatmapModel.X_ROLE_NAME) == null || this.chart.getVariable(HeatmapModel.Y_ROLE_NAME) == null || this.chart.getVariable(HeatmapModel.RESP_ROLE_NAME) == null) || this.chart.getHeatmapModel().isSpreadSheetData() && !this.chart.getHeatmapModel().isValidSpreadSheet())) {
            return false;
        }
        if (this.isTreeOn()) {
            for (int i = 0; i < 2; ++i) {
                if (!this.treeOn[i] || this.tree[i].isDataAssigned()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isDataChanged() {
        if (this.chart.isDataChanged()) {
            return true;
        }
        if (this.isTreeOn()) {
            for (int i = 0; i < 2; ++i) {
                if (!this.treeOn[i] || !this.tree[i].isRebuildRequired()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHeatMapOn() {
        return this.chart != null && this.chart.getDataSource() != null;
    }

    protected void updateComponent() {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        if (!this.isDataAssigned()) {
            return;
        }
        Dimension d = new Dimension(this.compWidth, this.compHeight);
        if (this.isTreeOn()) {
            int i;
            for (i = 0; i < 2; ++i) {
                if (!this.treeOn[i]) continue;
                if (this.tree[i].getOrientation() == 0) {
                    d.width = (int)((double)this.compWidth * 0.85);
                    continue;
                }
                d.height = (int)((double)this.compHeight * 0.8);
            }
            for (i = 0; i < 2; ++i) {
                if (!this.treeOn[i]) continue;
                this.tree[i].setChartAreaDimension(d);
            }
        }
        this.chart.setChartAreaDimension(d);
        this.controllYAxisTickmarks();
        this.updateChartOuterMargin();
        this.updateChartClipArea();
        this.updateComp = false;
    }

    protected void doResize(int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (width == this.compWidth && height == this.compHeight) {
            return;
        }
        this.compWidth = width;
        this.compHeight = height;
        if (this.useBackBuffer) {
            if (this.backBuffer == null || width > this.backBuffer.getWidth((ImageObserver)((Object)this)) || height > this.backBuffer.getHeight((ImageObserver)((Object)this))) {
                if (this.backBuffer != null) {
                    this.backBuffer.flush();
                }
                this.backBuffer = this.createImage(width, height);
            }
            if (this.backBuffer2 == null || width > this.backBuffer2.getWidth((ImageObserver)((Object)this)) || height > this.backBuffer2.getHeight((ImageObserver)((Object)this))) {
                if (this.backBuffer2 != null) {
                    this.backBuffer2.flush();
                }
                this.backBuffer2 = this.createImage(width, height);
            }
        }
        this.viewportWidth = this.compWidth;
        this.viewportHeight = this.compHeight;
        if (this.isTreeOn()) {
            for (int i = 0; i < 2; ++i) {
                if (!this.treeOn[i]) continue;
                if (this.tree[i].getOrientation() == 0) {
                    this.viewportWidth = (int)((double)this.compWidth * 0.85);
                    continue;
                }
                this.viewportY = (int)((double)this.compHeight * 0.19999999999999996);
                this.viewportHeight = (int)((double)this.compHeight * 0.8);
            }
        }
        this.updateComp = true;
        this.redrawBKBuffer = true;
    }

    protected void paintComponent(Graphics g) {
        this.gc = g;
        if (this.applyingChanges) {
            return;
        }
        if (this.chart == null) {
            return;
        }
        if (this.useBackBuffer && (this.backBuffer == null || this.backBuffer2 == null)) {
            return;
        }
        if (this.isTreeOn()) {
            this.buildTrees();
        }
        if (this.updateComp || this.isDataChanged()) {
            this.updateComponent();
        }
        if (this.isRebuildRequired()) {
            this.build(null);
        }
        if ((this.error & 1) != 0) {
            this.drawErrorMessage(g);
            return;
        }
        if (!this.useBackBuffer || this.redrawBKBuffer) {
            this.drawToBackBuffer(g);
        }
        if (!this.useBackBuffer) {
            return;
        }
        if (this.isHighlightRequired() || this.brushMode && this.rubberband != null) {
            Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
            backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, (ImageObserver)((Object)this));
            if (this.chart.isHighlightRequired()) {
                backGraphics2.setClip(this.chartClipRect.x + 1, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height + 1);
                this.chart.drawHighlight(backGraphics2);
                backGraphics2.setClip(0, 0, this.compWidth, this.compHeight);
            }
            if (this.brushMode && this.rubberband != null) {
                backGraphics2.setColor(this.brushColor);
                backGraphics2.draw(this.rubberband);
            }
            if (this.isTreeOn()) {
                for (int i = 0; i < 2; ++i) {
                    if (!this.treeOn[i] || !this.tree[i].isHighlightRequired()) continue;
                    Rectangle treeClipRect = this.tree[i].getChartClipArea();
                    backGraphics2.setClip(treeClipRect.x, treeClipRect.y, treeClipRect.width + 1, treeClipRect.height + 1);
                    this.tree[i].drawHighlight(backGraphics2);
                    backGraphics2.setClip(0, 0, this.compWidth, this.compHeight);
                }
            }
            g.drawImage(this.backBuffer2, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, (ImageObserver)((Object)this));
            backGraphics2.dispose();
        } else {
            g.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, (ImageObserver)((Object)this));
        }
        if (this.mouseOnXAxis) {
            this.xHandler.drawZoomPanIndicator(g);
        } else if (this.mouseOnYAxis) {
            this.yHandler.drawZoomPanIndicator(g);
        } else if (this.mouseOnHeightX) {
            this.tree[1].getHeightHandler().drawZoomPanIndicator(g);
        } else if (this.mouseOnHeightY) {
            this.tree[0].getHeightHandler().drawZoomPanIndicator(g);
        }
        this.xHandler.drawViewportIndicator(g);
        this.yHandler.drawViewportIndicator(g);
        if (this.tree[1] != null && this.tree[1].getHeightHandler() != null) {
            this.tree[1].getHeightHandler().drawViewportIndicator(g);
        }
        if (this.tree[0] != null && this.tree[0].getHeightHandler() != null) {
            this.tree[0].getHeightHandler().drawViewportIndicator(g);
        }
        this.warningIcon.draw(g);
    }

    private boolean isHighlightRequired() {
        if (this.chart.isHighlightRequired()) {
            return true;
        }
        if (this.isTreeOn()) {
            for (int i = 0; i < 2; ++i) {
                if (!this.treeOn[i] || !this.tree[i].isHighlightRequired()) continue;
                return true;
            }
        }
        return false;
    }

    public String getToolTipText(MouseEvent e) {
        int y;
        String toolTipText = null;
        int x = e.getX();
        if (this.warningIcon.isMouseOverIcon(x, y = e.getY())) {
            return this.warningIcon.getTooltipText();
        }
        if (toolTipText == null && this.xAxis != null) {
            toolTipText = this.xAxis.getToolTipText(x, y);
        }
        if (toolTipText == null && this.yAxis != null) {
            toolTipText = this.yAxis.getToolTipText(x, y);
        }
        if (toolTipText == null && this.chartClipRect.contains(x, y) && this.chart != null) {
            toolTipText = this.chart.getToolTipText(x, y);
        }
        if (this.isTreeOn()) {
            for (int i = 0; i < 2; ++i) {
                if (!this.treeOn[i] || this.tree[i].getChartClipArea() == null || !this.tree[i].getChartClipArea().contains(x, y)) continue;
                toolTipText = this.tree[i].getToolTipText(x, y);
                break;
            }
        }
        return toolTipText;
    }

    protected boolean createChartElements(Object source) {
        if (this.chart == null) {
            this.chart = new HeatmapChart();
        }
        if (this.chart != null) {
            this.chart.setDataSource(this.dataFilter);
            this.chart.setTransformObject(this);
            this.chart.addRedrawListener(this);
            this.chart.setMarginListener(this.marginListeners, this);
            this.setColorsToChart();
        }
        if (this.xAxis == null) {
            this.xAxis = this.createAxis(source);
            this.xAxis.setTransformObject((Object)this);
            this.xHandler = new AxisZoomPanHandler(this.xAxis);
            this.warningIcon.addZoomPanHandler(this.xHandler);
            this.xHandler.addViewportListener((Object)this);
            this.addViewportListener(this.xHandler);
        }
        if (this.yAxis == null) {
            this.yAxis = this.createAxis(source);
            this.yAxis.setTransformObject((Object)this);
            this.yHandler = new AxisZoomPanHandler(this.yAxis);
            this.warningIcon.addZoomPanHandler(this.yHandler);
            this.yHandler.addViewportListener((Object)this);
            this.addViewportListener(this.yHandler);
        }
        if (this.legend == null) {
            this.legend = new LegendObjectJ2D();
            this.legend.setPosition(2);
            this.legend.setVisible(true);
            this.graphLayout.addLegend((LegendInterface)this.legend);
            this.setColorsToLegend();
        }
        if (this.chart != null) {
            this.chart.setXAxis(this.xAxis);
            this.chart.setYAxis(this.yAxis);
            this.chart.setLegend((LegendObject)this.legend);
        }
        return true;
    }

    protected Axes createAxis(Object source) {
        Axes axis = new Axes(source);
        axis.setReverseEnabled(false);
        axis.setTransformObject((Object)this);
        axis.addRedrawListener((RedrawListener)this);
        this.setColorsToAxis(axis);
        return axis;
    }

    protected void buildOtherElements(Object buildData) {
        if (this.updatePanels) {
            if (this.propertiesDialog != null) {
                // empty if block
            }
            this.updatePanels = false;
        }
    }

    protected void drawErrorMessage(Graphics g) {
        if (g == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String errorMessage = "";
        if ((this.error & 1) != 0) {
            errorMessage = ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapComponent.DataNotAssigned.txt", (String)"Data is not assigned correctly.");
        } else if ((this.error & 2) != 0) {
            errorMessage = ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapComponent.GraphAreaSmall.txt", (String)"Graph area is too small.");
        }
        Font f = TabbedPropertiesDialog.dialogFont;
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout errorString = new TextLayout(errorMessage, f, frc);
        Rectangle2D bounds = errorString.getBounds();
        g2.setColor(Color.red);
        errorString.draw(g2, 0.0f, (float)bounds.getHeight());
    }

    protected void drawZeroObservation(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Font f = this.xAxis.getLabel().getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        String msg = ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapComponent.NoData.txt", (String)"No Data");
        TextLayout msgString = new TextLayout(msg, f, frc);
        Rectangle2D bounds = msgString.getBounds();
        double x = this.chartClipRect.getX() + (this.chartClipRect.getWidth() - bounds.getWidth()) * 0.5;
        double y = this.chartClipRect.getY() + this.chartClipRect.getHeight() * 0.5;
        msgString.draw(g2, (float)x, (float)y);
    }

    protected void drawToBackBuffer(Graphics g) {
        Graphics2D g2 = !this.useBackBuffer ? (Graphics2D)g : (Graphics2D)this.backBuffer.getGraphics();
        this.background.drawBackground(g2, (Component)((Object)this), new Rectangle(0, 0, this.compWidth, this.compHeight));
        if (this.error == 0) {
            if (this.wall != null && this.wallOn) {
                this.wall.drawBackground(g2, (Component)((Object)this), this.chartClipRect);
            }
            if (this.chart != null) {
                g2.setClip(this.chartClipRect.x + 1, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height + 1);
                this.chart.draw(g2, !this.useBackBuffer);
                g2.setClip(0, 0, this.compWidth, this.compHeight);
            }
            if (this.xAxis != null) {
                this.xAxis.draw((Object)g2, false);
            }
            if (this.yAxis != null) {
                this.yAxis.draw((Object)g2, false);
            }
        }
        this.graphLayout.draw((Graphics)g2);
        if (this.isTreeOn()) {
            for (int i = 0; i < 2; ++i) {
                if (this.treeOn[i] && this.tree[i].getHeightAxis() != null) {
                    this.tree[i].getHeightAxis().draw((Object)g2, false);
                }
                if (!this.treeOn[i]) continue;
                Rectangle treeClipRect = this.tree[i].getChartClipArea();
                g2.setClip(treeClipRect.x, treeClipRect.y, treeClipRect.width + 1, treeClipRect.height + 1);
                this.tree[i].draw(g2, !this.useBackBuffer);
                g2.setClip(0, 0, this.compWidth, this.compHeight);
            }
        }
        if (this.dataFilter.getNumberObservations(-1) <= 0) {
            this.drawZeroObservation(g2);
        }
        if (!this.useBackBuffer) {
            return;
        }
        Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
        backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, (ImageObserver)((Object)this));
        g2.dispose();
        backGraphics2.dispose();
        this.redrawBKBuffer = false;
    }

    protected void brushing(Point pt) {
        int chartClipX = this.chartClipRect.x;
        int chartClipY = this.chartClipRect.y;
        int chartClipWidth = this.chartClipRect.width;
        int chartClipHeight = this.chartClipRect.height;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        switch (this.brushAction) {
            case 1: {
                x = this.rubberband.x + (pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, chartClipX + chartClipWidth - this.rubberband.width);
                y = this.rubberband.y + (pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, chartClipY + chartClipHeight - this.rubberband.height);
                width = this.rubberband.width;
                height = this.rubberband.height;
                break;
            }
            case 2: {
                x = this.rubberband.x + (pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4);
                y = this.rubberband.y;
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height;
                break;
            }
            case 3: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width + (pt.x - this.startPt.x);
                width = Math.max(width, 4);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height;
                break;
            }
            case 4: {
                x = this.rubberband.x;
                y = this.rubberband.y + (pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4);
                width = this.rubberband.width;
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 5: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width;
                height = this.rubberband.height + (pt.y - this.startPt.y);
                height = Math.max(height, 4);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            case 6: {
                x = this.rubberband.x + (pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4);
                y = this.rubberband.y + (pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4);
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 7: {
                x = this.rubberband.x;
                y = this.rubberband.y + (pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4);
                width = this.rubberband.width + (pt.x - this.startPt.x);
                width = Math.max(width, 4);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 8: {
                x = this.rubberband.x + (pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4);
                y = this.rubberband.y;
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height + (pt.y - this.startPt.y);
                height = Math.max(height, 4);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            case 9: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width + (pt.x - this.startPt.x);
                width = Math.max(width, 4);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height + (pt.y - this.startPt.y);
                height = Math.max(height, 4);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            default: {
                return;
            }
        }
        this.rubberband.x = x;
        this.rubberband.y = y;
        this.rubberband.width = width;
        this.rubberband.height = height;
        this.chart.setSelection(this.rubberband, false);
        this.startPt = pt;
        this.repaint();
    }

    protected void setCursorShape(int action, boolean down) {
        switch (action) {
            case 2: {
                this.setCursor(new Cursor(10));
                break;
            }
            case 3: {
                this.setCursor(new Cursor(11));
                break;
            }
            case 4: {
                this.setCursor(new Cursor(8));
                break;
            }
            case 5: {
                this.setCursor(new Cursor(9));
                break;
            }
            case 6: {
                this.setCursor(new Cursor(6));
                break;
            }
            case 7: {
                this.setCursor(new Cursor(7));
                break;
            }
            case 8: {
                this.setCursor(new Cursor(4));
                break;
            }
            case 9: {
                this.setCursor(new Cursor(5));
                break;
            }
            case 1: {
                Toolkit tk = Toolkit.getDefaultToolkit();
                if (down) {
                    this.setCursor(tk.createCustomCursor(this.closeMoveImage, new Point(6, 2), "icons/MoveClosed.gif"));
                    break;
                }
                this.setCursor(tk.createCustomCursor(this.openMoveImage, new Point(6, 2), "icons/MoveOpen.gif"));
                break;
            }
            default: {
                this.setCursor(new Cursor(0));
            }
        }
    }

    protected int getMouseSpot(Point pt) {
        int spot = 0;
        if (this.resizeL.contains(pt)) {
            spot = 2;
        } else if (this.resizeR.contains(pt)) {
            spot = 3;
        }
        if (spot == 0) {
            if (this.resizeT.contains(pt)) {
                spot = 4;
            } else if (this.resizeB.contains(pt)) {
                spot = 5;
            } else if (this.resizeTL.contains(pt)) {
                spot = 6;
            } else if (this.resizeTR.contains(pt)) {
                spot = 7;
            } else if (this.resizeBL.contains(pt)) {
                spot = 8;
            } else if (this.resizeBR.contains(pt)) {
                spot = 9;
            }
        }
        if (spot == 0 && this.rubberband.contains(pt)) {
            spot = 1;
        }
        return spot;
    }

    protected void createHandleRects() {
        if ((double)this.rubberband.width > 24.0 && (double)this.rubberband.height > 24.0) {
            this.resizeL = new Rectangle2D.Double((double)this.rubberband.x - 3.0, (double)this.rubberband.y + 0.5 * (double)this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeR = new Rectangle2D.Double((double)(this.rubberband.x + this.rubberband.width) - 3.0, (double)this.rubberband.y + 0.5 * (double)this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeT = new Rectangle2D.Double((double)this.rubberband.x + (double)this.rubberband.width * 0.5 - 3.0, (double)this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeB = new Rectangle2D.Double((double)this.rubberband.x + (double)this.rubberband.width * 0.5 - 3.0, (double)(this.rubberband.y + this.rubberband.height) - 3.0, 6.0, 6.0);
            this.resizeTL = new Rectangle2D.Double((double)this.rubberband.x - 3.0, (double)this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeTR = new Rectangle2D.Double((double)(this.rubberband.x + this.rubberband.width) - 3.0, (double)this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeBL = new Rectangle2D.Double((double)this.rubberband.x - 3.0, (double)(this.rubberband.y + this.rubberband.height) - 3.0, 6.0, 6.0);
            this.resizeBR = new Rectangle2D.Double((double)(this.rubberband.x + this.rubberband.width) - 3.0, (double)(this.rubberband.y + this.rubberband.height) - 3.0, 6.0, 6.0);
        } else {
            this.resizeL = new Rectangle2D.Double(this.rubberband.x - 6, (double)this.rubberband.y + 0.5 * (double)this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, (double)this.rubberband.y + 0.5 * (double)this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeT = new Rectangle2D.Double((double)this.rubberband.x + (double)this.rubberband.width * 0.5 - 3.0, this.rubberband.y - 6, 6.0, 6.0);
            this.resizeB = new Rectangle2D.Double((double)this.rubberband.x + (double)this.rubberband.width * 0.5 - 3.0, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
            this.resizeTL = new Rectangle2D.Double(this.rubberband.x - 6, this.rubberband.y - 6, 6.0, 6.0);
            this.resizeTR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y - 6, 6.0, 6.0);
            this.resizeBL = new Rectangle2D.Double(this.rubberband.x - 6, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
            this.resizeBR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
        }
    }

    protected int getRubberbandingDirection() {
        return 3;
    }

    protected void zoomGraph(Point pt) {
        double middle;
        double offset;
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        this.unProject(0.0, 0.0, 0.0, v1);
        double xmin = this.chartBBox[0];
        double xmax = this.chartBBox[3];
        double ymin = this.chartBBox[1];
        double ymax = this.chartBBox[4];
        int dy = (int)((double)(pt.y - this.startPt.y) * 0.5);
        int dx = (int)((double)(this.startPt.x - pt.x) * 0.5);
        if (dx != 0 && (this.getRubberbandingDirection() == 1 || this.getRubberbandingDirection() == 3)) {
            this.unProject(dx, 0.0, 0.0, v2);
            offset = v2[0] - v1[0];
            xmin -= offset;
            xmax += offset;
            if (xmax - xmin < 1.0) {
                return;
            }
            middle = 0.5 * (this.viewportXMax + this.viewportXMin);
            xmin = Math.min(middle, Math.max(xmin, this.dataXMin));
            xmax = Math.max(xmin + this.chart.getMinimumDisplayRange(true), Math.min(xmax, this.dataXMax));
        }
        if (dy != 0 && (this.getRubberbandingDirection() == 2 || this.getRubberbandingDirection() == 3)) {
            this.unProject(0.0, dy, 0.0, v2);
            offset = v2[1] - v1[1];
            ymin += offset;
            ymax -= offset;
            if (ymax - ymin < 1.0) {
                return;
            }
            middle = 0.5 * (this.viewportYMax + this.viewportYMin);
            ymin = Math.min(middle, Math.max(ymin, this.dataYMin));
            ymax = Math.max(ymin + this.chart.getMinimumDisplayRange(false), Math.min(ymax, this.dataYMax));
        }
        this.chart.setBoundingBox(xmin, ymin, 0.0, xmax, ymax, 0.0);
        this.startPt = pt;
    }

    protected void panGraph(Point pt) {
        double delta;
        double offset;
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        this.unProject(0.0, 0.0, 0.0, v1);
        double xmin = this.chartBBox[0];
        double xmax = this.chartBBox[3];
        double ymin = this.chartBBox[1];
        double ymax = this.chartBBox[4];
        if (this.getRubberbandingDirection() == 1 || this.getRubberbandingDirection() == 3) {
            int dx = pt.x - this.startPt.x;
            this.unProject(dx, 0.0, 0.0, v2);
            offset = v2[0] - v1[0];
            xmin -= offset;
            xmax -= offset;
            if (xmin < this.dataXMin) {
                delta = this.dataXMin - xmin;
                xmin = this.dataXMin;
                xmax += delta;
            }
            if (xmax > this.dataXMax) {
                delta = xmax - this.dataXMax;
                xmin -= delta;
                xmax = this.dataXMax;
            }
        }
        if (this.getRubberbandingDirection() == 2 || this.getRubberbandingDirection() == 3) {
            int dy = pt.y - this.startPt.y;
            this.unProject(0.0, dy, 0.0, v2);
            offset = v2[1] - v1[1];
            ymin -= offset;
            ymax -= offset;
            if (ymin < this.dataYMin) {
                delta = this.dataYMin - ymin;
                ymin = this.dataYMin;
                ymax += delta;
            }
            if (ymax > this.dataYMax) {
                delta = ymax - this.dataYMax;
                ymin -= delta;
                ymax = this.dataYMax;
            }
        }
        this.chart.setBoundingBox(xmin, ymin, 0.0, xmax, ymax, 0.0);
        this.startPt = pt;
    }

    protected void dragRubberband(Point pt) {
        if (Math.abs(pt.x - this.startPt.x) < 5 || Math.abs(pt.y - this.startPt.y) < 5) {
            return;
        }
        this.rectSelection = true;
        if (this.rubberband == null) {
            this.rubberband = new Rectangle();
        }
        if (this.rubberband != null) {
            int x1 = Math.min(this.startPt.x, pt.x);
            int x2 = Math.max(this.startPt.x, pt.x);
            x1 = Math.max(x1, this.chartClipRect.x);
            x2 = Math.min(x2, this.chartClipRect.x + this.chartClipRect.width);
            int y1 = Math.min(this.startPt.y, pt.y);
            int y2 = Math.max(this.startPt.y, pt.y);
            y1 = Math.max(y1, this.chartClipRect.y);
            y2 = Math.min(y2, this.chartClipRect.y + this.chartClipRect.height);
            this.rubberband.x = x1;
            this.rubberband.y = y1;
            this.rubberband.width = x2 - x1;
            this.rubberband.height = y2 - y1;
        }
        if (!this.useBackBuffer) {
            return;
        }
        Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
        backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, (ImageObserver)((Object)this));
        if (this.chart.isHighlightRequired()) {
            backGraphics2.setClip(this.chartClipRect.x + 1, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height + 1);
            this.chart.drawHighlight(backGraphics2);
            backGraphics2.setClip(0, 0, this.compWidth, this.compHeight);
        }
        if (this.isTreeOn()) {
            for (int i = 0; i < 2; ++i) {
                if (!this.treeOn[i] || !this.tree[i].isHighlightRequired()) continue;
                Rectangle treeClipRect = this.tree[i].getChartClipArea();
                backGraphics2.setClip(treeClipRect.x, treeClipRect.y, treeClipRect.width + 1, treeClipRect.height + 1);
                this.tree[i].drawHighlight(backGraphics2);
                backGraphics2.setClip(0, 0, this.compWidth, this.compHeight);
            }
        }
        if (this.rubberband != null) {
            backGraphics2.setColor(this.brushColor);
            backGraphics2.setXORMode(Color.white);
            backGraphics2.draw(this.rubberband);
        }
        int x = this.chartClipRect.x;
        int y = this.chartClipRect.y;
        int w = this.chartClipRect.width;
        int h = this.chartClipRect.height;
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        g2.drawImage(this.backBuffer2, x, y, x + w, y + h, x, y, x + w, y + h, (ImageObserver)((Object)this));
        backGraphics2.dispose();
        g2.dispose();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        int oldWidth = this.compWidth;
        int oldHeight = this.compHeight;
        boolean backOn = this.useBackBuffer;
        this.useBackBuffer = false;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Rectangle bounds = this.getBounds();
        double width = pageFormat.getImageableWidth();
        double height = pageFormat.getImageableHeight();
        double s_aspect = (double)bounds.width / (double)bounds.height;
        double p_aspect = width / height;
        double p_width = width;
        double p_height = height;
        if (p_aspect <= 1.0) {
            if (s_aspect < 1.0 && s_aspect < p_aspect) {
                p_width = height * s_aspect;
            } else {
                p_height = width / s_aspect;
            }
        } else if (s_aspect > 1.0 && s_aspect > p_aspect) {
            p_height = width / s_aspect;
        } else {
            p_width = height * s_aspect;
        }
        this.doResize((int)p_width, (int)p_height);
        float tx = (float)((width - p_width) * 0.5);
        float ty = (float)((height - p_height) * 0.5);
        g2.translate(tx, ty);
        g2.setClip(0, 0, (int)p_width, (int)p_height);
        this.paint(graphics);
        this.useBackBuffer = backOn;
        this.doResize(oldWidth, oldHeight);
        return 0;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (this.tipsOn && this.tipText != null) {
            this.tipText = null;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.chart == null || this.error > 0) {
            return;
        }
        this.startPt = e.getPoint();
        if (this.warningIcon.isMouseOverIcon(e.getX(), e.getY())) {
            this.resetViewport();
            return;
        }
        if (this.mouseOnXAxis) {
            this.xHandler.mousePressed(e);
            return;
        }
        if (this.mouseOnYAxis) {
            this.yHandler.mousePressed(e);
            return;
        }
        if (this.mouseOnHeightX) {
            this.tree[1].getHeightHandler().mousePressed(e);
            return;
        }
        if (this.mouseOnHeightY) {
            this.tree[0].getHeightHandler().mousePressed(e);
            return;
        }
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            return;
        }
        if (this.brushMode && this.actionMode == 1) {
            this.brushAction = this.getMouseSpot(this.startPt);
            this.setCursorShape(this.brushAction, true);
            if (this.brushAction == 0) {
                this.brushMode = false;
            }
        } else {
            if (!this.chartClipRect.contains(this.startPt)) {
                return;
            }
            this.setCursor(new Cursor(0));
        }
        super.mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.chart == null) {
            return;
        }
        if (this.mouseOnXAxis) {
            this.xHandler.mouseReleased(e);
            return;
        }
        if (this.mouseOnYAxis) {
            this.yHandler.mouseReleased(e);
            return;
        }
        if (this.mouseOnHeightX) {
            this.tree[1].getHeightHandler().mouseReleased(e);
            return;
        }
        if (this.mouseOnHeightY) {
            this.tree[0].getHeightHandler().mouseReleased(e);
            return;
        }
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            if (!this.allowPopup) {
                return;
            }
            if (this.popup == null) {
                this.popup = this.getPopupMenu();
                this.add(this.popup);
            }
            this.popup.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        if (this.error > 0) {
            return;
        }
        super.mouseReleased(e);
        if (this.brushMode && this.actionMode == 1) {
            this.setCursor(new Cursor(0));
            this.createHandleRects();
            return;
        }
        this.brushMode = false;
        boolean sel = false;
        if (this.rectSelection) {
            if (this.actionMode == 2) {
                boolean viewporting = true;
                double min_viewport = 0.1;
                if (this.getRubberbandingDirection() == 1) {
                    if (this.chartBBox[3] - this.chartBBox[0] < min_viewport) {
                        viewporting = false;
                    }
                } else if (this.getRubberbandingDirection() == 2) {
                    if (this.chartBBox[4] - this.chartBBox[1] < min_viewport) {
                        viewporting = false;
                    }
                } else if (this.getRubberbandingDirection() == 3 && this.chartBBox[3] - this.chartBBox[0] < min_viewport && this.chartBBox[4] - this.chartBBox[1] < min_viewport) {
                    viewporting = false;
                }
                if (!viewporting) {
                    this.rectSelection = false;
                    this.repaint();
                    return;
                }
                double[] min = new double[3];
                double[] max = new double[3];
                this.unProject(this.rubberband.x, this.rubberband.y + this.rubberband.height, 0.0, min);
                this.unProject(this.rubberband.x + this.rubberband.width, this.rubberband.y, 0.0, max);
                if (this.getRubberbandingDirection() == 1) {
                    min[0] = Math.max(min[0], this.dataXMin);
                    min[1] = this.dataYMin;
                    max[0] = Math.min(max[0], this.dataXMax);
                    max[1] = this.dataYMax;
                } else if (this.getRubberbandingDirection() == 2) {
                    min[0] = this.dataXMin;
                    min[1] = Math.max(min[1], this.dataYMin);
                    max[0] = this.dataXMax;
                    max[1] = Math.min(max[1], this.dataYMax);
                } else {
                    min[0] = Math.max(min[0], this.dataXMin);
                    min[1] = Math.max(min[1], this.dataYMin);
                    max[0] = Math.min(max[0], this.dataXMax);
                    max[1] = Math.min(max[1], this.dataYMax);
                }
                this.chart.setBoundingBox(min[0], min[1], 0.0, max[0], max[1], 0.0);
                this.viewportXMin = min[0];
                this.viewportXMax = max[0];
                this.viewportYMin = min[1];
                this.viewportYMax = max[1];
                this.fireViewportChangeEvent();
            } else if (this.actionMode == 1) {
                this.brushMode = true;
                this.mouseAction = true;
                sel = this.chart.setSelection(this.rubberband, false);
                this.createHandleRects();
                this.mouseAction = false;
            } else if (this.actionMode == 6) {
                boolean extend;
                boolean bl = extend = e.isControlDown();
                if (this.chartClipRect.intersects(this.rubberband)) {
                    sel = this.chart.setSelection(this.rubberband, extend);
                } else if (this.isTreeOn()) {
                    for (int i = 0; i < 2; ++i) {
                        if (!this.treeOn[i] || !this.tree[i].getChartClipArea().intersects(this.rubberband)) continue;
                        this.tree[i].setSelection(this.rubberband, extend);
                    }
                }
            }
            this.rectSelection = false;
        } else if (this.actionMode == 6) {
            boolean extend;
            boolean bl = extend = e.isControlDown();
            if (this.chartClipRect.contains(e.getX(), e.getY())) {
                this.chart.setSelection(e.getX(), e.getY(), extend);
            } else if (this.isTreeOn()) {
                for (int i = 0; i < 2; ++i) {
                    boolean fire;
                    if (!this.treeOn[i] || !this.tree[i].getChartClipArea().contains(e.getX(), e.getY()) || !(fire = this.tree[i].setSelection(e.getX(), e.getY(), extend))) continue;
                    String role = this.tree[i].getOrientation() == 0 ? "Y" : "X";
                    this.chart.setSelection(role, this.tree[i].getSelectedValues(), extend);
                }
            }
        } else if (this.actionMode == 1) {
            this.chart.setSelection(e.getX(), e.getY(), false);
        }
        if (!sel) {
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.chart == null || this.error > 0) {
            return;
        }
        this.startPt = e.getPoint();
        this.mouseOnHeightY = false;
        this.mouseOnHeightX = false;
        this.mouseOnYAxis = false;
        this.mouseOnXAxis = false;
        if (this.xHandler.isMouseInZoomPanArea(e)) {
            this.xHandler.mouseMoved(e);
            this.mouseOnXAxis = true;
            this.tipText = null;
            return;
        }
        if (this.yHandler.isMouseInZoomPanArea(e)) {
            this.yHandler.mouseMoved(e);
            this.mouseOnYAxis = true;
            this.tipText = null;
            return;
        }
        if (this.treeOn[1] && this.tree[1].getHeightHandler().isMouseInZoomPanArea(e)) {
            this.tree[1].getHeightHandler().mouseMoved(e);
            this.mouseOnHeightX = true;
            return;
        }
        if (this.treeOn[0] && this.tree[0].getHeightHandler().isMouseInZoomPanArea(e)) {
            this.tree[0].getHeightHandler().mouseMoved(e);
            this.mouseOnHeightY = true;
            return;
        }
        if (this.brushMode && this.actionMode == 1) {
            this.setCursorShape(this.getMouseSpot(this.startPt), false);
        } else {
            this.setCursor(new Cursor(0));
        }
        super.mouseMoved(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.chart == null || this.error > 0) {
            return;
        }
        if (this.dataFilter.getNumberObservations(-1) <= 0) {
            return;
        }
        Point pt = e.getPoint();
        if (this.mouseOnXAxis) {
            this.xHandler.mouseDragged(e);
            return;
        }
        if (this.mouseOnYAxis) {
            this.yHandler.mouseDragged(e);
            return;
        }
        if (this.mouseOnHeightX) {
            this.tree[1].getHeightHandler().mouseDragged(e);
            return;
        }
        if (this.mouseOnHeightY) {
            this.tree[0].getHeightHandler().mouseDragged(e);
            return;
        }
        switch (this.actionMode) {
            case 3: {
                this.zoomGraph(pt);
                break;
            }
            case 4: {
                this.panGraph(pt);
                break;
            }
            case 2: 
            case 6: {
                this.dragRubberband(pt);
                break;
            }
            case 1: {
                if (this.brushMode) {
                    this.mouseAction = true;
                    this.brushing(pt);
                    this.mouseAction = false;
                    break;
                }
                this.dragRubberband(pt);
                break;
            }
        }
    }

    public void addViewportListener(Object listener) {
        if (listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (!this.viewportListeners.contains(listener)) {
            this.viewportListeners.add(listener);
        }
    }

    public void removeViewportListener(Object listener) {
        if (listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (this.viewportListeners.contains(listener)) {
            this.viewportListeners.remove(listener);
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = MenuUtilities.getPopupMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/StandardMenu.xml"), (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String actionCommand = e.getActionCommand();
                    HeatmapComponent.this.handleMenuCommand(actionCommand);
                }
            });
        }
        return this.popup;
    }

    public Component getToolBar() {
        Component tb = super.getToolBar();
        if (tb != null && tb instanceof GraphToolbarInterface && !this.userSetToolbar) {
            ((SILKToolbar)tb).setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapComponent.HeatmapToolbar.txt", (String)"Heatmap Toolbar"));
        }
        return tb;
    }

    public boolean setToolBar(Component toolBarIn) {
        if (toolBarIn != null) {
            if (this.toolBar == null && this.popup != null) {
                this.popup.insert(this.tBar, 1);
            }
            this.toolBar = toolBarIn;
            if (this.toolBar instanceof GraphToolbarInterface) {
                ((GraphToolbarInterface)this.toolBar).addListener((GraphInterface)this);
            }
        } else if (this.toolBar != null) {
            if (this.toolBar.isShowing()) {
                this.toolBar.setVisible(false);
            }
            this.toolBar = null;
            if (this.popup != null) {
                this.popup.remove(1);
            }
        }
        this.userSetToolbar = true;
        return true;
    }

    public boolean setActionMode(int mode) {
        boolean rc = true;
        if (mode == 5) {
            this.resetViewport();
            this.viewportXMin = this.dataXMin;
            this.viewportXMax = this.dataXMax;
            this.viewportYMin = this.dataYMin;
            this.viewportYMax = this.dataYMax;
            this.fireViewportChangeEvent();
        } else {
            rc = super.setActionMode(mode);
        }
        if (this.actionMode != 1 && this.brushMode) {
            this.brushMode = false;
            this.repaint();
        }
        return rc;
    }

    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        if (!rc || this.style == null) {
            return rc;
        }
        this.wall.setSolidBackground((Object)this.style.getFillStyleElement("WallFill").getFillColor());
        this.graphLayout.getTitle().applyStyle(this.style);
        this.graphLayout.getFootnote().applyStyle(this.style);
        this.tooltip.applyStyle(this.style);
        if (this.chart != null) {
            this.setColorsToChart();
        }
        if (this.xAxis != null) {
            this.setColorsToAxis(this.xAxis);
            this.xHandler.setStyle(this.style);
        }
        if (this.yAxis != null) {
            this.setColorsToAxis(this.yAxis);
            this.yHandler.setStyle(this.style);
        }
        if (this.legend != null) {
            this.setColorsToLegend();
        }
        for (int i = 0; i < 2; ++i) {
            if (!this.treeOn[i]) continue;
            this.setColorsToTree(i);
        }
        if (this.heatmapColorPanel != null) {
            this.heatmapColorPanel.updateColorScheme(this.style);
        }
        return true;
    }

    public AxisInterface getAxis(Object which) {
        if (which == null || !(which instanceof String)) {
            return null;
        }
        if (((String)which).equalsIgnoreCase(HeatmapModel.X_ROLE_NAME) || ((String)which).equalsIgnoreCase("X") || ((String)which).equalsIgnoreCase("XAxis")) {
            return this.xAxis;
        }
        if (((String)which).equalsIgnoreCase(HeatmapModel.Y_ROLE_NAME) || ((String)which).equalsIgnoreCase("Y") || ((String)which).equalsIgnoreCase("YAxis")) {
            return this.yAxis;
        }
        return null;
    }

    public LegendInterface getLegend(Object which) {
        return this.chart != null ? this.legend : null;
    }

    public Object getLegendPosition(Object which) {
        return this.legend == null ? null : this.legend.getLegendNumber(this.legend.getPosition());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setLegendPosition(Object which, Object pos) {
        if (this.legend == null) {
            return true;
        }
        int position = -1;
        if (pos instanceof String) {
            if (((String)pos).equalsIgnoreCase("South")) {
                position = 2;
            } else if (((String)pos).equalsIgnoreCase("North")) {
                position = 1;
            } else if (((String)pos).equalsIgnoreCase("East")) {
                position = 3;
            } else if (((String)pos).equalsIgnoreCase("West")) {
                position = 4;
            } else {
                if (!((String)pos).equalsIgnoreCase("Custom")) return false;
                position = 5;
            }
        } else if (pos instanceof Number) {
            position = ((Number)pos).intValue();
            switch (position) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.legend.getPosition() == position) return true;
        this.legend.setPosition(position);
        this.updateComp = true;
        this.redrawBKBuffer = true;
        this.repaint();
        return true;
    }

    public Rectangle getLegendBounds() {
        if (this.legend == null) {
            return null;
        }
        int x = this.legend.getStartPoint().x;
        int y = this.legend.getStartPoint().y;
        int w = this.legend.getPreferredSize().width;
        int h = this.legend.getPreferredSize().height;
        return new Rectangle(x, y, w, h);
    }

    public boolean setLegendBounds(Rectangle rect) {
        if (this.legend == null) {
            return true;
        }
        this.legendBounds = rect;
        this.updateComp = true;
        this.redrawBKBuffer = true;
        this.repaint();
        return true;
    }

    public void dispose() {
        super.dispose();
        this.chartClipRect = null;
        this.chartBBox = null;
        this.chartOuterMargin = null;
        this.compMargin = null;
        this.rubberband = null;
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.backBuffer2 != null) {
            this.backBuffer2.flush();
        }
        this.backBuffer2 = null;
        this.backImage = null;
        this.chart = null;
        this.xAxis = null;
        this.yAxis = null;
        this.legend = null;
        this.legendBounds = null;
        this.wall = null;
        if (this.graphLayout.getTitle() != null) {
            this.graphLayout.getTitle().removeTextListener((TextListenerInterface)this);
        }
        if (this.graphLayout.getFootnote() != null) {
            // empty if block
        }
        this.graphLayout.getFootnote().removeTextListener((TextListenerInterface)this);
        this.popup = null;
        if (this.toolBar != null) {
            this.toolBar.setVisible(false);
        }
        this.toolBar = null;
        this.removeMouseListener((MouseListener)((Object)this));
        this.removeMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public Object getDataSource(Object id) {
        return super.getDataSource(id);
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, HEATMAP);
    }

    public boolean setDataSource(Object source, Object id) {
        boolean rc = super.setDataSource(source, id);
        if (!rc) {
            return rc;
        }
        this.updatePanels = true;
        this.dataId = id;
        if (id == null || id.equals(HEATMAP)) {
            return this.createChartElements(source);
        }
        if (id.equals(DENDROGRAM_Y)) {
            return this.createTreeElement(source, 0);
        }
        if (id.equals(DENDROGRAM_X)) {
            return this.createTreeElement(source, 1);
        }
        return false;
    }

    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    public Object getVariable(Object role) {
        if (this.chart == null) {
            return null;
        }
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)role).toString();
        }
        return this.getRoleInterface().getVariable(role);
    }

    public Object getRole(Object variableId) {
        if (this.chart == null) {
            return null;
        }
        if (variableId instanceof Number) {
            Object obj = ((Number)variableId).intValue() == -3 ? HeatmapModel.X_ROLE_NUMBER : (((Number)variableId).intValue() == -4 ? HeatmapModel.Y_ROLE_NUMBER : null);
            return obj;
        }
        return this.getRoleInterface().getRole(variableId);
    }

    public boolean setRole(Object variableId, Object role) {
        if (this.chart == null || role == null) {
            return false;
        }
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)role).toString();
        }
        if (!this.getRoleInterface().setRole(variableId, role)) {
            return false;
        }
        this.updatePanels = true;
        this.repaint();
        return true;
    }

    public boolean addRole(Object variableId, Object role) {
        if (this.chart == null || role == null) {
            return false;
        }
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)role).toString();
        }
        if (!this.getRoleInterface().addRole(variableId, role)) {
            return false;
        }
        this.updatePanels = true;
        this.repaint();
        return true;
    }

    public boolean removeRole(Object variableId, Object role) {
        if (this.chart == null || role == null) {
            return false;
        }
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)role).toString();
        }
        if (!this.getRoleInterface().removeRole(variableId, role)) {
            return false;
        }
        this.updatePanels = true;
        this.repaint();
        return true;
    }

    public boolean isDiscrete(Object role) {
        if (this.chart == null) {
            return false;
        }
        return this.getRoleInterface().isDiscrete(role);
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.chart == null) {
            return false;
        }
        return this.getRoleInterface().setDiscrete(role, discrete);
    }

    public Object getSortOrder(Object role) {
        if (this.chart == null) {
            return null;
        }
        return this.getRoleInterface().getSortOrder(role);
    }

    public boolean setSortOrder(Object role, Object order) {
        if (this.chart == null) {
            return false;
        }
        return this.getRoleInterface().setSortOrder(role, order);
    }

    public Object getRoleValue(Object role, int which) {
        if (this.chart == null) {
            return null;
        }
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)role).toString();
        }
        return this.getRoleInterface().getRoleValue(role, which);
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        if (this.chart == null) {
            return null;
        }
        return this.getRoleInterface().getSupportedRoles(id, discrete);
    }

    public int getMaxAllowed(Object role) {
        if (this.chart == null) {
            return -1;
        }
        return this.getRoleInterface().getMaxAllowed(role);
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    private RoleInterface getRoleInterface() {
        if (this.dataId.equals(HEATMAP)) {
            return this.chart;
        }
        if (this.dataId.equals(DENDROGRAM_Y)) {
            return this.tree[0];
        }
        if (this.dataId.equals(DENDROGRAM_X)) {
            return this.tree[1];
        }
        return this.chart;
    }

    public boolean create(Object createData) {
        boolean status = this.build(null);
        this.repaint();
        return status;
    }

    public boolean isRebuildRequired() {
        return this.chart.isRebuildRequired() || this.xAxis.isRebuildRequired() || this.yAxis.isRebuildRequired();
    }

    public synchronized boolean build(Object buildData) {
        if (this.chart == null) {
            return false;
        }
        if (!this.isRebuildRequired()) {
            return true;
        }
        if (this.isTreeOn()) {
            Object[] values;
            if (this.treeOn[0]) {
                values = this.tree[0].getOrderedLeaves();
                this.chart.getHeatmapModel().setYValues(values);
                Object[] orderedYValue = this.chart.getHeatmapModel().getUniqueYValues();
                this.yAxis.setAxis((Object)new Double(0.0), (Object)new Double(orderedYValue.length - 1), -1, -1, orderedYValue, Boolean.TRUE, null);
            }
            if (this.treeOn[1]) {
                values = this.tree[1].getOrderedLeaves();
                this.chart.getHeatmapModel().setXValues(values);
                this.xAxis.setAxis((Object)new Double(0.0), (Object)new Double(values.length - 1), -1, -1, values, Boolean.TRUE, null);
            }
        }
        this.redrawBKBuffer = true;
        if (!this.isDataAssigned()) {
            this.error |= 1;
            return false;
        }
        this.error &= 0xFFFFFFFE;
        if (this.chart.isDataChanged()) {
            this.chartBBox = this.chart.getBoundingBox();
            if (this.chartBBox == null) {
                return false;
            }
            double[] dr = this.chart.getDataBoundingBox();
            this.dataXMin = dr[0];
            this.dataYMin = dr[1];
            this.dataXMax = dr[3];
            this.dataYMax = dr[4];
            this.viewportXMin = this.chartBBox[0];
            this.viewportYMin = this.chartBBox[1];
            this.viewportXMax = this.chartBBox[3];
            this.viewportYMax = this.chartBBox[4];
            this.xHandler.setDataRange(this.dataXMin, this.dataXMax);
            this.yHandler.setDataRange(this.dataYMin, this.dataYMax);
            this.xHandler.setMinimumViewportRange(this.chart.getMinimumDisplayRange(true));
            this.yHandler.setMinimumViewportRange(this.chart.getMinimumDisplayRange(false));
            this.fireViewportChangeEvent();
            this.fireRangeChangeEvent((byte)1);
            this.fireRangeChangeEvent((byte)2);
            this.brushMode = false;
        }
        if (this.chart.isRebuildRequired()) {
            this.chart.build(null);
        }
        if (this.xAxis != null && this.xAxis.isRebuildRequired()) {
            this.xAxis.build(null);
        }
        if (this.yAxis != null && this.yAxis.isRebuildRequired()) {
            this.yAxis.build(null);
        }
        this.buildOtherElements(null);
        return true;
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(null);
        this.repaint();
        return status;
    }

    public double[] project(double x, double y, double z, double[] out) {
        if (this.chartBBox == null) {
            return null;
        }
        double[] ret = out;
        if (ret == null && (ret = new double[3]) == null) {
            return null;
        }
        int w = this.viewportWidth - this.chartOuterMargin.left - this.chartOuterMargin.right;
        int h = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom;
        int xo = this.viewportX + this.chartOuterMargin.left;
        int yo = this.viewportY + this.chartOuterMargin.top;
        if (this.chartInnerMargin != null) {
            w -= this.chartInnerMargin.left + this.chartInnerMargin.right;
            h -= this.chartInnerMargin.top + this.chartInnerMargin.bottom;
            xo += this.chartInnerMargin.left;
            yo += this.chartInnerMargin.top;
        }
        double xMin = this.chartBBox[0];
        double yMin = this.chartBBox[1];
        double xMax = this.chartBBox[3];
        double yMax = this.chartBBox[4];
        ret[0] = xMax == xMin ? (double)xo : (double)w * (x - xMin) / (xMax - xMin) + (double)xo;
        ret[1] = yMax == yMin ? (double)yo : (double)h - (double)h * (y - yMin) / (yMax - yMin) + (double)yo;
        ret[2] = 0.0;
        return ret;
    }

    public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
        if (this.chartBBox == null) {
            return null;
        }
        double[] ret = out;
        if (ret == null && (ret = new double[3]) == null) {
            return null;
        }
        int w = this.viewportWidth - this.chartOuterMargin.left - this.chartOuterMargin.right;
        int h = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom;
        int xo = this.viewportX + this.chartOuterMargin.left;
        int yo = this.viewportY + this.chartOuterMargin.top;
        if (this.chartInnerMargin != null) {
            w -= this.chartInnerMargin.left + this.chartInnerMargin.right;
            h -= this.chartInnerMargin.top + this.chartInnerMargin.bottom;
            xo += this.chartInnerMargin.left;
            yo += this.chartInnerMargin.top;
        }
        double xMin = this.chartBBox[0];
        double yMin = this.chartBBox[1];
        double xMax = this.chartBBox[3];
        double yMax = this.chartBBox[4];
        ret[0] = w == 0 ? xMin : (xMax - xMin) * (pixelX - (double)xo) / (double)w + xMin;
        ret[1] = h == 0 ? yMin : (yMax - yMin) * ((double)(h + yo) - pixelY) / (double)h + yMin;
        ret[2] = 0.0;
        return ret;
    }

    public boolean isReverse(int axis) {
        return false;
    }

    public void setReverse(int axis, boolean flag) {
    }

    public void redraw(RedrawEvent e) {
        if (e.getSource() instanceof DendrogramChart) {
            this.updateComp = true;
        }
        if (e.type == 5 && !this.mouseAction) {
            this.brushMode = false;
        }
        if (e.type != 5) {
            this.redrawBKBuffer = true;
        }
        if (this.chart != null && this.chart.isInnerMarginChanged()) {
            this.fireMarginChangeEvent(true, false);
        }
        this.repaint();
    }

    public void boundingBoxChanged(RedrawEvent e) {
        this.chartInnerMargin = null;
        if (e.newBoundingBox != null) {
            if (e.getSource() == this.chart) {
                this.chartBBox = e.newBoundingBox;
            } else if (e.getSource() == this.yAxis) {
                this.chartBBox[1] = e.newBoundingBox[1];
                this.chartBBox[4] = e.newBoundingBox[4];
            } else if (e.getSource() == this.xAxis) {
                this.chartBBox[0] = e.newBoundingBox[0];
                this.chartBBox[3] = e.newBoundingBox[3];
            }
            if (this.xAxis != null && this.chart.getHeatmapModel().isDateTime()) {
                this.xAxis.setAxis((Object)new Double(this.chartBBox[0]), (Object)new Double(this.chartBBox[3]), -1, -1, null, Boolean.TRUE, null);
            }
            this.viewportXMin = this.chartBBox[0];
            this.viewportYMin = this.chartBBox[1];
            this.viewportXMax = this.chartBBox[3];
            this.viewportYMax = this.chartBBox[4];
            this.fireViewportChangeEvent();
            this.brushMode = false;
        }
    }

    public void outerMarginChanged(RedrawEvent e) {
        this.chartMargin = this.chart.getOuterMargin((Graphics2D)this.gc);
        this.chartOuterMargin.top = this.compMargin.top + this.chartMargin.top;
        this.chartOuterMargin.bottom = this.compMargin.bottom + this.chartMargin.bottom;
        this.chartOuterMargin.left = this.compMargin.left + this.chartMargin.left;
        this.chartOuterMargin.right = this.compMargin.right + this.chartMargin.right;
        if (!this.updateComp && this.updateChartClipArea()) {
            this.redrawBKBuffer = true;
            this.repaint();
        }
    }

    public int numPages(PageFormat pf) {
        return 1;
    }

    public int numPagesX(PageFormat pf) {
        return 1;
    }

    public int numPagesY(PageFormat pf) {
        return 1;
    }

    public void textUpdated(DvrTextEvent evt) {
        if (evt.isBoundsChanged) {
            this.updateComp = true;
        }
        this.redrawBKBuffer = true;
        this.repaint();
    }

    public int getNumRanges(byte dim) {
        return 0;
    }

    public DataRangeInterface getRangeSource(byte dim, int index) {
        return this;
    }

    public void setAxesVisible(boolean axesVisible) {
    }

    public boolean getAxesVisible() {
        return true;
    }

    public void setRange(byte dim, int index, DataRange range) {
        Axes axis;
        if (dim == 1) {
            axis = this.xAxis;
        } else if (dim == 2) {
            axis = this.yAxis;
        } else {
            return;
        }
        if (range instanceof ContinuousRange) {
            double min = ((ContinuousRange)range).getMin();
            double max = ((ContinuousRange)range).getMax();
            axis.setAxis((Object)new Double(min), (Object)new Double(max), -1, -1, null, Boolean.TRUE, null);
            this.chart.getHeatmapModel().setMinimumTime(min);
            this.chart.getHeatmapModel().setMaximumTime(max);
        } else if (range instanceof DiscreteRange) {
            int size = ((DiscreteRange)range).getValuesSize();
            Enumeration e = ((DiscreteRange)range).getEnumeration();
            Object[] vals = new Object[size];
            int i = 0;
            while (e.hasMoreElements()) {
                vals[i] = e.nextElement();
                ++i;
            }
            axis.setAxis((Object)new Double(0.0), (Object)new Double(size - 1), -1, -1, vals, Boolean.TRUE, null);
            if (dim == 1) {
                this.chart.getHeatmapModel().setXValues(vals);
            } else {
                this.chart.getHeatmapModel().setYValues(vals);
            }
        }
        this.chart.setDataChanged(true);
    }

    public Insets getOuterMargin() {
        if (this.userSetOuterMargin) {
            return this.chartOuterMargin;
        }
        return this.getPreferredOuterMargin();
    }

    public Insets getInnerMargin() {
        if (this.chartInnerMargin != null) {
            return this.chartInnerMargin;
        }
        return this.getPreferredInnerMargin();
    }

    public void setOuterMargin(Insets margin) {
        Insets oldOM = this.chartOuterMargin;
        this.chartOuterMargin = margin;
        this.userSetOuterMargin = true;
        if (this.chartOuterMargin.equals(oldOM)) {
            return;
        }
        this.updateChartClipArea();
        this.redrawBKBuffer = true;
        this.repaint();
    }

    public void setInnerMargin(Insets margin) {
        this.chartInnerMargin = margin;
        this.chart.setInnerMargin(margin);
        if (this.xAxis != null) {
            this.xAxis.setOffset(this.chartInnerMargin.left, this.chartInnerMargin.right);
        }
        if (this.yAxis != null) {
            this.yAxis.setOffset(this.chartInnerMargin.bottom, this.chartInnerMargin.top);
        }
        Dimension cellDim = this.chart.getCellDimension();
        this.chartInnerMargin.top = (int)((double)this.chartInnerMargin.top - (double)cellDim.height * 0.5);
        this.chartInnerMargin.left = (int)((double)this.chartInnerMargin.left - (double)cellDim.width * 0.5);
        this.chartInnerMargin.bottom = (int)((double)this.chartInnerMargin.bottom - (double)cellDim.height * 0.5);
        this.chartInnerMargin.right = (int)((double)this.chartInnerMargin.right - (double)cellDim.width * 0.5);
        this.xAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        this.yAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        this.redrawBKBuffer = true;
        this.repaint();
    }

    public Insets getPreferredOuterMargin() {
        Insets margin = new Insets(0, 0, 0, 0);
        if (this.chart != null) {
            Insets m2 = this.chart.getOuterMargin((Graphics2D)this.gc);
            Insets m1 = this.getComponentMargin();
            margin.top = m1.top + m2.top;
            margin.bottom = m1.bottom + m2.bottom;
            margin.left = m1.left + m2.left;
            margin.right = m1.right + m2.right;
        }
        return margin;
    }

    public Insets getPreferredInnerMargin() {
        if (this.chart == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.chart.getInnerMargin();
    }

    public void disableMarginPrefCalc() {
    }

    public void enableMarginPrefCalc() {
    }

    public boolean getMarginsAligned() {
        return true;
    }

    public void addMarginListener(MarginListener listener) {
        if (!this.marginListeners.contains(listener)) {
            this.marginListeners.add(listener);
        }
        if (this.chart != null) {
            this.chart.setMarginListener(this.marginListeners, this);
        }
    }

    public void removeMarginListener(MarginListener listener) {
        if (this.marginListeners.contains(listener)) {
            this.marginListeners.remove(this.marginListeners.indexOf(listener));
        }
        if (this.chart != null) {
            this.chart.setMarginListener(this.marginListeners, this);
        }
    }

    public DataRange getDataRange(byte dimension) {
        HeatmapModel model = this.chart.getHeatmapModel();
        if (model == null) {
            return null;
        }
        if (dimension == 1) {
            if (model.isDateTime()) {
                Number MIN = (Number)this.getRoleValue(HeatmapModel.X_ROLE_NAME, 0);
                Number MAX = (Number)this.getRoleValue(HeatmapModel.X_ROLE_NAME, 1);
                double min = MIN == null ? Double.NaN : MIN.doubleValue();
                double max = MAX == null ? Double.NaN : MAX.doubleValue();
                return new ContinuousRange(min, max);
            }
            Object[] vals = model.getUniqueXValues();
            return new DiscreteRange(vals);
        }
        if (dimension == 2) {
            Object[] vals = model.getUniqueYValues();
            return new DiscreteRange(vals);
        }
        return null;
    }

    public void addRangeChangeListener(RangeChangeListener listener) {
        if (!this.rangeListeners.contains(listener)) {
            this.rangeListeners.add(listener);
        }
    }

    public void removeRangeChangeListener(RangeChangeListener listener) {
        if (this.rangeListeners.contains(listener)) {
            this.rangeListeners.remove(this.rangeListeners.indexOf(listener));
        }
    }

    public Object getPropertyValue(int idx) {
        int i;
        if (this.propertyIndex != null && (i = this.propertyIndex.indexOf(new Integer(idx))) >= 0) {
            return this.propertyValue.get(i);
        }
        switch (idx) {
            case 27: {
                if (this.wall != null) {
                    return this.wall.getGraphBackground();
                }
                return null;
            }
            case 26: {
                if (this.wall != null) {
                    return new Boolean(this.wallOn);
                }
            }
            case 2: {
                return new Boolean(this.tipsOn);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return this.tooltip.getPropertyValue(idx);
            }
            case 10: {
                return this.getGraphBackground();
            }
            case 21: {
                return this.getSolidBackground();
            }
            case 11: {
                return new Boolean(this.supportsGradientBackground());
            }
            case 12: {
                return new Boolean(this.supportsImageBackground());
            }
            case 32: {
                return new Integer(this.xMargin);
            }
            case 33: {
                return new Integer(this.yMargin);
            }
            case 34: {
                return null;
            }
            case 238: {
                return new Integer(this.selectedAxis);
            }
            case 23: {
                return this.legend;
            }
            case 443: {
                return this.legend.getPropertyValue(443);
            }
            case 402: {
                if (this.getLegend(null) == null) {
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
            case 601: {
                return this.getTitle(0);
            }
            case 602: {
                return this.getTitle(1);
            }
            case 603: {
                return this.getFootnote(0);
            }
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: {
                TextStyleInterface text = idx >= 607 ? this.getTitle(0) : (idx >= 609 ? this.getTitle(1) : this.getFootnote(0));
                if (text == null) {
                    return null;
                }
                switch (idx) {
                    case 607: 
                    case 609: 
                    case 611: {
                        return new Boolean(text.isVisible());
                    }
                    case 608: 
                    case 610: 
                    case 612: {
                        return text.getText();
                    }
                }
            }
        }
        if (this.legend != null && this.legend.isPropertySupported(idx)) {
            return this.legend.getPropertyValue(idx);
        }
        if (this.chart != null && this.chart.isPropertySupported(idx)) {
            return this.chart.getPropertyValue(idx);
        }
        if (this.xAxis != null && this.xAxis.isPropertySupported(idx)) {
            if (this.selectedAxis == 0) {
                return this.xAxis.getPropertyValue(idx);
            }
            return this.yAxis.getPropertyValue(idx);
        }
        return null;
    }

    public boolean setPropertyValue(int idx, Object value) {
        if (this.isPropertySupported(idx)) {
            int i = this.propertyIndex.indexOf(new Integer(idx));
            if (i >= 0) {
                this.propertyValue.set(i, value);
            } else {
                this.propertyIndex.add(new Integer(idx));
                this.propertyValue.add(value);
            }
            if (idx == 238 && value instanceof Integer) {
                this.selectedAxis = (Integer)value;
            }
        } else {
            if (this.legend != null && this.legend.isPropertySupported(idx)) {
                return this.legend.setPropertyValue(idx, value);
            }
            if (this.chart != null && this.chart.isPropertySupported(idx)) {
                return this.chart.setPropertyValue(idx, value);
            }
            if (this.xAxis != null && this.xAxis.isPropertySupported(idx)) {
                if (this.selectedAxis == 0) {
                    return this.xAxis.setPropertyValue(idx, value);
                }
                if (this.yAxis != null) {
                    return this.yAxis.setPropertyValue(idx, value);
                }
            }
        }
        return true;
    }

    public int getNumberProperties() {
        return 8;
    }

    public boolean applyPropertyChanges() {
        this.applyingChanges = true;
        if (this.propertyIndex == null) {
            return false;
        }
        if (this.propertyIndex.size() <= 0) {
            if (this.legend != null) {
                this.legend.applyPropertyChanges();
            }
            if (this.chart != null) {
                this.chart.applyPropertyChanges();
            }
            if (this.xAxis != null) {
                this.xAxis.applyPropertyChanges();
            }
            if (this.yAxis != null) {
                this.yAxis.applyPropertyChanges();
            }
            this.applyingChanges = false;
            this.updateComp = true;
            this.redrawBKBuffer = true;
            this.repaint();
            return true;
        }
        Object startColor = null;
        Object endColor = null;
        block25: for (int i = 0; i < this.propertyIndex.size(); ++i) {
            int idx = (Integer)this.propertyIndex.get(i);
            Object value = this.propertyValue.get(i);
            if (value instanceof PropertyEvent) {
                value = ((PropertyEvent)value).value;
            }
            switch (idx) {
                case 26: {
                    this.wallOn = (Boolean)value;
                    continue block25;
                }
                case 2: {
                    if (!(value instanceof Boolean)) continue block25;
                    this.tipsOn = (Boolean)value;
                    continue block25;
                }
                case 3: {
                    if (!(value instanceof Font)) continue block25;
                    this.tooltip.setFontObject((Font)value);
                    continue block25;
                }
                case 4: {
                    this.tooltip.setChartTipTextColor(value);
                    continue block25;
                }
                case 5: {
                    this.tooltip.setChartTipBorderColor(value);
                    continue block25;
                }
                case 6: {
                    this.tooltip.getChartTipBackground().setSolidBackground(value);
                    continue block25;
                }
                case 8: {
                    if (!(value instanceof Double)) continue block25;
                    this.tooltip.setChartTipOpacity(((Double)value).doubleValue());
                    continue block25;
                }
                case 21: {
                    this.setSolidBackground(value);
                    continue block25;
                }
                case 13: {
                    startColor = value;
                    continue block25;
                }
                case 14: {
                    endColor = value;
                    continue block25;
                }
                case 15: {
                    this.setGradientBackground(startColor, endColor, value);
                    continue block25;
                }
                case 32: {
                    this.xMargin = value instanceof Number ? ((Number)value).intValue() : this.xMargin;
                    continue block25;
                }
                case 33: {
                    this.yMargin = value instanceof Number ? ((Number)value).intValue() : this.yMargin;
                    continue block25;
                }
                case 34: {
                    boolean vis;
                    if (!(value instanceof Boolean)) continue block25;
                    this.hScrollbarOn = this.vScrollbarOn = (vis = ((Boolean)value).booleanValue());
                    if (this.xHandler != null) {
                        this.xHandler.setZoomPanEnabled(this.hScrollbarOn);
                    }
                    if (this.yHandler == null) continue block25;
                    this.yHandler.setZoomPanEnabled(this.hScrollbarOn);
                    continue block25;
                }
                case 443: {
                    if (!(value instanceof String) && !(value instanceof Number)) continue block25;
                    this.setLegendPosition(null, value);
                    continue block25;
                }
                case 604: {
                    if (!(value instanceof TextStyleInterface)) continue block25;
                    this.setTitle(0, (TextStyleInterface)value);
                    continue block25;
                }
                case 605: {
                    if (!(value instanceof TextStyleInterface)) continue block25;
                    this.setTitle(1, (TextStyleInterface)value);
                    continue block25;
                }
                case 606: {
                    if (!(value instanceof TextStyleInterface)) continue block25;
                    this.setFootnote(0, (TextStyleInterface)value);
                    continue block25;
                }
                case 601: 
                case 602: 
                case 603: 
                case 607: 
                case 608: 
                case 609: 
                case 610: 
                case 611: 
                case 612: {
                    TextStyleInterface text = idx >= 607 ? this.getTitle(0) : (idx >= 609 ? this.getTitle(1) : this.getFootnote(0));
                    if (text == null) {
                        return false;
                    }
                    switch (idx) {
                        case 607: 
                        case 609: 
                        case 611: {
                            text.setVisible(((Boolean)value).booleanValue());
                            break;
                        }
                        case 608: 
                        case 610: 
                        case 612: {
                            text.setText(value);
                        }
                    }
                    continue block25;
                }
                default: {
                    this.applyChange(idx, value);
                }
            }
        }
        this.propertyIndex.clear();
        this.propertyValue.clear();
        if (this.legend != null) {
            this.legend.applyPropertyChanges();
        }
        if (this.chart != null) {
            this.chart.applyPropertyChanges();
        }
        if (this.xAxis != null) {
            this.xAxis.applyPropertyChanges();
        }
        if (this.yAxis != null) {
            this.yAxis.applyPropertyChanges();
        }
        this.applyingChanges = false;
        this.updateComp = true;
        this.redrawBKBuffer = true;
        this.repaint();
        return true;
    }

    public boolean applyPropertyChanges(Object source) {
        return this.applyPropertyChanges();
    }

    public void cancelPropertyChanges() {
        this.propertyIndex.clear();
        this.propertyValue.clear();
        if (this.legend != null) {
            this.legend.cancelPropertyChanges();
        }
        if (this.chart != null) {
            this.chart.cancelPropertyChanges();
        }
        if (this.xAxis != null) {
            this.xAxis.cancelPropertyChanges();
        }
        if (this.yAxis != null) {
            this.yAxis.cancelPropertyChanges();
        }
    }

    public void cancelPropertyChanges(Object source) {
    }

    public int[] getPendingChanges() {
        int[] index = new int[this.propertyIndex.size()];
        for (int i = 0; i < this.propertyIndex.size(); ++i) {
            index[i] = (Integer)this.propertyIndex.get(i);
        }
        return index;
    }

    public int[] getPendingChanges(Object source) {
        int[] index = new int[this.propertyIndex.size()];
        return index;
    }

    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 238: 
            case 402: 
            case 443: 
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int idx) {
        return false;
    }

    public int getNumberPendingProperties() {
        return -1;
    }

    public boolean hasUserSetValue(int id) {
        if (this.legend != null && this.legend.isPropertySupported(id)) {
            return this.legend.hasUserSetValue(id);
        }
        if (this.chart != null && this.chart.isPropertySupported(id)) {
            return this.chart.hasUserSetValue(id);
        }
        if (this.xAxis != null && this.xAxis.isPropertySupported(id)) {
            return this.xAxis.hasUserSetValue(id);
        }
        if (this.yAxis != null && this.yAxis.isPropertySupported(id)) {
            return this.yAxis.hasUserSetValue(id);
        }
        return super.hasUserSetValue(id);
    }

    public double[] getViewport(int type, int level, int dimension) {
        double[] vport = new double[2];
        switch (dimension) {
            case 1: {
                vport[0] = this.viewportXMin;
                vport[1] = this.viewportXMax;
                break;
            }
            case 2: {
                vport[0] = this.viewportYMin;
                vport[1] = this.viewportYMax;
                break;
            }
            default: {
                return null;
            }
        }
        return vport;
    }

    public boolean setViewport(int type, int dimension, double min, double max) {
        switch (dimension) {
            case 1: {
                this.viewportXMin = min;
                this.viewportXMax = max;
                break;
            }
            case 2: {
                this.viewportYMin = min;
                this.viewportYMax = max;
                break;
            }
            default: {
                return false;
            }
        }
        if (this.chart != null) {
            this.chart.setBoundingBox(this.viewportXMin, this.viewportYMin, 0.0, this.viewportXMax, this.viewportYMax, 0.0);
        }
        return true;
    }

    public boolean setViewport(int type, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        this.viewportXMin = Math.max(this.dataXMin, xmin);
        this.viewportXMax = Math.min(this.dataXMax, xmax);
        this.viewportYMin = Math.max(this.dataYMin, ymin);
        this.viewportYMax = Math.min(this.dataYMax, ymax);
        if (this.chart != null) {
            this.chart.setBoundingBox(this.viewportXMin, this.viewportYMin, 0.0, this.viewportXMax, this.viewportYMax, 0.0);
        }
        return true;
    }

    public double getZoomFactor(int dimension) {
        return 1.0;
    }

    public boolean setZoomFactor(int dimension, double fac) {
        if (fac <= 0.0 || fac > 1.0) {
            return false;
        }
        switch (dimension) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                return false;
            }
        }
        this.zoomFactor = fac;
        this.doDataZoom(dimension);
        return true;
    }

    public boolean resetViewport() {
        this.chart.setBoundingBox(this.dataXMin, this.dataYMin, 0.0, this.dataXMax, this.dataYMax, 0.0);
        return true;
    }

    public void viewportChanged(ViewportEvent evt) {
        if (this.mouseOnXAxis) {
            this.setViewport(1, 1, evt.xMin, evt.xMax);
        } else if (this.mouseOnYAxis) {
            this.setViewport(1, 2, evt.yMin, evt.yMax);
        }
    }

    public HeatmapChart getChart() {
        return this.chart;
    }

    public Object getWall() {
        return this.wall;
    }

    protected void doDataZoom(int dim) {
        double rangeX = this.dataXMax - this.dataXMin;
        double rangeY = this.dataYMax - this.dataYMin;
        if (dim == 1) {
            this.viewportXMin = this.dataXMin;
            this.viewportXMax = this.dataXMin + rangeX * this.zoomFactor;
        } else if (dim == 2) {
            this.viewportYMin = this.dataYMax - rangeY * this.zoomFactor;
            this.viewportYMax = this.dataYMax;
        } else if (dim == 4) {
            this.viewportXMin = this.dataXMin;
            this.viewportXMax = this.dataXMin + rangeX * this.zoomFactor;
            this.viewportYMin = this.dataYMax - rangeY * this.zoomFactor;
            this.viewportYMax = this.dataYMax;
        }
        this.chart.setBoundingBox(this.viewportXMin, this.viewportYMin, 0.0, this.viewportXMax, this.viewportYMax, 0.0);
    }

    protected void fireRangeChangeEvent(byte dimension) {
        DataRange dr = this.getDataRange(dimension);
        RangeChangedEvent rce = new RangeChangedEvent((Object)this, 3, dr, dimension, dr);
        int numListeners = this.rangeListeners.size();
        if (numListeners > 0) {
            for (int i = 0; i < numListeners; ++i) {
                ((RangeChangeListener)this.rangeListeners.get(i)).rangeChanged(rce);
            }
        }
    }

    protected void fireMarginChangeEvent(boolean inner, boolean outer) {
        int numListeners;
        if (inner) {
            this.chartInnerMargin = null;
        }
        if (outer) {
            this.userSetOuterMargin = false;
        }
        if ((numListeners = this.marginListeners.size()) > 0) {
            MarginChangeEvent mce = new MarginChangeEvent((Object)this);
            if (inner) {
                mce.setInnerChanged(true);
            }
            if (outer) {
                mce.setOuterChanged(true);
            }
            for (int i = 0; i < numListeners; ++i) {
                ((MarginListener)this.marginListeners.get(i)).marginChanged(mce);
            }
        }
    }

    protected void fireViewportChangeEvent() {
        ViewportEvent evt = new ViewportEvent((Object)this, 1, this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax, 0.0, 0.0);
        for (int i = 0; i < this.viewportListeners.size(); ++i) {
            ((ViewportListenerInterface)this.viewportListeners.get(i)).viewportChanged(evt);
        }
    }

    protected boolean createTreeElement(Object source, int id) {
        if (!this.isHeatMapOn()) {
            return false;
        }
        if (this.tree[id] == null) {
            this.tree[id] = new DendrogramChart();
        }
        if (this.tree[id] == null) {
            return false;
        }
        this.treeOn[id] = true;
        this.tree[id].setDataSource(this.dataFilter);
        this.tree[id].addRedrawListener(this);
        this.setColorsToTree(id);
        Axes heightAxis = new Axes(source);
        if (heightAxis != null) {
            heightAxis.addRedrawListener((RedrawListener)this);
            this.setColorsToAxis(heightAxis);
            this.tree[id].setHeightAxis(heightAxis);
        }
        int o = id == 0 ? 0 : 1;
        this.tree[id].setOrientation(o);
        return true;
    }

    protected void setColorsToTree(int id) {
        this.tree[id].setNodeColor(this.style.getLineStyleElement("AxisLines").getLineColor());
        this.tree[id].setSelectionColor(this.style.getLineStyleElement("Outlines").getLineColor());
        if (this.tree[id].getTreeAxis() != null) {
            this.setColorsToAxis(this.tree[id].getTreeAxis());
            this.tree[id].getTreeHandler().setStyle(this.style);
        }
        if (this.tree[id].getHeightAxis() != null) {
            this.setColorsToAxis(this.tree[id].getHeightAxis());
            this.tree[id].getHeightHandler().setStyle(this.style);
        }
    }

    protected boolean isTreeOn() {
        return this.treeOn[0] || this.treeOn[1];
    }

    private synchronized boolean buildTrees() {
        for (int i = 0; i < 2; ++i) {
            if (this.treeOn[i] && this.tree[i].isRebuildRequired() && !this.tree[i].build(null)) {
                this.error |= 1;
                return false;
            }
            this.error &= 0xFFFFFFFE;
        }
        return true;
    }

    public boolean isDendrogramOn(Object id) {
        if (id.equals(DENDROGRAM_X)) {
            return this.treeOn[1];
        }
        if (id.equals(DENDROGRAM_Y)) {
            return this.treeOn[0];
        }
        return false;
    }

    public void setDendrogramOn(Object id, boolean on) {
        int treeId;
        if (id.equals(DENDROGRAM_X)) {
            treeId = 1;
        } else if (id.equals(DENDROGRAM_Y)) {
            treeId = 0;
        } else {
            return;
        }
        this.treeOn[treeId] = on && this.tree[treeId] != null && this.tree[treeId].getDataSource() != null;
        this.updateComp = true;
    }

    public DendrogramChart getDendrogram(Object id) {
        if (id.equals(DENDROGRAM_X)) {
            return this.tree[1];
        }
        if (id.equals(DENDROGRAM_Y)) {
            return this.tree[0];
        }
        return null;
    }
}

