/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.BarComponent;
import com.sas.graphics.silk.ConstComponent;
import com.sas.graphics.silk.GTableComponent;
import com.sas.graphics.silk.HistogramComponent;
import com.sas.graphics.silk.LatticeComponent;
import com.sas.graphics.silk.PieComponent;
import com.sas.graphics.silk.ScatterComponent;
import com.sas.graphics.silk.TreeviewComponent;
import com.sas.graphics.silk.event.DrilldownEvent;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.ui.AxisPanel;
import com.sas.graphics.silk.ui.BarPanel;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.HistogramPanel;
import com.sas.graphics.silk.ui.LinksPanel;
import com.sas.graphics.silk.ui.NodesPanel;
import com.sas.graphics.silk.ui.PiePanel;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.ScatterPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.ui.WherePanel;
import com.sas.graphics.silk.util.LayoutNode;
import com.sas.graphics.silk.util.Print;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.PropertyMulticaster;
import com.sas.graphics.util.nld.NLDViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;

public class GridLayoutComponent
extends JComponent
implements MouseListener,
ActionListener,
Printable,
ComponentInterface {
    private static final long serialVersionUID = -9040403111201894002L;
    private LayoutNode root = null;
    private Vector graphs = null;
    private Vector scatters = null;
    private Vector bars = null;
    private Vector pies = null;
    private Vector histograms = null;
    private Vector constellations = null;
    private Vector treeviews = null;
    private JPopupMenu menu = null;
    private TabbedPropertiesDialog dialog = null;
    private JDialog whereDialog = null;
    private SILKToolbar toolbar = null;
    private ComponentInterface selectedChart = null;
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
    protected Vector drilldownListeners = new Vector();
    protected Object id = null;

    public GridLayoutComponent() {
        this.graphs = new Vector();
        this.scatters = new Vector();
        this.bars = new Vector();
        this.pies = new Vector();
        this.histograms = new Vector();
        this.constellations = new Vector();
        this.treeviews = new Vector();
        this.setLayout(new BorderLayout());
    }

    public GridLayoutComponent(LayoutNode node) {
        this();
        this.setRoot(node);
    }

    public void setRoot(LayoutNode node) {
        this.root = node;
        this.init(this.root);
        this.add("Center", this.root);
    }

    public LayoutNode getRoot() {
        return this.root;
    }

    private void buildMenu() {
        this.menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Properties.txt", (String)"Properties"));
        this.menu.add(item);
        item.addActionListener(this);
        this.menu.addSeparator();
        item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Where.txt", (String)"Where"));
        this.menu.add(item);
        item.addActionListener(this);
        JMenu chartMenu = null;
        chartMenu = this.selectedChart instanceof ScatterComponent ? new JMenu(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Scatter.txt", (String)"Scatter")) : (this.selectedChart instanceof HistogramComponent ? new JMenu(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Histogram.txt", (String)"Histogram")) : (this.selectedChart instanceof BarComponent ? new JMenu(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Bar.txt", (String)"Bar")) : (this.selectedChart instanceof PieComponent ? new JMenu(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Pie.txt", (String)"Pie")) : (this.selectedChart instanceof ConstComponent ? new JMenu(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Const.txt", (String)"Const")) : (this.selectedChart instanceof TreeviewComponent ? new JMenu(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Treeview.txt", (String)"Tree")) : new JMenu())))));
        if (chartMenu != null && this.selectedChart instanceof GraphInterface) {
            JPopupMenu pMenu = ((GraphInterface)this.selectedChart).getPopupMenu();
            if (chartMenu.getText() == null || chartMenu.getText().length() == 0) {
                chartMenu.setText(pMenu.getLabel() == null ? "Chart" : pMenu.getLabel());
            }
            UIUtilities.addMenu((JPopupMenu)pMenu, (JMenu)chartMenu);
            this.menu.addSeparator();
            this.menu.add(chartMenu);
        } else if (this.selectedChart instanceof ComponentInterface && this.selectedChart instanceof GTableComponent) {
            chartMenu = ((GTableComponent)this.selectedChart).getGTablePopMenu("GTable", this);
            this.menu.addSeparator();
            this.menu.add(chartMenu);
        }
        this.menu.add(new JSeparator());
        JMenu print = new JMenu(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Print.txt", (String)"Print"));
        this.menu.add(print);
        item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.All.txt", (String)"All"));
        item.setActionCommand("PrintAll");
        item.addActionListener(this);
        print.add(item);
        item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Component.txt", (String)"Component"));
        item.setActionCommand("PrintComponent");
        item.addActionListener(this);
        print.add(item);
        item = new JMenuItem(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Save_as_image.txt", (String)"Save as image"));
        item.setEnabled(false);
        this.menu.add(item);
    }

    @Override
    public void addNotify() {
        int i;
        GraphPanel panel;
        Container c;
        super.addNotify();
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        for (c = this.getParent(); c != null && !(c instanceof Frame); c = c.getParent()) {
        }
        this.dialog = new TabbedPropertiesDialog((Frame)c, (Component)this, ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Properties.txt", (String)"Properties"));
        if (this.graphs.size() > 0) {
            int index = 0;
            for (index = 0; index < this.graphs.size() && !(this.graphs.elementAt(index) instanceof GraphInterface); ++index) {
            }
            if (index == this.graphs.size()) {
                index = 0;
            }
            panel = new GraphPanel((PropertyInterface)this.graphs.elementAt(index), null);
            for (i = 0; i < this.graphs.size(); ++i) {
                if (i == index) continue;
                panel.addChart((PropertyInterface)this.graphs.elementAt(i));
            }
            this.dialog.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Graph.txt", (String)"Graph"), (TabPanelInterface)panel);
        }
        if (this.scatters.size() > 0) {
            PropertyMulticaster pm = new PropertyMulticaster((PropertyInterface)((ScatterComponent)this.scatters.elementAt(0)).getChart(null));
            for (int i2 = 1; i2 < this.scatters.size(); ++i2) {
                pm.addListener((PropertyInterface)((ScatterComponent)this.scatters.elementAt(i2)).getChart(null));
            }
            this.dialog.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Plot.txt", (String)"Plot"), (TabPanelInterface)new ScatterPanel((PropertyInterface)pm));
        }
        if (this.bars.size() > 0) {
            PropertyMulticaster pm = new PropertyMulticaster((PropertyInterface)this.bars.elementAt(0));
            for (int i3 = 1; i3 < this.bars.size(); ++i3) {
                pm.addListener((PropertyInterface)this.bars.elementAt(i3));
            }
            this.dialog.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Bar.txt", (String)"Bar"), (TabPanelInterface)new BarPanel((PropertyInterface)pm));
        }
        if (this.pies.size() > 0) {
            PropertyMulticaster pm = new PropertyMulticaster((PropertyInterface)this.pies.elementAt(0));
            for (int i4 = 1; i4 < this.pies.size(); ++i4) {
                pm.addListener((PropertyInterface)this.pies.elementAt(i4));
            }
            this.dialog.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Pie.txt", (String)"Pie"), (TabPanelInterface)new PiePanel((PropertyInterface)pm));
        }
        if (this.histograms.size() > 0) {
            PropertyMulticaster pm = new PropertyMulticaster((PropertyInterface)this.histograms.elementAt(0));
            for (int i5 = 1; i5 < this.histograms.size(); ++i5) {
                pm.addListener((PropertyInterface)this.histograms.elementAt(i5));
            }
            this.dialog.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Bins.txt", (String)"Bins"), (TabPanelInterface)new HistogramPanel((PropertyInterface)pm));
        }
        if (this.constellations.size() > 0) {
            PropertyMulticaster pm = new PropertyMulticaster((PropertyInterface)this.constellations.elementAt(0));
            for (int i6 = 1; i6 < this.constellations.size(); ++i6) {
                pm.addListener((PropertyInterface)this.constellations.elementAt(i6));
            }
            this.dialog.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Nodes.txt", (String)"Nodes"), (TabPanelInterface)new NodesPanel((PropertyInterface)pm, (ConstComponent)this.constellations.elementAt(0)));
            this.dialog.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Links.txt", (String)"Links"), (TabPanelInterface)new LinksPanel((PropertyInterface)pm, (ConstComponent)this.constellations.elementAt(0)));
        }
        if (this.histograms.size() > 0 || this.scatters.size() > 0 || this.bars.size() > 0) {
            AxisInterface y;
            AxisInterface x;
            GraphInterface g;
            Vector<AxisInterface> xAxes = new Vector<AxisInterface>();
            Vector<AxisInterface> yAxes = new Vector<AxisInterface>();
            if (this.histograms.size() > 0) {
                for (i = 0; i < this.histograms.size(); ++i) {
                    g = (GraphInterface)this.histograms.elementAt(i);
                    x = g.getAxis((Object)"X");
                    y = g.getAxis((Object)"Y");
                    if (x != null) {
                        xAxes.addElement(x);
                    }
                    if (y == null) continue;
                    yAxes.addElement(y);
                }
            }
            if (this.bars.size() > 0) {
                for (i = 0; i < this.bars.size(); ++i) {
                    g = (GraphInterface)this.bars.elementAt(i);
                    x = g.getAxis((Object)"X");
                    y = g.getAxis((Object)"Y");
                    if (x != null) {
                        xAxes.addElement(x);
                    }
                    if (y == null) continue;
                    yAxes.addElement(y);
                }
            }
            if (this.scatters.size() > 0) {
                for (i = 0; i < this.scatters.size(); ++i) {
                    g = (GraphInterface)this.scatters.elementAt(i);
                    x = g.getAxis((Object)"X");
                    y = g.getAxis((Object)"Y");
                    if (x != null) {
                        xAxes.addElement(x);
                    }
                    if (y == null) continue;
                    yAxes.addElement(y);
                }
            }
            PropertyMulticaster yPm = null;
            PropertyMulticaster xPm = null;
            if (xAxes.size() > 0) {
                xPm = new PropertyMulticaster((PropertyInterface)xAxes.elementAt(0));
                for (int i7 = 1; i7 < xAxes.size(); ++i7) {
                    xPm.addListener((PropertyInterface)xAxes.elementAt(i7));
                }
            }
            if (xAxes.size() > 0) {
                yPm = new PropertyMulticaster((PropertyInterface)yAxes.elementAt(0));
                for (int i8 = 1; i8 < yAxes.size(); ++i8) {
                    yPm.addListener((PropertyInterface)yAxes.elementAt(i8));
                }
            }
            if (xPm != null || yPm != null) {
                this.dialog.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Axes.txt", (String)"Axes"), (TabPanelInterface)new AxisPanel((PropertyInterface)xPm, (PropertyInterface)yPm));
            }
        }
        this.whereDialog = new JDialog((Frame)c, ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.Where_clause_builder.txt", (String)"Where clause builder"), true);
        this.whereDialog.setSize(600, 425);
        Container con = this.whereDialog.getContentPane();
        con.setLayout(new BorderLayout());
        panel = new WherePanel();
        panel.setData((Object)this);
        for (i = 1; i < this.graphs.size(); ++i) {
            panel.addListener(this.graphs.elementAt(i));
        }
        JPanel pan = new JPanel(new FlowLayout(2));
        JButton button = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"GridLayoutComponent.OK.txt", (String)"OK"));
        button.setActionCommand("CloseWhere");
        button.addActionListener(this);
        pan.add(button);
        con.add("South", pan);
        button.setFont(TabbedPropertiesDialog.dialogFont);
        con.add("Center", (Component)panel);
    }

    private void init(LayoutNode node) {
        if (node == null) {
            return;
        }
        JComponent[] components = node.getChildren();
        if (components == null) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof LayoutNode) {
                this.init((LayoutNode)components[i]);
                continue;
            }
            this.setupChart(components[i]);
        }
    }

    private void setupChart(JComponent component) {
        ComponentInterface graph;
        int i;
        if (component == null) {
            return;
        }
        MouseListener[] mouseListeners = component.getMouseListeners();
        if (mouseListeners != null) {
            for (i = 0; i < mouseListeners.length; ++i) {
                component.removeMouseListener(mouseListeners[i]);
            }
        }
        component.addMouseListener(this);
        if (mouseListeners != null) {
            for (i = 0; i < mouseListeners.length; ++i) {
                component.addMouseListener(mouseListeners[i]);
            }
        }
        if (component instanceof ComponentInterface && (graph = (ComponentInterface)component) instanceof PropertyInterface) {
            this.graphs.addElement(graph);
        }
        if (component instanceof ScatterComponent) {
            this.scatters.addElement(component);
        } else if (component instanceof BarComponent) {
            this.bars.addElement(component);
        } else if (component instanceof PieComponent) {
            this.pies.addElement(component);
        } else if (component instanceof HistogramComponent) {
            this.histograms.addElement(component);
        } else if (component instanceof ConstComponent) {
            ((ConstComponent)component).addChartMouseListener(this);
            this.constellations.addElement(component);
        } else if (component instanceof TreeviewComponent) {
            ((TreeviewComponent)component).addChartMouseListener(this);
            this.treeviews.addElement(component);
        } else if (component instanceof LatticeComponent) {
            ((LatticeComponent)((Object)component)).enablePopup(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equalsIgnoreCase("Properties")) {
            this.dialog.setVisible(true);
            return;
        } else if (command.equalsIgnoreCase("Where")) {
            this.whereDialog.setVisible(true);
            return;
        } else if (command.equalsIgnoreCase("CloseWhere")) {
            this.whereDialog.setVisible(false);
            return;
        } else if (command.equalsIgnoreCase("Toolbar")) {
            if (this.toolbar == null) return;
            this.toolbar.setVisible(true);
            return;
        } else if (command.equalsIgnoreCase("ChartProperties")) {
            if (this.selectedChart == null) {
                return;
            }
            Dialog d = this.selectedChart.getDialog((Object)"Properties", null);
            if (d == null) return;
            d.setVisible(true);
            return;
        } else if (command.equalsIgnoreCase("ChartData")) {
            if (this.selectedChart == null) {
                return;
            }
            Dialog d = this.selectedChart.getDialog((Object)"Data", null);
            if (d == null) return;
            d.setVisible(true);
            return;
        } else if (command.equalsIgnoreCase("Reset")) {
            if (this.selectedChart == null) {
                return;
            }
            if (!(this.selectedChart instanceof GraphInterface)) return;
            ((GraphInterface)this.selectedChart).setActionMode(5);
            return;
        } else if (command.equalsIgnoreCase("PrintAll")) {
            Print.print((Object)this);
            return;
        } else {
            if (!command.equalsIgnoreCase("PrintComponent")) return;
            if (this.selectedChart == null) {
                return;
            }
            Print.print((Object)((Printable)this.selectedChart));
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        Container con;
        int x = me.getX();
        int y = me.getY();
        if (me.getSource() instanceof ComponentInterface) {
            this.selectedChart = (ComponentInterface)me.getSource();
        } else if (me.getSource() instanceof JTable) {
            for (con = ((Container)me.getSource()).getParent(); con != null && !(con instanceof ComponentInterface); con = con.getParent()) {
            }
            if (con != null && con instanceof ComponentInterface) {
                this.selectedChart = (ComponentInterface)con;
            }
        } else if (me.getSource() instanceof NLDViewer) {
            for (con = ((Component)me.getSource()).getParent(); con != null && !(con instanceof ComponentInterface); con = con.getParent()) {
            }
            if (con != null && con instanceof ComponentInterface) {
                this.selectedChart = (ComponentInterface)con;
            }
        }
        int flags = me.getModifiers();
        if ((flags & 4) != 0) {
            this.buildMenu();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)graphics;
            g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            Dimension d = this.getSize();
            double scaleX = pageFormat.getImageableWidth() / (double)d.width;
            double scaleY = pageFormat.getImageableHeight() / (double)d.height;
            double scale = Math.min(scaleX, scaleY);
            AffineTransform defaultXfm = g2.getTransform();
            AffineTransform xfm = new AffineTransform(defaultXfm);
            xfm.scale(scale, scale);
            g2.setTransform(xfm);
            this.paint(g2);
            return 0;
        }
        return 1;
    }

    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        boolean rc = false;
        for (int i = 0; i < this.graphs.size(); ++i) {
            rc |= ((ComponentInterface)this.graphs.elementAt(i)).applyWhereClause(clause, clearPrevious);
        }
        return rc;
    }

    public boolean areChartTipsOn() {
        return false;
    }

    public void dispose() {
        this.removeMyMouseListeners(this.root);
        this.root.dispose();
        this.removeAll();
    }

    public void removeMyMouseListeners() {
        this.removeMyMouseListeners(this.root);
    }

    private void removeMyMouseListeners(JComponent c) {
        JComponent[] arr;
        if (c == null) {
            return;
        }
        if (c instanceof LayoutNode && (arr = ((LayoutNode)c).getChildren()) != null) {
            for (int i = 0; i < arr.length; ++i) {
                this.removeMyMouseListeners(arr[i]);
            }
        }
        c.removeMouseListener(this);
    }

    public void enablePopup(boolean on) {
    }

    public TipInterface getChartTip() {
        return null;
    }

    public ColorSchemeInterface getColorScheme() {
        return null;
    }

    public String getColorSchemeName() {
        return null;
    }

    public Dialog getDialog(Object id, Object listener) {
        return null;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    public DataFilterReadInterface getFilter() {
        if (this.graphs.size() <= 0) {
            return null;
        }
        return ((ComponentInterface)this.graphs.elementAt(0)).getFilter();
    }

    public DataFilterReadInterface getFilter(Object id) {
        return this.getFilter();
    }

    public TextStyleInterface getFootnote(int index) {
        return null;
    }

    public String getStyle() {
        return null;
    }

    public TextStyleInterface getTitle(int index) {
        return null;
    }

    public String getWhereClause() {
        return null;
    }

    public boolean isDataListening() {
        return false;
    }

    public void setChartTipsOn(boolean on) {
    }

    public boolean setColorScheme(Object newScheme) {
        return false;
    }

    public boolean setDataListening(boolean listen) {
        return false;
    }

    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        return false;
    }

    public boolean setFootnote(int index, String textString) {
        return false;
    }

    public boolean setFootnote(int index, TextStyleInterface textObject) {
        return false;
    }

    public boolean setStyle(Object newStyle) {
        return false;
    }

    public boolean setTitle(int index, String textString) {
        return false;
    }

    public boolean setTitle(int index, TextStyleInterface textObject) {
        return false;
    }

    public JPopupMenu getPopupMenu() {
        return this.menu;
    }

    public boolean getUsageMode(int mode) {
        return false;
    }

    public void setUsageMode(int mode, boolean on) {
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object idIn) {
        this.id = idIn;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean setEditable(boolean editable) {
        return false;
    }

    public boolean setActionMode(int mode) {
        return false;
    }

    public int getActionMode() {
        return 0;
    }

    public Object getChart(Object id) {
        return null;
    }

    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    public boolean isBackBufferDrawEnabled() {
        return false;
    }

    public void setBackBufferDrawEnabled(boolean drawback) {
    }

    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    public boolean isActionEnabled(String action) {
        return true;
    }

    public AnnotateInterface getAnnotate() {
        return null;
    }

    public void addDrilldownListener(DrilldownListenerInterface dli) {
        if (dli != null) {
            this.drilldownListeners.addElement(dli);
        }
    }

    public void removeDrilldownListener(DrilldownListenerInterface dli) {
        if (dli != null && this.drilldownListeners.contains(dli)) {
            this.drilldownListeners.removeElement(dli);
        }
    }

    protected void fireDrilldownEvent(String s) {
        DrilldownEvent de = new DrilldownEvent(s);
        for (int i = 0; i < this.drilldownListeners.size(); ++i) {
            ((DrilldownListenerInterface)this.drilldownListeners.elementAt(i)).drilldown(de);
        }
    }
}

