/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.dendrogram.DendrogramChart;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.GraphPropertyInterface;
import com.sas.graphics.silk.interfaces.GraphToolbarInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PrintInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.ui.AxisPanel;
import com.sas.graphics.silk.ui.DendrogramPanel;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.ViewportWarningIcon;
import com.sas.graphics.util.PropertyEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class DendrogramComponent
extends SILKComponent
implements UpdateInterface,
PrintInterface,
Printable,
RedrawListener,
TextListenerInterface,
CellItemInterface,
DataRangeInterface,
PropertyInterface,
GraphPropertyInterface {
    private static final long serialVersionUID = -4861889264624799563L;
    protected static final int BORDER = 5;
    protected static final int MIN_WIDTH = 1;
    protected static final int MIN_HEIGHT = 1;
    protected static final int ERROR_DATA = 1;
    protected static final int ERROR_SPACE = 2;
    protected static final int NONE = 0;
    protected static final int MOVE = 1;
    protected static final int RESIZE_L = 2;
    protected static final int RESIZE_R = 3;
    protected static final int RESIZE_T = 4;
    protected static final int RESIZE_B = 5;
    protected static final int RESIZE_TL = 6;
    protected static final int RESIZE_TR = 7;
    protected static final int RESIZE_BL = 8;
    protected static final int RESIZE_BR = 9;
    protected static final int MIN_SIZE = 4;
    protected static final int HANDLE_SIZE = 6;
    protected int viewportX = 0;
    protected int viewportY = 0;
    protected int viewportWidth;
    protected int viewportHeight;
    protected Rectangle chartClipRect;
    protected Image backBuffer = null;
    protected Image backBuffer2 = null;
    protected Image backImage = null;
    protected DendrogramChart tree = null;
    protected Axes treeAxis = null;
    protected Axes heightAxis = null;
    protected LegendObjectJ2D legend = null;
    protected boolean wallOn = true;
    protected GraphBackground wall;
    protected Rectangle rubberband = null;
    protected Color brushColor;
    protected Point startPt;
    protected boolean rectSelection = false;
    protected int error = 0;
    protected boolean brushMode = false;
    protected int brushAction;
    protected Rectangle2D.Double resizeL;
    protected Rectangle2D.Double resizeR;
    protected Rectangle2D.Double resizeT;
    protected Rectangle2D.Double resizeB;
    protected Rectangle2D.Double resizeTL;
    protected Rectangle2D.Double resizeTR;
    protected Rectangle2D.Double resizeBL;
    protected Rectangle2D.Double resizeBR;
    protected boolean redrawBKBuffer = true;
    protected boolean updateComp = true;
    protected boolean mouseAction = false;
    protected Cursor openMoveCursor;
    protected Cursor closeMoveCursor;
    protected Image openMoveImage;
    protected Image closeMoveImage;
    protected JPopupMenu popup;
    protected boolean addPanels;
    protected Action tBar;
    protected boolean userSetToolbar;
    protected ArrayList marginListeners;
    protected ArrayList rangeListeners;
    protected ArrayList propertyIndex;
    protected ArrayList propertyValue;
    protected int selectedAxis;
    protected boolean applyingChanges;
    protected boolean hScrollbarOn;
    protected boolean vScrollbarOn;
    protected DendrogramComponent instance = null;
    protected int vBarRightMargin;
    protected ArrayList viewportListeners;
    protected Graphics gc;
    protected AxisZoomPanHandler treeHandler;
    protected AxisZoomPanHandler heightHandler;
    protected boolean onTreeAxis;
    protected boolean onHeightAxis;
    protected ViewportWarningIcon warningIcon = null;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.dendrogram.dendrogram_NLS");
    public static int[] supportedProperties = new int[]{26, 0, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 32, 33, 34, 23, 443, 402, 604, 605, 606, 607, 608, 601, 609, 610, 602, 611, 612, 603, 238};

    public DendrogramComponent() {
        this.viewportWidth = this.compWidth;
        this.viewportHeight = this.compHeight;
        this.chartClipRect = new Rectangle(this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
        this.brushColor = Color.black;
        this.wall = new GraphBackground((JComponent)((Object)this));
        this.openMoveImage = ResourceLoader.getImage((Component)((Object)this), (String)"icons/MoveOpen.gif");
        this.closeMoveImage = ResourceLoader.getImage((Component)((Object)this), (String)"icons/MoveClosed.gif");
        this.setStyle(SILKGlobal.getInstance().getPropertyValue(29));
        this.setDoubleBuffered(false);
        this.popup = null;
        this.addPanels = false;
        this.userSetToolbar = false;
        this.actionMode = 6;
        this.marginListeners = new ArrayList();
        this.rangeListeners = new ArrayList();
        this.viewportListeners = new ArrayList();
        this.propertyIndex = new ArrayList();
        this.propertyValue = new ArrayList();
        this.selectedAxis = 0;
        this.applyingChanges = false;
        this.instance = this;
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        this.userSetProperties.appendProperties(supportedProperties);
        this.warningIcon = new ViewportWarningIcon((Component)((Object)this));
    }

    protected GraphPropertiesDialog getPropertyDialog() {
        this.createPropertyDialog(this);
        this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"DendrogramComponent.Graph.txt", (String)"Graph"), (Component)new GraphPanel((PropertyInterface)this, (PropertyInterface)this.tooltip));
        this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"DendrogramComponent.Tree.txt", (String)"Tree"), (Component)new DendrogramPanel(this.tree));
        this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"DendrogramComponent.Axis.txt", (String)"Axis"), (Component)new AxisPanel((PropertyInterface)this, (PropertyInterface)this));
        this.propertiesDialog.addRootNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"DendrogramComponent.TitleFootnote.txt", (String)"Title/Footnote"), (Component)new TitlePanel((PropertyInterface)this, (JComponent)((Object)this)));
        this.propertiesDialog.setSelectedNode((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"DendrogramComponent.Tree.txt", (String)"Tree"));
        this.propertiesDialog.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"DendrogramComponent.DendrogramPropertiesDialogTitle.txt", (String)"Dendrogram Properties"));
        this.addPanels = true;
        return this.propertiesDialog;
    }

    public void printComponent() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf = job.pageDialog(job.defaultPage());
        job.setPrintable(this, pf);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected Insets getComponentMargin() {
        this.graphLayout.doLayout((JComponent)((Object)this));
        if (this.tree == null || !this.tree.isValid()) {
            return new Insets(this.yMargin + this.getTitleHeight(), 0, this.yMargin + this.getFootnoteHeight(), 0);
        }
        Insets margin = new Insets(this.yMargin, this.xMargin, this.yMargin, this.xMargin);
        margin.top += this.getTitleHeight();
        margin.bottom += this.getFootnoteHeight();
        if (this.legend != null && this.legend.isVisible()) {
            Dimension d = this.legend.getPreferredSize();
            if (d.width > 0 && d.height > 0) {
                switch (this.legend.getPosition()) {
                    case 2: {
                        margin.bottom += d.height + 5;
                        break;
                    }
                    case 1: {
                        margin.top += d.height + 5;
                        break;
                    }
                    case 3: {
                        margin.right += d.width + 5;
                        break;
                    }
                    case 4: {
                        margin.left += d.width + 5;
                    }
                }
            }
        }
        return margin;
    }

    protected int getTitleHeight() {
        int h = 0;
        if (this.graphLayout.getTitle() != null) {
            Rectangle r = this.graphLayout.getTitle().getBounds();
            h = r.height;
        }
        return h;
    }

    protected int getFootnoteHeight() {
        int h = 0;
        if (this.graphLayout.getFootnote() != null) {
            Rectangle r = this.graphLayout.getFootnote().getBounds();
            h += r.height;
        }
        return h;
    }

    protected void setColorsToAxis(Axes axis) {
        if (axis == null) {
            return;
        }
        axis.applyStyle(this.style);
    }

    private boolean isDataAssigned() {
        if (this.getFilter() == null) {
            return false;
        }
        return this.tree.isDataAssigned();
    }

    protected void updateComponent() {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        if (!this.isDataAssigned()) {
            return;
        }
        this.tree.setChartAreaDimension(new Dimension(this.compWidth, this.compHeight));
        this.tree.setChartClipArea(new Rectangle(0, 0, this.compWidth, this.compHeight));
        Insets om = this.tree.getOuterMargin((Graphics2D)this.gc);
        Insets compMargin = this.getComponentMargin();
        Rectangle clip = new Rectangle(compMargin.left + om.left, compMargin.top + om.top, this.compWidth - compMargin.left - om.left - compMargin.right - om.right, this.compHeight - compMargin.top - om.top - compMargin.bottom - om.bottom);
        this.tree.setChartClipArea(clip);
        this.chartClipRect.setRect(clip);
        this.redrawBKBuffer = true;
        this.updateComp = false;
    }

    protected void doResize(int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (width == this.compWidth && height == this.compHeight) {
            return;
        }
        this.compWidth = width;
        this.compHeight = height;
        if (this.useBackBuffer) {
            if (this.backBuffer == null || width > this.backBuffer.getWidth((ImageObserver)((Object)this)) || height > this.backBuffer.getHeight((ImageObserver)((Object)this))) {
                if (this.backBuffer != null) {
                    this.backBuffer.flush();
                }
                this.backBuffer = this.createImage(width, height);
            }
            if (this.backBuffer2 == null || width > this.backBuffer2.getWidth((ImageObserver)((Object)this)) || height > this.backBuffer2.getHeight((ImageObserver)((Object)this))) {
                if (this.backBuffer2 != null) {
                    this.backBuffer2.flush();
                }
                this.backBuffer2 = this.createImage(width, height);
            }
        }
        this.viewportWidth = this.compWidth;
        this.viewportHeight = this.compHeight;
        this.updateComp = true;
        this.redrawBKBuffer = true;
    }

    protected void paintComponent(Graphics g) {
        this.gc = g;
        if (this.applyingChanges) {
            return;
        }
        if (this.tree == null) {
            return;
        }
        if (this.useBackBuffer && (this.backBuffer == null || this.backBuffer2 == null)) {
            return;
        }
        if (this.isRebuildRequired()) {
            this.build(null);
        }
        if ((this.error & 1) != 0) {
            this.drawErrorMessage(g);
            return;
        }
        if (this.updateComp) {
            this.updateComponent();
        }
        if (!this.useBackBuffer || this.redrawBKBuffer) {
            this.drawToBackBuffer(g);
        }
        if (!this.useBackBuffer) {
            return;
        }
        if (this.isHighlightRequired() || this.brushMode && this.rubberband != null) {
            Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
            backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, (ImageObserver)((Object)this));
            if (this.tree.isHighlightRequired()) {
                Rectangle treeClipRect = this.tree.getChartClipArea();
                backGraphics2.setClip(treeClipRect.x, treeClipRect.y, treeClipRect.width + 1, treeClipRect.height + 1);
                this.tree.drawHighlight(backGraphics2);
                backGraphics2.setClip(0, 0, this.compWidth, this.compHeight);
            }
            if (this.brushMode && this.rubberband != null) {
                backGraphics2.setColor(this.brushColor);
                backGraphics2.draw(this.rubberband);
            }
            g.drawImage(this.backBuffer2, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, (ImageObserver)((Object)this));
            backGraphics2.dispose();
        } else {
            g.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, (ImageObserver)((Object)this));
        }
        if (this.onTreeAxis) {
            this.treeHandler.drawZoomPanIndicator(g);
        }
        if (this.onHeightAxis) {
            this.heightHandler.drawZoomPanIndicator(g);
        }
        if (this.treeAxis.isVisible()) {
            this.treeHandler.drawViewportIndicator(g);
        }
        if (this.heightAxis.isVisible()) {
            this.heightHandler.drawViewportIndicator(g);
        }
        this.warningIcon.draw(g);
    }

    private boolean isHighlightRequired() {
        return this.tree.isHighlightRequired();
    }

    public String getToolTipText(MouseEvent e) {
        int y;
        String toolTipText = null;
        int x = e.getX();
        if (this.warningIcon.isMouseOverIcon(x, y = e.getY())) {
            return this.warningIcon.getTooltipText();
        }
        if (this.tree.getChartClipArea() != null && this.tree.getChartClipArea().contains(x, y)) {
            toolTipText = this.tree.getToolTipText(x, y);
        }
        return toolTipText;
    }

    protected void drawErrorMessage(Graphics g) {
        if (g == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String errorMessage = "";
        if ((this.error & 1) != 0) {
            errorMessage = ResourceLoader.getResourceString((Object)this.rb, (String)"DendrogramComponent.DataNotAssigned.txt", (String)"Data is not assigned correctly.");
        } else if ((this.error & 2) != 0) {
            errorMessage = ResourceLoader.getResourceString((Object)this.rb, (String)"DendrogramComponent.GraphAreaSmall.txt", (String)"Graph area is too small.");
        }
        Font f = this.heightAxis.getLabel().getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout errorString = new TextLayout(errorMessage, f, frc);
        Rectangle2D bounds = errorString.getBounds();
        g2.setColor(Color.red);
        errorString.draw(g2, 0.0f, (float)bounds.getHeight());
    }

    protected void drawZeroObservation(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Font f = this.heightAxis.getLabel().getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        String msg = ResourceLoader.getResourceString((Object)this.rb, (String)"DendrogramComponent.NoData.txt", (String)"No Data");
        TextLayout msgString = new TextLayout(msg, f, frc);
        Rectangle2D bounds = msgString.getBounds();
        double x = this.chartClipRect.getX() + (this.chartClipRect.getWidth() - bounds.getWidth()) * 0.5;
        double y = this.chartClipRect.getY() + this.chartClipRect.getHeight() * 0.5;
        msgString.draw(g2, (float)x, (float)y);
    }

    protected void drawToBackBuffer(Graphics g) {
        Graphics2D g2 = !this.useBackBuffer ? (Graphics2D)g : (Graphics2D)this.backBuffer.getGraphics();
        this.background.drawBackground(g2, (Component)((Object)this), new Rectangle(0, 0, this.compWidth, this.compHeight));
        if (this.wall != null && this.wallOn) {
            this.wall.drawBackground(g2, (Component)((Object)this), this.chartClipRect);
        }
        if (this.tree.getHeightAxis() != null && this.tree.isValid()) {
            this.tree.getHeightAxis().draw((Object)g2, false);
            this.tree.getHeightAxis().drawReferenceLines((Graphics)g2);
            this.tree.getHeightAxis().drawReferenceRanges(g2);
        }
        if (this.tree.getTreeAxis() != null && this.tree.isValid()) {
            this.tree.getTreeAxis().draw((Object)g2, false);
            this.tree.getTreeAxis().drawReferenceLines((Graphics)g2);
            this.tree.getTreeAxis().drawReferenceRanges(g2);
        }
        Rectangle treeClipRect = this.tree.getChartClipArea();
        g2.setClip(treeClipRect.x, treeClipRect.y, treeClipRect.width + 1, treeClipRect.height + 1);
        this.tree.draw(g2, !this.useBackBuffer);
        g2.setClip(0, 0, this.compWidth, this.compHeight);
        this.graphLayout.draw((Graphics)g2);
        if (!this.useBackBuffer) {
            return;
        }
        Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
        backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, (ImageObserver)((Object)this));
        g2.dispose();
        backGraphics2.dispose();
        this.redrawBKBuffer = false;
    }

    protected void brushing(Point pt) {
        int chartClipX = this.chartClipRect.x;
        int chartClipY = this.chartClipRect.y;
        int chartClipWidth = this.chartClipRect.width;
        int chartClipHeight = this.chartClipRect.height;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        switch (this.brushAction) {
            case 1: {
                x = this.rubberband.x + (pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, chartClipX + chartClipWidth - this.rubberband.width);
                y = this.rubberband.y + (pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, chartClipY + chartClipHeight - this.rubberband.height);
                width = this.rubberband.width;
                height = this.rubberband.height;
                break;
            }
            case 2: {
                x = this.rubberband.x + (pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4);
                y = this.rubberband.y;
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height;
                break;
            }
            case 3: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width + (pt.x - this.startPt.x);
                width = Math.max(width, 4);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height;
                break;
            }
            case 4: {
                x = this.rubberband.x;
                y = this.rubberband.y + (pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4);
                width = this.rubberband.width;
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 5: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width;
                height = this.rubberband.height + (pt.y - this.startPt.y);
                height = Math.max(height, 4);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            case 6: {
                x = this.rubberband.x + (pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4);
                y = this.rubberband.y + (pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4);
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 7: {
                x = this.rubberband.x;
                y = this.rubberband.y + (pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4);
                width = this.rubberband.width + (pt.x - this.startPt.x);
                width = Math.max(width, 4);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 8: {
                x = this.rubberband.x + (pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4);
                y = this.rubberband.y;
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height + (pt.y - this.startPt.y);
                height = Math.max(height, 4);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            case 9: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width + (pt.x - this.startPt.x);
                width = Math.max(width, 4);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height + (pt.y - this.startPt.y);
                height = Math.max(height, 4);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            default: {
                return;
            }
        }
        this.rubberband.x = x;
        this.rubberband.y = y;
        this.rubberband.width = width;
        this.rubberband.height = height;
        this.tree.setSelection(this.rubberband, false);
        this.startPt = pt;
        this.repaint();
    }

    protected void setCursorShape(int action, boolean down) {
        switch (action) {
            case 2: {
                this.setCursor(new Cursor(10));
                break;
            }
            case 3: {
                this.setCursor(new Cursor(11));
                break;
            }
            case 4: {
                this.setCursor(new Cursor(8));
                break;
            }
            case 5: {
                this.setCursor(new Cursor(9));
                break;
            }
            case 6: {
                this.setCursor(new Cursor(6));
                break;
            }
            case 7: {
                this.setCursor(new Cursor(7));
                break;
            }
            case 8: {
                this.setCursor(new Cursor(4));
                break;
            }
            case 9: {
                this.setCursor(new Cursor(5));
                break;
            }
            case 1: {
                Toolkit tk = Toolkit.getDefaultToolkit();
                if (down) {
                    this.setCursor(tk.createCustomCursor(this.closeMoveImage, new Point(6, 2), "icons/MoveClosed.gif"));
                    break;
                }
                this.setCursor(tk.createCustomCursor(this.openMoveImage, new Point(6, 2), "icons/MoveOpen.gif"));
                break;
            }
            default: {
                this.setCursor(new Cursor(0));
            }
        }
    }

    protected int getMouseSpot(Point pt) {
        int spot = 0;
        if (this.resizeL.contains(pt)) {
            spot = 2;
        } else if (this.resizeR.contains(pt)) {
            spot = 3;
        }
        if (spot == 0) {
            if (this.resizeT.contains(pt)) {
                spot = 4;
            } else if (this.resizeB.contains(pt)) {
                spot = 5;
            } else if (this.resizeTL.contains(pt)) {
                spot = 6;
            } else if (this.resizeTR.contains(pt)) {
                spot = 7;
            } else if (this.resizeBL.contains(pt)) {
                spot = 8;
            } else if (this.resizeBR.contains(pt)) {
                spot = 9;
            }
        }
        if (spot == 0 && this.rubberband.contains(pt)) {
            spot = 1;
        }
        return spot;
    }

    protected void createHandleRects() {
        if ((double)this.rubberband.width > 24.0 && (double)this.rubberband.height > 24.0) {
            this.resizeL = new Rectangle2D.Double((double)this.rubberband.x - 3.0, (double)this.rubberband.y + 0.5 * (double)this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeR = new Rectangle2D.Double((double)(this.rubberband.x + this.rubberband.width) - 3.0, (double)this.rubberband.y + 0.5 * (double)this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeT = new Rectangle2D.Double((double)this.rubberband.x + (double)this.rubberband.width * 0.5 - 3.0, (double)this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeB = new Rectangle2D.Double((double)this.rubberband.x + (double)this.rubberband.width * 0.5 - 3.0, (double)(this.rubberband.y + this.rubberband.height) - 3.0, 6.0, 6.0);
            this.resizeTL = new Rectangle2D.Double((double)this.rubberband.x - 3.0, (double)this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeTR = new Rectangle2D.Double((double)(this.rubberband.x + this.rubberband.width) - 3.0, (double)this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeBL = new Rectangle2D.Double((double)this.rubberband.x - 3.0, (double)(this.rubberband.y + this.rubberband.height) - 3.0, 6.0, 6.0);
            this.resizeBR = new Rectangle2D.Double((double)(this.rubberband.x + this.rubberband.width) - 3.0, (double)(this.rubberband.y + this.rubberband.height) - 3.0, 6.0, 6.0);
        } else {
            this.resizeL = new Rectangle2D.Double(this.rubberband.x - 6, (double)this.rubberband.y + 0.5 * (double)this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, (double)this.rubberband.y + 0.5 * (double)this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeT = new Rectangle2D.Double((double)this.rubberband.x + (double)this.rubberband.width * 0.5 - 3.0, this.rubberband.y - 6, 6.0, 6.0);
            this.resizeB = new Rectangle2D.Double((double)this.rubberband.x + (double)this.rubberband.width * 0.5 - 3.0, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
            this.resizeTL = new Rectangle2D.Double(this.rubberband.x - 6, this.rubberband.y - 6, 6.0, 6.0);
            this.resizeTR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y - 6, 6.0, 6.0);
            this.resizeBL = new Rectangle2D.Double(this.rubberband.x - 6, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
            this.resizeBR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
        }
    }

    protected void dragRubberband(Point pt) {
        if (Math.abs(pt.x - this.startPt.x) < 5 || Math.abs(pt.y - this.startPt.y) < 5) {
            return;
        }
        this.rectSelection = true;
        if (this.rubberband == null) {
            this.rubberband = new Rectangle();
        }
        if (this.rubberband != null) {
            int x1 = Math.min(this.startPt.x, pt.x);
            int x2 = Math.max(this.startPt.x, pt.x);
            x1 = Math.max(x1, this.chartClipRect.x);
            x2 = Math.min(x2, this.chartClipRect.x + this.chartClipRect.width);
            int y1 = Math.min(this.startPt.y, pt.y);
            int y2 = Math.max(this.startPt.y, pt.y);
            y1 = Math.max(y1, this.chartClipRect.y);
            y2 = Math.min(y2, this.chartClipRect.y + this.chartClipRect.height);
            if (this.actionMode == 2) {
                if (this.tree.getOrientation() == 0) {
                    x1 = this.chartClipRect.x;
                    x2 = this.chartClipRect.x + this.chartClipRect.width;
                } else {
                    y1 = this.chartClipRect.y;
                    y2 = this.chartClipRect.y + this.chartClipRect.height;
                }
            }
            this.rubberband.x = x1;
            this.rubberband.y = y1;
            this.rubberband.width = x2 - x1;
            this.rubberband.height = y2 - y1;
        }
        if (!this.useBackBuffer) {
            return;
        }
        Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
        backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, (ImageObserver)((Object)this));
        if (this.tree.isHighlightRequired()) {
            Rectangle treeClipRect = this.tree.getChartClipArea();
            backGraphics2.setClip(treeClipRect.x, treeClipRect.y, treeClipRect.width + 1, treeClipRect.height + 1);
            this.tree.drawHighlight(backGraphics2);
            backGraphics2.setClip(0, 0, this.compWidth, this.compHeight);
        }
        if (this.rubberband != null) {
            backGraphics2.setColor(this.brushColor);
            backGraphics2.setXORMode(Color.white);
            backGraphics2.draw(this.rubberband);
        }
        int x = this.chartClipRect.x;
        int y = this.chartClipRect.y;
        int w = this.chartClipRect.width;
        int h = this.chartClipRect.height;
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        g2.drawImage(this.backBuffer2, x, y, x + w, y + h, x, y, x + w, y + h, (ImageObserver)((Object)this));
        backGraphics2.dispose();
        g2.dispose();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        int oldWidth = this.compWidth;
        int oldHeight = this.compHeight;
        boolean backOn = this.useBackBuffer;
        this.useBackBuffer = false;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Rectangle bounds = this.getBounds();
        double width = pageFormat.getImageableWidth();
        double height = pageFormat.getImageableHeight();
        double s_aspect = (double)bounds.width / (double)bounds.height;
        double p_aspect = width / height;
        double p_width = width;
        double p_height = height;
        if (p_aspect <= 1.0) {
            if (s_aspect < 1.0 && s_aspect < p_aspect) {
                p_width = height * s_aspect;
            } else {
                p_height = width / s_aspect;
            }
        } else if (s_aspect > 1.0 && s_aspect > p_aspect) {
            p_height = width / s_aspect;
        } else {
            p_width = height * s_aspect;
        }
        this.doResize((int)p_width, (int)p_height);
        float tx = (float)((width - p_width) * 0.5);
        float ty = (float)((height - p_height) * 0.5);
        g2.translate(tx, ty);
        g2.setClip(0, 0, (int)p_width, (int)p_height);
        this.paint(graphics);
        this.useBackBuffer = backOn;
        this.doResize(oldWidth, oldHeight);
        return 0;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (this.tipsOn && this.tipText != null) {
            this.tipText = null;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.tree == null || this.error > 0) {
            return;
        }
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            return;
        }
        this.startPt = e.getPoint();
        if (this.onTreeAxis) {
            this.treeHandler.mousePressed(e);
            return;
        }
        if (this.onHeightAxis) {
            this.heightHandler.mousePressed(e);
            return;
        }
        if (this.brushMode && this.actionMode == 1) {
            this.brushAction = this.getMouseSpot(this.startPt);
            this.setCursorShape(this.brushAction, true);
            if (this.brushAction == 0) {
                this.brushMode = false;
            }
        } else {
            if (!this.chartClipRect.contains(this.startPt)) {
                return;
            }
            this.setCursor(new Cursor(0));
        }
        super.mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.tree == null) {
            return;
        }
        if (this.warningIcon.isMouseOverIcon(e.getX(), e.getY())) {
            this.tree.resetViewport();
            this.fireViewportChangeEvent();
            return;
        }
        if (this.onTreeAxis) {
            this.treeHandler.mouseReleased(e);
            return;
        }
        if (this.onHeightAxis) {
            this.heightHandler.mouseReleased(e);
            return;
        }
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            if (this.error == 0) {
                boolean fire = false;
                if (this.tree.getChartClipArea().contains(e.getX(), e.getY())) {
                    fire = this.tree.setCollapse(e.getX(), e.getY());
                }
                if (fire) {
                    this.repaint();
                    return;
                }
            }
            if (!this.allowPopup) {
                return;
            }
            if (this.popup == null) {
                this.popup = this.getPopupMenu();
                this.add(this.popup);
            }
            this.popup.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        if (this.error > 0) {
            return;
        }
        super.mouseReleased(e);
        if (this.brushMode && this.actionMode == 1) {
            this.setCursor(new Cursor(0));
            this.createHandleRects();
            return;
        }
        this.brushMode = false;
        if (this.rectSelection) {
            if (this.actionMode == 2) {
                this.tree.setViewport(3, this.rubberband.x, this.rubberband.x + this.rubberband.width, this.rubberband.y, this.rubberband.y + this.rubberband.height, 0.0, 0.0);
                this.fireViewportChangeEvent();
            } else if (this.actionMode == 1) {
                this.brushMode = true;
                this.mouseAction = true;
                this.tree.setSelection(this.rubberband, false);
                this.createHandleRects();
                this.mouseAction = false;
            } else if (this.actionMode == 6) {
                boolean extend;
                boolean bl = extend = e.isControlDown();
                if (this.tree.getChartClipArea().intersects(this.rubberband)) {
                    this.tree.setSelection(this.rubberband, extend);
                }
            }
            this.rectSelection = false;
        } else if (this.actionMode == 6) {
            boolean extend;
            boolean bl = extend = e.isControlDown();
            if (this.tree.getChartClipArea().contains(e.getX(), e.getY())) {
                this.tree.setSelection(e.getX(), e.getY(), extend);
            }
        } else if (this.actionMode == 1) {
            this.tree.setSelection(e.getX(), e.getY(), false);
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        if (this.tree == null || this.error > 0) {
            return;
        }
        this.onHeightAxis = false;
        this.onTreeAxis = false;
        if (!this.warningIcon.isMouseOverIcon(e.getX(), e.getY()) && this.treeHandler.isMouseInZoomPanArea(e)) {
            this.treeHandler.mouseMoved(e);
            this.onTreeAxis = true;
            this.tipText = null;
            return;
        }
        if (!this.warningIcon.isMouseOverIcon(e.getX(), e.getY()) && this.heightHandler.isMouseInZoomPanArea(e)) {
            this.heightHandler.mouseMoved(e);
            this.onHeightAxis = true;
            this.tipText = null;
            return;
        }
        this.startPt = e.getPoint();
        if (this.brushMode && this.actionMode == 1) {
            this.setCursorShape(this.getMouseSpot(this.startPt), false);
        } else {
            this.setCursor(new Cursor(0));
        }
        super.mouseMoved(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.tree == null || this.error > 0) {
            return;
        }
        if (this.dataFilter.getNumberObservations(-1) <= 0) {
            return;
        }
        if (this.onTreeAxis) {
            if (this.tree.isFisheyeView()) {
                this.tree.updateFisheyeFocusPoint(this.startPt, e.getPoint(), true);
            } else {
                this.treeHandler.mouseDragged(e);
            }
            return;
        }
        if (this.onHeightAxis) {
            if (this.tree.isFisheyeView()) {
                this.tree.updateFisheyeFocusPoint(this.startPt, e.getPoint(), false);
            } else {
                this.heightHandler.mouseDragged(e);
            }
            return;
        }
        Point pt = e.getPoint();
        switch (this.actionMode) {
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 2: 
            case 6: {
                this.dragRubberband(pt);
                break;
            }
            case 1: {
                if (this.brushMode) {
                    this.mouseAction = true;
                    this.brushing(pt);
                    this.mouseAction = false;
                    break;
                }
                this.dragRubberband(pt);
                break;
            }
        }
    }

    public void addViewportListener(Object listener) {
        if (listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (!this.viewportListeners.contains(listener)) {
            this.viewportListeners.add(listener);
        }
    }

    public void removeViewportListener(Object listener) {
        if (listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (this.viewportListeners.contains(listener)) {
            this.viewportListeners.remove(listener);
        }
    }

    protected void handleMenuCommand(String command) {
        if ("CHART_TYPE_HORIZONTAL".equalsIgnoreCase(command)) {
            this.tree.setOrientation(0);
        } else if ("CHART_TYPE_VERTICAL".equalsIgnoreCase(command)) {
            this.tree.setOrientation(1);
        } else {
            super.handleMenuCommand(command);
        }
    }

    protected void buildPropertiesDialog(Object listner) {
        if (this.propertiesDialog != null) {
            return;
        }
        this.getPropertyDialog();
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = MenuUtilities.getPopupMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/DendrogramMenu.xml"), (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String actionCommand = e.getActionCommand();
                    DendrogramComponent.this.handleMenuCommand(actionCommand);
                }
            });
        }
        if (this.tree.getOrientation() == 0) {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popup, (String)"CHART_TYPE_HORIZONTAL", (boolean)true);
        } else {
            MenuUtilities.setMenuItemSelected((JPopupMenu)this.popup, (String)"CHART_TYPE_VERTICAL", (boolean)true);
        }
        return this.popup;
    }

    public Component getToolBar() {
        Component tb = super.getToolBar();
        if (tb != null && tb instanceof GraphToolbarInterface && !this.userSetToolbar) {
            ((SILKToolbar)tb).setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"DendrogramComponent.DendrogramToolbar.txt", (String)"Dendrogram Toolbar"));
            ((SILKToolbar)tb).setButtonEnabled(1, false);
            ((SILKToolbar)tb).setButtonEnabled(4, false);
            ((SILKToolbar)tb).setButtonEnabled(3, false);
        }
        return tb;
    }

    public boolean setToolBar(Component toolBarIn) {
        if (toolBarIn != null) {
            if (this.toolBar == null && this.popup != null) {
                this.popup.insert(this.tBar, 1);
            }
            this.toolBar = toolBarIn;
            if (this.toolBar instanceof GraphToolbarInterface) {
                ((GraphToolbarInterface)this.toolBar).addListener((GraphInterface)this);
            }
        } else if (this.toolBar != null) {
            if (this.toolBar.isShowing()) {
                this.toolBar.setVisible(false);
            }
            this.toolBar = null;
            if (this.popup != null) {
                this.popup.remove(1);
            }
        }
        this.userSetToolbar = true;
        return true;
    }

    public boolean setActionMode(int mode) {
        boolean rc = true;
        if (mode == 5) {
            this.tree.resetViewport();
            this.fireViewportChangeEvent();
        } else {
            rc = super.setActionMode(mode);
        }
        if (this.actionMode != 1 && this.brushMode) {
            this.brushMode = false;
            this.repaint();
        }
        return rc;
    }

    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        if (!rc || this.style == null) {
            return rc;
        }
        this.wall.setSolidBackground((Object)this.style.getFillStyleElement("WallFill").getFillColor());
        this.graphLayout.getTitle().applyStyle(this.style);
        this.graphLayout.getFootnote().applyStyle(this.style);
        this.tooltip.applyStyle(this.style);
        if (this.heightAxis != null) {
            this.setColorsToAxis(this.heightAxis);
            this.heightHandler.setStyle(this.style);
        }
        if (this.treeAxis != null) {
            this.setColorsToAxis(this.treeAxis);
            this.treeHandler.setStyle(this.style);
        }
        this.setColorsToTree();
        return true;
    }

    public AxisInterface getAxis(Object which) {
        if (which == null || !(which instanceof String)) {
            return null;
        }
        if (((String)which).equalsIgnoreCase("X") || ((String)which).equalsIgnoreCase("XAxis")) {
            return this.tree.getOrientation() == 0 ? this.heightAxis : this.treeAxis;
        }
        if (((String)which).equalsIgnoreCase("Y") || ((String)which).equalsIgnoreCase("YAxis")) {
            return this.tree.getOrientation() == 0 ? this.treeAxis : this.heightAxis;
        }
        return null;
    }

    public LegendInterface getLegend(Object which) {
        return null;
    }

    public Object getLegendPosition(Object which) {
        return null;
    }

    public boolean setLegendPosition(Object which, Object pos) {
        return true;
    }

    public Rectangle getLegendBounds() {
        return null;
    }

    public boolean setLegendBounds(Rectangle rect) {
        return true;
    }

    public void dispose() {
        super.dispose();
        this.chartClipRect = null;
        this.rubberband = null;
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.backBuffer2 != null) {
            this.backBuffer2.flush();
        }
        this.backBuffer2 = null;
        this.backImage = null;
        this.tree = null;
        this.heightAxis = null;
        this.treeAxis = null;
        this.legend = null;
        this.wall = null;
        if (this.graphLayout.getTitle() != null) {
            this.graphLayout.getTitle().removeTextListener((TextListenerInterface)this);
        }
        if (this.graphLayout.getFootnote() != null) {
            // empty if block
        }
        this.graphLayout.getFootnote().removeTextListener((TextListenerInterface)this);
        this.popup = null;
        if (this.toolBar != null) {
            this.toolBar.setVisible(false);
        }
        this.toolBar = null;
        this.removeMouseListener((MouseListener)((Object)this));
        this.removeMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public Object getDataSource(Object id) {
        return super.getDataSource(id);
    }

    public boolean setDataSource(Object source, Object id) {
        boolean rc = super.setDataSource(source, id);
        if (!rc) {
            return rc;
        }
        return this.createTreeElement(source);
    }

    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    public Object getVariable(Object role) {
        if (this.tree == null) {
            return null;
        }
        return this.tree.getVariable(role);
    }

    public Object getRole(Object variableId) {
        if (this.tree == null) {
            return null;
        }
        return this.tree.getRole(variableId);
    }

    public boolean setRole(Object variableId, Object role) {
        if (this.tree == null || role == null) {
            return false;
        }
        return this.tree.setRole(variableId, role);
    }

    public boolean addRole(Object variableId, Object role) {
        if (this.tree == null || role == null) {
            return false;
        }
        return this.tree.addRole(variableId, role);
    }

    public boolean removeRole(Object variableId, Object role) {
        if (this.tree == null || role == null) {
            return false;
        }
        return this.tree.removeRole(variableId, role);
    }

    public boolean isDiscrete(Object role) {
        if (this.tree == null) {
            return false;
        }
        return this.tree.isDiscrete(role);
    }

    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.tree == null) {
            return false;
        }
        return this.tree.setDiscrete(role, discrete);
    }

    public Object getSortOrder(Object role) {
        if (this.tree == null) {
            return null;
        }
        return this.tree.getSortOrder(role);
    }

    public boolean setSortOrder(Object role, Object order) {
        if (this.tree == null) {
            return false;
        }
        return this.tree.setSortOrder(role, order);
    }

    public Object getRoleValue(Object role, int which) {
        if (this.tree == null) {
            return null;
        }
        return this.tree.getRoleValue(role, which);
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        if (this.tree == null) {
            return null;
        }
        return this.tree.getSupportedRoles(id, discrete);
    }

    public int getMaxAllowed(Object role) {
        if (this.tree == null) {
            return -1;
        }
        return this.tree.getMaxAllowed(role);
    }

    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    public boolean create(Object createData) {
        boolean status = this.build(null);
        this.repaint();
        return status;
    }

    public boolean isRebuildRequired() {
        return this.tree.isRebuildRequired();
    }

    public synchronized boolean build(Object buildData) {
        if (!this.isDataAssigned()) {
            this.error |= 1;
            return false;
        }
        this.error &= 0xFFFFFFFE;
        this.tree.build(buildData);
        this.fireViewportChangeEvent();
        this.redrawBKBuffer = true;
        this.updateComp = true;
        return true;
    }

    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(null);
        this.repaint();
        return status;
    }

    public void redraw(RedrawEvent e) {
        if (e.getSource() instanceof DendrogramChart) {
            this.updateComp = true;
        }
        if (e.type == 5 && !this.mouseAction) {
            this.brushMode = false;
        }
        if (e.type != 5) {
            this.redrawBKBuffer = true;
        }
        this.repaint();
    }

    public void boundingBoxChanged(RedrawEvent e) {
    }

    public void outerMarginChanged(RedrawEvent e) {
    }

    public int numPages(PageFormat pf) {
        return 1;
    }

    public int numPagesX(PageFormat pf) {
        return 1;
    }

    public int numPagesY(PageFormat pf) {
        return 1;
    }

    public void textUpdated(DvrTextEvent evt) {
        if (evt.isBoundsChanged) {
            this.updateComp = true;
        }
        this.redrawBKBuffer = true;
        this.repaint();
    }

    public int getNumRanges(byte dim) {
        return 0;
    }

    public DataRangeInterface getRangeSource(byte dim, int index) {
        return this;
    }

    public void setAxesVisible(boolean axesVisible) {
    }

    public boolean getAxesVisible() {
        return true;
    }

    public void setRange(byte dim, int index, DataRange range) {
    }

    public Insets getOuterMargin() {
        return this.getPreferredOuterMargin();
    }

    public Insets getInnerMargin() {
        return new Insets(0, 0, 0, 0);
    }

    public void setOuterMargin(Insets margin) {
    }

    public void setInnerMargin(Insets margin) {
    }

    public Insets getPreferredOuterMargin() {
        Insets margin = new Insets(0, 0, 0, 0);
        return margin;
    }

    public Insets getPreferredInnerMargin() {
        return new Insets(0, 0, 0, 0);
    }

    public void disableMarginPrefCalc() {
    }

    public void enableMarginPrefCalc() {
    }

    public boolean getMarginsAligned() {
        return true;
    }

    public void addMarginListener(MarginListener listener) {
        if (!this.marginListeners.contains(listener)) {
            this.marginListeners.add(listener);
        }
    }

    public void removeMarginListener(MarginListener listener) {
        if (this.marginListeners.contains(listener)) {
            this.marginListeners.remove(this.marginListeners.indexOf(listener));
        }
    }

    public DataRange getDataRange(byte dimension) {
        return null;
    }

    public void addRangeChangeListener(RangeChangeListener listener) {
        if (!this.rangeListeners.contains(listener)) {
            this.rangeListeners.add(listener);
        }
    }

    public void removeRangeChangeListener(RangeChangeListener listener) {
        if (this.rangeListeners.contains(listener)) {
            this.rangeListeners.remove(this.rangeListeners.indexOf(listener));
        }
    }

    public Object getPropertyValue(int idx) {
        int i;
        if (this.propertyIndex != null && (i = this.propertyIndex.indexOf(new Integer(idx))) >= 0) {
            return this.propertyValue.get(i);
        }
        switch (idx) {
            case 27: {
                if (this.wall != null) {
                    return this.wall.getGraphBackground();
                }
                return null;
            }
            case 26: {
                if (this.wall != null) {
                    return new Boolean(this.wallOn);
                }
            }
            case 2: {
                return new Boolean(this.tipsOn);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return this.tooltip.getPropertyValue(idx);
            }
            case 10: {
                return this.getGraphBackground();
            }
            case 21: {
                return this.getSolidBackground();
            }
            case 11: {
                return new Boolean(this.supportsGradientBackground());
            }
            case 12: {
                return new Boolean(this.supportsImageBackground());
            }
            case 32: {
                return new Integer(this.xMargin);
            }
            case 33: {
                return new Integer(this.yMargin);
            }
            case 34: {
                return null;
            }
            case 238: {
                return new Integer(this.selectedAxis);
            }
            case 23: {
                return this.legend;
            }
            case 443: {
                return this.getLegendPosition(null);
            }
            case 402: {
                if (this.getLegend(null) == null) {
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
            case 601: {
                return this.getTitle(0);
            }
            case 602: {
                return this.getTitle(1);
            }
            case 603: {
                return this.getFootnote(0);
            }
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: {
                TextStyleInterface text = idx >= 607 ? this.getTitle(0) : (idx >= 609 ? this.getTitle(1) : this.getFootnote(0));
                if (text == null) {
                    return null;
                }
                switch (idx) {
                    case 607: 
                    case 609: 
                    case 611: {
                        return new Boolean(text.isVisible());
                    }
                    case 608: 
                    case 610: 
                    case 612: {
                        return text.getText();
                    }
                }
            }
        }
        if (this.legend != null && this.legend.isPropertySupported(idx)) {
            return this.legend.getPropertyValue(idx);
        }
        if (this.tree != null && this.tree.isPropertySupported(idx)) {
            return this.tree.getPropertyValue(idx);
        }
        if (this.heightAxis != null && this.heightAxis.isPropertySupported(idx)) {
            if (this.selectedAxis == 0) {
                return ((PropertyInterface)this.getAxis("xAxis")).getPropertyValue(idx);
            }
            return ((PropertyInterface)this.getAxis("yAxis")).getPropertyValue(idx);
        }
        return null;
    }

    public boolean setPropertyValue(int idx, Object value) {
        if (this.isPropertySupported(idx)) {
            int i = this.propertyIndex.indexOf(new Integer(idx));
            if (i >= 0) {
                this.propertyValue.set(i, value);
            } else {
                this.propertyIndex.add(new Integer(idx));
                this.propertyValue.add(value);
            }
            if (idx == 238) {
                if (value instanceof PropertyEvent) {
                    Object obj = ((PropertyEvent)value).value;
                    if (obj instanceof Number) {
                        this.selectedAxis = ((Number)obj).intValue();
                    }
                } else if (value instanceof Number) {
                    this.selectedAxis = ((Number)value).intValue();
                }
            }
        } else {
            if (this.legend != null && this.legend.isPropertySupported(idx)) {
                return this.legend.setPropertyValue(idx, value);
            }
            if (this.tree != null && this.tree.isPropertySupported(idx)) {
                return this.tree.setPropertyValue(idx, value);
            }
            if (this.heightAxis != null && this.heightAxis.isPropertySupported(idx)) {
                if (this.selectedAxis == 0) {
                    return ((PropertyInterface)this.getAxis("xAxis")).setPropertyValue(idx, value);
                }
                if (this.treeAxis != null) {
                    return ((PropertyInterface)this.getAxis("yAxis")).setPropertyValue(idx, value);
                }
            }
        }
        return true;
    }

    public int getNumberProperties() {
        return 8;
    }

    public boolean applyPropertyChanges() {
        this.applyingChanges = true;
        if (this.propertyIndex == null) {
            return false;
        }
        if (this.propertyIndex.size() <= 0) {
            if (this.legend != null) {
                this.legend.applyPropertyChanges();
            }
            if (this.tree != null) {
                this.tree.applyPropertyChanges();
            }
            if (this.heightAxis != null) {
                this.heightAxis.applyPropertyChanges();
            }
            if (this.treeAxis != null) {
                this.treeAxis.applyPropertyChanges();
            }
            this.applyingChanges = false;
            this.updateComp = true;
            this.redrawBKBuffer = true;
            this.repaint();
            return true;
        }
        Object startColor = null;
        Object endColor = null;
        block26: for (int i = 0; i < this.propertyIndex.size(); ++i) {
            int idx = (Integer)this.propertyIndex.get(i);
            Object value = this.propertyValue.get(i);
            if (value instanceof PropertyEvent) {
                value = ((PropertyEvent)value).value;
            }
            switch (idx) {
                case 26: {
                    this.wallOn = (Boolean)value;
                    continue block26;
                }
                case 0: {
                    this.setColorScheme(value);
                    continue block26;
                }
                case 2: {
                    if (!(value instanceof Boolean)) continue block26;
                    this.tipsOn = (Boolean)value;
                    continue block26;
                }
                case 3: {
                    if (!(value instanceof Font)) continue block26;
                    this.tooltip.setFontObject((Font)value);
                    continue block26;
                }
                case 4: {
                    this.tooltip.setChartTipTextColor(value);
                    continue block26;
                }
                case 5: {
                    this.tooltip.setChartTipBorderColor(value);
                    continue block26;
                }
                case 6: {
                    this.tooltip.getChartTipBackground().setSolidBackground(value);
                    continue block26;
                }
                case 8: {
                    if (!(value instanceof Double)) continue block26;
                    this.tooltip.setChartTipOpacity(((Double)value).doubleValue());
                    continue block26;
                }
                case 21: {
                    this.setSolidBackground(value);
                    continue block26;
                }
                case 13: {
                    startColor = value;
                    continue block26;
                }
                case 14: {
                    endColor = value;
                    continue block26;
                }
                case 15: {
                    this.setGradientBackground(startColor, endColor, value);
                    continue block26;
                }
                case 32: {
                    this.xMargin = value instanceof Number ? ((Number)value).intValue() : this.xMargin;
                    continue block26;
                }
                case 33: {
                    this.yMargin = value instanceof Number ? ((Number)value).intValue() : this.yMargin;
                    continue block26;
                }
                case 34: {
                    boolean vis;
                    if (!(value instanceof Boolean)) continue block26;
                    this.hScrollbarOn = this.vScrollbarOn = (vis = ((Boolean)value).booleanValue());
                    if (this.treeHandler != null) {
                        this.treeHandler.setZoomPanEnabled(this.hScrollbarOn);
                    }
                    if (this.heightHandler == null) continue block26;
                    this.heightHandler.setZoomPanEnabled(this.hScrollbarOn);
                    continue block26;
                }
                case 443: {
                    if (!(value instanceof String) && !(value instanceof Number)) continue block26;
                    this.setLegendPosition(null, value);
                    continue block26;
                }
                case 604: {
                    if (!(value instanceof TextStyleInterface)) continue block26;
                    this.setTitle(0, (TextStyleInterface)value);
                    continue block26;
                }
                case 605: {
                    if (!(value instanceof TextStyleInterface)) continue block26;
                    this.setTitle(1, (TextStyleInterface)value);
                    continue block26;
                }
                case 606: {
                    if (!(value instanceof TextStyleInterface)) continue block26;
                    this.setFootnote(0, (TextStyleInterface)value);
                    continue block26;
                }
                case 601: 
                case 602: 
                case 603: 
                case 607: 
                case 608: 
                case 609: 
                case 610: 
                case 611: 
                case 612: {
                    TextStyleInterface text = idx >= 607 ? this.getTitle(0) : (idx >= 609 ? this.getTitle(1) : this.getFootnote(0));
                    if (text == null) {
                        return false;
                    }
                    switch (idx) {
                        case 607: 
                        case 609: 
                        case 611: {
                            text.setVisible(((Boolean)value).booleanValue());
                            break;
                        }
                        case 608: 
                        case 610: 
                        case 612: {
                            text.setText(value);
                        }
                    }
                    continue block26;
                }
            }
        }
        this.propertyIndex.clear();
        this.propertyValue.clear();
        if (this.legend != null) {
            this.legend.applyPropertyChanges();
        }
        if (this.tree != null) {
            this.tree.applyPropertyChanges();
        }
        if (this.heightAxis != null) {
            this.heightAxis.applyPropertyChanges();
        }
        if (this.treeAxis != null) {
            this.treeAxis.applyPropertyChanges();
        }
        this.applyingChanges = false;
        this.updateComp = true;
        this.redrawBKBuffer = true;
        this.repaint();
        return true;
    }

    public boolean applyPropertyChanges(Object source) {
        return this.applyPropertyChanges();
    }

    public void cancelPropertyChanges() {
        this.propertyIndex.clear();
        this.propertyValue.clear();
        if (this.legend != null) {
            this.legend.cancelPropertyChanges();
        }
        if (this.tree != null) {
            this.tree.cancelPropertyChanges();
        }
        if (this.heightAxis != null) {
            this.heightAxis.cancelPropertyChanges();
        }
        if (this.treeAxis != null) {
            this.treeAxis.cancelPropertyChanges();
        }
    }

    public void cancelPropertyChanges(Object source) {
    }

    public int[] getPendingChanges() {
        int[] index = new int[this.propertyIndex.size()];
        for (int i = 0; i < this.propertyIndex.size(); ++i) {
            index[i] = (Integer)this.propertyIndex.get(i);
        }
        return index;
    }

    public int[] getPendingChanges(Object source) {
        int[] index = new int[this.propertyIndex.size()];
        return index;
    }

    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 238: 
            case 402: 
            case 443: 
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int idx) {
        return false;
    }

    public int getNumberPendingProperties() {
        return -1;
    }

    public boolean hasUserSetValue(int id) {
        if (this.legend != null && this.legend.isPropertySupported(id)) {
            return this.legend.hasUserSetValue(id);
        }
        if (this.tree != null && this.tree.isPropertySupported(id)) {
            return this.tree.hasUserSetValue(id);
        }
        if (this.heightAxis != null && this.heightAxis.isPropertySupported(id)) {
            return this.heightAxis.hasUserSetValue(id);
        }
        if (this.treeAxis != null && this.treeAxis.isPropertySupported(id)) {
            return this.treeAxis.hasUserSetValue(id);
        }
        return super.hasUserSetValue(id);
    }

    public DendrogramChart getChart() {
        return this.tree;
    }

    public Object getWall() {
        return this.wall;
    }

    protected void fireRangeChangeEvent(byte dimension) {
        DataRange dr = this.getDataRange(dimension);
        RangeChangedEvent rce = new RangeChangedEvent((Object)this, 3, dr, dimension, dr);
        int numListeners = this.rangeListeners.size();
        if (numListeners > 0) {
            for (int i = 0; i < numListeners; ++i) {
                ((RangeChangeListener)this.rangeListeners.get(i)).rangeChanged(rce);
            }
        }
    }

    protected void fireViewportChangeEvent() {
        double[] minmax = this.tree.getViewport(1, 2, 1);
        double xMin = minmax[0];
        double xMax = minmax[1];
        minmax = this.tree.getViewport(1, 2, 2);
        double yMin = minmax[0];
        double yMax = minmax[1];
        ViewportEvent evt = new ViewportEvent((Object)this, 1, xMin, xMax, yMin, yMax, 0.0, 0.0);
        for (int i = 0; i < this.viewportListeners.size(); ++i) {
            ((ViewportListenerInterface)this.viewportListeners.get(i)).viewportChanged(evt);
        }
    }

    protected boolean createTreeElement(Object source) {
        if (this.tree == null) {
            this.tree = new DendrogramChart();
        }
        if (this.tree == null) {
            return false;
        }
        this.tree.setDataSource(this.dataFilter);
        this.tree.addRedrawListener(this);
        this.setColorsToTree();
        this.heightAxis = new Axes(source);
        if (this.heightAxis != null) {
            this.heightAxis.addRedrawListener((RedrawListener)this);
            this.heightAxis.setLayoutRangeModel(false);
            this.setColorsToAxis(this.heightAxis);
            this.tree.setHeightAxis(this.heightAxis);
            this.heightHandler = this.tree.getHeightHandler();
            this.warningIcon.addZoomPanHandler(this.heightHandler);
            this.addViewportListener(this.heightHandler);
        }
        this.treeAxis = new Axes(source);
        if (this.treeAxis != null) {
            this.treeAxis.addRedrawListener((RedrawListener)this);
            this.treeAxis.setLayoutRangeModel(false);
            this.setColorsToAxis(this.treeAxis);
            this.tree.setTreeAxis(this.treeAxis);
            this.treeHandler = this.tree.getTreeHandler();
            this.warningIcon.addZoomPanHandler(this.treeHandler);
            this.addViewportListener(this.treeHandler);
        }
        return true;
    }

    protected void setColorsToTree() {
        if (this.tree == null) {
            return;
        }
        this.tree.setNodeColor(this.style.getFillStyleElement("GraphDataStyleDefault").getFillColor());
        this.tree.setSelectionColor(this.style.getLineStyleElement("Selection").getLineColor());
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 1: 
            case 3: {
                if (this.tree != null) {
                    this.tree.setDataChanged();
                }
                this.buildAndDraw(Boolean.TRUE, null, null);
            }
        }
        super.dataFilterChanged(evt);
    }
}

