/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.JVerticalLabel;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisLayout;
import com.sas.graphics.applets.statgraph.sgchart.grid.TrellisPlot;
import com.sas.graphics.silk.BaseHistComponent;
import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.GraphToolbarInterface;
import com.sas.graphics.silk.interfaces.LayerInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.matrix.AbstractMatrixChartFactory;
import com.sas.graphics.silk.matrix.DensityPlotMatrixChartFactory;
import com.sas.graphics.silk.matrix.ScatterMatrixChartFactory;
import com.sas.graphics.silk.ui.AxisPanel;
import com.sas.graphics.silk.ui.DataOptionsDialog;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.MultipleVarsDataDialog;
import com.sas.graphics.silk.ui.PlotMatrixPanel;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.AxisComponent;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.MatrixDefaults;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.AxisParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyMulticaster;
import com.sas.graphics.util.StringCompare;
import com.sas.graphics.xml.GraphParserFactory;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.w3c.dom.Element;

public class BaseMatrixComponent
extends SILKComponent
implements ActionListener,
ItemListener,
Printable,
PropertyInterface,
RoleInterface,
GraphInterface {
    private static final long serialVersionUID = -2095156169641225869L;
    public static final int SCATTER = 1;
    public static final int DENSITY_PLOT = 2;
    private int FULL_MATRIX_THRESHOLD = 8;
    private int componentType = 1;
    private static int MAX_NUM_MATRIX_VARS = 25;
    protected JComponent[] components = null;
    protected Object dataSource;
    protected DataFilterReadInterface filter = null;
    protected TrellisPlot matrix = null;
    protected TrellisLayout layout = null;
    protected int hGap = 0;
    protected int vGap = 0;
    protected final int BORDER_WIDTH = 1;
    protected Color borderColor = null;
    protected JPopupMenu popup = null;
    protected Dialog graphDialog = null;
    protected Dialog dataDialog = null;
    protected Component toolbar = null;
    protected int actionMode = 1;
    protected Color labelColor = null;
    protected Color backgroundColor = null;
    protected ResourceBundle rb = null;
    protected Frame parentFrame = null;
    protected ArrayList matrixVars = null;
    private boolean externalAxes = true;
    private boolean showExternalAxes = false;
    protected Roles roles = null;
    protected String matrixVar = null;
    protected String engMatrixVar = "MatrixVar";
    private ArrayList externalXAxes = null;
    private ArrayList externalYAxes = null;
    private int currentAxis = 0;
    private boolean alternateAxes = true;
    protected Hashtable properties = null;
    protected Border border = null;
    private boolean showFullMatrix = true;
    private boolean showOnlyLowerTriangle = false;
    protected MatrixDefaults matrixDefaults = null;
    private boolean popupEnabled = true;
    protected Object id = null;
    protected SILKNumber xRole = null;
    protected SILKNumber yRole = null;
    protected SILKNumber groupRole = null;
    protected SILKNumber groupIndexRole = null;
    protected SILKNumber colorRole = null;
    protected String currentLegend = null;
    protected String X_AXIS_DISPLAY_NAME = null;
    protected String Y_AXIS_DISPLAY_NAME = null;
    protected AbstractMatrixChartFactory mcFactory = new ScatterMatrixChartFactory();
    protected boolean ignorePopupMenuEvents = false;
    private MultipleVarsDataDialog matrixVarsDialog = null;
    private PlotMatrixPanel plotMatrixPanel = null;
    private boolean showDescription = true;
    private GraphPropertiesDialog.PropertiesTreeNode rootAxisNode = null;
    private GraphPropertiesDialog.PropertiesTreeNode xAxisNode = null;
    private GraphPropertiesDialog.PropertiesTreeNode yAxisNode = null;
    private ComponentInterface tempCI = null;
    private boolean toolbarSet = false;

    public BaseMatrixComponent() {
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
        this.X_AXIS_DISPLAY_NAME = ResourceLoader.getResourceString((Object)this.rb, (String)"SILKXYComponent.X.DisplayName.txt", (String)"Horizonal");
        this.Y_AXIS_DISPLAY_NAME = ResourceLoader.getResourceString((Object)this.rb, (String)"SILKXYComponent.Y.DisplayName.txt", (String)"Vertical");
        this.matrixDefaults = new MatrixDefaults();
        this.roles = Roles.getInstance(null);
        this.matrixVar = this.roles.getRoleNLSName("ROLE_MATRIX_VAR");
        this.xRole = this.roles.getRoleObject("ROLE_X");
        this.yRole = this.roles.getRoleObject("ROLE_Y");
        this.groupRole = this.roles.getRoleObject("ROLE_GROUP");
        this.groupIndexRole = this.roles.getRoleObject("ROLE_GROUP_INDEX");
        this.colorRole = this.roles.getRoleObject("ROLE_COLOR");
        if (this.matrixDefaults.fullMatrixThreshold < this.FULL_MATRIX_THRESHOLD) {
            this.FULL_MATRIX_THRESHOLD = this.matrixDefaults.fullMatrixThreshold;
        }
        this.matrixVars = new ArrayList();
        this.components = new JComponent[1];
        this.vGap = 4;
        this.hGap = 4;
        this.createTrellis();
        JLabel label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.Error.EmptyPlotMatrix.txt", (String)"Empty Plot Matrix"), 0);
        label.addMouseListener((MouseListener)((Object)this));
        this.matrix.addCellItem(0, 0, (Component)label);
        this.setStyle(SILKGlobal.getInstance().getPropertyValue(0));
        this.border = new LineBorder(this.borderColor, 1);
        this.externalAxes = true;
        this.showExternalAxes = false;
        this.externalXAxes = new ArrayList();
        this.externalYAxes = new ArrayList();
        this.properties = new Hashtable();
        SILKGlobal.register((PropertyInterface)this);
    }

    public BaseMatrixComponent(Object source, int compType, String[] variables) {
        this();
        this.matrix.removeCellItem(0, 0);
        this.setDataSource(source);
        this.componentType = compType;
        if (this.externalAxes) {
            this.showExternalAxes = true;
        }
        for (int i = 0; i < variables.length; ++i) {
            this.matrixVars.add(variables[i]);
            if (this.filter == null || this.filter.isNumericVariable((Object)variables[i])) continue;
            this.showExternalAxes = false;
        }
        this.components = new JComponent[this.matrixVars.size() * this.matrixVars.size()];
        this.createMatrix();
    }

    private void disposeTrellis() {
        if (this.matrix != null) {
            int i;
            for (i = 0; i < this.layout.getGridRows(); ++i) {
                for (int j = 0; j < this.layout.getGridColumns(); ++j) {
                    this.matrix.removeCell(i, j);
                }
            }
            for (i = 0; i < this.layout.getGridRows(); ++i) {
                this.matrix.removeRowAxis(i, true);
                this.matrix.removeRowAxis(i, false);
                this.matrix.removeRowHeader(i);
            }
            for (i = 0; i < this.layout.getGridColumns(); ++i) {
                this.matrix.removeColumnAxis(i, true);
                this.matrix.removeColumnAxis(i, false);
                this.matrix.removeColumnHeader(i);
            }
            this.matrix.removeAll();
        }
        this.matrix = null;
        this.layout = null;
    }

    public void createTrellis() {
        this.matrix = new TrellisPlot();
        this.layout = new TrellisLayout();
        this.layout.setGridHGap(this.hGap);
        this.layout.setGridVGap(this.vGap);
        this.matrix.setLayout((LayoutManager)this.layout);
        this.setLayout(null);
        this.add((Component)this.matrix);
    }

    public void createMatrix() {
        int i;
        int i2;
        if (this.filter == null) {
            return;
        }
        int numVars = this.matrixVars.size();
        this.matrix.disableLayout();
        for (i2 = 0; i2 < numVars - 1; ++i2) {
            this.matrix.addColumn();
        }
        for (i2 = 0; i2 < numVars - 1; ++i2) {
            this.matrix.addRow();
        }
        this.showFullMatrix = numVars <= this.FULL_MATRIX_THRESHOLD && !this.showOnlyLowerTriangle;
        int index = 0;
        for (i = 0; i < numVars; ++i) {
            for (int j = 0; j < numVars; ++j) {
                String yVariable = this.matrixVars.get(i).toString();
                String xVariable = this.matrixVars.get(j).toString();
                index = i * numVars + j;
                this.components[index] = this.createComponent(this.componentType, xVariable, yVariable);
                this.components[index].addMouseListener((MouseListener)((Object)this));
                this.components[index].addMouseMotionListener((MouseMotionListener)((Object)this));
                this.components[index].setBorder(this.border);
                this.matrix.addCellItem(i, j, (Component)this.components[index]);
            }
        }
        if (this.getDiagonal() == 2) {
            for (i = 0; i < numVars; ++i) {
                JLabel rowLabel = this.getLabel(this.matrixVars.get(i), 1);
                this.matrix.addRowHeader(i, (Component)rowLabel);
                JLabel colLabel = this.getLabel(this.matrixVars.get(i), 0);
                this.matrix.addColumnHeader(i, (Component)colLabel);
            }
        }
        Vector<JComponent> v = null;
        if (this.components != null) {
            v = new Vector<JComponent>(this.components.length);
            for (int i3 = 0; i3 < this.components.length; ++i3) {
                if (!(this.components[i3] instanceof RoleInterface) || this.components[i3] instanceof BaseHistComponent) continue;
                v.addElement(this.components[i3]);
            }
        }
        this.mcFactory.initLegends();
        if (this.showExternalAxes && this.showFullMatrix && this.getDiagonal() == 1) {
            int i4;
            this.layout.setExternalAxesAlignment(1);
            for (i4 = 0; i4 < numVars; ++i4) {
                boolean primary = true;
                if (this.alternateAxes) {
                    primary = i4 % 2 == 0;
                }
                Object axisDesc = this.filter.getVariableDescription((Object)this.matrixVars.get(i4).toString());
                String axisLabel = null;
                if (axisDesc != null) {
                    axisLabel = axisDesc.toString();
                }
                Object varFormat = this.filter.getFormat(this.matrixVars.get(i4), SASFormat.class);
                AxisComponent axis = new AxisComponent(2, axisLabel);
                axis.setPrimary(primary);
                axis.setPropertyValue(200, (Object)new Boolean(false));
                axis.applyPropertyChanges();
                this.matrix.addRowAxis(i4, (Component)axis, primary);
                axis.setLabel((Object)new Boolean(false));
                axis.addMouseListener((MouseListener)((Object)this));
                axis.setValuesFormat(varFormat);
                this.externalYAxes.add(axis);
                axis = new AxisComponent(1, axisLabel);
                axis.setPrimary(primary);
                this.matrix.addColumnAxis(i4, (Component)axis, primary);
                axis.setLabel((Object)new Boolean(false));
                axis.setPropertyValue(200, (Object)new Boolean(false));
                axis.applyPropertyChanges();
                axis.addMouseListener((MouseListener)((Object)this));
                axis.setValuesFormat(varFormat);
                this.externalXAxes.add(axis);
            }
            for (i4 = 0; i4 < numVars; ++i4) {
                String xVar = this.matrixVars.get(i4).toString();
                AxisInterface xAxis = (AxisInterface)this.externalXAxes.get(i4);
                for (int j = 0; j < numVars; ++j) {
                    String yVar = this.matrixVars.get(j).toString();
                    AxisInterface yAxis = (AxisInterface)this.externalYAxes.get(j);
                    this.mcFactory.applyAxesToCrossing(xVar, yVar, xAxis, yAxis);
                }
            }
            this.enableListeners();
        }
        this.applyColorScheme();
        this.matrix.enableLayout();
        Rectangle r = this.getBounds();
        if (r.width > 0 && r.height > 0) {
            this.setAxesFontHeights(r);
        }
        this.matrix.addMouseListener((MouseListener)((Object)this));
    }

    public JComponent createComponent(int compType, String xVariable, String yVariable) {
        if (this.mcFactory == null) {
            return null;
        }
        return this.mcFactory.getComponentAtCrossing(xVariable, yVariable);
    }

    protected JLabel getLabel(Object variable, int orientation) {
        Object t = this.showDescription ? this.filter.getVariableDescription(variable) : variable;
        String text = t != null ? t.toString() : "";
        Object jl = null;
        jl = orientation == 1 ? new VerticalLabel(text, false) : new JLabel(text, 0);
        Font font = this.style.getTextStyleElement("LabelText").getFont();
        ((JComponent)jl).setFont(font.deriveFont(this.getLabelFontSize((JLabel)jl)));
        return jl;
    }

    private float getLabelFontSize(JLabel label) {
        double cellHeight;
        float font_size;
        if (this.components == null || this.components.length == 0) {
            if (label != null) {
                return label.getFont().getSize();
            }
            return 0.0f;
        }
        double height = 0.0;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null) continue;
            height = this.components[i].getHeight();
            break;
        }
        if ((font_size = (float)((cellHeight = height - 50.0) * 0.021 * 1.38889)) < 9.0f) {
            font_size = 9.0f;
        } else if (font_size > 16.0f) {
            font_size = 16.0f;
        }
        return font_size;
    }

    public void addNotify() {
        Container c;
        super.addNotify();
        for (c = this.getParent(); c != null && !(c instanceof Frame); c = c.getParent()) {
        }
        if (c != null && c instanceof Frame) {
            this.parentFrame = (Frame)c;
        }
        if (this.matrix != null) {
            this.matrix.setBounds(this.graphLayout.getChartArea());
            if (this.getDiagonal() == 1) {
                this.matrix.installMarginListeners();
                this.matrix.installRangeListeners();
            }
            this.matrix.enableLayout();
        }
    }

    public void removeNotify() {
        if (this.matrix != null) {
            this.matrix.disableLayout();
            this.matrix.uninstallMarginListeners();
            this.matrix.uninstallRangeListeners();
        }
        super.removeNotify();
        if (this.toolbar != null) {
            this.toolbar.setVisible(false);
        }
    }

    protected void paintComponent(Graphics g) {
        if (this.legendUpdateRequired()) {
            this.graphLayout.doLayout((JComponent)((Object)this));
            if (this.matrix != null) {
                this.matrix.setBounds(this.graphLayout.getChartArea());
            }
            this.matrix.enableLayout();
        }
        Color c = this.getBackground();
        if (this.style != null) {
            c = this.style.getFillStyleElement("Backfill").getFillColor();
        }
        g.setColor(c);
        g.fillRect(this.getBounds().x, this.getBounds().y, this.compWidth, this.compHeight);
        super.paintComponent(g);
        this.graphLayout.draw(g);
        this.graphLayout.drawHighlight(g);
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            if (this.popup == null) {
                this.popup = this.createPopupMenu();
            }
            if (this.popupEnabled) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = MenuUtilities.getPopupMenu((InputStream)this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/BaseMatrixMenu.xml"), (ActionListener)this);
        this.ignorePopupMenuEvents = true;
        switch (this.actionMode) {
            case 1: {
                MenuUtilities.setMenuItemSelected((JPopupMenu)menu, (String)"ACTION_MODE_BRUSH", (boolean)true);
                break;
            }
            case 6: {
                MenuUtilities.setMenuItemSelected((JPopupMenu)menu, (String)"ACTION_MODE_SELECT", (boolean)true);
            }
        }
        this.ignorePopupMenuEvents = false;
        return menu;
    }

    public void setAxisPanelStatus() {
        if (this.graphDialog != null && this.graphDialog instanceof TabbedPropertiesDialog) {
            JTabbedPane tabPanel;
            TabbedPropertiesDialog tpd = (TabbedPropertiesDialog)this.graphDialog;
            TabPanelInterface tbi = tpd.getActivePanel();
            AxisPanel ap = null;
            if (tbi instanceof AxisPanel) {
                ap = (AxisPanel)tbi;
            }
            if ((tabPanel = tpd.getTabbedPane()) != null) {
                for (int j = 0; j < tabPanel.getTabCount(); ++j) {
                    Component c = tabPanel.getComponentAt(j);
                    if (!(c instanceof AxisPanel)) continue;
                    tabPanel.setEnabledAt(j, this.showFullMatrix);
                    if (ap == null || this.showFullMatrix) continue;
                    tpd.setActiveTab(1);
                }
            }
        } else if (this.graphDialog instanceof GraphPropertiesDialog) {
            GraphPropertiesDialog gpd = (GraphPropertiesDialog)this.graphDialog;
            GraphPropertiesDialog.PropertiesTreeNode node = gpd.getRootNode((Object)"Axis", false);
            if (!(node == null || this.showFullMatrix && this.externalAxes && this.mcFactory.getDiagonal() == 1)) {
                node.removeChild((Object)"X");
                node.removeChild((Object)"Y");
                gpd.removeRootNode((Object)"Axis");
                gpd.refreshTree();
            } else if (node == null && this.mcFactory.getDiagonal() == 1) {
                this.rootAxisNode = gpd.getRootNode((Object)"Axis", true);
                if (this.rootAxisNode != null) {
                    this.rootAxisNode.addChild(this.xAxisNode);
                    this.rootAxisNode.addChild(this.yAxisNode);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.ignorePopupMenuEvents) {
            return;
        }
        Object source = evt.getSource();
        if (source instanceof JMenuItem) {
            String command = ((JMenuItem)source).getActionCommand();
            if (command.equals("GRAPH_PROPERTIES")) {
                if (this.graphDialog == null) {
                    this.graphDialog = this.createGraphDialog();
                }
                if (this.graphDialog != null && this.matrixVars.size() > 1) {
                    this.setAxisPanelStatus();
                    this.graphDialog.setVisible(true);
                } else {
                    System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.Error.NoGraphDialog.txt", (String)"No graph dialog to show!"));
                }
            } else if (command.equalsIgnoreCase("DATA_OPTIONS")) {
                if (this.dataDialog == null) {
                    DataOptionsDialog dd = new DataOptionsDialog((RoleInterface)this, (JComponent)((Object)this), this.parentFrame);
                    dd.disableRoleReassignment((RoleInterface)this, null, (Object)Roles.getInstance(null).getRoleObject("ROLE_MATRIX_VAR"));
                    ResourceBundle rbmenu = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.menus.silk_menus_NLS");
                    dd.addAction((RoleInterface)this, null, (AbstractAction)new MatrixVarsAction(ResourceLoader.getResourceString((Object)rbmenu, (String)"Popup.Matrix.MatrixVariables.txt", (String)"Matrix Variables...")));
                    this.dataDialog = dd;
                }
                if (this.dataDialog != null) {
                    this.dataDialog.setVisible(true);
                } else {
                    System.out.println(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.Error.NoDataDialog.txt", (String)"No data dialog to show!"));
                }
            } else if (command.equalsIgnoreCase("MATRIX_VARIABLES")) {
                this.showMatrixVarsDialog();
            } else if (command.equalsIgnoreCase("ACTION_MODE_BRUSH")) {
                this.setActionMode(1);
            } else if (command.equalsIgnoreCase("ACTION_MODE_SELECT")) {
                this.setActionMode(6);
            } else if (command.equalsIgnoreCase("toolbar")) {
                if (this.toolbar == null) {
                    this.toolbar = this.createToolbar();
                }
                if (this.toolbar != null) {
                    this.toolbar.setVisible(true);
                }
            } else if (command.equalsIgnoreCase("resetView")) {
                this.resetView();
            } else if (command.equals("COPY")) {
                CopyToClipboard.toClipboard((JComponent)((Object)this));
            } else if (command.equalsIgnoreCase("DEBUG__SAVE_AS_XML")) {
                SILKParser.saveAsXML((Object)this, null, (boolean)true);
            }
        }
    }

    private void showMatrixVarsDialog() {
        if (this.matrixVarsDialog == null) {
            String title = ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.MatrixVarsDialog.txt", (String)"Matrix Variables Settings Dialog");
            this.matrixVarsDialog = new MultipleVarsDataDialog(this.parentFrame, (RoleInterface)this, Roles.getInstance(null).getRoleObject("ROLE_MATRIX_VAR"), this.filter, false, title);
        }
        if (this.matrixVarsDialog != null) {
            this.matrixVarsDialog.setVisible(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
    }

    private SILKToolbar createToolbar() {
        SILKToolbar toolBar = new SILKToolbar(this.parentFrame);
        toolBar.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.GraphToolbar.txt", (String)"Graph Toolbar"));
        toolBar.setButtonEnabled(3, false);
        toolBar.setButtonEnabled(4, false);
        toolBar.setButtonEnabled(2, false);
        toolBar.setButtonEnabled(5, false);
        toolBar.addListener((GraphInterface)this);
        return toolBar;
    }

    private void resetView() {
        for (int i = 0; i < this.components.length; ++i) {
            if (!(this.components[i] instanceof GraphInterface)) continue;
            ((GraphInterface)this.components[i]).setActionMode(5);
        }
    }

    private Dialog createGraphDialog() {
        return this.getGraphDialog();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Dialog getGraphDialog() {
        Dialog d;
        Dialog graphDlg = null;
        if (this.tempCI == null) {
            JComponent ci = this.createComponent(this.componentType, null, null);
            if (ci instanceof ComponentInterface) {
                this.tempCI = (ComponentInterface)ci;
            }
            if (ci instanceof PropertyInterface) {
                SILKGlobal.unregister((PropertyInterface)((PropertyInterface)ci));
            }
        }
        if (this.tempCI == null) return graphDlg;
        graphDlg = d = this.tempCI.getDialog((Object)"Properties", (Object)this);
        if (d != null && d instanceof TabbedPropertiesDialog) {
            TabbedPropertiesDialog tpd = (TabbedPropertiesDialog)d;
            JTabbedPane tabPanel = tpd.getTabbedPane();
            if (tabPanel == null) return graphDlg;
        }
        GraphPropertiesDialog gpd = (GraphPropertiesDialog)d;
        gpd.addPropertyListener((PropertyInterface)this);
        GraphPropertiesDialog.PropertiesTreeNode node = gpd.getRootNode((Object)"Chart", true);
        String displayName = node.getDisplayName();
        Component panel = node.getPanel();
        node.setDisplayName(ResourceLoader.getResourceString((Object)this.rb, (String)"MatrixComponent.GraphDialog.PlotMatrix.txt", (String)"Plot Matrix"));
        this.plotMatrixPanel = new PlotMatrixPanel();
        this.plotMatrixPanel.addPropertyListener(this);
        node.setPanel((Component)this.plotMatrixPanel);
        if (displayName != null && panel != null) {
            GraphPropertiesDialog.PropertiesTreeNode child = node.createChild((Object)displayName);
            child.setPanel(panel);
        }
        if ((node = gpd.getRootNode((Object)"Axis", false)) != null) {
            this.rootAxisNode = node;
            this.xAxisNode = node.getChild((Object)"X");
            this.yAxisNode = node.getChild((Object)"Y");
            node.setPanel(null);
            node.removeChild((Object)"X2");
            node.removeChild((Object)"Y2");
        }
        gpd.updateAxesPanels((PropertyInterface)this, (Object)this);
        gpd.updateLegendPanels((PropertyInterface)this, (Object)this);
        if (node == null || this.showFullMatrix && this.externalAxes && this.mcFactory.getDiagonal() == 1) return graphDlg;
        node.removeChild((Object)"X");
        node.removeChild((Object)"Y");
        gpd.removeRootNode((Object)"Axis");
        return graphDlg;
    }

    public void addDrilldownListener(DrilldownListenerInterface dli) {
    }

    public void removeDrilldownListener(DrilldownListenerInterface dli) {
    }

    public AxisInterface getAxis(Object which) {
        return null;
    }

    public boolean setExternalAxis(Object which, AxisInterface axis) {
        return false;
    }

    public LegendInterface getLegend(Object which) {
        return null;
    }

    public Component getToolBar() {
        if (!this.toolbarSet && this.toolbar == null) {
            this.toolbar = this.createToolbar();
        }
        return this.toolbar;
    }

    public boolean setToolBar(Component toolBarIn) {
        this.toolbarSet = true;
        this.toolbar = toolBarIn;
        if (toolBarIn != null && this.toolbar instanceof GraphToolbarInterface) {
            ((GraphToolbarInterface)this.toolbar).addListener((GraphInterface)this);
        }
        return true;
    }

    public int getActionMode() {
        return this.actionMode;
    }

    public boolean setActionMode(int mode) {
        switch (mode) {
            case 1: 
            case 6: {
                this.actionMode = mode;
                if (this.components == null) {
                    return true;
                }
                for (int i = 0; i < this.components.length; ++i) {
                    if (this.components[i] == null || !(this.components[i] instanceof BaseComponentInterface)) continue;
                    ((BaseComponentInterface)this.components[i]).setActionMode(this.actionMode);
                }
                return true;
            }
        }
        return false;
    }

    public boolean setStyle(Object newStyle) {
        super.setStyle(newStyle);
        return this.applyColorScheme();
    }

    public boolean applyColorScheme() {
        if (this.style == null) {
            return false;
        }
        this.backgroundColor = this.style.getFillStyleElement("Backfill").getFillColor();
        this.borderColor = this.backgroundColor.darker();
        this.labelColor = this.style.getTextStyleElement("LabelText").getTextColor();
        this.setBackground(this.backgroundColor);
        this.matrix.setBackground(this.backgroundColor);
        this.border = new LineBorder(this.borderColor, 1);
        if (this.components == null) {
            return true;
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] == null) continue;
            this.components[i].setBorder(this.border);
        }
        if (this.showExternalAxes) {
            Object o;
            int i;
            int size;
            if (this.externalXAxes != null && this.externalXAxes.size() > 0) {
                size = this.externalXAxes.size();
                for (i = 0; i < size; ++i) {
                    o = this.externalXAxes.get(i);
                    if (!(o instanceof AxisComponent)) continue;
                    ((AxisComponent)o).setStyle(this.style);
                }
            }
            if (this.externalYAxes != null && this.externalYAxes.size() > 0) {
                size = this.externalYAxes.size();
                for (i = 0; i < size; ++i) {
                    o = this.externalYAxes.get(i);
                    if (!(o instanceof AxisComponent)) continue;
                    ((AxisComponent)o).setStyle(this.style);
                }
            }
        }
        this.mcFactory.setStyle(this.style);
        return true;
    }

    public DataFilterReadInterface getFilter() {
        return this.filter;
    }

    public boolean setDataListening(boolean listen) {
        return false;
    }

    public boolean isDataListening() {
        return true;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean setEditable(boolean editable) {
        return false;
    }

    private void disableListeners() {
        if (this.matrix != null) {
            this.matrix.uninstallMarginListeners();
            this.matrix.uninstallRangeListeners();
        }
    }

    private void enableListeners() {
        if (this.matrix != null && this.showFullMatrix && this.externalAxes && this.mcFactory.getDiagonal() == 1) {
            this.matrix.installMarginListeners();
            this.matrix.installRangeListeners();
            this.revalidate();
            this.repaint();
        }
    }

    public boolean applyWhereClause(String whereClause, boolean clear) {
        boolean returnValue = true;
        this.disableListeners();
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i] == null || !(this.components[i] instanceof GraphInterface)) continue;
                returnValue = ((GraphInterface)this.components[i]).applyWhereClause(whereClause, clear) && returnValue;
            }
        }
        returnValue = this.filter != null ? this.filter.applyWhereClause(whereClause, clear) && returnValue : false;
        this.enableListeners();
        this.updateLegend(6, true);
        return returnValue;
    }

    public String getWhereClause() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getWhereClause();
    }

    public boolean isBackBufferDrawEnabled() {
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof GraphInterface)) continue;
                return ((GraphInterface)this.components[i]).isBackBufferDrawEnabled();
            }
        }
        return false;
    }

    public boolean isModelAttributeHonored(Object attribute) {
        return false;
    }

    public void setBackBufferDrawEnabled(boolean drawback) {
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof GraphInterface)) continue;
                ((GraphInterface)this.components[i]).setBackBufferDrawEnabled(drawback);
            }
        }
    }

    public boolean setHonorModelAttribute(Object attribute, boolean honorit) {
        boolean rc = true;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof GraphInterface)) continue;
                rc |= ((GraphInterface)this.components[i]).setHonorModelAttribute(attribute, honorit);
            }
        }
        return rc;
    }

    public void enablePopup(boolean on) {
        this.popupEnabled = on;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = this.createPopupMenu();
        }
        return this.popup;
    }

    public void dispose() {
        this.suspendTooltipTimer();
        this.disableListeners();
        this.disposeComponents();
        if (this.mcFactory != null) {
            this.mcFactory.dispose();
        }
        this.mcFactory = null;
        if (this.toolbar != null) {
            this.toolbar.setVisible(false);
            if (this.toolbar instanceof GraphToolbarInterface) {
                ((GraphToolbarInterface)this.toolbar).removeAllListeners();
            }
        }
        this.toolbar = null;
        if (this.plotMatrixPanel != null) {
            this.plotMatrixPanel.removePropertyListener(this);
            this.plotMatrixPanel.dispose();
        }
        this.plotMatrixPanel = null;
        if (this.graphDialog != null) {
            this.graphDialog.setVisible(false);
            this.graphDialog.dispose();
        }
        this.graphDialog = null;
        if (this.dataDialog != null) {
            this.dataDialog.setVisible(false);
            this.dataDialog.dispose();
        }
        this.dataDialog = null;
        this.components = null;
        this.dataSource = null;
        this.filter = null;
        this.matrix = null;
        this.layout = null;
        this.popup = null;
        this.style = null;
        this.labelColor = null;
        this.rb = null;
        this.parentFrame = null;
        this.matrixVars = null;
        this.roles = null;
        this.matrixVar = null;
        this.externalXAxes = null;
        this.externalYAxes = null;
        if (this.tempCI != null) {
            this.tempCI.dispose();
        }
        this.tempCI = null;
        SILKGlobal.unregister((PropertyInterface)this);
        super.dispose();
    }

    public Dialog getDialog(Object id, Object listener) {
        if (id instanceof String) {
            String ID = (String)id;
            if (StringCompare.equals((String)ID, (String)"Properties")) {
                return this.graphDialog;
            }
            if (StringCompare.equals((String)ID, (String)"Data")) {
                return this.dataDialog;
            }
        }
        return null;
    }

    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        if (dialogIn == null) {
            return false;
        }
        if (id instanceof String) {
            String ID = (String)id;
            if (StringCompare.equals((String)ID, (String)"Properties")) {
                this.graphDialog = dialogIn;
                return true;
            }
            if (StringCompare.equals((String)ID, (String)"Data")) {
                this.dataDialog = dialogIn;
                return true;
            }
        }
        return false;
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return this.addTabs(id, dialogIn, category, this);
    }

    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    public int getSelectionBehavior() {
        return -1;
    }

    public Object getSelectionBehaviorValue() {
        return null;
    }

    public boolean setSelectionBehavior(int behavior, Object value) {
        boolean rc = true;
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                if (!(this.components[i] instanceof GraphInterface)) continue;
                rc |= ((GraphInterface)this.components[i]).setSelectionBehavior(behavior, value);
            }
        }
        return rc;
    }

    public void addViewportListener(Object listener) {
    }

    public void removeViewportListener(Object listener) {
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object idIn) {
        this.id = idIn;
    }

    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    public Object getChart(Object id) {
        int irow;
        int icol;
        int n = 0;
        JComponent[] out = null;
        if (this.components == null || this.components.length <= 0) {
            return null;
        }
        if (id == null) {
            out = new JComponent[this.components.length];
            if (out == null) {
                return null;
            }
            for (int i = 0; i < this.components.length; ++i) {
                out[i] = this.components[i];
            }
            return out;
        }
        int type = Extract.getSourceType((Object)id);
        n = Extract.getNumberItems((Object)id, (int)type);
        if (n <= 0) {
            return null;
        }
        switch (n) {
            case 1: {
                icol = Extract.getInteger((Object)id, (int)0, (int)type);
                irow = 0;
                break;
            }
            default: {
                irow = Extract.getInteger((Object)id, (int)0, (int)type);
                icol = Extract.getInteger((Object)id, (int)1, (int)type);
            }
        }
        int i = irow * this.matrixVars.size() + icol;
        if (i < 0 || i >= this.components.length) {
            return null;
        }
        return this.components[i];
    }

    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    public boolean isActionEnabled(String action) {
        return true;
    }

    public boolean isPropertySupported(int id) {
        if (this.components == null) {
            return false;
        }
        if (this.showExternalAxes) {
            switch (id) {
                case 44: 
                case 45: 
                case 46: 
                case 238: {
                    return true;
                }
                case 239: {
                    return false;
                }
            }
            if (this.isAxisPropertySupported(id)) {
                return true;
            }
        }
        switch (id) {
            case 0: 
            case 23: 
            case 71: {
                return true;
            }
            case 34: {
                return false;
            }
            case 21001: {
                return true;
            }
        }
        return this.mcFactory.isPropertySupported(id);
    }

    public boolean isPropertyPending(int id) {
        if (this.components == null) {
            return false;
        }
        if ((id == 0 || id == 21001) && !this.properties.isEmpty() && this.properties.containsKey(new Integer(id))) {
            return true;
        }
        if (this.showExternalAxes) {
            switch (id) {
                default: {
                    if (!this.isAxisPropertySupported(id)) break;
                    return this.isAxisPropertyPending(id);
                }
                case 239: {
                    return false;
                }
            }
        }
        return this.mcFactory.isPropertyPending(id);
    }

    private PropertyMulticaster getPropertyMulticaster(int id) {
        PropertyMulticaster pm = new PropertyMulticaster((Object)this.components);
        return pm;
    }

    public Object getPropertyValue(int id) {
        if (this.components == null) {
            return null;
        }
        if (id == 34) {
            return null;
        }
        switch (id) {
            default: {
                break;
            }
            case 261: {
                return Boolean.TRUE;
            }
            case 260: {
                return Boolean.FALSE;
            }
            case 248: {
                return Boolean.FALSE;
            }
            case 252: {
                return null;
            }
            case 0: {
                if (this.properties.isEmpty() || !this.properties.containsKey(new Integer(id))) break;
                Object value = this.properties.get(new Integer(id));
                if (value != null) {
                    return value;
                }
                return new ColorScheme(this.style);
            }
            case 71: {
                return Boolean.FALSE;
            }
            case 21001: {
                Object value;
                if (!this.properties.isEmpty() && this.properties.containsKey(id) && (value = this.properties.get(id)) != null) {
                    return value;
                }
                return this.getDiagonal();
            }
            case 2: {
                return new Boolean(this.tipsOn);
            }
            case 3: 
            case 7: {
                return this.getPropertyMulticaster(id);
            }
            case 601: 
            case 602: 
            case 603: {
                if (!super.isPropertySupported(id)) break;
                return super.getPropertyValue(id);
            }
        }
        if (this.showExternalAxes) {
            switch (id) {
                case 46: {
                    return new Object[]{this, this};
                }
                case 45: {
                    return new Object[]{this.X_AXIS_DISPLAY_NAME, this.Y_AXIS_DISPLAY_NAME};
                }
                case 44: {
                    return new Object[]{"X", "Y"};
                }
                case 238: {
                    return new Integer(this.currentAxis);
                }
                case 239: {
                    return null;
                }
            }
            if (this.isAxisPropertySupported(id)) {
                return this.getAxisPropertyValue(id);
            }
        }
        return this.mcFactory.getPropertyValue(id);
    }

    public boolean setPropertyValue(int id, Object value) {
        if (this.components == null) {
            return false;
        }
        switch (id) {
            case 23: {
                if (value == null) break;
                this.currentLegend = value.toString();
                break;
            }
            case 0: 
            case 2: 
            case 601: 
            case 602: 
            case 603: {
                if (!super.isPropertySupported(id)) break;
                return super.setPropertyValue(id, value);
            }
            case 21001: {
                this.properties.put(id, value);
                break;
            }
        }
        if (this.showExternalAxes) {
            block5 : switch (id) {
                case 238: {
                    Object v = value;
                    if (value != null && value instanceof PropertyEvent) {
                        v = ((PropertyEvent)value).value;
                    }
                    if (v != null && v instanceof Number) {
                        int curAxis = ((Number)v).intValue();
                        switch (curAxis) {
                            case 0: 
                            case 1: {
                                this.currentAxis = curAxis;
                                break block5;
                            }
                        }
                        return false;
                    }
                    if (v instanceof String) {
                        if ("X".equalsIgnoreCase(v.toString())) {
                            this.currentAxis = 0;
                            break;
                        }
                        if (!"Y".equalsIgnoreCase(v.toString())) break;
                        this.currentAxis = 1;
                        break;
                    }
                    return false;
                }
                case 239: {
                    return false;
                }
                case 246: {
                    if (!this.isAxisPropertySupported(id)) break;
                    this.setAxisPropertyValue(id, value);
                    break;
                }
                case 244: {
                    int ca = this.currentAxis;
                    this.currentAxis = 0;
                    if (this.isAxisPropertySupported(id)) {
                        this.setAxisPropertyValue(id, value);
                    }
                    this.currentAxis = ca;
                    break;
                }
                case 245: {
                    int ca = this.currentAxis;
                    this.currentAxis = 1;
                    if (this.isAxisPropertySupported(id)) {
                        this.setAxisPropertyValue(id, value);
                    }
                    this.currentAxis = ca;
                    break;
                }
                default: {
                    if (!this.isAxisPropertySupported(id)) break;
                    boolean rc = this.setAxisPropertyValue(id, value);
                    if (id == 229) break;
                    return rc;
                }
            }
        }
        return this.mcFactory.setPropertyValue(id, value);
    }

    public int getNumberPendingProperties() {
        return 0;
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    private boolean areChangesPending(Object source) {
        int[] list;
        Object o;
        int i;
        int size;
        if (this.externalXAxes != null && this.externalXAxes.size() > 0) {
            size = this.externalXAxes.size();
            for (i = 0; i < size; ++i) {
                o = this.externalXAxes.get(i);
                if (o == null || !(o instanceof PropertyInterface) || (list = ((PropertyInterface)o).getPendingChanges(source)) == null || list.length <= 0) continue;
                return true;
            }
        }
        if (this.externalYAxes != null && this.externalYAxes.size() > 0) {
            size = this.externalYAxes.size();
            for (i = 0; i < size; ++i) {
                o = this.externalYAxes.get(i);
                if (o == null || !(o instanceof PropertyInterface) || (list = ((PropertyInterface)o).getPendingChanges(source)) == null || list.length <= 0) continue;
                return true;
            }
        }
        if (this.mcFactory.areChangesPending(source)) {
            return true;
        }
        if (!this.properties.isEmpty()) {
            return true;
        }
        int[] list2 = super.getPendingChanges(source);
        return list2 != null && list2.length > 0;
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.components == null) {
            return false;
        }
        boolean returnVal = false;
        boolean propertyPending = this.areChangesPending(source);
        if (!propertyPending) {
            return false;
        }
        this.disableListeners();
        this.matrix.disableLayout();
        if (this.showExternalAxes) {
            returnVal = this.applyAxisPropertyChanges();
        }
        boolean rebuildMatrix = false;
        if (!this.properties.isEmpty()) {
            Enumeration keys = this.properties.keys();
            Enumeration values = this.properties.elements();
            while (keys.hasMoreElements()) {
                Integer i = (Integer)keys.nextElement();
                int key = -1;
                if (i != null) {
                    key = i;
                }
                Object value = values.nextElement();
                switch (key) {
                    case 0: {
                        Object v = value;
                        if (value instanceof PropertyEvent) {
                            v = ((PropertyEvent)value).value;
                        }
                        this.setColorScheme(v);
                        break;
                    }
                    case 21001: {
                        Object val;
                        if (value instanceof Number) {
                            this.setDiagonal(((Number)value).intValue());
                        } else if (value instanceof PropertyEvent && (val = ((PropertyEvent)value).value) instanceof Number) {
                            this.setDiagonal(((Number)val).intValue());
                        }
                        rebuildMatrix = true;
                    }
                }
            }
            this.properties.clear();
        }
        boolean bl = returnVal = this.mcFactory.applyPropertyChanges(source) || returnVal;
        if (returnVal) {
            this.updateLegend(this.colorRole.intValue(), false);
        }
        returnVal = super.applyPropertyChanges(source) || returnVal;
        this.graphLayout.getTitle().applyPropertyChanges(source);
        this.graphLayout.getFootnote().applyPropertyChanges(source);
        if (propertyPending) {
            this.graphLayout.doLayout((JComponent)((Object)this));
            if (this.graphLayout != null && this.graphLayout.getChartArea() != null) {
                this.matrix.setBounds(this.graphLayout.getChartArea());
            }
            this.matrix.enableLayout();
            this.enableListeners();
        }
        if (rebuildMatrix) {
            this.rebuildMatrix();
            this.revalidate();
        }
        this.setAxisPanelStatus();
        return returnVal;
    }

    public void cancelPropertyChanges() {
        if (this.components == null) {
            return;
        }
        if (this.showExternalAxes) {
            this.cancelAxisPropertyChanges();
        }
        this.properties.clear();
        this.mcFactory.cancelPropertyChanges();
        super.cancelPropertyChanges();
    }

    public void cancelPropertyChanges(Object source) {
        if (this.components == null) {
            return;
        }
        if (this.showExternalAxes) {
            this.cancelAxisPropertyChanges();
        }
        this.properties.clear();
        this.mcFactory.cancelPropertyChanges(source);
        super.cancelPropertyChanges(source);
    }

    public boolean hasUserSetValue(int id) {
        String wc;
        if (35 == id && ((wc = this.getWhereClause()) == null || wc.trim().length() == 0)) {
            return false;
        }
        return super.hasUserSetValue(id);
    }

    private ArrayList getCurrentAxes() {
        switch (this.currentAxis) {
            case 0: {
                return this.externalXAxes;
            }
            case 1: {
                return this.externalYAxes;
            }
        }
        return null;
    }

    private boolean isAxisPropertyPending(int id) {
        ArrayList axes = this.getCurrentAxes();
        if (axes == null || axes.size() == 0) {
            return false;
        }
        Object o = axes.get(0);
        if (o != null && o instanceof PropertyInterface) {
            PropertyInterface p = (PropertyInterface)o;
            return p.isPropertyPending(id);
        }
        return false;
    }

    private Object getAxisPropertyValue(int id) {
        ArrayList axes = this.getCurrentAxes();
        if (axes == null || axes.size() == 0) {
            if (id == 237) {
                return new Boolean(false);
            }
            return null;
        }
        Object o = null;
        switch (id) {
            case 249: 
            case 250: {
                Vector<Object> v = new Vector<Object>();
                for (int i = 0; i < axes.size(); ++i) {
                    Object o2;
                    o = axes.get(i);
                    if (!(o instanceof PropertyInterface) || (o2 = ((PropertyInterface)o).getPropertyValue(id)) == null) continue;
                    v.add(o2);
                }
                return new PropertyMulticaster(v);
            }
        }
        o = axes.get(0);
        if (o != null && o instanceof PropertyInterface) {
            PropertyInterface p = o;
            return p.getPropertyValue(id);
        }
        return null;
    }

    private boolean isAxisPropertySupported(int id) {
        ArrayList axes = this.getCurrentAxes();
        if (axes == null || axes.size() == 0) {
            return false;
        }
        Object o = axes.get(0);
        if (o != null && o instanceof PropertyInterface) {
            PropertyInterface p = (PropertyInterface)o;
            return p.isPropertySupported(id);
        }
        return false;
    }

    private boolean setAxisPropertyValue(int id, Object value) {
        ArrayList axes = this.getCurrentAxes();
        if (axes == null || axes.size() == 0) {
            return false;
        }
        boolean return_flag = true;
        int numAxes = axes.size();
        for (int i = 0; i < numAxes; ++i) {
            Object o = axes.get(i);
            if (o == null || !(o instanceof PropertyInterface)) continue;
            PropertyInterface p = (PropertyInterface)o;
            return_flag = return_flag && p.setPropertyValue(id, value);
        }
        return return_flag;
    }

    private boolean applyAxisPropertyChanges() {
        PropertyInterface p;
        Object o;
        int i;
        int size;
        boolean returnValue = true;
        if (this.externalXAxes != null && this.externalXAxes.size() > 0) {
            size = this.externalXAxes.size();
            for (i = 0; i < size; ++i) {
                o = this.externalXAxes.get(i);
                if (o == null || !(o instanceof PropertyInterface)) continue;
                p = (PropertyInterface)o;
                returnValue = p.applyPropertyChanges() && returnValue;
            }
        }
        if (this.externalYAxes != null && this.externalYAxes.size() > 0) {
            size = this.externalYAxes.size();
            for (i = 0; i < size; ++i) {
                o = this.externalYAxes.get(i);
                if (o == null || !(o instanceof PropertyInterface)) continue;
                p = (PropertyInterface)o;
                returnValue = p.applyPropertyChanges() && returnValue;
            }
        }
        return returnValue;
    }

    private void cancelAxisPropertyChanges() {
        PropertyInterface p;
        Object o;
        int i;
        int size;
        if (this.externalXAxes != null && this.externalXAxes.size() > 0) {
            size = this.externalXAxes.size();
            for (i = 0; i < size; ++i) {
                o = this.externalXAxes.get(i);
                if (o == null || !(o instanceof PropertyInterface)) continue;
                p = (PropertyInterface)o;
                p.cancelPropertyChanges();
            }
        }
        if (this.externalYAxes != null && this.externalYAxes.size() > 0) {
            size = this.externalYAxes.size();
            for (i = 0; i < size; ++i) {
                o = this.externalYAxes.get(i);
                if (o == null || !(o instanceof PropertyInterface)) continue;
                p = (PropertyInterface)o;
                p.cancelPropertyChanges();
            }
        }
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public Object getDataSource(Object id) {
        return this.getDataSource();
    }

    public boolean setDataSource(Object source) {
        if (source == null) {
            return false;
        }
        this.dataSource = source;
        this.filter = FilterFactory.getDataSourceFilter((Object)this.dataSource);
        if (this.filter == null) {
            return false;
        }
        this.mcFactory.setDataSource(source);
        return true;
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null) {
            return false;
        }
        if (id == null) {
            this.dataSource = source;
            this.filter = FilterFactory.getDataSourceFilter((Object)this.dataSource);
            if (this.filter == null) {
                return false;
            }
        }
        return this.mcFactory.setDataSource(source, id);
    }

    public Object getAllVariables(Object role) {
        if (role == null || this.matrixVars == null) {
            return null;
        }
        int roleVal = this.getRoleIntValue(role);
        if (roleVal == 39) {
            return this.matrixVars.toArray();
        }
        return this.mcFactory.getAllVariables(role);
    }

    public Object getVariable(Object role) {
        if (role == null || this.matrixVars == null || this.matrixVars.size() == 0) {
            return null;
        }
        int roleVal = this.getRoleIntValue(role);
        if (roleVal == 39) {
            return this.matrixVars.get(0);
        }
        return this.mcFactory.getVariable(role);
    }

    public Object getRole(Object variableId) {
        if (this.mcFactory == null) {
            return null;
        }
        Vector<String> roles = new Vector<String>();
        int numVars = this.matrixVars.size();
        if (this.matrixVars != null) {
            for (int i = 0; i < numVars; ++i) {
                if (!StringCompare.equals((String)this.matrixVars.get(i).toString(), (String)variableId.toString())) continue;
                roles.add(this.matrixVar);
            }
        }
        Object o = this.mcFactory.getRole(variableId);
        Enumeration e = Extract.elements((Object)o);
        while (e.hasMoreElements()) {
            roles.add((String)e.nextElement());
        }
        return roles.toArray();
    }

    public boolean setRole(Object variableId, Object role) {
        this.disableListeners();
        int roleVal = this.getRoleIntValue(role);
        if (roleVal == 39 && variableId != null) {
            int type = Extract.getSourceType((Object)variableId);
            int vars = Extract.getNumberItems((Object)variableId, (int)type);
            if (vars > 1) {
                this.matrixVars.clear();
            }
            Enumeration e = Extract.elements((Object)variableId);
            while (e.hasMoreElements()) {
                Object vid = e.nextElement();
                int varId = this.filter.getVariableIndex(vid);
                if (varId < 0 || varId > this.filter.getNumberVariables() || !this.filter.isNumericVariable(vid)) {
                    return false;
                }
                if (this.matrixVars.contains(vid)) continue;
                this.matrixVars.add(vid.toString());
            }
            int numVars = this.matrixVars.size();
            if (numVars > 1) {
                if (this.externalAxes) {
                    this.showExternalAxes = true;
                }
                for (int i = 0; i < numVars; ++i) {
                    if (this.filter.isNumericVariable(this.matrixVars.get(i))) continue;
                    this.showExternalAxes = false;
                }
            }
            this.rebuildMatrix();
            return true;
        }
        boolean return_flag = this.mcFactory.setRole(variableId, role);
        this.enableListeners();
        if (return_flag) {
            this.updateLegend(this.getRoleIntValue(role), true);
        }
        return return_flag;
    }

    public boolean addRole(Object variableId, Object role) {
        int roleVal = this.getRoleIntValue(role);
        if (roleVal == 39 && variableId != null) {
            Enumeration e = Extract.elements((Object)variableId);
            while (e.hasMoreElements()) {
                Object vid = e.nextElement();
                int varId = this.filter.getVariableIndex(vid);
                if (varId < 0 || varId > this.filter.getNumberVariables() || !this.filter.isNumericVariable(vid)) {
                    return false;
                }
                if (this.matrixVars.contains(vid)) continue;
                this.matrixVars.add(vid.toString());
            }
            int numVars = this.matrixVars.size();
            if (numVars > 1) {
                if (this.externalAxes) {
                    this.showExternalAxes = true;
                }
                for (int i = 0; i < numVars; ++i) {
                    if (this.filter.isNumericVariable(this.matrixVars.get(i))) continue;
                    this.showExternalAxes = false;
                }
            }
            this.rebuildMatrix();
            return true;
        }
        this.disableListeners();
        boolean return_flag = this.mcFactory.addRole(variableId, role);
        this.enableListeners();
        if (return_flag) {
            this.updateLegend(roleVal, true);
        }
        return return_flag;
    }

    public boolean removeRole(Object variableId, Object role) {
        this.disableListeners();
        int roleVal = this.getRoleIntValue(role);
        if (roleVal == 39 && this.matrixVars != null) {
            boolean rebuild = false;
            Enumeration e = Extract.elements((Object)variableId);
            while (e.hasMoreElements()) {
                String var = e.nextElement().toString();
                rebuild |= this.matrixVars.remove(var);
            }
            if (rebuild) {
                this.rebuildMatrix();
            }
        }
        boolean return_flag = this.mcFactory.removeRole(variableId, role);
        this.enableListeners();
        if (return_flag) {
            this.updateLegend(roleVal, true);
        }
        return return_flag;
    }

    public Object getRoleValue(Object role, int which) {
        return null;
    }

    public boolean isDiscrete(Object variableId) {
        return false;
    }

    public boolean setDiscrete(Object variableId, boolean discrete) {
        return false;
    }

    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Object[] componentRoles = null;
        if (this.mcFactory == null) {
            return null;
        }
        componentRoles = this.mcFactory.getSupportedRoles(id, discrete);
        return componentRoles;
    }

    public int getMaxAllowed(Object role) {
        if (role == null) {
            return 0;
        }
        int roleVal = this.getRoleIntValue(role);
        if (roleVal == 39) {
            return MAX_NUM_MATRIX_VARS;
        }
        if (this.components == null) {
            return 0;
        }
        return this.mcFactory.getMaxAllowed(role);
    }

    public boolean supportsMultipleAssignments(Object role) {
        return true;
    }

    public Object getSortOrder(Object role) {
        if (role == null) {
            return null;
        }
        if (this.components == null) {
            return null;
        }
        return this.mcFactory.getSortOrder(role);
    }

    public boolean setSortOrder(Object role, Object order) {
        return this.mcFactory.setSortOrder(role, order);
    }

    public void addRoleListener(RoleListenerInterface listener) {
    }

    public void removeRoleListener(RoleListenerInterface listener) {
    }

    public Object[] getDataIds() {
        if (this.mcFactory == null) {
            return null;
        }
        return this.mcFactory.getDataIds();
    }

    public Object getLimit(Object role) {
        return null;
    }

    public boolean setLimit(Object role, Object value) {
        return false;
    }

    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    public int getRoleIntValue(Object role) {
        int roleVal = -1;
        if (role instanceof Number) {
            roleVal = ((Number)role).intValue();
        } else if (role != null) {
            String s = role.toString();
            if (this.roles.equalsRoleNLSName("ROLE_MATRIX_VAR", s) || s.equalsIgnoreCase(this.engMatrixVar)) {
                roleVal = 39;
            } else if (this.roles.equalsRoleNLSName("ROLE_GROUP", s) || this.roles.getRoleUSName("ROLE_GROUP").equalsIgnoreCase(s)) {
                roleVal = 6;
            } else if (this.roles.equalsRoleNLSName("ROLE_GROUP_INDEX", s) || this.roles.getRoleUSName("ROLE_GROUP_INDEX").equalsIgnoreCase(s)) {
                roleVal = 7;
            } else if (this.roles.equalsRoleNLSName("ROLE_COLOR", s) || this.roles.getRoleUSName("ROLE_COLOR").equalsIgnoreCase(s)) {
                roleVal = 2;
            }
        }
        return roleVal;
    }

    public void rebuildMatrix() {
        Hashtable context = new Hashtable();
        Element compXML = this.mcFactory.getComponentStatgraphXML(context);
        Element xAxesXML = this.getAxisStatgraphXML(0, context);
        Element yAxesXML = this.getAxisStatgraphXML(1, context);
        Element legendXML = this.mcFactory.getLegendStatgraphXML(context);
        this.disposeComponents();
        this.removeAll();
        this.components = new JComponent[this.matrixVars.size() * this.matrixVars.size()];
        this.createTrellis();
        this.createMatrix();
        this.mcFactory.initComponentsFromXML(compXML, context);
        this.initAxesFromXML(0, context, xAxesXML);
        this.initAxesFromXML(1, context, yAxesXML);
        String whereClause = this.getWhereClause();
        if (whereClause != null && whereClause.trim().length() > 0) {
            this.applyWhereClause(whereClause, true);
        }
        this.updateLegend(6, true);
        this.mcFactory.initLegendsFromXML(legendXML);
        this.invalidate();
        this.validate();
        if (this.matrix != null && this.graphLayout != null && this.graphLayout.getChartArea() != null) {
            this.matrix.setBounds(this.graphLayout.getChartArea());
        }
        this.repaint();
        System.runFinalization();
        System.gc();
    }

    public void disposeComponents() {
        this.disableListeners();
        while (this.externalXAxes != null && this.externalXAxes.size() > 0) {
            this.externalXAxes.remove(0);
        }
        while (this.externalYAxes != null && this.externalYAxes.size() > 0) {
            this.externalYAxes.remove(0);
        }
        this.disposeTrellis();
        if (this.components != null) {
            for (int i = 0; i < this.components.length; ++i) {
                this.components[i] = null;
            }
        }
        this.components = null;
        if (this.mcFactory != null) {
            this.mcFactory.clearAllComponents();
        }
        if (this.toolbar != null && this.toolbar instanceof GraphToolbarInterface) {
            ((GraphToolbarInterface)this.toolbar).removeAllListeners();
            ((GraphToolbarInterface)this.toolbar).addListener((GraphInterface)this);
        }
    }

    protected void doResize(int compWidthIn, int compHeightIn) {
        if (compWidthIn == this.compWidth && compHeightIn == this.compHeight) {
            return;
        }
        super.doResize(compWidthIn, compHeightIn);
        if (this.matrix != null) {
            this.matrix.setBounds(this.graphLayout.getChartArea());
        }
        this.setAxesFontHeights(compWidthIn, compHeightIn);
    }

    public void setAxesFontHeights(int width, int height) {
        int numVars = this.matrixVars.size();
        if (numVars == 0 || this.filter == null) {
            return;
        }
        double rowHeight = (float)height / (float)numVars;
        double scaleFactor = 1.0 + (double)(this.matrixVars.size() - 1) / (double)this.matrixVars.size();
        double rh = rowHeight * scaleFactor;
        if (this.showExternalAxes) {
            for (int i = 0; i < numVars; ++i) {
                AxisComponent axis;
                boolean primary = true;
                if (this.alternateAxes) {
                    boolean bl = primary = i % 2 == 0;
                }
                if ((axis = (AxisComponent)this.matrix.getRowAxis(i, primary)) != null) {
                    axis.enableMarginPrefCalc();
                    axis.setDefaultFont(rh);
                }
                if ((axis = (AxisComponent)this.matrix.getColumnAxis(i, primary)) == null) continue;
                axis.enableMarginPrefCalc();
                axis.setDefaultFont(rh);
            }
        }
    }

    public void setAxesFontHeights(Rectangle r) {
        this.setAxesFontHeights(r.width, r.height);
    }

    public void setExternalAxesVisible(boolean flag) {
    }

    public boolean areExternalAxesVisible() {
        return this.externalAxes;
    }

    public boolean setAlternateAxes(boolean flag) {
        this.alternateAxes = flag;
        return true;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (graphics == null || pageFormat == null) {
            return 1;
        }
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)graphics;
            Dimension d = this.getSize();
            double scaleX = pageFormat.getImageableWidth() / (double)d.width;
            double scaleY = pageFormat.getImageableHeight() / (double)d.height;
            double scale = Math.min(scaleX, scaleY);
            double w = scale * (double)d.width;
            double ht = scale * (double)d.height;
            int xTrans = (int)Math.max((pageFormat.getImageableWidth() - w) / 2.0, 0.0);
            int yTrans = (int)Math.max((pageFormat.getImageableHeight() - ht) / 2.0, 0.0);
            g2.translate(pageFormat.getImageableX() + (double)xTrans, pageFormat.getImageableY() + (double)yTrans);
            AffineTransform defaultXfm = g2.getTransform();
            AffineTransform xfm = new AffineTransform(defaultXfm);
            xfm.scale(scale, scale);
            g2.setTransform(xfm);
            this.matrix.paint((Graphics)g2);
            return 0;
        }
        return 1;
    }

    public void setShowOnlyLowerTriangle(boolean f) {
        boolean b = this.showOnlyLowerTriangle;
        this.showOnlyLowerTriangle = f;
        if (b != this.showOnlyLowerTriangle) {
            this.rebuildMatrix();
        }
    }

    public void initChildrenFromXML(Element element, Hashtable context) {
        if (element == null) {
            return;
        }
        int i = -1;
        while (++i < this.components.length && !(this.components[i] instanceof GraphInterface)) {
        }
        if (i >= this.components.length) {
            return;
        }
        String compTagName = GraphParserFactory.getElementTagName((Object)this.components[i]);
        Element compXML = ParserUtils.getChildWithTagName((String)compTagName, (Element)element);
        this.mcFactory.initComponentsFromXML(compXML, context);
        Element xAxis = ParserUtils.getChildWithTagName((String)"XAxis", (Element)element);
        this.initAxesFromXML(0, context, xAxis);
        Element yAxis = ParserUtils.getChildWithTagName((String)"YAxis", (Element)element);
        this.initAxesFromXML(1, context, yAxis);
        if (this.showFullMatrix && this.showExternalAxes && this.getDiagonal() == 1) {
            int numVars = this.matrixVars.size();
            for (i = 0; i < numVars; ++i) {
                String xVar = this.matrixVars.get(i).toString();
                AxisInterface xa = (AxisInterface)this.externalXAxes.get(i);
                for (int j = 0; j < numVars; ++j) {
                    String yVar = this.matrixVars.get(j).toString();
                    AxisInterface ya = (AxisInterface)this.externalYAxes.get(j);
                    this.mcFactory.applyAxesToCrossing(xVar, yVar, xa, ya);
                }
            }
        }
        this.updateLegend(6, true);
        this.mcFactory.initLegendsFromXML(element);
    }

    public Element putChildXML(Hashtable context, Element element) {
        if (element == null) {
            return null;
        }
        Element compXML = this.mcFactory.getComponentStatgraphXML(context);
        Element xAxisXML = this.getAxisStatgraphXML(0, context);
        Element yAxisXML = this.getAxisStatgraphXML(1, context);
        Element legendXML = this.mcFactory.getLegendStatgraphXML(context);
        if (compXML == null) {
            return element;
        }
        element.appendChild(compXML);
        if (xAxisXML != null) {
            element.appendChild(xAxisXML);
        }
        if (yAxisXML != null) {
            element.appendChild(yAxisXML);
        }
        if (legendXML != null) {
            element.appendChild(legendXML);
        }
        return element;
    }

    private void initAxesFromXML(int axisType, Hashtable context, Element axisXML) {
        if (axisXML == null) {
            return;
        }
        ArrayList axes = null;
        switch (axisType) {
            case 0: {
                axes = this.externalXAxes;
                break;
            }
            case 1: {
                axes = this.externalYAxes;
                break;
            }
            default: {
                axes = null;
            }
        }
        if (axes == null) {
            return;
        }
        AxisParser ap = new AxisParser();
        for (int i = 0; i < axes.size(); ++i) {
            Object o = axes.get(i);
            if (!(o instanceof AxisComponent)) continue;
            ap.getFromXML(context, axisXML, (Object)((AxisComponent)o).getInternalAxis());
        }
    }

    private Element getAxisStatgraphXML(int axisType, Hashtable context) {
        ArrayList axes = null;
        String axisName = null;
        switch (axisType) {
            case 0: {
                axes = this.externalXAxes;
                axisName = "XAxis";
                break;
            }
            case 1: {
                axisName = "YAxis";
                axes = this.externalYAxes;
                break;
            }
            default: {
                axes = null;
            }
        }
        if (axes == null || axes.size() <= 0) {
            return null;
        }
        Object o = axes.get(0);
        if (!(o instanceof AxisComponent)) {
            return null;
        }
        AxisParser ap = new AxisParser();
        if (context == null) {
            context = new Hashtable();
        }
        return ap.putToXML(context, o, axisName);
    }

    public boolean getUsageMode(int mode) {
        return false;
    }

    public void setUsageMode(int mode, boolean on) {
    }

    public boolean setComponentType(int compType) {
        if (this.componentType == compType) {
            return true;
        }
        switch (compType) {
            case 1: 
            case 2: {
                this.componentType = compType;
                break;
            }
            default: {
                return false;
            }
        }
        switch (compType) {
            default: {
                this.setMatrixChartFactory(new ScatterMatrixChartFactory());
                break;
            }
            case 2: {
                this.setMatrixChartFactory(new DensityPlotMatrixChartFactory());
            }
        }
        return true;
    }

    public int getComponentType() {
        return this.componentType;
    }

    public boolean setMatrixChartFactory(AbstractMatrixChartFactory amcFactory) {
        if (amcFactory == null) {
            return false;
        }
        this.mcFactory = amcFactory;
        return true;
    }

    public boolean isVariableDescriptionUsed() {
        return this.showDescription;
    }

    public void setUseVariableDescription(boolean useVariableDescription) {
        if (this.showDescription == useVariableDescription) {
            return;
        }
        this.showDescription = useVariableDescription;
        String label = "<HTML><CENTER>{0}</CENTER></HTML>";
        for (int i = 0; i < this.matrixVars.size(); ++i) {
            Object[] args = new Object[]{this.showDescription ? this.filter.getVariableDescription(this.matrixVars.get(i)).toString() : this.matrixVars.get(i)};
            String text = MessageFormat.format(label, args);
            Component c = this.matrix.getCellItem(i, i);
            if (!(c instanceof JLabel)) continue;
            ((JLabel)c).setText(text);
        }
    }

    public String getToolTipText(MouseEvent me) {
        if (this.mouseEventSource != this && this.mouseEventSource instanceof LayerInterface) {
            if (this.mouseEventSource instanceof Component) {
                this.tipLocation = new Point(this.matrix.getX() + ((Component)this.mouseEventSource).getX() + me.getX(), this.matrix.getY() + ((Component)this.mouseEventSource).getY() + me.getY());
            }
            return ((LayerInterface)this.mouseEventSource).getTipText(me.getX(), me.getY());
        }
        return null;
    }

    private int getNumberOfLegends() {
        LegendInterface[] li = this.graphLayout.getLegends();
        if (li != null) {
            return li.length;
        }
        return 0;
    }

    private void removeLegends() {
        LegendInterface[] legends;
        LegendInterface[] li = this.graphLayout.getLegends();
        if (li != null) {
            for (int i = 0; i < li.length; ++i) {
                this.graphLayout.removeLegend(li[i]);
            }
        }
        if ((legends = this.mcFactory.getLegends()) != null) {
            for (int i = 0; i < legends.length; ++i) {
                this.graphLayout.removeLegend(legends[i]);
                if (!(legends[i] instanceof LegendObjectJ2D)) continue;
                this.removeMouseListener((MouseListener)((LegendObjectJ2D)legends[i]));
                this.removeMouseMotionListener((MouseMotionListener)((LegendObjectJ2D)legends[i]));
            }
        }
    }

    protected boolean legendUpdateRequired() {
        boolean rc = false;
        if (this.mcFactory == null) {
            return rc;
        }
        LegendInterface[] legends = this.mcFactory.getLegends();
        if (legends != null) {
            Enumeration e = Extract.elements((Object)legends);
            while (e.hasMoreElements()) {
                Object l = e.nextElement();
                if (!(l instanceof LegendObjectJ2D)) continue;
                rc |= ((LegendObjectJ2D)l).isUpdateRequired();
            }
        }
        return rc;
    }

    private void updateLegend(int roleInt, boolean rebuildLegends) {
        switch (roleInt) {
            case 2: 
            case 6: 
            case 7: {
                int numLegends = this.getNumberOfLegends();
                if (rebuildLegends) {
                    this.removeLegends();
                }
                this.mcFactory.buildLegends(roleInt, rebuildLegends);
                if (rebuildLegends) {
                    LegendInterface[] legends = this.mcFactory.getLegends();
                    if (legends == null && numLegends == 0) {
                        return;
                    }
                    if (legends != null) {
                        Enumeration e = Extract.elements((Object)legends);
                        while (e.hasMoreElements()) {
                            Object l = e.nextElement();
                            if (l instanceof LegendInterface) {
                                this.graphLayout.addLegend((LegendInterface)l);
                            }
                            if (!(l instanceof LegendObjectJ2D)) continue;
                            this.addMouseListener((MouseListener)((LegendObjectJ2D)l));
                            this.addMouseMotionListener((MouseMotionListener)((LegendObjectJ2D)l));
                        }
                    }
                }
                this.graphLayout.doLayout((JComponent)((Object)this));
                if (this.matrix != null) {
                    this.matrix.setBounds(this.graphLayout.getChartArea());
                }
                this.invalidate();
                this.validate();
                this.repaint();
                if (!(this.graphDialog instanceof GraphPropertiesDialog)) break;
                ((GraphPropertiesDialog)this.graphDialog).updateLegendPanels((PropertyInterface)this, (Object)this);
            }
        }
    }

    public void setDiagonal(int type) {
        if (this.mcFactory != null) {
            this.mcFactory.setDiagonal(type);
        }
    }

    public int getDiagonal() {
        if (this.mcFactory != null) {
            return this.mcFactory.getDiagonal();
        }
        return -1;
    }

    public Object[] getAssignedVariables() {
        Object[] compRoles = this.getSupportedRoles(null, true);
        Object[] supportedRoles = compRoles == null ? new Object[1] : new Object[compRoles.length + 1];
        supportedRoles[0] = RoleInterface.ROLE_MATRIX_VAR;
        if (compRoles != null) {
            for (int i = 0; i < compRoles.length; ++i) {
                supportedRoles[i + 1] = compRoles[i];
            }
        }
        Vector vars = new Vector();
        for (int i = 0; i < supportedRoles.length; ++i) {
            Object allVars = this.getAllVariables(supportedRoles[i]);
            if (allVars == null) continue;
            Enumeration e = Extract.elements((Object)allVars);
            while (e.hasMoreElements()) {
                Object var = e.nextElement();
                if (vars.contains(var)) continue;
                vars.add(var);
            }
        }
        return vars.toArray();
    }

    private class MatrixVarsAction
    extends AbstractAction {
        MatrixVarsAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseMatrixComponent.this.showMatrixVarsDialog();
        }
    }

    private class VerticalLabel
    extends JVerticalLabel {
        VerticalLabel(String text, boolean topDown) {
            super(text, topDown);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            d.width = d.width + fm.getDescent() + 4;
            return d;
        }
    }
}

