/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.AbstractDeployment;
import com.sas.management.deployment.MessageUtil;
import com.sas.management.deployment.MetadataUtility;
import com.sas.metadata.remote.MetadataResource;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Report {
    protected static MetadataResource bundle = new MetadataResource(Report.class);
    StreamSource m_InputSource = null;
    String m_InputFileName = "";
    String m_ReportString = "";
    String m_FileName = null;

    public Report(String InputFile, String serverReturn) {
        this.m_InputSource = new StreamSource(new StringReader(serverReturn));
        this.m_InputFileName = InputFile;
        this.createReport(this.m_InputSource);
    }

    private void createReport(StreamSource source) {
        String xslfile = "com/sas/management/deployment/res/Report.xsl";
        try {
            String jarlocation = MetadataUtility.getJarLocation();
            JarFile jf = new JarFile(jarlocation);
            JarEntry entry = (JarEntry)jf.getEntry(xslfile);
            BufferedReader br = new BufferedReader(new InputStreamReader(jf.getInputStream(entry)));
            StringWriter outWriter = new StringWriter();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(br));
            transformer.setParameter("file", this.m_InputFileName);
            Date date = new Date();
            String fd = DateFormat.getDateTimeInstance().format(date);
            transformer.setParameter("date", fd);
            transformer.transform(source, new StreamResult(outWriter));
            this.m_ReportString = outWriter.toString();
            transformer = null;
            tFactory = null;
        }
        catch (IOException io) {
            MessageUtil.printStackTrace(io);
        }
        catch (TransformerConfigurationException e) {
            MessageUtil.printStackTrace(e);
        }
        catch (TransformerException e) {
            MessageUtil.printStackTrace(e);
        }
    }

    public void writeToFile() {
        try {
            StringBuffer fileName = new StringBuffer(this.m_InputFileName);
            int index = this.m_InputFileName.lastIndexOf(95);
            if (index < 0) {
                index = this.m_InputFileName.lastIndexOf(46);
            }
            fileName.replace(index, fileName.length(), "_report.html");
            this.m_FileName = fileName.toString();
            BufferedWriter bw = new BufferedWriter(new FileWriter(AbstractDeployment.getFileLocation() + this.m_FileName));
            String st = MetadataUtility.formatXML(this.m_ReportString);
            bw.write(st);
            bw.close();
        }
        catch (IOException e) {
            MessageUtil.printMessage(bundle.getString("Report.error.WritingReport.txt"), 2);
            MessageUtil.printStackTrace(e);
        }
    }
}

