/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.AbstractDeployment;
import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.MessageUtil;
import com.sas.metadata.remote.MdFactory;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetadataUtility {
    private static final String JAR_FILE_NAME = "sas.oma.deployment.jar";

    public static String getMetadata(MdFactory factory, String objectType, String objectID, String templateName) throws DeploymentException {
        String returnXML = "";
        StringHolder outXML = new StringHolder();
        String namespace = "SAS";
        int flags = 0;
        StringBuffer metadata = new StringBuffer(40);
        metadata.append("<");
        metadata.append(objectType);
        metadata.append(" Id=\"");
        metadata.append(objectID);
        metadata.append("\" Name=\"\" PublicType=\"\" />");
        if (AbstractDeployment.getDebug()) {
            StringBuffer inputXML = new StringBuffer(75);
            inputXML.append("<GetMetadata><Metadata>");
            inputXML.append(metadata);
            inputXML.append("</Metadata><NS>");
            inputXML.append(namespace);
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options/></GetMetadata>");
            MessageUtil.printLoglnClient(inputXML.toString());
        }
        try {
            factory.getConnection().getCMRHandle().GetMetadata(metadata.toString(), outXML, namespace, flags, "");
            String outXMLString = outXML.value;
            MessageUtil.printLoglnServer(outXMLString);
            Document doc = factory.getOMIUtil().parseXML(outXMLString);
            returnXML = MetadataUtility.addExtractTemplateAttribute(doc, templateName);
        }
        catch (Exception e) {
            MessageUtil.printStackTrace(e);
            throw new DeploymentException(e);
        }
        return returnXML;
    }

    public static String getMetadataObjects(MdFactory factory, String objectType, String searchValue, String reposID, String templateName) throws DeploymentException {
        String returnXML = "";
        StringHolder outXML = new StringHolder();
        String namespace = "SAS";
        int flags = 388;
        StringBuffer options = new StringBuffer();
        options.append("<XMLSelect search=\"" + searchValue + "\"/>");
        options.append("<Templates><");
        options.append(objectType);
        options.append(" PublicType=\"\" /></Templates>");
        if (AbstractDeployment.getDebug()) {
            StringBuffer inputXML = new StringBuffer(100);
            inputXML.append("<GetMetadataObjects><Reposid>");
            inputXML.append(reposID);
            inputXML.append("</Reposid><Type>");
            inputXML.append(objectType);
            inputXML.append("</Type><NS>");
            inputXML.append(namespace);
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append(options);
            inputXML.append("</Options></GetMetadataObjects>");
            MessageUtil.printLoglnClient(inputXML.toString());
        }
        try {
            factory.getConnection().getCMRHandle().GetMetadataObjects(reposID, objectType, outXML, namespace, flags, options.toString());
            String outXMLString = outXML.value;
            MessageUtil.printLoglnServer(outXMLString);
            if (outXMLString.length() > 10) {
                Document doc = factory.getOMIUtil().parseXML(outXMLString);
                returnXML = MetadataUtility.addExtractTemplateAttribute(doc, templateName);
            }
        }
        catch (Exception e) {
            MessageUtil.printStackTrace(e);
            throw new DeploymentException(e);
        }
        return returnXML;
    }

    public static String getMetadataObjects(MdFactory factory, String objectType, String searchValue, String reposID) throws DeploymentException {
        String returnXML = "";
        StringHolder outXML = new StringHolder();
        String namespace = "SAS";
        int flags = 8320;
        String options = "<XMLSelect search=\"" + MetadataUtility.cleanStringForXML(searchValue) + "\"/>";
        if (AbstractDeployment.getDebug()) {
            StringBuffer inputXML = new StringBuffer(100);
            inputXML.append("<GetMetadataObjects><Reposid>");
            inputXML.append(reposID);
            inputXML.append("</Reposid><Type>");
            inputXML.append(objectType);
            inputXML.append("</Type><NS>");
            inputXML.append(namespace);
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append(options);
            inputXML.append("</Options></GetMetadataObjects>");
            MessageUtil.printLoglnClient(inputXML.toString());
        }
        try {
            factory.getConnection().getCMRHandle().GetMetadataObjects(reposID, objectType, outXML, namespace, flags, options);
            returnXML = outXML.value;
            MessageUtil.printLoglnServer(returnXML);
        }
        catch (Exception e) {
            MessageUtil.printStackTrace(e);
            throw new DeploymentException(e);
        }
        return returnXML;
    }

    public static String getRepositories(MdFactory factory, String searchValue, boolean searchForName) throws DeploymentException {
        String returnXML = "";
        StringHolder outXML = new StringHolder();
        String namespace = "REPOS";
        String type = "RepositoryBase";
        int flags = 128;
        String options = searchForName ? "<XMLSelect search=\"*[@Id='" + searchValue + "']\"/>" : "<XMLSelect search=\"*[@Name='" + searchValue + "']\"/>";
        if (AbstractDeployment.getDebug()) {
            StringBuffer inputXML = new StringBuffer(100);
            inputXML.append("<GetMetadataObjects><ReposId>A0000001.A0000001</ReposId><Type>");
            inputXML.append(type);
            inputXML.append("</Type><NS>");
            inputXML.append(namespace);
            inputXML.append("</NS><Flags>0");
            inputXML.append("</Flags><Options>");
            inputXML.append(options);
            inputXML.append("</Options></GetMetadataObjects>");
            MessageUtil.printLoglnClient(inputXML.toString());
        }
        try {
            factory.getConnection().getCMRHandle().GetMetadataObjects("A0000001.A0000001", type, outXML, namespace, flags, options);
            returnXML = outXML.value;
            MessageUtil.printLoglnServer(returnXML);
        }
        catch (Exception e) {
            MessageUtil.printStackTrace(e);
            throw new DeploymentException(e);
        }
        return returnXML;
    }

    public static String DoRequest(MdFactory factory, String inXML) throws DeploymentException {
        MessageUtil.printLoglnClient(inXML);
        StringHolder outXML = new StringHolder();
        try {
            factory.getConnection().getCMRHandle().DoRequest(inXML, outXML);
        }
        catch (Exception e) {
            MessageUtil.printMessage(e.getMessage(), 2);
            MessageUtil.printStackTrace(e);
            throw new DeploymentException(e);
        }
        String outXMLString = outXML.value;
        MessageUtil.printLoglnServer(outXMLString);
        return outXMLString;
    }

    private static String addExtractTemplateAttribute(Document doc, String templateName) {
        StringBuffer returnXML = new StringBuffer();
        Node node = doc.getFirstChild();
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement = (Element)nodeList.item(i);
                if (templateName != null) {
                    childElement.setAttribute("TemplateName", templateName);
                }
                returnXML.append(MetadataUtility.createXMLStringForNode(childElement));
            }
        } else {
            if (templateName != null) {
                ((Element)node).setAttribute("TemplateName", templateName);
            }
            returnXML.append(MetadataUtility.createXMLStringForNode(node));
        }
        return returnXML.toString();
    }

    public static String createXMLStringForNode(Node node) {
        NodeList childNodes;
        if (node == null) {
            return "";
        }
        String nodeName = node.getNodeName();
        if (nodeName.charAt(0) == '#') {
            if (node.getNodeType() == 4) {
                StringBuffer sb = new StringBuffer();
                sb.append("<![CDATA[");
                sb.append(node.getNodeValue());
                sb.append("]]>");
                return sb.toString();
            }
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(nodeName);
        NamedNodeMap map = node.getAttributes();
        if (map.getLength() > 0) {
            sb.append(" ");
            for (int j = 0; j < map.getLength(); ++j) {
                Node attr = map.item(j);
                sb.append(attr.getNodeName());
                sb.append("=\"");
                sb.append(MetadataUtility.cleanStringForXML(attr.getNodeValue()));
                sb.append("\" ");
            }
        }
        if ((childNodes = node.getChildNodes()).getLength() > 0) {
            sb.append(">");
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node n = childNodes.item(i);
                if (n == null) continue;
                sb.append(MetadataUtility.createXMLStringForNode(n));
            }
            sb.append("</").append(nodeName).append(">");
        } else {
            sb.append("/>");
        }
        return sb.toString();
    }

    public static String formatXML(String original) {
        boolean newLine = false;
        char[] chars = new char[original.length()];
        original.getChars(0, original.length(), chars, 0);
        int indent = 0;
        StringBuffer output = new StringBuffer();
        int length = chars.length;
        for (int index = 0; index < length; ++index) {
            if (chars[index] == '<') {
                int indentIndex;
                if (chars[index + 1] != '/') {
                    if (index > 0) {
                        newLine = true;
                        output.append('\n');
                        for (indentIndex = 0; indentIndex < indent; ++indentIndex) {
                            output.append('\t');
                        }
                    }
                    if (chars[index + 1] != '!') {
                        ++indent;
                    }
                } else {
                    --indent;
                    if (newLine) {
                        output.append('\n');
                        newLine = false;
                        for (indentIndex = 0; indentIndex < indent; ++indentIndex) {
                            output.append('\t');
                        }
                    }
                }
            }
            if (chars[index] != '\t' && chars[index] != '\n') {
                output.append(chars[index]);
            }
            if (chars[index] != '>') continue;
            if (chars[index - 1] != '/') {
                if (newLine) {
                    newLine = false;
                    continue;
                }
                newLine = true;
                continue;
            }
            if (!newLine) {
                output.append('\n');
            }
            --indent;
        }
        original = null;
        chars = null;
        return output.toString();
    }

    public static String escapeQuotationMarks(String s) {
        int quotationMark = 34;
        if (s != null && s.indexOf(34) > -1) {
            StringBuffer parsed = new StringBuffer();
            block3: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\"': {
                        parsed.append("&#");
                        parsed.append(Integer.toString(c));
                        parsed.append(';');
                        continue block3;
                    }
                    default: {
                        parsed.append(c);
                    }
                }
            }
            return parsed.toString();
        }
        return s;
    }

    public static String cleanStringForXML(String s) {
        StringBuffer parsed = new StringBuffer();
        if (s == null) {
            return "";
        }
        block3: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '<': 
                case '>': 
                case '\\': {
                    parsed.append("&#");
                    parsed.append(Integer.toString(c));
                    parsed.append(';');
                    continue block3;
                }
                default: {
                    parsed.append(c);
                }
            }
        }
        return parsed.toString();
    }

    public static String removeDollarSignsFromString(String s) {
        if (s == null) {
            return "";
        }
        int length = s.length();
        StringBuffer parsed = new StringBuffer(s.length());
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '$') {
                parsed.append("&#");
                parsed.append(Integer.toString(c));
                parsed.append(';');
                continue;
            }
            parsed.append(c);
        }
        return parsed.toString();
    }

    public static String getJarLocation() throws IOException {
        try {
            Enumeration<URL> urls = ClassLoader.getSystemResources("com/sas/management/deployment/res");
            while (urls.hasMoreElements()) {
                String path;
                int index;
                URL url = urls.nextElement();
                if (!url.getProtocol().equalsIgnoreCase("jar") || (index = (path = url.getPath()).indexOf(JAR_FILE_NAME)) <= -1) continue;
                int start = 5;
                path = path.substring(start, index + JAR_FILE_NAME.length());
                path = URLDecoder.decode(path, "UTF-8");
                return path;
            }
        }
        catch (IOException e) {
            MessageUtil.printStackTrace(e);
            throw e;
        }
        return JAR_FILE_NAME;
    }
}

