/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.AbstractDeployment;
import com.sas.management.deployment.DeleteMetadata;
import com.sas.management.deployment.DeployMetadata;
import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.DeploymentMapping;
import com.sas.management.deployment.DeploymentObject;
import com.sas.management.deployment.ExtractMetadata;
import com.sas.management.deployment.MessageUtil;
import com.sas.management.deployment.validate.ValidationException;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MetadataResource;
import com.sas.workspace.WorkspaceFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class MetadataDeployment {
    protected static MetadataResource bundle = new MetadataResource(MetadataDeployment.class);
    public static final int RETURN_CODE_SUCCESS = 0;
    public static final int RETURN_CODE_WARNING = 1;
    public static final int RETURN_CODE_ERROR = 2;
    public static final int RETURN_CODE_VALIDATION = 4;
    private static boolean m_Extract = false;
    private static boolean m_Deploy = false;
    private static boolean m_AutoMap = false;
    private static boolean m_AutoMapOverride = false;
    private static boolean m_DeployOnly = false;
    private static boolean m_ExpandOnly = false;
    private static boolean m_ExtractOnly = false;
    private static boolean m_createReport = false;
    private static boolean m_passwordOnStandardIn = false;
    private static boolean m_Delete = false;
    private static String m_User = null;
    private static String m_Password = null;
    private static String m_Server = null;
    private static String m_Port = null;
    private static String m_TargetUser = null;
    private static String m_TargetPassword = null;
    private static String m_TargetServer = null;
    private static String m_TargetPort = null;
    private static String m_MapRepos = null;
    private static String m_SourceWorkspaceFile = null;
    private static String m_TargetWorkspaceFile = null;
    private static String m_LogFileName = null;
    private static String m_ExpandFileName = null;
    private static String m_ExtractFileName = null;
    private static String m_InputFileName = null;
    private static String m_ExtractedServerXMLFileName = null;
    private static String m_DeployFileName = null;
    private static String m_ValidationFileName = null;
    private static String m_DeleteMetadataType = null;
    private static String m_DeleteMetadataSearch = null;
    private static String m_RepositoryName = null;
    private int _rc = 0;

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || args[i].length() <= 0 || args[i].charAt(0) != '-') continue;
            if (args[i].equalsIgnoreCase("-sourceServer")) {
                m_Server = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-sourcePort")) {
                m_Port = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-sourceUser")) {
                m_User = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-sourcePassword")) {
                m_Password = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-targetServer")) {
                m_TargetServer = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-targetPort")) {
                m_TargetPort = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-targetUser")) {
                m_TargetUser = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-targetPassword")) {
                m_TargetPassword = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-mapRepos")) {
                m_MapRepos = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-sourceWorkspaceFile")) {
                m_SourceWorkspaceFile = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-targetWorkspaceFile")) {
                m_TargetWorkspaceFile = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-input")) {
                m_InputFileName = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-extractFile")) {
                m_ExtractedServerXMLFileName = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-extract")) {
                m_Extract = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-deploy")) {
                m_Deploy = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expandOnly")) {
                m_ExpandOnly = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-extractOnly")) {
                m_ExtractOnly = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-autoMapOnly")) {
                m_AutoMap = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-autoMapOverride")) {
                m_AutoMapOverride = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-deployOnly")) {
                m_DeployOnly = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-deployFile")) {
                m_DeployFileName = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-validate")) {
                m_ValidationFileName = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                AbstractDeployment.setDebug(true);
                continue;
            }
            if (args[i].equalsIgnoreCase("-logfile")) {
                m_LogFileName = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-appendToLog")) {
                AbstractDeployment.appendToLogFile(true);
                continue;
            }
            if (args[i].equalsIgnoreCase("-setExpandFileName")) {
                m_ExpandFileName = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-setExtractFileName")) {
                m_ExtractFileName = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-setFileLocation")) {
                AbstractDeployment.setFileLocation(args[i + 1]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-quiet")) {
                AbstractDeployment.setQuiet(true);
                continue;
            }
            if (args[i].equalsIgnoreCase("-encodePasswords")) {
                AbstractDeployment.setEncodePasswords(true);
                continue;
            }
            if (args[i].equalsIgnoreCase("-password_on_stdin")) {
                m_passwordOnStandardIn = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-createReport")) {
                m_createReport = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-delete")) {
                m_Delete = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-deleteType")) {
                m_DeleteMetadataType = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-deleteSearch")) {
                m_DeleteMetadataSearch = args[i + 1];
                continue;
            }
            if (args[i].equalsIgnoreCase("-repositoryName")) {
                m_RepositoryName = args[i + 1];
                continue;
            }
            if (!args[i].equalsIgnoreCase("-help")) continue;
            StringBuffer sb = new StringBuffer();
            sb.append(bundle.getString("MetadataDeployment.Help.Intro.txt"));
            sb.append("\n\n").append(bundle.getString("MetadataDeployment.Help.ServerIntro.txt"));
            sb.append("\n-sourceServer: ").append(bundle.getString("MetadataDeployment.Help.SourceServer.txt"));
            sb.append("\n-sourcePort: ").append(bundle.getString("MetadataDeployment.Help.SourcePort.txt"));
            sb.append("\n-sourceUser: ").append(bundle.getString("MetadataDeployment.Help.SourceUser.txt"));
            sb.append("\n-sourcePassword: ").append(bundle.getString("MetadataDeployment.Help.SourcePassword.txt"));
            sb.append("\n-sourceWorkspaceFile: ").append(bundle.getString("MetadataDeployment.Help.SourceWkspFile.txt"));
            sb.append("\n-targetServer: ").append(bundle.getString("MetadataDeployment.Help.TargetServer.txt"));
            sb.append("\n-targetPort: ").append(bundle.getString("MetadataDeployment.Help.TargetPort.txt"));
            sb.append("\n-targetUser: ").append(bundle.getString("MetadataDeployment.Help.TargetUser.txt"));
            sb.append("\n-targetPassword: ").append(bundle.getString("MetadataDeployment.Help.TargetPassword.txt"));
            sb.append("\n-targetWorkspaceFile: ").append(bundle.getString("MetadataDeployment.Help.TargetWkspFile.txt"));
            sb.append("\n\n").append(bundle.getString("MetadataDeployment.Help.OptionsIntro.txt"));
            sb.append("\n-extract: ").append(bundle.getString("MetadataDeployment.Help.Extract.txt"));
            sb.append("\n-extractOnly: ").append(bundle.getString("MetadataDeployment.Help.ExtractOnly.txt"));
            sb.append("\n-expandOnly: ").append(bundle.getString("MetadataDeployment.Help.ExpandOnly.txt"));
            sb.append("\n-deploy: ").append(bundle.getString("MetadataDeployment.Help.Deploy.txt"));
            sb.append("\n-deployOnly: ").append(bundle.getString("MetadataDeployment.Help.DeployOnly.txt"));
            sb.append("\n-autoMapOnly: ").append(bundle.getString("MetadataDeployment.Help.AutoMap.txt"));
            sb.append("\n-autoMapOverride: ").append(bundle.getString("MetadataDeployment.Help.AutoMapOverride.txt"));
            sb.append("\n-mapRepos: ").append(bundle.getString("MetadataDeployment.Help.MapRepos.txt"));
            sb.append("\n-input: ").append(bundle.getString("MetadataDeployment.Help.Input.txt"));
            sb.append("\n-extractFile: ").append(bundle.getString("MetadataDeployment.Help.ExtractFile.txt"));
            sb.append("\n-deployFile: ").append(bundle.getString("MetadataDeployment.Help.DeployFile.txt"));
            sb.append("\n-logFile: ").append(bundle.getString("MetadataDeployment.Help.LogFile.txt"));
            sb.append("\n-appendToLog: ").append(bundle.getString("MetadataDeployment.Help.AppendToLog.txt"));
            sb.append("\n-setFileLocation: ").append(bundle.getString("MetadataDeployment.Help.SetFileLocation.txt"));
            sb.append("\n-createReport: ").append(bundle.getString("MetadataDeployment.Help.Report.txt"));
            sb.append("\n-debug: ").append(bundle.getString("MetadataDeployment.Help.Debug.txt"));
            sb.append("\n-quiet: ").append("MetadataDeployment.Help.Quiet.txt");
            System.out.println(sb.toString());
            return;
        }
        MetadataDeployment deployment = new MetadataDeployment();
        deployment.process();
        int returnCode = deployment.getReturnCode();
        returnCode = (returnCode & 4) > 0 ? 4 : ((returnCode & 2) > 0 ? 2 : ((returnCode & 1) > 0 ? 1 : 0));
        m_Password = null;
        m_TargetPassword = null;
        System.exit(returnCode);
    }

    public void process() {
        try {
            if (m_Extract || m_ExpandOnly || m_ExtractOnly) {
                this.extract();
            }
            if (m_Deploy || m_AutoMap || m_AutoMapOverride || m_DeployOnly) {
                this.deploy();
            }
            if (m_Delete) {
                this.delete();
            }
        }
        catch (Exception e) {
            this._rc |= 2;
            System.err.println(e.getLocalizedMessage());
        }
        finally {
            m_Password = null;
            m_TargetPassword = null;
            MessageUtil.printMessage(bundle.messageString("AbstractDeployment.EndProcess.txt", (Object)new Date()), 0);
        }
    }

    public void extract() throws DeploymentException, IOException, MdException {
        String msg;
        if (m_passwordOnStandardIn && (m_Password = this.readValueFromStandardIn("-sourcePassword", msg = bundle.getString("MetadataDeployment.SpecifySourcePassword.txt"), "UTF-8")) == null) {
            System.err.println(msg);
            return;
        }
        ExtractMetadata extract = m_SourceWorkspaceFile == null ? new ExtractMetadata(m_Server, m_Port, m_User, m_Password) : new ExtractMetadata(this.getWorkspaceFile(m_SourceWorkspaceFile));
        try {
            AbstractDeployment.setLogFileName(m_LogFileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        MessageUtil.printMessage(bundle.messageString("AbstractDeployment.StartProcess.txt", (Object)new Date()), 0);
        extract.initialize();
        if (extract.getFactory().getConnection().getCMRHandle() != null) {
            boolean createFiles;
            if (m_InputFileName == null) {
                MessageUtil.printMessage(bundle.getString("AbstractDeployment.NoInputFile.txt"), 2);
                return;
            }
            String sExpandedXML = null;
            String sExtractedXML = null;
            File input = new File(m_InputFileName);
            boolean bl = createFiles = !AbstractDeployment.isQuiet();
            if (m_ExpandOnly) {
                if (m_ExpandFileName == null) {
                    extract.expandXML(input, createFiles);
                } else {
                    extract.expandXML(input, createFiles, m_ExpandFileName);
                }
            } else if (m_ExtractOnly) {
                sExtractedXML = m_ExtractFileName == null ? extract.extractXML(input, createFiles) : extract.extractXML(input, createFiles, m_ExtractFileName);
            } else {
                sExpandedXML = m_ExpandFileName == null ? extract.expandXML(input, createFiles) : extract.expandXML(input, createFiles, m_ExpandFileName);
                if (extract.objectsFoundDuringExpansion()) {
                    sExtractedXML = m_ExtractFileName == null ? extract.extractXML(sExpandedXML, createFiles) : extract.extractXML(sExpandedXML, createFiles, m_ExtractFileName);
                } else {
                    MessageUtil.printMessage(bundle.getString("AbstractDeployment.Expansion.NoObjects.txt"), 1);
                    extract.closeConnection();
                    return;
                }
            }
            if (m_Deploy) {
                if (m_ExtractedServerXMLFileName == null) {
                    m_ExtractedServerXMLFileName = m_ExtractFileName == null ? extract.createExtractFileName(m_InputFileName) : m_ExtractFileName;
                }
                if (AbstractDeployment.getFileLocation().length() > 0) {
                    m_ExtractedServerXMLFileName = AbstractDeployment.getFileLocation() + m_ExtractedServerXMLFileName;
                }
                m_DeployFileName = extract.getDeployFileName();
                AbstractDeployment.appendToLogFile(true);
            }
            if (sExtractedXML == null && !m_ExpandOnly) {
                MessageUtil.printMessage(bundle.getString("AbstractDeployment.ExtractFail.txt"), 2);
            }
            sExpandedXML = null;
            sExtractedXML = null;
            extract.closeConnection();
            this._rc |= extract.getReturnCode();
        }
    }

    public void deploy() throws DeploymentException, IOException, MdException {
        String msg;
        if (m_passwordOnStandardIn && (m_TargetPassword = this.readValueFromStandardIn("-targetPassword", msg = bundle.getString("MetadataDeployment.SpecifyTargetPassword.txt"), "UTF-8")) == null) {
            System.err.println(msg);
            return;
        }
        DeploymentMapping.setVerifyExtractVersion(false);
        DeployMetadata deploy = m_TargetWorkspaceFile == null ? new DeployMetadata(m_TargetServer, m_TargetPort, m_TargetUser, m_TargetPassword) : new DeployMetadata(this.getWorkspaceFile(m_TargetWorkspaceFile));
        try {
            AbstractDeployment.setLogFileName(m_LogFileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (!m_Extract && !m_ExtractOnly) {
            MessageUtil.printMessage(bundle.messageString("AbstractDeployment.StartProcess.txt", (Object)new Date()), 0);
        }
        deploy.initialize();
        if (deploy.getFactory().getConnection().getCMRHandle() != null) {
            if (m_ExtractedServerXMLFileName == null) {
                MessageUtil.printMessage(bundle.getString("AbstractDeployment.NoExtractFile.txt"), 2);
                deploy.closeConnection();
                return;
            }
            if (m_MapRepos != null) {
                deploy.mapRepositories(m_MapRepos);
            }
            File input = new File(m_ExtractedServerXMLFileName);
            File deployFile = new File(m_DeployFileName);
            if (m_AutoMap) {
                deploy.autoMapConnectionPoints(input, deployFile, 2);
            } else if (m_AutoMapOverride) {
                deploy.autoMapConnectionPoints(input, deployFile, 1);
            } else if (m_DeployOnly) {
                deploy.deployOnly(input, deployFile);
                List topLevelObjects = deploy.getTopLevelObjects();
                Map targetMappings = deploy.getDeployedObjects();
                this.displayOutput(topLevelObjects, targetMappings);
            } else {
                if (m_ValidationFileName != null && m_ValidationFileName.length() > 0) {
                    File validationFile = new File(m_ValidationFileName);
                    if (validationFile.exists()) {
                        try {
                            deploy.validateMetadata(validationFile);
                        }
                        catch (IOException e) {
                            this._rc |= 1;
                        }
                    } else {
                        MessageUtil.printMessage(bundle.messageString("MetadataDeployment.NoValidationFile.txt", (Object)m_ValidationFileName), 2);
                        return;
                    }
                }
                try {
                    deploy.deploy(input, deployFile, 2);
                    List topLevelObjects = deploy.getTopLevelObjects();
                    Map targetMappings = deploy.getDeployedObjects();
                    this.displayOutput(topLevelObjects, targetMappings);
                }
                catch (ValidationException e) {
                    this._rc |= 4;
                }
            }
            if (m_createReport && !AbstractDeployment.isQuiet()) {
                deploy.createReport();
            }
            deploy.closeConnection();
            this._rc |= deploy.getReturnCode();
        }
    }

    public void delete() throws DeploymentException, IOException, MdException {
        String msg;
        if (m_passwordOnStandardIn && (m_TargetPassword = this.readValueFromStandardIn("-targetPassword", msg = bundle.getString("MetadataDeployment.SpecifyTargetPassword.txt"), "UTF-8")) == null) {
            System.err.println(msg);
            return;
        }
        DeleteMetadata delete = m_TargetWorkspaceFile == null ? new DeleteMetadata(m_TargetServer, m_TargetPort, m_TargetUser, m_TargetPassword) : new DeleteMetadata(this.getWorkspaceFile(m_TargetWorkspaceFile));
        try {
            AbstractDeployment.setLogFileName(m_LogFileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        MessageUtil.printMessage(bundle.messageString("AbstractDeployment.StartProcess.txt", (Object)new Date()), 0);
        delete.initialize();
        if (delete.getFactory().getConnection().getCMRHandle() != null) {
            if (m_ExtractedServerXMLFileName == null) {
                MessageUtil.printMessage(bundle.getString("AbstractDeployment.NoExtractFile.txt"), 2);
                this._rc |= 2;
                delete.closeConnection();
                return;
            }
            File extractXML = new File(m_ExtractedServerXMLFileName);
            delete.delete(extractXML, m_RepositoryName, m_DeleteMetadataType, m_DeleteMetadataSearch);
            if (m_createReport && !AbstractDeployment.isQuiet()) {
                delete.createReport();
            }
            delete.closeConnection();
            this._rc |= delete.getReturnCode();
        }
    }

    public int getReturnCode() {
        return this._rc;
    }

    private void displayOutput(List topLevelObjects, Map targetMappings) {
        if (topLevelObjects != null && targetMappings != null) {
            int count = 0;
            Iterator iter = topLevelObjects.iterator();
            while (iter.hasNext()) {
                if (count == 0) {
                    System.out.println("\r\n");
                }
                ++count;
                DeploymentObject obj = (DeploymentObject)iter.next();
                String sourceID = obj.getObjectID();
                String targetID = (String)targetMappings.get(sourceID);
                if (targetID == null) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("fqid=");
                sb.append(targetID);
                sb.append(" type=");
                sb.append(obj.getType());
                sb.append(" name=");
                sb.append(obj.getName());
                System.out.println(sb.toString());
            }
        }
    }

    private WorkspaceFile getWorkspaceFile(String strFile) {
        if (strFile.lastIndexOf(File.separator) > -1) {
            return new WorkspaceFile(strFile);
        }
        WorkspaceFile wksp = new WorkspaceFile();
        StringBuffer workspacePath = new StringBuffer();
        workspacePath.append(System.getProperty("user.home"));
        workspacePath.append(File.separator);
        workspacePath.append("Workspaces");
        workspacePath.append(File.separator);
        workspacePath.append(strFile);
        String name = workspacePath.toString();
        File f = new File(name);
        if (f.exists()) {
            wksp.setFileName(name);
            wksp.openExisting(name);
            return wksp;
        }
        MessageUtil.printMessage(bundle.messageString("AbstractDeployment.NoWorkspaceFile.txt", (Object)name), 2);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readValueFromStandardIn(String optionName, String promptMessage, String charsetName) throws IOException {
        String value = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(System.in, charsetName));
            for (int i = 0; i < 3; ++i) {
                String inData;
                if (promptMessage != null) {
                    System.out.print(promptMessage);
                }
                if ((inData = reader.readLine()) == null) {
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(inData.trim(), " ");
                    String token = null;
                    while (stringTokenizer.hasMoreTokens()) {
                        token = stringTokenizer.nextToken();
                        if (!optionName.equals(token) || (token = stringTokenizer.nextToken()) == null || (token = token.trim()).length() <= 0) continue;
                        value = token;
                        break;
                    }
                    if (value == null) continue;
                }
                break;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return value;
    }
}

