/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.AbstractDeployment;
import com.sas.management.deployment.DeployFile;
import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.ExtractMethod;
import com.sas.management.deployment.ExtractTemplate;
import com.sas.management.deployment.MdMethodCall;
import com.sas.management.deployment.MessageUtil;
import com.sas.management.deployment.MetadataUtility;
import com.sas.management.deployment.SAXHandler;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.workspace.WorkspaceFile;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ExtractMetadata
extends AbstractDeployment {
    private boolean m_ObjectsFound = false;
    private ExtractMethod m_ExtractMethod = null;
    private Map _defaultTemplateMap;
    private Map _userDefinedTemplateMap;
    private boolean _isDeployFileSeparate = true;
    private String m_DeployFileName = null;
    private String _userData = null;

    public ExtractMetadata(MdFactory factory) {
        super(factory);
    }

    public ExtractMetadata(IOMI connection) throws RemoteException, MdException {
        this.setOMRConnection(connection);
    }

    public ExtractMetadata(WorkspaceFile file) throws RemoteException, MdException {
        this.m_WorkspaceFile = file;
    }

    public ExtractMetadata(String host, String port, String user, String password) throws RemoteException, MdException {
        this.m_Host = host;
        this.m_Port = port;
        this.m_User = user;
        this.m_Password = password;
    }

    public void initialize() throws DeploymentException, IOException, RemoteException {
        if (this.m_ConnectionHandle == null) {
            this.makeOMRConnection();
        }
    }

    public String expandXML(File inputFile) throws DeploymentException, IOException {
        return this.expandXML(inputFile, true);
    }

    public String expandXML(File inputFile, boolean createExpandFile) throws DeploymentException, IOException {
        if (inputFile == null) {
            return null;
        }
        String defaultFileName = this.createExpandFileName(inputFile.getName());
        return this.expandXML(inputFile, createExpandFile, defaultFileName);
    }

    public String expandXML(File inputFile, boolean createExpandFile, String expandFileName) throws DeploymentException, IOException {
        if (inputFile == null || !inputFile.exists()) {
            MessageUtil.printMessage(bundle.getString("AbstractDeployment.NoInputFile.txt"), 2);
            return null;
        }
        m_InputFileName = inputFile.getName();
        String xml = ExtractMetadata.getFileContents(inputFile);
        return this.expandXML(xml, createExpandFile, expandFileName);
    }

    public String expandXML(String inputXML) throws DeploymentException, IOException {
        return this.expandXML(inputXML, true);
    }

    public String expandXML(String inputXML, boolean createExpandFile) throws DeploymentException, IOException {
        return this.expandXML(inputXML, createExpandFile, m_InputFileName == null ? "expand.xml" : this.createExpandFileName(m_InputFileName));
    }

    public String expandXML(String inputXML, boolean createExpandFile, String expandFileName) throws DeploymentException, IOException {
        SAXHandler handler = new SAXHandler(this);
        String expandedXML = null;
        boolean parsed = this.parseXML(handler, inputXML);
        if (parsed) {
            String metadataObjects = this.retrieveObjects();
            expandedXML = this.transformXML(metadataObjects);
            if (createExpandFile) {
                this.writeToFile(expandFileName, MetadataUtility.formatXML(expandedXML));
            }
        }
        return expandedXML;
    }

    public String createInputString(Map objectMap, String reposID) {
        StringBuffer sb = new StringBuffer();
        sb.append("<ExtractMetadata><Metadata>");
        for (String type : objectMap.keySet()) {
            List objects = (List)objectMap.get(type);
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                sb.append("<");
                sb.append(type);
                sb.append(" Id=\"");
                sb.append((String)objects.get(i));
                sb.append("\"/>");
            }
        }
        sb.append("</Metadata><ReposId>");
        sb.append(reposID);
        sb.append("</ReposId><ns>SAS</ns><Flags/><Options/></ExtractMetadata>");
        return sb.toString();
    }

    public String createInputXMLForExtract(Map objectMap, String reposID) {
        StringBuffer sb = new StringBuffer();
        StringBuffer templateBuffer = new StringBuffer();
        sb.append("<ExtractMetadata><Metadata>");
        for (String type : objectMap.keySet()) {
            List objects = (List)objectMap.get(type);
            String objectType = null;
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    ExtractTemplate template = null;
                    if (this._userDefinedTemplateMap != null && this._userDefinedTemplateMap.containsKey(type)) {
                        template = (ExtractTemplate)this._userDefinedTemplateMap.get(type);
                    }
                    if (template != null) {
                        objectType = template.getObjectType();
                        templateBuffer.append(template.getText());
                    }
                }
                sb.append("<");
                sb.append(objectType);
                sb.append(" Id=\"");
                sb.append((String)objects.get(i));
                sb.append("\" TemplateName=\"");
                sb.append(type);
                sb.append("\" ExtractTemplate=\"");
                sb.append(type);
                sb.append("\"/>");
            }
        }
        sb.append("</Metadata><ReposId>");
        sb.append(reposID);
        sb.append("</ReposId><ns>SAS</ns><flags>");
        sb.append(4);
        sb.append("</flags>");
        sb.append("<Options><ExtractTemplates>");
        sb.append(templateBuffer);
        sb.append("</ExtractTemplates></Options></ExtractMetadata>");
        return sb.toString();
    }

    public void addExtractTemplate(String template) {
        if (this._userDefinedTemplateMap == null) {
            this._userDefinedTemplateMap = new HashMap();
        }
        if (template != null && template.indexOf("ExtractTemplate") > -1) {
            ExtractTemplate temp = this.parseTemplate(template);
            this._userDefinedTemplateMap.put(temp.getTemplateName(), temp);
        }
    }

    public String extractXML(File inputFile) throws DeploymentException, IOException {
        return this.extractXML(inputFile, true);
    }

    public String extractXML(File inputFile, boolean createExtractFile) throws DeploymentException, IOException {
        if (inputFile == null) {
            return null;
        }
        String defaultFileName = this.createExtractFileName(inputFile.getName());
        return this.extractXML(inputFile, createExtractFile, defaultFileName);
    }

    public String extractXML(File inputFile, boolean createExtractFile, String extractFileName) throws DeploymentException, IOException {
        String xml = ExtractMetadata.getFileContents(inputFile);
        return this.extractXML(xml, createExtractFile, extractFileName);
    }

    public String extractXML(String inputXML) throws DeploymentException, IOException {
        return this.extractXML(inputXML, true);
    }

    public String extractXML(String inputXML, boolean createExtractFile) throws DeploymentException, IOException {
        return this.extractXML(inputXML, createExtractFile, m_InputFileName == null ? "extract.xml" : this.createExtractFileName(m_InputFileName));
    }

    public String extractXML(String inputXML, boolean createExtractFile, String extractFileName) throws DeploymentException, IOException {
        String extractedXML = MetadataUtility.DoRequest(this._factory, inputXML);
        if (extractedXML != null) {
            if (createExtractFile) {
                if (this._userData != null && this._userData.length() > 0) {
                    extractedXML = this.createCDataSection(extractedXML);
                }
                this.writeToFile(extractFileName, MetadataUtility.formatXML(extractedXML));
            }
            if (this._isDeployFileSeparate) {
                DeployFile df = new DeployFile(extractFileName, extractedXML);
                df.createDeployFile();
                df.writeToFile();
                this.m_DeployFileName = df.getDeployFileName();
            }
        }
        return extractedXML;
    }

    public boolean objectsFoundDuringExpansion() {
        return this.m_ObjectsFound;
    }

    public void createSeparateDeployFile(boolean b) {
        this._isDeployFileSeparate = b;
    }

    public boolean isDeployFileSeparate() {
        return this._isDeployFileSeparate;
    }

    public String getDeployFileName() {
        return this.m_DeployFileName;
    }

    public void addUserDefinedData(String data) {
        this._userData = data;
    }

    public void removeUserDefinedData() {
        this._userData = null;
    }

    public Map getDefaultTemplates() {
        return this._defaultTemplateMap;
    }

    @Override
    public void dispose() {
        this.m_ExtractMethod = null;
        this._defaultTemplateMap = null;
    }

    private String createCDataSection(String input) {
        StringBuffer cdata = new StringBuffer(35 + this._userData.length());
        cdata.append("<UserData><![CDATA[");
        cdata.append(this._userData);
        cdata.append("]]></UserData>");
        int index = input.indexOf("</DeployMap");
        StringBuffer sb = new StringBuffer(input.length() + cdata.length());
        sb.append(input);
        sb.insert(index, cdata);
        return sb.toString();
    }

    protected String createExpandFileName(String inputFileName) {
        StringBuffer sb = new StringBuffer(inputFileName);
        int index = inputFileName.lastIndexOf(46);
        if (index < 0) {
            index = inputFileName.length();
        }
        sb.insert(index, "_expand");
        return sb.toString();
    }

    protected String createExtractFileName(String fileName) {
        int index;
        StringBuffer sb = new StringBuffer(fileName);
        int i = fileName.indexOf("_expand");
        if (i > -1) {
            sb.delete(i, i + 7);
            fileName = sb.substring(0);
        }
        if ((index = fileName.lastIndexOf(46)) < 0) {
            index = fileName.length();
        }
        sb.insert(index, "_extract");
        return sb.toString();
    }

    protected void setExtractMethod(ExtractMethod method) {
        this.m_ExtractMethod = method;
    }

    private boolean parseXML(SAXHandler handler, String inputXML) throws DeploymentException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(false);
            parserFactory.setValidating(true);
            parserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser parser = parserFactory.newSAXParser();
            if (inputXML != null && inputXML.length() > 0) {
                StringReader sr = new StringReader(inputXML);
                InputSource is = new InputSource(sr);
                parser.parse(is, (DefaultHandler)handler);
                parser = null;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            String msg = bundle.getString("ExtractMetadata.Warning.ParsingError.txt");
            MessageUtil.printMessage(msg, 2);
            MessageUtil.printStackTrace(e);
            throw new DeploymentException(msg, e);
        }
    }

    private String retrieveObjects() throws DeploymentException {
        StringBuffer objectBuffer = new StringBuffer();
        objectBuffer.append("<Metadata>");
        int len = this.m_ExtractMethod.getMethodCalls().size();
        for (int i = 0; i < len; ++i) {
            String object;
            ExtractTemplate template;
            MdMethodCall method = (MdMethodCall)this.m_ExtractMethod.getMethodCalls().get(i);
            String templateName = method.getTemplateName();
            if (templateName != null && (template = (ExtractTemplate)this.m_ExtractMethod.getTemplateMap().get(templateName)) != null) {
                method.setObjectType(template.getObjectType());
            }
            if (method.getSearchType().equalsIgnoreCase("Id")) {
                objectBuffer.append("<!-- ");
                objectBuffer.append(method.getObjectType());
                objectBuffer.append(": Id = ");
                objectBuffer.append(method.getSearchValue());
                objectBuffer.append(" -->\n");
                object = MetadataUtility.getMetadata(this._factory, method.getObjectType(), method.getSearchValue(), templateName);
                if (object.length() == 0) {
                    MessageUtil.printMessage(bundle.messageString("ExtractMetadata.Warning.ObjectNotFound.txt", (Object)method.getObjectType(), (Object)method.getSearchValue()), 1);
                    this._rc |= 1;
                } else {
                    this.m_ObjectsFound = true;
                    objectBuffer.append(object);
                }
            } else if (method.getSearchType().equalsIgnoreCase("Search")) {
                objectBuffer.append("<!-- ");
                objectBuffer.append(method.getObjectType());
                objectBuffer.append(": Searched for ");
                objectBuffer.append(method.getSearchValue());
                objectBuffer.append(" -->\n");
                object = MetadataUtility.getMetadataObjects(this._factory, method.getObjectType(), method.getSearchValue(), this.m_ExtractMethod.getReposID(), templateName);
                if (object.length() == 0) {
                    MessageUtil.printMessage(bundle.messageString("ExtractMetadata.Warning.ObjectsNotFound.txt", (Object)method.getObjectType(), (Object)method.getSearchValue()), 1);
                    this._rc |= 1;
                } else {
                    this.m_ObjectsFound = true;
                    objectBuffer.append(object);
                }
            }
            objectBuffer.append("\n");
        }
        objectBuffer.append("</Metadata>");
        return objectBuffer.toString();
    }

    private String transformXML(String replacementXML) {
        Pattern metaTagPattern = Pattern.compile("<metadata>(.*)</metadata>", 2);
        Pattern optionsTagPattern = Pattern.compile("(<Options>|<Options/>)", 2);
        StringBuffer sb = new StringBuffer(this.m_ExtractMethod.getMethodXML().length());
        Matcher m = metaTagPattern.matcher(this.m_ExtractMethod.getMethodXML());
        if (m.find()) {
            if (replacementXML.indexOf(36) > -1) {
                replacementXML = MetadataUtility.removeDollarSignsFromString(replacementXML);
            }
            m.appendReplacement(sb, replacementXML);
        }
        m.appendTail(sb);
        switch (this.m_ExtractMethod.getOptionsState()) {
            case 0: {
                int insertIndex = sb.lastIndexOf("</ExtractMetadata>");
                sb.insert(insertIndex - 1, this.m_ExtractMethod.addExtractTemplates(true));
                break;
            }
            case 1: {
                m = optionsTagPattern.matcher(sb.substring(0));
                if (!m.find()) break;
                String s1 = m.group(1);
                if (s1.equalsIgnoreCase("<Options/>")) {
                    sb.delete(m.start(1), m.end(1));
                    sb.insert(m.start(1) - 1, this.m_ExtractMethod.addExtractTemplates(true));
                    break;
                }
                int endIndex = sb.indexOf("</Options>", m.start(1));
                if (endIndex == -1) {
                    endIndex = sb.indexOf("<options>", m.start(1));
                }
                sb.delete(m.start(1), endIndex + 10);
                sb.insert(m.start(1), this.m_ExtractMethod.addExtractTemplates(true));
                break;
            }
            case 2: {
                m = optionsTagPattern.matcher(sb.substring(0));
                if (!m.find()) break;
                int index = sb.lastIndexOf("</ExtractTemplates>");
                if (index == -1) {
                    index = m.start() + 9;
                    String templates = "<ExtractTemplates> " + this.m_ExtractMethod.addExtractTemplates(false) + "</ExtractTemplates>";
                    sb.insert(index, templates);
                    break;
                }
                sb.insert(index, this.m_ExtractMethod.addExtractTemplates(false));
            }
        }
        return sb.toString();
    }

    private ExtractTemplate parseTemplate(String text) {
        if (text == null) {
            return null;
        }
        String templateType = "";
        int startIndex = 1;
        int index = text.indexOf("Type=\"");
        if (index == -1) {
            index = text.indexOf("type=\"");
        }
        ExtractTemplate template = null;
        if (index > -1) {
            startIndex = text.indexOf(34, index + 6);
            templateType = text.substring(index + 6, startIndex);
            template = new ExtractTemplate(templateType, text);
            int endIndex = text.indexOf(62, startIndex);
            if (endIndex > startIndex + 1) {
                String attributeString = text.substring(startIndex + 1, endIndex);
                int searchIndex = attributeString.indexOf("Search");
                if (searchIndex < 0) {
                    searchIndex = attributeString.indexOf("search");
                }
                if (searchIndex > -1) {
                    int begin = attributeString.indexOf(34, searchIndex);
                    int end = attributeString.indexOf(34, begin + 1);
                    template.setTemplateSearch(attributeString.substring(begin + 1, end));
                }
            }
        }
        if (templateType != null && template != null) {
            if (templateType.equalsIgnoreCase("Default")) {
                template.setObjectType("Root");
            } else {
                int endIndex2;
                int index1 = text.indexOf(60, startIndex);
                int endIndex1 = text.indexOf(32, index1);
                int index2 = Math.min(endIndex1, endIndex2 = text.indexOf(62, index1));
                if (index2 < 0) {
                    index2 = Math.max(endIndex1, endIndex2);
                }
                template.setObjectType(text.substring(index1 + 1, index2));
            }
        }
        return template;
    }
}

