/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.AbstractDeployment;
import com.sas.management.deployment.ConnectionPoint;
import com.sas.management.deployment.DeployDocument;
import com.sas.management.deployment.DeployFile;
import com.sas.management.deployment.DeployOutputParser;
import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.DeploymentMapping;
import com.sas.management.deployment.MessageUtil;
import com.sas.management.deployment.MetadataUtility;
import com.sas.management.deployment.Report;
import com.sas.management.deployment.validate.DeploymentValidation;
import com.sas.management.deployment.validate.ValidationException;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.WorkspaceFile;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeployMetadata
extends AbstractDeployment {
    public static final int OMI_EXCLUDE_SECURITY = 524288;
    public static final int AUTOMAP_OFF_STATE = 0;
    public static final int AUTOMAP_OVERRIDE_STATE = 1;
    public static final int AUTOMAP_IFNECESSARY_STATE = 2;
    private static final Pattern reposIDPattern = Pattern.compile("(<ReposId>)([0-9a-zA-Z.$]+)(</ReposId>)", 2);
    private Map m_RepositoryMapping = null;
    private boolean m_Validate = false;
    private String m_ValidationXML;
    private boolean _removeSecurity = false;
    private List _topLevelObjects = null;
    private int _repositoryIndex = -1;
    private String m_ExtractXML = null;
    private String m_ModifiedDeployXML;
    private String m_DeployedXML;
    private File m_DeployFile = null;
    private Document m_DeployDoc = null;
    private boolean m_bAutoMapFailed = false;

    public DeployMetadata(MdFactory factory) {
        super(factory);
    }

    public DeployMetadata(IOMI connection) throws RemoteException, MdException {
        this.setOMRConnection(connection);
    }

    public DeployMetadata(WorkspaceFile file) throws RemoteException, MdException {
        this.m_WorkspaceFile = file;
    }

    public DeployMetadata(String host, String port, String user, String password) throws RemoteException, MdException {
        this.m_Host = host;
        this.m_Port = port;
        this.m_User = user;
        this.m_Password = password;
    }

    public void initialize() throws DeploymentException, RemoteException {
        if (this.m_ConnectionHandle == null) {
            this.makeOMRConnection();
        }
    }

    @Override
    public void dispose() throws RemoteException {
        super.dispose();
        this.m_ExtractXML = null;
        this.m_ModifiedDeployXML = null;
        this.m_DeployedXML = null;
        this.m_DeployFile = null;
        if (this.m_RepositoryMapping != null) {
            this.m_RepositoryMapping.clear();
            this.m_RepositoryMapping = null;
        }
    }

    public List getTopLevelObjects() {
        return this._topLevelObjects;
    }

    public void removeSecurity(boolean remove) {
        this._removeSecurity = remove;
    }

    public void validateMetadata(File validationFile) throws IOException {
        this.m_Validate = true;
        this.m_ValidationXML = DeployMetadata.getFileContents(validationFile);
    }

    public void deployOnly(File inputFile, File deployFile) throws DeploymentException, IOException {
        this.deploy(inputFile, deployFile, 0);
    }

    public void deploy(File inputFile, File deployFile) throws DeploymentException, IOException {
        this.deploy(inputFile, deployFile, 2);
    }

    public void deploy(File inputFile, int autoMapState) throws DeploymentException, IOException {
        String xml = DeployMetadata.getFileContents(inputFile);
        this.deploy(xml, autoMapState);
    }

    public void deploy(String inputXML, int autoMapState) throws DeploymentException, RemoteException {
        String extractXML = this.autoMapConnectionPoints(inputXML, autoMapState);
        String modifiedExtractXML = this.transformExtractedXML(extractXML);
        this.m_DeployedXML = MetadataUtility.DoRequest(this._factory, modifiedExtractXML);
        extractXML = null;
        modifiedExtractXML = null;
    }

    public void deploy(File inputFile, File deployFile, int autoMapState) throws DeploymentException, IOException {
        String updatedExtractXML = this.autoMapConnectionPoints(inputFile, deployFile, autoMapState);
        if (!this.m_bAutoMapFailed) {
            if (this.m_Validate) {
                DeploymentValidation validate = new DeploymentValidation(this._factory, updatedExtractXML, this.m_ValidationXML);
                validate.setRepositoryMapping(this.m_RepositoryMapping);
                if (!validate.validateXML()) {
                    throw new ValidationException(bundle.getString("DeployMetadata.Error.Validation.txt"));
                }
            }
            String deployXML = this.transformExtractedXML(updatedExtractXML);
            this.m_DeployedXML = MetadataUtility.DoRequest(this._factory, deployXML);
        }
    }

    private String autoMapConnectionPoints(DeploymentMapping mapping, int autoMapState) throws DeploymentException {
        if (this.m_RepositoryMapping != null) {
            this.validateRepositoryMap(mapping);
            mapping.setTargetRepositoryIDs(this.m_RepositoryMapping);
        } else {
            mapping.autoMapRepositories();
            this.m_RepositoryMapping = mapping.getRepositoryMap();
        }
        if (this.m_RepositoryMapping.size() == 0) {
            String msg = bundle.getString("DeployMetadata.Warning.NoReposMapping.txt");
            MessageUtil.printMessage(msg, 2);
            this.m_bAutoMapFailed = true;
            throw new DeploymentException(msg);
        }
        List connectionPoints = mapping.getConnectionPoints();
        for (ConnectionPoint pt : connectionPoints) {
            if (!pt.isActive()) continue;
            if (autoMapState == 1) {
                mapping.autoMapConnectionPoint(pt);
                continue;
            }
            if (autoMapState != 2 || pt.getTargetObjectID() != null) continue;
            mapping.autoMapConnectionPoint(pt);
        }
        String updatedExtractXML = mapping.getUpdatedExtractString();
        return this.replaceRepositoryID(updatedExtractXML);
    }

    public String autoMapConnectionPoints(File extractXML, File deployFile, int autoMapState) throws DeploymentException, IOException {
        DeploymentMapping mapping = new DeploymentMapping(this._factory, extractXML, deployFile);
        String updatedExtractXML = this.autoMapConnectionPoints(mapping, autoMapState);
        this._topLevelObjects = mapping.getTopLevelObjects();
        if (autoMapState != 0 && !DeployMetadata.isQuiet()) {
            String deploy_xml = mapping.getUpdatedDeployMapString();
            if (DeployMetadata.isEncodingPasswords()) {
                deploy_xml = this.handlePasswords(deploy_xml, true);
            }
            DeployFile df = new DeployFile(deployFile.getName(), deploy_xml);
            df.createDeployFile();
            df.writeToFile();
        }
        if (DeployMetadata.isEncodingPasswords()) {
            return this.handlePasswords(updatedExtractXML, false);
        }
        return updatedExtractXML;
    }

    public String autoMapConnectionPoints(String extractXML, int autoMapState) throws DeploymentException, RemoteException {
        if (autoMapState == 0) {
            return this.updateRepositoryIDinExtractFile(extractXML);
        }
        DeploymentMapping mapping = new DeploymentMapping(this._factory, extractXML);
        return this.autoMapConnectionPoints(mapping, autoMapState);
    }

    private void autoMap(String inputXML, File deployFile, int state) throws DeploymentException, IOException {
        Pattern deployMapPattern = Pattern.compile("<DeployMap>(.*)</DeployMap>", 2);
        this.m_DeployFile = deployFile;
        if (this.m_RepositoryMapping == null || this.m_RepositoryMapping.size() == 0) {
            if (this.m_RepositoryMapping == null) {
                this.m_RepositoryMapping = new HashMap();
            }
            this.getRepositoryIDFromDeployFile(true);
            if (this.m_RepositoryMapping.size() == 0) {
                MessageUtil.printMessage(bundle.getString("DeployMetadata.Warning.NoReposMapping.txt"), 2);
                this.m_bAutoMapFailed = true;
                return;
            }
        } else if (!this.setTargetRepositoryID()) {
            this.m_bAutoMapFailed = true;
        }
        StringBuffer xmlBuffer = new StringBuffer(inputXML.length());
        int count = 0;
        Matcher m = deployMapPattern.matcher(inputXML);
        while (m.find()) {
            String modifiedDeployMap = this.parseDeployMap(state);
            if (modifiedDeployMap.indexOf(36) > -1) {
                modifiedDeployMap = MetadataUtility.removeDollarSignsFromString(modifiedDeployMap);
            }
            m.appendReplacement(xmlBuffer, modifiedDeployMap);
            ++count;
        }
        m.appendTail(xmlBuffer);
        this.m_ModifiedDeployXML = this.replaceRepositoryID(xmlBuffer.toString());
        if (!this.m_bAutoMapFailed && state != 0 && !DeployMetadata.isQuiet()) {
            String deploy_xml = this.m_ModifiedDeployXML;
            if (DeployMetadata.isEncodingPasswords()) {
                deploy_xml = this.handlePasswords(deploy_xml, true);
            }
            DeployFile df = new DeployFile(this.m_DeployFile.getName(), deploy_xml);
            df.createDeployFile();
            df.writeToFile();
        }
    }

    public void autoMap(File inputFile, File deployFile, int state) throws DeploymentException, IOException {
        String xml = DeployMetadata.getFileContents(inputFile);
        this.autoMap(xml, deployFile, state);
    }

    public void mapRepositories(String repos) {
        StringTokenizer st = new StringTokenizer(repos, ",");
        this.m_RepositoryMapping = new HashMap(st.countTokens());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf("=");
            if (index <= -1) continue;
            String source = token.substring(0, index).trim();
            String target = token.substring(index + 1, token.length()).trim();
            this.m_RepositoryMapping.put(source, target);
        }
    }

    public void mapRepositories(Map reposMap) {
        this.m_RepositoryMapping = reposMap;
    }

    public void createReport() {
        this.createReport("deployment_report.html");
    }

    public void createReport(String fileName) {
        if (this.m_DeployedXML != null) {
            Report rep = new Report(fileName, this.m_DeployedXML);
            rep.writeToFile();
        }
    }

    public Map getDeployedObjects() {
        DeployOutputParser parser = new DeployOutputParser();
        try {
            parser.parse(this.m_DeployedXML);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return parser.getDeployedObjectsMap();
    }

    private String parseDeployMap(int automap_state) throws DeploymentException {
        String returnXML = "";
        Document doc = this.getDeployDocument();
        if (doc != null) {
            Node node = doc.getFirstChild();
            if (automap_state == 0) {
                return MetadataUtility.createXMLStringForNode(node);
            }
            NodeList deployList = doc.getElementsByTagName("DeployMap");
            for (int k = 0; k < deployList.getLength(); ++k) {
                Node n = deployList.item(k);
                NodeList myNodeList = n.getChildNodes();
                int length = myNodeList.getLength();
                for (int i = 0; i < length; ++i) {
                    Node childNode = myNodeList.item(i);
                    if (childNode.getNodeType() != 1 || !childNode.getNodeName().equalsIgnoreCase("ReposMap") && !childNode.getNodeName().equalsIgnoreCase("Connections")) continue;
                    NodeList childList = childNode.getChildNodes();
                    int len = childList.getLength();
                    for (int j = 0; j < len; ++j) {
                        Node grandChild = childList.item(j);
                        NamedNodeMap nodeMap = grandChild.getAttributes();
                        if (nodeMap == null) continue;
                        if (automap_state == 1) {
                            this.autoMapNode(grandChild, nodeMap, childNode.getNodeName());
                            continue;
                        }
                        if (automap_state != 2 || nodeMap.getNamedItem("Deploy_Id") == null || nodeMap.getNamedItem("Deploy_Id").getNodeValue().length() != 0) continue;
                        this.autoMapNode(grandChild, nodeMap, childNode.getNodeName());
                    }
                }
            }
            returnXML = MetadataUtility.createXMLStringForNode(node);
            if (DeployMetadata.isEncodingPasswords()) {
                return this.handlePasswords(returnXML, false);
            }
        }
        return returnXML;
    }

    private String handlePasswords(String inputString, boolean encode) {
        String pass = "Password=\"";
        StringBuffer sb = new StringBuffer(inputString);
        int index = -1;
        int startIndex = 0;
        while ((index = sb.indexOf("Password=\"", startIndex)) > -1) {
            int passStart = index + 10;
            int passEnd = sb.indexOf("\"", passStart);
            String password = sb.substring(passStart, passEnd);
            if (password.length() > 0) {
                String pwd = null;
                if (encode && !password.startsWith("{sas001")) {
                    try {
                        pwd = SasPasswordString.encode((String)"sas001", (String)password);
                    }
                    catch (SasPasswordEncodingException e) {
                        MessageUtil.printStackTrace(e);
                    }
                } else if (!encode && password.startsWith("{sas001")) {
                    try {
                        pwd = SasPasswordString.decode((String)password);
                        pwd = MetadataUtility.cleanStringForXML(pwd);
                    }
                    catch (SasPasswordEncodingException e) {
                        MessageUtil.printStackTrace(e);
                    }
                }
                if (pwd != null) {
                    sb.replace(passStart, passEnd, pwd);
                }
                pwd = null;
            }
            index = -1;
            startIndex = passStart;
            password = null;
        }
        return sb.toString();
    }

    private void autoMapNode(Node node, NamedNodeMap nodeMap, String parentNode) throws DeploymentException {
        String sourceID = null;
        String serverXML = "";
        if (parentNode.equalsIgnoreCase("ReposMap")) {
            sourceID = nodeMap.getNamedItem("Id").getNodeValue();
            if (this.m_RepositoryMapping.containsKey(sourceID)) {
                return;
            }
            String search = nodeMap.getNamedItem("Search") != null && nodeMap.getNamedItem("Search").getNodeValue() != null ? nodeMap.getNamedItem("Search").getNodeValue() : nodeMap.getNamedItem("Name").getNodeValue();
            serverXML = MetadataUtility.getRepositories(this._factory, search, false);
            if (serverXML.length() <= 10) {
                MessageUtil.printMessage(bundle.getString("DeployMetadata.Warning.NoObjects.txt"), 1);
                return;
            }
            this.setDeployAttributes(node, serverXML);
            if (sourceID != null) {
                this.m_RepositoryMapping.put(sourceID, node.getAttributes().getNamedItem("Deploy_Id").getNodeValue());
            }
        } else if (parentNode.equalsIgnoreCase("Connections")) {
            String search;
            Node action = nodeMap.getNamedItem("Deploy_Action");
            if (action != null && action.getNodeValue().equalsIgnoreCase("Ignore")) {
                return;
            }
            String id = nodeMap.getNamedItem("Id").getNodeValue();
            String sourceRepos = "A0000001." + id.substring(0, id.indexOf(46));
            String targetRepos = (String)this.m_RepositoryMapping.get(sourceRepos);
            if (targetRepos == null) {
                String msg = bundle.getString("DeployMetadata.Warning.NoReposMapping.txt");
                MessageUtil.printMessage(msg, 2);
                this.m_bAutoMapFailed = true;
                throw new DeploymentException(msg);
            }
            String type = node.getNodeName();
            serverXML = MetadataUtility.getMetadataObjects(this._factory, type, search = nodeMap.getNamedItem("Search").getNodeValue(), targetRepos);
            if (serverXML.length() <= 10 && nodeMap.getNamedItem("ConnectionAction") != null) {
                if (nodeMap.getNamedItem("ConnectionMessage") == null || nodeMap.getNamedItem("ConnectionMessage").getNodeValue().length() == 0) {
                    DeployMetadata.checkConnectionAction(nodeMap.getNamedItem("ConnectionAction").getNodeValue(), bundle.messageString("DeployMetadata.Connection.Default.txt", (Object)type));
                } else {
                    DeployMetadata.checkConnectionAction(nodeMap.getNamedItem("ConnectionAction").getNodeValue(), nodeMap.getNamedItem("ConnectionMessage").getNodeValue());
                }
            }
            this.setDeployAttributes(node, serverXML);
        }
    }

    private Node setDeployAttributes(Node node, String xml) {
        Matcher m = attributesPattern.matcher(xml);
        int count = 0;
        while (m.find()) {
            if (count > 0) {
                MessageUtil.printMessage(bundle.messageString("DeployMetadata.Warning.ConnectionPoints.txt", (Object)node.getNodeName()), 1);
                break;
            }
            if (node.getNodeType() == 1) {
                ((Element)node).setAttribute("Deploy_Id", m.group(1));
                ((Element)node).setAttribute("Deploy_Name", m.group(2));
            }
            ++count;
        }
        return node;
    }

    private String replaceRepositoryID(String input) {
        Matcher m = reposIDPattern.matcher(input);
        StringBuffer sb = new StringBuffer(input.length());
        while (m.find()) {
            String oldReposID = m.group(2);
            String newReposID = (String)this.m_RepositoryMapping.get(oldReposID);
            if (newReposID == null) continue;
            StringBuffer replacement = new StringBuffer();
            replacement.append("<ToReposId>");
            replacement.append(newReposID);
            replacement.append("</ToReposId>");
            m.appendReplacement(sb, replacement.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String updateRepositoryIDinExtractFile(String input) {
        int startIndex = input.lastIndexOf("<DeployMap>");
        if (startIndex > -1) {
            int index = -1;
            while ((index = input.indexOf("<RepositoryBase", startIndex)) > -1) {
                String s;
                int reposIndex;
                int end = input.indexOf("/>", index);
                String repos = input.substring(index, end);
                String sourceReposID = null;
                int sourceStart = repos.indexOf(" Id=\"") + 5;
                if (sourceStart > -1) {
                    int sourceEnd = repos.indexOf(34, sourceStart);
                    sourceReposID = repos.substring(sourceStart, sourceEnd);
                }
                String targetReposID = null;
                int targetStart = repos.indexOf("Deploy_Id=\"") + 11;
                if (targetStart > -1) {
                    int targetEnd = repos.indexOf(34, targetStart);
                    targetReposID = repos.substring(targetStart, targetEnd);
                }
                if (targetReposID != null && targetReposID.length() > 0 && (reposIndex = input.lastIndexOf(s = "<ReposId>" + sourceReposID + "</ReposId>")) > -1) {
                    StringBuffer sb = new StringBuffer(input);
                    sb.delete(reposIndex, reposIndex + s.length());
                    String target = "<ToReposId>" + targetReposID + "</ToReposId>";
                    sb.insert(reposIndex, target);
                    this._repositoryIndex = reposIndex;
                    return sb.toString();
                }
                startIndex = end;
            }
        }
        return input;
    }

    private void validateRepositoryMap(DeploymentMapping mapping) throws DeploymentException {
        String reposPrefix = "A0000001.";
        Object[] keys = this.m_RepositoryMapping.keySet().toArray();
        int length = keys.length;
        for (int index = 0; index < length; ++index) {
            String source;
            String originalSource = source = (String)keys[index];
            String target = (String)this.m_RepositoryMapping.get(source);
            if (!source.startsWith("A0000001.")) {
                boolean reposFound = false;
                Map sourceReposMap = mapping.getSourceRepositoryMap();
                for (Map.Entry entry : sourceReposMap.entrySet()) {
                    String value = (String)entry.getValue();
                    if (!value.equals(source)) continue;
                    source = (String)entry.getKey();
                    reposFound = true;
                    break;
                }
                if (source == null || !reposFound) {
                    String msg = bundle.getString("AbstractDeployment.NoSourceRepos.txt");
                    MessageUtil.printMessage(msg, 2);
                    throw new IllegalStateException(msg);
                }
            }
            if (target.startsWith("A0000001.")) continue;
            String targetID = this.getTargetRepositoryInfo(target, false);
            this.m_RepositoryMapping.remove(originalSource);
            this.m_RepositoryMapping.put(source, targetID);
        }
    }

    private boolean setTargetRepositoryID() throws DeploymentException {
        String reposPrefix = "A0000001.";
        Document doc = this.getDeployDocument();
        if (doc == null) {
            return false;
        }
        for (String source : this.m_RepositoryMapping.keySet()) {
            NodeList list;
            String target = (String)this.m_RepositoryMapping.get(source);
            String targetName = null;
            if (!source.startsWith("A0000001.")) {
                list = doc.getElementsByTagName("RepositoryBase");
                boolean reposFound = false;
                for (int i = 0; i < list.getLength(); ++i) {
                    Node node = list.item(i);
                    NamedNodeMap map = node.getAttributes();
                    String sourceName = map.getNamedItem("Name").getNodeValue();
                    if (!sourceName.equals(source)) continue;
                    if (map.getNamedItem("Id") == null) {
                        MessageUtil.printMessage(bundle.getString("AbstractDeployment.NoReposId.txt"), 2);
                        return false;
                    }
                    source = map.getNamedItem("Id").getNodeValue();
                    reposFound = true;
                    break;
                }
                if (!reposFound) {
                    MessageUtil.printMessage(bundle.getString("AbstractDeployment.NoSourceRepos.txt"), 2);
                    return false;
                }
            }
            if (!target.startsWith("A0000001.")) {
                targetName = target;
                target = this.getTargetRepositoryInfo(target, false);
            } else {
                targetName = this.getTargetRepositoryInfo(target, true);
            }
            this.addRepositoryID(source, target);
            list = doc.getElementsByTagName("RepositoryBase");
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                NamedNodeMap map = node.getAttributes();
                String id = map.getNamedItem("Id").getNodeValue();
                if (!id.equals(source)) continue;
                ((Element)node).setAttribute("Deploy_Id", target);
                ((Element)node).setAttribute("Deploy_Name", targetName);
            }
        }
        return true;
    }

    private void getRepositoryIDFromDeployFile(boolean isDeployFileSeparate) throws DeploymentException {
        Document doc = null;
        if (isDeployFileSeparate) {
            if (this.m_DeployFile == null || !this.m_DeployFile.exists()) {
                MessageUtil.printMessage(bundle.getString("AbstractDeployment.NoDeployFile.txt"), 2);
                return;
            }
            doc = this.getDeployDocument();
        } else {
            doc = this.getDeployDocumentFromExtractFile();
        }
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("RepositoryBase");
            for (int i = 0; i < list.getLength(); ++i) {
                String targetName;
                String targetID;
                Node node = list.item(i);
                NamedNodeMap map = node.getAttributes();
                String sourceID = map.getNamedItem("Id").getNodeValue();
                String sourceName = map.getNamedItem("Name").getNodeValue();
                if (map.getNamedItem("Deploy_Id") != null && map.getNamedItem("Deploy_Id").getNodeValue().length() > 0) {
                    targetID = map.getNamedItem("Deploy_Id").getNodeValue();
                    targetName = this.getTargetRepositoryInfo(targetID, true);
                    if (targetName == null) {
                        return;
                    }
                    ((Element)node).setAttribute("Deploy_Name", targetName);
                } else if (map.getNamedItem("Deploy_Name") != null && map.getNamedItem("Deploy_Name").getNodeValue().length() > 0) {
                    targetName = map.getNamedItem("Deploy_Name").getNodeValue();
                    targetID = this.getTargetRepositoryInfo(targetName, false);
                    if (targetID == null) {
                        return;
                    }
                    ((Element)node).setAttribute("Deploy_Id", targetID);
                } else {
                    targetID = this.getTargetRepositoryInfo(sourceName, false);
                    if (targetID == null) {
                        return;
                    }
                    ((Element)node).setAttribute("Deploy_Id", targetID);
                    ((Element)node).setAttribute("Deploy_Name", sourceName);
                }
                this.addRepositoryID(sourceID, targetID);
            }
        }
    }

    public Document getDeployDocument() throws DeploymentException {
        if (this.m_DeployDoc == null) {
            if (this.m_DeployFile == null) {
                this.m_DeployDoc = this.getDeployDocumentFromExtractFile();
            } else {
                String name = this.m_DeployFile.getPath();
                DeployDocument deploy = new DeployDocument(name);
                this.m_DeployDoc = deploy.getDocument();
            }
        }
        return this.m_DeployDoc;
    }

    private Document getDeployDocumentFromExtractFile() throws DeploymentException {
        if (this.m_DeployDoc == null) {
            int startIndex = this.m_ExtractXML.indexOf("<DeployMap>");
            int endIndex = this.m_ExtractXML.indexOf("</DeployMap>", startIndex);
            if (startIndex > -1 && endIndex > startIndex) {
                String deployMapString = this.m_ExtractXML.substring(startIndex, endIndex + 12);
                try {
                    this.m_DeployDoc = this._factory.getOMIUtil().parseXML(deployMapString);
                }
                catch (Exception e) {
                    throw new DeploymentException(e);
                }
            }
        }
        return this.m_DeployDoc;
    }

    private void addRepositoryID(String sourceID, String targetID) {
        this.m_RepositoryMapping.put(sourceID, targetID);
    }

    private String transformExtractedXML(String input) {
        StringBuffer sb = new StringBuffer(input);
        int index = sb.indexOf("ExtractMetadata");
        if (index > -1) {
            sb.replace(index, index + "ExtractMetadata".length(), "DeployMetadata");
            int lastIndex = sb.lastIndexOf("ExtractMetadata");
            if (lastIndex > index) {
                sb.replace(lastIndex, lastIndex + "ExtractMetadata".length(), "DeployMetadata");
            }
        }
        if (this._removeSecurity) {
            this.addSecurityFlag(sb);
        }
        return sb.toString();
    }

    private void addSecurityFlag(StringBuffer sb) {
        int index = -1;
        if (this._repositoryIndex > -1) {
            index = sb.indexOf("<flags>", this._repositoryIndex);
        }
        if (index == -1) {
            index = sb.lastIndexOf("<flags>");
        }
        if (index > -1) {
            int startIndex = index + 7;
            int endIndex = sb.indexOf("</flags>", index);
            String s = sb.substring(startIndex, endIndex);
            try {
                int flags = Integer.parseInt(s);
                sb.replace(startIndex, endIndex, String.valueOf(flags |= 0x80000));
            }
            catch (NumberFormatException e) {
                return;
            }
        }
    }
}

