/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.BaseDeploymentObject;
import com.sas.management.deployment.DeploymentObject;
import java.util.ArrayList;
import java.util.List;

public class ConnectionPoint
extends BaseDeploymentObject {
    public static final char CONNECTION_FAILURE = 'F';
    public static final char CONNECTION_WARNING = 'W';
    public static final char CONNECTION_DEFAULT = 'D';
    private String _searchAttribute = null;
    private String _targetID = null;
    private List _associatedObjectsList = null;
    private String _connectionMessage = null;
    private char _connectionAction = (char)68;
    private boolean _active = true;
    private boolean _autoMapConnection = false;
    private boolean _reset = false;

    public ConnectionPoint(String objectType, String objectID, String objectName) {
        super(objectType, objectID, objectName);
    }

    public void setTargetObjectID(String id) {
        this._targetID = id;
    }

    public boolean hasConnectionBeenSet() {
        return this._targetID != null;
    }

    public void setSearchAttribute(String search) {
        this._searchAttribute = search;
    }

    public void addAssociatedObject(DeploymentObject obj) {
        this.addAssociatedObject(obj, true);
    }

    public void addAssociatedObject(DeploymentObject obj, boolean addOppositeSide) {
        if (this._associatedObjectsList == null) {
            this._associatedObjectsList = new ArrayList();
        }
        this._associatedObjectsList.add(obj);
        if (addOppositeSide) {
            obj.addConnectionPoint(this, false);
        }
    }

    public void addAssociatedObjects(List objects) {
        this.addAssociatedObjects(objects, true);
    }

    public void addAssociatedObjects(List objects, boolean addOppositeSide) {
        if (this._associatedObjectsList == null) {
            this._associatedObjectsList = new ArrayList(objects.size());
        }
        this._associatedObjectsList.addAll(objects);
        if (addOppositeSide) {
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                DeploymentObject obj = (DeploymentObject)objects.get(i);
                obj.addConnectionPoint(this, false);
            }
        }
    }

    public void setConnectionMessage(String message) {
        this._connectionMessage = message;
    }

    public void setConnectionAction(char action) {
        if (action != 'F' && action != 'W' && action != 'D') {
            action = (char)68;
        }
        this._connectionAction = action;
    }

    public String getSearchAttribute() {
        return this._searchAttribute;
    }

    public List getAssociatedObjects() {
        return this._associatedObjectsList;
    }

    public String getConnectionMessage() {
        return this._connectionMessage;
    }

    public char getConnectionAction() {
        return this._connectionAction;
    }

    public String getTargetObjectID() {
        return this._targetID;
    }

    public boolean isActiveConnectionForImportItem(String logicalObjectID) {
        if (this._active && this._associatedObjectsList != null) {
            for (DeploymentObject deployObj : this._associatedObjectsList) {
                if (!deployObj.getObjectID().equals(logicalObjectID)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isActiveConnectionForImportType(String logicalType) {
        if (this._active && this._associatedObjectsList != null) {
            for (DeploymentObject deployObj : this._associatedObjectsList) {
                if (!deployObj.getLogicalObjectType().equals(logicalType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConnectionAutoMapped() {
        return this._autoMapConnection;
    }

    public boolean isSharedConnection() {
        return this._associatedObjectsList != null && this._associatedObjectsList.size() > 1;
    }

    public void setConnectionAutoMapped(boolean automap) {
        this._autoMapConnection = automap;
    }

    public boolean isActive() {
        return this._active;
    }

    public void setActive(boolean active) {
        this._active = active;
    }

    public void resetConnection(boolean reset) {
        this._reset = reset;
    }

    public boolean isResetConnection() {
        return this._reset;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ConnectionPoint (");
        sb.append(this.getType());
        sb.append("): Name=\"");
        sb.append(this.getName());
        sb.append("\", Id=\"");
        sb.append(this.getObjectID());
        sb.append("\"");
        return sb.toString();
    }
}

