/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.MessageUtil;
import com.sas.management.deployment.MetadataUtility;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MetadataResource;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.workspace.WorkspaceFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.NO_PERMISSION;

public abstract class AbstractDeployment {
    protected static MetadataResource bundle = new MetadataResource(AbstractDeployment.class);
    protected static final Pattern attributesPattern = Pattern.compile("Id=\"([0-9a-zA-Z.]+)\" Name=\"(.*)(?=\")");
    public static final String m_ResDirectory = bundle.getString("TemplateLocation.notrans");
    protected IOMI m_ConnectionHandle = null;
    protected static boolean m_Debug = false;
    protected static String m_FileLocation = "";
    protected static String m_LogFileName = "deployment_log.txt";
    protected static String m_InputFileName = null;
    protected static boolean m_appendToLog = false;
    protected static boolean m_quiet = false;
    protected static boolean m_encodePasswords = false;
    protected String m_User = null;
    protected String m_Password = null;
    protected String m_Host = null;
    protected String m_Port = null;
    protected WorkspaceFile m_WorkspaceFile = null;
    protected MdFactory _factory;
    protected int _rc = 0;

    public AbstractDeployment() throws MdException, RemoteException {
        this._factory = new MdFactoryImpl(false);
    }

    public AbstractDeployment(MdFactory factory) {
        this._factory = factory;
    }

    public MdFactory getFactory() {
        return this._factory;
    }

    public int getReturnCode() {
        return this._rc;
    }

    public MdOMRConnection getConnection() throws RemoteException {
        if (this._factory != null) {
            return this._factory.getConnection();
        }
        return null;
    }

    public IOMI getOMRConnection() throws RemoteException {
        return this._factory.getConnection().getCMRHandle();
    }

    public void setOMRConnection(IOMI connection) {
        this.m_ConnectionHandle = connection;
    }

    public void dispose() throws RemoteException {
        this.closeConnection();
    }

    protected void makeOMRConnection() throws DeploymentException, RemoteException {
        if (!this.verifyConnectionParams()) {
            String msg = bundle.getString("AbstractDeployment.InvalidConnectParameters.txt");
            throw new IllegalStateException(msg);
        }
        MdOMRConnection connection = this._factory.getConnection();
        if (connection.getCMRHandle() == null) {
            String errorMsg = null;
            try {
                connection.makeOMRConnection(this.m_Host, this.m_Port, this.m_User, this.m_Password);
            }
            catch (MdException e) {
                Throwable t = e.getCause();
                if (t != null) {
                    String ErrorType = e.getSASMessageSeverity();
                    if (ErrorType != null) {
                        String ErrorMsg = e.getSASMessage();
                        errorMsg = ErrorType + ": " + ErrorMsg;
                    }
                    errorMsg = t instanceof COMM_FAILURE ? bundle.getString("AbstractDeployment.ConnectError.txt") : (t instanceof NumberFormatException ? bundle.getString("AbstractDeployment.InvalidServerPort.txt") : (t instanceof NO_PERMISSION ? bundle.getString("AbstractDeployment.LoginError.txt") : (t instanceof INV_OBJREF ? bundle.getString("AbstractDeployment.InvalidServerError.txt") : bundle.getString("AbstractDeployment.UnknownConnectError.txt"))));
                } else {
                    errorMsg = bundle.getString("AbstractDeployment.UnknownConnectError.txt");
                }
                MessageUtil.printStackTrace(e);
                throw new DeploymentException(errorMsg, e);
            }
            catch (RemoteException re) {
                errorMsg = bundle.getString("AbstractDeployment.UnknownConnectError.txt");
                MessageUtil.printStackTrace(re);
                throw new DeploymentException(errorMsg, re);
            }
            finally {
                this.m_Password = null;
            }
        }
    }

    private boolean verifyConnectionParams() {
        if (this.m_WorkspaceFile == null) {
            if (this.m_Host == null || this.m_Port == null || this.m_User == null || this.m_Password == null) {
                return false;
            }
            this.m_Password = this.getEncodedPassword(this.m_Password);
        } else {
            this.m_Host = this.m_WorkspaceFile.getPropertyString("host");
            this.m_Port = this.m_WorkspaceFile.getPropertyString("port");
            this.m_User = this.m_WorkspaceFile.getPropertyString("userid");
            try {
                this.m_Password = SasPasswordString.encode((String)"sas001", (String)this._factory.getUtil().decrypt(this.m_WorkspaceFile.getPropertyString("password")));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not encrypt password. Cause: " + e.getMessage());
            }
        }
        return true;
    }

    protected void closeConnection() throws RemoteException {
        MdOMRConnection connection = this._factory.getConnection();
        if (connection != null) {
            connection.closeOMRConnection();
        }
    }

    public static String getFileContents(String fileName) throws IOException {
        File inputFile = new File(fileName);
        return AbstractDeployment.getFileContents(inputFile);
    }

    public static String getFileContents(File inputFile) throws IOException {
        try {
            String in;
            StringBuffer text = new StringBuffer(new Long(inputFile.length()).intValue());
            FileInputStream fs = new FileInputStream(inputFile);
            InputStreamReader ir = new InputStreamReader((InputStream)fs, "UTF-8");
            BufferedReader br = new BufferedReader(ir);
            while ((in = br.readLine()) != null) {
                if (in.length() > 0 && (in.charAt(0) == '\ufeff' || in.charAt(0) == '\ufffe')) {
                    in = in.substring(1);
                }
                text.append(in);
            }
            br.close();
            return text.toString();
        }
        catch (IOException e) {
            MessageUtil.printMessage(bundle.messageString("AbstractDeployment.FileNotFound.txt", (Object)inputFile.getName()), 2);
            MessageUtil.printStackTrace(e);
            throw e;
        }
    }

    protected void writeToFile(String fileName, String text) throws IOException {
        try {
            FileOutputStream fs = new FileOutputStream(m_FileLocation.length() > 0 ? m_FileLocation + fileName : fileName);
            OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fs, "UTF-8");
            BufferedWriter bw = new BufferedWriter(ow);
            bw.write(text);
            bw.close();
            bw = null;
            ow = null;
            fs = null;
        }
        catch (IOException e) {
            MessageUtil.printMessage(bundle.messageString("AbstractDeployment.WriteError.IncludeFilename.txt", (Object)fileName), 1);
            throw e;
        }
    }

    protected String getTargetRepositoryInfo(String reposInfo, boolean searchForName) throws DeploymentException {
        String targetRepos = null;
        String serverXML = MetadataUtility.getRepositories(this._factory, reposInfo, searchForName);
        Matcher m = attributesPattern.matcher(serverXML);
        int count = 0;
        while (m.find()) {
            if (count > 0) {
                MessageUtil.printMessage(bundle.messageString("AbstractDeployment.Warning.MultipleRepositories.txt", (Object)reposInfo), 1);
                break;
            }
            targetRepos = searchForName ? m.group(2) : m.group(1);
            ++count;
        }
        if (count == 0) {
            MessageUtil.printMessage(bundle.messageString("AbstractDeployment.Warning.TargetReposNotFound.txt", (Object)reposInfo), 2);
            return null;
        }
        return targetRepos;
    }

    protected static void checkConnectionAction(String connectAction, String connectMessage) throws DeploymentException {
        String msg = "";
        if (connectAction.length() > 0) {
            char action = connectAction.charAt(0);
            if (Character.isUpperCase(action)) {
                action = Character.toLowerCase(action);
            }
            if (connectMessage == null) {
                connectMessage = "";
            }
            if (connectMessage.startsWith("SAS_")) {
                msg = bundle.getRawString(connectMessage = connectMessage.substring(4));
                if (msg == null) {
                    msg = connectMessage;
                }
            } else {
                msg = connectMessage;
            }
            switch (action) {
                case 'f': {
                    MessageUtil.printMessage(msg, 2);
                    throw new DeploymentException(bundle.getString("AbstractDeployment.ConnectionPointFailure.txt"));
                }
                case 'w': {
                    MessageUtil.printMessage(msg, 1);
                    break;
                }
            }
        }
    }

    private static void setOutputStream() throws FileNotFoundException {
        if (!AbstractDeployment.isQuiet()) {
            try {
                FileOutputStream logFile = new FileOutputStream(m_FileLocation + m_LogFileName, m_appendToLog);
                MessageUtil.setOutputStream(logFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public static void setDebug(boolean debug) {
        m_Debug = debug;
    }

    public static boolean getDebug() {
        return m_Debug;
    }

    public static void setLogFileName(String fileName) throws FileNotFoundException {
        if (fileName != null) {
            m_LogFileName = fileName;
        }
        AbstractDeployment.setOutputStream();
    }

    public static String getLogFileName() {
        return m_LogFileName;
    }

    public static void setFileLocation(String location) {
        String file_separator = File.separator;
        if (location != null && location.length() > 0 && !location.endsWith(file_separator)) {
            location = location + file_separator;
        }
        m_FileLocation = location;
    }

    public static String getFileLocation() {
        return m_FileLocation;
    }

    public static void setQuiet(boolean quiet) {
        m_quiet = quiet;
    }

    public static boolean isQuiet() {
        return m_quiet;
    }

    public static void appendToLogFile(boolean append) {
        m_appendToLog = append;
    }

    public static boolean isAppendToLogFile() {
        return m_appendToLog;
    }

    public static void setEncodePasswords(boolean encode) {
        m_encodePasswords = encode;
    }

    public static boolean isEncodingPasswords() {
        return m_encodePasswords;
    }

    private String getEncodedPassword(String password) {
        String encodedPassword = password;
        if (password != null && password.indexOf("{sas001}") == -1) {
            try {
                encodedPassword = SasPasswordString.encode((String)"sas001", (String)password);
            }
            catch (SasPasswordEncodingException e) {
                throw new IllegalStateException("Could not encrypt password. Cause: " + e.getMessage());
            }
        }
        return encodedPassword;
    }
}

