/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.templates;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.tools.generic.DateTool;
import org.apache.velocity.tools.generic.EscapeTool;

public class TemplateUtil {
    public static void mergeTemplate(File template, Map context, File destinationFile) {
        TemplateUtil.mergeTemplate(template, context, null, destinationFile);
    }

    public static void mergeTemplate(File template, Map context, File[] macroFiles, File destinationFile) {
        TemplateUtil.mergeTemplate(template, new Map[]{context}, macroFiles, destinationFile);
    }

    public static void mergeTemplate(File templateFile, File[] contextFiles, File destinationFile) {
        TemplateUtil.mergeTemplate(templateFile, contextFiles, null, destinationFile);
    }

    public static void mergeTemplate(File templateFile, File[] contextFiles, File[] macroFiles, File destinationFile) {
        TemplateUtil.mergeTemplate(templateFile, TemplateUtil.loadContextChain(contextFiles), macroFiles, destinationFile);
    }

    public static void mergeTemplate(File templateFile, Map[] contexts, File[] macroFiles, File destinationFile) {
        if (destinationFile == null) {
            System.out.println("No destination file specified. Aborting.");
            return;
        }
        if (destinationFile.exists() && destinationFile.isDirectory()) {
            System.out.println("You cannot specify a directory as the output css file.. Aborting.");
            return;
        }
        if (templateFile == null || !templateFile.exists() || contexts == null || contexts.length == 0) {
            System.out.println("Either template or contexts were not specified. Aborting.");
            return;
        }
        try {
            VelocityEngine velocity = new VelocityEngine();
            Properties velocityConfiguration = new Properties();
            velocityConfiguration.put("resource.loaders", "file");
            velocityConfiguration.put("resource.loader.file.description", "File Resource Loader");
            velocityConfiguration.put("resource.loader.file.path", "");
            velocityConfiguration.put("resource.loader.file.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
            velocityConfiguration.put("resource.loader.file.cache", "false");
            velocityConfiguration.put("resource.loader.file.modification_check_interval", "0");
            velocityConfiguration.put("introspector.conversion_handler.class", "none");
            velocityConfiguration.put("parser.space_gobbling", "bc");
            velocityConfiguration.put("directive.if.empty_check", "false");
            velocityConfiguration.put("parser.allow_hyphen_in_identifiers", "true");
            velocityConfiguration.put("velocimacro.enable_bc_mode", "true");
            velocityConfiguration.put("event_handler.invalid_references.quiet", "true");
            velocityConfiguration.put("event_handler.invalid_references.null", "true");
            velocityConfiguration.put("event_handler.invalid_references.tested", "true");
            velocity.init(velocityConfiguration);
            System.out.println("Resolving template[" + templateFile.getName() + "] to " + destinationFile.getName());
            VelocityContext velocityContext = null;
            for (int i = 0; i < contexts.length; ++i) {
                Map context = contexts[i];
                velocityContext = new VelocityContext(context, velocityContext);
            }
            if (velocityContext.get("datetool") == null) {
                velocityContext.put("datetool", (Object)new DateTool());
            }
            if (velocityContext.get("escapetool") == null) {
                velocityContext.put("escapetool", (Object)new EscapeTool());
            }
            if (!destinationFile.exists()) {
                File parentDir;
                if (destinationFile.getParent() != null && (parentDir = new File(destinationFile.getParent())) != null && !parentDir.exists()) {
                    parentDir.mkdirs();
                }
                destinationFile.createNewFile();
            }
            File templateFileWithMacros = TemplateUtil.createTemplateWithMacros(templateFile, macroFiles);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(destinationFile), "UTF-8");
            String templatePath = templateFileWithMacros == null ? templateFile.getCanonicalPath() : templateFileWithMacros.getCanonicalPath();
            Template t = velocity.getTemplate(templatePath);
            t.merge((Context)velocityContext, (Writer)writer);
            writer.close();
            if (templateFileWithMacros != null && templateFileWithMacros != templateFile) {
                templateFileWithMacros.delete();
            }
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mergeTemplates(File[] templateFiles, Map context, File outputDir, String outputFileExtension) {
        TemplateUtil.mergeTemplates(templateFiles, context, null, outputDir, outputFileExtension);
    }

    public static void mergeTemplates(File[] templateFiles, Map context, File[] macroFiles, File outputDir, String outputFileExtension) {
        TemplateUtil.mergeTemplates(templateFiles, new Map[]{context}, macroFiles, outputDir, outputFileExtension);
    }

    public static void mergeTemplates(File[] templateFiles, File[] contextFiles, File outputDir, String outputFileExtension) {
        TemplateUtil.mergeTemplates(templateFiles, contextFiles, null, outputDir, outputFileExtension);
    }

    public static void mergeTemplates(File[] templateFiles, File[] contextFiles, File[] macroFiles, File outputDir, String outputFileExtension) {
        TemplateUtil.mergeTemplates(templateFiles, TemplateUtil.loadContextChain(contextFiles), macroFiles, outputDir, outputFileExtension);
    }

    public static void mergeTemplates(File[] templateFiles, Map[] contextChain, File outputDir, String outputFileExtension) {
        TemplateUtil.mergeTemplates(templateFiles, contextChain, null, outputDir, outputFileExtension);
    }

    public static void mergeTemplates(File[] templateFiles, Map[] contextChain, File[] macroFiles, File outputDir, String outputFileExtension) {
        if (templateFiles == null || templateFiles.length == 0 || contextChain == null || contextChain.length == 0) {
            System.out.println("Either templates or contexts were not specified. Aborting.");
            return;
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (outputFileExtension == null) {
            outputFileExtension = "resolved";
        }
        for (int i = 0; i < templateFiles.length; ++i) {
            int extensionDotPosition;
            File templateFile = templateFiles[i];
            String templateExtension = TemplateUtil.getFileExtension(templateFile);
            String destinationFileName = null;
            if (templateExtension != null && (extensionDotPosition = templateFile.getName().lastIndexOf("." + templateExtension)) != -1) {
                destinationFileName = templateFile.getName().substring(0, extensionDotPosition) + "." + outputFileExtension;
            }
            if (destinationFileName == null) {
                destinationFileName = templateFile.getName() + "." + outputFileExtension;
            }
            File destinationFile = new File(outputDir, destinationFileName);
            TemplateUtil.mergeTemplate(templateFile, contextChain, macroFiles, destinationFile);
        }
    }

    private static String getFileExtension(File file) {
        int dotPos = file.getName().lastIndexOf(".");
        if (dotPos != -1) {
            return file.getName().substring(dotPos + 1);
        }
        return null;
    }

    private static Map[] loadContextChain(File[] contextFiles) {
        Map[] contextChain = new HashMap[contextFiles.length];
        for (int i = 0; i < contextFiles.length; ++i) {
            File file = contextFiles[i];
            Map context = TemplateUtil.loadContext(file);
            if (context == null) {
                System.out.println("Warning: Error reading context " + file.getName());
            }
            contextChain[i] = context;
        }
        return contextChain;
    }

    private static Map loadContext(File file) {
        HashMap<Object, Object> contextMap = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream stream = new BufferedInputStream(fis);
            Properties props = new Properties();
            props.load(stream);
            contextMap = new HashMap<Object, Object>();
            contextMap.putAll(props);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contextMap;
    }

    private static File createTemplateWithMacros(File templateFile, File[] macroFiles) {
        if (macroFiles == null) {
            return templateFile;
        }
        File destinationFile = null;
        try {
            int c;
            destinationFile = new File(templateFile.getParentFile(), templateFile.getName() + ".temp");
            if (destinationFile.exists()) {
                destinationFile.delete();
            }
            destinationFile.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(destinationFile);
            SequenceInputStream s = new SequenceInputStream(new MacroEnumeration(templateFile, macroFiles));
            while ((c = s.read()) != -1) {
                outputStream.write(c);
            }
            s.close();
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return destinationFile;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            TemplateUtil.printUsagePattern();
            System.exit(1);
        }
        boolean rc = false;
        File destinationFile = new File(args[0]);
        File templateFile = new File(args[1]);
        if (!templateFile.exists()) {
            System.err.println("Error: Unable to locate template file (" + args[1] + ")");
            System.exit(2);
        }
        ArrayList<File> contextFilesList = new ArrayList<File>();
        ArrayList<File> macroFilesList = new ArrayList<File>();
        for (int i = 2; i < args.length; ++i) {
            File file = new File(args[i]);
            String fileExtension = file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(".") + 1);
            if (fileExtension.equalsIgnoreCase("vctxt")) {
                if (!file.exists()) {
                    System.err.println("Error: Unable to locate velocity context file (" + args[i] + ")");
                    System.exit(2);
                }
                contextFilesList.add(file);
                continue;
            }
            if (fileExtension.equalsIgnoreCase("vm")) {
                if (!file.exists()) {
                    System.err.println("Error: Unable to locate velocity macro file (" + args[i] + ")");
                    System.exit(2);
                }
                macroFilesList.add(file);
                continue;
            }
            System.err.println("Error: " + args[i] + " is not a valid velocity context or macro file.  These files must have .vctxt and .vm extensions.");
            System.exit(2);
        }
        if (contextFilesList.isEmpty()) {
            System.err.println("Error: No context files were specified.");
            System.err.println("");
            TemplateUtil.printUsagePattern();
            System.exit(2);
        }
        File[] macroFiles = null;
        if (!macroFilesList.isEmpty()) {
            macroFiles = macroFilesList.toArray(new File[0]);
        }
        TemplateUtil.mergeTemplate(templateFile, contextFilesList.toArray(new File[0]), macroFiles, destinationFile);
        if (destinationFile.exists()) {
            System.exit(0);
        } else {
            System.err.println("Error: Template was not created.");
            System.exit(3);
        }
    }

    public static void printUsagePattern() {
        System.err.println("java -jar sas.velocity.tools destination template context [context2 context3...] [macro1 macro2...]");
        System.err.println("");
        System.err.println("destination  - Specifies the file to write resolved template to.");
        System.err.println("template     - Specifies a valid velocity template file.");
        System.err.println("context(1-N) - Specifies a chain of velocity context files.");
        System.err.println("macro(1-N)   - Specifies a chain of velocimacro files. Macro files are optional.");
    }

    private static class MacroEnumeration
    implements Enumeration {
        File templateFile;
        File[] macros;
        int current = 0;

        MacroEnumeration(File templateFile, File[] macroFiles) {
            this.templateFile = templateFile;
            ArrayList<File> macroList = new ArrayList<File>();
            for (int i = macroFiles.length - 1; i >= 0; --i) {
                if (macroFiles[i].exists()) {
                    macroList.add(macroFiles[i]);
                    continue;
                }
                System.err.println("Unable to load macro file : " + macroFiles[i].getAbsolutePath());
            }
            macroList.add(templateFile);
            this.macros = macroList.toArray(new File[0]);
        }

        @Override
        public boolean hasMoreElements() {
            return this.current < this.macros.length;
        }

        public Object nextElement() {
            FileInputStream is = null;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more files.");
            }
            try {
                File nextElement = this.macros[this.current];
                ++this.current;
                is = new FileInputStream(nextElement);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            return is;
        }
    }
}

