/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.templates;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.zip.ZipFile;

public final class FileUtil {
    public static final int COPY_BUFFER_SIZE = 8192;

    private FileUtil() {
        throw new UnsupportedOperationException();
    }

    public static void close(InputStream s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void close(ZipFile s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static File canonical(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    static File toFile(URL u) {
        if (u == null) {
            return null;
        }
        if (!"file".equals(u.getProtocol())) {
            return null;
        }
        String path = u.getPath();
        int p = path.indexOf(37);
        if (p >= 0) {
            StringBuffer b = new StringBuffer(path.length());
            if (p > 0) {
                b.append(path.substring(0, p));
            }
            int n = path.length();
            for (int i = p; i < n; ++i) {
                int y;
                int x;
                char c1;
                char c = path.charAt(i);
                if (c != '%' || i + 2 >= n) {
                    b.append(c);
                    continue;
                }
                if ((c1 = path.charAt(++i)) >= 'a' && c1 <= 'f') {
                    x = c1 - 97 + 10;
                } else if (c1 >= '0' && c1 <= 'F') {
                    x = c1 - 48;
                } else {
                    b.append('%');
                    b.append(c1);
                    continue;
                }
                char c2 = path.charAt(++i);
                if (c2 >= 'a' && c2 <= 'f') {
                    y = c2 - 97 + 10;
                } else if (c2 >= '0' && c2 <= 'F') {
                    y = c2 - 48;
                } else {
                    b.append('%');
                    b.append(c1);
                    b.append(c2);
                    continue;
                }
                b.append((char)((x << 4) + y & 0xFF));
            }
            path = b.toString();
        }
        return new File(path);
    }

    public static void concatenateFiles(File file1, File file2, File destinationFile) {
        try {
            if (destinationFile.exists()) {
                System.out.println("Destination file already exists. aborting.");
            } else {
                int c;
                destinationFile.createNewFile();
                FileOutputStream outputStream = new FileOutputStream(destinationFile);
                SequenceInputStream s = new SequenceInputStream(new FileInputStream(file1), new FileInputStream(file2));
                while ((c = s.read()) != -1) {
                    outputStream.write(c);
                }
                s.close();
                outputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static long copy(InputStream s, OutputStream o, byte[] buffer) throws IOException {
        int n;
        long total = 0L;
        if (buffer == null || buffer.length < 1024) {
            buffer = new byte[8192];
        }
        while ((n = s.read(buffer)) >= 0) {
            o.write(buffer, 0, n);
            total += (long)n;
        }
        return total;
    }

    static IllegalArgumentException illegalNegative(String paramName, long value) {
        return new IllegalArgumentException(MessageFormat.format("{0} must not be negative: {1}", paramName, new Long(value)));
    }

    static IllegalArgumentException illegalArgument(String paramName, Object value) {
        return new IllegalArgumentException(MessageFormat.format("{0}: {1}", paramName, value));
    }

    static IllegalArgumentException illegalNull(String paramName) {
        return new IllegalArgumentException(MessageFormat.format("{0} must not be null", paramName));
    }

    public static boolean delContents(File dir) {
        File f;
        int i;
        if (dir == null) {
            throw FileUtil.illegalNull("dir");
        }
        if (!dir.isDirectory()) {
            if (!dir.exists()) {
                return true;
            }
            throw new IllegalArgumentException(dir + " is not a dir");
        }
        File[] files = dir.listFiles();
        if (files == null || files.length <= 0) {
            return true;
        }
        boolean anyDir = false;
        for (i = 0; i < files.length; ++i) {
            f = files[i];
            if (f.isDirectory()) {
                anyDir = true;
                continue;
            }
            files[i] = null;
            if (FileUtil.delete(f)) continue;
            return false;
        }
        if (anyDir) {
            for (i = 0; i < files.length; ++i) {
                f = files[i];
                if (f == null) continue;
                if (!FileUtil.delContents(f)) {
                    return false;
                }
                if (FileUtil.delete(f)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean delete(File f) {
        if (f == null) {
            throw FileUtil.illegalNull("f");
        }
        if (f.delete()) {
            return true;
        }
        return f.exists();
    }

    public static boolean deleteAny(File f) {
        if (f == null) {
            throw FileUtil.illegalNull("f");
        }
        if (f.delete()) {
            return true;
        }
        if (!f.exists()) {
            return true;
        }
        if (!f.isDirectory()) {
            return false;
        }
        FileUtil.delContents(f);
        FileUtil.delete(f);
        return !f.exists();
    }

    public static void copy(File source, File destination, boolean keepTimestamps) {
        if (source.isDirectory()) {
            if (!destination.isDirectory()) {
                throw new IllegalArgumentException("Destination '" + destination.getName() + "' is not directory.");
            }
            FileUtil.copyDirectory(source, destination, keepTimestamps);
        } else {
            if (destination.isDirectory()) {
                destination = new File(destination, source.getName());
            }
            FileUtil.copyFile(source, destination, keepTimestamps);
        }
    }

    public static void copy(File source, File destination) {
        if (source.isDirectory()) {
            if (!destination.isDirectory()) {
                throw new IllegalArgumentException("Destination '" + destination.getName() + "' is not directory.");
            }
            FileUtil.copyDirectory(source, destination, false);
        } else {
            if (destination.isDirectory()) {
                destination = new File(destination, source.getName());
            }
            FileUtil.copyFile(source, destination, false);
        }
    }

    protected static void copyDirectory(File source, File destination, boolean keepTimestamps) {
        File[] list = source.listFiles();
        for (int i = 0; i < list.length; ++i) {
            File dest = new File(destination, list[i].getName());
            if (list[i].isDirectory()) {
                dest.mkdir();
                FileUtil.copyDirectory(list[i], dest, keepTimestamps);
                if (!keepTimestamps) continue;
                dest.setLastModified(source.lastModified());
                continue;
            }
            FileUtil.copyFile(list[i], dest, keepTimestamps);
        }
    }

    protected static void copyFile(File source, File destination, boolean keepTimestamp) {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            int len;
            inStream = new FileInputStream(source);
            outStream = new FileOutputStream(destination);
            byte[] buf = new byte[2048];
            while ((len = inStream.read(buf)) != -1) {
                outStream.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Can't copy file " + source + " -> " + destination + ".");
            iae.initCause(e);
            throw iae;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (keepTimestamp) {
                destination.setLastModified(source.lastModified());
            }
        }
    }
}

