/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.perf;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.EntityRef;
import org.jdom2.JDOMFactory;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import org.jdom2.UncheckedJDOMFactory;
import org.jdom2.contrib.perf.DevNull;
import org.jdom2.contrib.perf.PerfTest;
import org.jdom2.contrib.perf.TimeRunnable;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.input.DOMBuilder;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.StAXEventBuilder;
import org.jdom2.input.StAXStreamBuilder;
import org.jdom2.input.sax.SAXHandler;
import org.jdom2.internal.ArrayCopy;
import org.jdom2.output.Format;
import org.jdom2.output.SAXOutputter;
import org.jdom2.output.XMLOutputter;
import org.jdom2.util.IteratorIterable;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfDoc {
    private static final DevNull devnull = new DevNull();
    private final File infile;
    private long saxTime = -1L;
    private long domTime = -1L;
    private long staxTime = -1L;
    private long staxETime = -1L;
    private long saxDTime = -1L;
    private long domDTime = -1L;
    private long staxDTime = -1L;
    private long staxDETime = -1L;
    private long loadMem = -1L;
    private long dumpTime = -1L;
    private long xpathTime = -1L;
    private long dupeTime = -1L;
    private long scanTime = -1L;
    private long checkedTime = -1L;
    private long uncheckedTime = -1L;
    private Document document = null;
    private final char[] chars;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerfDoc(File file) throws IOException {
        this.infile = file;
        char[] fchars = new char[(int)this.infile.length()];
        int len = 0;
        int cnt = 0;
        FileReader fr = null;
        try {
            fr = new FileReader(this.infile);
            while ((cnt = fr.read(fchars, len, fchars.length - len)) >= 0) {
                if (cnt == 0 && len == fchars.length) {
                    fchars = ArrayCopy.copyOf((char[])fchars, (int)(fchars.length + 10240));
                }
                len += cnt;
            }
            fchars = ArrayCopy.copyOf((char[])fchars, (int)len);
        }
        finally {
            if (fr != null) {
                fr.close();
            }
            fr = null;
        }
        this.chars = fchars;
    }

    public File getFile() {
        return this.infile;
    }

    public long saxLoad() throws Exception {
        long startmem = PerfTest.usedMem();
        this.saxTime = PerfTest.timeRun(new SAXLoadRunnable(0));
        this.loadMem = PerfTest.usedMem() - startmem;
        this.saxDTime = PerfTest.timeRun(new SAXLoadRunnable(8));
        return this.saxTime;
    }

    public long domLoad() throws Exception {
        this.domTime = PerfTest.timeRun(new SAXLoadRunnable(1));
        this.domDTime = PerfTest.timeRun(new SAXLoadRunnable(9));
        return this.domTime;
    }

    public long staxLoad() throws Exception {
        this.staxTime = PerfTest.timeRun(new SAXLoadRunnable(2));
        this.staxDTime = PerfTest.timeRun(new SAXLoadRunnable(10));
        return this.staxTime;
    }

    public long staxELoad() throws Exception {
        this.staxETime = PerfTest.timeRun(new SAXLoadRunnable(3));
        this.staxDETime = PerfTest.timeRun(new SAXLoadRunnable(11));
        return this.staxETime;
    }

    public Document subload(int type) throws Exception {
        CharArrayReader car = new CharArrayReader(this.chars);
        switch (type) {
            case 0: {
                SAXBuilder sax = new SAXBuilder();
                sax.setJDOMFactory((JDOMFactory)new UncheckedJDOMFactory());
                return sax.build((Reader)car);
            }
            case 1: {
                DOMBuilder dom = new DOMBuilder();
                dom.setFactory((JDOMFactory)new UncheckedJDOMFactory());
                InputSource source = new InputSource(car);
                return dom.build(PerfDoc.getDocument(source, false));
            }
            case 2: {
                StAXStreamBuilder stax = new StAXStreamBuilder();
                stax.setFactory((JDOMFactory)new UncheckedJDOMFactory());
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(car);
                return stax.build(reader);
            }
            case 3: {
                StAXEventBuilder staxe = new StAXEventBuilder();
                staxe.setFactory((JDOMFactory)new UncheckedJDOMFactory());
                XMLEventReader events = XMLInputFactory.newInstance().createXMLEventReader(car);
                return staxe.build(events);
            }
            case 8: {
                SAXBuilder dsax = new SAXBuilder();
                DefaultHandler2 def = new DefaultHandler2();
                XMLReader sread = dsax.getXMLReaderFactory().createXMLReader();
                sread.setContentHandler(def);
                sread.setDTDHandler(def);
                sread.setEntityResolver(def);
                sread.setErrorHandler(def);
                sread.setProperty("http://xml.org/sax/properties/lexical-handler", def);
                sread.parse(new InputSource(car));
                return null;
            }
            case 9: {
                InputSource dsource = new InputSource(car);
                PerfDoc.getDocument(dsource, false);
                return null;
            }
            case 10: {
                XMLStreamReader dreader = XMLInputFactory.newInstance().createXMLStreamReader(car);
                int sum = 0;
                while (dreader.hasNext()) {
                    sum += dreader.next();
                }
                System.out.println("Sum " + sum);
                return null;
            }
            case 11: {
                XMLEventReader dereader = XMLInputFactory.newInstance().createXMLEventReader(car);
                int esum = 0;
                while (dereader.hasNext()) {
                    esum += dereader.nextEvent().getEventType();
                }
                System.out.println("Sum " + esum);
                return null;
            }
            case 12: {
                SAXBuilder slimsax = new SAXBuilder();
                return slimsax.build((Reader)car);
            }
        }
        return null;
    }

    public int recurse(Element emt) {
        int cnt = 1;
        for (Object kid : emt.getChildren()) {
            cnt += this.recurse((Element)kid);
        }
        return cnt;
    }

    public long scan() throws Exception {
        this.scanTime = PerfTest.timeRun(new TimeRunnable(){

            public void run() {
                int rcnt;
                int elements = 0;
                IteratorIterable it = PerfDoc.this.document.getDescendants();
                while (it.hasNext()) {
                    if (!(it.next() instanceof Element)) continue;
                    ++elements;
                }
                int felements = 0;
                IteratorIterable et = PerfDoc.this.document.getDescendants((Filter)new ElementFilter());
                while (et.hasNext()) {
                    et.next();
                    ++felements;
                }
                if (felements != elements) {
                    System.out.printf("Different counts Descendants=%d Elements=%d\n", elements, felements);
                }
                if ((rcnt = PerfDoc.this.recurse(PerfDoc.this.document.getRootElement())) != elements) {
                    System.out.printf("Different counts Descendants=%d Recurse=%d\n", elements, rcnt);
                }
            }
        });
        return this.scanTime;
    }

    public long dump() throws Exception {
        this.dumpTime = PerfTest.timeRun(new TimeRunnable(){

            public void run() throws Exception {
                long start = System.nanoTime();
                PerfDoc.this.dump(Format.getCompactFormat());
                long comp = System.nanoTime();
                PerfDoc.this.dump(Format.getPrettyFormat());
                long pretty = System.nanoTime();
                PerfDoc.this.dump(Format.getRawFormat());
                long raw = System.nanoTime();
                raw -= pretty;
                pretty -= comp;
                System.out.printf("Raw=%d Pretty=%8d Compact=%8d\n", raw, pretty, comp -= start);
            }
        });
        return this.dumpTime;
    }

    private void dump(Format format) throws IOException {
        XMLOutputter xout = new XMLOutputter(format);
        devnull.reset();
        System.setProperty("NamespaceStack", "");
        xout.output(this.document, (Writer)devnull);
        System.clearProperty("NamespaceStack");
        if (devnull.getCounter() <= 0) {
            throw new IllegalStateException("Needed a counter");
        }
    }

    public long xpath() throws Exception {
        final XPathFactory fac = XPathFactory.instance();
        this.xpathTime = PerfTest.timeRun(new TimeRunnable(){

            public void run() throws Exception {
                XPathExpression patha = fac.compile("//@null");
                patha.evaluate((Object)PerfDoc.this.document);
                XPathExpression pathb = fac.compile("//node()");
                pathb.evaluate((Object)PerfDoc.this.document);
            }
        });
        return this.xpathTime;
    }

    private Collection<Content> duplicateContent(List<? extends Content> content) {
        ArrayList<Content> ret = new ArrayList<Content>(content.size());
        for (Content content2 : content) {
            if (content2 instanceof Element) {
                Element emt = (Element)content2;
                Element ne = new Element(emt.getName(), emt.getNamespacePrefix(), emt.getNamespaceURI());
                if (emt.hasAttributes()) {
                    for (Object oatt : emt.getAttributes()) {
                        Attribute att = (Attribute)oatt;
                        Attribute a = new Attribute(att.getName(), att.getValue(), att.getAttributeType(), Namespace.getNamespace((String)att.getNamespacePrefix(), (String)att.getNamespaceURI()));
                        emt.setAttribute(a);
                    }
                }
                if (emt.hasAdditionalNamespaces()) {
                    for (Object ns : emt.getAdditionalNamespaces()) {
                        ne.addNamespaceDeclaration((Namespace)ns);
                    }
                }
                ne.addContent(this.duplicateContent(emt.getContent()));
                ret.add((Content)ne);
                continue;
            }
            if (content2 instanceof CDATA) {
                ret.add((Content)new CDATA(((CDATA)content2).getText()));
                continue;
            }
            if (content2 instanceof Comment) {
                ret.add((Content)new Comment(((Comment)content2).getText()));
                continue;
            }
            if (content2 instanceof EntityRef) {
                EntityRef er = (EntityRef)content2;
                ret.add((Content)new EntityRef(er.getName(), er.getPublicID(), er.getSystemID()));
                continue;
            }
            if (content2 instanceof Text) {
                ret.add((Content)new Text(((Text)content2).getText()));
                continue;
            }
            if (content2 instanceof ProcessingInstruction) {
                ProcessingInstruction pi = (ProcessingInstruction)content2;
                ret.add((Content)new ProcessingInstruction(pi.getTarget(), pi.getData()));
                continue;
            }
            if (content2 instanceof DocType) {
                DocType dt = (DocType)content2;
                DocType ndt = new DocType(dt.getElementName(), dt.getPublicID(), dt.getSystemID());
                if (dt.getInternalSubset() != null) {
                    ndt.setInternalSubset(dt.getInternalSubset());
                }
                ret.add((Content)ndt);
                continue;
            }
            throw new IllegalStateException("Unknown content " + content2);
        }
        return ret;
    }

    public long duplicate() throws Exception {
        final XMLOutputter xout = new XMLOutputter(Format.getRawFormat());
        final String orig = xout.outputString(this.document);
        this.dupeTime = PerfTest.timeRun(new TimeRunnable(){

            public void run() throws Exception {
                Document doc = new Document();
                doc.addContent(PerfDoc.this.duplicateContent(PerfDoc.this.document.getContent()));
                String dupe = xout.outputString(doc);
                if (!orig.equals(dupe)) {
                    throw new IllegalStateException("Bad clone!");
                }
            }
        });
        return this.dupeTime;
    }

    public long checkedParse() throws Exception {
        final XMLOutputter xout = new XMLOutputter(Format.getRawFormat());
        final String orig = xout.outputString(this.document);
        this.checkedTime = PerfTest.timeRun(new TimeRunnable(){

            public void run() throws Exception {
                SAXHandler handler = new SAXHandler((JDOMFactory)new DefaultJDOMFactory());
                SAXOutputter saxout = new SAXOutputter((ContentHandler)handler, (ErrorHandler)handler, (DTDHandler)handler, (EntityResolver)handler, (LexicalHandler)handler);
                saxout.output(PerfDoc.this.document);
                Document doc = handler.getDocument();
                String dupe = xout.outputString(doc);
                if (!orig.equals(dupe)) {
                    throw new IllegalStateException("Bad clone!");
                }
            }
        });
        return this.checkedTime;
    }

    public long unCheckedParse() throws Exception {
        final XMLOutputter xout = new XMLOutputter(Format.getRawFormat());
        final String orig = xout.outputString(this.document);
        this.uncheckedTime = PerfTest.timeRun(new TimeRunnable(){

            public void run() throws Exception {
                SAXHandler handler = new SAXHandler((JDOMFactory)new UncheckedJDOMFactory());
                SAXOutputter saxout = new SAXOutputter((ContentHandler)handler, (ErrorHandler)handler, (DTDHandler)handler, (EntityResolver)handler, (LexicalHandler)handler);
                saxout.output(PerfDoc.this.document);
                Document doc = handler.getDocument();
                String dupe = xout.outputString(doc);
                if (!orig.equals(dupe)) {
                    throw new IllegalStateException("Bad clone!");
                }
            }
        });
        return this.uncheckedTime;
    }

    public long getSAXLoadTime() {
        return this.saxTime;
    }

    public long getLoadMem() {
        return this.loadMem;
    }

    public long getDumpTime() {
        return this.dumpTime;
    }

    public long getDupeTime() {
        return this.dupeTime;
    }

    public long getXpathTime() {
        return this.xpathTime;
    }

    public long getCheckedTime() {
        return this.checkedTime;
    }

    public long getUncheckedTime() {
        return this.uncheckedTime;
    }

    public long getScanTime() {
        return this.scanTime;
    }

    public long getSaxDTime() {
        return this.saxDTime;
    }

    public long getDomDTime() {
        return this.domDTime;
    }

    public long getStaxDTime() {
        return this.staxDTime;
    }

    public long getStaxETime() {
        return this.staxETime;
    }

    public long getStaxDETime() {
        return this.staxDETime;
    }

    public Document getDocument() {
        return this.document;
    }

    public String toString() {
        return String.format("PerfDoc %s mem=%d sax=%d dom=%d stax=%d scan=%d xpath=%d dump=%d", this.infile.getPath(), this.loadMem, this.saxTime, this.domTime, this.staxTime, this.scanTime, this.xpathTime, this.dumpTime);
    }

    private static final org.w3c.dom.Document getDocument(InputSource data, boolean xsdvalidate) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(xsdvalidate);
        dbf.setExpandEntityReferences(false);
        if (xsdvalidate) {
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(data);
    }

    private class SAXLoadRunnable
    implements TimeRunnable {
        private final int type;

        SAXLoadRunnable(int type) {
            this.type = type;
        }

        public void run() throws Exception {
            Document doc = PerfDoc.this.subload(this.type);
            if (PerfDoc.this.document == null) {
                PerfDoc.this.document = doc;
            }
        }
    }
}

