/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.beans;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderSAX2Factory;
import org.jdom2.output.XMLOutputter;

public class JDOMBean {
    private static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";
    private String parser;
    private SAXBuilder builder;
    private Map<String, FileInfo> files = new HashMap<String, FileInfo>();

    public JDOMBean() {
        this.setParser(DEFAULT_PARSER);
    }

    public JDOMBean(String parser) {
        this.setParser(parser);
    }

    public void setParser(String parser) {
        this.parser = parser;
        XMLReaderSAX2Factory fac = new XMLReaderSAX2Factory(false, parser);
        this.builder = new SAXBuilder((XMLReaderJDOMFactory)fac);
    }

    public String getParser() {
        return this.parser;
    }

    public void setFileRoot(String root) {
    }

    public String getFileRoot() {
        return null;
    }

    public Document getDocument(String filename) throws JDOMException, IOException {
        FileInfo info = this.files.get(filename);
        File file = this.getFile(filename);
        if (info == null || info.modified < file.lastModified()) {
            Document doc = this.builder.build(file);
            info = new FileInfo(filename, file.lastModified(), doc);
            this.files.put(filename, info);
        }
        return info.document;
    }

    public Element getRootElement(String file) throws JDOMException, IOException {
        Document doc = this.getDocument(file);
        if (doc != null) {
            return doc.getRootElement();
        }
        return null;
    }

    private File getFile(String filename) {
        return new File(filename);
    }

    public static void main(String[] args) throws IOException, JDOMException {
        JDOMBean bean;
        int i = 0;
        if (args[i].equals("-parser")) {
            bean = new JDOMBean(args[++i]);
            ++i;
        } else {
            bean = new JDOMBean();
        }
        XMLOutputter out = new XMLOutputter();
        while (i < args.length) {
            Document doc = bean.getDocument(args[i]);
            out.output(doc, (OutputStream)System.out);
            System.out.println();
            ++i;
        }
    }

    class FileInfo {
        String name;
        long modified;
        Document document;

        public FileInfo(String name, long modified, Document document) {
            this.name = name;
            this.modified = modified;
            this.document = document;
        }
    }
}

