/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.beans;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DateUtils {
    public static boolean debug;
    protected static String reISO8601;

    public static Date parseDate(String s) {
        try {
            return new Date(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return DateFormat.getDateInstance().parse(s);
            }
            catch (ParseException parseException) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException numberFormatException) {
                    ISO8601 iso = DateUtils.parseISO8601(s);
                    if (iso != null) {
                        Calendar cal = Calendar.getInstance();
                        cal.set(1, iso.year);
                        cal.set(2, iso.month - 1);
                        cal.set(5, iso.day);
                        cal.set(10, iso.hour + 12);
                        cal.set(12, iso.min);
                        cal.set(13, iso.sec);
                        return cal.getTime();
                    }
                    return null;
                }
            }
        }
    }

    public static ISO8601 parseISO8601(String s) {
        try {
            Pattern pat = Pattern.compile(reISO8601);
            Matcher re = pat.matcher(s);
            if (re.matches()) {
                if (debug) {
                    DateUtils.showParens(re);
                }
                ISO8601 iso = new ISO8601();
                iso.year = DateUtils.toInt(re.group(1));
                iso.month = DateUtils.toInt(re.group(3));
                iso.day = DateUtils.toInt(re.group(5));
                iso.hour = DateUtils.toInt(re.group(7));
                iso.min = DateUtils.toInt(re.group(8));
                iso.sec = DateUtils.toInt(re.group(11));
                iso.frac = DateUtils.toInt(re.group(13));
                iso.tz = re.group(14);
                if (debug) {
                    System.out.println("year='" + iso.year + "'");
                    System.out.println("month='" + iso.month + "'");
                    System.out.println("day='" + iso.day + "'");
                    System.out.println("hour='" + iso.hour + "'");
                    System.out.println("min='" + iso.min + "'");
                    System.out.println("sec='" + iso.sec + "'");
                    System.out.println("frac='" + iso.frac + "'");
                    System.out.println("tz='" + iso.tz + "'");
                }
                return iso;
            }
        }
        catch (PatternSyntaxException ree) {
            ree.printStackTrace();
        }
        return null;
    }

    public static int toInt(String x) {
        if (x == null) {
            return 0;
        }
        try {
            return Integer.parseInt(x);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    static void showParens(Matcher r) {
        for (int i = 0; i < r.groupCount(); ++i) {
            System.out.println("$" + i + " = " + r.group(i));
        }
    }

    public static void main(String[] args) {
        debug = true;
        for (int i = 0; i < args.length; ++i) {
            System.out.println(DateUtils.parseDate(args[i]));
        }
    }

    static {
        reISO8601 = "(\\d\\d\\d\\d)(-(\\d\\d)(-(\\d\\d))?)?([T| ]?(\\d\\d):(\\d\\d)(:((\\d\\d)(\\.(\\d+))?)?)?(Z|([+-]\\d\\d:\\d\\d)|([A-Z]{3}))?)?";
    }

    public static class ISO8601 {
        public int year;
        public int month;
        public int day;
        public int hour;
        public int min;
        public int sec;
        public int frac;
        public String tz;
    }
}

