/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.GlobPattern;
import org.apache.jackrabbit.core.security.authorization.PrivilegeBits;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.core.security.principal.GroupPrincipals;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entry
implements AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger(Entry.class);
    private final String principalName;
    private final boolean isGroupEntry;
    private final PrivilegeBits privilegeBits;
    private final boolean isAllow;
    private final NodeId id;
    private final GlobPattern pattern;
    private final boolean hasRestrictions;
    private int hashCode;

    public Entry(NodeId id, String principalName, boolean isGroupEntry, PrivilegeBits privilegeBits, boolean allow, String path, Value globValue) throws RepositoryException {
        this.principalName = principalName;
        this.isGroupEntry = isGroupEntry;
        this.privilegeBits = privilegeBits;
        this.isAllow = allow;
        this.id = id;
        this.pattern = Entry.calculatePattern(path, globValue);
        this.hasRestrictions = globValue != null;
    }

    public static List<Entry> readEntries(NodeImpl aclNode, String path) throws RepositoryException {
        if (aclNode == null || !NT_REP_ACL.equals(aclNode.getPrimaryNodeTypeName())) {
            throw new IllegalArgumentException("Node must be of type 'rep:ACL'");
        }
        SessionImpl sImpl = (SessionImpl)aclNode.getSession();
        PrincipalManager principalMgr = sImpl.getPrincipalManager();
        PrivilegeManagerImpl privilegeMgr = (PrivilegeManagerImpl)((JackrabbitWorkspace)sImpl.getWorkspace()).getPrivilegeManager();
        NodeId nodeId = aclNode.getParentId();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        NodeIterator itr = aclNode.getNodes();
        while (itr.hasNext()) {
            NodeImpl aceNode = (NodeImpl)itr.nextNode();
            try {
                String principalName = aceNode.getProperty(P_PRINCIPAL_NAME).getString();
                boolean isGroupEntry = false;
                Principal princ = principalMgr.getPrincipal(principalName);
                if (princ != null) {
                    isGroupEntry = GroupPrincipals.isGroup(princ);
                }
                InternalValue[] privValues = aceNode.getProperty(P_PRIVILEGES).internalGetValues();
                Name[] privNames = new Name[privValues.length];
                for (int i = 0; i < privValues.length; ++i) {
                    privNames[i] = privValues[i].getName();
                }
                Value globValue = null;
                if (aceNode.hasProperty(P_GLOB)) {
                    globValue = aceNode.getProperty(P_GLOB).getValue();
                }
                boolean isAllow = NT_REP_GRANT_ACE.equals(aceNode.getPrimaryNodeTypeName());
                Entry ace = new Entry(nodeId, principalName, isGroupEntry, privilegeMgr.getBits(privNames), isAllow, path, globValue);
                entries.add(ace);
            }
            catch (RepositoryException e) {
                log.debug("Failed to build ACE from content. {}", (Object)e.getMessage());
            }
        }
        return entries;
    }

    private static GlobPattern calculatePattern(String path, Value globValue) throws RepositoryException {
        if (path == null) {
            return null;
        }
        if (globValue == null) {
            return GlobPattern.create(path);
        }
        return GlobPattern.create(path, globValue.getString());
    }

    boolean isLocal(NodeId nodeId) {
        return this.id != null && this.id.equals(nodeId);
    }

    boolean matches(String jcrPath) {
        return this.pattern != null && this.pattern.matches(jcrPath);
    }

    PrivilegeBits getPrivilegeBits() {
        return this.privilegeBits;
    }

    boolean isAllow() {
        return this.isAllow;
    }

    String getPrincipalName() {
        return this.principalName;
    }

    boolean isGroupEntry() {
        return this.isGroupEntry;
    }

    boolean hasRestrictions() {
        return this.hasRestrictions;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int h = 17;
            h = 37 * h + this.principalName.hashCode();
            h = 37 * h + this.privilegeBits.hashCode();
            h = 37 * h + Boolean.valueOf(this.isAllow).hashCode();
            this.hashCode = h = 37 * h + this.pattern.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Entry) {
            Entry other = (Entry)obj;
            return this.principalName.equals(other.principalName) && this.privilegeBits.equals(other.privilegeBits) && this.isAllow == other.isAllow && this.pattern.equals(other.pattern);
        }
        return false;
    }
}

